/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.communicate;

import JACE.ASX.MessageBlock;
import JACE.Concurrency.Mutex;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.communicate.TKCmdMSG;
import com.huawei.dc.toolkit.client.base.communicate.TKCmdMSGHeader;
import com.huawei.dc.toolkit.client.base.communicate.TKComm;
import com.huawei.dc.toolkit.client.base.communicate.TKCommandResult;
import com.huawei.dc.toolkit.client.base.communicate.TKLogContent;
import com.huawei.dc.toolkit.client.base.communicate.TKResponseReceiver;
import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKLogUtility;
import com.huawei.dc.toolkit.client.base.util.TKProfileFactory;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.te.toolkit.TKMainFrame;
import com.huawei.dc.toolkit.control.TKCommNotifier;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterface;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterfaceMgr;
import com.huawei.te.toolkit.AsnTkVersionCheckRsp;
import com.huawei.te.toolkit.FStruDecoderFixUTC;
import java.util.ArrayList;
import java.util.Calendar;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.FStruct;

public class TKCommUtility {
    public static final Calendar serverTime = Calendar.getInstance();
    public static TKComm comm = null;
    public static int refCount = 0;
    public static final String DEFAULT_IP = "127.0.0.1";
    public static final int DEFAULT_PORT = 8999;
    public static final int DEFAULT_SSL_PORT = 13006;
    private static String connectIP = "127.0.0.1";
    private static int connectPort = 8999;
    private static int startServMark = -1;
    private static boolean startServException = false;
    public static final String toServer = "send:";
    public static final String rspServer = "response:";
    public static final String evtServer = "report:";
    public static boolean isStartLocalServer = false;
    static Mutex logLockMutex = new Mutex();
    private static int connectServerID = 0;
    private static String usessl = "";
    public static boolean SSL_COMM = false;
    private static ArrayList connNotifierList = new ArrayList();

    public static synchronized void init() {
        TKLogUtility.init();
        if (comm != null) {
            ++refCount;
            return;
        }
        ArrayList<String> ipStrLst = Toolkit4T2kInterfaceMgr.getInstance().getTKServerNamelst();
        for (int i = 0; i < ipStrLst.size(); ++i) {
            try {
                Toolkit4T2kInterface inf;
                String ipStr = ipStrLst.get(i);
                if (ipStr.trim().equals("")) {
                    ipStr = DEFAULT_IP;
                }
                if ((inf = Toolkit4T2kInterfaceMgr.getInstance()) != null) {
                    String t2kIP = ipStr;
                    String defaultPortStr = TKProfileFactory.getCfgString("cfghost", "defaultPort");
                    String defaultSSLPortStr = TKProfileFactory.getCfgString("cfghost", "defaultSSLPort");
                    int defaultPort = Integer.parseInt(defaultPortStr);
                    int defaultSSLPort = Integer.parseInt(defaultSSLPortStr);
                    TKLogManager.writeToFile("TKCommUtility->107");
                    if (inf.getSSLMode() == 0) {
                        TKCommUtility.connect(t2kIP, defaultPort);
                    } else if (inf.getSSLMode() == 1) {
                        SSL_COMM = true;
                        TKCommUtility.connect(t2kIP, defaultSSLPort);
                        SSL_COMM = false;
                    } else if (inf.getSSLMode() == 2) {
                        TKCommUtility.connect(t2kIP, defaultPort);
                    }
                }
                if (!TKCommUtility.isConnected()) continue;
                Toolkit4T2kInterfaceMgr.getInstance().setServerIP(ipStr);
                break;
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
            }
        }
    }

    public static boolean connect(String ipStr, int port) {
        connectServerID = TKLogManager.getConnectServerLog(ipStr);
        try {
            if (TKMainFrame.instance != null) {
                TKMainFrame.instance.setStatusInfo1("Connecting to ToolKit Server:" + ipStr + ":" + port);
            }
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        boolean isSuccessConnect = false;
        try {
            isStartLocalServer = false;
            TKLogManager.writeToFile("Connecting to Toolkit Server:" + ipStr + "(" + port + ")");
            comm = new TKComm("TKCom", ipStr, port);
            comm.init(ipStr, port);
            for (int i = 0; i < 20; ++i) {
                Thread.sleep(1500L);
                byte cs = comm.getConnectState();
                byte reg = comm.getRegisterState();
                if (cs != 1 || reg != 1) continue;
                ++refCount;
                isSuccessConnect = true;
                break;
            }
            if (refCount < 1) {
                TKLogManager.writeToFile("Connecting to Toolkit Server " + ipStr + " Failed!");
                Toolkit4T2kInterface inf = Toolkit4T2kInterfaceMgr.getInstance();
                if (null != inf) {
                    comm.getConnector().addReConnectTimer();
                    TKLogManager.writeToFile("addReConnectTimer: comm");
                    return false;
                }
            } else {
                isSuccessConnect = true;
                TKLogManager.writeToFile("Connecting to Toolkit Server " + ipStr + " Successfully!");
            }
            if (isSuccessConnect) {
                TKProfileFactory.writeBackCommonStringProperty("tkconfig.ini", "option", "ip", "value", ipStr);
                String portStr = String.valueOf(port);
                TKProfileFactory.writeBackCommonStringProperty("tkconfig.ini", "option", "port", "value", portStr);
                usessl = SSL_COMM ? "true" : "false";
                TKProfileFactory.writeBackCommonStringProperty("tkconfig.ini", "option", "UseSSL", "value", usessl);
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        TKLogManager.ConnectID = comm.getConnectID();
        if (isSuccessConnect && null != TKMainFrame.instance) {
            TKMainFrame.instance.setStatusInfo1("ToolKit Server:" + ipStr + ":" + port + "-" + comm.getConnectID());
        }
        return isSuccessConnect;
    }

    public static boolean disconnect() {
        refCount = 0;
        boolean disconnect = false;
        TKLogManager.writeToDebug("Comm disconnencting.............");
        try {
            comm.close();
            Thread.sleep(4000L);
            byte con = comm.getConnectState();
            if (con == 0) {
                disconnect = true;
                comm.removeListeners();
                comm = null;
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        TKLogManager.writeToDebug("Comm disconnencted.");
        return disconnect;
    }

    public static void dispose() {
        if (comm == null || --refCount > 0) {
            return;
        }
        try {
            comm.close();
            comm.removeListeners();
            comm = null;
            if (Toolkit4T2kInterfaceMgr.getInstance() != null) {
                TKProfileFactory.writeBackCommonFile();
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    public static boolean getASNData(TKCmdMSG dataPackage, FStruct asnData) {
        if (dataPackage == null) {
            return false;
        }
        try {
            byte[] bytes = dataPackage.getContent();
            FStruDecoderFixUTC dec = new FStruDecoderFixUTC(bytes);
            asnData.deserialize((Decoder)dec);
            TKCommUtility.writeLog(dataPackage, asnData, 4, false);
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
            return false;
        }
        return true;
    }

    public static boolean getASNData(TKCmdMSG dataPackage, FStruct asnData, boolean isLog) {
        if (dataPackage == null) {
            return false;
        }
        try {
            byte[] bytes = dataPackage.getContent();
            FStruDecoderFixUTC dec = new FStruDecoderFixUTC(bytes);
            asnData.deserialize((Decoder)dec);
            if (isLog) {
                TKCommUtility.writeLog(dataPackage, asnData, 4, false);
            }
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
            return false;
        }
        return true;
    }

    private static void testAsnData(FStruct asnData) {
    }

    public static TKCommandResult sendCommand(FStruct req, FStruct rsp, char cmdCode, byte recvModule, int timeout) {
        TKCommandResult cr = new TKCommandResult();
        if (TKDebug.isDebugCmdCode(cmdCode)) {
            TKCommUtility.testAsnData(rsp);
            return cr;
        }
        if (!TKCommUtility.isConnected()) {
            cr.isSuccess = false;
            cr.rsultId = '\u0001';
            cr.resultInfo = TKResourceManager.getString("stringres.ini", "TKComm_Fail");
            if (comm != null) {
                TKLogManager.writeToDebug("ConnState:" + comm.getConnectState() + "\t" + comm.getRegisterState());
            }
        } else {
            TKCmdMSGHeader cmdMSGHead = new TKCmdMSGHeader();
            cmdMSGHead.cmdCode = cmdCode;
            cmdMSGHead.receiverModule = recvModule;
            TKCmdMSG data = comm.sendCommand(cmdMSGHead, req, null, timeout, cr);
            if (cr.isSuccess) {
                if (data != null) {
                    cr.serverDateTime = data.msgHead.dateTime;
                    if (!TKCommUtility.getASNData(data, rsp, false)) {
                        cr.rsultId = (char)3;
                        cr.isSuccess = false;
                        cr.resultInfo = TKResourceManager.getString("stringres.ini", "FailParseAsn");
                    } else {
                        TKCommUtility.writeLog(data, rsp, 2, false);
                    }
                } else {
                    cr.rsultId = (char)2;
                    cr.isSuccess = false;
                    cr.resultInfo = TKResourceManager.getString("stringres.ini", "TimeOut");
                }
            }
        }
        return cr;
    }

    public static char sendRequest(FStruct req, char cmdCode, byte recvModule, TKResponseReceiver responseReceiver, int timeout) {
        if (!TKCommUtility.isConnected()) {
            return '\u0000';
        }
        TKCmdMSGHeader cmdMSGHead = new TKCmdMSGHeader();
        cmdMSGHead.cmdCode = cmdCode;
        cmdMSGHead.receiverModule = recvModule;
        char code = comm.sendRequest(cmdMSGHead, req, responseReceiver, timeout);
        return code;
    }

    public static synchronized void writeLog(TKCmdMSG data, FStruct asn, int msgType, boolean isWriteCmd) {
        boolean isWriteLog = TKCommUtility.isWriteLog(data, msgType);
        if (!isWriteLog) {
            return;
        }
        TKLogContent msg = new TKLogContent();
        msg.ASN1Type = asn;
        String timeMillis = "0000" + System.currentTimeMillis();
        timeMillis = timeMillis.substring(timeMillis.length() - 3);
        String msgTypeDesc = "request";
        switch (msgType) {
            case 1: {
                msgTypeDesc = "request";
                break;
            }
            case 2: {
                msgTypeDesc = "response";
                break;
            }
            case 4: {
                msgTypeDesc = "report";
                break;
            }
        }
        msg.header.append("\n\n[" + TKDebug.toTimeString(Calendar.getInstance()) + "." + timeMillis + " " + connectServerID + "-" + data.msgHead.connectID + "." + "]" + msgTypeDesc + "\n" + data);
        MessageBlock mb = new MessageBlock((Object)msg);
        TKCommUtility.comm.logTask.put(mb, null);
    }

    private static boolean isWriteLog(TKCmdMSG data, int msgType) {
        if ("**3841*".indexOf(String.valueOf(data.msgHead.cmdCode)) >= 0) {
            return false;
        }
        String writeFlagStr = TKProfileFactory.getCfgString("log", "writeFlag");
        String modelIDStr = TKProfileFactory.getCfgString("log", "modelID");
        String messageTypeStr = TKProfileFactory.getCfgString("log", "messageType");
        int messageType = 0;
        try {
            messageType = Integer.parseInt(messageTypeStr);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        return writeFlagStr.equals("1") && modelIDStr.indexOf("*" + data.msgHead.receiverModule + "*") >= 0 && (messageType & msgType) > 0;
    }

    public static boolean isConnected() {
        if (comm == null) {
            return false;
        }
        byte cs = comm.getConnectState();
        byte reg = comm.getRegisterState();
        return cs == 1 && reg == 1;
    }

    public static void addCommunicationNotifier(TKCommNotifier notifier) {
        if (!connNotifierList.contains(notifier)) {
            connNotifierList.add(notifier);
        }
    }

    public static void removeCommunicationNotifier(TKCommNotifier notifier) {
        connNotifierList.remove(notifier);
    }

    protected static void notifyCommunication(boolean isConnected) {
        int notifierCount = connNotifierList.size();
        TKLogManager.writeToDebug("Notify Communication State:" + isConnected);
        for (int i = 0; i < notifierCount; ++i) {
            TKCommNotifier notifier = (TKCommNotifier)connNotifierList.get(i);
            if (notifier == null) continue;
            TKLogManager.writeToDebug("Communication Notifier:" + notifier.getClass());
            notifier.notifyCommunication(isConnected);
        }
    }

    public static String getServerVersion() {
        String hint = "";
        Toolkit4T2kInterface inf = Toolkit4T2kInterfaceMgr.getInstance();
        String clientVersion = "";
        try {
            clientVersion = TKProfileFactory.getBaseCfgString("option", "Version");
        }
        catch (Exception e) {
            TKLogManager.writeToDebug("get clientVersion is exception.");
            return "";
        }
        AsnTkVersionCheckRsp verRsp = new AsnTkVersionCheckRsp();
        char cmdCode = '\u011d';
        byte recvModule = 1;
        TKCommandResult ret = TKCommUtility.sendCommand(null, (FStruct)verRsp, cmdCode, recvModule, 30);
        if (!ret.isSuccess) {
            hint = inf != null ? TKRes.instance().getString("INT2000ServerVersion") : TKRes.instance().getString("DifferentVersion");
            TKLogManager.writeToDebug("AsnTkVersionCheckRsp is time out!");
            return hint;
        }
        if (verRsp.ret.isSuccess) {
            String serverVersion = new String(verRsp.version);
            TKLogManager.writeToDebug("The Client version :" + clientVersion);
            TKLogManager.writeToDebug("The Server version :" + serverVersion);
            if (!clientVersion.equals(serverVersion)) {
                hint = inf != null ? TKRes.instance().getString("INT2000ServerVersion") : TKRes.instance().getString("DifferentVersion") + TKRes.instance().getString("CLIENT") + clientVersion + TKRes.instance().getString("SERVER") + serverVersion;
                return hint;
            }
        }
        return hint;
    }

    public static void isTheSameVersion() {
        Toolkit4T2kInterface inf = Toolkit4T2kInterfaceMgr.getInstance();
        if (null != inf) {
            inf.isSameVersion();
        } else {
            TKMainFrame.instance.isSameVersion();
        }
    }
}

