/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.communicate;

import JACE.Concurrency.Mutex;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.communicate.TKCmdMSG;
import com.huawei.dc.toolkit.client.base.communicate.TKCmdMSGHeader;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKCommand;
import com.huawei.dc.toolkit.client.base.communicate.TKCommandResult;
import com.huawei.dc.toolkit.client.base.communicate.TKConnector;
import com.huawei.dc.toolkit.client.base.communicate.TKListener;
import com.huawei.dc.toolkit.client.base.communicate.TKLogTaskManager;
import com.huawei.dc.toolkit.client.base.communicate.TKNoticeReceiver;
import com.huawei.dc.toolkit.client.base.communicate.TKResponseReceiver;
import com.huawei.dc.toolkit.client.base.communicate.TKTaskManager;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import java.util.Hashtable;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruEncoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class TKComm
implements Runnable {
    private int defaultTimeout;
    private int miniumTimeout;
    private int threadNumber;
    private TKConnector connector;
    private TKTaskManager taskManager;
    protected TKLogTaskManager logTask;
    private String serverIP = "";
    private int serverPort = 0;
    private Mutex commandTableMutex;
    private Hashtable commandTable = new Hashtable();
    TKCommand sentCommand;

    public TKComm(String name, String hostIP, int hostPort) throws Exception {
        this(name, 4, hostIP, hostPort);
    }

    public TKComm(String name, int threadNumber, String hostIP, int hostPort) throws Exception {
        this.commandTableMutex = new Mutex();
        this.serverIP = hostIP;
        this.serverPort = hostPort;
        this.defaultTimeout = 60;
        this.miniumTimeout = 20;
        this.threadNumber = threadNumber;
        this.connector = new TKConnector(hostIP, hostPort);
        this.taskManager = new TKTaskManager(name, threadNumber);
        this.logTask = new TKLogTaskManager();
        if (this.connector == null || this.taskManager == null) {
            throw new Exception("TKComm construct fail");
        }
        this.taskManager.setConnector(this.connector);
        this.connector.setTaskManager(this.taskManager);
    }

    public TKConnector getConnector() {
        return this.connector;
    }

    public void init(String hostName, int hostPort) {
        this.init(hostName, hostPort, null);
    }

    public void init(String hostName, int hostPort, TKNoticeReceiver noticeHandler) {
        byte cs = this.getConnectState();
        byte reg = this.getRegisterState();
        if (cs == 1 && reg == 1) {
            TKLogManager.writeToDebug("TKCm aldy OK");
            return;
        }
        this.connector.reset(hostName, hostPort);
        this.taskManager.reset();
        this.logTask.reset();
        if (noticeHandler != null) {
            this.registerListener('\u0001', noticeHandler);
            this.registerListener('\u0002', noticeHandler);
            this.registerListener('\u0003', noticeHandler);
            this.registerListener('\u0004', noticeHandler);
            this.registerListener('\u0005', noticeHandler);
            this.registerListener('\u0006', noticeHandler);
        }
        new Thread(this).start();
    }

    @Override
    public void run() {
        this.connector.connect();
    }

    public String getServerAddress() {
        return this.serverIP;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public byte getConnectID() {
        return this.taskManager.getConnectID();
    }

    public byte getConnectState() {
        return this.connector.getConnectState();
    }

    public byte getRegisterState() {
        return this.taskManager.getRegisterState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelRequest(FStruct data) {
        try {
            this.commandTableMutex.acquire();
            TKCommand command = (TKCommand)this.commandTable.get(data);
            if (command != null) {
                TKCommand tKCommand = command;
                synchronized (tKCommand) {
                    command.messageInSignal = true;
                    command.isCanceled = true;
                    command.setData(null);
                    command.notifyAll();
                }
            }
            this.commandTable.remove(data);
            this.commandTableMutex.release();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelRequest() {
        if (this.sentCommand == null) {
            return false;
        }
        try {
            TKCommand tKCommand = this.sentCommand;
            synchronized (tKCommand) {
                this.sentCommand.messageInSignal = true;
                this.sentCommand.isCanceled = true;
                this.sentCommand.setData(null);
                this.sentCommand.notifyAll();
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public TKCmdMSG sendCommand(TKCmdMSGHeader msgHead, FStruct data, TKResponseReceiver responseReceiver, int timeout, TKCommandResult cr) {
        cr.isSuccess = true;
        if (this.getRegisterState() != 1) {
            TKLogManager.writeToDebug("TKComm.sendCommand: NOT REGISTERED");
            cr.resultInfo = TKResourceManager.getString("stringres.ini", "TKComm_Fail");
            TKLogManager.writeToFile("cr.resultInfo :" + cr.resultInfo);
            cr.isSuccess = false;
            return null;
        }
        TKCommand command = new TKCommand();
        command.message.msgHead = msgHead;
        command.message.msgHead.connectID = this.taskManager.getConnectID();
        command.message.msgHead.msgType = '\u0001';
        if (data != null) {
            try {
                FStruEncoder enc = new FStruEncoder();
                data.serialize((Encoder)enc);
                enc.finish();
                command.message.content = enc.toByteArray();
                command.message.msgHead.contentLength = command.message.content.length;
            }
            catch (Exception e) {
                cr.resultInfo = TKResourceManager.getString("stringres.ini", "FailParseAsn");
                cr.isSuccess = false;
                DCDebugTracer.trace(e);
                return null;
            }
        }
        if (responseReceiver != null) {
            command.responseReceiver = responseReceiver;
            command.setTaskState((byte)3);
        } else {
            command.setTaskState((byte)2);
        }
        try {
            this.commandTableMutex.acquire();
            if (data != null) {
                this.commandTable.put(data, command);
            }
            this.commandTableMutex.release();
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        this.sentCommand = command;
        this.taskManager.insertCommand(command);
        this.taskManager.addTimer(command, this.getTimeout(timeout));
        TKCommUtility.writeLog(command.message, data, 1, true);
        TKCmdMSG ret = this.taskManager.sendMessageAndWait(command);
        this.sentCommand = null;
        try {
            this.commandTableMutex.acquire();
            if (data != null) {
                this.commandTable.remove(data);
            }
            this.commandTableMutex.release();
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        if (ret == null) {
            cr.rsultId = (char)2;
            cr.isSuccess = false;
            if (command.isCanceled) {
                cr.resultInfo = "Request Canceled.....";
                cr.rsultId = (char)4;
            } else {
                cr.resultInfo = TKResourceManager.getString("stringres.ini", "TimeOut");
            }
        }
        return ret;
    }

    public char sendRequest(TKCmdMSGHeader msgHead, FStruct data, TKResponseReceiver responseReceiver, int timeout) {
        if (this.getRegisterState() != 1) {
            return '\u0000';
        }
        TKCommand command = new TKCommand();
        command.message.msgHead = msgHead;
        command.message.msgHead.connectID = this.taskManager.getConnectID();
        command.message.msgHead.msgType = '\u0001';
        if (data != null) {
            try {
                FStruEncoder enc = new FStruEncoder();
                data.serialize((Encoder)enc);
                enc.finish();
                command.message.content = enc.toByteArray();
                command.message.msgHead.contentLength = command.message.content.length;
            }
            catch (FStruException e) {
                DCDebugTracer.trace((Exception)((Object)e));
                return '\u0000';
            }
        }
        TKCommUtility.writeLog(command.message, data, 1, true);
        command.responseReceiver = responseReceiver;
        char sequenceID = this.taskManager.insertCommand(command);
        this.taskManager.addTimer(command, this.getTimeout(timeout));
        command.setTaskState((byte)1);
        this.taskManager.sendMessage(command);
        return sequenceID;
    }

    public void registerListener(char cmdCode, TKNoticeReceiver noticeHandler) {
        this.unregisterListener(cmdCode, noticeHandler);
        this.registerListener(cmdCode, noticeHandler, (byte)2);
    }

    public void registerListener(char cmdCode, TKNoticeReceiver noticeHandler, byte level) {
        TKListener listener = new TKListener();
        listener.noticeReceiver = noticeHandler;
        this.taskManager.insertListener(cmdCode, listener, level);
    }

    public void unregisterListener(char cmdCode, TKNoticeReceiver noticeHandler) {
        this.taskManager.removeListener(cmdCode, noticeHandler);
    }

    public void unregisterListener(TKNoticeReceiver noticeHandler) {
        this.taskManager.removeListener(noticeHandler);
    }

    public void removeListeners() {
        this.taskManager.removeListeners();
    }

    private int getTimeout(int timeout) {
        if (timeout < this.miniumTimeout) {
            return this.miniumTimeout;
        }
        return timeout;
    }

    public void close() {
        this.logTask.close(0L);
        this.taskManager.close(0L);
        this.connector.close(0L);
    }

    public void close(int i) {
        this.connector.close(1L);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

