/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.communicate;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.communicate.TKCmdMSGHeader;
import com.huawei.dc.toolkit.client.base.communicate.TKConvertByte;

public class TKCmdMSG
extends TKConvertByte {
    public TKCmdMSGHeader msgHead = new TKCmdMSGHeader();
    public byte[] content;

    public byte[] toByte() {
        byte[] data = new byte[24 + this.msgHead.contentLength];
        try {
            byte[] tmp = this.msgHead.toByte();
            System.arraycopy(tmp, 0, data, 0, 24);
            if (this.content != null && this.content.length > 0) {
                System.arraycopy(this.content, 0, data, 24, this.content.length);
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            return null;
        }
        return data;
    }

    public void fromByte(byte[] data) throws Exception {
        if (data.length < 24) {
            throw new Exception("invalid msg data");
        }
        this.msgHead.fromByte(data);
        if (data.length < 24 + this.msgHead.contentLength) {
            throw new Exception("invalid msg data");
        }
        if (this.msgHead.contentLength == 0) {
            this.content = null;
        } else {
            this.content = new byte[this.msgHead.contentLength];
            System.arraycopy(data, 24, this.content, 0, this.msgHead.contentLength);
        }
    }

    public byte[] getContent() {
        return this.content;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("msgHead pVer(");
        sb.append(this.msgHead.protocolVer);
        sb.append(") cID(");
        sb.append(this.msgHead.connectID);
        sb.append(") sM(");
        sb.append(this.msgHead.senderModule);
        sb.append(") rM(");
        sb.append(this.msgHead.receiverModule);
        sb.append(") cC(");
        sb.append((int)this.msgHead.cmdCode);
        sb.append(") mT(");
        sb.append((int)this.msgHead.msgType);
        sb.append(") sq(");
        sb.append((int)this.msgHead.sequence);
        sb.append(") rs(");
        sb.append((int)this.msgHead.reserved);
        sb.append(") cL(");
        sb.append(this.msgHead.contentLength);
        sb.append(") hl(");
        sb.append(24);
        sb.append(")");
        sb.append(" hc(" + this.hashCode() + ")");
        return sb.toString();
    }
}

