/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.viewtask;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.selectdevice.ViewSelecDevWithUpgradeType;
import com.huawei.dc.devicemanagement.deviceoperation.selectdevice.ViewSelectDevice;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.ITaskGroup;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.view.viewtask.SavePrintTaskReportUtil;
import com.huawei.dc.taskmgmt.view.viewtask.ViewBasePanel;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public class ViewTaskDialog
extends DCModalDialog {
    private ITask m_oTaskDataObj;
    private ResourceManager m_oResourceManager = ResourceManager.getInstance();
    private static final long serialVersionUID = 1L;
    private JTabbedPane m_oTabbedPane = new JTabbedPane();
    private ViewSelectDevice m_oViewSelectDevice;
    private SavePrintTaskReportUtil savePrintTaskReportUtil;
    private JRadioButton m_isOffLineRadioBtn;

    public ViewTaskDialog(ITask oTaskDataObj) throws DCException {
        this.m_oTaskDataObj = oTaskDataObj;
        this.m_oViewSelectDevice = this.getDeviceSelectionPanel(oTaskDataObj);
        this.initViewDialog();
        this.savePrintTaskReportUtil = new SavePrintTaskReportUtil(this, oTaskDataObj);
        if (4 != oTaskDataObj.getDeviceType().getDeviceDomain()) {
            this.initDialogButtons();
        }
        this.addCloseButton();
        this.initTabbedPane();
        this.m_isOffLineRadioBtn = new JRadioButton(ResourceManager.getInstance().getResString("CREATE_OFF_LINE_TASK_CHECK_BOX_TEXT"));
        this.m_isOffLineRadioBtn.setName("com.huawei.dc.taskmgmt.view.viewtask.ViewTaskDialog.m_isOffLineRadioBtn");
        this.m_isOffLineRadioBtn.setSelected(this.m_oTaskDataObj.getIsOffLineTask());
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_isOffLineRadioBtn);
        this.setBoundsForAllComponent();
        this.addOperationTabs();
        this.getContentPane().add(this.m_oTabbedPane);
        if (this.m_isOffLineRadioBtn.isSelected()) {
            this.getContentPane().add(this.m_isOffLineRadioBtn);
        }
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    private void setBoundsForAllComponent() {
        if (this.m_oTaskDataObj.getTaskTypeId() == 3 || this.m_oTaskDataObj.getTaskTypeId() == 5 || this.m_oTaskDataObj.getTaskTypeId() == 4 || this.m_oTaskDataObj.getTaskTypeId() == 12 || this.m_oTaskDataObj.getTaskTypeId() == 13) {
            this.m_oTabbedPane.setBounds(16, 12, 885, 385);
            if (this.m_isOffLineRadioBtn.isSelected()) {
                this.setBounds(100, 100, 923, 490);
                this.m_isOffLineRadioBtn.setBounds(12, 405, 540, 21);
                this.m_oCancelBtn.setBounds(822, 425, 80, 21);
            } else {
                this.setBounds(100, 100, 923, 480);
                this.m_oCancelBtn.setBounds(822, 412, 80, 21);
            }
        } else if (this.m_isOffLineRadioBtn.isSelected()) {
            this.setBounds(100, 100, 656, 575);
            this.m_oTabbedPane.setBounds(12, 42, 626, 438);
            this.m_isOffLineRadioBtn.setBounds(12, 487, 540, 21);
            this.m_oCancelBtn.setBounds(558, 512, 80, 21);
        } else {
            this.setBounds(100, 100, 656, 555);
            this.m_oTabbedPane.setBounds(12, 42, 626, 438);
            this.m_isOffLineRadioBtn.setBounds(12, 492, 400, 21);
            this.m_oCancelBtn.setBounds(558, 492, 80, 21);
        }
    }

    private ViewSelectDevice getDeviceSelectionPanel(ITask oTaskDataObj) {
        ViewSelectDevice oSelectDevice = null;
        if (null == oTaskDataObj.getTaskContentType()) {
            oSelectDevice = new ViewSelectDevice(oTaskDataObj);
            oSelectDevice.setName("TaskMgmt_ViewTaskDialog_oSelecdevice");
        } else {
            oSelectDevice = new ViewSelecDevWithUpgradeType(oTaskDataObj);
            oSelectDevice.setName("TaskMgmt_ViewTaskDialog_oSelecdevice");
        }
        return oSelectDevice;
    }

    private void addOperationTabs() {
        List<ITaskDeviceOperation> oTaskOpLst = this.m_oTaskDataObj.getSupportedOperation();
        boolean vari = false;
        int iSizeOfLst = oTaskOpLst.size();
        ITaskDeviceOperation oTaskdev = null;
        ViewBasePanel oViewBasePanel = null;
        this.m_oTabbedPane.addTab(this.m_oResourceManager.getResString("SELECTED_DEVICES"), null, this.m_oViewSelectDevice, null);
        for (int var = 0; var < iSizeOfLst; ++var) {
            oTaskdev = oTaskOpLst.get(var);
            vari = oTaskdev.isSelected();
            if (!oTaskdev.isSelected()) continue;
            oViewBasePanel = new ViewBasePanel(oTaskdev, var, this.m_oTaskDataObj);
            oViewBasePanel.setName("TaskMgmt_ViewTaskDialog_oViewBasePanel");
            if (!vari) continue;
            this.m_oTabbedPane.addTab(oTaskdev.getOperationName(), null, oViewBasePanel, null);
        }
    }

    private void initTabbedPane() {
        this.m_oTabbedPane.setTabLayoutPolicy(1);
        this.getContentPane().add(this.m_oTabbedPane);
    }

    private void initDialogButtons() {
        JButton saveBtn = new JButton();
        saveBtn.setName("TaskMgmt_ViewTaskDialog_saveBtn");
        saveBtn.setIcon(ResourceManager.getInstance().getImage("save.gif"));
        saveBtn.setToolTipText(this.m_oResourceManager.getResString("SAVE_REPORT"));
        ActionListener saveActionListener = this.createActionListener("save");
        saveBtn.addActionListener(saveActionListener);
        KeyStroke sKeyStroke = KeyStroke.getKeyStroke(83, 0);
        this.registerKeyBoardActionFor(sKeyStroke, saveActionListener);
        this.setButtonSize(saveBtn);
        JButton previewBtn = new JButton();
        previewBtn.setName("TaskMgmt_ViewTaskDialog_previewBtn");
        previewBtn.setToolTipText(this.m_oResourceManager.getResString("PREVIEW_REPORT"));
        previewBtn.setIcon(ResourceManager.getInstance().getImage("preview.gif"));
        ActionListener previewActionListener = this.createActionListener("preview");
        previewBtn.addActionListener(previewActionListener);
        KeyStroke vKeyStroke = KeyStroke.getKeyStroke(86, 0);
        this.registerKeyBoardActionFor(vKeyStroke, previewActionListener);
        this.setButtonSize(previewBtn);
        JButton printBtn = new JButton();
        printBtn.setName("TaskMgmt_ViewTaskDialog_printBtn");
        printBtn.setToolTipText(this.m_oResourceManager.getResString("PRINT_REPORT"));
        printBtn.setIcon(ResourceManager.getInstance().getImage("print.gif"));
        ActionListener printActionListener = this.createActionListener("print");
        printBtn.addActionListener(printActionListener);
        KeyStroke pKeyStroke = KeyStroke.getKeyStroke(80, 0);
        this.registerKeyBoardActionFor(pKeyStroke, printActionListener);
        this.setButtonSize(printBtn);
        JPanel l_buttonPnl = new JPanel();
        l_buttonPnl.setBounds(8, 10, 200, 25);
        FlowLayout l_flowLayout = new FlowLayout(0);
        l_flowLayout.setHgap(7);
        l_buttonPnl.setLayout(l_flowLayout);
        l_buttonPnl.add(saveBtn);
        l_buttonPnl.add(previewBtn);
        l_buttonPnl.add(printBtn);
        this.getContentPane().add(l_buttonPnl);
    }

    private void addCloseButton() {
        this.m_oCancelBtn.setText(this.m_oResourceManager.getResString("CLOSE"));
        this.m_oCancelBtn.setName("TaskMgmt_ViewTaskDialog_m_oCancelBtn");
        this.getContentPane().add(this.m_oCancelBtn);
    }

    public void setButtonSize(JButton button) {
        button.setMaximumSize(new Dimension(20, 20));
        button.setMinimumSize(new Dimension(20, 20));
        button.setPreferredSize(new Dimension(20, 20));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initViewDialog() {
        this.getContentPane().setLayout(null);
        String taskGroupName = "";
        ITaskGroup oTaskGroup = TaskDataModel.getInstance().getTaskGroupForTaskOperation(this.m_oTaskDataObj.getTaskTypeId());
        switch (this.m_oTaskDataObj.getTaskTypeId()) {
            case 4: {
                taskGroupName = this.m_oResourceManager.getResString("PACKAGE_UPDATE_TASK_GROUP");
                break;
            }
            case 13: {
                taskGroupName = this.m_oResourceManager.getResString("PACKAGE_DOWNGRADE_TASK_GROUP");
                break;
            }
            case 5: {
                taskGroupName = this.m_oResourceManager.getResString("PACKAGE_DIFFUSION_UPDATE_TASK_GROUP");
                break;
            }
            case 12: {
                taskGroupName = this.m_oResourceManager.getResString("PACKAGE_DIFFUSION_DOWNGRADE_TASK_GROUP");
                break;
            }
            case 0: {
                taskGroupName = this.m_oResourceManager.getResString("SOFTWARE_UPGRADE_TASK_GROUP2");
                break;
            }
            case 1: {
                taskGroupName = this.m_oResourceManager.getResString("SOFTWARE_DOWNGRADE_TASK_GROUP2");
                break;
            }
            default: {
                taskGroupName = oTaskGroup.getTaskGroupName();
            }
        }
        Object[] objArray = new Object[]{this.m_oResourceManager.getResString("VIEW_TASK_DIALOG_TITLE_PREFIX"), taskGroupName, this.m_oResourceManager.getResString("VIEW_TASK_DIALOG_TITLE_SUFFIX")};
        ViewTaskDialog viewTaskDialog = this;
        synchronized (viewTaskDialog) {
            String strTitle = MessageFormat.format(this.m_oResourceManager.getResString("VIEW_TASK_DIALOG_TITLE"), objArray);
            StringBuffer strBufferTitle = new StringBuffer(strTitle);
            strBufferTitle.append(" [");
            strBufferTitle.append(this.m_oTaskDataObj.getTaskName());
            strBufferTitle.append(']');
            this.setTitle(strBufferTitle.toString());
        }
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_ID_VIEW_TASK_DLG";
    }

    private ActionListener createActionListener(final String strMethodName) {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ViewTaskDialog.this.savePrintTaskReportUtil.getClass().getMethod(strMethodName, new Class[0]).invoke((Object)ViewTaskDialog.this.savePrintTaskReportUtil, new Object[0]);
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                }
            }
        };
        return actionListener;
    }

    private void registerKeyBoardActionFor(KeyStroke oKeyStroke, ActionListener oKeyHandler) {
        this.rootPane.registerKeyboardAction(oKeyHandler, oKeyStroke, 2);
    }

    @Override
    public void doCleanUp() {
        this.m_oTabbedPane.removeAll();
        this.m_oTaskDataObj = null;
        this.m_oResourceManager = null;
        this.m_oTabbedPane = null;
        this.m_oViewSelectDevice = null;
        this.savePrintTaskReportUtil = null;
        super.doCleanUp();
    }
}

