/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.viewtask;

import com.huawei.dc.adapter.swimap.iview.commstyle.resource.DCResourceMng;
import com.huawei.dc.adapter.swimap.iview.templates.print.DCPrintSupportor;
import com.huawei.dc.adapter.swimap.iview.templates.print.DCTablePrintable;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnTaskDevOpInfo;
import com.huawei.dc.common.asndatacenter.AsnTaskDevOpInfoLst;
import com.huawei.dc.common.asndatacenter.AsnTaskDevResult;
import com.huawei.dc.common.asndatacenter.AsnTaskDevResultLst;
import com.huawei.dc.common.asndatacenter.AsnTaskResultRsp;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCSaveFileChooser;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.ParaValue;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperation;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ContentConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.ICheckOperationConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.ICheckType;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.LoadSoftwareOperation;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.taskmgmt.controller.ITaskSyncCommController;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.ActiveBoardInfo;
import com.huawei.dc.taskmgmt.model.ActiveDevInfo;
import com.huawei.dc.taskmgmt.model.ActiveGroupInfo;
import com.huawei.dc.taskmgmt.model.ActiveInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.LoadSimPackageBoardInfo;
import com.huawei.dc.taskmgmt.model.LoadSimPackageDevInfo;
import com.huawei.dc.taskmgmt.model.LoadSimPackageFileInfo;
import com.huawei.dc.taskmgmt.model.LoadSimPackageInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.swimap.iview.templates.print.tools.TablePrintable;
import gnu.trove.THashSet;
import java.awt.Component;
import java.io.File;
import java.security.AccessController;
import java.text.Collator;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import sun.security.action.GetPropertyAction;

public class SavePrintTaskReportUtil {
    private String m_lineSeparator;
    private ITask m_task;
    private DCModalDialog m_parentDlg;
    private String[] m_taskReportTableHeader;
    private ResourceManager m_oResourceManager = ResourceManager.getInstance();
    private DCTablePrintable m_tablePrintable;
    ITaskSyncCommController oTaskController = TaskSyncCommController.getInstance();
    private String m_strTaskStartTime = "";
    private String m_strTaskEndTime = "";
    private int m_iDevCount = 0;
    private Vector m_tableDataVec = new Vector();
    private String m_strYes = "";
    private String m_strNo = "";
    private boolean m_isInitialize;
    private IDeviceInfoManager devInfoImpl;
    private boolean isSave = true;

    public SavePrintTaskReportUtil(DCModalDialog parentDlg, ITask task) {
        this.m_parentDlg = parentDlg;
        this.m_task = task;
        this.m_lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        this.m_taskReportTableHeader = new String[]{this.m_oResourceManager.getResString("TASK_REPORT_TABLE_OPERATION_NAME"), this.m_oResourceManager.getResString("TASK_REPORT_TABLE_RESOURCE_NAME"), this.m_oResourceManager.getResString("TASK_REPORT_TABLE_DEVICE_IP"), this.m_oResourceManager.getResString("TASK_REPORT_TABLE_START_TIME"), this.m_oResourceManager.getResString("TASK_REPORT_TABLE_END_TIME"), this.m_oResourceManager.getResString("TASK_REPORT_TABLE_CONFIG_ITEM"), this.m_oResourceManager.getResString("TASK_REPORT_TABLE_CONFIG_VALUE"), this.m_oResourceManager.getResString("TASK_REPORT_TABLE_IS_PAUSE"), this.m_oResourceManager.getResString("TASK_REPORT_TABLE_DEPEND_ON"), this.m_oResourceManager.getResString("TASK_REPORT_TABLE_RESULT")};
        this.m_strYes = this.m_oResourceManager.getResString("TASK_REPORT_TABLE_IS_PAUSE_YES");
        this.m_strNo = this.m_oResourceManager.getResString("TASK_REPORT_TABLE_IS_PAUSE_NO");
        this.m_isInitialize = true;
        this.devInfoImpl = DeviceInfoManagerImpl.getInstance();
    }

    private Resource[] getTaskResult() {
        AsnTaskResultRsp asnTaskResultRsp = new AsnTaskResultRsp();
        try {
            this.oTaskController.getTaskResultFrmServer(this.m_task.getTaskId(), asnTaskResultRsp);
            this.m_strTaskStartTime = this.convertTimeToString(asnTaskResultRsp.oTaskStartTime);
            this.m_strTaskEndTime = this.convertTimeToString(asnTaskResultRsp.oTaskEndTime);
            AsnTaskDevResultLst asnTaskResultLst = asnTaskResultRsp.oTaskDevResultLst;
            this.m_iDevCount = asnTaskResultLst.size();
            Resource[] res = new Resource[this.m_iDevCount];
            for (int i = 0; i < this.m_iDevCount; ++i) {
                AsnTaskDevResult asnDevResult = (AsnTaskDevResult)asnTaskResultLst.get(i);
                res[i] = new Resource();
                int iDevID = asnDevResult.oResourceInfo.iDeviceId.intValue();
                res[i].setDeviceID(iDevID);
                DeviceInfo devInfo = this.devInfoImpl.getDevice(iDevID);
                res[i].setDeviceName(devInfo.getDevName());
                res[i].setDeviceIP(devInfo.getDevIPAddress());
                if (null != asnDevResult.oResourceInfo.iFrameId) {
                    res[i].setFrameId(asnDevResult.oResourceInfo.iFrameId.intValue());
                }
                if (null != asnDevResult.oResourceInfo.iSlotId) {
                    res[i].setSlotId(asnDevResult.oResourceInfo.iSlotId.intValue());
                }
                if (null != asnDevResult.oResourceInfo.iSubSlotId) {
                    res[i].setSubSlotId(asnDevResult.oResourceInfo.iSubSlotId.intValue());
                }
                AsnTaskDevOpInfoLst asnOprInfoLst = asnDevResult.oTaskDevOpInfoLst;
                int iOprCount = asnOprInfoLst.size();
                for (int j = 0; j < iOprCount; ++j) {
                    AsnTaskDevOpInfo asnOprInfo = (AsnTaskDevOpInfo)asnOprInfoLst.get(j);
                    ResourceProgressInfo resInfo = new ResourceProgressInfo();
                    resInfo.setCurrentOperationId(new String(asnOprInfo.strOpId));
                    resInfo.setState(asnOprInfo.enOpStatus.value);
                    String strOprName = TaskCommUtil.getDisplayNameForOperation(this.m_task.getSelectedDeviceType(), resInfo.getCurrentOperationId());
                    resInfo.setCurrentOperationName(strOprName);
                    String strErrMsg = null;
                    if (null != asnOprInfo.stErrorInfo.strResult) {
                        strErrMsg = new String(asnOprInfo.stErrorInfo.strResult);
                    }
                    resInfo.setErrorInfo(asnOprInfo.stErrorInfo.iErrorNo.intValue(), strErrMsg);
                    resInfo.setFailureReason(new String(asnOprInfo.stErrorInfo.strResult));
                    resInfo.setStartTime(asnOprInfo.oOprStartTime);
                    resInfo.setEndTime(asnOprInfo.oOprEndTime);
                    res[i].addOprResultInfo(resInfo.getCurrentOperationId(), resInfo);
                }
            }
            return res;
        }
        catch (DCException ex) {
            DCDebugTracer.trace(ex);
            return null;
        }
    }

    private void constructTablePrintable(boolean isSave) {
        this.constructData();
        String strFileHeader = this.m_oResourceManager.getResString("TASK_REPORT_TASK_DETAILS");
        String strUserName = DCFrameWorkUtil.getUserName();
        this.m_tablePrintable = new DCTablePrintable(strFileHeader, strUserName, this.constructSummary(), this.m_taskReportTableHeader, this.m_tableDataVec, this.m_tableDataVec.size(), isSave);
    }

    public void save() {
        PrintSupportor.setIsFileSelection(false);
        String strPath = ConfigurationInfo.getInstance().getAbsoluteBaseDirectory() + File.separator + "report/";
        File fileDoc = new File(strPath);
        if (!fileDoc.exists()) {
            try {
                fileDoc.mkdir();
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
                return;
            }
        }
        DCSaveFileChooser oSaveFileChooserDlg = new DCSaveFileChooser(strPath, false);
        oSaveFileChooserDlg.setTitle(ResourceManager.getInstance().getResString("SAVE_REPORT"));
        oSaveFileChooserDlg.setFileFilter(7);
        oSaveFileChooserDlg.setAcceptAllFileFilterUsed(false);
        oSaveFileChooserDlg.setEncodingEnabled(true);
        int iReturnVal = -1;
        iReturnVal = oSaveFileChooserDlg.showSaveDialog((Component)((Object)this.m_parentDlg));
        if (iReturnVal == 0) {
            String strFileName = oSaveFileChooserDlg.getFullFileName();
            String strLowerFileName = strFileName.toLowerCase(DCResourceMng.getInstance().getLocale());
            boolean bSaveSuccess = false;
            if (strLowerFileName.endsWith(".html") || strLowerFileName.endsWith(".htm") || strLowerFileName.endsWith(".txt") || strLowerFileName.endsWith(".csv")) {
                bSaveSuccess = this.saveDataToFile(strFileName);
            } else {
                DCOptionPane.showMessageDialog((Component)((Object)this.m_parentDlg), this.m_oResourceManager.getResString("AUTO_UPGRADE_DEVICE_TABLE_FILE_TYPE_NOT_SUPP"), this.m_oResourceManager.getResString("ERROR_MESSAGE"), 0);
            }
            if (bSaveSuccess) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_SUCCESS"), ResourceManager.getInstance().getResString("INFO"), 1);
            } else {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_FAILURE"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
            }
        }
    }

    public void preview() {
        this.isSave = false;
        this.constructTablePrintable(this.isSave);
        DCPrintSupportor.preview((JFrame)DCFrameWorkUtil.getMainFrame(), (TablePrintable)this.m_tablePrintable, (int)this.m_tablePrintable.getPageCount());
    }

    public void print() {
        this.isSave = false;
        this.constructTablePrintable(this.isSave);
        DCPrintSupportor.print((JFrame)DCFrameWorkUtil.getMainFrame(), (TablePrintable)this.m_tablePrintable, (int)this.m_tablePrintable.getPageCount());
    }

    private boolean saveDataToFile(String strFileName) {
        try {
            String strFileType = null;
            String strLowerFileName = strFileName.toLowerCase(DCResourceMng.getInstance().getLocale());
            strFileType = strLowerFileName.endsWith(".html") || strLowerFileName.endsWith(".htm") ? "html" : (strLowerFileName.endsWith(".csv") ? "csv" : "txt");
            this.isSave = true;
            this.constructTablePrintable(this.isSave);
            String sysEncoding = DCSaveFileChooser.getSystemEncoding();
            if (null == sysEncoding) {
                sysEncoding = FileUtil.getSystemEncoding();
                DCSaveFileChooser.ENCODING_KEY_VALUE_MAP.put(sysEncoding, sysEncoding);
            }
            boolean bSaveSuccess = DCPrintSupportor.saveToFileNoCheck((JFrame)DCFrameWorkUtil.getMainFrame(), (String)strFileName, (TablePrintable)this.m_tablePrintable, (String)strFileType, (String)sysEncoding);
            return bSaveSuccess;
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            return false;
        }
    }

    private String constructSummary() {
        String strTaskType = "";
        switch (this.m_task.getTaskTypeId()) {
            case 0: {
                strTaskType = this.m_oResourceManager.getResString("SOFTWARE_UPGRADE_TASK_GROUP");
                break;
            }
            case 1: {
                strTaskType = this.m_oResourceManager.getResString("SOFTWARE_DOWNGRADE_TASK_GROUP");
                break;
            }
            case 2: {
                strTaskType = this.m_oResourceManager.getResString("PATCH_UPDATE_TASK_GROUP");
                break;
            }
            case 6: {
                strTaskType = this.m_oResourceManager.getResString("MXU_AUTOUPGRADE_TASK_GROUP");
                break;
            }
            case 3: {
                strTaskType = this.m_oResourceManager.getResString("MIMIC_PACKAGE_UPDATE_TASK_GROUP");
                break;
            }
            case 4: {
                strTaskType = this.m_oResourceManager.getResString("PACKAGE_UPDATE_TASK_GROUP");
                break;
            }
            case 5: {
                strTaskType = this.m_oResourceManager.getResString("PACKAGE_DIFFUSION_UPDATE_TASK_GROUP");
                break;
            }
            case 13: {
                strTaskType = this.m_oResourceManager.getResString("PACKAGE_DOWNGRADE_TASK_GROUP");
                break;
            }
            case 12: {
                strTaskType = this.m_oResourceManager.getResString("PACKAGE_DIFFUSION_DOWNGRADE_TASK_GROUP");
                break;
            }
            case 7: {
                strTaskType = this.m_oResourceManager.getResString("OLT_AGENTUPGRADE_TASK_GROUP");
                break;
            }
        }
        strTaskType = this.m_lineSeparator + this.m_oResourceManager.getResString("TASK_REPORT_TASK_TYPE") + strTaskType;
        String strTaskName = this.m_lineSeparator + this.m_oResourceManager.getResString("TASK_REPORT_TASK_NAME") + this.m_task.getTaskName();
        String strTaskStartTime = this.m_lineSeparator + this.m_oResourceManager.getResString("TASK_REPORT_START_TIME") + this.m_strTaskStartTime;
        String strTaskEndTime = this.m_lineSeparator + this.m_oResourceManager.getResString("TASK_REPORT_END_TIME") + this.m_strTaskEndTime;
        String strTargetVersion = this.m_lineSeparator + this.m_oResourceManager.getResString("TASK_REPORT_TARGET_VERSION") + this.m_task.getTargetVersion();
        DeviceType devType = this.m_task.getSelectedDeviceType();
        String strDeviceType = "";
        if (devType.getDeviceDomain() == 4) {
            strDeviceType = this.m_lineSeparator + this.m_oResourceManager.getResString("TASK_REPORT_DEVICE_TYPE") + devType.getDeviceTypeName();
        } else {
            String strDevTypeVersion = devType.getDeviceTypeVersionName();
            if (devType.getDeviceTypeVersionName().endsWith("_telnet")) {
                strDevTypeVersion = strDevTypeVersion.substring(0, devType.getDeviceTypeVersionName().length() - 7);
            }
            strDeviceType = this.m_lineSeparator + this.m_oResourceManager.getResString("TASK_REPORT_DEVICE_TYPE") + devType.getDeviceTypeName() + "(" + strDevTypeVersion + ")";
        }
        String strTotalDev = this.m_lineSeparator + this.m_oResourceManager.getResString("TASK_REPORT_TOTAL_DEVICE") + this.m_iDevCount;
        String strTaskResult = this.m_lineSeparator + this.m_oResourceManager.getResString("TASK_REPORT_TASK_RESULT") + this.m_task.getTaskProgressInfo().toString();
        String strSummary = strTaskType + strTaskName + strTaskStartTime + strTaskEndTime + strTargetVersion + strDeviceType + strTotalDev + strTaskResult;
        return strSummary;
    }

    private void constructData() {
        if (this.m_isInitialize) {
            Resource[] resInfos = this.getTaskResult();
            if (null == resInfos) {
                return;
            }
            List<ITaskDeviceOperation> devOprList = this.m_task.getSupportedOperation();
            int iOprCount = devOprList.size();
            for (int i = 0; i < iOprCount; ++i) {
                ITaskDeviceOperation devOpr = devOprList.get(i);
                if (null == devOpr || !devOpr.isSelected()) continue;
                Object oprParaObj = new Object();
                switch (devOpr.getOperationId()) {
                    case 4: 
                    case 16: {
                        oprParaObj = this.getCheckTypeInfo(devOpr.getConfiguredPara());
                        break;
                    }
                    case 1: 
                    case 2: {
                        oprParaObj = this.getContentConfigInfo(devOpr.getConfiguredPara());
                        break;
                    }
                    case 6: 
                    case 9: {
                        if (this.m_task.getTaskTypeId() == 3) {
                            DCDebugTracer.trace("m_task.getTaskTypeId() == ITaskGroup.MIMIC_PACKAGE_UPGRADE");
                            break;
                        }
                        oprParaObj = this.getLoadFilesInfo(devOpr.getConfiguredPara());
                        break;
                    }
                    case 7: {
                        oprParaObj = this.getDataFilesInfo(devOpr.getConfiguredPara());
                        break;
                    }
                    case 8: {
                        if (this.m_task.getTaskTypeId() == 3 || this.m_task.getTaskTypeId() == 5 && this.m_task.getUpgradeLevel() == 2) {
                            DCDebugTracer.trace("m_task.getTaskTypeId()==ITaskGroup.PACKAGE_DIFFUSION_UPGRADE && m_task.getUpgradeLevel() == Task.BOARD_LEVEL");
                            break;
                        }
                        oprParaObj = this.getActivationInfo(devOpr.getConfiguredPara());
                        break;
                    }
                }
                this.m_tableDataVec.addAll(this.constructOprInfo(devOpr, resInfos, oprParaObj));
            }
            this.m_isInitialize = !this.m_isInitialize;
        }
    }

    private Vector constructOprInfo(ITaskDeviceOperation devOpr, Resource[] res, Object oprParaObj) {
        Vector dataVec = new Vector();
        if (devOpr instanceof ActivationOperation && (this.m_task.getTaskTypeId() == 3 || this.m_task.getTaskTypeId() == 5 && this.m_task.getUpgradeLevel() == 2)) {
            dataVec = this.constructOprInfoForMimicPackageTask(devOpr, res);
            return dataVec;
        }
        if (devOpr instanceof LoadSoftwareOperation && (this.m_task.getTaskTypeId() == 3 || this.m_task.getTaskTypeId() == 5 && this.m_task.getUpgradeLevel() == 2)) {
            dataVec = this.getLoadFilesInfoForMinicPackageTask(devOpr, res);
            return dataVec;
        }
        for (int i = 0; i < this.m_iDevCount; ++i) {
            ResourceProgressInfo resProgressInfo = res[i].getOprResultInfo(devOpr.getOperationIdString());
            if (null == resProgressInfo) continue;
            Vector oprParaVec = new Vector();
            if (oprParaObj instanceof Vector) {
                oprParaVec = (Vector)oprParaObj;
            } else if (oprParaObj instanceof HashMap) {
                oprParaVec = (Vector)((HashMap)oprParaObj).get(String.valueOf(res[i].getDeviceID()));
            }
            for (int j = -1; j < oprParaVec.size(); ++j) {
                Vector<String> tmpRowVec = new Vector<String>();
                if (0 == i && j < 0) {
                    tmpRowVec.add(resProgressInfo.getCurrentOperationName());
                } else {
                    tmpRowVec.add("");
                }
                if (j < 0) {
                    tmpRowVec.add(res[i].getDeviceName());
                    tmpRowVec.add(res[i].getDeviceIP());
                    String strStartTime = "";
                    String strEndTime = "";
                    if (null != resProgressInfo.getStartTime()) {
                        strStartTime = DCTimeDateUtil.getLocaleDisplayTime(resProgressInfo.getStartTime());
                    }
                    tmpRowVec.add(strStartTime);
                    if (null != resProgressInfo.getEndTime()) {
                        strEndTime = DCTimeDateUtil.getLocaleDisplayTime(resProgressInfo.getEndTime());
                    }
                    tmpRowVec.add(strEndTime);
                    tmpRowVec.add("");
                    tmpRowVec.add("");
                    if (devOpr.isPauseBeforeCurOp()) {
                        tmpRowVec.add(this.m_strYes);
                    } else {
                        tmpRowVec.add(this.m_strNo);
                    }
                    List<Integer> dependOnOprLst = devOpr.getDependentOperation();
                    if (null != dependOnOprLst) {
                        StringBuffer sbDependOnOprs = new StringBuffer("");
                        for (int n = 0; n < dependOnOprLst.size(); ++n) {
                            Integer devOprId = dependOnOprLst.get(n);
                            if (n == 0) {
                                sbDependOnOprs.append(this.getOpreationName(devOprId, this.m_task.getSelectedDeviceType()));
                                continue;
                            }
                            String str = "; " + this.getOpreationName(devOprId, this.m_task.getSelectedDeviceType());
                            sbDependOnOprs.append(str);
                        }
                        tmpRowVec.add(sbDependOnOprs.toString());
                    } else {
                        tmpRowVec.add("");
                    }
                    tmpRowVec.add(resProgressInfo.getToolTipText());
                } else {
                    tmpRowVec.add("");
                    tmpRowVec.add("");
                    tmpRowVec.add("");
                    tmpRowVec.add("");
                    String[] strConfigInfo = (String[])oprParaVec.get(j);
                    tmpRowVec.add(strConfigInfo[0]);
                    tmpRowVec.add(strConfigInfo[1]);
                    tmpRowVec.add("");
                    tmpRowVec.add("");
                    tmpRowVec.add("");
                }
                dataVec.add(tmpRowVec);
            }
        }
        return dataVec;
    }

    private Vector constructOprInfoForMimicPackageTask(ITaskDeviceOperation devOpr, Resource[] res) {
        Vector<Vector> dataVec = new Vector<Vector>();
        Vector tmpRowVec = new Vector();
        ActiveInfo activeInfo = this.m_task.getActivationInfo();
        Vector<ActiveGroupInfo> groupList = activeInfo.getGroupList();
        int groupCount = groupList.size();
        for (int i = 0; i < groupCount; ++i) {
            ActiveGroupInfo groupInfo = groupList.get(i);
            Vector devList = groupInfo.getActivationInfoLst();
            int devCount = devList.size();
            for (int j = 0; j < devCount; ++j) {
                ActiveDevInfo devInfo = (ActiveDevInfo)devList.get(j);
                String operationId = null;
                operationId = i == 0 && j == 0 ? devOpr.getOperationIdString() : "";
                String devName = devInfo.getDevName();
                String devIp = DeviceInfoManagerImpl.getInstance().getDevice(devInfo.getDevId()).getDevIPAddress();
                String isPause = "";
                tmpRowVec = this.constructDevInfoForRow(operationId, devName, devIp, isPause);
                dataVec.add(tmpRowVec);
                Vector boardList = devInfo.getBoardList();
                int boardCount = boardList.size();
                for (int l = 0; l < boardCount; ++l) {
                    String value;
                    String item;
                    tmpRowVec = new Vector();
                    ActiveBoardInfo boardInfo = (ActiveBoardInfo)boardList.get(l);
                    tmpRowVec.add("");
                    tmpRowVec.add(boardInfo.getSlotLabel());
                    tmpRowVec.add("boardInfo.getBoardType()");
                    for (int z = 0; z < this.m_iDevCount; ++z) {
                        Resource resource = res[z];
                        if (resource.getDeviceID() != devInfo.getDevId() || resource.getSlotId() != boardInfo.getSlotId()) continue;
                        ResourceProgressInfo resProgressInfo = res[z].getOprResultInfo(devOpr.getOperationIdString());
                        tmpRowVec.add(resProgressInfo.getStartTime());
                        tmpRowVec.add(resProgressInfo.getEndTime());
                        tmpRowVec.add("");
                        tmpRowVec.add("");
                        if (groupInfo.getIsPause() == 0) {
                            tmpRowVec.add(this.m_oResourceManager.getResString("NO"));
                        } else {
                            tmpRowVec.add(this.m_oResourceManager.getResString("YES"));
                        }
                        tmpRowVec.add("");
                        tmpRowVec.add(resProgressInfo.getToolTipText());
                        dataVec.add(tmpRowVec);
                        break;
                    }
                    if (activeInfo.getStartTime() != null) {
                        item = this.m_oResourceManager.getResString("TASK_REPORT_ACTIVATE_TIME");
                        value = DCTimeDateUtil.getLocaleDisplayTime(activeInfo.getStartTime());
                        tmpRowVec = this.constructConfiguredParaRow(item, value);
                        dataVec.add(tmpRowVec);
                    }
                    item = this.m_oResourceManager.getResString("IS_DELETE_DATABASE");
                    value = boardInfo.getIsDeleteDatabase() == 0 ? this.m_oResourceManager.getResString("NO") : this.m_oResourceManager.getResString("YES");
                    tmpRowVec = this.constructConfiguredParaRow(item, value);
                    dataVec.add(tmpRowVec);
                    item = this.m_oResourceManager.getResString("GROUPING_FILE_PATH");
                    value = activeInfo.getFilePath();
                    tmpRowVec = this.constructConfiguredParaRow(item, value);
                    dataVec.add(tmpRowVec);
                    item = this.m_oResourceManager.getResString("TASK_REPORT_TABLE_GROUP_NAME");
                    value = this.m_oResourceManager.getResString("GROUP") + groupInfo.getGroupId();
                    tmpRowVec = this.constructConfiguredParaRow(item, value);
                    dataVec.add(tmpRowVec);
                }
            }
        }
        return dataVec;
    }

    private Vector constructConfiguredParaRow(String Item, String value) {
        Vector<String> tmpRowVec = new Vector<String>();
        tmpRowVec.add("");
        tmpRowVec.add("");
        tmpRowVec.add("");
        tmpRowVec.add("");
        tmpRowVec.add("");
        tmpRowVec.add(Item);
        tmpRowVec.add(value);
        tmpRowVec.add("");
        tmpRowVec.add("");
        tmpRowVec.add("");
        return tmpRowVec;
    }

    private Vector constructDevInfoForRow(String operationId, String devName, String devIp, String isPause) {
        Vector<String> tmpRowVec = new Vector<String>();
        tmpRowVec.add(operationId);
        tmpRowVec.add(devName);
        tmpRowVec.add(devIp);
        tmpRowVec.add("");
        tmpRowVec.add("");
        tmpRowVec.add("");
        tmpRowVec.add("");
        tmpRowVec.add(isPause);
        tmpRowVec.add("");
        tmpRowVec.add("");
        return tmpRowVec;
    }

    private Vector getCheckTypeInfo(Object oOprPara) {
        Vector<String[]> checkTypeVec = new Vector<String[]>();
        if (oOprPara instanceof ICheckOperationConfigParam) {
            ICheckOperationConfigParam checkConfigPara = (ICheckOperationConfigParam)oOprPara;
            int iCheckTypeCount = checkConfigPara.getNumOfCheckType();
            String strCheckType = this.m_oResourceManager.getResString("TASK_REPORT_TABLE_CHECK_TYPE");
            int iCheckTypeNum = 0;
            for (int i = 0; i < iCheckTypeCount; ++i) {
                ICheckType checkType = checkConfigPara.getCheckType(i);
                if (null == checkType || !checkType.isSelected()) continue;
                String[] checkTypeInfo = new String[]{strCheckType + " " + ++iCheckTypeNum, checkType.getDisplayName()};
                checkTypeVec.add(checkTypeInfo);
            }
        }
        return checkTypeVec;
    }

    private Vector getContentConfigInfo(Object oOprPara) {
        ContentConfigParam contentPara;
        List<ContentType> contentTypeLst;
        Vector<String[]> contentTypeVec = new Vector<String[]>();
        if (oOprPara instanceof ContentConfigParam && (contentTypeLst = (contentPara = (ContentConfigParam)oOprPara).getSelectedContentType()) != null) {
            String[] contentTypeInfo = null;
            if (contentPara.isContentTypeRequired()) {
                for (ContentType oContentType : contentTypeLst) {
                    contentTypeInfo = new String[]{this.m_oResourceManager.getResString("TASK_REPORT_CONTENT_TYPE"), oContentType.getStrContentType()};
                    contentTypeVec.add(contentTypeInfo);
                }
            }
        }
        return contentTypeVec;
    }

    private Vector getLoadFilesInfoForMinicPackageTask(ITaskDeviceOperation devOpr, Resource[] res) {
        Vector<Vector> dataVec = new Vector<Vector>();
        Vector tmpRowVec = new Vector();
        String item = "";
        String value = "";
        LoadSimPackageInfo simPackageInfo = this.m_task.getLoadSimPackageInfo();
        Vector devList = simPackageInfo.getDevList();
        int devCount = devList.size();
        for (int i = 0; i < devCount; ++i) {
            LoadSimPackageDevInfo devInfo = (LoadSimPackageDevInfo)devList.get(i);
            String operationId = null;
            operationId = i == 0 ? devOpr.getOperationIdString() : "";
            String devName = devInfo.getDevName();
            String devIp = DeviceInfoManagerImpl.getInstance().getDevice(devInfo.getDevId()).getDevIPAddress();
            String isPause = null;
            isPause = devOpr.isPauseBeforeCurOp() ? this.m_strYes : this.m_strNo;
            tmpRowVec = this.constructDevInfoForRow(operationId, devName, devIp, isPause);
            dataVec.add(tmpRowVec);
            Vector boardList = devInfo.getBoardList();
            int boardCount = boardList.size();
            for (int j = 0; j < boardCount; ++j) {
                tmpRowVec = new Vector();
                LoadSimPackageBoardInfo boardInfo = (LoadSimPackageBoardInfo)boardList.get(j);
                tmpRowVec.add("");
                tmpRowVec.add(boardInfo.getSlotLabel());
                tmpRowVec.add("");
                for (int z = 0; z < this.m_iDevCount; ++z) {
                    Resource resource = res[z];
                    if (resource.getDeviceID() != devInfo.getDevId() || resource.getSlotId() != boardInfo.getSlotId()) continue;
                    ResourceProgressInfo resProgressInfo = res[z].getOprResultInfo(devOpr.getOperationIdString());
                    tmpRowVec.add(resProgressInfo.getStartTime());
                    tmpRowVec.add(resProgressInfo.getEndTime());
                    tmpRowVec.add("");
                    tmpRowVec.add("");
                    tmpRowVec.add("");
                    tmpRowVec.add("");
                    tmpRowVec.add(resProgressInfo.getToolTipText());
                    dataVec.add(tmpRowVec);
                    break;
                }
                Vector fileList = boardInfo.getFileList();
                int fileCount = fileList.size();
                for (int l = 0; l < fileCount; ++l) {
                    LoadSimPackageFileInfo fileInfo = (LoadSimPackageFileInfo)fileList.get(l);
                    operationId = "";
                    devName = fileInfo.getFileName();
                    devIp = "";
                    isPause = "";
                    tmpRowVec = this.constructDevInfoForRow(operationId, devName, devIp, isPause);
                    dataVec.add(tmpRowVec);
                    item = this.m_oResourceManager.getResString("TASK_TABLE_COLUMN_NEW_SOFTWARE_VERSION");
                    value = fileInfo.getSoftwareNewVersion();
                    tmpRowVec = this.constructConfiguredParaRow(item, value);
                    dataVec.add(tmpRowVec);
                    item = this.m_oResourceManager.getResString("TASK_TABLE_COLUMN_TO_BE_LOADED");
                    value = fileInfo.getToBeLoad() == 0 ? this.m_oResourceManager.getResString("NO") : this.m_oResourceManager.getResString("YES");
                    tmpRowVec = this.constructConfiguredParaRow(item, value);
                    dataVec.add(tmpRowVec);
                }
            }
        }
        return dataVec;
    }

    private HashMap getLoadFilesInfo(Object oOprPara) {
        HashMap loadFilesMap = new HashMap();
        THashSet<Resource> oResList = this.m_task.getSelectedDeviceType().getResources();
        if (oOprPara instanceof LoadFileInfoListParam) {
            LoadFileInfoListParam loadFilesInfo = (LoadFileInfoListParam)oOprPara;
            List<LoadFileInfo> loadFileLst = loadFilesInfo.getLoadFileInfoList();
            String strFileNameLab = this.m_oResourceManager.getResString("TASK_REPORT_FILE_NAME");
            String strContentTypeLab = this.m_oResourceManager.getResString("TASK_REPORT_CONTENT_TYPE");
            String strSeqNoLab = this.m_oResourceManager.getResString("TASK_REPORT_SEQUENCE_NO");
            LoadFileInfo oPacketTool = loadFilesInfo.getPacketTool();
            if (null != oPacketTool) {
                Vector<String[]> loadFilesVec = new Vector<String[]>();
                String strPacketToolLab = this.m_oResourceManager.getResString("PACKET_TOOL_LABEL");
                String[] arrPacketToolInfo = new String[]{strPacketToolLab, oPacketTool.getFileName()};
                loadFilesVec.add(arrPacketToolInfo);
                Iterator oResItor = oResList.iterator();
                Resource oRes = null;
                while (oResItor.hasNext()) {
                    oRes = (Resource)oResItor.next();
                    String strDevId = String.valueOf(oRes.getDeviceID());
                    if (loadFilesMap.containsKey(strDevId)) {
                        Vector tmpVec = (Vector)loadFilesMap.get(strDevId);
                        tmpVec.addAll(loadFilesVec);
                        continue;
                    }
                    loadFilesMap.put(strDevId, loadFilesVec);
                }
            }
            int iFileCount = loadFileLst.size();
            for (int i = 0; i < iFileCount; ++i) {
                Vector<String[]> loadFilesVec = new Vector<String[]>();
                LoadFileInfo tmpLoadFileInfo = loadFilesInfo.getLoadFileInfo(i);
                String[] fileName = new String[]{strFileNameLab, tmpLoadFileInfo.getFileName()};
                loadFilesVec.add(fileName);
                String[] contentType = new String[]{strContentTypeLab, tmpLoadFileInfo.getContentType().toString()};
                loadFilesVec.add(contentType);
                String[] seqNo = new String[]{strSeqNoLab, tmpLoadFileInfo.getSequenceNo() + ""};
                loadFilesVec.add(seqNo);
                if (0 == tmpLoadFileInfo.getFileSelectionLevel()) {
                    Iterator oResItor = oResList.iterator();
                    Resource oRes = null;
                    while (oResItor.hasNext()) {
                        oRes = (Resource)oResItor.next();
                        String strDevId = String.valueOf(oRes.getDeviceID());
                        if (loadFilesMap.containsKey(strDevId)) {
                            Vector tmpVec = (Vector)loadFilesMap.get(strDevId);
                            tmpVec.addAll(loadFilesVec);
                            continue;
                        }
                        loadFilesMap.put(strDevId, (Vector)CloneUtil.getClone(loadFilesVec));
                    }
                } else {
                    String strDevId = String.valueOf(tmpLoadFileInfo.getDeviceId());
                    if (loadFilesMap.containsKey(strDevId)) {
                        Vector tmpVec = (Vector)loadFilesMap.get(strDevId);
                        tmpVec.addAll(loadFilesVec);
                    } else {
                        loadFilesMap.put(strDevId, loadFilesVec);
                    }
                }
                loadFilesVec = null;
            }
        }
        return loadFilesMap;
    }

    private HashMap getDataFilesInfo(Object oOprPara) {
        HashMap loadFilesMap = new HashMap();
        if (oOprPara instanceof LoadFileInfoListParam) {
            LoadFileInfoListParam loadFilesInfo = (LoadFileInfoListParam)oOprPara;
            List<LoadFileInfo> loadFileLst = loadFilesInfo.getLoadFileInfoList();
            String strFileNameLab = this.m_oResourceManager.getResString("TASK_REPORT_FILE_NAME");
            String strContentTypeLab = this.m_oResourceManager.getResString("TASK_REPORT_CONTENT_TYPE");
            String strSeqNoLab = this.m_oResourceManager.getResString("TASK_REPORT_SEQUENCE_NO");
            int iFileCount = loadFileLst.size();
            for (int i = 0; i < iFileCount; ++i) {
                Vector<String[]> loadFilesVec = new Vector<String[]>();
                LoadFileInfo tmpLoadFileInfo = loadFilesInfo.getLoadFileInfo(i);
                String[] fileName = new String[]{strFileNameLab, tmpLoadFileInfo.getFileName()};
                loadFilesVec.add(fileName);
                String[] contentType = new String[]{strContentTypeLab, tmpLoadFileInfo.getContentType().toString()};
                loadFilesVec.add(contentType);
                String[] seqNo = new String[]{strSeqNoLab, tmpLoadFileInfo.getSequenceNo() + ""};
                loadFilesVec.add(seqNo);
                String strDevId = String.valueOf(tmpLoadFileInfo.getDeviceId());
                if (loadFilesMap.containsKey(strDevId)) {
                    Vector tmpVec = (Vector)loadFilesMap.get(strDevId);
                    tmpVec.addAll(loadFilesVec);
                } else {
                    loadFilesMap.put(strDevId, loadFilesVec);
                }
                loadFilesVec = null;
            }
        }
        return loadFilesMap;
    }

    private HashMap getActivationInfo(Object oOprPara) {
        HashMap activationParaMap = new HashMap();
        Vector<String[]> activationParaVec = new Vector<String[]>();
        if (oOprPara instanceof ActivationConfigPara) {
            ParaValue activationMode;
            ActivationConfigPara activationConfigPara = (ActivationConfigPara)oOprPara;
            if (activationConfigPara.isActivationTimeRequired() && null != activationConfigPara.getActivationUTCTime()) {
                String[] activeTime = new String[]{this.m_oResourceManager.getResString("TASK_REPORT_ACTIVATE_TIME"), DCTimeDateUtil.getLocaleDisplayTime(activationConfigPara.getActivationUTCTime())};
                activationParaVec.add(activeTime);
            }
            if (activationConfigPara.isActivationTypeRequired() && activationConfigPara.getSelectedActivateType() != null) {
                String[] activationType = new String[]{this.m_oResourceManager.getResString("TASK_REPORT_ACTIVATION_TYPE"), activationConfigPara.getSelectedActivateType().toString()};
                activationParaVec.add(activationType);
            }
            if (null != (activationMode = activationConfigPara.getSelectedActivationMode())) {
                String[] activationModeName = new String[]{this.m_oResourceManager.getResString("TASK_REPORT_ACTIVATION_MODE"), activationMode.getDisplayName()};
                activationParaVec.add(activationModeName);
            }
            List elementInfoLst = activationConfigPara.getElementInfoLst();
            int iElementCount = elementInfoLst.size();
            for (int i = 0; i < iElementCount; ++i) {
                String strDevId;
                Vector<String[]> groupNameVec = new Vector<String[]>();
                groupNameVec.addAll(activationParaVec);
                ActivationElementInfo oElementInfo = null;
                oElementInfo = (ActivationElementInfo)elementInfoLst.get(i);
                if (Collator.getInstance().equals(activationConfigPara.getSelectedActivationMode().getId(), "GroupActivation")) {
                    ActivationGroupInfo activationGroupInfo = activationConfigPara.getGroupForId(oElementInfo.getGroupId());
                    String[] groupName = new String[]{this.m_oResourceManager.getResString("TASK_REPORT_TABLE_GROUP_NAME"), activationGroupInfo.getGroupName()};
                    groupNameVec.add(groupName);
                }
                if (activationParaMap.containsKey(strDevId = String.valueOf(oElementInfo.getResource().getDeviceID()))) {
                    Vector tmpVec = (Vector)activationParaMap.get(strDevId);
                    tmpVec.addAll(groupNameVec);
                } else {
                    activationParaMap.put(strDevId, groupNameVec);
                }
                groupNameVec = null;
            }
        }
        return activationParaMap;
    }

    private String getOpreationName(int iOprId, DeviceType devType) {
        IOperation oOperation;
        IDeviceTypeConfigModel oDevTypeModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(devType);
        if (null != oDevTypeModel && null != (oOperation = oDevTypeModel.getOperationObj(1, iOprId))) {
            return oOperation.getOperationName();
        }
        return null;
    }

    private String convertTimeToString(Calendar oCalendar) {
        if (oCalendar != null) {
            DCTimeDateUtil.switchToLocalCalendar(oCalendar);
            return DCTimeDateUtil.getLocaleDisplayTime(oCalendar);
        }
        return "";
    }
}

