/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.upgraderesult;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpForErrCodeUtil;
import com.huawei.dc.common.util.ErrorInfo;
import com.huawei.dc.taskmgmt.model.UpgradeFailInfo;
import com.huawei.dc.taskmgmt.model.UpgradeFailModel;
import com.huawei.dc.taskmgmt.view.createtask.ViewCommandResultDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class UpgradeFailDialog
extends DCModalDialog
implements IDCObjectDeallocator {
    private long firstOpenClientTime = System.nanoTime();
    private static UpgradeFailDialog instance = null;
    private static final long serialVersionUID = 5965164869304151347L;
    private UpgradeFailModel dataModel = null;
    private JPanel jPanel = null;
    private JTable jTable = null;
    private JScrollPane scrollPnl = null;

    public static synchronized UpgradeFailDialog getInstance() {
        if (null == instance) {
            DCDebugTracer.trace("popupdlg instance is null");
            instance = new UpgradeFailDialog();
        }
        return instance;
    }

    private UpgradeFailDialog() {
        this.initPanel();
        this.jPanel.setSize(800, 520);
        this.jPanel.setLayout(null);
        this.initDataModel();
        this.initTable();
        this.scrollPnl = new JScrollPane();
        this.scrollPnl.getViewport().add(this.jTable);
        this.scrollPnl.setBounds(20, 10, 755, 435);
        this.jPanel.add(this.scrollPnl);
        this.initCloseBtn();
        this.m_oCancelBtn.setBounds(350, 455, 100, 22);
        this.jPanel.add(this.m_oCancelBtn);
        this.setContentPane(this.jPanel);
        this.setTitle(DCFrameWorkUtil.getLocalizedString("UPGRADE_FAIL_TITLE"));
        this.setSize(800, 520);
        this.setLocationRelativeTo(DCFrameWorkUtil.getTaskTablePanel());
        this.setResizable(false);
        DCObjectDestructor.getInstance().addObjectForDestructor(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstOpenClientTime ^ this.firstOpenClientTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpgradeFailDialog other = (UpgradeFailDialog)obj;
        return this.firstOpenClientTime == other.firstOpenClientTime;
    }

    public void addUpgFailInfo(final UpgradeFailInfo rowData) {
        if (null == rowData) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null == UpgradeFailDialog.this.dataModel) {
                    DCDebugTracer.trace("dataModel is null");
                    UpgradeFailDialog.this.initDataModel();
                }
                UpgradeFailDialog.this.dataModel.insertRow(rowData);
                UpgradeFailDialog.this.jTable.updateUI();
                UpgradeFailDialog.this.jPanel.updateUI();
                if (null != DCFrameWorkUtil.getDCModuleManager().getTaskMgrMainPanel() && DCFrameWorkUtil.getDCModuleManager().getTaskMgrMainPanel().isActivated()) {
                    UpgradeFailDialog.this.setVisible(true);
                }
            }
        });
    }

    public void addUpgFailInfo(List<UpgradeFailInfo> rowDataLst) {
        if (null == rowDataLst || rowDataLst.size() == 0) {
            return;
        }
        for (UpgradeFailInfo rowData : rowDataLst) {
            this.dataModel.insertRow(rowData);
        }
        DCFrameWorkUtil.updateUI(this.jPanel);
        DCFrameWorkUtil.updateUI(this.jTable);
    }

    @Override
    protected String getCurrentContext() {
        return ResourceManager.getInstance().getResString("", "helpmapfile");
    }

    private void initCloseBtn() {
        this.m_oCancelBtn.setText(DCFrameWorkUtil.getLocalizedString("CLOSE_BUTTON"));
        this.m_oCancelBtn.setName("UpgradeFailDialog_m_oCancelBtn");
    }

    @Override
    protected void cancelButton_ActionPerformed() {
        DCDebugTracer.trace("popupdlg close upgradeFailDialog");
        instance = null;
        DCFrameWorkUtil.setUpgradeFaildDlg(null);
        DCDebugTracer.trace("set obj null");
        this.dispose();
    }

    @Override
    protected void closeDialog() {
        this.cancelButton_ActionPerformed();
    }

    private void initDataModel() {
        this.dataModel = new UpgradeFailModel();
    }

    private void initPanel() {
        this.jPanel = new JPanel();
        this.jPanel.setName("UpgradeFailDialog_jPanel");
    }

    private void initTable() {
        this.jTable = new JTable(this.dataModel);
        this.jTable.setRowHeight(21);
        this.jTable.getTableHeader().setReorderingAllowed(false);
        this.jTable.setRowSelectionAllowed(true);
        this.jTable.setSelectionMode(2);
        this.jTable.setFocusable(false);
        this.jTable.setName("UpgradeFailDialog_jTable");
        int colCount = this.jTable.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            TableColumn column = this.jTable.getColumnModel().getColumn(i);
            column.setCellRenderer(new DetailTableRenderer());
        }
        this.jTable.addMouseMotionListener(this.generateMouseMotionAdapter());
        this.jTable.addMouseListener(this.generateMouseAdapterForTable());
    }

    public void clearData() {
        if (null != this.dataModel) {
            this.dataModel.clear();
        }
    }

    @Override
    public void setToNULL() {
        if (this.dataModel != null) {
            this.dataModel.setToNull();
        }
        this.dataModel = null;
        instance = null;
    }

    private Component renderColumn(JTable table, Object value, boolean isSelected, JLabel label, ErrorInfo oErrorInfo) {
        if (isSelected) {
            this.setLabelWhenColumnIsSelected(table, label);
        } else {
            this.setLabelWhenColumnIsNotSelected(table, label);
        }
        if (null != value) {
            this.setLabelWhenColumnValueIsNull(value, label, oErrorInfo);
        }
        label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.gray));
        return label;
    }

    private void setLabelWhenColumnIsSelected(JTable table, JLabel label) {
        label.setBackground(table.getSelectionBackground());
        label.setForeground(Color.white);
    }

    private void setLabelWhenColumnIsNotSelected(JTable table, JLabel label) {
        label.setBackground(table.getBackground());
        label.setForeground(table.getForeground());
    }

    private void setLabelWhenColumnValueIsNull(Object value, JLabel label, ErrorInfo oErrorInfo) {
        String strLabelText = value.toString();
        if (null != oErrorInfo) {
            strLabelText = DCCommonUtil.getFailureStr("", oErrorInfo.getErrorCode());
        }
        label.setText(strLabelText);
        label.setToolTipText(value.toString());
    }

    private MouseMotionAdapter generateMouseMotionAdapter() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent oMouseEvent) {
                Cursor cur;
                UpgradeFailInfo oUpgradeFailInfo;
                Vector oValue;
                Point oPoint = oMouseEvent.getPoint();
                int iCol = UpgradeFailDialog.this.jTable.columnAtPoint(oPoint);
                int iRow = UpgradeFailDialog.this.jTable.rowAtPoint(oPoint);
                boolean bHandCursor = false;
                if (4 == iCol && (oValue = UpgradeFailDialog.this.dataModel.getDataVector().elementAt(iRow)) instanceof UpgradeFailInfo && (oUpgradeFailInfo = (UpgradeFailInfo)((Object)oValue)).getErrorInfo() != null && DCHelpForErrCodeUtil.isShowHyperlink(oUpgradeFailInfo.getErrorInfo().getErrorCode()) && 995098636 != oUpgradeFailInfo.getErrorInfo().getErrorCode()) {
                    bHandCursor = true;
                }
                if (bHandCursor) {
                    cur = new Cursor(12);
                    DCFrameWorkUtil.setCursor((Component)((Object)UpgradeFailDialog.this), cur);
                } else {
                    cur = new Cursor(0);
                    DCFrameWorkUtil.setCursor((Component)((Object)UpgradeFailDialog.this), cur);
                }
            }
        };
    }

    private MouseAdapter generateMouseAdapterForTable() {
        return new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                Cursor cur = new Cursor(0);
                DCFrameWorkUtil.setCursor((Component)((Object)UpgradeFailDialog.this), cur);
            }

            @Override
            public void mouseClicked(MouseEvent oMouseEvent) {
                UpgradeFailInfo oUpgradeFailInfo;
                Vector oValue;
                Point oPoint = oMouseEvent.getPoint();
                int iCol = UpgradeFailDialog.this.jTable.columnAtPoint(oPoint);
                int iRow = UpgradeFailDialog.this.jTable.rowAtPoint(oPoint);
                ErrorInfo oErrInfo = null;
                if (4 == iCol && (oValue = UpgradeFailDialog.this.dataModel.getDataVector().elementAt(iRow)) instanceof UpgradeFailInfo && null != (oUpgradeFailInfo = (UpgradeFailInfo)((Object)oValue))) {
                    oErrInfo = oUpgradeFailInfo.getErrorInfo();
                }
                if (null != oErrInfo) {
                    if (999293081 == oErrInfo.getErrorCode()) {
                        String strMessage = oErrInfo.getErrMsg();
                        ViewCommandResultDialog dialog = new ViewCommandResultDialog(strMessage);
                        dialog.setTitle(DCFrameWorkUtil.getLocalizedString("OPERATION_RESULT"));
                        dialog.getContentTextArea().setLineWrap(true);
                        dialog.setVisible(true);
                    } else {
                        DCHelpForErrCodeUtil.showHelp((Component)((Object)UpgradeFailDialog.this), oErrInfo.getErrorCode());
                    }
                }
            }
        };
    }

    class DetailTableRenderer
    implements TableCellRenderer {
        DetailTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int iRow, int iCol) {
            UpgradeFailInfo oTmpUpgradeFailInfo;
            ErrorInfo oTmpErrorInfo;
            Vector oValue;
            JLabel label = new JLabel();
            label.setOpaque(true);
            ErrorInfo oErrorInfo = null;
            if (4 == iCol && (oValue = UpgradeFailDialog.this.dataModel.getDataVector().elementAt(iRow)) instanceof UpgradeFailInfo && null != (oTmpErrorInfo = (oTmpUpgradeFailInfo = (UpgradeFailInfo)((Object)oValue)).getErrorInfo()) && DCHelpForErrCodeUtil.isShowHyperlink(oTmpErrorInfo.getErrorCode())) {
                oErrorInfo = oTmpErrorInfo;
            }
            return UpgradeFailDialog.this.renderColumn(table, value, isSelected, label, oErrorInfo);
        }
    }
}

