/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.tasktree;

import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfoLst;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.event.TaskTreeSelectionEvent;
import com.huawei.dc.common.framework.interfaces.DCEventRegisterInterface;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.TreeHelper;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.taskmgmt.controller.ITaskNotificationListener;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskEventID;
import com.huawei.dc.taskmgmt.controller.TaskInfoNotifier;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.ITaskDataModel;
import com.huawei.dc.taskmgmt.model.ITaskGroup;
import com.huawei.dc.taskmgmt.model.TaskGroup;
import com.huawei.dc.taskmgmt.model.TaskModelUtil;
import com.huawei.dc.taskmgmt.view.common.TaskManagementPopupMenuManager;
import com.huawei.dc.taskmgmt.view.common.TaskMenuItemHandler;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTablePanel;
import com.huawei.dc.taskmgmt.view.tasktree.TaskTreeCellRenderer;
import com.huawei.dc.taskmgmt.view.tasktree.TaskTreeNodeInfo;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TaskTreePanel
extends JPanel
implements DCEventRegisterInterface,
ITaskNotificationListener {
    private static final long serialVersionUID = 1L;
    private JTree m_oTaskTree;
    private ITaskDataModel m_oTaskDataModel;
    protected DefaultTreeModel m_oTaskTreeModel;
    private JScrollPane m_oScrollPane;
    private List<DCTreeEventListener> m_oListenerList;
    private DefaultMutableTreeNode m_oRootNode;
    private boolean m_bIsAutoTreeEvent = false;
    private static final int LISTENER_LIST_DEFAULT_COUNT = 1;
    private TaskTablePanel m_oTaskTablePanel;
    private TaskManagementPopupMenuManager m_oPopupMenuManager;
    private TaskMenuItemHandler m_oTaskMenuItemHandler;

    public TaskTreePanel(ITaskDataModel oTaskModel, TaskTablePanel taskTablePanel) {
        this.m_oTaskDataModel = oTaskModel;
        this.m_oTaskTablePanel = taskTablePanel;
        this.jInit();
    }

    private void jInit() {
        this.setLayout(new BorderLayout());
        this.createTaskTree();
        this.m_oScrollPane = new JScrollPane(this.m_oTaskTree);
        this.m_oScrollPane.setName("TaskMgmt_TaskTreePanel_m_oScrollPane");
        this.add(this.m_oScrollPane);
        this.m_oTaskMenuItemHandler = new TaskMenuItemHandler(this.m_oTaskTablePanel);
        this.m_oPopupMenuManager = new TaskManagementPopupMenuManager(this.m_oTaskTablePanel.getTaskTreeTable(), this.m_oTaskMenuItemHandler);
        this.m_oListenerList = new ArrayList<DCTreeEventListener>(1);
    }

    private void createTaskTree() {
        this.m_oTaskTree = new JTree();
        this.m_oTaskTree.setName("TaskMgmt_TaskTreePanel_m_oTaskTree");
        this.m_oTaskTreeModel = (DefaultTreeModel)this.m_oTaskTree.getModel();
        this.populateTaskTree();
        this.setBackground(Color.white);
        this.expandTreeAtRoot();
        this.m_oTaskTree.getSelectionModel().setSelectionMode(1);
        this.m_oTaskTree.setShowsRootHandles(true);
        this.initializeTreeCellRenderer();
        this.initializeTreeSelectionListener();
        this.initDefaultSelection();
    }

    private void initDefaultSelection() {
        this.m_oTaskTree.setSelectionRow(0);
        TaskTreeSelectionEvent eventObj = new TaskTreeSelectionEvent(this.m_oRootNode.getUserObject());
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_oTaskTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                TaskTreePanel.this.generateMouseAdapterForTree(e);
            }
        });
        this.notifyEvent(eventObj);
    }

    private void generateMouseAdapterForTree(MouseEvent e) {
        DCFrameWorkUtil.getTaskTableButtonPanel().setRefreshDateTime();
        DCFrameWorkUtil.getTaskTableButtonPanel().refreshSelectedTaskCountLabel();
        if (0 == (e.getModifiers() & 0x10) && 0 == (e.getModifiers() & 8) && e.getID() == 502 && e.getClickCount() == 1) {
            this.taskTree_MousePressed(e);
        }
    }

    private void taskTree_MousePressed(MouseEvent oMouseEvent) {
        DCSortableTreeTable oTaskTreeTable = this.m_oTaskTablePanel.getTaskTreeTable();
        int iClickedRow = oTaskTreeTable.rowAtPoint(oMouseEvent.getPoint());
        boolean bIsClickedRowSelected = false;
        int[] nRows = oTaskTreeTable.getSelectedRows();
        if (nRows.length > 0) {
            for (int i = 0; i < nRows.length; ++i) {
                if (nRows[i] != iClickedRow) continue;
                bIsClickedRowSelected = true;
                break;
            }
        }
        if (!bIsClickedRowSelected) {
            ListSelectionModel selectionModel = oTaskTreeTable.getSelectionModel();
            selectionModel.setSelectionInterval(iClickedRow, iClickedRow);
        }
        nRows = oTaskTreeTable.getSelectedRows();
        JPopupMenu oPopupMenu = null;
        try {
            this.removeTableFocus(oTaskTreeTable, nRows);
            oPopupMenu = this.m_oPopupMenuManager.enableOnlyCreateTaskItem();
            oPopupMenu.show(this.m_oTaskTree, oMouseEvent.getX(), oMouseEvent.getY());
        }
        catch (Exception e) {
            DCDebugTracer.trace("[menu] popup menu load fail error detail : ");
            DCDebugTracer.trace(e);
            DCDebugTracer.traceError(e.getMessage());
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("POPUP_MENU_LOAD_FAIL_ERROR"), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
    }

    private void removeTableFocus(DCSortableTreeTable oTaskTreeTable, int[] nRows) {
        try {
            for (int nRow : nRows) {
                oTaskTreeTable.removeRowSelectionInterval(nRow, nRow);
            }
        }
        catch (Exception ignore) {
            DCDebugTracer.trace(ignore);
        }
    }

    private void populateTaskTree() {
        TaskTreeNodeInfo oRootNodeInfo = new TaskTreeNodeInfo(this.m_oTaskDataModel);
        this.m_oRootNode = new DefaultMutableTreeNode(oRootNodeInfo);
        this.m_oTaskTreeModel.setRoot(this.m_oRootNode);
        List arrTaskGroups = this.getOrderedTaskGroupList();
        ITaskGroup oTaskGroup = null;
        int iGroupID = -1;
        TIntArrayList oSupportGroups = TaskModelUtil.getSupportGroupLst();
        for (int i = 0; i < arrTaskGroups.size(); ++i) {
            oTaskGroup = (ITaskGroup)arrTaskGroups.get(i);
            iGroupID = oTaskGroup.getTaskGroupId();
            if (!oSupportGroups.contains(iGroupID)) continue;
            this.populateTaskGroupTree(oTaskGroup, this.m_oRootNode);
        }
    }

    private List getOrderedTaskGroupList() {
        ArrayList<ITaskGroup> oOrderedList = new ArrayList<ITaskGroup>(0);
        int[] taskGroups = TaskGroup.getTaskGroupIdLst();
        int iTaskGroupsNum = taskGroups.length;
        for (int i = 0; i < iTaskGroupsNum; ++i) {
            ITaskGroup oTaskGroup = this.m_oTaskDataModel.getTaskGroup(taskGroups[i]);
            if (null == oTaskGroup) continue;
            oOrderedList.add(oTaskGroup);
        }
        return oOrderedList;
    }

    private void populateTaskGroupTree(ITaskGroup oTaskGroup, DefaultMutableTreeNode oRootNode) {
        if (null == oTaskGroup) {
            return;
        }
        TaskTreeNodeInfo oTaskGroupNodeInfo = new TaskTreeNodeInfo(oTaskGroup);
        DefaultMutableTreeNode oTaskGroupNode = new DefaultMutableTreeNode(oTaskGroupNodeInfo);
        oRootNode.add(oTaskGroupNode);
        this.populateStatusNodesForTaskGroup(oTaskGroup, oTaskGroupNode);
    }

    private void populateStatusNodesForTaskGroup(ITaskGroup oTaskGroup, DefaultMutableTreeNode oTaskGroupNode) {
        int taskCount = 0;
        TaskTreeNodeInfo oNotRunTaskNodeInfo = new TaskTreeNodeInfo(oTaskGroup, 0, taskCount);
        DefaultMutableTreeNode oNotRunTaskNode = new DefaultMutableTreeNode(oNotRunTaskNodeInfo);
        oTaskGroupNode.add(oNotRunTaskNode);
        TaskTreeNodeInfo oRunningTaskNodeInfo = new TaskTreeNodeInfo(oTaskGroup, 2, taskCount);
        DefaultMutableTreeNode oRunningTaskNode = new DefaultMutableTreeNode(oRunningTaskNodeInfo);
        oTaskGroupNode.add(oRunningTaskNode);
        TaskTreeNodeInfo oCompletedTaskNodeInfo = new TaskTreeNodeInfo(oTaskGroup, 3, taskCount);
        DefaultMutableTreeNode oCompletedTaskNode = new DefaultMutableTreeNode(oCompletedTaskNodeInfo);
        oTaskGroupNode.add(oCompletedTaskNode);
    }

    private void expandTreeAtRoot() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeHelper.expandAll(TaskTreePanel.this.m_oTaskTree, TaskTreePanel.this.m_oTaskTree.getPathForRow(0), true);
            }
        });
    }

    private void initializeTreeCellRenderer() {
        this.m_oTaskTree.setCellRenderer(new TaskTreeCellRenderer());
    }

    private void initializeTreeSelectionListener() {
        this.m_oTaskTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent oEvent) {
                TaskTreePanel.this.sendNotificationToListeners(oEvent);
            }
        });
    }

    private void sendNotificationToListeners(TreeSelectionEvent oEvent) {
        TreePath oPath = oEvent.getNewLeadSelectionPath();
        if (oPath != null) {
            Object oNode = oPath.getLastPathComponent();
            DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)oNode;
            TaskTreeSelectionEvent eventObj = new TaskTreeSelectionEvent(oTreeNode.getUserObject());
            eventObj.setAutoTreeEvent(this.m_bIsAutoTreeEvent);
            this.notifyEvent(eventObj);
        }
    }

    @Override
    public void addDCEventListener(DCTreeEventListener eventListener) {
        if (null != eventListener && !this.m_oListenerList.contains(eventListener)) {
            this.m_oListenerList.add(eventListener);
        }
    }

    @Override
    public void notifyEvent(final DCEventObject eventObject) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int iCount = TaskTreePanel.this.m_oListenerList.size();
                for (int index = 0; index < iCount; ++index) {
                    DCTreeEventListener eventListener = (DCTreeEventListener)TaskTreePanel.this.m_oListenerList.get(index);
                    eventListener.onTreeNodeSelection(eventObject);
                }
            }
        });
    }

    @Override
    public void removeDCEventListener(DCTreeEventListener eventListener) {
        if (null != eventListener && this.m_oListenerList.contains(eventListener)) {
            this.m_oListenerList.remove(eventListener);
        }
    }

    public void updateTaskTreeTaskCount() {
        List arrTaskGroups = this.getOrderedTaskGroupList();
        IDeviceInfoManager m_oDeviceInfoManagerImpl = DeviceInfoManagerImpl.getInstance();
        DeviceTypeInfo[] arrDeviceTypes = m_oDeviceInfoManagerImpl.getExistDeviceTypes();
        int[] iDeviceIdLst = m_oDeviceInfoManagerImpl.getAddedDeviceIdLst();
        for (int i = 0; i < arrTaskGroups.size(); ++i) {
            ITaskGroup oTaskGroup = (ITaskGroup)arrTaskGroups.get(i);
            if (!TaskModelUtil.isTaskTypeSupportedForDeviceTypesOnlyExistsDev(oTaskGroup.getTaskGroupId(), arrDeviceTypes, iDeviceIdLst)) continue;
            this.updateTaskStautsNodeTaskCount(oTaskGroup, 0);
            this.updateTaskStautsNodeTaskCount(oTaskGroup, 2);
            this.updateTaskStautsNodeTaskCount(oTaskGroup, 3);
        }
        this.updateTaskTree();
    }

    private void updateTaskTree() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskTreePanel.this.m_oTaskTree.updateUI();
                DCFrameWorkUtil.getTaskTableButtonPanel().setRefreshDateTime();
            }
        });
    }

    public void updateTaskStautsNodeTaskCount(ITaskGroup oTaskGroup, int taskStatus) {
        DefaultMutableTreeNode oTreeNode = this.getTreeNodeForTaskTypeAndStatus(oTaskGroup.getTaskGroupId(), taskStatus);
        if (null == oTreeNode) {
            DCDebugTracer.trace("oTreeNode is null");
            DCDebugTracer.trace("method updateTaskStautsNodeTaskCount end..");
            return;
        }
        TaskTreeNodeInfo treeNodeInfo = (TaskTreeNodeInfo)oTreeNode.getUserObject();
        List<ITask> taskList = this.getTasksByTaskStatus(oTaskGroup, taskStatus);
        treeNodeInfo.setTaskCountStatus(taskList.size());
    }

    public List<ITask> getTasksByTaskStatus(ITaskGroup taskGroup, int taskStatus) {
        if (null == taskGroup || null == taskGroup.getAllTask(taskStatus)) {
            return new ArrayList<ITask>();
        }
        return taskGroup.getTasksByTaskStatus(taskStatus);
    }

    @Override
    public void onTaskNotification(TaskEvent oEvent) {
        if (null == oEvent || null == oEvent.getSource()) {
            return;
        }
        this.updateTreeForNotification(oEvent);
    }

    private void updateTreeForNotification(TaskEvent oEvent) {
        TaskEventID enTaskEventType = oEvent.getTaskEventType();
        if (TaskEventID.TASK_LIST_REFRESH == enTaskEventType) {
            if (null == oEvent.getSource()) {
                DCDebugTracer.trace("enTaskEventType : TASK_LIST_REFRESH event source is null");
                return;
            }
            Boolean oIsLastInfo = (Boolean)oEvent.getSource();
            if (null == oIsLastInfo || oIsLastInfo.booleanValue()) {
                DCFrameWorkUtil.defaultCursor();
                this.updateTaskTreeTaskCount();
                DCFrameWorkUtil.setCursor(this, Cursor.getPredefinedCursor(0));
            } else {
                DCFrameWorkUtil.waitCursor();
                this.updateTaskTreeTaskCount();
                DCFrameWorkUtil.setCursor(this, Cursor.getPredefinedCursor(3));
            }
        } else if (TaskEventID.TASK_CREATION == enTaskEventType || TaskEventID.TASK_DELETION == enTaskEventType || TaskEventID.TASK_UPDATE_TASK_COUNT == enTaskEventType) {
            this.updateTaskTreeTaskCount();
        } else if (TaskEventID.MOVE_TO_COMPLETED == enTaskEventType) {
            if (null == oEvent.getSource()) {
                DCDebugTracer.trace("enTaskEventType : MOVE_TO_COMPLETED event source is null");
                return;
            }
            ITask oTask = (ITask)oEvent.getSource();
            DefaultMutableTreeNode oTreeNode = this.getTreeNodeForTaskTypeAndStatus(oTask.getTaskTypeId(), 3);
            TreePath oPath = new TreePath(oTreeNode.getPath());
            this.m_oTaskTree.removeSelectionPath(oPath);
            this.m_oTaskTree.setSelectionPath(oPath);
            this.updateTaskTreeTaskCount();
        } else {
            DCDebugTracer.trace("enTaskEventType : " + (Object)((Object)enTaskEventType));
        }
    }

    private DefaultMutableTreeNode getTreeNodeForTaskTypeAndStatus(int iTaskTypeID, int iTaskStatus) {
        Enumeration<TreeNode> oNodeList = this.m_oRootNode.depthFirstEnumeration();
        while (oNodeList.hasMoreElements()) {
            DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)oNodeList.nextElement();
            TaskTreeNodeInfo oNodeInfo = (TaskTreeNodeInfo)oTreeNode.getUserObject();
            if (2 != oNodeInfo.getNodeType()) continue;
            switch (iTaskTypeID) {
                case 0: 
                case 1: {
                    iTaskTypeID = 10;
                    break;
                }
                case 5: 
                case 12: {
                    iTaskTypeID = 11;
                    break;
                }
                case 4: 
                case 13: {
                    iTaskTypeID = 14;
                    break;
                }
                default: {
                    DCDebugTracer.trace("iTaskTypeID : " + iTaskTypeID);
                }
            }
            if (iTaskTypeID != oNodeInfo.getTaskGroup().getTaskGroupId() || iTaskStatus != oNodeInfo.getTaskStatus()) continue;
            return oTreeNode;
        }
        return null;
    }

    public void disposePanel() {
        TaskInfoNotifier.getInstance().removeTaskNotificationListener(this);
        this.removeAll();
        if (null != this.m_oListenerList) {
            this.m_oListenerList.clear();
            this.m_oListenerList = null;
        }
        this.m_oTaskTree = null;
        this.m_oTaskDataModel = null;
        this.m_oTaskTreeModel = null;
        this.m_oScrollPane = null;
        if (null != this.m_oRootNode) {
            this.m_oRootNode.removeAllChildren();
            this.m_oRootNode = null;
        }
        this.m_oTaskTablePanel = null;
        if (null != this.m_oPopupMenuManager) {
            this.m_oPopupMenuManager.doCleanUp();
            this.m_oPopupMenuManager = null;
        }
    }

    public void refreshData() {
        if (null != this.m_oRootNode) {
            this.m_oRootNode.removeAllChildren();
        }
        this.populateTaskTree();
        this.expandTreeAtRoot();
        this.m_oTaskTree.setSelectionRow(0);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskTreePanel.this.m_oTaskTree.updateUI();
            }
        });
    }

    public void handleDeviceDeleteNotification(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        if (null == this.getDeviceInfoFromASN(oDeviceInfoList)) {
            return;
        }
        List<DeviceInfo> oDelDevInfo = Arrays.asList(this.getDeviceInfoFromASN(oDeviceInfoList));
        this.updateTaskTreeForDeviceConfigChange(oDelDevInfo, false);
        this.updateTaskTreeTaskCount();
    }

    private void updateTaskTreeForDeviceConfigChange(List<DeviceInfo> oModifyDevInfo, boolean bFlagForAdd) {
        try {
            TaskTreeNodeInfo oRootNodeInfo = new TaskTreeNodeInfo(this.m_oTaskDataModel);
            this.m_oRootNode = new DefaultMutableTreeNode(oRootNodeInfo);
            this.m_oTaskTreeModel.setRoot(this.m_oRootNode);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        IDeviceInfoManager m_oDeviceInfoManagerImpl = DeviceInfoManagerImpl.getInstance();
        DeviceInfo[] arrDeviceInfo = m_oDeviceInfoManagerImpl.getDevices();
        List<DeviceInfo> oDevInfo = Arrays.asList(arrDeviceInfo);
        ArrayList<DeviceInfo> oDevInfoList = new ArrayList<DeviceInfo>();
        if (oDevInfoList != null) {
            if (bFlagForAdd) {
                oDevInfoList.addAll(oModifyDevInfo);
                oDevInfoList.addAll(oDevInfo);
            } else {
                oDevInfoList.addAll(oDevInfo);
                oDevInfoList.removeAll(oModifyDevInfo);
            }
            Vector<DeviceTypeInfo> consolidatedDeviceTypeVec = new Vector<DeviceTypeInfo>(0);
            DeviceTypeInfo currDeviceTypeInfo = new DeviceTypeInfo();
            int[] iDeviceIdLst = new int[oDevInfoList.size()];
            for (int index = 0; index < oDevInfoList.size(); ++index) {
                iDeviceIdLst[index] = ((DeviceInfo)oDevInfoList.get(index)).getDevId();
                currDeviceTypeInfo = ((DeviceInfo)oDevInfoList.get(index)).getDeviceTypeInfo();
                boolean bFound = false;
                for (int j = 0; j < consolidatedDeviceTypeVec.size(); ++j) {
                    DeviceTypeInfo oldDeviceType = (DeviceTypeInfo)consolidatedDeviceTypeVec.elementAt(j);
                    if (oldDeviceType.getDevTypeID() != currDeviceTypeInfo.getDevTypeID() || oldDeviceType.getDevTypeVersionId() != currDeviceTypeInfo.getDevTypeVersionId()) continue;
                    bFound = true;
                    break;
                }
                if (bFound) continue;
                consolidatedDeviceTypeVec.add(currDeviceTypeInfo);
            }
            try {
                Collections.sort(consolidatedDeviceTypeVec);
            }
            catch (RuntimeException e) {
                DCDebugTracer.trace(e);
            }
            DeviceTypeInfo[] arrDeviceTypeList = consolidatedDeviceTypeVec.toArray(new DeviceTypeInfo[0]);
            List arrTaskGroups = this.getOrderedTaskGroupList();
            for (int i = 0; i < arrTaskGroups.size(); ++i) {
                ITaskGroup oTaskGroup = (ITaskGroup)arrTaskGroups.get(i);
                if (!TaskModelUtil.isTaskTypeSupportedForDeviceTypes(oTaskGroup.getTaskGroupId(), arrDeviceTypeList, iDeviceIdLst) || DCFrameWorkUtil.getIsSingleClient() && 7 == oTaskGroup.getTaskGroupId()) continue;
                this.populateTaskGroupTree(oTaskGroup, this.m_oRootNode);
            }
        }
        this.m_oTaskTree.setSelectionRow(0);
        this.expandTreeAtRoot();
    }

    private DeviceInfo[] getDeviceInfoFromASN(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        if (null == oDeviceInfoList || 0 == oDeviceInfoList.size()) {
            return null;
        }
        int noOfDevices = oDeviceInfoList.size();
        AsnDCDeviceSubmapNtfnInfo asnDeviceInfo = null;
        DeviceInfo[] arrDeviceTypes = new DeviceInfo[noOfDevices];
        for (int i = 0; i < noOfDevices; ++i) {
            DeviceInfo oDevType;
            asnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            arrDeviceTypes[i] = oDevType = DCFrameWorkUtil.getDeviceInfoManager().getDevice(asnDeviceInfo.oDeviceInfo.iDevId.intValue());
        }
        return arrDeviceTypes;
    }

    public void handleDeviceAddNotification(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        if (null == this.getDeviceInfoFromASN(oDeviceInfoList)) {
            return;
        }
        List<DeviceInfo> oAddDevInfo = Arrays.asList(this.getDeviceInfoFromASN(oDeviceInfoList));
        this.updateTaskTreeForDeviceConfigChange(oAddDevInfo, true);
        this.updateTaskTreeTaskCount();
    }
}

