/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.tasktree;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.taskmgmt.model.ITaskDataModel;
import com.huawei.dc.taskmgmt.model.ITaskGroup;

public class TaskTreeNodeInfo {
    private ITaskDataModel m_oTaskDataModel;
    private ITaskGroup m_oTaskGroup;
    private int m_iTaskStatus;
    private int m_iNodeType;
    private String m_strNodeName;
    public static final int TASK_TREE_ROOT_NODE = 0;
    public static final int TASK_TREE_TASK_GROUP_NODE = 1;
    public static final int TASK_TREE_TASK_STATUS_NODE = 2;
    private int taskCount_status = 0;

    public TaskTreeNodeInfo(ITaskDataModel oTaskModel) {
        this.m_oTaskDataModel = oTaskModel;
        this.m_iNodeType = 0;
        this.m_strNodeName = ResourceManager.getInstance().getResString("TASK_TREE_ROOT_NODE");
    }

    public TaskTreeNodeInfo(ITaskGroup oTaskGroup) {
        this.m_oTaskGroup = oTaskGroup;
        this.m_iNodeType = 1;
        this.m_strNodeName = oTaskGroup.toString();
    }

    public TaskTreeNodeInfo(ITaskGroup oTaskGroup, int iTaskStatus) {
        this.m_oTaskGroup = oTaskGroup;
        this.m_iNodeType = 2;
        this.m_iTaskStatus = iTaskStatus;
        this.m_strNodeName = TaskTreeNodeInfo.getNodeNameForStatus(iTaskStatus);
    }

    public TaskTreeNodeInfo(ITaskGroup oTaskGroup, int iTaskStatus, int taskCount) {
        this.m_oTaskGroup = oTaskGroup;
        this.m_iNodeType = 2;
        this.m_iTaskStatus = iTaskStatus;
        this.m_strNodeName = TaskTreeNodeInfo.getNodeNameForStatus(iTaskStatus);
        this.taskCount_status = taskCount;
    }

    private static String getNodeNameForStatus(int iTaskStatus) {
        ResourceManager oResManager = ResourceManager.getInstance();
        switch (iTaskStatus) {
            case 0: {
                return oResManager.getResString("TASK_STATUS_NOT_RUN");
            }
            case 1: 
            case 2: {
                return oResManager.getResString("TASK_STATUS_RUNNING");
            }
            case 3: {
                return oResManager.getResString("TASK_STATUS_COMPLETED");
            }
        }
        return "";
    }

    public String toString() {
        if (null == this.m_strNodeName) {
            return "";
        }
        if (2 == this.m_iNodeType) {
            return new StringBuffer(this.m_strNodeName).append("(").append(this.taskCount_status).append(")").toString();
        }
        return this.m_strNodeName;
    }

    public ITaskDataModel getTaskDataModel() {
        return this.m_oTaskDataModel;
    }

    public ITaskGroup getTaskGroup() {
        return this.m_oTaskGroup;
    }

    public int getNodeType() {
        return this.m_iNodeType;
    }

    public int getTaskStatus() {
        return this.m_iTaskStatus;
    }

    public int getTaskCountStatus() {
        return this.taskCount_status;
    }

    public void setTaskCountStatus(int taskCountStatus) {
        this.taskCount_status = taskCountStatus;
    }
}

