/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.tasktree;

import com.huawei.dc.common.components.tree.renderer.DCDefaultTreeCellRenderer;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.taskmgmt.model.ITaskGroup;
import com.huawei.dc.taskmgmt.view.tasktree.TaskTreeNodeInfo;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class TaskTreeCellRenderer
extends DCDefaultTreeCellRenderer {
    @Override
    protected JLabel createLabelWithIcon(Object oUserObject, boolean bIsLeaf, boolean anIsExpanded) {
        if (!(oUserObject instanceof TaskTreeNodeInfo)) {
            return super.createLabelWithIcon(oUserObject, bIsLeaf, anIsExpanded);
        }
        TaskTreeNodeInfo oTaskNodeInfo = (TaskTreeNodeInfo)oUserObject;
        JLabel oLabel = new JLabel();
        ImageIcon oTaskNodeIcon = null;
        if (0 == oTaskNodeInfo.getNodeType()) {
            oTaskNodeIcon = ResourceManager.getInstance().getImage("task.gif");
        } else if (1 == oTaskNodeInfo.getNodeType()) {
            oTaskNodeIcon = this.getIconForTaskGroup(oTaskNodeInfo.getTaskGroup());
        } else if (2 == oTaskNodeInfo.getNodeType()) {
            oTaskNodeIcon = this.getIconForTaskGroupAndStatus(oTaskNodeInfo.getTaskGroup(), oTaskNodeInfo.getTaskStatus());
        }
        if (null != oTaskNodeIcon) {
            oLabel.setIcon(oTaskNodeIcon);
        }
        return oLabel;
    }

    private ImageIcon getIconForTaskGroupAndStatus(ITaskGroup iTaskGroup, int iTaskStatus) {
        switch (iTaskStatus) {
            case 0: {
                return ResourceManager.getInstance().getImage("not-running.gif");
            }
            case 1: 
            case 2: {
                return ResourceManager.getInstance().getImage("running.gif");
            }
            case 3: {
                return ResourceManager.getInstance().getImage("completed.gif");
            }
        }
        return null;
    }

    private ImageIcon getIconForTaskGroup(ITaskGroup oTaskGroup) {
        int iTaskGroupID = oTaskGroup.getTaskGroupId();
        ImageIcon oNodeIcon = null;
        switch (iTaskGroupID) {
            case 0: {
                oNodeIcon = ResourceManager.getInstance().getImage("software_upgrade_task.gif");
                break;
            }
            case 1: {
                oNodeIcon = ResourceManager.getInstance().getImage("software_downgrade_task.gif");
                break;
            }
            case 10: {
                oNodeIcon = ResourceManager.getInstance().getImage("software_upgrade_task.gif");
                break;
            }
            case 2: {
                oNodeIcon = ResourceManager.getInstance().getImage("patch_update_task.gif");
                break;
            }
            case 6: {
                oNodeIcon = ResourceManager.getInstance().getImage("software_upgrade_task.gif");
                break;
            }
            case 3: {
                oNodeIcon = ResourceManager.getInstance().getImage("simulation_package_upgrade_task.gif");
                break;
            }
            case 4: {
                oNodeIcon = ResourceManager.getInstance().getImage("package_upgrade_task.gif");
                break;
            }
            case 14: {
                oNodeIcon = ResourceManager.getInstance().getImage("package_upgrade_task.gif");
                break;
            }
            case 5: {
                oNodeIcon = ResourceManager.getInstance().getImage("package_diffusion_task.gif");
                break;
            }
            case 11: {
                oNodeIcon = ResourceManager.getInstance().getImage("package_diffusion_task.gif");
                break;
            }
            case 7: {
                oNodeIcon = ResourceManager.getInstance().getImage("olt_agent_upgrade_task.gif");
                break;
            }
        }
        return oNodeIcon;
    }
}

