/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.tasktable;

import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCSaveFileChooser;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.model.ActiveDevInfo;
import com.huawei.dc.taskmgmt.model.ActiveGroupInfo;
import com.huawei.dc.taskmgmt.model.ActiveInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.Task;
import com.swimap.iview.commstyle.resource.ResourceMng;
import gnu.trove.THashSet;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.Collator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TaskTableUtil {
    private static final String STRING_SUCCESS = ResourceManager.getInstance().getResString("OPERATION_SUCCESSFUL");
    private static final String STRING_MANUAL_GROUP_NAME = ResourceManager.getInstance().getResString("MANUAL_ACTIVATE_GROUP_NAME");
    private static boolean bInTaskSubTablePanel = false;
    private static final int DEFAULT_COLUMN_INDEX = 0;
    private static final String SEPERATOR = System.getProperty("line.separator");

    public static boolean isOnlySelResInSingleTask(DCSortableTreeTable oTaskTreeTable) {
        boolean bInSingleTask = true;
        int[] arrSelectedRows = oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return true;
        }
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        int iTaskID = -1;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData)) continue;
            oRowData = (TreeTableRowData)oNode.getUserObject();
            if (oRowData.getUserObject() instanceof ITask) {
                bInSingleTask = false;
                break;
            }
            if (oRowData.getUserObject() instanceof Resource) {
                Resource resource = (Resource)oRowData.getUserObject();
                if (3 == resource.getRoleType() && -1 != resource.getStackId()) {
                    bInSingleTask = false;
                    break;
                }
                if (resource.getFrameId() != -1 && resource.getSlotId() != -1) {
                    bInSingleTask = false;
                    break;
                }
                TreeTableRowData oP = (TreeTableRowData)((TreeTableNode)oNode.getParent()).getUserObject();
                int iTmpTaskId = ((ITask)oP.getUserObject()).getTaskId();
                if (-1 == iTaskID) {
                    iTaskID = iTmpTaskId;
                    continue;
                }
                if (iTmpTaskId == iTaskID) continue;
                bInSingleTask = false;
                break;
            }
            DCDebugTracer.trace("invalid node type");
        }
        return bInSingleTask;
    }

    public static boolean isAResourceOnlySelection(DCSortableTreeTable oTaskTreeTable) {
        boolean bState = true;
        int[] arrSelectedRows = oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath) {
                bState = false;
                continue;
            }
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            if (!(oNode.getUserObject() instanceof TreeTableRowData)) {
                return false;
            }
            oRowData = (TreeTableRowData)oNode.getUserObject();
            if (!(oRowData.getUserObject() instanceof Resource)) {
                return false;
            }
            Resource resource = (Resource)oRowData.getUserObject();
            if (3 == resource.getRoleType() && -1 != resource.getStackId()) {
                return false;
            }
            if (resource.getFrameId() == -1 || resource.getSlotId() == -1) continue;
            return false;
        }
        return bState;
    }

    public static boolean isABoardResourceOnlySelection(DCSortableTreeTable oTaskTreeTable) {
        int[] arrSelectedRows = oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath) continue;
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            if (!(oNode.getUserObject() instanceof TreeTableRowData)) {
                return false;
            }
            oRowData = (TreeTableRowData)oNode.getUserObject();
            if (!(oRowData.getUserObject() instanceof Resource)) {
                return false;
            }
            Resource resource = (Resource)oRowData.getUserObject();
            if (resource.getFrameId() != -1 || resource.getSlotId() != -1 || (3 != resource.getRoleType() || -1 != resource.getStackId()) && 3 == resource.getRoleType()) continue;
            return false;
        }
        return true;
    }

    public static int isADeviceNodeOnlySelection(DCSortableTreeTable oTaskTreeTable) {
        int devNodeForMimicPackageTask = 0;
        int devNodeForPackage = 0;
        int boardNodeForMimicPackageTask = 0;
        int boardNodeForPackage = 0;
        int[] arrSelectedRows = oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return 4;
        }
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        int count = arrSelectedRows.length;
        for (int i = 0; i < count; ++i) {
            TreePath oTreePath = oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath) continue;
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            oRowData = (TreeTableRowData)oNode.getUserObject();
            ITask oTask = TaskTableUtil.getTaskForTableNode(oNode);
            if (oTask.getSelectedDeviceType().getDeviceDomain() != 4) break;
            if (oRowData.getNodeType() == 2) {
                if (oTask.getTaskTypeId() == 3) {
                    ++devNodeForMimicPackageTask;
                    continue;
                }
                ++devNodeForPackage;
                continue;
            }
            if (oRowData.getNodeType() != 3) break;
            if (oTask.getTaskTypeId() == 3) {
                ++boardNodeForMimicPackageTask;
                continue;
            }
            ++boardNodeForPackage;
        }
        if (boardNodeForPackage == count) {
            return 3;
        }
        if (boardNodeForMimicPackageTask == count) {
            return 1;
        }
        if (devNodeForPackage == count) {
            return 2;
        }
        if (devNodeForMimicPackageTask == count) {
            return 0;
        }
        return 4;
    }

    public static boolean isATaskOnlySelection(DCSortableTreeTable oTaskTreeTable) {
        boolean bState = true;
        int[] arrSelectedRows = oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath) {
                bState = false;
                continue;
            }
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            if (!(oNode.getUserObject() instanceof TreeTableRowData)) {
                return false;
            }
            oRowData = (TreeTableRowData)oNode.getUserObject();
            if (oRowData.getUserObject() instanceof ITask) continue;
            return false;
        }
        return bState;
    }

    public static boolean isASingleTaskSelection(DCSortableTreeTable oTaskTreeTable) {
        int[] arrSelectedRows = oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        if (1 == arrSelectedRows.length) {
            return true;
        }
        TreePath oTreePath = oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[0]);
        TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
        ITask oBaseTask = TaskTableUtil.getTaskForTableNode(oNode);
        if (null == oBaseTask) {
            return false;
        }
        for (int i = 1; i < arrSelectedRows.length; ++i) {
            ITask oCurrentTask;
            oTreePath = oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || null != (oCurrentTask = TaskTableUtil.getTaskForTableNode(oNode = (TreeTableNode)oTreePath.getLastPathComponent())) && oBaseTask.equals(oCurrentTask)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyTaskPresentWithState(DCSortableTreeTable oTaskTreeTable, int iTaskState) {
        boolean bIsAnyTaskWithState = false;
        int[] arrSelectedRows = oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            ITask oTask;
            TreeTableRowData oRowData;
            TreeTableNode oNode;
            TreePath oTreePath = oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData) || !((oRowData = (TreeTableRowData)oNode.getUserObject()).getUserObject() instanceof ITask) || iTaskState != (oTask = (ITask)oRowData.getUserObject()).getTaskProgressInfo().getState()) continue;
            bIsAnyTaskWithState = true;
            break;
        }
        return bIsAnyTaskWithState;
    }

    public static boolean isAnyOtherResPresentExceptDomain(DCSortableTreeTable oTaskTreeTable, int iDeviceDomain) {
        boolean isAnyOtherResPresentExceptDomain = false;
        int[] arrSelectedRows = oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreeTableRowData oRowData;
            TreeTableNode oNode;
            TreePath oTreePath = oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData) || !((oRowData = (TreeTableRowData)oNode.getUserObject()).getUserObject() instanceof Resource)) continue;
            Resource oRes = (Resource)oRowData.getUserObject();
            DeviceInfo devInfo = DeviceInfoManagerImpl.getInstance().getDevice(oRes.getDeviceID());
            if (iDeviceDomain == devInfo.getDeviceTypeInfo().getDevDomain()) continue;
            isAnyOtherResPresentExceptDomain = true;
            break;
        }
        return isAnyOtherResPresentExceptDomain;
    }

    public static ITask getTaskForTableNode(TreeTableNode oNode) {
        if (null == oNode) {
            return null;
        }
        TreeTableRowData oRow = (TreeTableRowData)oNode.getUserObject();
        if (oRow != null && oRow.getUserObject() instanceof ITask) {
            return (ITask)oRow.getUserObject();
        }
        return TaskTableUtil.getTaskForTableNode((TreeTableNode)oNode.getParent());
    }

    public static TreeTableNode getOneTaskNodeByTask(DCSortableTreeTable oTaskTreeTable, ITask task) {
        TreeTableNode oNode = null;
        int[] arrSelectedRows = oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return null;
        }
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            ITask oTask;
            TreePath oTreePath = oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || (oTask = TaskTableUtil.getTaskForTableNode(oNode = (TreeTableNode)oTreePath.getLastPathComponent())).getTaskId() != task.getTaskId()) continue;
            return oNode;
        }
        DCDebugTracer.trace("DC::TaskTableUtil-getOneTaskNodeByTask:get oNode is null.");
        return null;
    }

    public static TreeTableNode getTaskNodeForOneNode(TreeTableNode oNode) {
        if (null == oNode) {
            return null;
        }
        TreeTableRowData oRow = (TreeTableRowData)oNode.getUserObject();
        if (oRow.getUserObject() instanceof ITask) {
            return oNode;
        }
        return TaskTableUtil.getTaskNodeForOneNode((TreeTableNode)oNode.getParent());
    }

    public static boolean isAutoActivateGroupSuccess(ITask oTask, TreeTableNode oTaskNodeData) {
        boolean isAutoActivateGroupComplete = false;
        if (oTask.getTaskTypeId() != 3) {
            return isAutoActivateGroupComplete;
        }
        ActiveInfo oActiveInfo = oTask.getActivationInfo();
        if (null == oActiveInfo) {
            return isAutoActivateGroupComplete;
        }
        Vector<ActiveGroupInfo> oAcGroup = oActiveInfo.getGroupList();
        int autoCount = 0;
        if (null == oAcGroup) {
            return isAutoActivateGroupComplete;
        }
        for (ActiveGroupInfo oGroupInfo : oAcGroup) {
            if (null == oGroupInfo || oGroupInfo.getGroupId() == Short.MAX_VALUE) continue;
            for (int i = 0; i < oGroupInfo.getActivationInfoLst().size(); ++i) {
                autoCount += ((ActiveDevInfo)oGroupInfo.getActivationInfoLst().get(i)).getBoardList().size();
            }
        }
        int i = 0;
        Enumeration<TreeNode> oChildren = oTaskNodeData.breadthFirstEnumeration();
        TreeTableRowData rowData = null;
        String sGroupName = null;
        String sDevOperID = null;
        String strOpeResult = null;
        Resource oDevResource = null;
        while (oChildren.hasMoreElements()) {
            Object oUserObject;
            DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)oChildren.nextElement();
            if (null == oNode || null == (oUserObject = oNode.getUserObject()) || !(oUserObject instanceof TreeTableRowData) || null == (rowData = (TreeTableRowData)oUserObject) || !(rowData.getUserObject() instanceof Resource) || null == rowData.getColumnData(4) || STRING_MANUAL_GROUP_NAME.equals(sGroupName = rowData.getColumnData(4).getCellDataValue().toString()) || !"ActivateSoftware".equals(sDevOperID = (oDevResource = (Resource)rowData.getUserObject()).getProgressInfo().getCurrentOperationId()) || null == rowData.getColumnData(8) || !STRING_SUCCESS.equals(strOpeResult = rowData.getColumnData(8).getCellDataValue().toString())) continue;
            ++i;
        }
        DCDebugTracer.trace("DC::+isAutoActivateGroupComplete()-i=" + i + "||autoCount=" + autoCount);
        return i == autoCount;
    }

    public static boolean isManualActivateGroupSuccess(ITask oTask, TreeTableNode oTaskNodeData) {
        boolean isManualActivateGroupComplete = false;
        if (oTask.getTaskTypeId() != 3) {
            return isManualActivateGroupComplete;
        }
        ActiveInfo oActiveInfo = oTask.getActivationInfo();
        if (null == oActiveInfo) {
            return isManualActivateGroupComplete;
        }
        int manualCount = 0;
        Vector<ActiveGroupInfo> oAcGroup = oActiveInfo.getGroupList();
        if (null == oAcGroup) {
            return isManualActivateGroupComplete;
        }
        for (ActiveGroupInfo oGroupInfo : oAcGroup) {
            if (null == oGroupInfo || oGroupInfo.getGroupId() != Short.MAX_VALUE) continue;
            for (int i = 0; i < oGroupInfo.getActivationInfoLst().size(); ++i) {
                manualCount += ((ActiveDevInfo)oGroupInfo.getActivationInfoLst().get(i)).getBoardList().size();
            }
        }
        int i = 0;
        Enumeration<TreeNode> oChildren = oTaskNodeData.breadthFirstEnumeration();
        TreeTableRowData rowData = null;
        String sGroupName = null;
        String sDevOperID = null;
        String strOpeResult = null;
        Resource oDevResource = null;
        while (oChildren.hasMoreElements()) {
            Object oUserObject;
            DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)oChildren.nextElement();
            if (null == oNode || null == (oUserObject = oNode.getUserObject()) || !(oUserObject instanceof TreeTableRowData) || null == (rowData = (TreeTableRowData)oUserObject) || !(rowData.getUserObject() instanceof Resource) || null == rowData.getColumnData(4)) continue;
            sGroupName = rowData.getColumnData(4).getCellDataValue().toString();
            if (!Collator.getInstance().equals(sGroupName, STRING_MANUAL_GROUP_NAME) || !"ActivateSoftware".equals(sDevOperID = (oDevResource = (Resource)rowData.getUserObject()).getProgressInfo().getCurrentOperationId()) || null == rowData.getColumnData(8) || !STRING_SUCCESS.equals(strOpeResult = rowData.getColumnData(8).getCellDataValue().toString())) continue;
            ++i;
        }
        DCDebugTracer.trace("DC::+isManualActivateGroupComplete()-i=" + i + "||autoCount=" + manualCount);
        return i == manualCount;
    }

    public static THashSet<Resource> getSelectedResources(DCSortableTreeTable oTaskTable) {
        if (null == oTaskTable || null == oTaskTable.getSelectedRows() || 0 == oTaskTable.getSelectedRows().length) {
            return null;
        }
        int[] arrSelectedRows = oTaskTable.getSelectedRows();
        THashSet oResourceList = new THashSet(arrSelectedRows.length);
        TreePath oTreePath = null;
        TreeTableNode oNode = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreeTableRowData oRow;
            oTreePath = oTaskTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || null == (oNode = (TreeTableNode)oTreePath.getLastPathComponent()) || (oRow = (TreeTableRowData)oNode.getUserObject()).getUserObject() instanceof ITask) continue;
            oResourceList.add((Object)((Resource)oRow.getUserObject()));
        }
        return oResourceList;
    }

    public static THashSet<Resource> getSelectedBoardResources(DCSortableTreeTable oTaskTable, Vector storageBoardLabelList) {
        if (null == oTaskTable || null == oTaskTable.getSelectedRows() || 0 == oTaskTable.getSelectedRows().length) {
            return null;
        }
        int[] arrSelectedRows = oTaskTable.getSelectedRows();
        THashSet oResourceList = new THashSet(arrSelectedRows.length);
        TreePath oTreePath = null;
        TreeTableNode oNode = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreeTableRowData oRow;
            oTreePath = oTaskTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || null == (oNode = (TreeTableNode)oTreePath.getLastPathComponent()) || (oRow = (TreeTableRowData)oNode.getUserObject()).getUserObject() instanceof ITask) continue;
            Vector<Object> boardLabel = new Vector<Object>();
            Resource temp = (Resource)oRow.getUserObject();
            IDeviceInfoManager oDeviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
            DeviceInfo deviceInfo = oDeviceInfoManager.getDevice(temp.getDeviceID());
            String boardIdName = oRow.toString();
            if (deviceInfo.getDeviceTypeInfo().isT2000Domain()) {
                try {
                    String[] boardInfo = boardIdName.split("_");
                    if (boardInfo != null && boardInfo.length > 0) {
                        temp.setSlotLabel(boardInfo[0]);
                        temp.setSlotId(Integer.parseInt(boardInfo[1]));
                    }
                }
                catch (Exception e) {
                    DCDebugTracer.traceError("TaskTableUtil#getSelectedBoardResources" + e.getMessage());
                    DCDebugTracer.trace(e);
                }
            }
            oResourceList.add((Object)temp);
            boardLabel.add(temp);
            boardLabel.add(boardIdName);
            storageBoardLabelList.add(boardLabel);
        }
        return oResourceList;
    }

    public static String breakLongToolTipText(String toolTipText, int iNumCharInOneRow) {
        int iLength = toolTipText.length();
        int iNumLines = iLength / iNumCharInOneRow + 1;
        String[] strToolTipList = new String[iNumLines];
        strToolTipList[0] = toolTipText.substring(0, iNumCharInOneRow - 1);
        for (int i = 1; i < iNumLines - 1; ++i) {
            strToolTipList[i] = toolTipText.substring(iNumCharInOneRow * i - 1, iNumCharInOneRow * i + iNumCharInOneRow - 1);
        }
        if (iNumLines > 1) {
            strToolTipList[iNumLines - 1] = toolTipText.substring(iNumCharInOneRow * (iNumLines - 1) - 1, iLength);
        }
        StringBuffer strHTMLToolTipText = new StringBuffer();
        strHTMLToolTipText.append("<html>");
        for (int count = 0; count < strToolTipList.length; ++count) {
            strHTMLToolTipText.append(strToolTipList[count]);
            strHTMLToolTipText.append("<br>");
        }
        strHTMLToolTipText.append("</html>");
        String strToolTipText = strHTMLToolTipText.toString();
        return strToolTipText;
    }

    public static TreeTableNode getNodeForResourceInTask(DCSortableTreeTable oTaskTable, Resource oResource, ITask oTask) {
        if (null == oResource || null == oTask || null == oTaskTable) {
            return null;
        }
        TreeTableNode oRoot = (TreeTableNode)oTaskTable.getTree().getModel().getRoot();
        int iTaskCount = oRoot.getChildCount();
        TreeTableNode oNode = null;
        for (int i = 0; i < iTaskCount; ++i) {
            oNode = (TreeTableNode)oRoot.getChildAt(i);
            if (null == oNode || null == oNode || !(oNode.getUserObject() instanceof ITask) || !oTask.equals(oNode.getUserObject())) continue;
            Enumeration<TreeNode> oChildNodes = oNode.depthFirstEnumeration();
            TreeTableNode oChildNode = null;
            while (oChildNodes.hasMoreElements()) {
                Resource oResourceInNode;
                oChildNode = (TreeTableNode)oChildNodes.nextElement();
                TreeTableRowData oChildRow = (TreeTableRowData)oChildNode.getUserObject();
                if (null == oChildRow || !(oChildRow.getUserObject() instanceof Resource) || !oResource.equals(oResourceInNode = (Resource)oChildRow.getUserObject())) continue;
                return oChildNode;
            }
        }
        return null;
    }

    public static boolean isAStackOnlySelection(DCSortableTreeTable oTaskTreeTable) {
        int[] arrSelectedRows = oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath) continue;
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            if (!(oNode.getUserObject() instanceof TreeTableRowData)) {
                return false;
            }
            oRowData = (TreeTableRowData)oNode.getUserObject();
            if (!(oRowData.getUserObject() instanceof Resource)) {
                return false;
            }
            Resource resource = (Resource)oRowData.getUserObject();
            if (3 == resource.getRoleType() && resource.getStackId() != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isTaskContainsTelnetDevice(DCSortableTreeTable oTaskTreeTable) {
        boolean bState = false;
        int[] arrSelectedRows = oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        ITask oTask = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath) continue;
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            if (!(oNode.getUserObject() instanceof TreeTableRowData)) {
                return false;
            }
            oRowData = (TreeTableRowData)oNode.getUserObject();
            if (!(oRowData.getUserObject() instanceof ITask)) {
                return false;
            }
            oTask = (ITask)oRowData.getUserObject();
            if (null == oTask) {
                return false;
            }
            if (!oTask.getDeviceType().isUpgradeModeSupportedByAnyOneOfDevice(4096)) continue;
            return true;
        }
        return bState;
    }

    public static int getSelectedTaskCount(DCSortableTreeTable oTaskTreeTable) {
        int iTaskCount = 0;
        int[] arrSelectedRows = oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return iTaskCount;
        }
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData) || !((oRowData = (TreeTableRowData)oNode.getUserObject()).getUserObject() instanceof ITask)) continue;
            ++iTaskCount;
        }
        return iTaskCount;
    }

    public static int getIndexOfTask(DCSortableTreeTable oTaskTreeTable) {
        int iTaskIndex = 0;
        int[] arrSelectedRows = oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return iTaskIndex;
        }
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        for (int i = 0; i < arrSelectedRows[0] + 1; ++i) {
            TreePath oTreePath = oTaskTreeTable.getTree().getPathForRow(i);
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            if (!(oNode.getUserObject() instanceof TreeTableRowData) || !((oRowData = (TreeTableRowData)oNode.getUserObject()).getUserObject() instanceof ITask)) continue;
            ++iTaskIndex;
        }
        return iTaskIndex;
    }

    public static int getTotalTaskCount(DCSortableTreeTable oTaskTreeTable) {
        int iTaskCount = 0;
        int allRows = oTaskTreeTable.getRowCount();
        if (0 == allRows) {
            return iTaskCount;
        }
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        for (int i = 0; i < allRows; ++i) {
            TreePath oTreePath = oTaskTreeTable.getTree().getPathForRow(i);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData) || !((oRowData = (TreeTableRowData)oNode.getUserObject()).getUserObject() instanceof ITask)) continue;
            ++iTaskCount;
        }
        return iTaskCount;
    }

    public static boolean isAllActiveGroupIsManualGroupInResource(Resource oResource, ITask oTask, DCSortableTreeTable oTaskTreeTable) {
        TreeTableNode resourceNode = TaskTableUtil.getNodeForResourceInTask(oTaskTreeTable, oResource, oTask);
        if (resourceNode == null) {
            return false;
        }
        int iCnt = resourceNode.getChildCount();
        for (int i = 0; i < iCnt; ++i) {
            TreeTableNode oChildNode = (TreeTableNode)resourceNode.getChildAt(i);
            if (oChildNode == null) {
                return false;
            }
            Object oUserObject = oChildNode.getUserObject();
            TreeTableRowData rowData = (TreeTableRowData)oUserObject;
            if (rowData == null) {
                return false;
            }
            String sGroupName = rowData.getColumnData(4).getCellDataValue().toString();
            if (StringUtils.isNullOrEmptyStr(sGroupName)) {
                return false;
            }
            if (!STRING_MANUAL_GROUP_NAME.equals(sGroupName)) continue;
            return false;
        }
        return true;
    }

    public static int getTaskOperStepOrder(ITask oTask, String operationId) {
        List<ITaskDeviceOperation> m_oTaskOpLst = oTask.getSupportedOperation();
        if (null == m_oTaskOpLst) {
            return -1;
        }
        for (int j = 0; j < m_oTaskOpLst.size(); ++j) {
            ITaskDeviceOperation operation = m_oTaskOpLst.get(j);
            if (!operationId.equals(operation.getOperationIdString())) continue;
            return j;
        }
        return -1;
    }

    public static boolean isRollbackEnableT2kPkgTask(DCSortableTreeTable oTaskTreeTable) {
        int[] arrSelectedRows = oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        if (!TaskTableUtil.isAResourceOnlySelection(oTaskTreeTable)) {
            return false;
        }
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        ITask oTask = null;
        int count = arrSelectedRows.length;
        for (int i = 0; i < count; ++i) {
            Resource resource;
            TreePath oTreePath = oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || null == (resource = (Resource)(oRowData = (TreeTableRowData)(oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject()).getUserObject()) || null == resource.getProgressInfo()) continue;
            oTask = TaskTableUtil.getTaskForTableNode(oNode);
            String currOperStringId = resource.getProgressInfo().getCurrentOperationId();
            int currOperStep = TaskTableUtil.getTaskOperStepOrder(oTask, currOperStringId);
            int commitOperStep = TaskTableUtil.getTaskOperStepOrder(oTask, "Commit");
            int loadSoftwareOperStep = TaskTableUtil.getTaskOperStepOrder(oTask, "LoadSoftware");
            if (loadSoftwareOperStep == -1) {
                return false;
            }
            if (commitOperStep == -1) {
                commitOperStep = currOperStep + 1;
            }
            if (currOperStep == -1) {
                if (!(currOperStringId.equals("Rollback") ? resource.getProgressInfo().getState() == 1 : StringUtils.isNullOrEmptyStr(currOperStringId))) continue;
                return false;
            }
            if (currOperStep < loadSoftwareOperStep) {
                return false;
            }
            if (loadSoftwareOperStep <= currOperStep && currOperStep <= commitOperStep) {
                int iResourePrgress = resource.getProgressInfo().getProgress();
                int iState = resource.getProgressInfo().getState();
                if (iResourePrgress == 0 && iState == 1) {
                    return false;
                }
                if (currOperStep == loadSoftwareOperStep) {
                    if (iState != 4) continue;
                    return false;
                }
                if (loadSoftwareOperStep < currOperStep && currOperStep < commitOperStep) {
                    DCDebugTracer.trace("Rollback true.currOperStringId = " + currOperStringId);
                    continue;
                }
                if (currOperStep != commitOperStep || iState == 4) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean isAnyResourceInProgressInTask(DCSortableTreeTable m_oTaskTreeTable) {
        if (0 == m_oTaskTreeTable.getRowCount()) {
            return false;
        }
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        for (int j = 0; j < arrSelectedRows.length; ++j) {
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[j]);
            TreeTableNode oTaskRoot = (TreeTableNode)oTreePath.getLastPathComponent();
            if (oTaskRoot == null || oTaskRoot.getUserObject() instanceof ITask) continue;
            int resourceCount = oTaskRoot.getChildCount();
            for (int i = 0; i < resourceCount; ++i) {
                TreeTableRowData oRow;
                TreeTableNode oResourceNode = (TreeTableNode)oTaskRoot.getChildAt(i);
                if (!oResourceNode.isLeaf()) {
                    int iBoardCount = oResourceNode.getChildCount();
                    for (int k = 0; k < iBoardCount; ++k) {
                        TreeTableNode oBoardNode = (TreeTableNode)oResourceNode.getChildAt(k);
                        TreeTableRowData oBoardRow = (TreeTableRowData)oBoardNode.getUserObject();
                        if (null == oBoardRow || !(oBoardRow.getUserObject() instanceof Resource)) {
                            return false;
                        }
                        Resource resource = (Resource)oBoardRow.getUserObject();
                        if (resource.getProgressInfo() == null || resource.getProgressInfo().getState() != 1) continue;
                        return false;
                    }
                }
                if (null == (oRow = (TreeTableRowData)oResourceNode.getUserObject()) || !(oRow.getUserObject() instanceof Resource)) {
                    return false;
                }
                Resource resource = (Resource)oRow.getUserObject();
                if (resource.getProgressInfo() == null || resource.getProgressInfo().getState() != 1) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean checkIsSelectAllDevInSameTask(DCSortableTreeTable m_oTaskTreeTable, ITask oTask) {
        if (!TaskTableUtil.isAResourceOnlySelection(m_oTaskTreeTable)) {
            return false;
        }
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 >= arrSelectedRows.length) {
            return false;
        }
        if (null == oTask || null == oTask.getDeviceType() || null == oTask.getDeviceType().getResources()) {
            return false;
        }
        THashSet<Resource> resList = oTask.getDeviceType().getResources();
        if (resList.size() <= 0) {
            return false;
        }
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        int findResCount = 0;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            Resource resource;
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || null == (resource = (Resource)(oRowData = (TreeTableRowData)(oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject()).getUserObject()) || !resList.contains((Object)resource)) continue;
            ++findResCount;
        }
        return findResCount == resList.size();
    }

    public static boolean isNextOprOfPostCheck(TreeTableNode oSelectedNode, String strCurrentOperation) {
        ITask oTask = TaskTableUtil.getTaskForTableNode(oSelectedNode);
        List<ITaskDeviceOperation> oTaskOprLst = oTask.getSupportedOperation();
        boolean isFindPostCheck = false;
        boolean isReturn = false;
        for (ITaskDeviceOperation oTaskOpr : oTaskOprLst) {
            String strOprId = oTaskOpr.getOperationIdString();
            if (oTaskOpr.isSelected() && "PostCheck".equals(strOprId)) {
                isFindPostCheck = true;
                continue;
            }
            if (!isFindPostCheck || !oTaskOpr.isSelected()) continue;
            if (!strCurrentOperation.equals(strOprId)) break;
            isReturn = true;
            break;
        }
        return isReturn;
    }

    public static boolean isNextOprOfPreCheck(TreeTableNode oSelectedNode, String strCurrentOperation) {
        ITask oTask = TaskTableUtil.getTaskForTableNode(oSelectedNode);
        List<ITaskDeviceOperation> oTaskOprLst = oTask.getSupportedOperation();
        boolean isFindCheck = false;
        boolean isReturn = false;
        for (ITaskDeviceOperation oTaskOpr : oTaskOprLst) {
            String strOprId = oTaskOpr.getOperationIdString();
            if (oTaskOpr.isSelected() && "PreCheck".equals(strOprId)) {
                isFindCheck = true;
                continue;
            }
            if (!isFindCheck || !oTaskOpr.isSelected()) continue;
            if (!strCurrentOperation.equals(strOprId)) break;
            isReturn = true;
            break;
        }
        return isReturn;
    }

    public static boolean isLastOperation(TreeTableNode oSelectedNode, String strOperationId) {
        ITask oTask = TaskTableUtil.getTaskForTableNode(oSelectedNode);
        List<ITaskDeviceOperation> oTaskOprLst = oTask.getSupportedOperation();
        boolean isFinalOpr = false;
        for (ITaskDeviceOperation oTaskOpr : oTaskOprLst) {
            if (strOperationId.equals(oTaskOpr.getOperationIdString())) {
                isFinalOpr = true;
                continue;
            }
            if (!isFinalOpr || !oTaskOpr.isSelected()) continue;
            isFinalOpr = false;
            break;
        }
        return isFinalOpr;
    }

    public static Map<Integer, THashSet<Resource>> getTaskIdAndDevLstMap(DCSortableTreeTable oTaskTable) {
        HashMap<Integer, THashSet<Resource>> taskAndDevLstMap = new HashMap<Integer, THashSet<Resource>>();
        if (null == oTaskTable || null == oTaskTable.getSelectedRows() || 0 == oTaskTable.getSelectedRows().length) {
            return taskAndDevLstMap;
        }
        int[] arrSelectedRows = oTaskTable.getSelectedRows();
        TreePath oTreePath = null;
        TreeTableNode oNode = null;
        boolean isTaskObj = false;
        Task oTask = null;
        Integer oTaskId = Integer.MIN_VALUE;
        THashSet oResSet = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            boolean isolationTask;
            TreeTableRowData oRow;
            oTreePath = oTaskTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || null == (oNode = (TreeTableNode)oTreePath.getLastPathComponent()) || !(isTaskObj = (oRow = (TreeTableRowData)oNode.getUserObject()).getUserObject() instanceof Task) || (isolationTask = IsolationCommonOperation.isIsolationTask((oTask = (Task)oRow.getUserObject()).getTaskTypeId())) || taskAndDevLstMap.containsKey(oTaskId = Integer.valueOf(oTask.getTaskId()))) continue;
            oResSet = new THashSet();
            taskAndDevLstMap.put(oTaskId, (THashSet<Resource>)oResSet);
            TaskTableUtil.getFailResInTask(oTask, (THashSet<Resource>)oResSet);
        }
        return taskAndDevLstMap;
    }

    private static void getFailResInTask(Task oTask, THashSet<Resource> oResSet) {
        DeviceType oDecType = oTask.getDeviceType();
        THashSet<Resource> resLst = oDecType.getResources();
        if (null != resLst) {
            for (Resource res : resLst) {
                if (!res.isFailed()) continue;
                oResSet.add((Object)res);
            }
        }
    }

    public static int convertColumnIndexToModel(int iColumn, String modelName) {
        if (DCFrameWorkUtil.getDCModuleManager().getDeviceOperationPanel() != null && modelName.equals("device_main_table") && DCFrameWorkUtil.getDeviceTablePanel().getTreeTable().getColumnModel().getColumnCount() > iColumn) {
            return DCFrameWorkUtil.getDeviceTablePanel().getTreeTable().getColumnModel().getColumn(iColumn).getModelIndex();
        }
        if (DCFrameWorkUtil.getDCModuleManager().getTaskMgrMainPanel() != null && modelName.equals("task_main_table") && DCFrameWorkUtil.getTaskTablePanel().getTaskTreeTable().getColumnModel().getColumnCount() > iColumn) {
            return DCFrameWorkUtil.getTaskTablePanel().getTaskTreeTable().getColumnModel().getColumn(iColumn).getModelIndex();
        }
        return iColumn;
    }

    public static void setbInTaskSubTablePanel(boolean bValue) {
        bInTaskSubTablePanel = bValue;
    }

    public static boolean getbInTaskSubTablePanel() {
        return bInTaskSubTablePanel;
    }

    public static void exportAlarmDevices(final DCSortableTreeTable m_oDeviceTreeTable) {
        String defaultFileName = ResourceManager.getInstance().getResString("ALARM_NE") + "-" + StringUtils.getStrNowTime("yyyy_MM_dd-HH_mm_ss");
        DCSaveFileChooser oExportFileChooser = TaskTableUtil.initExportDialog(defaultFileName, 2);
        int iRetVal = -1;
        iRetVal = oExportFileChooser.showSaveDialog(DCFrameWorkUtil.getMainFrame());
        if (iRetVal == 0) {
            boolean isSuccess;
            File file;
            if (null == oExportFileChooser.getSelectedFile()) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SELECT_FILES"), ResourceManager.getInstance().getResString("ERROR"), 0);
                return;
            }
            String strFileName = oExportFileChooser.getSelectedFile().getAbsolutePath();
            if (strFileName.length() > 1 && !strFileName.toLowerCase(ResourceMng.getInstance().getLocale()).endsWith(".csv")) {
                strFileName = strFileName + ".csv";
            }
            if ((file = new File(strFileName)).exists() && file.isFile() && !(isSuccess = file.delete())) {
                DCDebugTracer.trace("fail to delete file<" + file.getAbsolutePath() + ">");
            }
            Thread exportAlarmDeviceThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FileOutputStream outputSteam = null;
                    Writer fileWriter = null;
                    StringBuffer strBuf = new StringBuffer();
                    strBuf.append(ResourceManager.getInstance().getResString("DEVICE_NAME")).append(SEPERATOR);
                    try {
                        strBuf = TaskTableUtil.getDevNameOfSelectedRow(m_oDeviceTreeTable, strBuf);
                        outputSteam = new FileOutputStream(file.getAbsolutePath());
                        fileWriter = new OutputStreamWriter((OutputStream)outputSteam, FileUtil.getSystemEncoding());
                        fileWriter.write(strBuf.toString());
                        fileWriter.close();
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("FILE_EXPORT_ALARM_SUCCESSFULLY", new String[]{String.valueOf(m_oDeviceTreeTable.getSelectedRows().length)}), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
                    }
                    catch (Exception be) {
                        boolean isSuccess;
                        DCDebugTracer.trace(be);
                        if (file.exists() && file.isFile() && !(isSuccess = file.delete())) {
                            DCDebugTracer.trace("fail to delete file<" + file.getAbsolutePath() + ">");
                        }
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("FILE_EXPORT_FAILED"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
                    }
                    finally {
                        try {
                            if (fileWriter != null) {
                                fileWriter.close();
                            }
                            if (outputSteam != null) {
                                outputSteam.close();
                            }
                        }
                        catch (IOException e) {
                            DCDebugTracer.trace(e);
                        }
                    }
                }
            };
            exportAlarmDeviceThread.setName("exportAlarmDeviceThread");
            exportAlarmDeviceThread.start();
        }
    }

    private static DCSaveFileChooser initExportDialog(String defaultFileName, int fileFilter) {
        PrintSupportor.setIsFileSelection(false);
        DCSaveFileChooser oFileChooserDialog = new DCSaveFileChooser();
        oFileChooserDialog.setTitle(ResourceManager.getInstance().getResString("EXPORT_DEVICE_INFO"));
        DCHelpManager.getInstance().enableF1HelpKey((Component)((Object)oFileChooserDialog), "HELP_TOPIC_NE_EXPORT");
        oFileChooserDialog.setFileFilter(fileFilter);
        oFileChooserDialog.setAcceptAllFileFilterUsed(false);
        oFileChooserDialog.setSelectedFile(new File(defaultFileName));
        return oFileChooserDialog;
    }

    private static StringBuffer getDevNameOfSelectedRow(DCSortableTreeTable m_oDeviceTreeTable, StringBuffer strBuf) {
        int[] arrSelectedRows = m_oDeviceTreeTable.getSelectedRows();
        for (int iSeletedRowIndex = 0; iSeletedRowIndex < arrSelectedRows.length; ++iSeletedRowIndex) {
            JTree tree = m_oDeviceTreeTable.getTree();
            TreeTableNode tmpNode = (TreeTableNode)tree.getPathForRow(arrSelectedRows[iSeletedRowIndex]).getLastPathComponent();
            strBuf.append(tmpNode.getUserObject().toString()).append(SEPERATOR);
        }
        return strBuf;
    }
}

