/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.tasktable;

import com.huawei.dc.common.components.treetable.model.TreeTableCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableNodeCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.controller.AbstractDeviceInfoManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperation;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.model.ActiveBoardInfo;
import com.huawei.dc.taskmgmt.model.ActiveDevInfo;
import com.huawei.dc.taskmgmt.model.ActiveGroupInfo;
import com.huawei.dc.taskmgmt.model.ActiveInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.LoadSimPackageBoardInfo;
import com.huawei.dc.taskmgmt.model.LoadSimPackageDevInfo;
import com.huawei.dc.taskmgmt.model.LoadSimPackageFileInfo;
import com.huawei.dc.taskmgmt.model.LoadSimPackageInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import gnu.trove.THashSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TaskTablePanelUtil {
    private IDeviceInfoManager m_oDevInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
    public static final int TASK_TABLE_COLUMN_SIZE = 9;
    public static final int TASK_NAME_COLUMN_INDEX = 0;
    public static final int DEVICE_IP_COLUMN_INDEX = 1;
    public static final int RESOURVE_TYPE_COLUMN_INDEX = 2;
    public static final int PACKAGE_STATUS_COLUMN_INDEX = 3;
    public static final int GROUP_ID_COLUMN_INDEX = 4;
    public static final int ORIGINAL_VERSION_COLUMN_INDEX = 5;
    public static final int UPGRADE_VERSION_COLUMN_INDEX = 6;
    public static final int OPERATION_COLUMN_INDEX = 7;
    public static final int OPERATION_STATUS_COLUMN_INDEX = 8;

    protected void createStackResourceNodeInTable(Resource oResource, ITask oTask, TreeTableNode oTaskNode) {
        if (-1 == oResource.getStackId()) {
            TreeTableRowData oDevRow = new TreeTableRowData(9, 2);
            oDevRow.setUserObject(oResource);
            DeviceInfo devInfo = this.m_oDevInfoManager.getDevice(oResource.getDeviceID());
            if (null == devInfo) {
                return;
            }
            DeviceTypeInfo devTypeInfo = devInfo.getDeviceTypeInfo();
            TreeTableNodeCellData oDevNameCell = new TreeTableNodeCellData(oResource.getDeviceName());
            TreeTableCellData oDevIpCell = new TreeTableCellData(StringUtils.getShowIP(oResource.getDeviceIP()));
            TreeTableCellData oSourceTypeCell = new TreeTableCellData(devTypeInfo.getDevTypeName());
            ResourceProgressInfo oProgressInfo = oResource.getProgressInfo();
            TreeTableCellData swdlStatusCell = null;
            swdlStatusCell = devTypeInfo.isT2000Domain() ? new TreeTableCellData(oProgressInfo.getSWDLStatus()) : new TreeTableCellData("--");
            TreeTableCellData oDevOperationCell = new TreeTableCellData(oProgressInfo);
            TreeTableCellData oDevOperationStatusCell = new TreeTableCellData(oProgressInfo);
            oDevRow.setColumnData(0, oDevNameCell);
            oDevRow.setColumnData(1, oDevIpCell);
            oDevRow.setColumnData(2, oSourceTypeCell);
            oDevRow.setColumnData(7, oDevOperationCell);
            oDevRow.setColumnData(8, oDevOperationStatusCell);
            oDevRow.setColumnData(3, swdlStatusCell);
            List<ITaskDeviceOperation> operationList = oTask.getSupportedOperation();
            int count = operationList.size();
            block0: for (int i = 0; i < count; ++i) {
                ITaskDeviceOperation operation = operationList.get(i);
                if (operation.getOperationId() != 8) continue;
                ActivationConfigPara activateConf = (ActivationConfigPara)operation.getConfiguredPara();
                List<ActivationGroupInfo> activateList = activateConf.getActivateGroupInfoLst();
                if (activateList == null || activateList.size() <= 0) break;
                List elementList = activateConf.getElementInfoLst();
                int elementSize = elementList.size();
                for (int j = 0; j < elementSize; ++j) {
                    ActivationElementInfo elementInfo = (ActivationElementInfo)elementList.get(j);
                    Resource e_oResource = elementInfo.getResource();
                    if (e_oResource.getDeviceID() != oResource.getDeviceID()) continue;
                    TreeTableCellData oGroupId = new TreeTableCellData(ResourceManager.getInstance().getResString(ResourceManager.getInstance().getResString("GROUP") + elementInfo.getGroupId()));
                    oDevRow.setColumnData(4, oGroupId);
                    continue block0;
                }
            }
            TreeTableNode oDevNode = new TreeTableNode(oDevRow);
            oDevNameCell.setAttachedTreeNode(oDevNode);
            oTaskNode.add(oDevNode);
        }
    }

    protected void createBoardNodesInTable(Resource oResource, ITask oTask, TreeTableNode oNode) {
        int devId = oResource.getDeviceID();
        ActiveInfo activeInfo = oTask.getActivationInfo();
        if (activeInfo == null) {
            LoadSimPackageInfo loadPackageInfo = oTask.getLoadSimPackageInfo();
            if (loadPackageInfo != null) {
                Vector devList = loadPackageInfo.getDevList();
                int devCount = devList.size();
                for (int i = 0; i < devCount; ++i) {
                    LoadSimPackageDevInfo devInfo = (LoadSimPackageDevInfo)devList.get(i);
                    if (devId != devInfo.getDevId()) continue;
                    Vector boardList = devInfo.getBoardList();
                    int boardCount = boardList.size();
                    for (int j = 0; j < boardCount; ++j) {
                        LoadSimPackageBoardInfo boardInfo = (LoadSimPackageBoardInfo)boardList.get(j);
                        TreeTableNode oBoardNode = this.createBoardNodeInTable(oResource, oTask, boardInfo, -1);
                        if (oBoardNode == null) continue;
                        oNode.add(oBoardNode);
                    }
                }
            }
            return;
        }
        Vector<ActiveGroupInfo> groupList = activeInfo.getGroupList();
        int groupCount = groupList.size();
        for (int i = 0; i < groupCount; ++i) {
            ActiveGroupInfo groupInfo = groupList.get(i);
            Vector devList = groupInfo.getActivationInfoLst();
            int group = groupInfo.getGroupId();
            int devCount = devList.size();
            for (int j = 0; j < devCount; ++j) {
                ActiveDevInfo devInfo = (ActiveDevInfo)devList.get(j);
                if (devInfo.getDevId() != devId) continue;
                Vector boardList = devInfo.getBoardList();
                int boardCount = boardList.size();
                for (int l = 0; l < boardCount; ++l) {
                    ActiveBoardInfo boardInfo = (ActiveBoardInfo)boardList.get(l);
                    TreeTableNode oBoardNode = this.createBoardNodeInTable(oResource, oTask, boardInfo, group);
                    if (oBoardNode == null) continue;
                    oNode.add(oBoardNode);
                }
            }
        }
    }

    public LoadSimPackageBoardInfo getBoardInfo(ITask oTask, int iDevID, int iSlotID) {
        LoadSimPackageBoardInfo oLoadSimPackageBoardInfo = new LoadSimPackageBoardInfo();
        if (null == oTask) {
            return oLoadSimPackageBoardInfo;
        }
        LoadSimPackageInfo oLoadSimPackageInfo = oTask.getLoadSimPackageInfo();
        if (null == oLoadSimPackageInfo) {
            return oLoadSimPackageBoardInfo;
        }
        Vector devVector = oLoadSimPackageInfo.getDevList();
        for (LoadSimPackageDevInfo devInfo : devVector) {
            if (null == devInfo || devInfo.getDevId() != iDevID) continue;
            Vector boardVector = devInfo.getBoardList();
            for (LoadSimPackageBoardInfo boardInfo : boardVector) {
                if (null == boardInfo || boardInfo.getSlotId() != iSlotID) continue;
                return boardInfo;
            }
        }
        return oLoadSimPackageBoardInfo;
    }

    private Resource getSimPackageBoard(Resource oResource, THashSet<Resource> m_oResources, LoadSimPackageBoardInfo oBoardInfo) {
        Resource m_oResource = null;
        Iterator oResItor = m_oResources.iterator();
        Resource resource = null;
        while (oResItor.hasNext()) {
            resource = (Resource)oResItor.next();
            if (null == resource || resource.getDeviceID() != oResource.getDeviceID() || resource.getSlotId() != oBoardInfo.getSlotId()) continue;
            m_oResource = resource;
            m_oResource.setOriginalVersion(oBoardInfo.getBoardOriginalVersion());
            m_oResource.setUpgradeVersion(oBoardInfo.getBoardUpgradeVersion());
            break;
        }
        return m_oResource;
    }

    private Resource getBoard(Resource oResource, THashSet<Resource> m_oResources, int iSlotID) {
        Resource m_oResource = null;
        Iterator oResItor = m_oResources.iterator();
        Resource resource = null;
        while (oResItor.hasNext()) {
            resource = (Resource)oResItor.next();
            if (null == resource || resource.getDeviceID() != oResource.getDeviceID() || resource.getSlotId() != iSlotID) continue;
            m_oResource = resource;
            break;
        }
        return m_oResource;
    }

    private TreeTableNode createBoardNodeInTable(Resource oResource, ITask oTask, Object boardInfo, int group) {
        Serializable oBoardInfo;
        AbstractDeviceInfoManager oDeviceInfoMgr = (AbstractDeviceInfoManager)DeviceInfoManagerImpl.getInstance();
        TreeTableRowData oBoardRow = new TreeTableRowData(9, 3);
        DeviceType oTemDeviceType = oTask.getTemporaryDevType();
        THashSet<Resource> m_oResources = oTemDeviceType.getResources();
        Resource m_oResource = null;
        TreeTableNodeCellData oDevNameCell = null;
        if (boardInfo instanceof ActiveBoardInfo) {
            oBoardInfo = (ActiveBoardInfo)boardInfo;
            m_oResource = this.getBoard(oResource, m_oResources, ((ActiveBoardInfo)oBoardInfo).getSlotId());
            if (m_oResource == null) {
                return null;
            }
            List<ITaskDeviceOperation> oSupportedOperationLst = oTask.getSupportedOperation();
            int iSizeOfLst = oSupportedOperationLst.size();
            boolean isSelectActivation = true;
            for (int i = 0; i < iSizeOfLst; ++i) {
                ITaskDeviceOperation oTaskDevOp = oSupportedOperationLst.get(i);
                if (oTaskDevOp.isSelected() || !(oTaskDevOp instanceof ActivationOperation)) continue;
                isSelectActivation = false;
            }
            if (isSelectActivation) {
                m_oResource.setBoardResetType(((ActiveBoardInfo)oBoardInfo).getActiveDeviceMode());
            } else {
                m_oResource.setBoardResetType(0);
            }
            oBoardRow.setUserObject(m_oResource);
            oDevNameCell = new TreeTableNodeCellData(((ActiveBoardInfo)oBoardInfo).getSlotLabel() + '_' + oDeviceInfoMgr.getBoardNameForT2000(((ActiveBoardInfo)oBoardInfo).getSlotId()));
            TreeTableCellData oSourceTypeCell = new TreeTableCellData(((ActiveBoardInfo)oBoardInfo).getResourceType());
            String sGroup = "";
            sGroup = Short.MAX_VALUE == group ? ResourceManager.getInstance().getResString("MANUAL_ACTIVATE_GROUP_NAME") : ResourceManager.getInstance().getResString(ResourceManager.getInstance().getResString("GROUP") + group);
            TreeTableCellData oGroupId = new TreeTableCellData(sGroup);
            LoadSimPackageBoardInfo oBoardInfoContainsVersrion = this.getBoardInfo(oTask, oResource.getDeviceID(), ((ActiveBoardInfo)oBoardInfo).getSlotId());
            TreeTableCellData oOriginalVerCell = new TreeTableCellData(oBoardInfoContainsVersrion.getBoardOriginalVersion());
            TreeTableCellData oUpgradeVerCell = new TreeTableCellData(oBoardInfoContainsVersrion.getBoardUpgradeVersion());
            ResourceProgressInfo oProgressInfo = m_oResource.getProgressInfo();
            TreeTableCellData oDevOperationCell = new TreeTableCellData(oProgressInfo);
            TreeTableCellData oDevOperationStatusCell = new TreeTableCellData(oProgressInfo);
            TreeTableCellData swdlStatusCell = new TreeTableCellData(oProgressInfo.getSWDLStatus());
            oBoardRow.setColumnData(0, oDevNameCell);
            oBoardRow.setColumnData(2, oSourceTypeCell);
            oBoardRow.setColumnData(7, oDevOperationCell);
            oBoardRow.setColumnData(8, oDevOperationStatusCell);
            oBoardRow.setColumnData(3, swdlStatusCell);
            oBoardRow.setColumnData(5, oOriginalVerCell);
            oBoardRow.setColumnData(6, oUpgradeVerCell);
            oBoardRow.setColumnData(4, oGroupId);
        } else {
            oBoardInfo = (LoadSimPackageBoardInfo)boardInfo;
            boolean ifToBeLoad = false;
            ifToBeLoad = this.isFileToBeLoaded((LoadSimPackageBoardInfo)oBoardInfo);
            if (!ifToBeLoad) {
                return null;
            }
            m_oResource = this.getSimPackageBoard(oResource, m_oResources, (LoadSimPackageBoardInfo)oBoardInfo);
            if (m_oResource == null) {
                return null;
            }
            oBoardRow.setUserObject(m_oResource);
            oDevNameCell = new TreeTableNodeCellData(((LoadSimPackageBoardInfo)oBoardInfo).getSlotLabel() + '_' + oDeviceInfoMgr.getBoardNameForT2000(((LoadSimPackageBoardInfo)oBoardInfo).getSlotId()));
            TreeTableCellData oSourceTypeCell = new TreeTableCellData(((LoadSimPackageBoardInfo)oBoardInfo).getResourceType());
            ResourceProgressInfo oProgressInfo = m_oResource.getProgressInfo();
            TreeTableCellData oDevOperationCell = new TreeTableCellData(oProgressInfo);
            TreeTableCellData oDevOperationStatusCell = new TreeTableCellData(oProgressInfo);
            TreeTableCellData swdlStatusCell = new TreeTableCellData(oProgressInfo.getSWDLStatus());
            TreeTableCellData oOriginalVerCell = new TreeTableCellData(m_oResource.getOriginalVersion());
            TreeTableCellData oUpgradeVerCell = new TreeTableCellData(m_oResource.getUpgradeVersion());
            oBoardRow.setColumnData(0, oDevNameCell);
            oBoardRow.setColumnData(2, oSourceTypeCell);
            oBoardRow.setColumnData(5, oOriginalVerCell);
            oBoardRow.setColumnData(3, swdlStatusCell);
            oBoardRow.setColumnData(6, oUpgradeVerCell);
            oBoardRow.setColumnData(7, oDevOperationCell);
            oBoardRow.setColumnData(8, oDevOperationStatusCell);
        }
        TreeTableNode oBoardNode = new TreeTableNode(oBoardRow);
        oDevNameCell.setAttachedTreeNode(oBoardNode);
        return oBoardNode;
    }

    private boolean isFileToBeLoaded(LoadSimPackageBoardInfo oBoardInfo) {
        boolean ifToBeLoad = false;
        Vector fileList = oBoardInfo.getFileList();
        int filesCount = fileList.size();
        for (int n = 0; n < filesCount; ++n) {
            LoadSimPackageFileInfo fileInfo = (LoadSimPackageFileInfo)fileList.get(n);
            if (fileInfo.getToBeLoad() == 0) continue;
            ifToBeLoad = true;
            break;
        }
        return ifToBeLoad;
    }
}

