/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.tasktable;

import com.huawei.dc.common.MyMouseMotionAdapter;
import com.huawei.dc.common.asndatacenter.AsnDCErrorCodeInfo;
import com.huawei.dc.common.asndatacenter.AsnDCLoadTaskDeviceInfo;
import com.huawei.dc.common.asndatacenter.AsnDCMainBoardNum;
import com.huawei.dc.common.asndatacenter.AsnDCMainBoardNumRsp;
import com.huawei.dc.common.asndatacenter.AsnDCSWDLStatusNotify;
import com.huawei.dc.common.asndatacenter.AsnToleranceSearchRsp;
import com.huawei.dc.common.components.deviceselection.DeviceSelectionPanel;
import com.huawei.dc.common.components.dialog.CommonProgressDlg;
import com.huawei.dc.common.components.dialog.SimpleProgressDlg;
import com.huawei.dc.common.components.treetable.model.DCTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableComparator;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableNodeCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.components.treetable.view.DCTreeTableCellRenderer;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.dcmodule.DataCenterModuleManager;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.event.TaskTreeSelectionEvent;
import com.huawei.dc.common.framework.interfaces.DCEventRegisterInterface;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpForErrCodeUtil;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.MenuUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupInfo;
import com.huawei.dc.devicemanagement.deviceoperation.loadpatch.LoadPatchOperation;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.LoadSoftwareOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.PrepareUpgradeOperation;
import com.huawei.dc.devicemanagement.deviceview.common.DeviceTreeTableDataSelectionEventObject;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTablePanel;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.devicemanagement.model.deviceinfo.VisualData;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.huawei.dc.standalone.view.RouterDevInfoPanel;
import com.huawei.dc.taskmgmt.controller.ITaskNotificationListener;
import com.huawei.dc.taskmgmt.controller.LogInfoNotifier;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskEventID;
import com.huawei.dc.taskmgmt.controller.TaskInfoNotifier;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.isolation.view.IsolationTaskInfoPanel;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.ITaskDataModel;
import com.huawei.dc.taskmgmt.model.ITaskGroup;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.model.TaskModelUtil;
import com.huawei.dc.taskmgmt.model.TaskProgressInfo;
import com.huawei.dc.taskmgmt.view.common.TaskManagementPopupMenuManager;
import com.huawei.dc.taskmgmt.view.common.TaskMenuItemHandler;
import com.huawei.dc.taskmgmt.view.createtask.ViewCommandResultDialog;
import com.huawei.dc.taskmgmt.view.tasktable.MyCellRenderer;
import com.huawei.dc.taskmgmt.view.tasktable.ProgressInfoCellRenderer;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTablePanelUtil;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTableUtil;
import com.huawei.dc.taskmgmt.view.tasktree.TaskTreeNodeInfo;
import com.huawei.u2000.component.table.customize.TableCustomizer;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import gnu.trove.THashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TaskTablePanel
extends JPanel
implements DCTreeEventListener,
ITaskNotificationListener,
DCEventRegisterInterface {
    private static final long serialVersionUID = 1L;
    private DCSortableTreeTable m_oTaskTreeTable;
    private DCTreeTableModel m_oTaskTreeTableModel;
    private TreeTableNode m_oRootNode;
    private JTree m_oTaskTree;
    private JScrollPane m_oScrollPane;
    private TaskManagementPopupMenuManager m_oPopupMenuManager;
    private TaskTreeNodeInfo m_oSelectedTaskTreeNodeInfo;
    private TaskMenuItemHandler m_oTaskMenuItemHandler;
    private TaskTreeSelectionEvent m_oCurrentTreeSelectionEvent;
    private List m_oListeners;
    private IDeviceInfoManager m_oDevInfoManager;
    private CommonProgressDlg m_oCommProgressDlg = null;
    private DeviceSelectionPanel m_oDeviceSelectionPanel = null;
    private Object m_oSynObject = new Object();
    private List<AsnDCLoadTaskDeviceInfo> deviceInfoList = null;
    private DataCenterModuleManager m_dcModuleMgr;
    private SimpleProgressDlg m_oGettingTaskLstProgressDlg = null;
    private boolean m_bGettingTaskInfo = false;
    private boolean bIsDevInTaskSubOperation = false;
    private TaskTablePanelUtil m_oTaskTablePanelUtil = new TaskTablePanelUtil();
    private TaskTreeNodeInfo m_oCurrentSelectedNodeInfo;

    public TaskTablePanel(DataCenterModuleManager dcModuleMgr) {
        this.jInit();
        this.m_dcModuleMgr = dcModuleMgr;
        this.m_oDevInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
        this.populateAllTasksFromDataModel();
        this.updateTableView();
    }

    private void jInit() {
        this.m_oListeners = new Vector(16);
        this.createTreeTable();
        this.initializeDeleteKeyEventHandler();
        this.m_oScrollPane = new JScrollPane((Component)((Object)this.m_oTaskTreeTable));
        this.m_oScrollPane.setName("TaskMgmt_TaskTablePanelPanel_m_oScrollPane");
        this.m_oScrollPane.getViewport().addMouseListener(this.generateMouseAdapterForTable());
        this.add(this.m_oScrollPane);
        this.setLayout(new GridLayout());
        Border oBorder = BorderFactory.createEtchedBorder(Color.gray, Color.white);
        this.setBorder(oBorder);
        this.setFocusable(true);
    }

    private void createTreeTable() {
        this.createTreeTableModel();
        this.m_oTaskTreeTable = new DCSortableTreeTable(this.m_oTaskTreeTableModel);
        this.m_oTaskTreeTable.setName("TaskMgmt_TaskTablePanelPanel_m_oTaskTreeTable");
        this.m_oTaskTreeTableModel.setFlag("task_main_table");
        this.initializeTreeTable();
        TableCustomizer oTableCustomizer = new TableCustomizer((JTable)((Object)this.m_oTaskTreeTable), "conf/dc/task_table.xml");
        TableColumn[] oTableColumns = new TableColumn[]{this.m_oTaskTreeTable.getColumnModel().getColumn(0)};
        oTableCustomizer.setNotAllowCustomizedColumns(Arrays.asList(oTableColumns));
        if (DCFrameWorkUtil.getIsSingleClient() && StandAloneDomainInfo.getInstance().getSelectedDomain() != 4) {
            this.m_oTaskTreeTable.getColumnModel().getColumn(3).setMaxWidth(0);
            this.m_oTaskTreeTable.getColumnModel().getColumn(3).setMinWidth(0);
            this.m_oTaskTreeTable.getColumnModel().getColumn(3).setPreferredWidth(0);
            this.m_oTaskTreeTable.getColumnModel().getColumn(3).setResizable(false);
        }
    }

    private void initializeTreeTable() {
        this.m_oTaskTree = this.m_oTaskTreeTable.getTree();
        this.m_oTaskTree.setName("TaskMgmt_TaskTablePanelPanel_m_oTaskTree");
        this.m_oTaskTreeTable.getTableHeader().setReorderingAllowed(false);
        TableColumn oFirstColumn = this.m_oTaskTreeTable.getColumnModel().getColumn(0);
        oFirstColumn.setMinWidth(40);
        oFirstColumn.setPreferredWidth(180);
        this.m_oTaskTree.setToggleClickCount(2);
        this.initializeCellRenderers();
        this.initializeMouseAdapters();
        this.m_oTaskMenuItemHandler = new TaskMenuItemHandler(this);
        this.m_oPopupMenuManager = new TaskManagementPopupMenuManager(this.m_oTaskTreeTable, this.m_oTaskMenuItemHandler);
        this.m_oTaskTreeTable.setRowHeight(20);
        this.m_oTaskTreeTable.setColumnSelectionAllowed(false);
        this.m_oTaskTreeTable.setRowSelectionAllowed(true);
    }

    private void initializeCellRenderers() {
        this.m_oTaskTree.setCellRenderer(new MyCellRenderer(this.m_oTaskTreeTable));
        TableColumnModel oColumnModel = this.m_oTaskTreeTable.getColumnModel();
        DCTreeTableCellRenderer oIPRenderer = new DCTreeTableCellRenderer(this.m_oTaskTreeTable, 2);
        oIPRenderer.setBorder(null);
        oColumnModel.getColumn(1).setCellRenderer(oIPRenderer);
        DCTreeTableCellRenderer oDefaultRenderer = new DCTreeTableCellRenderer(this.m_oTaskTreeTable, 2);
        oDefaultRenderer.setBorder(null);
        for (int i = 2; i <= 7; ++i) {
            oColumnModel.getColumn(i).setCellRenderer(oDefaultRenderer);
        }
        this.m_oTaskTreeTable.getColumnModel().getColumn(8).setCellRenderer(new ProgressInfoCellRenderer(this.m_oTaskTreeTable, 0));
    }

    private void notifyDataSelectionEvent() {
        this.notifyEvent(new DeviceTreeTableDataSelectionEventObject((Object)this.m_oTaskTreeTable));
    }

    private void createTreeTableModel() {
        ResourceManager oResManager = ResourceManager.getInstance();
        String[] strColumnNames = new String[]{oResManager.getResString("TASK_TABLE_COLUMN_RESOURCE_NAME"), oResManager.getResString("TASK_TABLE_COLUMN_DEVICE_IP"), oResManager.getResString("TASK_TABLE_COLUMN_RESOURCE_TYPE"), oResManager.getResString("TASK_TABLE_COLUMN_DEVICE_PACKAGESTATUS"), oResManager.getResString("ACTIVATION_GROUP_ID"), oResManager.getResString("TASK_TABLE_COLUMN_ORIGINAL_VERSION"), oResManager.getResString("TASK_TABLE_COLUMN_UPGRADE_VERSION"), oResManager.getResString("TASK_TABLE_COLUMN_DEVICE_OPERATION"), oResManager.getResString("TASK_TABLE_COLUMN_DEVICE_OPERATION_STATUS")};
        Class[] arrColumnTypes = new Class[]{TreeTableModel.class, VisualData.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
        boolean[] arrSortableColumns = new boolean[]{true, true, true, true, false, false, false, true, true, true};
        boolean[] arrEditableColumns = new boolean[]{true, false, false, false, false, false, false, false};
        this.m_oTaskTreeTableModel = new DCTreeTableModel(strColumnNames, arrColumnTypes, arrSortableColumns, arrEditableColumns);
        this.m_oTaskTreeTableModel.setComparator(new TreeTableComparator());
        this.m_oRootNode = this.m_oTaskTreeTableModel.getRoot();
    }

    private void initializeDeleteKeyEventHandler() {
        ActionListener oDeleteKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaskTablePanel.this.deleteKey_ActionPerformed();
            }
        };
        KeyStroke oDeleteKeyStroke = KeyStroke.getKeyStroke(127, 0);
        this.m_oTaskTreeTable.registerKeyboardAction(oDeleteKeyHandler, oDeleteKeyStroke, 0);
    }

    private void deleteKey_ActionPerformed() {
        int[] arrSelectedRows = this.m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length || !TaskTableUtil.isATaskOnlySelection(this.m_oTaskTreeTable)) {
            return;
        }
        boolean bAnyTaskIsInProgress = TaskTableUtil.isAnyTaskPresentWithState(this.m_oTaskTreeTable, 1);
        if (!bAnyTaskIsInProgress) {
            this.m_oTaskMenuItemHandler.deleteTask();
        }
    }

    private void initializeMouseAdapters() {
        this.m_oTaskTreeTable.addMouseListener(this.generateMouseAdapterForTable());
        this.m_oTaskTreeTable.addMouseMotionListener(new MyMouseMotionAdapter(this.m_oTaskTreeTable));
        this.m_oTaskTreeTable.addKeyListener(new MyKeyAdapter());
    }

    private MouseAdapter generateMouseAdapterForTable() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent oMouseEvent) {
                TaskTablePanel.this.taskTable_MousePressed(oMouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Cursor cur = new Cursor(0);
                DCFrameWorkUtil.setCursor(cur);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Thread myThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        TaskTablePanel.this.notifyToGetLogInfo();
                        DCFrameWorkUtil.setIsNeedToSendCmdCode(false);
                        TaskTablePanel.this.notifyDataSelectionEvent();
                    }
                });
                myThread.setName("TaskTablePanel#MouseAdapter");
                myThread.start();
            }
        };
    }

    private void locateToIsolationPanel(int iSelectedRow) {
        TreeTableRowData oRowData;
        TreeTableNode devNod;
        TreePath oTreePath = this.m_oTaskTreeTable.getTree().getPathForRow(iSelectedRow);
        if (null != oTreePath && (devNod = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData && (oRowData = (TreeTableRowData)devNod.getUserObject()).getUserObject() instanceof Resource) {
            Resource resource = (Resource)oRowData.getUserObject();
            ITask oTask = TaskTableUtil.getTaskForTableNode(devNod);
            if (null != oTask) {
                this.m_dcModuleMgr.getTaskMgrMainPanel().showIsolationManagementPanel();
                IsolationTaskInfoPanel oIsolationTaskInfoPanel = DCFrameWorkUtil.getIsolationTaskInfoPanel();
                boolean isSuccessToLocate = false;
                if (null != oIsolationTaskInfoPanel) {
                    isSuccessToLocate = oIsolationTaskInfoPanel.locateIsolation(oTask.getTaskName(), resource.getDeviceID());
                }
                if (!isSuccessToLocate) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("FAIL_TO_FIND_ISOLATION_RESOURCE"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
                }
            }
        }
    }

    private void taskTable_MousePressed(MouseEvent oMouseEvent) {
        DCFrameWorkUtil.setIsNeedToSendCmdCode(false);
        int iClickedRow = this.m_oTaskTreeTable.rowAtPoint(oMouseEvent.getPoint());
        boolean bIsClickedRowSelected = false;
        int[] nRows = this.m_oTaskTreeTable.getSelectedRows();
        if (nRows.length > 0) {
            for (int i = 0; i < nRows.length; ++i) {
                if (nRows[i] != iClickedRow) continue;
                bIsClickedRowSelected = true;
                break;
            }
        }
        if (!bIsClickedRowSelected && 0 != (4 & oMouseEvent.getModifiers())) {
            ListSelectionModel selectionModel = this.m_oTaskTreeTable.getSelectionModel();
            selectionModel.setSelectionInterval(iClickedRow, iClickedRow);
        }
        if (0 != (0x10 & oMouseEvent.getModifiers())) {
            Object oCellVal;
            int iSelectedRow = this.m_oTaskTreeTable.rowAtPoint(oMouseEvent.getPoint());
            int iColumn = this.m_oTaskTreeTable.columnAtPoint(oMouseEvent.getPoint());
            if (iColumn != 8) {
                return;
            }
            Object oValue = this.m_oTaskTreeTable.getValueAt(iSelectedRow, iColumn);
            if (oValue instanceof TreeTableCellData && (oCellVal = ((TreeTableCellData)oValue).getCellDataValue()) instanceof ResourceProgressInfo) {
                ResourceProgressInfo oResProgress = (ResourceProgressInfo)oCellVal;
                if (1 == oResProgress.getState()) {
                    return;
                }
                if (999293081 == oResProgress.getErrorNo()) {
                    ViewCommandResultDialog dialog = new ViewCommandResultDialog(oResProgress.getErrorInfo());
                    dialog.setTitle(DCFrameWorkUtil.getLocalizedString("OPERATION_RESULT"));
                    dialog.getContentTextArea().setLineWrap(true);
                    dialog.setVisible(true);
                } else if (IsolationCommonOperation.isIsolationState(oResProgress)) {
                    this.locateToIsolationPanel(iSelectedRow);
                } else {
                    DCHelpForErrCodeUtil.showHelp(this, oResProgress.getErrorNo());
                }
            }
        }
        if (0 != (4 & oMouseEvent.getModifiers())) {
            JPopupMenu oPopupMenu = null;
            try {
                if (!bIsClickedRowSelected && iClickedRow == -1) {
                    this.m_oTaskTreeTable.getTree().clearSelection();
                    oPopupMenu = this.m_oPopupMenuManager.enableOnlyCreateTaskItem();
                } else {
                    oPopupMenu = this.m_oPopupMenuManager.load();
                }
                if (TaskTableUtil.isABoardResourceOnlySelection(this.m_oTaskTreeTable) || TaskTableUtil.isAResourceOnlySelection(this.m_oTaskTreeTable)) {
                    if (!MenuUtil.isAllItemUnVisible(oPopupMenu)) {
                        oPopupMenu.show((Component)((Object)this.m_oTaskTreeTable), oMouseEvent.getX(), oMouseEvent.getY());
                    }
                } else {
                    oPopupMenu.show((Component)((Object)this.m_oTaskTreeTable), oMouseEvent.getX(), oMouseEvent.getY());
                }
            }
            catch (Exception e) {
                DCDebugTracer.trace("[menu] popup menu load fail error detail : ");
                DCDebugTracer.trace(e);
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("POPUP_MENU_LOAD_FAIL_ERROR"), ResourceManager.getInstance().getResString("ERROR"), 0);
            }
        }
    }

    private void notifyToGetLogInfo() {
        if (null != this.m_oTaskTreeTable && 1 == this.m_oTaskTreeTable.getSelectedRows().length) {
            if (TaskTableUtil.isAResourceOnlySelection(this.m_oTaskTreeTable)) {
                DCDebugTracer.trace("[log]:get dev log.");
                this.initOprInfoForResource(this.m_oTaskTreeTable);
                LogInfoNotifier.getInstance().sendRequestForLog(new TaskEvent(null, TaskEventID.DEVICE_OPR_CHK_ITEM_N_LOG_EVENT));
            } else if (TaskTableUtil.isATaskOnlySelection(this.m_oTaskTreeTable)) {
                DCDebugTracer.trace("[log]:get task log.");
                LogInfoNotifier.getInstance().sendRequestForLog(new TaskEvent(null, TaskEventID.TASK_DEVICES_OPR_DETAIL_EVENT));
            } else if (TaskTableUtil.isABoardResourceOnlySelection(this.m_oTaskTreeTable)) {
                DCDebugTracer.trace("[log]:get board log.");
                this.initOprInfoForResource(this.m_oTaskTreeTable);
                LogInfoNotifier.getInstance().sendRequestForLog(new TaskEvent(null, TaskEventID.DEVICE_OPR_CHK_ITEM_N_LOG_EVENT));
                DCFrameWorkUtil.getTaskDeviceOperationLogPanel().clearLogInforamtion();
            }
        }
    }

    private void initOprInfoForResource(DCSortableTreeTable oTaskTreeTable) {
        int iSelectedRow = oTaskTreeTable.getSelectedRow();
        TreePath oTreePath = oTaskTreeTable.getTree().getPathForRow(iSelectedRow);
        if (null == oTreePath) {
            return;
        }
        TreeTableNode oNode = null;
        oNode = (TreeTableNode)oTreePath.getLastPathComponent();
        if (!(oNode.getUserObject() instanceof TreeTableRowData)) {
            return;
        }
        TreeTableRowData oRowData = null;
        oRowData = (TreeTableRowData)oNode.getUserObject();
        if (!(oRowData.getUserObject() instanceof Resource)) {
            return;
        }
        Resource resource = (Resource)oRowData.getUserObject();
        ITask oTask = TaskTableUtil.getTaskForTableNode(oNode);
        this.addOprInfoForResource(oTask, resource);
    }

    private void addOprInfoForResource(ITask oTask, Resource oRes) {
        if (!oRes.isSubOprInfoEmpty()) {
            return;
        }
        if (null != oTask) {
            List<ITaskDeviceOperation> oSupportedOpList = oTask.getSupportedOperation();
            ITaskDeviceOperation oTaskDevOp = null;
            int iSizeOfList = oSupportedOpList.size();
            for (int i = 0; i < iSizeOfList; ++i) {
                oTaskDevOp = oSupportedOpList.get(i);
                if (null == oTaskDevOp || !oTaskDevOp.isSelected()) continue;
                if (oTaskDevOp instanceof LoadSoftwareOperation) {
                    ((LoadSoftwareOperation)oTaskDevOp).setDevID(oRes.getDeviceID());
                }
                if (oTaskDevOp instanceof LoadPatchOperation) {
                    ((LoadPatchOperation)oTaskDevOp).setDevID(oRes.getDeviceID());
                }
                if (oTaskDevOp instanceof PrepareUpgradeOperation) {
                    ((PrepareUpgradeOperation)oTaskDevOp).setiDeviceID(oRes.getDeviceID());
                }
                oRes.addSubOprListInfo(oTaskDevOp.getOperationId(), oTaskDevOp.getSubOperationData());
            }
        }
    }

    public void refreshTable() {
        if (0 == this.m_oTaskTree.getRowCount()) {
            this.m_oTaskTreeTable.clearCurrentSort();
        }
        this.updateTableView();
    }

    private void refreshTable(int iSelectRow, TaskEventID enTaskEvent) {
        if (0 == this.m_oTaskTree.getRowCount()) {
            this.m_oTaskTreeTable.clearCurrentSort();
        }
        this.updateTableView(iSelectRow, enTaskEvent);
    }

    private void populateTaskInTable(ITask oTask) {
        DCDebugTracer.trace("[task repeat] method populateTaskInTable start");
        DeviceType oDeviceType = oTask.getSelectedDeviceType();
        if (null == oDeviceType) {
            DCDebugTracer.trace("[task repeat] method populateTaskInTable end.. oDeviceType is null");
            return;
        }
        TreeTableNode oTaskNode = this.createTaskNodeInTable(oTask);
        this.m_oRootNode.add(oTaskNode);
        THashSet<Resource> oResources = oTask.getSelectedDeviceType().getResources();
        TreeTableNode oNode = null;
        Iterator oResItor = oResources.iterator();
        Resource oResource = null;
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            if (3 == oResource.getRoleType()) {
                this.m_oTaskTablePanelUtil.createStackResourceNodeInTable(oResource, oTask, oTaskNode);
                continue;
            }
            oNode = this.createDevNodeInTable(oResource, oTask);
            if (null == oNode) {
                DCDebugTracer.trace("oNode is null.task=" + oTask.getTaskName() + "|res=" + oResource);
                continue;
            }
            oTaskNode.add(oNode);
            if (oTask.getTaskTypeId() != 3 && (oTask.getTaskTypeId() != 5 && oTask.getTaskTypeId() != 12 || oTask.getUpgradeLevel() != 2)) continue;
            this.m_oTaskTablePanelUtil.createBoardNodesInTable(oResource, oTask, oNode);
        }
        DCDebugTracer.trace("[task repeat] method populateTaskInTable end..");
    }

    private TreeTableNode createDevNodeInTable(Resource oResource, ITask oTask) {
        TreeTableRowData oDevRow = new TreeTableRowData(9, 2);
        oDevRow.setUserObject(oResource);
        TreeTableNodeCellData oDevNameCell = new TreeTableNodeCellData(oResource.getDeviceName());
        TreeTableCellData oDevIpCell = new TreeTableCellData(StringUtils.getShowIP(oResource.getDeviceIP()));
        DeviceInfo devInfo = this.m_oDevInfoManager.getDevice(oResource.getDeviceID());
        if (null == devInfo) {
            DCDebugTracer.trace("getDevice is null,devID:" + oResource.getDeviceID());
            return null;
        }
        DeviceTypeInfo devTypeInfo = devInfo.getDeviceTypeInfo();
        if (null == devTypeInfo) {
            DCDebugTracer.trace("get devTypeInfo is null,devID:" + oResource.getDeviceID());
            return null;
        }
        TreeTableCellData oSourceTypeCell = null;
        oSourceTypeCell = devTypeInfo.getDevDomain() == 2 ? new TreeTableCellData(devTypeInfo.toString()) : new TreeTableCellData(devTypeInfo.getDevTypeName());
        ResourceProgressInfo oProgressInfo = oResource.getProgressInfo();
        TreeTableCellData oSourcePackageStateCell = null;
        oSourcePackageStateCell = devTypeInfo.isT2000Domain() ? new TreeTableCellData(oProgressInfo) : new TreeTableCellData("--");
        TreeTableCellData oDevOperationCell = new TreeTableCellData(oProgressInfo);
        TreeTableCellData oDevOperationStatusCell = new TreeTableCellData(oProgressInfo);
        TreeTableCellData oOriginalVerCell = new TreeTableCellData(oResource.getOriginalVersion());
        TreeTableCellData oUpgradeVerVell = new TreeTableCellData(oResource.getUpgradeVersion());
        oDevRow.setColumnData(0, oDevNameCell);
        oDevRow.setColumnData(1, oDevIpCell);
        oDevRow.setColumnData(2, oSourceTypeCell);
        oDevRow.setColumnData(3, oSourcePackageStateCell);
        oDevRow.setColumnData(5, oOriginalVerCell);
        oDevRow.setColumnData(6, oUpgradeVerVell);
        oDevRow.setColumnData(7, oDevOperationCell);
        oDevRow.setColumnData(8, oDevOperationStatusCell);
        List<ITaskDeviceOperation> operationList = oTask.getSupportedOperation();
        int count = operationList.size();
        block0: for (int i = 0; i < count; ++i) {
            ITaskDeviceOperation operation = operationList.get(i);
            if (operation.getOperationId() != 8) continue;
            ActivationConfigPara activateConf = (ActivationConfigPara)operation.getConfiguredPara();
            List<ActivationGroupInfo> activateList = activateConf.getActivateGroupInfoLst();
            if (activateList == null || activateList.size() <= 0) break;
            List elementList = activateConf.getElementInfoLst();
            int elementSize = elementList.size();
            for (int j = 0; j < elementSize; ++j) {
                ActivationElementInfo elementInfo = (ActivationElementInfo)elementList.get(j);
                Resource e_oResource = elementInfo.getResource();
                if (e_oResource.getDeviceID() != oResource.getDeviceID()) continue;
                TreeTableCellData oGroupId = new TreeTableCellData(ResourceManager.getInstance().getResString(ResourceManager.getInstance().getResString("GROUP") + elementInfo.getGroupId()));
                if (!operation.isSelected() || oTask.getUpgradeLevel() != 1) continue block0;
                oDevRow.setColumnData(4, oGroupId);
                continue block0;
            }
        }
        TreeTableNode oDevNode = new TreeTableNode(oDevRow);
        oDevNameCell.setAttachedTreeNode(oDevNode);
        return oDevNode;
    }

    private TreeTableNode createTaskNodeInTable(ITask oTask) {
        TreeTableRowData oTaskRow = new TreeTableRowData(9, 1);
        oTaskRow.setUserObject(oTask);
        TreeTableNodeCellData oTaskNameCell = new TreeTableNodeCellData(oTask.getTaskName());
        TreeTableCellData oOperationStatusCell = new TreeTableCellData(oTask.getTaskProgressInfo());
        oTaskRow.setColumnData(0, oTaskNameCell);
        oTaskRow.setColumnData(8, oOperationStatusCell);
        TreeTableNode oTaskNode = new TreeTableNode(oTaskRow);
        oTaskNameCell.setAttachedTreeNode(oTaskNode);
        return oTaskNode;
    }

    @Override
    public void onTreeNodeSelection(DCEventObject oEventObject) {
        TaskTreeNodeInfo oTaskNodeInfo;
        DCDebugTracer.trace("[task repeat] method onTreeNodeSelection start");
        if (null == oEventObject) {
            DCDebugTracer.trace("[task repeat] method onTreeNodeSelection end.. invalid event");
            return;
        }
        if (!(oEventObject instanceof TaskTreeSelectionEvent)) {
            return;
        }
        this.m_oCurrentTreeSelectionEvent = (TaskTreeSelectionEvent)oEventObject;
        this.m_oCurrentSelectedNodeInfo = oTaskNodeInfo = (TaskTreeNodeInfo)oEventObject.getSource();
        int iNodeType = oTaskNodeInfo.getNodeType();
        this.clearTaskData();
        DCFrameWorkUtil.updateUI((JComponent)((Object)this.m_oTaskTreeTable));
        TaskEventID enTaskEvent = TaskEventID.INVALID_ID;
        DCDebugTracer.trace("[task repeat] iNodeType : " + iNodeType);
        switch (iNodeType) {
            case 0: {
                this.populateAllTasksFromDataModel();
                enTaskEvent = TaskEventID.TASK_TREE_SELECTION_NOTIFICATION;
                break;
            }
            case 1: {
                this.populateTaskGroup(oTaskNodeInfo.getTaskGroup());
                enTaskEvent = TaskEventID.TASK_TREE_SELECTION_NOTIFICATION;
                break;
            }
            case 2: {
                this.populateTaskGroupForStatus(oTaskNodeInfo.getTaskGroup(), oTaskNodeInfo.getTaskStatus());
                enTaskEvent = TaskEventID.TASK_TREE_SELECTION_NOTIFICATION;
                break;
            }
        }
        int iRowCount = this.m_oTaskTreeTableModel.getRowCount();
        DCDebugTracer.trace("[task repeat] iRowCount : " + iRowCount);
        int iSelectRow = 0;
        if (0 < iRowCount && this.m_oCurrentTreeSelectionEvent.isAutoTreeEvent()) {
            iSelectRow = iRowCount - 1;
        }
        this.refreshTable(iSelectRow, enTaskEvent);
        DCDebugTracer.trace("[task repeat] method onTreeNodeSelection end..");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTaskData() {
        DCDebugTracer.trace("[memory leak] TaskTablePanel#clearTaskData start");
        try {
            int iTaskCount = this.m_oRootNode.getChildCount();
            TreeTableNode oNode = null;
            for (int i = 0; i < iTaskCount; ++i) {
                oNode = (TreeTableNode)this.m_oRootNode.getChildAt(i);
                if (null == oNode) continue;
                TreeTableRowData oTaskRow = (TreeTableRowData)oNode.getUserObject();
                if (null == oTaskRow) {
                    oNode.setUserObject(null);
                    oNode.setParent(null);
                    oNode = null;
                    continue;
                }
                Enumeration<TreeNode> oChildNodes = oNode.depthFirstEnumeration();
                TreeTableNode oChildNode = null;
                while (oChildNodes.hasMoreElements()) {
                    oChildNode = (TreeTableNode)oChildNodes.nextElement();
                    TreeTableRowData oChildRow = (TreeTableRowData)oChildNode.getUserObject();
                    if (null == oChildRow) {
                        oChildNode.setUserObject(null);
                        oChildNode.setParent(null);
                        oChildNode = null;
                        continue;
                    }
                    oChildRow.setUserObject(null);
                    oChildRow.clearData();
                    oChildRow = null;
                    oChildNode.removeAllChildren();
                    oChildNode.setUserObject(null);
                    oChildNode.setParent(null);
                    oChildNode = null;
                }
                oChildNodes = null;
                oTaskRow.setUserObject(null);
                oTaskRow.clearData();
                oTaskRow = null;
                oNode.removeAllChildren();
                oNode.setUserObject(null);
                oNode.setParent(null);
                oNode = null;
            }
            DCDebugTracer.trace("[memory leak] TaskTablePanel#clearTaskData success");
        }
        catch (Exception ignore) {
            DCDebugTracer.trace("[memory leak] TaskTablePanel#clearTaskData release resources throw exception do not affort function");
            DCDebugTracer.trace(ignore);
        }
        finally {
            this.m_oRootNode.removeAllChildren();
        }
        DCDebugTracer.trace("[memory leak] TaskTablePanel#clearTaskData end..");
    }

    private synchronized void populateAllTasksFromDataModel() {
        ITaskDataModel m_oTaskModel = TaskDataModel.getInstance();
        if (null == m_oTaskModel || 0 == m_oTaskModel.getAllTaskGroup().size()) {
            return;
        }
        List oTaskGroups = m_oTaskModel.getAllTaskGroup();
        for (int i = 0; i < oTaskGroups.size(); ++i) {
            ITaskGroup oTaskGroup = (ITaskGroup)oTaskGroups.get(i);
            if (256 == oTaskGroup.getTaskGroupId()) continue;
            this.populateTaskGroup(oTaskGroup);
        }
    }

    private void populateTaskGroup(ITaskGroup oTaskGroup) {
        this.populateTaskGroupForStatus(oTaskGroup, 0);
        this.populateTaskGroupForStatus(oTaskGroup, 2);
        this.populateTaskGroupForStatus(oTaskGroup, 3);
    }

    private void populateTaskGroupForStatus(ITaskGroup oTaskGroup, int iTaskStatus) {
        if (null == oTaskGroup || null == oTaskGroup.getAllTask(iTaskStatus)) {
            return;
        }
        List oTasks = oTaskGroup.getAllTask(iTaskStatus);
        for (int i = 0; i < oTasks.size(); ++i) {
            ITask oTask = (ITask)oTasks.get(i);
            int iCurTaskState = oTask.getTaskProgressInfo().getState();
            boolean bIsTaskStarted = TaskModelUtil.isTaskStarted(oTask);
            if (4 == iCurTaskState) {
                this.handleTaskPaused(iTaskStatus, oTask, bIsTaskStarted);
                continue;
            }
            this.handleTaskProgress(iTaskStatus, oTask, iCurTaskState);
        }
    }

    private void handleTaskProgress(int iTaskStatus, ITask oTask, int iCurTaskState) {
        if (2 == iTaskStatus) {
            if (1 == iCurTaskState || 2 == iCurTaskState) {
                this.populateTaskInTable(oTask);
            }
        } else if (iTaskStatus == iCurTaskState) {
            this.populateTaskInTable(oTask);
        }
    }

    private void handleTaskPaused(int iTaskStatus, ITask oTask, boolean bIsTaskStarted) {
        if (!bIsTaskStarted && 0 == iTaskStatus) {
            this.populateTaskInTable(oTask);
        } else if (bIsTaskStarted && 2 == iTaskStatus) {
            this.populateTaskInTable(oTask);
        }
    }

    @Override
    public void onTreeInit(DCEventObject oEventObject) {
    }

    @Override
    public void onTaskNotification(TaskEvent oEvent) {
        if (null == oEvent) {
            return;
        }
        this.updateTableForTaskEvent(oEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTableForTaskEvent(TaskEvent oEvent) {
        TaskEventID enTaskEventType = oEvent.getTaskEventType();
        if (TaskEventID.RESOURCE_PROGRESS_NOTIFICATION == enTaskEventType) {
            try {
                Object oSource = oEvent.getSource();
                if (oSource instanceof Resource) {
                    Resource oResource = (Resource)oSource;
                    boolean bIsOpTabRefreshReq = oEvent.getIsTaskOperationRefresh();
                    DeviceTreeTableDataSelectionEventObject oNotifyEvent = new DeviceTreeTableDataSelectionEventObject(oResource, bIsOpTabRefreshReq, oEvent.getTaskID());
                    oNotifyEvent.setEventType(3);
                    this.notifyEvent(oNotifyEvent);
                }
                if (oSource instanceof HashMap) {
                    DeviceTreeTableDataSelectionEventObject oNotifyEvent = new DeviceTreeTableDataSelectionEventObject(oSource);
                    oNotifyEvent.setEventType(3);
                    this.notifyEvent(oNotifyEvent);
                }
                DCDebugTracer.trace("can't identify the type, the type is " + oSource);
            }
            finally {
                DCFrameWorkUtil.repaint((JComponent)((Object)this.m_oTaskTreeTable));
            }
        } else if (TaskEventID.TASK_LIST_REFRESH == enTaskEventType) {
            Boolean oIsLastInfo = (Boolean)oEvent.getSource();
            if (oIsLastInfo.booleanValue()) {
                this.closeGettingTaskLstProgressDlg();
                this.onTreeNodeSelection(this.m_oCurrentTreeSelectionEvent);
                DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(0));
            } else {
                this.onTreeNodeSelection(this.m_oCurrentTreeSelectionEvent);
                DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(3));
            }
        } else if (TaskEventID.TASK_CREATION == enTaskEventType) {
            int[] arrTaskIDs = (int[])oEvent.getSource();
            boolean isSelectLastRow = false;
            boolean isAddTask = false;
            for (int i = 0; i < arrTaskIDs.length; ++i) {
                ITask oTask = TaskDataModel.getInstance().getTask(arrTaskIDs[i]);
                if (this.isShowTask(oTask)) {
                    isAddTask = true;
                    this.populateTaskInTable(oTask);
                }
                if (!oTask.getTaskName().equals(TaskDataModel.getInstance().getCreatingTaskName())) continue;
                isSelectLastRow = true;
                TaskDataModel.getInstance().setCreatingTaskName("");
            }
            if (isAddTask) {
                if (isSelectLastRow) {
                    int iRowCount = this.m_oTaskTreeTable.getRowCount();
                    this.refreshTable(iRowCount, TaskEventID.TASK_TREE_SELECTION_NOTIFICATION);
                } else {
                    this.updateTableView();
                }
            }
        } else if (TaskEventID.DEVICE_SUB_OPR_NOTIFICATION == enTaskEventType) {
            Resource oResource = (Resource)oEvent.getSource();
            if (null == oResource) {
                return;
            }
            this.notifyEvent(oEvent);
        } else if (TaskEventID.TASK_DELETION == enTaskEventType) {
            if (oEvent.getSource() instanceof List) {
                List oTaskIDLst = (List)oEvent.getSource();
                this.m_oTaskMenuItemHandler.deleteTaskFromTable(oTaskIDLst, 0);
                this.notifyDataSelectionEvent();
            }
        } else {
            DCDebugTracer.trace("TaskTablePanel the task event id is " + (Object)((Object)enTaskEventType));
        }
    }

    public void updateTableView() {
        DCFrameWorkUtil.updateUI((JComponent)((Object)this.m_oTaskTreeTable));
    }

    private void updateTableView(final int iSelectRow, final TaskEventID enTaskEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskTablePanel.this.m_oTaskTreeTable.updateUI();
                if (iSelectRow >= 0) {
                    TaskTablePanel.this.m_oTaskTreeTable.getSelectionModel().setSelectionInterval(iSelectRow, iSelectRow);
                    TaskTablePanel.this.m_oTaskTreeTable.scrollRectToVisible(TaskTablePanel.this.m_oTaskTreeTable.getCellRect(iSelectRow, 0, true));
                }
                if (null != TaskTablePanel.this.m_oTaskTreeTable) {
                    TaskTablePanel.this.notifyToGetLogInfo();
                    DeviceTreeTableDataSelectionEventObject oNotify = new DeviceTreeTableDataSelectionEventObject((Object)TaskTablePanel.this.m_oTaskTreeTable);
                    if (TaskEventID.INVALID_ID != enTaskEvent) {
                        oNotify.setEventType(TaskEventID.TASK_TREE_SELECTION_NOTIFICATION.ordinal());
                    }
                    TaskTablePanel.this.notifyEvent(oNotify);
                }
            }
        });
    }

    public DCSortableTreeTable getTaskTreeTable() {
        return this.m_oTaskTreeTable;
    }

    public TaskTreeNodeInfo getSelectedTaskTreeNodeInfo() {
        return this.m_oSelectedTaskTreeNodeInfo;
    }

    @Override
    public void addDCEventListener(DCTreeEventListener eventListener) {
        if (null != eventListener && !this.m_oListeners.contains(eventListener)) {
            this.m_oListeners.add(eventListener);
        }
    }

    private void notifyEventWithoutEventDispatch(DCEventObject eventObject) {
        int iCount = this.m_oListeners.size();
        DCDebugTracer.traceDetail("TaskTablePanel m_oListeners size : " + iCount);
        for (int index = 0; index < iCount; ++index) {
            DCTreeEventListener eventListener = (DCTreeEventListener)this.m_oListeners.get(index);
            eventListener.onTreeNodeSelection(eventObject);
        }
    }

    @Override
    public void notifyEvent(final DCEventObject eventObject) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.notifyEventWithoutEventDispatch(eventObject);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TaskTablePanel.this.bIsDevInTaskSubOperation = true;
                    TaskTablePanel.this.notifyEventWithoutEventDispatch(eventObject);
                }
            });
        }
    }

    @Override
    public void removeDCEventListener(DCTreeEventListener eventListener) {
        if (null != eventListener && this.m_oListeners.contains(eventListener)) {
            this.m_oListeners.remove(eventListener);
        }
    }

    public void disposePanel() {
        TaskInfoNotifier.getInstance().removeTaskNotificationListener(this);
        this.removeAll();
        this.m_oListeners = null;
        this.m_oTaskTreeTable = null;
        this.m_oTaskTreeTableModel = null;
        if (null != this.m_oRootNode) {
            this.clearTaskData();
            this.m_oRootNode = null;
        }
        this.m_oTaskTree = null;
        this.m_oScrollPane = null;
        if (null != this.m_oPopupMenuManager) {
            this.m_oPopupMenuManager.doCleanUp();
            this.m_oPopupMenuManager = null;
        }
        this.m_oSelectedTaskTreeNodeInfo = null;
        if (null != this.m_oTaskMenuItemHandler) {
            this.m_oTaskMenuItemHandler.doCleanUp();
            this.m_oTaskMenuItemHandler = null;
        }
        this.m_oCurrentTreeSelectionEvent = null;
        this.m_oDevInfoManager = null;
        this.m_oTaskTablePanelUtil = null;
    }

    public void refreshData() {
        if (null != this.m_oRootNode) {
            this.m_oRootNode.removeAllChildren();
        }
        this.populateAllTasksFromDataModel();
        this.refreshTable();
    }

    public void setResultDlg(CommonProgressDlg oCommonProgressDlg) {
        this.m_oCommProgressDlg = oCommonProgressDlg;
    }

    public CommonProgressDlg getResultDlg() {
        return this.m_oCommProgressDlg;
    }

    public void handleSWDLStatusResponse(final AsnDCSWDLStatusNotify asnDCSWDLStatusNotify) {
        if (null == asnDCSWDLStatusNotify || null == this.m_oCommProgressDlg || this.m_oCommProgressDlg.getProgressDlgId() != asnDCSWDLStatusNotify.oReqID.intValue()) {
            if (null != asnDCSWDLStatusNotify) {
                DCDebugTracer.trace("iReqID :" + asnDCSWDLStatusNotify.oReqID.intValue());
            }
            if (null != this.m_oCommProgressDlg) {
                DCDebugTracer.trace("ProgressDlgId :" + this.m_oCommProgressDlg.getProgressDlgId());
            }
            return;
        }
        int iTaskID = asnDCSWDLStatusNotify.iTaskID.intValue();
        final int iDevID = asnDCSWDLStatusNotify.iDevID.intValue();
        String sOperationName = "";
        int iErrorcode = asnDCSWDLStatusNotify.oErrorInfo.iErrorNo.intValue();
        DCDebugTracer.trace("iTaskID :" + iTaskID + ";" + "iDevID :" + iDevID);
        if (0 != iErrorcode) {
            sOperationName = ErrorCodeReader.getInstance().getErrorDesc(asnDCSWDLStatusNotify.oErrorInfo.iErrorNo);
            DCDebugTracer.trace("sOperationName1 :" + sOperationName);
        } else {
            sOperationName = TaskCommUtil.getSWDLStatusRes(asnDCSWDLStatusNotify.oSWDLStatus.value);
            DCDebugTracer.trace("sOperationName :" + sOperationName);
        }
        final String sOperName = sOperationName;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskTablePanel.this.refreshProgressDlg(iDevID, sOperName);
            }
        });
        if (iTaskID != -1 && 0 == iErrorcode) {
            ITask task = TaskDataModel.getInstance().getTask(iTaskID);
            if (null == task) {
                return;
            }
            THashSet<Resource> resourceList = task.getDeviceType().getResources();
            for (Resource res : resourceList) {
                if (res.getDeviceID() != iDevID) continue;
                res.getProgressInfo().setSWDLStatus(sOperationName);
                res.getProgressInfo().setIntSWDLStatus(asnDCSWDLStatusNotify.oSWDLStatus.value);
                DCFrameWorkUtil.repaint((JComponent)((Object)this.m_oTaskTreeTable));
                break;
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (null != TaskTablePanel.this.m_oDeviceSelectionPanel) {
                        TaskTablePanel.this.m_oDeviceSelectionPanel.setResourceSWDLStatus(asnDCSWDLStatusNotify);
                    }
                }
            });
        }
    }

    public void handleMainBoardNumResponse(AsnDCMainBoardNumRsp oRsp) {
        if (null == oRsp) {
            DCDebugTracer.trace("handleMainBoardNumResponse(the response is null)");
            return;
        }
        int iReqId = oRsp.oReqID.intValue();
        DCDebugTracer.trace("handleMainBoardNumResponse(the request id is " + iReqId + ")");
        if (null == this.m_oCommProgressDlg || this.m_oCommProgressDlg.getProgressDlgId() != iReqId) {
            DCDebugTracer.trace("iReqID :" + iReqId);
            if (null != this.m_oCommProgressDlg) {
                DCDebugTracer.trace("ProgressDlgId :" + this.m_oCommProgressDlg.getProgressDlgId());
            }
            DCDebugTracer.trace(oRsp.toString());
            return;
        }
        String strResult = "";
        strResult = ErrorCodeReader.getInstance().getErrorDesc(oRsp.oErrorInfo.iErrorNo);
        AsnDCMainBoardNum oAsnMainBoardNum = oRsp.oAsnDCMainBoardNum;
        int iDevID = oAsnMainBoardNum.iDevId.intValue();
        this.refreshProgressDlg(iDevID, strResult);
        if (null != this.m_oDeviceSelectionPanel) {
            this.m_oDeviceSelectionPanel.setMainBoardNumInfo(iDevID, oAsnMainBoardNum.enBoardNum);
        }
    }

    public synchronized void handSingleDeviceGetActiveGroupRsp(int devId, int reqId) {
        if (this.m_oCommProgressDlg.isVisible()) {
            this.m_oCommProgressDlg.dispose();
        }
    }

    public void handSingleDeviceSetActiveGroupRsp(int devId, int reqId) {
        this.m_oCommProgressDlg.dispose();
    }

    public void handleQueryFailedBoardResponse(AsnToleranceSearchRsp oAsnToleranceSearchRsp) {
        if (null == oAsnToleranceSearchRsp || null == this.m_oCommProgressDlg || this.m_oCommProgressDlg.getProgressDlgId() != oAsnToleranceSearchRsp.oReqID.intValue()) {
            if (null != oAsnToleranceSearchRsp) {
                DCDebugTracer.trace("iReqID :" + oAsnToleranceSearchRsp.oReqID.intValue());
            }
            DCDebugTracer.trace("ProgressDlgId :" + this.m_oCommProgressDlg.getProgressDlgId());
            return;
        }
        AsnDCLoadTaskDeviceInfo oDeviceInfo = oAsnToleranceSearchRsp.oAsnDCLoadTaskDevice;
        int iErrorcode = oAsnToleranceSearchRsp.oErrorInfo.iErrorNo.intValue();
        String strOperationReason = "";
        int iDeviceId = oDeviceInfo.iDevId.intValue();
        if (0 != iErrorcode) {
            strOperationReason = ErrorCodeReader.getInstance().getErrorDesc(oAsnToleranceSearchRsp.oErrorInfo.iErrorNo);
            if (this.deviceInfoList == null) {
                this.deviceInfoList = new ArrayList<AsnDCLoadTaskDeviceInfo>();
            }
            this.deviceInfoList.add(oDeviceInfo);
        } else {
            strOperationReason = ResourceManager.getInstance().getResString("OPERTION_SUCCESS");
            if (this.deviceInfoList == null) {
                this.deviceInfoList = new ArrayList<AsnDCLoadTaskDeviceInfo>();
            }
            this.deviceInfoList.add(oDeviceInfo);
        }
        this.refreshProgressDlg(iDeviceId, strOperationReason);
        if (oAsnToleranceSearchRsp.bIsFinal && this.deviceInfoList.size() != 0) {
            this.m_oCommProgressDlg.setDeviceInfoList(this.deviceInfoList);
            for (int i = 0; i < this.deviceInfoList.size(); ++i) {
                AsnDCLoadTaskDeviceInfo devInfo = this.deviceInfoList.get(i);
                if (devInfo.oBoardList == null || devInfo.oBoardList.size() <= 0) continue;
                this.m_oCommProgressDlg.getShowQueryReasonButton().setVisible(true);
            }
            this.deviceInfoList = null;
        }
    }

    public void handleHighModeSetFailedRsp(int iTaskID, int iDevID, AsnDCErrorCodeInfo oErrorCode, int errorDevSize, int taskResult) {
        DCDebugTracer.trace("[HighMode]handleHighModeSetFailedRsp:start,iDevID=" + iDevID + "|iTaskID=" + iTaskID);
        boolean bRefreshSucDev = false;
        boolean bIsNeedUpdateTaskState = true;
        ITask oTask = null;
        oTask = TaskDataModel.getInstance().getTask(iTaskID);
        TreeTableNode taskNode = this.getTaskNode(iTaskID, this.m_oRootNode);
        if (null == taskNode) {
            oTask = TaskDataModel.getInstance().getTask(iTaskID);
            if (oTask == null) {
                DCDebugTracer.trace("[HighMode]handleHighModeSetFailedRsp: oTask can not found in m_oTaskModel.");
                return;
            }
            this.populateTaskInTable(oTask);
            taskNode = this.getTaskNode(iTaskID, this.m_oRootNode);
            if (null == taskNode) {
                DCDebugTracer.trace("[HighMode]handleHighModeSetFailedRsp:taskNode is null");
                return;
            }
        }
        if (iDevID == -1) {
            DCDebugTracer.trace("[HighMode]handleHighModeSetFailedRsp:iDevID = -1");
            bRefreshSucDev = true;
            Object treeTableNodeObj = taskNode.getUserObject();
            if (!(treeTableNodeObj instanceof TreeTableRowData)) {
                DCDebugTracer.trace("[HighMode]handleHighModeSetFailedRsp:treeTableNodeObj instanceof false.");
                return;
            }
            TreeTableRowData oRowData = (TreeTableRowData)treeTableNodeObj;
            if (oTask == null) {
                oTask = (ITask)oRowData.getUserObject();
            }
            if (oTask == null) {
                DCDebugTracer.trace("[HighMode]handleHighModeSetFailedRsp: oTask can not found in oRowData.");
                return;
            }
            if (oTask.getDeviceType().getResources().size() > errorDevSize) {
                DCDebugTracer.trace("[HighMode]handleHighModeSetFailedRsp:errorDevSize:" + errorDevSize);
                bIsNeedUpdateTaskState = false;
            }
            if (null != oRowData && oRowData.getUserObject() instanceof ITask && bIsNeedUpdateTaskState) {
                DCDebugTracer.trace("[HighMode]handleHighModeSetFailedRsp:set task Progres set result by taskResult=" + taskResult);
                ITask oTaskInfo = (ITask)oRowData.getUserObject();
                TaskProgressInfo oTaskProgress = oTaskInfo.getTaskProgressInfo();
                if (3 == taskResult) {
                    oTaskProgress.setProgress(0);
                    oTaskProgress.setState(1);
                } else if (2 == taskResult) {
                    oTaskProgress.setState(4);
                } else if (1 == taskResult) {
                    oTaskProgress.setState(2);
                    oTaskProgress.setResult(1);
                } else {
                    oTaskProgress.setResult(0);
                }
            }
        }
        Enumeration<TreeNode> childEnum = taskNode.breadthFirstEnumeration();
        while (childEnum.hasMoreElements()) {
            DCDebugTracer.trace("[HighMode]handleHighModeSetFailedRsp:childEnum has more.");
            TreeTableNode treeTableNode = (TreeTableNode)childEnum.nextElement();
            Object treeTableNodeObj = treeTableNode.getUserObject();
            if (!(treeTableNodeObj instanceof TreeTableRowData)) {
                DCDebugTracer.trace("[HighMode]handleHighModeSetFailedRsp:childEnum treeTableNodeObj instanceof false.");
                continue;
            }
            TreeTableRowData oRowData = (TreeTableRowData)treeTableNodeObj;
            if (!(oRowData.getUserObject() instanceof Resource)) {
                DCDebugTracer.trace("[HighMode]handleHighModeSetFailedRsp:oRowData instanceof false.");
                continue;
            }
            Resource resource = (Resource)oRowData.getUserObject();
            if (iDevID != -1 && iDevID != resource.getDeviceID()) {
                DCDebugTracer.trace("[HighMode]handleHighModeSetFailedRsp:(iDevID != -1) && (iDevID != resource.getDeviceID())");
                continue;
            }
            ResourceProgressInfo oResourceProgress = resource.getProgressInfo();
            if (bRefreshSucDev) continue;
            DCDebugTracer.trace("[HighMode]handleHighModeSetFailedRsp:bRefreshSucDev = false");
            oResourceProgress.setState(2);
            oResourceProgress.setResult(1);
            this.refreshFirstOperationInfo(oResourceProgress, iTaskID);
            String strResult = null;
            if (null != oErrorCode.strResult) {
                strResult = new String(oErrorCode.strResult);
            }
            oResourceProgress.setErrorInfo(oErrorCode.iErrorNo.intValue(), strResult);
            break;
        }
        DCFrameWorkUtil.repaint((JComponent)((Object)this.m_oTaskTreeTable));
    }

    private void refreshProgressDlg(int devID, String sOperationName) {
        DeviceInfo devInfo = DeviceInfoManagerImpl.getInstance().getDevice(devID);
        if (null == devInfo || null == this.m_oCommProgressDlg) {
            DCDebugTracer.trace("devInfo :null!");
            return;
        }
        int iDevID = devInfo.getDevId();
        DCDebugTracer.trace("iDevID ->" + iDevID);
        String devName = devInfo.getDevName();
        String devIP = devInfo.getDevIPAddress();
        String sDisplayName = devName + "(" + devIP + ")";
        this.m_oCommProgressDlg.setProgress(iDevID, sDisplayName, sOperationName);
    }

    private TreeTableNode getTaskNode(int iTaskNodeID, TreeTableNode oRoot) {
        TreeTableNode oTreeTableNode = null;
        int iChildCount = oRoot.getChildCount();
        for (int i = 0; i < iChildCount; ++i) {
            TreeTableNode childAt = (TreeTableNode)oRoot.getChildAt(i);
            TreeTableRowData oRowData = (TreeTableRowData)childAt.getUserObject();
            ITask userObject = (ITask)oRowData.getUserObject();
            if (userObject.getTaskId() != iTaskNodeID) continue;
            oTreeTableNode = childAt;
            break;
        }
        return oTreeTableNode;
    }

    public Object getSynObject() {
        return this.m_oSynObject;
    }

    public void setDeviceSelectionPanel(DeviceSelectionPanel deviceSelectionPanel) {
        this.m_oDeviceSelectionPanel = deviceSelectionPanel;
    }

    private void refreshFirstOperationInfo(ResourceProgressInfo oResourceProgressInfo, int iTaskID) {
        ITask oTask = TaskDataModel.getInstance().getTask(iTaskID);
        List<ITaskDeviceOperation> oDevOperationLst = oTask.getSupportedOperation();
        ITaskDeviceOperation oTaskDeviceOperation = null;
        for (int i = 0; i < oDevOperationLst.size(); ++i) {
            oTaskDeviceOperation = oDevOperationLst.get(i);
            if (null == oTaskDeviceOperation || !oTaskDeviceOperation.isSelected()) continue;
            oResourceProgressInfo.setCurrentOperationId(oTaskDeviceOperation.getOperationIdString());
            oResourceProgressInfo.setCurrentOperationName(oTaskDeviceOperation.getOperationName());
            break;
        }
    }

    public void openGettingTaskLstProgressDlg() {
        this.m_bGettingTaskInfo = true;
        DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(false);
        DeviceTablePanel oDevTablePanel = DCFrameWorkUtil.getDeviceTablePanel();
        if (null != oDevTablePanel && oDevTablePanel.isFirstOpenFromDevPanel()) {
            return;
        }
        RouterDevInfoPanel oRouteDevPanel = DCFrameWorkUtil.getRouterDevInfoPanel();
        if (null != oRouteDevPanel && oRouteDevPanel.isFirstOpenFromDevPanel()) {
            return;
        }
        this.m_oGettingTaskLstProgressDlg = new SimpleProgressDlg(ResourceManager.getInstance().getResString("GETTING_TASK_INFO"), true, ResourceManager.getInstance().getResString("GETTING_TASK_INFO_PROMPT")){
            private static final long serialVersionUID = 9144645144399907069L;

            @Override
            protected void cancelRollBtnActionPerformed() {
                this.doCleanUp();
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskTablePanel.this.m_oGettingTaskLstProgressDlg.setVisible(true);
            }
        });
    }

    public void closeGettingTaskLstProgressDlg() {
        if (null != this.m_oGettingTaskLstProgressDlg) {
            this.m_oGettingTaskLstProgressDlg.dispose();
        }
        this.m_oGettingTaskLstProgressDlg = null;
        DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(true);
        this.m_bGettingTaskInfo = false;
        this.requestFocus();
        DCFrameWorkUtil.getDCModuleManager().checkXFTPStatus();
        DCDebugTracer.trace("refresh task list over and close progres dialog");
    }

    public boolean isGettingTaskInfo() {
        return this.m_bGettingTaskInfo;
    }

    public boolean isDevInTaskSubOperation() {
        return this.bIsDevInTaskSubOperation;
    }

    public void setIsDevInTaskSubOperation(boolean m_bIsDevInTaskSubOperation) {
        this.bIsDevInTaskSubOperation = m_bIsDevInTaskSubOperation;
    }

    public TaskMenuItemHandler getTaskMenuItemHandler() {
        return this.m_oTaskMenuItemHandler;
    }

    public DCTreeTableModel getTaskTreeTableModel() {
        return this.m_oTaskTreeTableModel;
    }

    private boolean isShowTask(ITask oTask) {
        if (oTask.getTaskName().equals(TaskDataModel.getInstance().getCreatingTaskName())) {
            return true;
        }
        if (null != this.m_oCurrentSelectedNodeInfo) {
            int iNodeType = this.m_oCurrentSelectedNodeInfo.getNodeType();
            if (0 == iNodeType) {
                return true;
            }
            if (null != this.m_oCurrentSelectedNodeInfo.getTaskGroup().getTask(oTask.getTaskId())) {
                if (1 == iNodeType || 0 == this.m_oCurrentSelectedNodeInfo.getTaskStatus()) {
                    return true;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    class MyKeyAdapter
    extends KeyAdapter {
        MyKeyAdapter() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            int iKeyCode = e.getKeyCode();
            if (65 == iKeyCode && 2 == e.getModifiers()) {
                TaskTablePanel.this.notifyDataSelectionEvent();
            } else if (38 == iKeyCode || 40 == iKeyCode) {
                TaskTablePanel.this.notifyDataSelectionEvent();
            } else {
                DCDebugTracer.trace("dc won't handle the other key.");
            }
        }
    }
}

