/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.tasktable;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.components.treetable.model.TreeTableCellData;
import com.huawei.dc.common.components.treetable.view.DCTreeTableCellRenderer;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.model.ProgressInfo;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.TaskProgressInfo;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTableUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressInfoCellRenderer
extends DCTreeTableCellRenderer {
    public ProgressInfoCellRenderer(JSortTreeTable oSortTableTree, int iAlignment) {
        super(oSortTableTree, iAlignment);
    }

    @Override
    protected Component getRendererComponentForCell(TreeTableCellData treeTableCellData, int col) {
        Object cellDataValue = treeTableCellData.getCellDataValue();
        if (null != cellDataValue) {
            if (cellDataValue instanceof ProgressInfo) {
                return this.getRendererComponentForProgressInfo((ProgressInfo)cellDataValue);
            }
            this.getDefaultRendererComponentForCell(cellDataValue, col);
        }
        return new JPanel();
    }

    private Component getRendererComponentForProgressInfo(ProgressInfo oProgressInfo) {
        if (1 == oProgressInfo.getState()) {
            if (oProgressInfo instanceof ResourceProgressInfo) {
                ResourceProgressInfo oResProgress = (ResourceProgressInfo)oProgressInfo;
                return this.generateResProgressBar(oResProgress);
            }
            return this.generateProgressBar(oProgressInfo);
        }
        if (oProgressInfo instanceof ResourceProgressInfo) {
            ResourceProgressInfo oResProgress = (ResourceProgressInfo)oProgressInfo;
            return this.generateLinkRenderer(oResProgress);
        }
        JLabel oLabel = new JLabel();
        oLabel.setOpaque(true);
        oLabel.setBorder(this.getBorder());
        oLabel.setText(oProgressInfo.toString());
        if (oProgressInfo instanceof TaskProgressInfo) {
            if (this.m_bIsCurrentCellSelected) {
                oLabel.setForeground(Color.white);
            } else {
                oLabel.setForeground(((TaskProgressInfo)oProgressInfo).getTaskStausColor());
            }
            oLabel.setName("TaskProgressInfoCellName");
        }
        String strToolTipText = oProgressInfo.toString();
        int iNumCharInOneRow = 100;
        if (strToolTipText.length() > 100) {
            strToolTipText = TaskTableUtil.breakLongToolTipText(strToolTipText, 100);
        }
        oLabel.setToolTipText(strToolTipText);
        return oLabel;
    }

    private Component generateLinkRenderer(ResourceProgressInfo oResourceProgressInfo) {
        JButton oButton = new JButton();
        oButton.setBackground(this.m_oTable.getBackground());
        String strText = oResourceProgressInfo.toString();
        if (IsolationCommonOperation.isIsolationState(oResourceProgressInfo)) {
            strText = ResourceManager.getInstance().getResString("LOCATE_TO_ISOLATION_LINE_NAME");
        }
        if (this.m_bIsCurrentCellSelected) {
            oButton.setText(StringUtils.convertColorsToWhite(strText));
        } else {
            oButton.setText(strText);
        }
        oButton.setToolTipText(strText);
        oButton.setHorizontalAlignment(2);
        oButton.setBorder(this.getBorder());
        oButton.setEnabled(true);
        return oButton;
    }

    private Component generateProgressBar(ProgressInfo oProgressInfo) {
        JProgressBar progressBar = new JProgressBar(0, 0, 100);
        progressBar.setOpaque(true);
        progressBar.setBackground(this.m_oTable.getBackground());
        progressBar.setForeground(new Color(0, 0, 115));
        progressBar.setStringPainted(true);
        if (oProgressInfo instanceof TaskProgressInfo) {
            progressBar.setString(oProgressInfo.toString());
        } else {
            progressBar.setValue(oProgressInfo.getProgress());
        }
        progressBar.setToolTipText(oProgressInfo.toString());
        progressBar.setBorder(DCConstants.DEFAULT_TABLE_CELL_BORDER);
        return progressBar;
    }

    private Component generateResProgressBar(ResourceProgressInfo oProgressInfo) {
        JProgressBar progressBar = new JProgressBar(0, 0, 100);
        progressBar.setOpaque(true);
        progressBar.setBackground(this.m_oTable.getBackground());
        progressBar.setForeground(new Color(0, 0, 115));
        progressBar.setStringPainted(true);
        if (997195801 == oProgressInfo.getErrorNo()) {
            progressBar.setString(oProgressInfo.toString());
        } else {
            progressBar.setValue(oProgressInfo.getProgress());
        }
        progressBar.setToolTipText(oProgressInfo.toString());
        return progressBar;
    }
}

