/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.tasktable;

import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.components.treetable.view.DCTreeTableCellRenderer;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.model.Resource;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;

public class MyCellRenderer
extends DCTreeTableCellRenderer
implements TreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private DCSortableTreeTable m_oTaskTreeTable;
    private Border m_oBorder;

    public MyCellRenderer(DCSortableTreeTable oTaskTreeTable) {
        super(oTaskTreeTable);
        this.m_oTaskTreeTable = oTaskTreeTable;
        this.m_oBorder = BorderFactory.createEtchedBorder(Color.gray, Color.white);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel oLabel = new JLabel();
        oLabel.setOpaque(true);
        oLabel.setIconTextGap(8);
        oLabel.setBorder(this.m_oBorder);
        boolean isEnable = true;
        this.m_bIsCurrentCellSelected = selected;
        TreeTableNode node = (TreeTableNode)value;
        TreeTableRowData nodeInfo = (TreeTableRowData)node.getUserObject();
        if (nodeInfo != null) {
            ImageIcon m_oSelectIcon;
            if (nodeInfo.getNodeType() == 1) {
                m_oSelectIcon = ResourceManager.getInstance().getImage("backuptask.gif");
            } else if (nodeInfo.getNodeType() == 2) {
                if (nodeInfo.getUserObject() instanceof Resource) {
                    Resource oResource = (Resource)nodeInfo.getUserObject();
                    int iDevID = oResource.getDeviceID();
                    m_oSelectIcon = ResourceManager.getInstance().getNeTypeImage(iDevID);
                } else {
                    m_oSelectIcon = ResourceManager.getInstance().getImage("ic_device.gif");
                }
            } else {
                Resource oResource = (Resource)nodeInfo.getUserObject();
                m_oSelectIcon = oResource.getBoardResetType() == 4 || oResource.getBoardResetType() == 5 ? ResourceManager.getInstance().getImage("ic_slot_" + oResource.getBoardResetType() + ".gif") : ResourceManager.getInstance().getImage("ic_slot_0.gif");
            }
            oLabel.setIcon(m_oSelectIcon);
        }
        if (IsolationCommonOperation.isIsolationResource(node) || IsolationCommonOperation.isIsolationResourceForDownGrade(node)) {
            isEnable = this.m_bIsCurrentCellSelected;
        }
        if (this.m_oTaskTreeTable.isRowSelected(row)) {
            oLabel.setBackground(this.m_oTaskTreeTable.getSelectionBackground());
            oLabel.setForeground(Color.white);
        } else {
            oLabel.setBackground(this.m_oTaskTreeTable.getBackground());
            oLabel.setForeground(this.m_oTaskTreeTable.getForeground());
        }
        oLabel.setText(value.toString());
        oLabel.setBorder(null);
        oLabel.setEnabled(isEnable);
        return oLabel;
    }
}

