/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.snmpconfigcom;

import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCSortButtonRenderer;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.compare.CompareFileDialog;
import com.huawei.dc.compare.datasource.ConfigFileControl;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.SnmpConfComInfo;
import com.huawei.dc.taskmgmt.model.SnmpConfComModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class SNMPConfComDialog
extends DCModalDialog {
    private static final long serialVersionUID = -5491291302812282782L;
    private SnmpConfComModel dataModel = null;
    private JPanel jPanel = null;
    private JTable snmpTable = null;
    private JScrollPane scrollPnl = null;
    private int taskId = -1;
    private SnmpConfComInfo[] oSnmpConfComInfoLst = null;

    public SNMPConfComDialog(SnmpConfComInfo[] snmpConfComInfoLst, int iTaskId, String taskName) {
        this.taskId = iTaskId;
        this.oSnmpConfComInfoLst = (SnmpConfComInfo[])CloneUtil.getClone(snmpConfComInfoLst);
        this.initPanel();
        this.jPanel.setSize(800, 600);
        this.jPanel.setLayout(null);
        this.initDataModel();
        this.initTable();
        this.setColumnHeaders();
        this.addTableHeaderListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SNMPConfComDialog.this.tableHeadMousePressed(e);
            }
        });
        this.addSnmpInfoLst(snmpConfComInfoLst);
        this.scrollPnl = new JScrollPane();
        this.scrollPnl.getViewport().add(this.snmpTable);
        this.scrollPnl.setBounds(20, 10, 755, 515);
        this.jPanel.add(this.scrollPnl);
        this.initCloseBtn();
        this.m_oCancelBtn.setBounds(350, 535, 100, 22);
        this.jPanel.add(this.m_oCancelBtn);
        this.setContentPane(this.jPanel);
        this.setTitle(DCFrameWorkUtil.getLocalizedString("SNMP_CONF_TITLE") + "(" + taskName + ")");
        this.setSize(800, 600);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.setResizable(false);
        DCHelpManager.getInstance().enableF1HelpKey(this.getRootPane(), this.getCurrentContext());
    }

    private void tableHeadMousePressed(MouseEvent e) {
        if (0 == (0x10 & e.getModifiers())) {
            return;
        }
        int col = this.snmpTable.getTableHeader().columnAtPoint(e.getPoint());
        TableCellRenderer headRender = this.snmpTable.getColumnModel().getColumn(col).getHeaderRenderer();
        if (null == headRender) {
            return;
        }
        DCSortButtonRenderer sortRenderer = (DCSortButtonRenderer)headRender;
        int sortCol = this.snmpTable.convertColumnIndexToModel(col);
        if (3 == sortCol) {
            int selectedRow = this.snmpTable.getSelectedRow();
            if (sortRenderer.getState(sortCol) == 2) {
                this.dataModel.setSortType(true);
            } else {
                this.dataModel.setSortType(false);
            }
            this.sortData(this.dataModel.getSortType());
            this.snmpTable.setRowSelectionInterval(selectedRow, selectedRow);
            sortRenderer.setPressedColumn(3);
            sortRenderer.setSelectedColumn(3);
            sortRenderer.repaint();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SNMPConfComDialog.this.snmpTable.getTableHeader().updateUI();
                    SNMPConfComDialog.this.snmpTable.updateUI();
                }
            });
        }
    }

    private void sortData(boolean sortType) {
        Object[] tempSnmpConfComInfoLst = (SnmpConfComInfo[])CloneUtil.getClone(this.oSnmpConfComInfoLst);
        Arrays.sort(tempSnmpConfComInfoLst);
        this.dataModel.clear();
        int count = tempSnmpConfComInfoLst.length;
        if (sortType) {
            for (int i = 0; i < count; ++i) {
                this.dataModel.insertRow((SnmpConfComInfo)tempSnmpConfComInfoLst[i]);
            }
        } else {
            for (int i = count - 1; i > -1; --i) {
                this.dataModel.insertRow((SnmpConfComInfo)tempSnmpConfComInfoLst[i]);
            }
        }
    }

    private void addTableHeaderListener(MouseListener l) {
        this.snmpTable.getTableHeader().addMouseListener(l);
    }

    private void setColumnHeaders() {
        DCSortButtonRenderer sortButtonRenderer = new DCSortButtonRenderer();
        this.snmpTable.getColumnModel().getColumn(3).setHeaderRenderer((TableCellRenderer)sortButtonRenderer);
    }

    private void addSnmpInfoLst(SnmpConfComInfo[] snmpConfComInfoLst) {
        if (null == snmpConfComInfoLst || snmpConfComInfoLst.length == 0) {
            return;
        }
        for (SnmpConfComInfo rowData : snmpConfComInfoLst) {
            this.dataModel.insertRow(rowData);
        }
        this.snmpTable.setRowSelectionInterval(0, 0);
        this.updateTable();
    }

    private void updateTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SNMPConfComDialog.this.snmpTable.getTableHeader().updateUI();
                SNMPConfComDialog.this.snmpTable.updateUI();
            }
        });
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_SNMP_CONFIG";
    }

    private void initCloseBtn() {
        if (null != this.m_oCancelBtn) {
            this.m_oCancelBtn.setText(DCFrameWorkUtil.getLocalizedString("CLOSE_BUTTON"));
            this.m_oCancelBtn.setName("SNMPConfComDialog_m_oCancelBtn");
        }
    }

    @Override
    protected void cancelButton_ActionPerformed() {
        DCFrameWorkUtil.setCursor((Component)((Object)this), Cursor.getDefaultCursor());
        this.setModal(false);
        this.setVisible(false);
        this.dispose();
    }

    private void initDataModel() {
        if (null == this.dataModel) {
            this.dataModel = new SnmpConfComModel();
        }
    }

    private void initPanel() {
        if (null == this.jPanel) {
            this.jPanel = new JPanel();
            this.jPanel.setName("SNMPConfComDialog_jPanel");
        }
    }

    private void initTable() {
        if (null == this.snmpTable) {
            this.snmpTable = new JTable(this.dataModel);
            this.snmpTable.setRowHeight(21);
            this.snmpTable.getTableHeader().setReorderingAllowed(false);
            this.snmpTable.setRowSelectionAllowed(true);
            this.snmpTable.setSelectionMode(1);
            this.snmpTable.setFocusable(false);
            this.snmpTable.setName("SNMPConfComDialog_snmpTable");
            int colCount = this.snmpTable.getColumnCount();
            for (int i = 0; i < colCount; ++i) {
                TableColumn column = this.snmpTable.getColumnModel().getColumn(i);
                column.setCellRenderer(new DetailTableRenderer());
            }
            TableColumn reportNameColumn = this.snmpTable.getColumnModel().getColumn(0);
            reportNameColumn.setMaxWidth(0);
            reportNameColumn.setMinWidth(0);
            reportNameColumn.setPreferredWidth(0);
            this.snmpTable.addMouseMotionListener(this.generateMouseMotionAdapter());
            this.snmpTable.addMouseListener(this.generateMouseAdapterForTable());
        }
    }

    private Component renderColumn(JTable table, Object value, boolean isSelected, JLabel label, boolean bLink) {
        if (isSelected) {
            this.setLabelWhenColumnIsSelected(table, label);
        } else {
            this.setLabelWhenColumnIsNotSelected(table, label);
        }
        if (null != value) {
            this.setLabelWhenColumnValueIsNull(value, label, bLink);
        }
        label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.gray));
        return label;
    }

    private void setLabelWhenColumnIsSelected(JTable table, JLabel label) {
        label.setBackground(table.getSelectionBackground());
        label.setForeground(Color.white);
    }

    private void setLabelWhenColumnIsNotSelected(JTable table, JLabel label) {
        label.setBackground(table.getBackground());
        label.setForeground(table.getForeground());
    }

    private void setLabelWhenColumnValueIsNull(Object value, JLabel label, boolean bLink) {
        String strLabelText = value.toString();
        if (bLink) {
            strLabelText = "<html><a href=\"x\">" + strLabelText + "</a>" + "</html>";
        }
        label.setText(strLabelText);
        label.setToolTipText(value.toString());
    }

    private MouseMotionAdapter generateMouseMotionAdapter() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent oMouseEvent) {
                Cursor cur;
                Vector oValue;
                Point oPoint = oMouseEvent.getPoint();
                int iCol = SNMPConfComDialog.this.snmpTable.columnAtPoint(oPoint);
                int iRow = SNMPConfComDialog.this.snmpTable.rowAtPoint(oPoint);
                boolean bHandCursor = false;
                if (4 == iCol && (oValue = SNMPConfComDialog.this.dataModel.getDataVector().elementAt(iRow)) instanceof SnmpConfComInfo && 3 != ((SnmpConfComInfo)((Object)oValue)).getCompareRes()) {
                    bHandCursor = true;
                }
                if (bHandCursor) {
                    cur = new Cursor(12);
                    DCFrameWorkUtil.setCursor(cur);
                } else {
                    cur = new Cursor(0);
                    DCFrameWorkUtil.setCursor(cur);
                }
            }
        };
    }

    private MouseAdapter generateMouseAdapterForTable() {
        return new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
            }

            @Override
            public void mouseClicked(MouseEvent oMouseEvent) {
                Vector oValue;
                Point oPoint = oMouseEvent.getPoint();
                int iCol = SNMPConfComDialog.this.snmpTable.columnAtPoint(oPoint);
                int iRow = SNMPConfComDialog.this.snmpTable.rowAtPoint(oPoint);
                SnmpConfComInfo oSnmpConfComInfo = null;
                if (4 == iCol && (oValue = SNMPConfComDialog.this.dataModel.getDataVector().elementAt(iRow)) instanceof SnmpConfComInfo) {
                    oSnmpConfComInfo = (SnmpConfComInfo)((Object)oValue);
                    if (3 == ((SnmpConfComInfo)((Object)oValue)).getCompareRes()) {
                        return;
                    }
                }
                if (null == oSnmpConfComInfo) {
                    return;
                }
                List<String> cmdReslut = TaskSyncCommController.getInstance().getCommandResultInfo(oSnmpConfComInfo.getDevId(), SNMPConfComDialog.this.taskId);
                if (null == cmdReslut || 2 != cmdReslut.size()) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("COMPARE_PARAMETER_ERROR"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
                } else {
                    CompareFileDialog dialog = new CompareFileDialog((Frame)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("SNMP_CONF_TITLE"), true);
                    dialog.setCompareContentAndInfo(DCFrameWorkUtil.getLocalizedString("PRECHECK_COMMAND_RESULT"), cmdReslut.get(0), DCFrameWorkUtil.getLocalizedString("POSTCHECK_COMMAND_RESULT"), cmdReslut.get(1));
                    ConfigFileControl.releaseResource();
                    dialog.setVisible(true);
                }
            }
        };
    }

    class DetailTableRenderer
    implements TableCellRenderer {
        DetailTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int iRow, int iCol) {
            Vector oValue;
            JLabel label = new JLabel();
            label.setOpaque(true);
            boolean bLink = false;
            if (4 == iCol && (oValue = SNMPConfComDialog.this.dataModel.getDataVector().elementAt(iRow)) instanceof SnmpConfComInfo && 3 != ((SnmpConfComInfo)((Object)oValue)).getCompareRes()) {
                bLink = true;
            }
            return SNMPConfComDialog.this.renderColumn(table, value, isSelected, label, bLink);
        }
    }
}

