/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.modifytask;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activation.view.ActivationOpPanel;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ContentConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.backup.TaskBackupOperation;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.PostcheckOperation;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.PrecheckOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.PostUpgradeOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.PrepareUpgradeOperation;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.standalone.view.RouterDevInfoPanel;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.model.ModifyTaskModel;
import com.huawei.dc.taskmgmt.view.modifytask.ModifyBasePanel;
import gnu.trove.THashSet;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class CopyModifyTaskDialogHelper {
    private CopyModifyTaskDialogHelper() {
    }

    public static boolean checkIsProxiedDevice(ITask oTaskDatObjOld) {
        THashSet<Resource> oResourcesList = oTaskDatObjOld.getSelectedDeviceType().getResources();
        int iSize = oResourcesList.size();
        if (0 < iSize) {
            int[] iDevIds = new int[iSize];
            Iterator oResItor = oResourcesList.iterator();
            Resource oResource = null;
            int i = 0;
            while (oResItor.hasNext()) {
                oResource = (Resource)oResItor.next();
                iDevIds[i] = oResource.getDeviceID();
                ++i;
            }
            RouterDevInfoPanel oRouterDevInfoPanel = DCFrameWorkUtil.getRouterDevInfoPanel();
            if (null != oRouterDevInfoPanel) {
                return oRouterDevInfoPanel.checkIsContainProxiedDev(iDevIds);
            }
        }
        return false;
    }

    public static void getPackageStatesFromTaskObject(THashSet<Resource> resList, THashSet<Resource> cloneResList) {
        if (resList == null || resList.size() == 0) {
            return;
        }
        Iterator oCloneResItor = cloneResList.iterator();
        Resource res2 = null;
        Resource cloneRes = null;
        block0: while (oCloneResItor.hasNext()) {
            cloneRes = (Resource)oCloneResItor.next();
            for (Resource res2 : resList) {
                if (!cloneRes.equals(res2)) continue;
                cloneRes.getProgressInfo().setSWDLStatus(res2.getProgressInfo().getSWDLStatus());
                cloneRes.getProgressInfo().setIntSWDLStatus(res2.getProgressInfo().getIntSWDLStatus());
                continue block0;
            }
        }
    }

    public static void filterStackClusterStep(ITask oTaskDataObj) {
        if (4 != oTaskDataObj.getDeviceType().getDeviceDomain()) {
            ArrayList<ITaskDeviceOperation> supportOprList = new ArrayList<ITaskDeviceOperation>();
            THashSet<Resource> oResLst = oTaskDataObj.getTemporaryDevType().getResources();
            List<ITaskDeviceOperation> curOprList = oTaskDataObj.getSupportedOperation();
            if (DeviceInfoUtil.isStackDevicePresent(oResLst, 3) || oTaskDataObj.isClusterChildDevice() && oTaskDataObj.getDeviceType().isUpgradeModeSupportedByAllDevices(1)) {
                for (ITaskDeviceOperation oTaskOp : curOprList) {
                    if (oTaskOp instanceof PrecheckOperation || oTaskOp instanceof PostcheckOperation || oTaskOp instanceof PrepareUpgradeOperation || oTaskOp instanceof PostUpgradeOperation) continue;
                    supportOprList.add(oTaskOp);
                }
                oTaskDataObj.setSupportedOperation(supportOprList);
            }
        }
    }

    public static void updateBackupConfigParamForFTP(ContentConfigParam oBackupCfParam, boolean bSelected, ModifyTaskModel oModifyTaskDataModel) {
        if (bSelected) {
            Object[] oContentTypeArray = oBackupCfParam.getContentTypeList();
            ContentType oContentType = null;
            for (int i = 0; i < oContentTypeArray.length; ++i) {
                oContentType = (ContentType)oContentTypeArray[i];
                if (Collator.getInstance().equals(oContentType.getId(), "Log") || Collator.getInstance().equals(oContentType.getId(), "Trap")) {
                    oContentType.setSelected(false);
                    oContentType.setEnabled(false);
                }
                oContentType.setDestination("BackupFolder");
                oContentTypeArray[i] = oContentType;
            }
            List<ContentType> oContentTypeList = oBackupCfParam.getSelectedContentType();
            for (int i = oContentTypeList.size() - 1; i >= 0; --i) {
                oContentType = oContentTypeList.get(i);
                if (Collator.getInstance().equals(oContentType.getId(), "Log") || Collator.getInstance().equals(oContentType.getId(), "Trap")) {
                    oContentTypeList.remove(i);
                }
                oContentType.setDestination("BackupFolder");
            }
        } else {
            ContentConfigParam oParam = new ContentConfigParam(oBackupCfParam.getParaList());
            Object[] oContentTypeArray = oParam.getContentTypeList();
            ContentType oContentType = null;
            ArrayList<ContentType> oContentTypeList = new ArrayList<ContentType>(0);
            for (int i = 0; i < oContentTypeArray.length; ++i) {
                oContentType = (ContentType)oContentTypeArray[i];
                oContentType.setSelected(true);
                oContentTypeArray[i] = oContentType;
                oContentTypeList.add(oContentType);
            }
            oParam.setSelectedContentType(oContentTypeList);
            if (oModifyTaskDataModel.getTaskOpObj(2) instanceof TaskBackupOperation) {
                ((TaskBackupOperation)oModifyTaskDataModel.getTaskOpObj(2)).setConfiguredPara(oParam);
            }
        }
    }

    public static boolean checkIsSelectDelayReboot(ModifyTaskModel oModifyTaskDataModel) {
        ActivationOpPanel obj;
        if (null == oModifyTaskDataModel) {
            return false;
        }
        boolean isSlected = false;
        ITaskDeviceOperation oTaskDevOperation = oModifyTaskDataModel.getTaskOpObj(8);
        if (oTaskDevOperation instanceof ActivationOperation && (obj = ((ActivationOperation)oTaskDevOperation).getM_oActivationPanel()) instanceof ActivationOpPanel) {
            ActivationOpPanel activationOpPanel = obj;
            isSlected = activationOpPanel.isSelectDelayReboot();
        }
        return isSlected;
    }

    public static boolean checkIsSelectDelayRebootAndPause(ModifyTaskModel oModifyTaskDataModel) {
        ActivationOpPanel obj;
        if (null == oModifyTaskDataModel) {
            return false;
        }
        boolean isSlected = false;
        ITaskDeviceOperation oTaskDevOperation = oModifyTaskDataModel.getTaskOpObj(8);
        if (oTaskDevOperation instanceof ActivationOperation && (obj = ((ActivationOperation)oTaskDevOperation).getM_oActivationPanel()) instanceof ActivationOpPanel) {
            ActivationOpPanel activationOpPanel = obj;
            isSlected = activationOpPanel.isPauseBeforeCurOp();
        }
        return isSlected;
    }

    public static String getConfirmationString(List<ModifyBasePanel> m_oOpList) {
        DCDebugTracer.trace("method getConfirmationString start");
        int iSizeOfLst = m_oOpList.size();
        StringBuffer tmpStrOperationName = new StringBuffer("");
        String separatorChar = ResourceManager.getInstance().getResString("TARGET_VERSION_CHANGE_MESSAGE_SEP");
        for (int i = 0; i < iSizeOfLst; ++i) {
            ModifyBasePanel oModifyBasePanel = m_oOpList.get(i);
            ITaskDeviceOperation oTaskDevOp = oModifyBasePanel.getTaskOperation();
            if (!oTaskDevOp.isSelected() || oTaskDevOp.getOperationId() == 7) continue;
            tmpStrOperationName.append(oTaskDevOp.getOperationName());
            tmpStrOperationName.append(separatorChar);
            break;
        }
        if (0 == tmpStrOperationName.toString().length()) {
            DCDebugTracer.trace("method getConfirmationString end.. strOperationName is empty");
            return null;
        }
        String strOperationName = tmpStrOperationName.toString();
        strOperationName = strOperationName.substring(0, strOperationName.length() - 1);
        String strConfirmationMsg = ResourceManager.getInstance().getResStringFromPattern("TARGET_VERSION_CHANGE_MESSAGE", "%s", strOperationName);
        DCDebugTracer.trace("method getConfirmationString end..");
        return strConfirmationMsg;
    }
}

