/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.model;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ContentConfigParam;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.ITaskTypeConfiguration;
import com.huawei.dc.taskmgmt.model.ITask;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class TaskMgmtOperationSelecModel {
    private List m_oSuportedOpList = null;

    public List getSupportedOperationLst(ITask oTaskObj, String strDevTypeName, String strDevTypeVerName, DeviceTypeInfo m_oDeviceTypeInfo) throws DCException {
        DCDebugTracer.trace("[upgrade mode] method getSupportedOperationLst start");
        DCDebugTracer.trace("[upgrade mode] strDevTypeName : " + strDevTypeName);
        DCDebugTracer.trace("[upgrade mode] strDevTypeVerName : " + strDevTypeVerName);
        int iTaskType = oTaskObj.getTaskTypeId();
        int iTaskViewType = oTaskObj.getTaskViewType();
        boolean bContainsClusterDev = TaskInfoUtil.isContainsClusterNE(oTaskObj);
        if (bContainsClusterDev) {
            DCDebugTracer.trace("contains cluster device");
            strDevTypeVerName = StringUtils.removePostfix(strDevTypeVerName, "_telnet");
            oTaskObj.getDeviceType().setDeviceTypeVersionName(strDevTypeVerName);
        }
        DeviceTypeInfo oDeviceTypeInfo = (DeviceTypeInfo)CloneUtil.getClone(m_oDeviceTypeInfo);
        oDeviceTypeInfo.setDevTypeName(strDevTypeName);
        oDeviceTypeInfo.setDevTypeVersionName(strDevTypeVerName);
        int[] iDeviceIdLst = TaskInfoUtil.getTaskDeviceIdLst(oTaskObj, oDeviceTypeInfo);
        IDeviceTypeConfigModel oDevTypeModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceTypeInfo, iDeviceIdLst);
        if (null == oDevTypeModel) {
            throw new DCException(ResourceManager.getInstance().getResString("SUPPORTED_OPERATION_NOT_CONFIGURED"));
        }
        this.getSupportedOpFromTaskTypeConfiguration(iTaskType, oDevTypeModel, oTaskObj);
        if (null == this.m_oSuportedOpList) {
            String msg = ResourceManager.getInstance().getResString("TASK_SUPPORTED_OPERATION_NOT_CONFIGURED");
            String hitMsg = MessageFormat.format(msg, "" + oTaskObj.getSelectedDeviceType().getDeviceTypeName(), "" + oTaskObj.getTaskTypeName());
            DCDebugTracer.trace("Method TaskMgmtOperationSelecModel#getSupportedOperationLst Exception oSuportedOpList is null");
            throw new DCException(hitMsg);
        }
        this.getSuppOpForTaskViewType(iTaskViewType);
        this.updateOpListBasedOnTaskContentType(oTaskObj.getTaskContentType(), iTaskViewType, oTaskObj);
        this.updateDependentOpList();
        DCDebugTracer.trace("[upgrade mode] method getSupportedOperationLst end..");
        return this.m_oSuportedOpList;
    }

    private void updateOpListBasedOnTaskContentType(ContentType oTaskContentType, int iTaskViewType, ITask oTaskObj) {
        int iSizeOfLst = this.m_oSuportedOpList.size();
        ITaskDeviceOperation oTaskDevOp = null;
        for (int i = iSizeOfLst - 1; i >= 0; --i) {
            oTaskDevOp = (ITaskDeviceOperation)this.m_oSuportedOpList.get(i);
            if (null != oTaskContentType && Collator.getInstance().equals("CONFIGURATIONFILE", oTaskContentType.getId()) && 5 == oTaskDevOp.getOperationId()) {
                this.m_oSuportedOpList.remove(i);
                continue;
            }
            if (8 == oTaskDevOp.getOperationId()) {
                ActivationConfigPara oActivateConfigPara = (ActivationConfigPara)oTaskDevOp.getConfiguredPara();
                if (null != oTaskContentType) {
                    oActivateConfigPara.setCurrentActivationTypeLst(oTaskContentType.getId(), iTaskViewType, oTaskObj);
                    continue;
                }
                oActivateConfigPara.setCurrentActivationTypeLst("", iTaskViewType, oTaskObj);
                continue;
            }
            if (null != oTaskContentType && 2 == oTaskDevOp.getOperationId()) {
                ContentConfigParam oBackupConfigPara = (ContentConfigParam)oTaskDevOp.getConfiguredPara();
                oBackupConfigPara.setSelectedContentTypeId(oTaskContentType.getId());
                continue;
            }
            if (null == oTaskContentType || 1 != oTaskDevOp.getOperationId()) continue;
            ContentConfigParam oSaveConfigPara = (ContentConfigParam)oTaskDevOp.getConfiguredPara();
            oSaveConfigPara.setSelectedContentTypeId(oTaskContentType.getId());
        }
    }

    private void getSuppOpForTaskViewType(int iTaskViewType) {
        int iSizeofLst = this.m_oSuportedOpList.size();
        ITaskDeviceOperation oTaskDevOp = null;
        boolean isSupported = false;
        for (int i = iSizeofLst - 1; i >= 0; --i) {
            oTaskDevOp = (ITaskDeviceOperation)this.m_oSuportedOpList.get(i);
            isSupported = this.checkIfSupportsViewType(oTaskDevOp, iTaskViewType);
            if (isSupported) continue;
            this.m_oSuportedOpList.remove(i);
        }
    }

    private boolean checkIfSupportsViewType(ITaskDeviceOperation oTaskDevOp, int iTaskViewType) {
        boolean bSupported = false;
        int iOperationLevel = oTaskDevOp.getOperationLevel();
        if (!(1 != iTaskViewType && 3 != iTaskViewType && 5 != iTaskViewType || 0 != iOperationLevel && 2 != iOperationLevel)) {
            bSupported = true;
        } else if (!(2 != iTaskViewType && 4 != iTaskViewType || 1 != iOperationLevel && 2 != iOperationLevel)) {
            bSupported = true;
        }
        return bSupported;
    }

    protected void getSupportedOpFromTaskTypeConfiguration(int iTaskType, IDeviceTypeConfigModel oDevTypeModel, ITask oTask) {
        ITaskTypeConfiguration oTaskConfigurations = oDevTypeModel.getTaskTaskTypeConfiguration();
        this.m_oSuportedOpList = oTaskConfigurations.getCloneTaskOperations(iTaskType, oTask);
    }

    private void updateDependentOpList() {
        DCDebugTracer.trace("[upgrade mode] method updateDependentOpList start");
        int iSizeOfLst = this.m_oSuportedOpList.size();
        ArrayList<Integer> oDependentOpIdLst = null;
        Integer oDependentOperationId = null;
        Integer oOperationId = null;
        for (int i = 0; i < iSizeOfLst; ++i) {
            ITaskDeviceOperation oTaskOpObj = (ITaskDeviceOperation)this.m_oSuportedOpList.get(i);
            DCDebugTracer.trace("[upgrade mode] OperationDesc : " + oTaskOpObj.getOperationDesc());
            oOperationId = oTaskOpObj.getDependsOnOperation();
            oDependentOpIdLst = new ArrayList<Integer>(10);
            for (int j = 0; j < iSizeOfLst; ++j) {
                ITaskDeviceOperation oTaskDevOpObj = (ITaskDeviceOperation)this.m_oSuportedOpList.get(j);
                if (oOperationId.intValue() != oTaskDevOpObj.getOperationId()) continue;
                oDependentOperationId = oTaskDevOpObj.getOperationId();
                oDependentOpIdLst.add(oDependentOperationId);
            }
            oTaskOpObj.setDependentOperation(oDependentOpIdLst);
        }
        DCDebugTracer.trace("[upgrade mode] method updateDependentOpList end..");
    }

    public synchronized void updateList(Integer oTaskId, ITaskDeviceOperation oTaskDevOpObj) {
        ITaskDeviceOperation oTaskDeviceOpObj = null;
        int iSize = this.m_oSuportedOpList.size();
        for (int i = 0; i < iSize; ++i) {
            oTaskDeviceOpObj = (ITaskDeviceOperation)this.m_oSuportedOpList.get(i);
            if (oTaskId.intValue() != oTaskDeviceOpObj.getOperationId()) continue;
            this.m_oSuportedOpList.remove(i);
            this.m_oSuportedOpList.add(i, oTaskDevOpObj);
            break;
        }
    }

    public ITaskDeviceOperation getTaskOpObj(Integer oTaskDevOpId) {
        ITaskDeviceOperation oTaskDevOpObj = null;
        if (null == this.m_oSuportedOpList || null == oTaskDevOpId) {
            return oTaskDevOpObj;
        }
        int iSize = this.m_oSuportedOpList.size();
        for (int i = 0; i < iSize; ++i) {
            oTaskDevOpObj = (ITaskDeviceOperation)this.m_oSuportedOpList.get(i);
            if (null == oTaskDevOpObj) continue;
            if (oTaskDevOpId.intValue() == oTaskDevOpObj.getOperationId()) break;
            oTaskDevOpObj = null;
        }
        return oTaskDevOpObj;
    }

    public boolean isPauseEnabled(Integer oTaskId) {
        boolean bIsSelected = false;
        ITaskDeviceOperation oTaskDevOpObj = null;
        int iSize = this.m_oSuportedOpList.size();
        boolean bIsPrevOpSelec = false;
        for (int i = 0; i < iSize; ++i) {
            oTaskDevOpObj = (ITaskDeviceOperation)this.m_oSuportedOpList.get(i);
            if (oTaskId.intValue() == oTaskDevOpObj.getOperationId()) {
                bIsSelected = oTaskDevOpObj.isSelected();
                break;
            }
            if (!bIsPrevOpSelec && oTaskDevOpObj.isSelected()) {
                bIsPrevOpSelec = true;
            }
            oTaskDevOpObj = null;
        }
        return bIsSelected && bIsPrevOpSelec;
    }

    public List getTaskOpObjLst() {
        return this.m_oSuportedOpList;
    }
}

