/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.model;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.common.util.TaskInfoUtil2;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.IUpgradeSubOperation;
import com.huawei.dc.taskmgmt.model.ITask;
import java.awt.Component;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;

public class ModifyTaskModel {
    private ITask m_oTaskDatObj = null;
    private List<ITaskDeviceOperation> m_OTaskDevOperationLst = null;

    public ModifyTaskModel(ITask oTaskObj) {
        this.m_oTaskDatObj = oTaskObj;
        this.m_OTaskDevOperationLst = this.m_oTaskDatObj.getSupportedOperation();
        this.updateDependentOpList();
    }

    public void setTaskDataObj(ITask oTaskObj) {
        this.m_oTaskDatObj = oTaskObj;
    }

    public ITask getTaskDataObj() {
        return this.m_oTaskDatObj;
    }

    private void updateDependentOpList() {
        int iSizeOfLst = this.m_OTaskDevOperationLst.size();
        ArrayList<Integer> oDependentOpIdLst = null;
        Integer oDependentOperationId = null;
        Integer oOperationId = null;
        for (int i = 0; i < iSizeOfLst; ++i) {
            ITaskDeviceOperation oTaskOpObj = this.m_OTaskDevOperationLst.get(i);
            oOperationId = oTaskOpObj.getOperationId();
            oDependentOpIdLst = new ArrayList<Integer>(10);
            for (int j = 0; j < iSizeOfLst; ++j) {
                ITaskDeviceOperation oTaskDevOpObj = this.m_OTaskDevOperationLst.get(j);
                if (oOperationId.intValue() != oTaskDevOpObj.getDependsOnOperation()) continue;
                oDependentOperationId = oTaskDevOpObj.getOperationId();
                oDependentOpIdLst.add(oDependentOperationId);
            }
            oTaskOpObj.setDependentOperation(oDependentOpIdLst);
        }
    }

    public List<ITaskDeviceOperation> getOperationList() {
        return this.m_OTaskDevOperationLst;
    }

    public void updateOperationLst(int iTaskOpId, ITaskDeviceOperation oTaskDevOp) {
        int iSize = this.m_OTaskDevOperationLst.size();
        ITaskDeviceOperation oTaskDeviceOpObj = null;
        for (int i = 0; i < iSize; ++i) {
            oTaskDeviceOpObj = this.m_OTaskDevOperationLst.get(i);
            if (iTaskOpId != oTaskDeviceOpObj.getOperationId()) continue;
            this.m_OTaskDevOperationLst.remove(i);
            this.m_OTaskDevOperationLst.add(i, oTaskDeviceOpObj);
            break;
        }
    }

    public boolean isPauseEnabled(Integer oTaskId) {
        boolean bIsSelected = false;
        ITaskDeviceOperation oTaskDevOpObj = null;
        int iSize = this.m_OTaskDevOperationLst.size();
        boolean bIsPrevOpSelec = false;
        for (int i = 0; i < iSize; ++i) {
            ActivationOperation oActivateOpr;
            oTaskDevOpObj = this.m_OTaskDevOperationLst.get(i);
            if (oTaskDevOpObj.getOperationId() == oTaskId.intValue() && oTaskId == 8 && (oActivateOpr = (ActivationOperation)oTaskDevOpObj).getActivateConfigPara().isManualReboot()) {
                bIsSelected = oTaskDevOpObj.isSelected();
                bIsPrevOpSelec = true;
                break;
            }
            if (oTaskId.intValue() == oTaskDevOpObj.getOperationId()) {
                bIsSelected = oTaskDevOpObj.isSelected();
                break;
            }
            if (!bIsPrevOpSelec && oTaskDevOpObj.isSelected()) {
                bIsPrevOpSelec = true;
            }
            oTaskDevOpObj = null;
        }
        return bIsSelected && bIsPrevOpSelec;
    }

    public ITaskDeviceOperation getTaskOpObj(int oTaskId) {
        ITaskDeviceOperation oTaskDevOpObj = null;
        int iSize = this.m_OTaskDevOperationLst.size();
        for (int i = 0; i < iSize && oTaskId != (oTaskDevOpObj = this.m_OTaskDevOperationLst.get(i)).getOperationId(); ++i) {
            oTaskDevOpObj = null;
        }
        return oTaskDevOpObj;
    }

    public boolean checkSelectedLoadFiles(String strOpr, IUpgradeSubOperation oUpgradeSubOpr, boolean bShowWarning, Component oComponent) {
        String strMessage;
        String strContentType;
        boolean bRetVal = true;
        if (Collator.getInstance().equals(strOpr, "PostUpgrade") && TaskInfoUtil.getTaskOperation(this.getTaskDataObj(), 33).isSelected()) {
            strContentType = "";
            strMessage = "";
            if (Collator.getInstance().equals(oUpgradeSubOpr.getOperationIdString(), "UpgradePatch")) {
                strContentType = "PATCH";
                strMessage = "DESELECT_UPGRADE_PATCH_SUB_OPERTAION";
            } else if (Collator.getInstance().equals(oUpgradeSubOpr.getOperationIdString(), "ActiveGTL")) {
                strContentType = "GTLLicense";
                strMessage = "DESELECT_ACTIVATE_GTL_SUB_OPERTAION";
            }
            if (oUpgradeSubOpr.isSelected()) {
                bRetVal = TaskInfoUtil.isFileSelectedForContentType(this.getTaskDataObj(), strContentType);
                if (bShowWarning && !bRetVal && !Collator.getInstance().equals("", strMessage)) {
                    DCOptionPane.showMessageDialog(oComponent, DCFrameWorkUtil.getLocalizedString(strMessage), DCFrameWorkUtil.getLocalizedString("WARNING"), 2);
                }
            }
        }
        if (Collator.getInstance().equals(strOpr, "PrepareUpgrade") && TaskInfoUtil.getTaskOperation(this.getTaskDataObj(), 32).isSelected()) {
            strContentType = "";
            strMessage = "";
            if (Collator.getInstance().equals(oUpgradeSubOpr.getOperationIdString(), "UpgradeBootROM")) {
                strContentType = "PROGRAM";
                strMessage = "DESELECT_UPGRADE_BOOT_ROM_SUB_OPERTAION";
            }
            if (oUpgradeSubOpr.isSelected()) {
                boolean bl = bRetVal = TaskInfoUtil.isFileSelectedForContentType(this.getTaskDataObj(), strContentType) || TaskInfoUtil2.isStartupConfigFileSelectedForContentType(this.getTaskDataObj(), strContentType);
                if (bShowWarning && !bRetVal && !Collator.getInstance().equals("", strMessage)) {
                    DCOptionPane.showMessageDialog(oComponent, DCFrameWorkUtil.getLocalizedString(strMessage), DCFrameWorkUtil.getLocalizedString("WARNING"), 2);
                }
            }
        }
        return bRetVal;
    }
}

