/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.createtask;

import com.huawei.dc.adapter.swimap.iview.commstyle.resource.DCResourceMng;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCSaveFileChooser;
import com.huawei.dc.common.util.FileUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ViewCommandResultDialog
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private JPanel m_oCloseBtnPanel = null;
    private JTextArea m_oTextArea;
    private JScrollPane m_oScrollPane;
    protected static final int MIN_PANEL_WIDTH = 633;
    protected static final int MAX_PANEL_HEIGHT = 490;
    private static final Dimension BUTTON_DIMENSION = new Dimension(100, 21);
    private ResourceManager m_ResourceMgnr = ResourceManager.getInstance();
    private String m_strContent = null;
    private String m_strCheckItem = null;

    public ViewCommandResultDialog(String content) {
        this.m_strContent = content;
        this.initialize();
    }

    public ViewCommandResultDialog(String strContent, String strCheckItem) {
        this.m_strContent = strContent;
        this.m_strCheckItem = strCheckItem;
        this.initialize();
    }

    public ViewCommandResultDialog() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(633, 490));
        this.setMinimumSize(new Dimension(633, 490));
        this.m_oTextArea = new JTextArea();
        this.m_oTextArea.setName("TaskMgmt_ViewCommandResultDialog_m_oTextArea");
        this.m_oTextArea.setEditable(false);
        this.m_oTextArea.setTabSize(80);
        if (null != this.m_strContent) {
            this.m_strContent = this.m_strContent.replace('\r', '\n');
        }
        this.m_oTextArea.setText(this.m_strContent);
        this.m_oTextArea.setWrapStyleWord(true);
        this.m_oScrollPane = new JScrollPane(this.m_oTextArea);
        this.m_oScrollPane.setPreferredSize(new Dimension(576, 397));
        this.m_oScrollPane.setMinimumSize(new Dimension(576, 397));
        this.m_oScrollPane.setMaximumSize(new Dimension(576, 397));
        GridBagConstraints areaGrdBagConsts = new GridBagConstraints(0, 0, 6, 5, 1.0, 1.0, 10, 1, new Insets(2, 12, 12, 12), 0, 0);
        this.add(this.m_oScrollPane, areaGrdBagConsts);
        this.m_oCloseBtnPanel = new JPanel();
        this.m_oCloseBtnPanel.setPreferredSize(new Dimension(250, 40));
        this.m_oCloseBtnPanel.setMinimumSize(new Dimension(250, 40));
        this.m_oCloseBtnPanel.setName("devicemanagement_ReportDlg_m_oCloseBtnPanel");
        GridBagLayout layout = new GridBagLayout();
        this.m_oCloseBtnPanel.setLayout(layout);
        this.m_oOKBtn = new JButton();
        this.m_oOKBtn.setName("TaskMgmt_ViewCommandResultDialog_m_OkButton");
        this.m_oOKBtn.setText(this.m_ResourceMgnr.getResString("OK"));
        this.m_oOKBtn.setVerticalTextPosition(3);
        this.m_oOKBtn.setPreferredSize(BUTTON_DIMENSION);
        this.m_oOKBtn.setMinimumSize(BUTTON_DIMENSION);
        this.m_oOKBtn.setMaximumSize(BUTTON_DIMENSION);
        this.m_oSaveBtn = new JButton();
        this.m_oSaveBtn.setName("TaskMgmt_ViewCommandResultDialog_m_oSaveBtn");
        this.m_oSaveBtn.setText(this.m_ResourceMgnr.getResString("SAVE"));
        this.m_oSaveBtn.setVerticalTextPosition(3);
        this.m_oSaveBtn.setMnemonic(83);
        this.m_oSaveBtn.setPreferredSize(BUTTON_DIMENSION);
        this.m_oSaveBtn.setMinimumSize(BUTTON_DIMENSION);
        this.m_oSaveBtn.setMaximumSize(BUTTON_DIMENSION);
        if (null == this.m_strCheckItem) {
            this.m_oSaveBtn.setVisible(false);
        }
        this.m_oCloseBtnPanel.add((Component)this.m_oOKBtn, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 12, 12, 12), 0, 0));
        this.m_oCloseBtnPanel.add((Component)this.m_oSaveBtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 12, 12), 0, 0));
        GridBagConstraints oBtnOKGrdBagConsts = null;
        oBtnOKGrdBagConsts = null != this.m_strCheckItem ? new GridBagConstraints(0, 6, 6, 1, 0.0, 0.0, 13, 0, new Insets(0, 360, 0, 12), 0, 0) : new GridBagConstraints(0, 6, 6, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.add(this.m_oCloseBtnPanel, oBtnOKGrdBagConsts);
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
        this.m_oOKBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewCommandResultDialog.this.performOkAction();
            }
        });
        this.m_oSaveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewCommandResultDialog.this.saveButtonActionPerformed();
            }
        });
        this.setResizable(true);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ViewCommandResultDialog.this.dispose();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ViewCommandResultDialog.this.dispose();
                }
            }
        });
    }

    public void performOkAction() {
        this.closeDialog();
    }

    private void saveButtonActionPerformed() {
        DCSaveFileChooser oFileChooserDlg = null;
        oFileChooserDlg = new DCSaveFileChooser();
        oFileChooserDlg.setFileFilter(3);
        oFileChooserDlg.setAcceptAllFileFilterUsed(false);
        oFileChooserDlg.setEncodingEnabled(true);
        oFileChooserDlg.setDefaultFileName(this.m_strCheckItem);
        int iReturnVal = -1;
        iReturnVal = oFileChooserDlg.showSaveDialog((Component)((Object)this));
        if (iReturnVal == 0) {
            String strFileName = oFileChooserDlg.getFullFileName();
            if (strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".txt") || strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".csv")) {
                this.saveData(strFileName, oFileChooserDlg.getUserEncoding());
            } else {
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("TASK_STATISTICS_TABLE_FILE_TYPE_NOT_SUPP"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
            }
        }
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_TASK_VIEW_COMMAND_BACK_INFO";
    }

    @Override
    public void doCleanUp() {
        this.m_ResourceMgnr = null;
        this.m_oOKBtn = null;
        this.m_oScrollPane = null;
        this.m_oTextArea = null;
        super.doCleanUp();
    }

    @Override
    protected void closeDialog() {
        this.dispose();
        super.closeDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveData(String strFileName, String encoding) {
        FileOutputStream oFileOutputStream = null;
        OutputStreamWriter ouputStreamWriter = null;
        BufferedWriter oBufferedWriter = null;
        try {
            File file = new File(strFileName);
            if (FileUtil.getUTF8Encoding().equalsIgnoreCase(encoding)) {
                FileUtil.addUTFBOMHeader(file);
                oFileOutputStream = new FileOutputStream(file, true);
                ouputStreamWriter = new OutputStreamWriter((OutputStream)oFileOutputStream, encoding);
            } else {
                oFileOutputStream = new FileOutputStream(file);
                ouputStreamWriter = new OutputStreamWriter(oFileOutputStream);
            }
            oBufferedWriter = new BufferedWriter(ouputStreamWriter);
            oBufferedWriter.write(this.m_strContent);
            oBufferedWriter.flush();
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("OPERATION_SUCCESSFUL"), ResourceManager.getInstance().getResString("INFO"), 1);
        }
        catch (Exception e) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("PRINT_ERROR_HALT"), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
        finally {
            if (null != oBufferedWriter) {
                try {
                    oBufferedWriter.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
            if (null != ouputStreamWriter) {
                try {
                    ouputStreamWriter.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
            if (null != oFileOutputStream) {
                try {
                    oFileOutputStream.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
    }

    public JTextArea getContentTextArea() {
        return this.m_oTextArea;
    }
}

