/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.createtask;

import com.huawei.dc.common.DCErrorCode;
import com.huawei.dc.common.asndatacenter.AsnDCSupportISSUReq;
import com.huawei.dc.common.components.dialog.ProgressDlg;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperation;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.LoadSoftwareOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.IUpgradeSubOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.PrepareUpgradeOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.StartupConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.UpgradeSubOperation;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import gnu.trove.THashSet;
import java.awt.Component;
import java.math.BigInteger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ValidateISSU {
    private boolean m_isHasError = false;
    private ITask m_oTask;

    public ValidateISSU(ITask oTask) {
        this.m_oTask = oTask;
    }

    public boolean isHasError() {
        return this.m_isHasError;
    }

    private void setHasError(boolean hasError) {
        this.m_isHasError = hasError;
    }

    public DCErrorCode validateIssu(String strFilePath, int[] iDevIdArray) {
        DCErrorCode oErrInfo = new DCErrorCode(0);
        if (this.m_oTask.isThirdPartySupported()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("CHECK_ISSU_PROMT_FOR_THRID_FTP"), ResourceManager.getInstance().getResString("INFORMATION"), 1);
            return oErrInfo;
        }
        AsnDCSupportISSUReq oAsnCheckISSUReq = new AsnDCSupportISSUReq();
        int iReqId = DCFrameWorkUtil.generateRequestId();
        oAsnCheckISSUReq.oReqID = BigInteger.valueOf(iReqId);
        oAsnCheckISSUReq.strFilePath = strFilePath.getBytes();
        final int iDevCount = iDevIdArray.length;
        for (int iTmpDevId : iDevIdArray) {
            oAsnCheckISSUReq.iDeviceIdLst.add((Object)BigInteger.valueOf(iTmpDevId));
        }
        String strDlgTitle = ResourceManager.getInstance().getResString("CHECK_ISSU_TITLE");
        String[] columnNames = new String[]{ResourceManager.getInstance().getResString("DEVICE_NAME"), ResourceManager.getInstance().getResString("OPERATION_RESULT")};
        this.setHasError(false);
        ProgressDlg oProgressDlg = new ProgressDlg(44085, iDevIdArray, columnNames){
            private static final long serialVersionUID = -8687186801882786526L;
            final Vector<Integer> doNotSupportDeviceLst;
            private int iReciveDevCount;
            {
                super(x0, x1, x2);
                this.doNotSupportDeviceLst = new Vector();
                this.iReciveDevCount = 0;
            }

            @Override
            public void doCleanUp() {
                if (ValidateISSU.this.isHasError()) {
                    this.dispose();
                } else if (this.m_closeBtn.isEnabled()) {
                    this.getM_oDetailsTableModel().getDataVector().removeAllElements();
                    this.dispose();
                }
            }

            @Override
            public void setProgress(String strDisplayName, String strOpResult, int iProgress, int iDeviceId) {
                if (null == strOpResult || strOpResult.length() == 0) {
                    return;
                }
                String error = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(0L));
                if (!Collator.getInstance().equals(strOpResult, error)) {
                    this.doNotSupportDeviceLst.add(iDeviceId);
                    ValidateISSU.this.setHasError(true);
                }
                ++this.iReciveDevCount;
                iProgress = this.iReciveDevCount * 100 / iDevCount;
                if (iProgress > 100) {
                    iProgress = 100;
                }
                super.setProgress(strDisplayName, strOpResult, iProgress, iDeviceId);
                if (100 == iProgress && ValidateISSU.this.isHasError()) {
                    this.setMainErrMessage(ResourceManager.getInstance().getResString("CHECK_ISSU_SOME_DEV_FAIL"));
                }
            }

            public void setMainErrMessage(String strMessage) {
                ImageIcon oIcon = ResourceManager.getInstance().getImage("informationIcon.gif");
                JLabel oInfoLbl = new JLabel(strMessage, oIcon, 2);
                oInfoLbl.setBounds(12, 5 + this.m_iNeedAddHeight, 470, 40);
                this.getContentPane().remove(this.m_progressBar);
                this.getContentPane().add(oInfoLbl);
            }
        };
        oProgressDlg.setProgressDlgId(iReqId);
        oProgressDlg.setTitle(strDlgTitle);
        oProgressDlg.setDefaultCloseOperation(2);
        oErrInfo = TaskAsynCommController.getInstance().checkDevicesIsSupportISSU(oProgressDlg, oAsnCheckISSUReq);
        return oErrInfo;
    }

    public ValidationResult validateISSUSelectedDevices() {
        ValidationResult oValidateResult = new ValidationResult();
        oValidateResult.setErrorCode(0);
        oValidateResult.setErrorMessage(ResourceManager.getInstance().getResString("OPERATION_SUCCESS"));
        THashSet<Resource> resLst = this.m_oTask.getDeviceType().getResources();
        ArrayList<Integer> oDevIdLst = new ArrayList<Integer>();
        Iterator oResItor = resLst.iterator();
        IDeviceInfoManager oDevInfoMgr = DeviceInfoManagerImpl.getInstance();
        boolean isContainSingleMainBoardDev = false;
        while (oResItor.hasNext()) {
            Resource oRes = (Resource)oResItor.next();
            int iDevId = oRes.getDeviceID();
            DeviceInfo oDevInfo = oDevInfoMgr.getDevice(iDevId);
            if (null == oDevInfo || !DCCommonUtil.isCheckMainAndStandbyBoard(oDevInfo.getDeviceTypeInfo().getDevTypeID())) continue;
            oDevIdLst.add(iDevId);
            if (2 != oRes.getIMainBoardNum()) continue;
            isContainSingleMainBoardDev = true;
        }
        if (0 >= oDevIdLst.size()) {
            return oValidateResult;
        }
        if (isContainSingleMainBoardDev) {
            oValidateResult.setErrorCode(-1);
            oValidateResult.setErrorMessage(ResourceManager.getInstance().getResString("CHECK_ISSU_SOME_DEV_SINGLE_MAIM_BOARD"));
            return oValidateResult;
        }
        if (this.isManualAppointStartupSoftware(oDevIdLst)) {
            return oValidateResult;
        }
        String strSoftwarePath = this.getSelectedSoftware();
        if ("".equals(strSoftwarePath)) {
            oValidateResult.setErrorCode(-1);
            oValidateResult.setErrorMessage(ResourceManager.getInstance().getResString("CHECK_ISSU_NOT_SELECT_IMAGE"));
            return oValidateResult;
        }
        int[] iDevIdArray = new int[oDevIdLst.size()];
        int i = 0;
        Iterator i$ = oDevIdLst.iterator();
        while (i$.hasNext()) {
            int iDevId = (Integer)i$.next();
            iDevIdArray[i++] = iDevId;
        }
        if (!this.m_oTask.getIsOffLineTask()) {
            DCErrorCode oErrInfo = this.validateIssu(strSoftwarePath, iDevIdArray);
            oValidateResult.setErrorCode(oErrInfo.getErrorCode());
            oValidateResult.setErrorMessage(oErrInfo.getErrorMsg());
            if (0 == oErrInfo.getErrorCode() && this.isHasError()) {
                oValidateResult.setErrorType(4);
            }
        }
        return oValidateResult;
    }

    public boolean isManualAppointStartupSoftware(List<Integer> oDevIdLst) {
        PrepareUpgradeOperation oPrepareOpr;
        IUpgradeSubOperation oSubOpr;
        ITaskDeviceOperation oTaskOpr = this.m_oTask.getTaskDeviceOperation(32);
        if (oTaskOpr instanceof PrepareUpgradeOperation && oTaskOpr.isSelected() && null != (oSubOpr = (oPrepareOpr = (PrepareUpgradeOperation)oTaskOpr).getUpgradeSubOperation("StartupConfig")) && oSubOpr.isSelected()) {
            UpgradeSubOperation oStartupConfigSubOpr = (UpgradeSubOperation)oSubOpr;
            StartupConfigParam oParam = (StartupConfigParam)oStartupConfigSubOpr.getUpgradeSubOperationConfig();
            if (1 == oParam.getStartupType()) {
                return false;
            }
            THashSet<Resource> oResSet = this.m_oTask.getDeviceType().getResources();
            HashMap<Integer, List<LoadFileInfo>> oFileInfoMap = oParam.getDeviceLoadFileInfoMap();
            if (null == oFileInfoMap || 0 >= oFileInfoMap.size()) {
                return false;
            }
            for (Resource oRes : oResSet) {
                int iDevId = oRes.getDeviceID();
                List<LoadFileInfo> oFileInfos = oFileInfoMap.get(iDevId);
                if (null == oFileInfos) {
                    return false;
                }
                boolean isContainProgram = false;
                for (LoadFileInfo oFileInfo : oFileInfos) {
                    if (!"PROGRAM".equals(oFileInfo.getContentType().getId())) continue;
                    oDevIdLst.remove((Object)oRes.getDeviceID());
                    isContainProgram = true;
                    break;
                }
                if (isContainProgram) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isSelectISSUForATN950() {
        ITaskDeviceOperation oTaskOpr = this.m_oTask.getTaskDeviceOperation(8);
        if (oTaskOpr instanceof ActivationOperation && oTaskOpr.isSelected()) {
            ActivationOperation oActivateOpr = (ActivationOperation)oTaskOpr;
            ActivationConfigPara oParam = (ActivationConfigPara)oActivateOpr.getConfiguredPara();
            return oParam.isSelISSU();
        }
        return false;
    }

    public String getSelectedSoftware() {
        ITaskDeviceOperation oTaskOpr = this.m_oTask.getTaskDeviceOperation(6);
        if (oTaskOpr instanceof LoadSoftwareOperation && oTaskOpr.isSelected()) {
            LoadSoftwareOperation oLoadSWOpr = (LoadSoftwareOperation)oTaskOpr;
            LoadFileInfoListParam oLoadFileParam = (LoadFileInfoListParam)oLoadSWOpr.getConfiguredPara();
            List<LoadFileInfo> oFileInfoLst = oLoadFileParam.getLoadFileInfoList();
            for (LoadFileInfo oFileInfo : oFileInfoLst) {
                if (!"PROGRAM".equals(oFileInfo.getContentType().getId())) continue;
                return oFileInfo.getFileName();
            }
        }
        return "";
    }

    public boolean checkForRemoveManualAppointedStartupImage() {
        if (DCCommonUtil.isContainsDevTypeID(this.m_oTask, 1332) && this.isSelectISSUForATN950() && "".equals(this.getSelectedSoftware())) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("CHECK_ISSU_DEPEND_ON_PREPARE_UPGRADE"), ResourceManager.getInstance().getResString("INFORMATION"), 1);
            return false;
        }
        return true;
    }

    public boolean checkForRemoveSelectedFile() {
        if (DCCommonUtil.isContainsDevTypeID(this.m_oTask, 1332) && this.isSelectISSUForATN950() && !this.isManualAppointStartupSoftware(new ArrayList<Integer>(0))) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("CHECK_ISSU_DEPEND_ON_LOAD"), ResourceManager.getInstance().getResString("INFORMATION"), 1);
            return false;
        }
        return true;
    }
}

