/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.createtask;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.deviceselection.dropdown.DeviceDropDownChangeEvent;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ParamUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.ITaskTypeConfiguration;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.huawei.dc.taskmgmt.view.common.CreateTaskDialog;
import com.huawei.dc.taskmgmt.view.createtask.CreateTaskDeviceSelectionPanel;
import com.huawei.dc.taskmgmt.view.createtask.IDeviceVersionChangeListener;
import com.huawei.dc.taskmgmt.view.createtask.IDeviceVersionEventregisterInterface;
import com.huawei.u2000.framework.help.HelpLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TaskDevSelecPanelWithUpgradeType
extends CreateTaskDeviceSelectionPanel
implements IDeviceVersionEventregisterInterface {
    private static final long serialVersionUID = -8467887499634425616L;
    private ComboBoxWithToolTip m_oUpgradeTypeComboBox = null;
    private ResourceManager m_oResMngr = ResourceManager.getInstance();
    private static final int DEVICE_VERSION_CHANGE = 2;
    private JLabel oUpgradeTypeLbl = null;
    private HelpLabel oUpgradeTypehelpLable = null;

    public TaskDevSelecPanelWithUpgradeType(CreateTaskDialog oDialog, ITask oTaskObj) throws DCException {
        super(oDialog, oTaskObj);
        this.initTaskTypeContentComboBox();
    }

    public TaskDevSelecPanelWithUpgradeType(CreateTaskDialog oDialog, ITask oTaskObj, boolean bInitDeviceSelection) throws DCException {
        this(oDialog, oTaskObj);
        if (bInitDeviceSelection) {
            this.initializeDeviceSelectionForDeviceType(oTaskObj.getDeviceType());
        }
    }

    private void initTaskTypeContentComboBox() {
        this.oUpgradeTypeLbl = new JLabel();
        this.oUpgradeTypeLbl.setText(this.m_oResMngr.getResString("UPGRADE_TYPE_LBL") + " :");
        this.oUpgradeTypeLbl.setPreferredSize(new Dimension(65, 20));
        this.oUpgradeTypeLbl.setMinimumSize(new Dimension(65, 20));
        if (null == this.m_oUpgradeTypeComboBox) {
            this.m_oUpgradeTypeComboBox = new ComboBoxWithToolTip();
            this.m_oUpgradeTypeComboBox.setName("TaskMgmt_TaskDevSelecPanelWithUpgradeType_m_oUpgradeTypeComboBox");
            this.m_oUpgradeTypeComboBox.setPreferredSize(new Dimension(125, 21));
            this.m_oUpgradeTypeComboBox.setMinimumSize(new Dimension(125, 21));
            String stroUpgradeTypeHelpID = ResourceManager.getInstance().getResString("HELP_TOPIC_TASK_UPGRADE_TYPE_LBL", "helpmapfile");
            this.oUpgradeTypehelpLable = new HelpLabel("", stroUpgradeTypeHelpID);
            this.oUpgradeTypehelpLable.setPreferredSize(new Dimension(20, 21));
            this.oUpgradeTypehelpLable.setMinimumSize(new Dimension(20, 21));
            this.oUpgradeTypehelpLable.setIcon((Icon)ResourceManager.getInstance().getImage("help1.png"));
            JPanel jp = new JPanel();
            jp.setLayout(new GridBagLayout());
            jp.add((Component)this.oUpgradeTypeLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 115, 0, 10), 0, 0));
            jp.add((Component)this.m_oUpgradeTypeComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 0, 0, 0), 0, 0));
            if (!DCFrameWorkUtil.isHelpIDFormSA()) {
                jp.add((Component)this.oUpgradeTypehelpLable, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 0, 0, 0), 0, 0));
            }
            this.add((Component)jp, new GridBagConstraints(4, this.m_iLayoutYConstraint, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 115, 0, 10), 0, 0));
            this.fillComboxWithDevType(this.m_oDevTypeInfo);
        }
    }

    private void fillComboxWithDevType(DeviceTypeInfo oDevTypeInfo) {
        if (null == oDevTypeInfo) {
            return;
        }
        int[] iDeviceIdLst = TaskInfoUtil.getTaskDeviceIdLst(this.m_oTaskDataObj, oDevTypeInfo);
        IDeviceTypeConfigModel oDevTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDevTypeInfo, iDeviceIdLst);
        ITaskTypeConfiguration oTaskTypeConfiguration = oDevTypeConfigModel.getTaskTaskTypeConfiguration();
        IParaList oParaList = null;
        oParaList = this.m_oTaskDataObj.getTaskTypeId() == 7 ? oTaskTypeConfiguration.getParaList(7) : oTaskTypeConfiguration.getParaList(0);
        this.fillComboBoxWithUpgradeType(oParaList);
    }

    public boolean isOnlyHasConFigureFileContentTypeWithSWUpgrade() {
        if (null != this.m_oDevTypeInfo) {
            int[] iDeviceIdLst = TaskInfoUtil.getTaskDeviceIdLst(this.m_oTaskDataObj, this.m_oDevTypeInfo);
            IDeviceTypeConfigModel oDevTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(this.m_oDevTypeInfo, iDeviceIdLst);
            ITaskTypeConfiguration oTaskTypeConfiguration = oDevTypeConfigModel.getTaskTaskTypeConfiguration();
            IParaList oParaList = oTaskTypeConfiguration.getParaList(0);
            Object[] arrObj = ParamUtil.getInstance().getContentTypeList(oParaList);
            if (arrObj instanceof ContentType[]) {
                ContentType[] arrContentType = (ContentType[])arrObj;
                int iSizeOfArr = arrContentType.length;
                ContentType oConType = null;
                boolean isConfigurationFileOnly = false;
                for (int i = 0; i < iSizeOfArr; ++i) {
                    oConType = arrContentType[i];
                    if (!"CONFIGURATIONFILE".equals(oConType.getId())) continue;
                    isConfigurationFileOnly = true;
                }
                if (1 == iSizeOfArr && isConfigurationFileOnly) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public ValidationResult validateInput() {
        ContentType oSelectedContentType = (ContentType)this.m_oUpgradeTypeComboBox.getSelectedItem();
        if (null != oSelectedContentType) {
            this.m_oTaskDataObj.setTaskContentType(oSelectedContentType);
        }
        return super.validateInput();
    }

    @Override
    public void onDropDownSelecton(DeviceDropDownChangeEvent oDevDropDownChangeEvent) {
        String StrDevVersion;
        super.onDropDownSelecton(oDevDropDownChangeEvent);
        if (2 == oDevDropDownChangeEvent.getSelectionType() && 0 != (StrDevVersion = oDevDropDownChangeEvent.getSource().toString()).length()) {
            this.onDeviceVersionChangeNoify(StrDevVersion);
        }
        if (null == this.m_oUpgradeTypeComboBox) {
            return;
        }
        int[] iDeviceIdLst = TaskInfoUtil.getTaskDeviceIdLst(this.m_oTaskDataObj, this.m_oDevTypeInfo);
        IDeviceTypeConfigModel oDevTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(this.m_oDevTypeInfo, iDeviceIdLst);
        if (null != oDevTypeConfigModel) {
            ITaskTypeConfiguration oTaskTypeConfiguration = oDevTypeConfigModel.getTaskTaskTypeConfiguration();
            IParaList oParaList = oTaskTypeConfiguration.getParaList(0);
            Object[] arrObj = ParamUtil.getInstance().getContentTypeList(oParaList);
            if (0 == arrObj.length) {
                this.oUpgradeTypeLbl.setVisible(false);
                this.m_oUpgradeTypeComboBox.setVisible(false);
                this.oUpgradeTypehelpLable.setVisible(false);
            } else {
                this.fillComboBoxWithUpgradeType(oParaList);
            }
        } else {
            IDeviceTypeConfigModel oDevTypeCfgModel;
            DeviceType oDevType = this.m_oTaskDataObj.getDeviceType();
            if (null != oDevType && null != (oDevTypeCfgModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDevType))) {
                ITaskTypeConfiguration oTaskTypeConfiguration = oDevTypeCfgModel.getTaskTaskTypeConfiguration();
                IParaList oParaList = oTaskTypeConfiguration.getParaList(0);
                Object[] arrObj = ParamUtil.getInstance().getContentTypeList(oParaList);
                if (0 == arrObj.length) {
                    this.oUpgradeTypeLbl.setVisible(false);
                    this.m_oUpgradeTypeComboBox.setVisible(false);
                    this.oUpgradeTypehelpLable.setVisible(false);
                } else {
                    this.fillComboBoxWithUpgradeType(oParaList);
                }
            }
            this.oUpgradeTypeLbl.setVisible(false);
            this.m_oUpgradeTypeComboBox.setVisible(false);
            this.oUpgradeTypehelpLable.setVisible(false);
        }
    }

    private void fillComboBoxWithUpgradeType(IParaList oParaList) {
        Object[] arrObj = ParamUtil.getInstance().getContentTypeList(oParaList);
        if (arrObj instanceof ContentType[]) {
            ContentType[] arrContentType = (ContentType[])arrObj;
            int iSizeOfArr = arrContentType.length;
            this.m_oUpgradeTypeComboBox.removeAllItems();
            ContentType oConType = null;
            boolean isConfigurationFileOnly = false;
            for (int i = 0; i < iSizeOfArr; ++i) {
                oConType = arrContentType[i];
                this.m_oUpgradeTypeComboBox.addItem(oConType);
                if (!"CONFIGURATIONFILE".equals(oConType.getId())) continue;
                isConfigurationFileOnly = true;
            }
            isConfigurationFileOnly = 1 == iSizeOfArr && isConfigurationFileOnly;
            this.m_oUpgradeTypeComboBox.setVisible(!isConfigurationFileOnly);
            this.oUpgradeTypeLbl.setVisible(!isConfigurationFileOnly);
            this.oUpgradeTypehelpLable.setVisible(!isConfigurationFileOnly);
        }
        this.m_oUpgradeTypeComboBox.updateUI();
        this.m_oUpgradeTypeComboBox.repaint();
        this.updateUI();
    }

    @Override
    public void onDeviceVersionChangeNoify(String strVersion) {
        int iListenerSize = this.m_oVersionChangeListenerlist.size();
        IDeviceVersionChangeListener oDevVersionChangeListener = null;
        for (int index = 0; index < iListenerSize; ++index) {
            oDevVersionChangeListener = (IDeviceVersionChangeListener)this.m_oVersionChangeListenerlist.get(index);
            oDevVersionChangeListener.deviceVersionChangeNotification(strVersion);
        }
    }

    @Override
    public void addDeviceVersionChangelistener(IDeviceVersionChangeListener oDeviceVersionChangeListener) {
        this.m_oVersionChangeListenerlist.add(oDeviceVersionChangeListener);
    }

    @Override
    public void removeDeviceVersionChangelistener(IDeviceVersionChangeListener oDeviceVersionChangeListener) {
        this.m_oVersionChangeListenerlist.remove(oDeviceVersionChangeListener);
    }
}

