/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.createtask;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.deviceselection.dropdown.DeviceDropDownChangeEvent;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.huawei.dc.taskmgmt.view.common.CreateTaskDialog;
import com.huawei.dc.taskmgmt.view.createtask.CreateTaskDeviceSelectionPanel;
import com.huawei.dc.taskmgmt.view.createtask.IDeviceVersionChangeListener;
import com.huawei.dc.taskmgmt.view.createtask.IDeviceVersionEventregisterInterface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JLabel;

public class TaskDevSelecPanelWithUpgradeLevel
extends CreateTaskDeviceSelectionPanel
implements IDeviceVersionEventregisterInterface {
    private static final long serialVersionUID = -848973431655924495L;
    private ComboBoxWithToolTip m_oActivationLevelComboBox = null;
    private ResourceManager m_oResMngr = ResourceManager.getInstance();

    public TaskDevSelecPanelWithUpgradeLevel(CreateTaskDialog oDialog, ITask oTaskObj) throws DCException {
        super(oDialog, oTaskObj);
        JLabel oActivationLevelLbl = new JLabel();
        oActivationLevelLbl.setPreferredSize(new Dimension(90, 20));
        oActivationLevelLbl.setMinimumSize(new Dimension(90, 20));
        oActivationLevelLbl.setText(this.m_oResMngr.getResString("PACKAGE_DIFFUSION_ACTIVATION_LEVEL_LABEL"));
        this.add((Component)oActivationLevelLbl, new GridBagConstraints(4, this.m_iLayoutYConstraint, 1, 1, 1.0, 0.0, 13, 0, new Insets(22, 0, 0, 12), 0, 0));
        this.initActivationTypeComboBox();
    }

    public TaskDevSelecPanelWithUpgradeLevel(CreateTaskDialog oDialog, ITask oTaskObj, boolean bInitDeviceSelection) throws DCException {
        this(oDialog, oTaskObj);
        if (bInitDeviceSelection) {
            this.initializeDeviceSelectionForDeviceType(oTaskObj.getDeviceType());
        }
    }

    private void initActivationTypeComboBox() {
        this.m_oActivationLevelComboBox = new ComboBoxWithToolTip();
        this.m_oActivationLevelComboBox.setName("TaskMgmt_TaskDevSelecPanelWithUpgradeLevel_m_oActivationLevelComboBox");
        this.fillTaskLevelComboBox();
        this.m_oActivationLevelComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TaskDevSelecPanelWithUpgradeLevel.this.activationLevel_ActionPerformed();
            }
        });
        this.m_oActivationLevelComboBox.setPreferredSize(new Dimension(158, 20));
        this.m_oActivationLevelComboBox.setMinimumSize(new Dimension(158, 20));
        this.m_oActivationLevelComboBox.setSelectedIndex(0);
        this.add((Component)this.m_oActivationLevelComboBox, new GridBagConstraints(5, this.m_iLayoutYConstraint, 1, 1, 0.0, 0.0, 13, 0, new Insets(22, 10, 0, 12), 0, 0));
    }

    private void fillTaskLevelComboBox() {
        boolean isTL1Dev = false;
        if (null != this.m_oDevTypeInfo) {
            isTL1Dev = DCCommonUtil.isTL1Dev(this.m_oDevTypeInfo);
        }
        this.m_oActivationLevelComboBox.addItem(this.m_oResMngr.getResString("PACKAGE_DIFFUSION_ACTIVATION_LEVEL_DEVICE"));
        if (!isTL1Dev) {
            this.m_oActivationLevelComboBox.addItem(this.m_oResMngr.getResString("PACKAGE_DIFFUSION_ACTIVATION_LEVEL_BOARD"));
        }
    }

    public void updateDiffCom(boolean isTL1Dev) {
        if (null == this.m_oActivationLevelComboBox) {
            return;
        }
        Object obj = this.m_oActivationLevelComboBox.getSelectedItem();
        int iSize = this.m_oActivationLevelComboBox.getItemCount();
        this.m_oActivationLevelComboBox.removeAllItems();
        this.m_oActivationLevelComboBox.addItem(this.m_oResMngr.getResString("PACKAGE_DIFFUSION_ACTIVATION_LEVEL_DEVICE"));
        if (!isTL1Dev) {
            this.m_oActivationLevelComboBox.addItem(this.m_oResMngr.getResString("PACKAGE_DIFFUSION_ACTIVATION_LEVEL_BOARD"));
        }
        if (iSize == this.m_oActivationLevelComboBox.getItemCount()) {
            this.m_oActivationLevelComboBox.setSelectedItem(obj);
        }
    }

    private void activationLevel_ActionPerformed() {
        LoadFileInfoListParam loadFileInfoListParam;
        ITaskDeviceOperation oTaskDevOpData;
        if (0 == this.m_oActivationLevelComboBox.getSelectedIndex()) {
            this.m_oTaskDataObj.setUpgradeLevel(1);
        }
        if (1 == this.m_oActivationLevelComboBox.getSelectedIndex()) {
            this.m_oTaskDataObj.setUpgradeLevel(2);
        }
        if (null != (oTaskDevOpData = this.m_oTaskDataObj.getTaskDeviceOperation(6)) && null != (loadFileInfoListParam = (LoadFileInfoListParam)oTaskDevOpData.getConfiguredPara())) {
            ArrayList<LoadFileInfo> oLoadFileInfoList = new ArrayList<LoadFileInfo>();
            loadFileInfoListParam.setLoadFileInfoList(oLoadFileInfoList);
        }
    }

    @Override
    public ValidationResult validateInput() {
        ValidationResult oResult = super.validateInput();
        if (null != oResult && 0 != oResult.getErrorCode()) {
            return oResult;
        }
        if (null != this.m_oActivationLevelComboBox && -1 == this.m_oActivationLevelComboBox.getSelectedIndex()) {
            oResult = new ValidationResult();
            oResult.setErrorCode(-1);
            oResult.setErrorMessage(ResourceManager.getInstance().getResString("PACKAGE_DIFFUSION_ACTIVATION_LEVEL_ERROR"));
        }
        return oResult;
    }

    @Override
    public void onDropDownSelecton(DeviceDropDownChangeEvent oDevDropDownChangeEvent) {
        super.onDropDownSelecton(oDevDropDownChangeEvent);
        if (oDevDropDownChangeEvent.getSource() instanceof DeviceTypeInfo) {
            DeviceTypeInfo devTypeInfo = (DeviceTypeInfo)oDevDropDownChangeEvent.getSource();
            this.updateDiffCom(DCCommonUtil.isTL1Dev(devTypeInfo));
        }
    }

    @Override
    public void onDeviceVersionChangeNoify(String strVersion) {
        int iListenerSize = this.m_oVersionChangeListenerlist.size();
        IDeviceVersionChangeListener oDevVersionChangeListener = null;
        for (int index = 0; index < iListenerSize; ++index) {
            oDevVersionChangeListener = (IDeviceVersionChangeListener)this.m_oVersionChangeListenerlist.get(index);
            oDevVersionChangeListener.deviceVersionChangeNotification(strVersion);
        }
    }

    @Override
    public void addDeviceVersionChangelistener(IDeviceVersionChangeListener oDeviceVersionChangeListener) {
        this.m_oVersionChangeListenerlist.add(oDeviceVersionChangeListener);
    }

    @Override
    public void removeDeviceVersionChangelistener(IDeviceVersionChangeListener oDeviceVersionChangeListener) {
        this.m_oVersionChangeListenerlist.remove(oDeviceVersionChangeListener);
    }
}

