/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.createtask;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperationUtil;
import com.huawei.dc.taskmgmt.controller.UpModeCheckController;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.huawei.dc.taskmgmt.view.common.TaskBasePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class TaskConfirmationPanel
extends TaskBasePanel {
    private static final long serialVersionUID = 1L;
    private static final String BlankSpace = "  ";
    private JTextPane m_oTextArea;
    private JScrollPane m_oScrollPane;
    private StringBuffer m_oStyleDoc = null;
    private ITask m_oTask;

    public TaskConfirmationPanel() {
        GridBagLayout thisLayout = new GridBagLayout();
        this.setLayout(thisLayout);
        JLabel oLabel = new JLabel(ResourceManager.getInstance().getResString("CREATE_TASK_CONFIRMATION_TITLE"));
        oLabel.setPreferredSize(new Dimension(400, 20));
        oLabel.setMinimumSize(new Dimension(400, 20));
        this.add((Component)oLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_oTextArea = new JTextPane();
        this.m_oTextArea.setName("TaskMgmt_TaskConfirmationPanel_m_oTextArea");
        this.m_oTextArea.setEditable(false);
        this.m_oTextArea.setContentType("text/html");
        this.m_oStyleDoc = new StringBuffer();
        this.m_oScrollPane = new JScrollPane(this.m_oTextArea);
        this.m_oScrollPane.setPreferredSize(new Dimension(600, 310));
        this.m_oScrollPane.setMinimumSize(new Dimension(600, 310));
        this.add((Component)this.m_oScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(12, 0, 0, 12), 0, 0));
    }

    @Override
    public void initPanelComponent(ITask taskDataObj) throws DCException {
        this.m_oTask = taskDataObj;
        this.m_oStyleDoc = new StringBuffer();
        List<ITaskDeviceOperation> oTaskDeviceOperationList = taskDataObj.getSupportedOperation();
        int iSize = oTaskDeviceOperationList.size();
        try {
            String strTargetVer;
            this.m_oStyleDoc.append("<body>");
            if (!this.m_oTask.isThirdPartySupported() && null != (strTargetVer = taskDataObj.getTargetVersion()) && !"".equals(strTargetVer)) {
                String strTargetLab = ResourceManager.getInstance().getResString("TARGET_VERSION_LABEL_CONFIRMATION");
                this.m_oStyleDoc.append("<p><b>[" + strTargetLab + ']' + "</b>");
                this.m_oStyleDoc.append("<br><dl><dd>" + strTargetVer + "</dl>" + "</p>");
            }
            if (UpModeCheckController.getInstance().isShowThirdPartyFTP(this.m_oTask) && this.m_oTask.isThirdPartySupported()) {
                String strThirdPartyFTPLabel = DCFrameWorkUtil.getLocalizedString("THIRD_PARTY_FTP_LABEL_CONFIRMATION");
                this.m_oStyleDoc.append("<p><b>[" + strThirdPartyFTPLabel + ']' + "</b>");
                String strThirdPartyFTP = DCFrameWorkUtil.getLocalizedString("PAUSE_ENABLED_FTP");
                this.m_oStyleDoc.append("<br><dl><dd>" + strThirdPartyFTP + "</dl>" + "</p>");
            }
            if (null != this.m_oTask.getStartTime()) {
                String strTaskStartTimeLabel = DCFrameWorkUtil.getLocalizedString("TASK_START_TIME_LABEL_CONFIRMATION");
                this.m_oStyleDoc.append("<p><b>[" + strTaskStartTimeLabel + ']' + "</b>");
                String strTaskStartTime = DCTimeDateUtil.getLocaleDisplayTime(this.m_oTask.getStartTime());
                this.m_oStyleDoc.append("<br><dl><dd>" + strTaskStartTime + "</dl>" + "</p>");
            }
            for (int iTaskOperationIndex = 0; iTaskOperationIndex < iSize; ++iTaskOperationIndex) {
                ITaskDeviceOperation oOperation = oTaskDeviceOperationList.get(iTaskOperationIndex);
                if (!oOperation.isSelected()) continue;
                if (oOperation instanceof ActivationOperation) {
                    ActivationOperation activationOperation = (ActivationOperation)oOperation;
                    ActivationConfigPara configuredPara = (ActivationConfigPara)activationOperation.getConfiguredPara();
                    try {
                        configuredPara.setElementInfoLst(ActivationOperationUtil.getElementInfo(configuredPara, "GroupActivation"));
                    }
                    catch (Exception ignore) {
                        DCDebugTracer.trace(ignore);
                    }
                }
                String strPauseBeforeCurOp = null;
                boolean bPauseBeforeCurOp = oOperation.isPauseBeforeCurOp();
                strPauseBeforeCurOp = bPauseBeforeCurOp ? BlankSpace + ResourceManager.getInstance().getResString("PAUSE_ENABLED") : BlankSpace + ResourceManager.getInstance().getResString("PAUSE_DISABLED");
                String strPauseStatus = BlankSpace + ResourceManager.getInstance().getResString("PAUSE_BEFORE_CURRENT_OPERATION") + strPauseBeforeCurOp;
                this.m_oStyleDoc.append("<p><b>[" + oOperation.getOperationName() + ']' + "</b><br>");
                if ("ISSUCheck".equals(oOperation.getOperationIdString())) {
                    String str1 = "<dl><dd>" + oOperation.getOperationDesc();
                    this.m_oStyleDoc.append(str1);
                } else {
                    String str = "<dl><dd>" + ((Object)oOperation).toString();
                    this.m_oStyleDoc.append(str);
                }
                this.m_oStyleDoc.append("<br>" + strPauseStatus + "</dl></p>");
            }
            if (this.m_oTask.isUpgradeFeasibilityRequired()) {
                if (this.m_oTask.isUpgradeFeasibilitySuccess()) {
                    this.m_oStyleDoc.append("<p><b>" + DCFrameWorkUtil.getLocalizedString("UPGRADE_FEASIBILITY_SUCCESS_SUMMARY_MESSAGE") + "</b><br></p>");
                } else {
                    this.m_oStyleDoc.append("<p><b>" + DCFrameWorkUtil.getLocalizedString("UPGRADE_FEASIBILITY_FAILURE_SUMMARY_MESSAGE") + "</b><br></p>");
                }
            }
            this.m_oStyleDoc.append("</body>");
            this.m_oTextArea.setText(this.m_oStyleDoc.toString());
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    @Override
    public ValidationResult validateInput() {
        return null;
    }

    @Override
    public String getTaskDialogTitle() {
        StringBuffer strTitle = new StringBuffer(10);
        strTitle.append(ResourceManager.getInstance().getResString("TASK_DIALOG_TASK_CONFIRM"));
        strTitle.append(" [");
        strTitle.append(this.m_oTask.getTaskTypeName());
        strTitle.append(']');
        return strTitle.toString();
    }

    protected void addStylesToDocument(StyledDocument oStyleDoc) {
        Style oStyleDefn = StyleContext.getDefaultStyleContext().getStyle("default");
        Style oRegularStyle = oStyleDoc.addStyle("regular", oStyleDefn);
        StyleConstants.setFontFamily(oStyleDefn, "SansSerif");
        Style oStyle = oStyleDoc.addStyle("italic", oRegularStyle);
        StyleConstants.setItalic(oStyle, true);
        oStyle = oStyleDoc.addStyle("bold", oRegularStyle);
        StyleConstants.setBold(oStyle, true);
        oStyle = oStyleDoc.addStyle("small", oRegularStyle);
        StyleConstants.setFontSize(oStyle, 10);
        oStyle = oStyleDoc.addStyle("large", oRegularStyle);
        StyleConstants.setFontSize(oStyle, 16);
    }

    public void cleanUp() {
        this.m_oScrollPane = null;
        this.m_oStyleDoc = null;
        this.m_oTask = null;
        this.m_oTextArea = null;
        this.removeAll();
    }

    public ITask getUpdatedTaskObj() {
        return null;
    }
}

