/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.copytask;

import com.huawei.dc.adapter.swimap.imap12.util.DCInmLengthLimitTextField;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.ValidationUtility;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperation;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.controller.ITaskSyncCommController;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.Task;
import com.huawei.dc.taskmgmt.view.modifytask.CopyModifyTaskDialog;
import com.huawei.dc.taskmgmt.view.modifytask.CopyModifyTaskDialogHelper;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class CopyTaskDlg
extends DCModalDialog {
    private ITask m_oNewTask = new Task();
    private DCInmLengthLimitTextField m_oNameTextField;
    private JLabel m_oTaskNameLabel;
    private ITask m_oExitingTask;
    private ResourceManager oRes = ResourceManager.getInstance();
    private ITaskSyncCommController m_oTaskController = this.getInstance();
    private int COPY_TASK = 1;
    private ButtonGroup m_oButtonGroup = null;
    private JRadioButton m_oAllDevButton = null;
    private JRadioButton m_oFailDevButton = null;
    private int DEVICE_PROGRESS_PAUSE = 989855882;
    private int DEVICE_PROGRESS_SUCCESS = 0;
    private int DEVICE_PROGRESS_NO_RUN = -1;

    public CopyTaskDlg(ITask oTask) {
        this.initCopyDialog(oTask);
        this.alignComponents();
        this.addComponents();
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    private void initCopyDialog(ITask oTask) {
        this.setResizable(false);
        this.setSize(284, 134);
        this.setTitle(this.oRes.getResString("COPY_TASK_DIALOG_TITTLE"));
        this.getContentPane().setLayout(null);
        this.m_oExitingTask = oTask;
        this.initComponents();
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
    }

    private void initComponents() {
        this.m_oTaskNameLabel = new JLabel(this.oRes.getResString("ENTER_NAME_FOR_NEW_TASK"));
        this.m_oNameTextField = new DCInmLengthLimitTextField(255);
        this.m_oNameTextField.setName("TaskMgmt_CopyTaslDlg_m_oNameTextField");
        SimpleDateFormat oTimeStampFormat = new SimpleDateFormat("yyMMddHHmmss");
        Date oTimeStamp = new Date();
        this.m_oNameTextField.setText(ResourceManager.getInstance().getResString("TASK") + '_' + oTimeStampFormat.format(oTimeStamp));
        this.m_oButtonGroup = new ButtonGroup();
        this.m_oFailDevButton = new JRadioButton(DCFrameWorkUtil.getLocalizedString("TASKMGMT_COPYTASKDLG_M_OFAILDEVBUTTON"));
        this.m_oFailDevButton.setName("TaskMgmt_CopyTaslDlg_m_oFailDevButton");
        this.m_oAllDevButton = new JRadioButton(DCFrameWorkUtil.getLocalizedString("TASKMGMT_COPYTASKDLG_M_OALLDEVBUTTON"));
        this.m_oAllDevButton.setSelected(true);
        this.m_oAllDevButton.setName("TaskMgmt_CopyTaslDlg_m_oAllDevButton");
        this.m_oButtonGroup.add(this.m_oAllDevButton);
        this.m_oButtonGroup.add(this.m_oFailDevButton);
        this.m_oOKBtn.setText(this.oRes.getResString("OK"));
        this.m_oOKBtn.setName("TaskMgmt_CopyTaslDlg_m_oOKBtn");
        this.m_oCancelBtn.setText(this.oRes.getResString("CANCEL"));
        this.m_oCancelBtn.setName("TaskMgmt_CopyTaslDlg_m_oCancelBtn");
    }

    private void addComponents() {
        boolean isFailed = false;
        DeviceType oDeviceType = this.m_oExitingTask.getDeviceType();
        THashSet<Resource> oResources = oDeviceType.getResources();
        int iTaskState = this.m_oExitingTask.getTaskProgressInfo().getState();
        int iTaskResult = this.m_oExitingTask.getTaskProgressInfo().getResult();
        if (iTaskState == 3 && iTaskResult == 0) {
            isFailed = false;
        } else {
            Iterator oResItor = oResources.iterator();
            Resource oResource = null;
            while (oResItor.hasNext()) {
                oResource = (Resource)oResItor.next();
                ResourceProgressInfo oResourceProgressInfo = oResource.getProgressInfo();
                if (oResourceProgressInfo.getErrorNo() == this.DEVICE_PROGRESS_NO_RUN || oResourceProgressInfo.getErrorNo() == this.DEVICE_PROGRESS_SUCCESS || oResourceProgressInfo.getErrorNo() == this.DEVICE_PROGRESS_PAUSE) continue;
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            this.getContentPane().add(this.m_oTaskNameLabel);
            this.getContentPane().add((Component)this.m_oNameTextField);
            this.getContentPane().add(this.m_oAllDevButton);
            this.getContentPane().add(this.m_oFailDevButton);
            this.getContentPane().add(this.m_oOKBtn);
            this.getContentPane().add(this.m_oCancelBtn);
        } else {
            this.setSize(284, 105);
            this.m_oOKBtn.setBounds(81, 41, 90, 20);
            this.m_oCancelBtn.setBounds(176, 41, 90, 20);
            this.getContentPane().add(this.m_oTaskNameLabel);
            this.getContentPane().add((Component)this.m_oNameTextField);
            this.getContentPane().add(this.m_oOKBtn);
            this.getContentPane().add(this.m_oCancelBtn);
        }
    }

    private void alignComponents() {
        this.m_oTaskNameLabel.setBounds(10, 11, 110, 21);
        this.m_oNameTextField.setBounds(117, 11, 150, 21);
        this.m_oAllDevButton.setBounds(10, 41, 110, 21);
        this.m_oFailDevButton.setBounds(117, 41, 110, 21);
        this.m_oOKBtn.setBounds(81, 72, 90, 20);
        this.m_oCancelBtn.setBounds(176, 72, 90, 20);
    }

    @Override
    protected void oKButton_ActionPerformed() {
        String sTaskName = this.m_oNameTextField.getText();
        boolean bTaskNameValid = this.validateTaskName(sTaskName);
        if (bTaskNameValid) {
            this.createNewTask(sTaskName);
        }
    }

    protected ITaskSyncCommController getInstance() {
        ITaskSyncCommController oTaskController = TaskSyncCommController.getInstance();
        return oTaskController;
    }

    private boolean validateTaskName(String strTaskName) {
        return this.validateForEmptyStringTaskName(strTaskName);
    }

    private boolean validateForEmptyStringTaskName(String strTaskName) {
        if (strTaskName.length() > 0) {
            return !this.checkForSpecialCharacters(strTaskName) && !this.checkForTaskNameLength(strTaskName) && !this.checkWhetherNameAlreadyExist(strTaskName);
        }
        String strMessage = this.oRes.getResString("TASK_NAME_CANNOT_BE_BLANK");
        DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), strMessage);
        return false;
    }

    private boolean checkWhetherNameAlreadyExist(String strTaskName) {
        int iErroCode = this.m_oTaskController.checkIfTaskNameExist(strTaskName);
        if (0 != iErroCode) {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), BigInteger.valueOf(iErroCode));
            return true;
        }
        return false;
    }

    private boolean checkForSpecialCharacters(String strTaskName) {
        boolean isValidName = ValidationUtility.validateName(strTaskName, false);
        if (!isValidName) {
            String strMessage = this.oRes.getResString("TASK_NAME_TIP");
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), strMessage);
            return true;
        }
        return false;
    }

    private boolean checkForTaskNameLength(String strTaskName) {
        boolean isValidName;
        boolean bl = isValidName = strTaskName.trim().length() > 50;
        if (isValidName) {
            String strMessage = this.oRes.getResString("TASK_NAME_TIP");
            this.showErrorMessage(strMessage);
            return true;
        }
        return false;
    }

    private void createNewTask(String strTaskName) {
        this.setDefaultConfigurationForTask(strTaskName);
        try {
            this.getCopyModifyTaskDialogInstance();
        }
        catch (DCException ex) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ex.getErrorCode(), ResourceManager.getInstance().getResString("Error"), 0);
        }
    }

    protected void getCopyModifyTaskDialogInstance() throws DCException {
        CopyModifyTaskDialog oCopyModifyTaskDialog = new CopyModifyTaskDialog(this.m_oNewTask, ResourceManager.getInstance().getResString("COPY_TASK_DIALOG_TITTLE"), 43872, this.COPY_TASK);
        this.dispose();
        oCopyModifyTaskDialog.setVisible(true);
    }

    private void setDefaultConfigurationForTask(String strTaskName) {
        this.m_oNewTask = (ITask)CloneUtil.getClone(this.m_oExitingTask);
        this.m_oNewTask.setTaskName(strTaskName);
        this.m_oNewTask.setTaskId(-1);
        CopyModifyTaskDialogHelper.getPackageStatesFromTaskObject(this.m_oExitingTask.getDeviceType().getResources(), this.m_oNewTask.getDeviceType().getResources());
        if (this.m_oFailDevButton.isSelected()) {
            DCDebugTracer.trace("copy task with failed NE");
            DeviceType oDeviceType = this.m_oNewTask.getDeviceType();
            if (oDeviceType == null) {
                return;
            }
            THashSet<Resource> oResources = oDeviceType.getResources();
            if (oResources == null) {
                return;
            }
            Iterator oResItor = oResources.iterator();
            Resource oResource = null;
            while (oResItor.hasNext()) {
                oResource = (Resource)oResItor.next();
                ResourceProgressInfo oResourceProgressInfo = oResource.getProgressInfo();
                if (oResourceProgressInfo.getErrorNo() != this.DEVICE_PROGRESS_NO_RUN && oResourceProgressInfo.getErrorNo() != this.DEVICE_PROGRESS_SUCCESS && oResourceProgressInfo.getErrorNo() != this.DEVICE_PROGRESS_PAUSE) continue;
                oResItor.remove();
            }
            this.removeNotFailedNEInActivateGroup(this.m_oNewTask);
            DeviceType oTemporaryDeviceType = this.m_oNewTask.getTemporaryDevType();
            if (oTemporaryDeviceType == null) {
                return;
            }
            THashSet<Resource> oTemporaryResources = oTemporaryDeviceType.getResources();
            if (oTemporaryResources == null) {
                return;
            }
            Iterator oTmpResItor = oTemporaryResources.iterator();
            while (oTmpResItor.hasNext()) {
                oResource = (Resource)oTmpResItor.next();
                if (!oResource.isUpgradeFail()) continue;
                oTmpResItor.remove();
            }
        }
    }

    private void removeNotFailedNEInActivateGroup(ITask oTask) {
        ITaskDeviceOperation oActivationOperation = TaskInfoUtil.getTaskOperation(oTask, 8);
        if (!(oActivationOperation instanceof ActivationOperation)) {
            return;
        }
        ActivationOperation oActivateOpr = (ActivationOperation)oActivationOperation;
        ActivationConfigPara oActivationPara = oActivateOpr.getActivateConfigPara();
        if (null == oActivationPara) {
            return;
        }
        List oElementInfoLst = oActivationPara.getElementInfoLst();
        if (null == oElementInfoLst) {
            return;
        }
        Iterator oEleItor = oElementInfoLst.iterator();
        ActivationElementInfo oActiationElement = null;
        int iGroupID = -1;
        Resource oRes = null;
        TIntArrayList oExistGroupIDLst = new TIntArrayList();
        boolean bNeedCheckNullGroup = false;
        while (oEleItor.hasNext()) {
            oActiationElement = (ActivationElementInfo)oEleItor.next();
            if (null == oActiationElement) continue;
            iGroupID = oActiationElement.getGroupId();
            oRes = oActiationElement.getResource();
            if (this.isNotFailled(oRes)) {
                bNeedCheckNullGroup = true;
                oEleItor.remove();
                continue;
            }
            if (oExistGroupIDLst.contains(iGroupID)) continue;
            oExistGroupIDLst.add(iGroupID);
        }
        if (!bNeedCheckNullGroup) {
            return;
        }
        List<ActivationGroupInfo> oActGropuInfoLst = oActivationPara.getActivateGroupInfoLst();
        if (null == oActGropuInfoLst) {
            return;
        }
        Iterator<ActivationGroupInfo> oActGroupItor = oActGropuInfoLst.iterator();
        ActivationGroupInfo oActGroupInfo = null;
        boolean bNextModify = false;
        int iChangeValue = 0;
        ResourceManager oResMgr = ResourceManager.getInstance();
        while (oActGroupItor.hasNext()) {
            oActGroupInfo = oActGroupItor.next();
            iGroupID = oActGroupInfo.getGroupId();
            if (!oExistGroupIDLst.contains(iGroupID)) {
                oActGroupItor.remove();
                bNextModify = true;
                ++iChangeValue;
                continue;
            }
            if (!bNextModify || iChangeValue <= 0) continue;
            int iNewID = iGroupID - iChangeValue;
            oActGroupInfo.setGroupId(iNewID);
            oActGroupInfo.setGroupName(oResMgr.getResString("ACTIVATION_GROUP_NAME_KEY") + "_" + iNewID);
            this.modifyGroupInElement(oElementInfoLst, iGroupID, iNewID);
        }
    }

    private void modifyGroupInElement(List oElementInfoLst, int iOldGroupID, int iNewGroupID) {
        if (null == oElementInfoLst || oElementInfoLst.isEmpty()) {
            return;
        }
        ActivationElementInfo oActiationElement2 = null;
        int iGroupID = -1;
        for (ActivationElementInfo oActiationElement2 : oElementInfoLst) {
            if (null == oActiationElement2 || (iGroupID = oActiationElement2.getGroupId()) != iOldGroupID) continue;
            oActiationElement2.setGroupId(iNewGroupID);
            break;
        }
    }

    private boolean isNotFailled(Resource oRes) {
        boolean bNotFailed = false;
        if (null == oRes) {
            return bNotFailed;
        }
        ResourceProgressInfo oResourceProgressInfo = oRes.getProgressInfo();
        if (oResourceProgressInfo.getErrorNo() == this.DEVICE_PROGRESS_NO_RUN || oResourceProgressInfo.getErrorNo() == this.DEVICE_PROGRESS_SUCCESS || oResourceProgressInfo.getErrorNo() == this.DEVICE_PROGRESS_PAUSE) {
            return true;
        }
        return bNotFailed;
    }

    public void showErrorMessage(String strMessage) {
        DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), strMessage);
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_COPY_TASK";
    }
}

