/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.components.treetable.model.TreeTableCellData;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.components.treetable.view.DCTreeTableCellRenderer;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ErrorInfo;
import com.huawei.dc.framework.ErrorCodeReader;
import java.awt.Color;
import java.awt.Component;
import java.math.BigInteger;
import javax.swing.JLabel;
import javax.swing.JTable;

public class TreeTableLinkRenderer
extends DCTreeTableCellRenderer {
    private DCSortableTreeTable m_oOpResultTreeTable;
    private int iTableLinkRenderRow = -1;

    public TreeTableLinkRenderer(DCSortableTreeTable oSortTableTree, int iAlignment) {
        super(oSortTableTree, iAlignment);
        this.m_oOpResultTreeTable = oSortTableTree;
    }

    @Override
    public Component getTableCellRendererComponent(JTable oTable, Object oValue, boolean bIsSelected, boolean bHasFocus, int iRow, int iCol) {
        this.m_oTable = oTable;
        this.iTableLinkRenderRow = iRow;
        if (oValue instanceof TreeTableCellData) {
            if (0 == this.iTableLinkRenderRow) {
                String strPreChkSubHeader = ResourceManager.getInstance().getResString("CHECk_REPORT_PRECHECK_SUBHEADER");
                String strPostChkSubHeader = ResourceManager.getInstance().getResString("CHECk_REPORT_POSTCHECK_SUBHEADER");
                String strPreChkInTable = oTable.getValueAt(0, 0).toString();
                if (null != strPreChkInTable && (strPreChkInTable.contains(strPreChkSubHeader) || strPreChkInTable.contains(strPostChkSubHeader))) {
                    oValue = new TreeTableCellData();
                }
            }
            return this.getRendererComponentForSelectableNode((TreeTableCellData)oValue, bIsSelected);
        }
        return super.getTableCellRendererComponent(oTable, oValue, bIsSelected, bHasFocus, iRow, iCol);
    }

    private Component getRendererComponentForSelectableNode(TreeTableCellData oTreeTableCellData, boolean bIsSelected) {
        String strOplink = "";
        String strCmdResult = "";
        boolean bLink = false;
        if (null != oTreeTableCellData) {
            if (oTreeTableCellData.getCellDataValue() instanceof ErrorInfo) {
                ErrorInfo oErrorInfo = (ErrorInfo)oTreeTableCellData.getCellDataValue();
                strCmdResult = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(oErrorInfo.getErrorCode()));
                bLink = true;
            } else {
                strCmdResult = oTreeTableCellData.toString();
            }
        }
        strOplink = null != strCmdResult && 0 != strCmdResult.length() ? (bLink || strCmdResult.equals(DCFrameWorkUtil.getLocalizedString("CHECK_REPORT_VIEW_DETAIL")) ? (bIsSelected ? "<html><a href=\"x\" color=\"FFFFFF\">" + strCmdResult + "</a>" + "</html>" : "<html><a href=\"x\">" + strCmdResult + "</a>" + "</html>") : (ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(995098639L)).equals(strCmdResult) ? (this.iTableLinkRenderRow > 0 ? (bIsSelected ? "<html><a href=\"x\" color=\"FFFFFF\">" + strCmdResult + "</a>" + "</html>" : "<html><a href=\"x\" color=\"C4302D\">" + strCmdResult + "</a>" + "</html>") : "<html><a color=\"C4302D\">" + strCmdResult + "</a></html>") : strCmdResult)) : strCmdResult;
        JLabel oLinkLabel = new JLabel();
        if (!bLink) {
            if (bIsSelected) {
                oLinkLabel.setForeground(Color.WHITE);
                oLinkLabel.setBackground(this.m_oOpResultTreeTable.getSelectionBackground());
            } else {
                oLinkLabel.setBackground(this.m_oOpResultTreeTable.getBackground());
            }
        } else {
            oLinkLabel.setBackground(this.m_oOpResultTreeTable.getBackground());
        }
        oLinkLabel.setOpaque(true);
        oLinkLabel.setText(strOplink);
        oLinkLabel.setBorder(this.m_oBorder);
        oLinkLabel.setToolTipText(strCmdResult);
        return oLinkLabel;
    }

    @Override
    public void removeAll() {
        if (null != this.m_oOpResultTreeTable) {
            this.m_oOpResultTreeTable.removeAll();
            this.m_oOpResultTreeTable = null;
        }
    }
}

