/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.TaskInfoUtil2;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.model.ITask;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TransferProtocolSelectPanel
extends JPanel {
    private static final long serialVersionUID = -6057702890211608627L;
    private ITask m_oTask;
    private JCheckBox m_oISFTPLoadCheckBox;
    private JComboBox m_oTransferProtocolComboBox;
    private JLabel m_oPostfixLabel;
    private JLabel m_oFrontfixLabel;
    private static final String FTP_PROTOCOL = ResourceManager.getInstance().getResString("TYPE_FTP");
    private static final String SFTP_PROTOCOL = ResourceManager.getInstance().getResString("TYPE_SFTP");
    private boolean bCreatingTask = false;

    public JComboBox getTransferProtocolComboBox() {
        return this.m_oTransferProtocolComboBox;
    }

    public TransferProtocolSelectPanel(ITask oTask, boolean bCreateTask) {
        this.m_oTask = oTask;
        this.bCreatingTask = bCreateTask;
        this.jInit();
    }

    private void jInit() {
        int iLoadSWType;
        FlowLayout layOut = new FlowLayout(0, 0, 0);
        this.setLayout(layOut);
        this.m_oISFTPLoadCheckBox = new JCheckBox();
        this.m_oISFTPLoadCheckBox.setText(ResourceManager.getInstance().getResString("IS_FTP_LOAD_SOFTWARE"));
        this.m_oISFTPLoadCheckBox.setFocusable(false);
        this.m_oISFTPLoadCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TransferProtocolSelectPanel.this.m_oISFTPLoadCheckBox.isSelected()) {
                    TransferProtocolSelectPanel.this.m_oTransferProtocolComboBox.setEnabled(true);
                    Object oSelectedProtocol = TransferProtocolSelectPanel.this.m_oTransferProtocolComboBox.getSelectedItem();
                    if (FTP_PROTOCOL.equals(oSelectedProtocol)) {
                        TransferProtocolSelectPanel.this.m_oTask.setLoadSoftwareType(1);
                    } else {
                        TransferProtocolSelectPanel.this.m_oTask.setLoadSoftwareType(2);
                    }
                } else {
                    TransferProtocolSelectPanel.this.m_oTransferProtocolComboBox.setEnabled(false);
                    TransferProtocolSelectPanel.this.m_oTask.setLoadSoftwareType(0);
                }
            }
        });
        this.add(this.m_oISFTPLoadCheckBox);
        this.m_oFrontfixLabel = new JLabel();
        this.m_oFrontfixLabel.setText(ResourceManager.getInstance().getResString("TL1_IS_FTP_LOAD_SOFTWARE"));
        if (DCCommonUtil.isIncludeTL1Device(this.m_oTask)) {
            this.m_oISFTPLoadCheckBox.setVisible(false);
            this.add(this.m_oFrontfixLabel);
        }
        this.m_oTransferProtocolComboBox = new JComboBox();
        this.m_oTransferProtocolComboBox.setPreferredSize(new Dimension(60, 18));
        this.m_oTransferProtocolComboBox.addItem(FTP_PROTOCOL);
        this.m_oTransferProtocolComboBox.addItem(SFTP_PROTOCOL);
        this.m_oTransferProtocolComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    Object oSelectedProtocol = e.getItem();
                    if (FTP_PROTOCOL.equals(oSelectedProtocol)) {
                        TransferProtocolSelectPanel.this.m_oTask.setLoadSoftwareType(1);
                    } else {
                        TransferProtocolSelectPanel.this.m_oTask.setLoadSoftwareType(2);
                    }
                }
            }
        });
        this.add(this.m_oTransferProtocolComboBox);
        this.m_oPostfixLabel = new JLabel(ResourceManager.getInstance().getResString("IS_FTP_LOAD_SOFTWARE_POSTFIX"));
        this.add(this.m_oPostfixLabel);
        if (TaskCommUtil.getTaskOperation(this.m_oTask.getSupportedOperation(), "LoadSoftware") != null && this.m_oTask.isT2000Domain()) {
            this.m_oISFTPLoadCheckBox.setEnabled(TaskCommUtil.getTaskOperation(this.m_oTask.getSupportedOperation(), "LoadSoftware").isSelected());
        }
        if (0 == (iLoadSWType = this.m_oTask.getLoadSoftwareType()) && (this.m_oTask.isContainTL1Device() || this.bCreatingTask && this.m_oTask.isT2000Domain())) {
            this.m_oTask.setLoadSoftwareType(1);
            iLoadSWType = 1;
        }
        if (0 == iLoadSWType && this.m_oISFTPLoadCheckBox.isVisible() || TaskInfoUtil2.isSelectThirdServer(this.m_oTask)) {
            this.m_oISFTPLoadCheckBox.setSelected(false);
            this.m_oTransferProtocolComboBox.setEnabled(false);
        } else {
            this.m_oISFTPLoadCheckBox.setSelected(true);
            this.m_oTransferProtocolComboBox.setEnabled(true);
            if (iLoadSWType <= this.m_oTransferProtocolComboBox.getItemCount()) {
                this.m_oTransferProtocolComboBox.setSelectedIndex(iLoadSWType - 1);
            }
        }
    }

    public void setSelected(boolean isSelected) {
        this.m_oISFTPLoadCheckBox.setSelected(isSelected);
    }

    public boolean isSelected() {
        return this.m_oISFTPLoadCheckBox.isSelected();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.m_oISFTPLoadCheckBox.setEnabled(isEnabled);
        this.m_oTransferProtocolComboBox.setEnabled(isEnabled);
        this.m_oPostfixLabel.setEnabled(isEnabled);
        this.m_oFrontfixLabel.setEnabled(isEnabled);
    }

    public JCheckBox getFTPLoadCheckBox() {
        return this.m_oISFTPLoadCheckBox;
    }

    public void setFtpLoadCombox(boolean isEnabled) {
        this.m_oTransferProtocolComboBox.setEnabled(isEnabled);
    }
}

