/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.deviceselection.table.DeviceTableActionEvent;
import com.huawei.dc.common.components.deviceselection.table.DeviceTableActionListener;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.system.ISystemManager;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCCleanupUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.configuration.system.SystemSettingDlg;
import com.huawei.dc.configuration.system.externalftp.ExternalFTPInfo;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.backup.TaskBackupOperation;
import com.huawei.dc.devicemanagement.deviceoperation.loadpatch.LoadPatchOperation;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.LoadSoftwareOperation;
import com.huawei.dc.taskmgmt.controller.TaskSrcDstVersionCheck;
import com.huawei.dc.taskmgmt.controller.ThirdPartyFTPNotifier;
import com.huawei.dc.taskmgmt.controller.UpModeCheckController;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.common.CreateTaskDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ThirdPartyFTPPanel
extends JPanel
implements DeviceTableActionListener {
    private static final long serialVersionUID = 3818762691060020468L;
    private transient JCheckBox m_oThirdPartyFTPCheckbox = null;
    private transient ItemListener oComboxItemListener = null;
    private int lastSelectIndex = -1;
    private transient ComboBoxWithToolTip m_oFTPServerComBox = null;
    private ITask m_oTaskDataObj = null;
    private ISystemManager m_oSysManager = new SystemManager();

    public void setEnabledThirdPartyFTPChkbox(boolean isEnable) {
        if (null != this.m_oThirdPartyFTPCheckbox) {
            this.m_oThirdPartyFTPCheckbox.setEnabled(isEnable);
        }
    }

    public boolean isSelectThirdPartyFTP() {
        return null == this.m_oThirdPartyFTPCheckbox ? false : this.m_oThirdPartyFTPCheckbox.isSelected();
    }

    public ThirdPartyFTPPanel(ITask oTaskDataObj) {
        this.m_oTaskDataObj = oTaskDataObj;
        this.jbinit();
    }

    private void jbinit() {
        this.setLayout(new GridBagLayout());
        this.setName("taskmgmt_TaskMgmtOperationSelecPanel_modePanel");
        this.add((Component)this.getThirdPartyFTPCheckbox(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getThirdPartyServerComBox(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.initGUIData();
        this.checkIsHaveProxyDevice();
    }

    private void checkIsHaveProxyDevice() {
        boolean isProxied = CreateTaskDialog.isProxied();
        if (isProxied) {
            boolean isSelected = this.m_oThirdPartyFTPCheckbox.isSelected();
            if (!isSelected) {
                this.m_oTaskDataObj.setThirdPartySupported(true);
                this.m_oTaskDataObj.setThirdPartyServerName(this.getSelectThirdPartyServerName());
                ThirdPartyFTPNotifier.getInstance().notifyEvent(this.m_oThirdPartyFTPCheckbox.isSelected());
                this.m_oThirdPartyFTPCheckbox.setSelected(true);
                this.m_oFTPServerComBox.setEnabled(true);
            }
            this.m_oFTPServerComBox.setSelectedIndex(0);
            this.m_oThirdPartyFTPCheckbox.setEnabled(false);
        }
    }

    private ComboBoxWithToolTip getThirdPartyServerComBox() {
        this.m_oFTPServerComBox = new ComboBoxWithToolTip();
        this.m_oFTPServerComBox.setName("taskmgmt_ThirdPartyFTPPanel_m_oFTPServerComBox");
        this.m_oFTPServerComBox.setEnabled(false);
        this.m_oFTPServerComBox.setPreferredSize(new Dimension(210, 20));
        this.m_oFTPServerComBox.setMinimumSize(new Dimension(210, 20));
        if (!"".equals(this.m_oTaskDataObj.getThirdPartyServerName()) || DCFrameWorkUtil.getIsSingleClient()) {
            this.initFTPServerComBox();
        }
        this.lastSelectIndex = this.m_oFTPServerComBox != null ? this.m_oFTPServerComBox.getSelectedIndex() : -1;
        this.oComboxItemListener = new ItemListener(){
            boolean isShowMessage = false;

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ThirdPartyFTPPanel.this.m_oFTPServerComBox.getItemCount() == 0) {
                    return;
                }
                if (this.isShowMessage) {
                    return;
                }
                if (ThirdPartyFTPPanel.this.lastSelectIndex != ThirdPartyFTPPanel.this.m_oFTPServerComBox.getSelectedIndex()) {
                    int iConfirm = 2;
                    if (ThirdPartyFTPPanel.this.checkIfLoadSelected() && ThirdPartyFTPPanel.this.checkIfBackupSelected()) {
                        this.isShowMessage = true;
                        iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("THIRD_PARTY_FTP_FOR_BACKUP_AND_LOAD_CONFIRM_MSG"), DCFrameWorkUtil.getLocalizedString("CONFIRM"), 0);
                        if (0 != iConfirm) {
                            ThirdPartyFTPPanel.this.m_oFTPServerComBox.setSelectedIndex(ThirdPartyFTPPanel.this.lastSelectIndex);
                            this.isShowMessage = false;
                            return;
                        }
                    } else if (ThirdPartyFTPPanel.this.checkIfLoadSelected()) {
                        this.isShowMessage = true;
                        iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("THIRD_PARTY_FTP_FOR_LOAD_CONFIRM_MSG"), DCFrameWorkUtil.getLocalizedString("CONFIRM"), 0);
                        if (0 != iConfirm) {
                            ThirdPartyFTPPanel.this.m_oFTPServerComBox.setSelectedIndex(ThirdPartyFTPPanel.this.lastSelectIndex);
                            this.isShowMessage = false;
                            return;
                        }
                    } else if (ThirdPartyFTPPanel.this.checkIfBackupSelected()) {
                        this.isShowMessage = true;
                        iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("THIRD_PARTY_FTP_FOR_BACKUP_CONFIRM_MSG"), DCFrameWorkUtil.getLocalizedString("CONFIRM"), 0);
                        if (0 != iConfirm) {
                            ThirdPartyFTPPanel.this.m_oFTPServerComBox.setSelectedIndex(ThirdPartyFTPPanel.this.lastSelectIndex);
                            this.isShowMessage = false;
                            return;
                        }
                    }
                    ThirdPartyFTPPanel.this.clearLoadfile(iConfirm);
                    ExternalFTPInfo oExternalFTPInfo = (ExternalFTPInfo)ThirdPartyFTPPanel.this.m_oFTPServerComBox.getSelectedItem();
                    TaskSrcDstVersionCheck.getInstance().setThirdFTPServerName(oExternalFTPInfo.getServerName());
                    ThirdPartyFTPPanel.this.m_oTaskDataObj.setThirdPartyServerName(oExternalFTPInfo.getServerName());
                    ThirdPartyFTPPanel.this.m_oTaskDataObj.setThirdPartyFTPInfo(oExternalFTPInfo);
                    ThirdPartyFTPNotifier.getInstance().notifyEvent(ThirdPartyFTPPanel.this.m_oThirdPartyFTPCheckbox.isSelected());
                    ThirdPartyFTPPanel.this.lastSelectIndex = ThirdPartyFTPPanel.this.m_oFTPServerComBox.getSelectedIndex();
                    this.isShowMessage = false;
                }
            }
        };
        this.m_oFTPServerComBox.addItemListener(this.oComboxItemListener);
        return this.m_oFTPServerComBox;
    }

    private void clearLoadfile(int iConfirm) {
        if (0 == iConfirm) {
            LoadPatchOperation oLoadPatchOperation;
            ITaskDeviceOperation oPatchOpr;
            LoadFileInfoListParam oLoadFileInfoListParam = this.m_oTaskDataObj.getLoadFileInfoListParam();
            if (oLoadFileInfoListParam != null) {
                oLoadFileInfoListParam.clearAllFilesFromList();
            }
            if ((oPatchOpr = this.m_oTaskDataObj.getTaskDeviceOperation(9)) instanceof LoadPatchOperation && (oLoadPatchOperation = (LoadPatchOperation)oPatchOpr).getConfiguredPara() instanceof LoadFileInfoListParam) {
                LoadFileInfoListParam oLoadPatchFileLst = (LoadFileInfoListParam)oLoadPatchOperation.getConfiguredPara();
                oLoadPatchFileLst.clearAllFilesFromList();
            }
        }
    }

    private JCheckBox getThirdPartyFTPCheckbox() {
        this.m_oThirdPartyFTPCheckbox = new JCheckBox(DCFrameWorkUtil.getLocalizedString("LBL_THIRD_PARTY_FTP"));
        this.m_oThirdPartyFTPCheckbox.setName("taskmgmt_HighEfficiencyModePanel_m_oHighefficiencyModeCheckbox");
        this.m_oThirdPartyFTPCheckbox.setFocusable(false);
        this.m_oThirdPartyFTPCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bThirdPartyConfigured;
                if (ThirdPartyFTPPanel.this.m_oThirdPartyFTPCheckbox.isSelected() && !(bThirdPartyConfigured = ThirdPartyFTPPanel.this.checkThirdPartyFTPConfigured())) {
                    ThirdPartyFTPPanel.this.m_oThirdPartyFTPCheckbox.setSelected(!ThirdPartyFTPPanel.this.m_oThirdPartyFTPCheckbox.isSelected());
                    return;
                }
                int iConfirm = 2;
                if (ThirdPartyFTPPanel.this.checkIfLoadSelected() && ThirdPartyFTPPanel.this.checkIfBackupSelected()) {
                    iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("THIRD_PARTY_FTP_FOR_BACKUP_AND_LOAD_CONFIRM_MSG"), DCFrameWorkUtil.getLocalizedString("CONFIRM"), 0);
                    if (0 != iConfirm) {
                        this.setThirdFTPCheckBoxAndComBoxStatus();
                        return;
                    }
                } else if (ThirdPartyFTPPanel.this.checkIfLoadSelected()) {
                    iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("THIRD_PARTY_FTP_FOR_LOAD_CONFIRM_MSG"), DCFrameWorkUtil.getLocalizedString("CONFIRM"), 0);
                    if (0 != iConfirm) {
                        this.setThirdFTPCheckBoxAndComBoxStatus();
                        return;
                    }
                } else if (ThirdPartyFTPPanel.this.checkIfBackupSelected() && 0 != (iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("THIRD_PARTY_FTP_FOR_BACKUP_CONFIRM_MSG"), DCFrameWorkUtil.getLocalizedString("CONFIRM"), 0))) {
                    this.setThirdFTPCheckBoxAndComBoxStatus();
                    return;
                }
                ThirdPartyFTPPanel.this.clearLoadfile(iConfirm);
                if (ThirdPartyFTPPanel.this.m_oThirdPartyFTPCheckbox.isSelected()) {
                    ThirdPartyFTPPanel.this.m_oFTPServerComBox.setEnabled(true);
                    ThirdPartyFTPPanel.this.m_oTaskDataObj.setThirdPartySupported(true);
                    ThirdPartyFTPPanel.this.m_oTaskDataObj.setThirdPartyServerName(ThirdPartyFTPPanel.this.getSelectThirdPartyServerName());
                    ThirdPartyFTPPanel.this.m_oTaskDataObj.setThirdPartyFTPInfo((ExternalFTPInfo)ThirdPartyFTPPanel.this.m_oFTPServerComBox.getSelectedItem());
                } else {
                    ThirdPartyFTPPanel.this.m_oFTPServerComBox.setEnabled(false);
                    this.setFTPServerComboxEmpty();
                    ThirdPartyFTPPanel.this.m_oTaskDataObj.setThirdPartySupported(false);
                    ThirdPartyFTPPanel.this.m_oTaskDataObj.setThirdPartyServerName("");
                    ThirdPartyFTPPanel.this.m_oTaskDataObj.setThirdPartyFTPInfo(null);
                }
                ThirdPartyFTPPanel.this.lastSelectIndex = ThirdPartyFTPPanel.this.m_oFTPServerComBox.getSelectedIndex();
                ThirdPartyFTPNotifier.getInstance().notifyEvent(ThirdPartyFTPPanel.this.m_oThirdPartyFTPCheckbox.isSelected());
            }

            private void setThirdFTPCheckBoxAndComBoxStatus() {
                ThirdPartyFTPPanel.this.m_oThirdPartyFTPCheckbox.setSelected(!ThirdPartyFTPPanel.this.m_oThirdPartyFTPCheckbox.isSelected());
                if (!ThirdPartyFTPPanel.this.m_oThirdPartyFTPCheckbox.isSelected()) {
                    this.setFTPServerComboxEmpty();
                }
            }

            private void setFTPServerComboxEmpty() {
                ThirdPartyFTPPanel.this.m_oFTPServerComBox.removeItemListener(ThirdPartyFTPPanel.this.oComboxItemListener);
                ThirdPartyFTPPanel.this.m_oFTPServerComBox.setSelectedIndex(-1);
                ThirdPartyFTPPanel.this.m_oFTPServerComBox.setSelectedItem("");
                ThirdPartyFTPPanel.this.m_oFTPServerComBox.addItemListener(ThirdPartyFTPPanel.this.oComboxItemListener);
            }
        });
        return this.m_oThirdPartyFTPCheckbox;
    }

    protected boolean checkThirdPartyFTPConfigured() {
        boolean bConfigured = this.isConfigExternalFTP();
        if (!bConfigured) {
            if (!DCFrameWorkUtil.getIsSingleClient()) {
                DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("NOT_CONFIG_EXTERNAL_FTP"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
            } else {
                int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("THIRD_PARTY_FTP_NOT_CONFIGURED_CONFIRM_MSG"), DCFrameWorkUtil.getLocalizedString("CONFIRM"), 0);
                if (0 != iConfirm) {
                    bConfigured = false;
                } else {
                    bConfigured = true;
                    boolean isSetThirdFtp = true;
                    SystemSettingDlg oSystemSettingDlg = new SystemSettingDlg(isSetThirdFtp);
                    oSystemSettingDlg.setTabSelectedIndex(oSystemSettingDlg.getBoardTabIndex());
                    oSystemSettingDlg.setVisible(true);
                    bConfigured = this.isConfigExternalFTP();
                }
            }
        }
        return bConfigured;
    }

    protected boolean checkIfLoadSelected() {
        List<ITaskDeviceOperation> oTaskOpLst = this.m_oTaskDataObj.getSupportedOperation();
        int iSizeOfLst = oTaskOpLst.size();
        if (0 >= iSizeOfLst) {
            return false;
        }
        boolean bLoadSelected = false;
        for (int i = 0; i < iSizeOfLst; ++i) {
            ITaskDeviceOperation oTaskDeviceOp = oTaskOpLst.get(i);
            if (!(oTaskDeviceOp instanceof LoadSoftwareOperation) && !(oTaskDeviceOp instanceof LoadPatchOperation) || !oTaskDeviceOp.isSelected()) continue;
            bLoadSelected = true;
            break;
        }
        return bLoadSelected;
    }

    protected boolean checkIfBackupSelected() {
        List<ITaskDeviceOperation> oTaskOpLst = this.m_oTaskDataObj.getSupportedOperation();
        int iSizeOfLst = oTaskOpLst.size();
        if (0 >= iSizeOfLst) {
            return false;
        }
        boolean bBackupSelected = false;
        for (int i = 0; i < iSizeOfLst; ++i) {
            ITaskDeviceOperation oTaskDeviceOp = oTaskOpLst.get(i);
            if (!(oTaskDeviceOp instanceof TaskBackupOperation) || !oTaskDeviceOp.isSelected()) continue;
            bBackupSelected = true;
            break;
        }
        return bBackupSelected;
    }

    private void initGUIData() {
        if (null == this.m_oTaskDataObj) {
            return;
        }
        this.m_oThirdPartyFTPCheckbox.setSelected(this.m_oTaskDataObj.isThirdPartySupported());
        if (this.m_oThirdPartyFTPCheckbox.isSelected()) {
            this.m_oFTPServerComBox.setEnabled(true);
        } else {
            this.m_oFTPServerComBox.setEnabled(false);
        }
    }

    @Override
    public void onTableActionPerformed(DeviceTableActionEvent event) {
        if (null == event) {
            return;
        }
        int iEventType = event.getEventType();
        switch (iEventType) {
            case 1: {
                List resourceLst = (List)event.getSource();
                this.handleDevDelete(resourceLst);
                break;
            }
            case 4: {
                DeviceInfo[] devInfos;
                for (DeviceInfo devInfo : devInfos = (DeviceInfo[])event.getSource()) {
                    this.handleDevAdd(devInfo);
                }
                break;
            }
            case 3: {
                DeviceInfo[] devInfos = (DeviceInfo[])event.getSource();
                if (null == devInfos) break;
                for (DeviceInfo devInfo : devInfos) {
                    int iDevID = devInfo.getDevId();
                    Resource resource = DeviceInfoManagerImpl.getInstance().getResourceForID(iDevID);
                    if (null == resource) continue;
                    ArrayList<Resource> resourceLst = new ArrayList<Resource>();
                    resourceLst.add(resource);
                    this.handleDevDelete(resourceLst);
                }
                break;
            }
        }
    }

    private void handleDevDelete(List<Resource> resourceLst) {
    }

    private void handleDevAdd(DeviceInfo oDeviceInfo) {
    }

    public boolean updateThirdFtpSetting() {
        boolean isSupportThirdPartyFTP = UpModeCheckController.getInstance().isShowThirdPartyFTP(this.m_oTaskDataObj);
        if (isSupportThirdPartyFTP) {
            this.m_oFTPServerComBox.setVisible(true);
            this.m_oThirdPartyFTPCheckbox.setVisible(true);
        } else {
            this.m_oFTPServerComBox.setVisible(false);
            this.m_oThirdPartyFTPCheckbox.setVisible(false);
            this.m_oThirdPartyFTPCheckbox.setSelected(false);
        }
        if (this.m_oThirdPartyFTPCheckbox.isSelected()) {
            this.m_oFTPServerComBox.setEnabled(true);
            this.m_oTaskDataObj.setThirdPartySupported(true);
            this.m_oTaskDataObj.setThirdPartyServerName(this.getSelectThirdPartyServerName());
            this.m_oTaskDataObj.setThirdPartyFTPInfo((ExternalFTPInfo)this.m_oFTPServerComBox.getSelectedItem());
        } else {
            this.m_oFTPServerComBox.setEnabled(false);
            this.m_oTaskDataObj.setThirdPartySupported(false);
            this.m_oTaskDataObj.setThirdPartyServerName("");
            this.m_oTaskDataObj.setThirdPartyFTPInfo(null);
        }
        return isSupportThirdPartyFTP;
    }

    public void dispose() {
        if (null != this.m_oTaskDataObj) {
            this.m_oTaskDataObj = null;
        }
        DCCleanupUtil.cleanUpPanel(this);
    }

    public void setViewComponents(boolean bValue) {
        this.m_oThirdPartyFTPCheckbox.setEnabled(bValue);
        this.m_oFTPServerComBox.setEnabled(this.m_oThirdPartyFTPCheckbox.isSelected() && this.m_oThirdPartyFTPCheckbox.isEnabled());
    }

    private boolean isConfigExternalFTP() {
        if (this.m_oFTPServerComBox.getItemCount() > 0) {
            this.m_oFTPServerComBox.removeAllItems();
        }
        this.initFTPServerComBox();
        return this.m_oFTPServerComBox.getItemCount() != 0;
    }

    private void initFTPServerComBox() {
        try {
            int iSelectItemIndex = -1;
            ExternalFTPInfo[] oExternalFTPInfos = this.m_oSysManager.getExternalFTPInfos();
            if (null == oExternalFTPInfos) {
                return;
            }
            this.m_oFTPServerComBox.removeItemListener(this.oComboxItemListener);
            for (int i = 0; i < oExternalFTPInfos.length; ++i) {
                this.m_oFTPServerComBox.addItem(oExternalFTPInfos[i]);
                if (!this.m_oTaskDataObj.getThirdPartyServerName().equals(oExternalFTPInfos[i].getServerName())) continue;
                iSelectItemIndex = i;
            }
            this.m_oFTPServerComBox.addItemListener(this.oComboxItemListener);
            if ("".equals(this.m_oTaskDataObj.getThirdPartyServerName())) {
                if (this.m_oFTPServerComBox.getItemCount() != 0 && (this.m_oTaskDataObj.isThirdPartySupported() || this.m_oThirdPartyFTPCheckbox.isSelected()) && null != oExternalFTPInfos && oExternalFTPInfos.length != 0) {
                    TaskSrcDstVersionCheck.getInstance().setThirdFTPServerName(oExternalFTPInfos[0].getServerName());
                    iSelectItemIndex = 0;
                }
                this.m_oFTPServerComBox.setSelectedIndex(iSelectItemIndex);
            } else {
                if (-1 == iSelectItemIndex) {
                    this.m_oFTPServerComBox.addItem(this.m_oTaskDataObj.getThirdPartyFTPInfo());
                    this.m_oFTPServerComBox.setSelectedItem(this.m_oTaskDataObj.getThirdPartyServerName());
                } else {
                    this.m_oFTPServerComBox.setSelectedIndex(iSelectItemIndex);
                }
                TaskSrcDstVersionCheck.getInstance().setThirdFTPServerName(this.m_oTaskDataObj.getThirdPartyServerName());
            }
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
    }

    public JCheckBox getThirdPartyFTPCheckBox() {
        return this.m_oThirdPartyFTPCheckbox;
    }

    private String getSelectThirdPartyServerName() {
        ExternalFTPInfo oExternalFTPInfo = (ExternalFTPInfo)this.m_oFTPServerComBox.getSelectedItem();
        if (oExternalFTPInfo != null) {
            return oExternalFTPInfo.getServerName();
        }
        return "";
    }
}

