/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.PopupMenuManager;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.configuration.licence.LicenseMonitor;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTableUtil;
import com.huawei.dc.taskmgmt.model.TaskModelUtil;
import com.huawei.dc.taskmgmt.view.common.TaskManagementPopupMenuManager;
import com.huawei.dc.taskmgmt.view.common.TaskMenuItemHandler;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTablePanel;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTableUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class TaskTableButtonPanel
extends JPanel
implements DCTreeEventListener {
    private static final long serialVersionUID = 1L;
    private TaskTablePanel m_oTaskTablePanel;
    private JLabel m_oTaskCountLabel;
    private String m_strTaskCountText;
    private JButton m_oNewTaskButton;
    private JButton m_oStartTaskButton;
    private JButton m_oPauseTaskButton;
    private JButton m_oContinueTaskButton;
    private JButton m_oCopyTaskButton;
    private JButton m_oGenerateReportButton;
    private TaskMenuItemHandler m_oTaskMenuItemHandler;
    private TaskManagementPopupMenuManager m_oPopupMenuManager;
    private JPopupMenu m_oNewTaskPopupMenu;
    private HashMap m_oTaskMenuItemMap;
    boolean m_hasTaskMgrPrivilege = true;
    private String strdate = "";

    public TaskTableButtonPanel(TaskTablePanel oTaskTablePanel) {
        this.m_oTaskTablePanel = oTaskTablePanel;
        this.m_oTaskMenuItemHandler = new TaskMenuItemHandler(this.m_oTaskTablePanel);
        this.m_oPopupMenuManager = new TaskManagementPopupMenuManager(this.m_oTaskTablePanel.getTaskTreeTable(), this.m_oTaskMenuItemHandler);
        this.jbinit();
        this.createTaskCountLabel();
        this.createNewTaskButton();
        this.createStartTaskButton();
        this.createPauseTaskButton();
        this.createContinueTaskButton();
        this.createCopyTaskButton();
        this.createGenerateReportButton();
        this.addComponentsToPanel();
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            this.m_hasTaskMgrPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43871);
        }
    }

    private void createNewTaskButton() {
        ImageIcon oIcon = ResourceManager.getInstance().getImage("Down.gif");
        this.m_oNewTaskButton = new JButton(ResourceManager.getInstance().getResString("TASK_NEW_TASK"), oIcon);
        this.m_oNewTaskButton.setToolTipText(ResourceManager.getInstance().getResString("TASK_NEW_TASK"));
        this.m_oNewTaskButton.setMnemonic('N');
        this.m_oNewTaskButton.setMinimumSize(new Dimension(120, 23));
        this.m_oNewTaskButton.setPreferredSize(new Dimension(120, 23));
        this.m_oNewTaskButton.setEnabled(false);
        this.m_oNewTaskButton.setHorizontalTextPosition(2);
        this.m_oNewTaskButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TaskTableButtonPanel.this.showPopupMenuForNewTask();
            }
        });
    }

    protected void showPopupMenuForNewTask() {
        PopupMenuManager oPopupMenuManager = PopupMenuManager.getInstance();
        this.m_oNewTaskPopupMenu = oPopupMenuManager.load(this.m_oTaskMenuItemHandler, "taskmgmtpopupmenufornewtaskbutton");
        this.m_oTaskMenuItemMap = oPopupMenuManager.getMenuItemMap();
        this.enableTaskMenuItems();
        this.m_oNewTaskPopupMenu.show(this.m_oNewTaskButton, 0, this.m_oNewTaskButton.getHeight());
    }

    private void enableTaskMenuItems() {
        DeviceTypeInfo[] arrDeviceTypes = DCFrameWorkUtil.getDeviceInfoManager().getAddedDeviceTypes();
        int[] iDeviceIdLst = DCFrameWorkUtil.getDeviceInfoManager().getAddedDeviceIdLst();
        if (null == arrDeviceTypes || 0 == arrDeviceTypes.length) {
            this.changeNewTaskButtonStatus(false);
        } else {
            this.changeNewTaskButtonStatus(true);
        }
        if (TaskModelUtil.isTaskTypeSupportedForDeviceTypes(10, arrDeviceTypes, iDeviceIdLst)) {
            this.getMenuItemForID("UpgradeDowngrade").setVisible(true);
            this.getMenuItemForID("UpgradeDowngrade").setEnabled(true);
        } else {
            this.getMenuItemForID("UpgradeDowngrade").setVisible(false);
        }
        if (TaskModelUtil.isTaskTypeSupportedForDeviceTypes(2, arrDeviceTypes, iDeviceIdLst)) {
            this.getMenuItemForID("PatchUpdate").setVisible(true);
            this.getMenuItemForID("PatchUpdate").setEnabled(true);
        } else {
            this.getMenuItemForID("PatchUpdate").setVisible(false);
        }
        if (TaskModelUtil.isTaskTypeSupportedForDeviceTypes(3, arrDeviceTypes, iDeviceIdLst)) {
            this.getMenuItemForID("MimcPackageUpgrade").setVisible(true);
            this.getMenuItemForID("MimcPackageUpgrade").setEnabled(true);
        } else {
            this.getMenuItemForID("MimcPackageUpgrade").setVisible(false);
        }
        if (TaskModelUtil.isTaskTypeSupportedForDeviceTypes(14, arrDeviceTypes, iDeviceIdLst)) {
            this.getMenuItemForID("packageUpgradedowngradetask").setVisible(true);
            this.getMenuItemForID("packageUpgradedowngradetask").setEnabled(true);
        } else {
            this.getMenuItemForID("packageUpgradedowngradetask").setVisible(false);
        }
        if (TaskModelUtil.isTaskTypeSupportedForDeviceTypes(11, arrDeviceTypes, iDeviceIdLst)) {
            if (LicenseMonitor.getInstance().isControlTran()) {
                if (LicenseMonitor.getInstance().isCurrStatusValid()) {
                    this.getMenuItemForID("packageDiffusionUpgradeDowngrade").setVisible(true);
                    this.getMenuItemForID("packageDiffusionUpgradeDowngrade").setEnabled(true);
                } else {
                    this.getMenuItemForID("packageDiffusionUpgradeDowngrade").setVisible(false);
                    this.getMenuItemForID("packageDiffusionUpgradeDowngrade").setEnabled(false);
                }
            } else {
                this.getMenuItemForID("packageDiffusionUpgradeDowngrade").setVisible(true);
                this.getMenuItemForID("packageDiffusionUpgradeDowngrade").setEnabled(true);
            }
        } else {
            this.getMenuItemForID("packageDiffusionUpgradeDowngrade").setVisible(false);
        }
        if (TaskModelUtil.isTaskTypeSupportedForDeviceTypes(7, arrDeviceTypes, iDeviceIdLst) && !DCFrameWorkUtil.getIsSingleClient() && LicenseMonitor.getInstance().isCurrStatusValid()) {
            this.getMenuItemForID("oltUpdate").setVisible(true);
            this.getMenuItemForID("oltUpdate").setEnabled(true);
        } else {
            this.getMenuItemForID("oltUpdate").setVisible(false);
        }
    }

    public JMenuItem getMenuItemForID(String strMenuItemID) {
        JMenuItem tempMenu = null;
        tempMenu = null != this.m_oTaskMenuItemMap.get(strMenuItemID) ? (JMenuItem)this.m_oTaskMenuItemMap.get(strMenuItemID) : new JMenuItem();
        return tempMenu;
    }

    private void createStartTaskButton() {
        this.m_oStartTaskButton = new JButton(ResourceManager.getInstance().getResString("START_TASK"));
        this.m_oStartTaskButton.setToolTipText(ResourceManager.getInstance().getResString("START_TASK"));
        this.m_oStartTaskButton.setMnemonic('r');
        this.m_oStartTaskButton.setMinimumSize(new Dimension(110, 23));
        this.m_oStartTaskButton.setPreferredSize(new Dimension(110, 23));
        this.m_oStartTaskButton.setEnabled(false);
        this.m_oStartTaskButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TaskTableButtonPanel.this.m_oTaskMenuItemHandler.startTask();
            }
        });
    }

    private void createPauseTaskButton() {
        this.m_oPauseTaskButton = new JButton(ResourceManager.getInstance().getResString("PAUSE_TASK"));
        this.m_oPauseTaskButton.setToolTipText(ResourceManager.getInstance().getResString("PAUSE_TASK"));
        this.m_oPauseTaskButton.setMnemonic('a');
        this.m_oPauseTaskButton.setMinimumSize(new Dimension(110, 23));
        this.m_oPauseTaskButton.setPreferredSize(new Dimension(110, 23));
        this.m_oPauseTaskButton.setEnabled(false);
        this.m_oPauseTaskButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TaskTableButtonPanel.this.m_oTaskMenuItemHandler.pauseTask();
            }
        });
    }

    private void createContinueTaskButton() {
        this.m_oContinueTaskButton = new JButton(ResourceManager.getInstance().getResString("CONTINUE_TASK"));
        this.m_oContinueTaskButton.setToolTipText(ResourceManager.getInstance().getResString("CONTINUE_TASK"));
        this.m_oContinueTaskButton.setMnemonic('i');
        this.m_oContinueTaskButton.setMinimumSize(new Dimension(120, 23));
        this.m_oContinueTaskButton.setPreferredSize(new Dimension(120, 23));
        this.m_oContinueTaskButton.setEnabled(false);
        this.m_oContinueTaskButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (null != DCFrameWorkUtil.getTaskTablePanel()) {
                    TaskTablePanel oTaskTablePanel = null;
                    TaskMenuItemHandler oMenuHandle = null;
                    oTaskTablePanel = DCFrameWorkUtil.getTaskTablePanel();
                    oMenuHandle = oTaskTablePanel.getTaskMenuItemHandler();
                    if (null != oMenuHandle) {
                        oMenuHandle.continueTask();
                    }
                }
            }
        });
    }

    private void createCopyTaskButton() {
        this.m_oCopyTaskButton = new JButton(ResourceManager.getInstance().getResString("COPY_TASK"));
        this.m_oCopyTaskButton.setToolTipText(ResourceManager.getInstance().getResString("COPY_TASK"));
        this.m_oCopyTaskButton.setMnemonic('p');
        this.m_oCopyTaskButton.setMinimumSize(new Dimension(120, 23));
        this.m_oCopyTaskButton.setPreferredSize(new Dimension(120, 23));
        this.m_oCopyTaskButton.setEnabled(false);
        this.m_oCopyTaskButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TaskTableButtonPanel.this.m_oTaskMenuItemHandler.copyTask();
            }
        });
    }

    private void createGenerateReportButton() {
        this.m_oGenerateReportButton = new JButton(ResourceManager.getInstance().getResString("GENERATE_TASK_REPORT_BTN"));
        this.m_oGenerateReportButton.setToolTipText(ResourceManager.getInstance().getResString("GENERATE_TASK_REPORT_BTN"));
        this.m_oGenerateReportButton.setMnemonic('G');
        this.m_oGenerateReportButton.setMinimumSize(new Dimension(170, 23));
        this.m_oGenerateReportButton.setPreferredSize(new Dimension(170, 23));
        this.m_oGenerateReportButton.setEnabled(false);
        this.m_oGenerateReportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TaskTableButtonPanel.this.m_oTaskMenuItemHandler.generateReport();
            }
        });
    }

    private void addComponentsToPanel() {
        this.add((Component)this.m_oTaskCountLabel, new GridBagConstraints(0, 0, 1, 7, 1.0, 0.0, 17, 1, new Insets(10, 12, 10, 0), 0, 0));
        this.add((Component)this.m_oNewTaskButton, new GridBagConstraints(1, 0, 1, 7, 0.0, 0.0, 17, 0, new Insets(10, 12, 10, 0), 0, 0));
        this.add((Component)this.m_oStartTaskButton, new GridBagConstraints(2, 0, 1, 7, 0.0, 0.0, 10, 0, new Insets(10, 12, 10, 0), 0, 0));
        this.add((Component)this.m_oPauseTaskButton, new GridBagConstraints(3, 0, 1, 7, 0.0, 0.0, 10, 0, new Insets(10, 12, 10, 0), 0, 0));
        this.add((Component)this.m_oContinueTaskButton, new GridBagConstraints(4, 0, 1, 7, 0.0, 0.0, 10, 0, new Insets(10, 12, 10, 0), 0, 0));
        this.add((Component)this.m_oCopyTaskButton, new GridBagConstraints(5, 0, 1, 7, 0.0, 0.0, 10, 0, new Insets(10, 12, 10, 0), 0, 0));
        this.add((Component)this.m_oGenerateReportButton, new GridBagConstraints(6, 0, 1, 7, 0.0, 0.0, 13, 0, new Insets(10, 12, 10, 12), 0, 0));
    }

    private void jbinit() {
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(1720, 45));
        this.setMinimumSize(new Dimension(1300, 45));
        this.setPreferredSize(new Dimension(1720, 45));
    }

    private void createTaskCountLabel() {
        this.m_oTaskCountLabel = new JLabel();
        this.m_oTaskCountLabel.setPreferredSize(new Dimension(580, 45));
        this.m_oTaskCountLabel.setMinimumSize(new Dimension(580, 45));
        this.m_strTaskCountText = ResourceManager.getInstance().getResString("LBL_SELECT_TASK_COUNT");
        this.setRefreshDateTime();
        this.refreshSelectedTaskCountLabel();
    }

    public void refreshSelectedTaskCountLabel() {
        if (null == this.m_oTaskCountLabel) {
            return;
        }
        int iSelectedTaskCount = 0;
        int[] arrSelectedRows = this.m_oTaskTablePanel.getTaskTreeTable().getSelectedRows();
        if (null != arrSelectedRows) {
            iSelectedTaskCount = TaskTableUtil.getSelectedTaskCount(this.m_oTaskTablePanel.getTaskTreeTable());
        }
        int iSelectedTaskIndex = 0;
        if (iSelectedTaskCount > 0) {
            iSelectedTaskIndex = TaskTableUtil.getIndexOfTask(this.m_oTaskTablePanel.getTaskTreeTable());
        }
        int iTaskCount = TaskTableUtil.getTotalTaskCount(this.m_oTaskTablePanel.getTaskTreeTable());
        String strDeviceCountMsg = MessageFormat.format(this.m_strTaskCountText, "" + iSelectedTaskIndex, "" + iTaskCount, "" + iSelectedTaskCount, "" + this.strdate);
        this.m_oTaskCountLabel.setText(StringUtils.getHtmlString(strDeviceCountMsg));
    }

    @Override
    public void onTreeInit(DCEventObject eventObject) {
    }

    @Override
    public void onTreeNodeSelection(DCEventObject eventObject) {
        this.refreshSelectedTaskCountLabel();
        this.checkButtonsStatus();
    }

    public void checkButtonsStatus() {
        if (null == this.m_oTaskTablePanel) {
            DCDebugTracer.trace("checkButtonsStatus#m_oTaskTablePanel is null");
            return;
        }
        if (null == this.m_oTaskTablePanel.getTaskTreeTable()) {
            return;
        }
        int[] arrSelectedRows = this.m_oTaskTablePanel.getTaskTreeTable().getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length || this.m_oTaskTablePanel.getTaskTreeTable().getRowCount() == 0) {
            this.changeNewTaskButtonStatus(true);
            this.changeButtonsStatus(false);
            return;
        }
        if (1 <= arrSelectedRows.length) {
            this.enableButtonForMultipleSelection();
            return;
        }
        this.changeNewTaskButtonStatus(true);
        this.changeButtonsStatus(false);
    }

    private void enableButtonForMultipleSelection() {
        if (!TaskTableUtil.isATaskOnlySelection(this.m_oTaskTablePanel.getTaskTreeTable())) {
            this.changeNewTaskButtonStatus(true);
            this.changeButtonsStatus(false);
            return;
        }
        try {
            this.m_oPopupMenuManager.load();
        }
        catch (Exception e) {
            this.changeNewTaskButtonStatus(true);
            this.changeButtonsStatus(false);
            return;
        }
        boolean isNewTaskEnabled = this.m_oPopupMenuManager.getMenuItemForID("NewTask").isEnabled();
        DCFrameWorkUtil.enableComponent(this.m_oNewTaskButton, isNewTaskEnabled);
        boolean isStartTaskEnabled = this.m_oPopupMenuManager.getMenuItemForID("StartTask").isEnabled();
        DCFrameWorkUtil.enableComponent(this.m_oStartTaskButton, isStartTaskEnabled);
        boolean isPauseTaskEnabled = this.m_oPopupMenuManager.getMenuItemForID("PauseTask").isEnabled();
        this.m_oPauseTaskButton.setEnabled(isPauseTaskEnabled);
        DCFrameWorkUtil.enableComponent(this.m_oPauseTaskButton, isPauseTaskEnabled);
        boolean isContinueTaskEnabled = this.m_oPopupMenuManager.getMenuItemForID("ContinueTask").isEnabled();
        DCFrameWorkUtil.enableComponent(this.m_oContinueTaskButton, isContinueTaskEnabled);
        boolean isCopyTaskEnabled = this.m_oPopupMenuManager.getMenuItemForID("Copy").isEnabled();
        DCFrameWorkUtil.enableComponent(this.m_oCopyTaskButton, isCopyTaskEnabled);
        boolean isGenerateReportEnabled = this.m_oPopupMenuManager.getMenuItemForID("GenerateReport").isEnabled();
        DCFrameWorkUtil.enableComponent(this.m_oGenerateReportButton, isGenerateReportEnabled);
    }

    private void changeButtonsStatus(boolean b) {
        DCFrameWorkUtil.enableComponent(this.m_oStartTaskButton, false);
        DCFrameWorkUtil.enableComponent(this.m_oPauseTaskButton, false);
        DCFrameWorkUtil.enableComponent(this.m_oContinueTaskButton, false);
        DCFrameWorkUtil.enableComponent(this.m_oGenerateReportButton, false);
        DCFrameWorkUtil.enableComponent(this.m_oCopyTaskButton, false);
    }

    private void changeNewTaskButtonStatus(boolean b) {
        if (DeviceInfoManagerImpl.getInstance().isHaveResourceInSys()) {
            DCFrameWorkUtil.enableComponent(this.m_oNewTaskButton, b && this.m_hasTaskMgrPrivilege);
        } else {
            DCFrameWorkUtil.enableComponent(this.m_oNewTaskButton, false);
        }
    }

    public void enableContinueTaskBtn(boolean bEnable) {
        if (null != this.m_oContinueTaskButton) {
            this.m_oContinueTaskButton.setEnabled(bEnable);
        }
    }

    public void disposePanel() {
        this.m_oTaskTablePanel = null;
        this.m_oPopupMenuManager = null;
        this.m_oNewTaskPopupMenu = null;
        if (null != this.m_oTaskMenuItemMap) {
            this.m_oTaskMenuItemMap.clear();
        }
        this.m_oTaskMenuItemMap = null;
    }

    public void setRefreshDateTime() {
        this.strdate = DeviceTableUtil.getCurDateTimeStr();
        this.refreshSelectedTaskCountLabel();
    }
}

