/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.OperationIdStore;
import com.huawei.dc.common.components.treetable.model.DCTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableNodeCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.ITaskSubOperation;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.SubOperationObject;
import com.huawei.dc.taskmgmt.model.SubOprCheckItemDetails;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.view.common.AbstractTaskSubOperationTablePanel;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTableUtil;
import gnu.trove.THashSet;
import java.math.BigInteger;
import java.text.Collator;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TaskSubOperationTablePanel
extends AbstractTaskSubOperationTablePanel {
    private static final long serialVersionUID = -3350429113501894862L;
    private static final String BACKUP_NODE_STRING = ResourceManager.getInstance().getResString("BACKUP");

    public TaskSubOperationTablePanel(DCSortableTreeTable oTaskTreeTable) {
        super(oTaskTreeTable);
    }

    private void populateData(TreeTableNode oNode, THashSet<Resource> oResList) {
        Resource oRes2 = null;
        TreeTableRowData oData = (TreeTableRowData)oNode.getUserObject();
        Resource oSelectedRes = (Resource)oData.getUserObject();
        DeviceInfo oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(oSelectedRes.getDeviceID());
        int iDomain = oDevInfo.getDeviceTypeInfo().getDevDomain();
        if (this.m_bIsBoardLevel && 1 == iDomain && this.m_iCurrentOprID != 8 && this.m_iCurrentOprID != 6) {
            return;
        }
        oDevInfo = null;
        ITaskSubOperation oTaskOprDetails = null;
        SubOprCheckItemDetails oOprDetails = null;
        HashMap<String, SubOperationObject> oNodeList = null;
        ArrayList<String> oOrderList = null;
        for (Resource oRes2 : oResList) {
            if (oSelectedRes.getDeviceID() != oRes2.getDeviceID() || null == (oTaskOprDetails = oRes2.getSubOprInfo(this.m_iCurrentOprID)) || !oTaskOprDetails.mustShowData() || null == (oOprDetails = oTaskOprDetails.getSubOprObject())) continue;
            oNodeList = oOprDetails.getNodeList();
            oOrderList = oOprDetails.getOrderList();
            this.taskOprNode(oNodeList, oOrderList, oTaskOprDetails.hasCheckItems(), oRes2);
        }
    }

    private void taskOprNode(HashMap<String, SubOperationObject> oNodeList, ArrayList<String> oOrderList, boolean bHasCheckItems, Resource oRes) {
        int iSize = oOrderList.size();
        if (0 == iSize) {
            return;
        }
        int iDomain = this.m_oTaskObj.getDeviceType().getDeviceDomain();
        SubOperationObject oObj = null;
        TreeTableNode oRootOperationNode = null;
        Calendar oCompleteStartTime = null;
        Calendar oCompleteEndTime = null;
        int iCompleteResult = -1;
        TreeTableCellData oOprName = null;
        TreeTableCellData oCmd = null;
        TreeTableCellData oStartTime = null;
        TreeTableCellData oEndTime = null;
        TreeTableCellData oResult = null;
        TreeTableCellData oDesc = null;
        String oPID = "";
        String strRoot = "";
        TreeTableRowData oRow = null;
        TreeTableNodeCellData oDevNameCell = null;
        TreeTableNode oOperationNode = null;
        boolean bAllOperationComplete = true;
        int iSelectedDevID = oRes.getDeviceID();
        for (int j = 0; j < iSize; ++j) {
            int iCompare;
            oStartTime = null;
            oEndTime = null;
            oResult = null;
            oDesc = null;
            oObj = oNodeList.get(oOrderList.get(j));
            if (null == oObj || -1 != oObj.getDeviceID() && iSelectedDevID != oObj.getDeviceID()) continue;
            oRow = new TreeTableRowData(8);
            if (ResourceManager.getInstance().isDmsForSpecialDevType(oRes.getDeviceType())) {
                oOprName = new TreeTableCellData(ResourceManager.getInstance().getSpecialResForDMS(oRes.getDeviceType(), oObj.getNodeID()));
                oCmd = new TreeTableCellData(ResourceManager.getInstance().getSpecialResForDMS(oRes.getDeviceType(), oObj.getOprNodeAttributes().getCommand()));
            } else {
                oOprName = new TreeTableCellData(DCFrameWorkUtil.getLocalizedString(oObj.getNodeID()));
                oCmd = new TreeTableCellData(DCFrameWorkUtil.getLocalizedString(oObj.getOprNodeAttributes().getCommand()));
            }
            oOprName.setNodeID(oObj.getNodeID());
            if (oObj.getParentID().equals("Connectivity") && !StringUtils.isIPV4(oObj.getNodeID())) {
                oCmd.setCellDataValue(oOprName.toString());
            }
            if (oObj.getNodeID().equals(oObj.getDevConnInfo().getStrContent())) {
                oCmd.setCellDataValue(oObj.getDevConnInfo().getStrContent());
            }
            if (null != oObj.getOprNodeAttributes().getStartTime()) {
                oStartTime = new TreeTableCellData(DCTimeDateUtil.getLocaleDisplayTime(oObj.getOprNodeAttributes().getStartTime()));
                if (null == oCompleteStartTime) {
                    oCompleteStartTime = oObj.getOprNodeAttributes().getStartTime();
                } else {
                    iCompare = oCompleteStartTime.getTime().compareTo(oObj.getOprNodeAttributes().getStartTime().getTime());
                    if (0 == iCompare || 0 < iCompare) {
                        oCompleteStartTime = oObj.getOprNodeAttributes().getStartTime();
                    }
                }
            }
            if (null != oObj.getOprNodeAttributes().getEndTime()) {
                oEndTime = new TreeTableCellData(DCTimeDateUtil.getLocaleDisplayTime(oObj.getOprNodeAttributes().getEndTime()));
                if (null == oCompleteEndTime) {
                    oCompleteEndTime = oObj.getOprNodeAttributes().getEndTime();
                } else {
                    iCompare = oCompleteEndTime.getTime().compareTo(oObj.getOprNodeAttributes().getEndTime().getTime());
                    if (0 == iCompare || 0 > iCompare) {
                        oCompleteEndTime = oObj.getOprNodeAttributes().getEndTime();
                    }
                }
            }
            if (null != oStartTime && null != oEndTime) {
                oResult = new TreeTableCellData(this.getResult(oObj.getOprNodeAttributes().getOprResult(), oObj.getNodeID(), true));
                if (-1 == iCompleteResult) {
                    iCompleteResult = oObj.getOprNodeAttributes().getOprResult();
                } else if (oObj.getOprNodeAttributes().getOprResult() > iCompleteResult) {
                    iCompleteResult = oObj.getOprNodeAttributes().getOprResult();
                }
                oDesc = this.getDescCellData(oRes, oObj);
            }
            oRow.setColumnData(0, oOprName);
            oRow.setColumnData(4, oStartTime);
            oRow.setColumnData(5, oEndTime);
            oPID = Normalizer.normalize(oObj.getParentID(), Normalizer.Form.NFC);
            strRoot = Normalizer.normalize("", Normalizer.Form.NFC);
            oResult = this.setResultCellData(oObj, oPID, strRoot, oResult);
            oRow.setNodeStatus(oObj.getOprNodeAttributes().getStatus());
            oDevNameCell = new TreeTableNodeCellData(oOprName);
            oOperationNode = new TreeTableNode(oRow);
            oDevNameCell.setAttachedTreeNode(oOperationNode);
            if (Collator.getInstance().equals(oPID, strRoot)) {
                oRootOperationNode = oOperationNode;
                this.m_oRootNode.add(oOperationNode);
                if (bHasCheckItems) {
                    oRow.setNodeType(4);
                } else {
                    oRow.setNodeType(5);
                }
                oRow.setColumnData(6, oResult);
                oRow.setColumnData(7, oDesc);
            } else {
                TreeTableNode oSubOprNode = this.getParentNode(this.m_oRootNode, oPID);
                if (null != oSubOprNode) {
                    if (StringUtils.isIPV4(oObj.getNodeID()) && "Connectivity".equals(oObj.getParentID()) && !oRes.getDeviceIP().equals(oObj.getNodeID())) continue;
                    oSubOprNode.add(oOperationNode);
                    if (oObj.hasSubCheckItems()) {
                        if (this.checkHasSubItemsForSelectedDevice(oNodeList, oOrderList, iSelectedDevID, oObj.getNodeID())) {
                            oRow.setNodeType(4);
                        } else {
                            oRow.setNodeType(5);
                        }
                    } else {
                        oRow.setNodeType(5);
                        if ((6 == this.m_iCurrentOprID || 2 == this.m_iCurrentOprID) && 1 == iDomain) {
                            oSubOprNode.remove(oOperationNode);
                        }
                    }
                    oRow.setColumnData(1, oCmd);
                    oRow.setColumnData(6, oResult);
                    oRow.setColumnData(7, oDesc);
                }
            }
            if (!this.isLeaf(oNodeList, oObj, iDomain) || null != oStartTime && null != oEndTime) continue;
            bAllOperationComplete = false;
        }
        if (4 != iDomain && !bAllOperationComplete && 0 == iCompleteResult) {
            oCompleteEndTime = null;
            iCompleteResult = -1;
        }
        this.updateOprStartTimeNEndTime(oRootOperationNode, oCompleteStartTime, oCompleteEndTime);
    }

    private TreeTableCellData getDescCellData(Resource oRes, SubOperationObject oObj) {
        TreeTableCellData oDesc;
        if (this.isShowLinkRender(this.m_iCurrentOprID)) {
            boolean bShow = true;
            if (28 == this.m_iCurrentOprID && oObj.getOprNodeAttributes().getErrorCode() == 0 && DeviceInfoUtil.isPTNDevice(oRes.getDevTypeId())) {
                bShow = false;
            }
            if (bShow) {
                int subOperErrorcode = oObj.getOprNodeAttributes().getErrorCode();
                oDesc = 995098639 == subOperErrorcode ? new TreeTableCellData(DCFrameWorkUtil.getLocalizedString(ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(995098639L)))) : (-1 == subOperErrorcode && oObj.getNodeID().equals("EXTENDCHECK") ? new TreeTableCellData(DCFrameWorkUtil.getLocalizedString("EXTEND_CHECK_SUCCESS")) : new TreeTableCellData(DCFrameWorkUtil.getLocalizedString("CHECK_REPORT_VIEW_DETAIL")));
            } else {
                String sErrorCode = oObj.getOprNodeAttributes().getErrorCodeInfo().getErrCodeDescription();
                oDesc = new TreeTableCellData(sErrorCode);
            }
        } else {
            oDesc = null != oObj.getOprNodeAttributes().getErrorInfo() ? (999293081 == oObj.getOprNodeAttributes().getErrorCode() ? new TreeTableCellData(oObj.getOprNodeAttributes().getErrorCodeInfo()) : new TreeTableCellData(oObj.getOprNodeAttributes().getErrorInfo())) : new TreeTableCellData(DCFrameWorkUtil.getLocalizedString(oObj.getOprNodeAttributes().getDescription()));
        }
        return oDesc;
    }

    private TreeTableCellData setResultCellData(SubOperationObject oObj, String oPID, String strRoot, TreeTableCellData defaultResult) {
        TreeTableCellData oResult = null;
        if (Collator.getInstance().equals(oPID, strRoot)) {
            ResourceProgressInfo oResProgerss = this.getCurrentResourceProgress();
            if (null != oResProgerss && oResProgerss.getState() != 0 && oResProgerss.getState() != 1 || null != oResProgerss && oResProgerss.getState() == 0 && oResProgerss.getResult() == 2) {
                oResult = new TreeTableCellData(this.getResult(oResProgerss.getResult(), oObj.getNodeID(), true));
            }
            if (null != oResProgerss && oResProgerss.getState() == 1) {
                oResult = new TreeTableCellData("");
            }
        } else if (oObj.getOprNodeAttributes().getStatus() == 1) {
            oResult = new TreeTableCellData("");
        } else {
            return defaultResult;
        }
        return oResult;
    }

    private ResourceProgressInfo getCurrentResourceProgress() {
        int iTaskID = this.m_oTaskObj.getTaskId();
        int iDeviD = this.m_oResource.getDeviceID();
        ITask oTask = TaskDataModel.getInstance().getTask(iTaskID);
        String strOperID = OperationIdStore.getInstance().getOperationStrId(this.m_iCurrentOprID);
        return TaskInfoUtil.getResourceProgress(oTask, iDeviD, strOperID);
    }

    private boolean isLeaf(HashMap<String, SubOperationObject> oNodeList, SubOperationObject curNode, int iDevDomain) {
        boolean isLeaf = false;
        if (null == oNodeList || null == curNode) {
            return isLeaf;
        }
        String curParentID = curNode.getParentID();
        if (StringUtils.isNullOrEmptyStr(curParentID)) {
            return isLeaf;
        }
        boolean haveChildren = false;
        String curNodeID = curNode.getNodeID();
        if ("Connectivity".equals(curParentID) && StringUtils.isIPV4(curNodeID)) {
            return isLeaf;
        }
        if (iDevDomain == 1 && BACKUP_NODE_STRING.equals(curParentID)) {
            return isLeaf;
        }
        String parentID = null;
        SubOperationObject eachNode = null;
        Set<Map.Entry<String, SubOperationObject>> allEntry = oNodeList.entrySet();
        for (Map.Entry<String, SubOperationObject> entry : allEntry) {
            eachNode = entry.getValue();
            parentID = eachNode.getParentID();
            if (!curNodeID.equals(parentID)) continue;
            haveChildren = true;
            break;
        }
        if (!haveChildren) {
            isLeaf = true;
        }
        return isLeaf;
    }

    private boolean checkHasSubItemsForSelectedDevice(HashMap<String, SubOperationObject> oNodeList, ArrayList<String> oOrderList, int iSelectedDevID, String strPID) {
        int iSize = oOrderList.size();
        SubOperationObject oObj = null;
        for (int j = 0; j < iSize; ++j) {
            oObj = oNodeList.get(oOrderList.get(j));
            if (-1 != oObj.getDeviceID() && iSelectedDevID != oObj.getDeviceID() || !Collator.getInstance().equals(oObj.getParentID(), strPID)) continue;
            return true;
        }
        return false;
    }

    private TreeTableNode getParentNode(TreeTableNode oNode, String oParentID) {
        boolean bParentFound = false;
        String strPID = DCFrameWorkUtil.getLocalizedString(oParentID);
        if (this.compareID(oNode, strPID)) {
            return oNode;
        }
        int iChildCount = oNode.getChildCount();
        TreeTableNode oTemp = null;
        TreeTableNode oReqNode = null;
        for (int i = 0; i < iChildCount; ++i) {
            oTemp = (TreeTableNode)oNode.getChildAt(i);
            oReqNode = this.getParentNode(oTemp, oParentID);
            if (null == oReqNode) continue;
            bParentFound = true;
            oTemp = oReqNode;
            break;
        }
        strPID = null;
        if (bParentFound) {
            return oTemp;
        }
        return null;
    }

    private TreeTableNode getRoot() {
        DCTreeTableModel oModel = this.m_oOpResultTreeTable.getDataModel();
        return oModel.getRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTreeTable(TreeTableNode oRoot) {
        try {
            int iCount = oRoot.getChildCount();
            TreeTableNode oNode = null;
            for (int i = 0; i < iCount; ++i) {
                oNode = (TreeTableNode)oRoot.getChildAt(i);
                if (null == oNode) continue;
                TreeTableRowData oRow = (TreeTableRowData)oNode.getUserObject();
                if (null == oRow) {
                    oNode.setUserObject(null);
                    oNode.setParent(null);
                    oNode = null;
                    continue;
                }
                Enumeration<TreeNode> oChildNodes = oNode.depthFirstEnumeration();
                TreeTableNode oChildNode = null;
                while (oChildNodes.hasMoreElements()) {
                    oChildNode = (TreeTableNode)oChildNodes.nextElement();
                    TreeTableRowData oChildRow = (TreeTableRowData)oChildNode.getUserObject();
                    if (null == oChildRow) {
                        oChildNode.setUserObject(null);
                        oChildNode.setParent(null);
                        oChildNode = null;
                        continue;
                    }
                    oChildRow.setUserObject(null);
                    oChildRow.clearData();
                    oChildRow = null;
                    oChildNode.removeAllChildren();
                    oChildNode.setUserObject(null);
                    oChildNode.setParent(null);
                    oChildNode = null;
                }
                oRow.setUserObject(null);
                oRow.clearData();
                oRow = null;
                oNode.removeAllChildren();
                oNode.setUserObject(null);
                oNode.setParent(null);
                oNode = null;
            }
        }
        catch (Exception ignore) {
            DCDebugTracer.trace("[memory leak] TaskSubOperationTablePanel#clearTreeTable release resources throw exception do not affort function");
            DCDebugTracer.trace(ignore);
        }
        finally {
            oRoot.removeAllChildren();
        }
    }

    public void updateOprDetailsTable(int iCurrentOprID) {
        this.updateOprDetailsTable(iCurrentOprID, null);
    }

    public void updateOprDetailsTable(int iCurrentOprID, Resource res) {
        int iSelectedRow;
        boolean TASK = false;
        boolean DEVICE = true;
        this.m_iCurrentOprID = iCurrentOprID;
        TreeTableNode oRoot = this.getRoot();
        if (null == res) {
            this.clearTreeTable(oRoot);
        }
        if (-1 != (iSelectedRow = this.m_oTaskTreeTable.getSelectedRow())) {
            this.addScrollPane();
        }
        this.initializeTaskObj();
        boolean bIsResourceSelectedInSingleTask = TaskTableUtil.isASingleTaskSelection(this.m_oTaskTreeTable);
        if (bIsResourceSelectedInSingleTask && TaskTableUtil.isAResourceOnlySelection(this.m_oTaskTreeTable)) {
            this.displayHiddenColumns(1);
            this.m_bIsBoardLevel = false;
            this.m_oCustomTableColumnModel.getColumn(0).setHeaderValue(this.m_oResourceMngr.getResString("SUB_OPERATION"));
            this.m_oOpResultTreeTable.getTableHeader().resizeAndRepaint();
            this.setLinkRenderer();
            this.populateDeviceData(false);
            this.removeTableColumn(1);
            this.m_oOpResultTreeTable.expandTree(this.m_oTree, this.m_oRootNode);
            this.updateTreeTable();
        } else if (bIsResourceSelectedInSingleTask && TaskTableUtil.isABoardResourceOnlySelection(this.m_oTaskTreeTable)) {
            this.m_bIsBoardLevel = true;
            this.populateDeviceData(true);
            this.m_oOpResultTreeTable.expandTree(this.m_oTree, this.m_oRootNode);
            this.updateTreeTable();
        } else if (bIsResourceSelectedInSingleTask && TaskTableUtil.isATaskOnlySelection(this.m_oTaskTreeTable)) {
            this.displayHiddenColumns(0);
            this.m_oCustomTableColumnModel.getColumn(this.toView(7)).setCellRenderer(this.m_oLinkRenderer);
            this.m_bIsBoardLevel = false;
            this.m_oCustomTableColumnModel.getColumn(0).setHeaderValue(this.m_oResourceMngr.getResString("RES_OPR_NAME").trim());
            this.m_oOpResultTreeTable.getTableHeader().resizeAndRepaint();
            this.populateTaskDeviceData(res);
            this.updateTreeTableForTaskSelected(res);
        } else {
            this.m_oOpResultTreeTable.expandTree(this.m_oTree, this.m_oRootNode);
            this.updateTreeTable();
        }
    }

    private void updateTreeTableForTaskSelected(Resource res) {
        ResourceProgressInfo progressInfo;
        if (null == res) {
            if (null != this.m_oOpResultTreeTable) {
                DCFrameWorkUtil.updateUI((JComponent)((Object)this.m_oOpResultTreeTable));
            }
        } else if (null != res.getProgressInfo() && null != (progressInfo = res.getProgressInfo())) {
            if (1 != progressInfo.getState()) {
                this.updateTreeTable();
            } else if (0 == progressInfo.getProgress() || 100 == progressInfo.getProgress()) {
                this.updateTreeTable();
            }
        }
    }

    private void populateDeviceData(boolean bIsBoard) {
        int iSelectedRow = this.m_oTaskTreeTable.getSelectedRow();
        TreePath oTreePath = this.m_oTaskTreeTable.getTree().getPathForRow(iSelectedRow);
        TreeTableNode oNode = null;
        TreeTableRowData oData = null;
        THashSet<Resource> oList = null;
        if (null != oTreePath && null != (oNode = (TreeTableNode)oTreePath.getLastPathComponent())) {
            this.m_oTaskObj = TaskTableUtil.getTaskForTableNode(oNode);
            oData = (TreeTableRowData)oNode.getUserObject();
            this.m_oResource = (Resource)oData.getUserObject();
            if (bIsBoard) {
                Vector oStorageBoardLabelList = new Vector(0);
                oList = TaskTableUtil.getSelectedBoardResources(this.m_oTaskTreeTable, oStorageBoardLabelList);
            } else {
                oList = new THashSet<Resource>();
                oList.add((Object)this.m_oResource);
            }
            this.populateData(oNode, oList);
        }
        oTreePath = null;
        oNode = null;
        oData = null;
        oList = null;
    }

    private void populateTaskDeviceData(Resource res) {
        int iSelectedRow = this.m_oTaskTreeTable.getSelectedRow();
        TreePath oTreePath = this.m_oTaskTreeTable.getTree().getPathForRow(iSelectedRow);
        TreeTableNode oNode = null;
        boolean TASK = false;
        if (null != oTreePath && null != (oNode = (TreeTableNode)oTreePath.getLastPathComponent())) {
            this.m_oTaskObj = TaskTableUtil.getTaskForTableNode(oNode);
            switch (this.m_oTaskObj.getTaskProgressInfo().getState()) {
                case 0: {
                    if (null != res) break;
                    this.populateTableForNotRunTask(this.m_oTaskObj);
                    this.removeTableColumn(0);
                    this.m_oOpResultTreeTable.expandTree(this.m_oTree, this.m_oRootNode);
                    break;
                }
                default: {
                    this.populateTableForTask(this.m_oTaskObj, res);
                    this.removeTableColumn(0);
                    this.m_oOpResultTreeTable.expandTree(this.m_oTree, this.m_oRootNode);
                }
            }
        }
        oTreePath = null;
        oNode = null;
    }

    private void updateTreeTable() {
        if (null != this.m_oOpResultTreeTable) {
            DCFrameWorkUtil.updateUI(this.m_oOpResultTreeTable.getTableHeader());
            DCFrameWorkUtil.updateUI((JComponent)((Object)this.m_oOpResultTreeTable));
        }
    }

    private void setOprStartAndEndTime(ITask oTaskObj, TreeTableNode oOprNode) {
        THashSet<Resource> oResList = oTaskObj.getDeviceType().getResources();
        Resource oRes2 = null;
        ResourceProgressInfo resPro = null;
        Calendar oOprStartTime = null;
        Calendar oOprEndTime = null;
        boolean bDisplayTaskLevelOprEndtime = true;
        String curOprId = OperationIdStore.getInstance().getOperationStrId(this.m_iCurrentOprID);
        boolean isTaskInprogress = 1 == oTaskObj.getTaskProgressInfo().getState();
        for (Resource oRes2 : oResList) {
            int iCompare;
            resPro = isTaskInprogress ? oRes2.getProgressInfo() : oRes2.getOprResultInfo(curOprId);
            if (null != resPro) {
                int currState = oRes2.getProgressInfo().getState();
                if (!resPro.getCurrentOperationId().equals(curOprId) || currState != 1) {
                    resPro = oRes2.getOprResultInfo(curOprId);
                }
            } else {
                resPro = oRes2.getOprResultInfo(curOprId);
            }
            if (null != resPro && 1 == resPro.getState()) {
                bDisplayTaskLevelOprEndtime = false;
            }
            if (null == resPro || !curOprId.equals(resPro.getCurrentOperationId())) continue;
            if (null != resPro.getStartTime()) {
                if (null == oOprStartTime) {
                    oOprStartTime = resPro.getStartTime();
                }
                if (0 == (iCompare = oOprStartTime.getTime().compareTo(resPro.getStartTime().getTime())) || 0 < iCompare) {
                    oOprStartTime = resPro.getStartTime();
                }
            }
            if (null == resPro.getEndTime()) continue;
            if (null == oOprEndTime) {
                oOprEndTime = resPro.getEndTime();
            }
            if (0 != (iCompare = oOprEndTime.getTime().compareTo(resPro.getEndTime().getTime())) && 0 <= iCompare) continue;
            oOprEndTime = resPro.getEndTime();
        }
        if (!bDisplayTaskLevelOprEndtime) {
            oOprEndTime = null;
        }
        this.updateOprStartTimeNEndTime(oOprNode, oOprStartTime, oOprEndTime);
    }

    private void populateTableForTask(ITask oTaskObj, Resource res) {
        TreeTableNode oOperationNode = this.createTaskLevelOprNode();
        this.m_oRootNode.add(oOperationNode);
        boolean isTaskInprogress = 1 == oTaskObj.getTaskProgressInfo().getState();
        boolean bResInTask = TaskInfoUtil.isResouceInTask(oTaskObj, res);
        DCDebugTracer.traceDetail("[record information] bResInTask : " + bResInTask);
        if (!bResInTask && null != res) {
            return;
        }
        TreeTableNode oDeviceNode = this.getDevNode(oOperationNode, res);
        if (null == oDeviceNode) {
            this.createDeviceNode(oTaskObj.getDeviceType().getResources(), isTaskInprogress, oOperationNode);
        } else {
            this.updateDeviceNode(oTaskObj, res, oDeviceNode);
        }
        this.setOprStartAndEndTime(oTaskObj, oOperationNode);
    }

    private void updateDeviceNode(ITask oTaskObj, Resource res, TreeTableNode oDeviceNode) {
        THashSet<Resource> oResList = oTaskObj.getDeviceType().getResources();
        Resource oRes = null;
        ResourceProgressInfo oResourceProgressInfo = null;
        TreeTableCellData oStartTime = null;
        TreeTableCellData oEndTime = null;
        TreeTableCellData oResult = null;
        TreeTableCellData oDesc = null;
        Iterator oResItor = oResList.iterator();
        String curOprId = OperationIdStore.getInstance().getOperationStrId(this.m_iCurrentOprID);
        while (oResItor.hasNext() && (oRes = (Resource)oResItor.next()).getDeviceID() != res.getDeviceID()) {
        }
        if (null != oRes) {
            DCDebugTracer.traceDetail("[record information] oRes name : " + oRes.getDeviceName() + " oRes Id : " + oRes.getDeviceID());
        }
        if (null != oRes) {
            oResourceProgressInfo = 1 == oTaskObj.getTaskProgressInfo().getState() ? oRes.getProgressInfo() : oRes.getOprResultInfo(curOprId);
        }
        if (null != oResourceProgressInfo && oResourceProgressInfo.getCurrentOperationId().equals(curOprId)) {
            TreeTableRowData oRow = (TreeTableRowData)oDeviceNode.getUserObject();
            if (null != oResourceProgressInfo.getStartTime() && null != oRow) {
                oStartTime = oRow.getColumnData(4);
                if (null == oStartTime) {
                    oStartTime = new TreeTableCellData("");
                }
                oStartTime.setCellDataValue(StringUtils.convertTimeToString(oResourceProgressInfo.getStartTime()));
            }
            if (null != oRow) {
                oResult = oRow.getColumnData(6);
            }
            if (null == oResult) {
                oResult = new TreeTableCellData("");
            }
            if (0 != oResourceProgressInfo.getState() && 1 != oResourceProgressInfo.getState()) {
                oResult.setCellDataValue(this.getResult(oResourceProgressInfo.getResult(), oResourceProgressInfo.getCurrentOperationId()));
            }
            if (1 == oResourceProgressInfo.getState()) {
                oResult.setCellDataValue("");
            }
            if (null != oResourceProgressInfo.getEndTime() && null != oRow) {
                oEndTime = oRow.getColumnData(5);
                if (null == oEndTime) {
                    oEndTime = new TreeTableCellData("");
                }
                oEndTime.setCellDataValue(StringUtils.convertTimeToString(oResourceProgressInfo.getEndTime()));
                oDesc = oRow.getColumnData(7);
                if (null == oDesc) {
                    oDesc = new TreeTableCellData("");
                }
                oDesc.setCellDataValue(oResourceProgressInfo.getErrorInfo());
            }
        }
        DCDebugTracer.traceDetail("[record information] construct tree node end..");
    }

    private TreeTableNode getDevNode(TreeTableNode oParentNode, Resource res) {
        DCDebugTracer.traceDetail("[record information] method getDevNode start");
        if (null == res) {
            return null;
        }
        String strDevID = String.valueOf(res.getDeviceID());
        int iCount = oParentNode.getChildCount();
        for (int i = 0; i < iCount; ++i) {
            TreeTableNode oNode = (TreeTableNode)oParentNode.getChildAt(i);
            TreeTableRowData oData = null;
            TreeTableCellData oCellData = null;
            String strCellData = "";
            oData = (TreeTableRowData)oNode.getUserObject();
            if (null == oData) continue;
            oCellData = oData.getColumnData(0);
            strCellData = oCellData.getNodeID();
            strCellData = Normalizer.normalize(strCellData, Normalizer.Form.NFC);
            if (!Collator.getInstance().equals(strDevID, strCellData)) continue;
            DCDebugTracer.traceDetail("[record information] operation Name : " + oCellData);
            DCDebugTracer.traceDetail("[record information]  strDevID : " + strDevID);
            DCDebugTracer.traceDetail("[record information] method getDevNode end..");
            return oNode;
        }
        DCDebugTracer.traceDetail("[record information] method getDevNode end node is null");
        return null;
    }

    private void populateTableForNotRunTask(ITask oTaskObj) {
        THashSet<Resource> oResList = oTaskObj.getDeviceType().getResources();
        Resource oRes2 = null;
        DeviceTypeInfo oDeviceTypeInfo = null;
        TreeTableRowData oRow = null;
        TreeTableCellData oDeviceName = null;
        TreeTableCellData oDeviceIP = null;
        TreeTableCellData oNEID = null;
        TreeTableCellData oDevType = null;
        TreeTableNode oDeviceNode = null;
        String strDevInfo = "";
        TreeTableNode oOperationNode = this.createTaskLevelOprNode();
        this.m_oRootNode.add(oOperationNode);
        for (Resource oRes2 : oResList) {
            if (3 == oRes2.getRoleType() && -1 != oRes2.getStackId()) continue;
            oDeviceTypeInfo = DeviceInfoManagerImpl.getInstance().getDevice(oRes2.getDeviceID()).getDeviceTypeInfo();
            int iDevDomain = oDeviceTypeInfo.getDevDomain();
            strDevInfo = oDeviceTypeInfo.getDevTypeName();
            if (4 != iDevDomain && null != oDeviceTypeInfo.getDevTypeVersionName() && 0 != oDeviceTypeInfo.getDevTypeVersionName().length()) {
                strDevInfo = strDevInfo + "(" + oDeviceTypeInfo.getDevTypeVersionName() + ")";
            }
            oRow = new TreeTableRowData(8, 2);
            oRow.setDevID(oRes2.getDeviceID());
            oDeviceName = new TreeTableCellData(oRes2.getDeviceName());
            oDeviceName.setNodeID(String.valueOf(oRes2.getDeviceID()));
            oDeviceIP = new TreeTableCellData(oRes2.getDeviceIP());
            oDevType = new TreeTableCellData(strDevInfo);
            oRow.setColumnData(0, oDeviceName);
            oRow.setColumnData(1, oDeviceIP);
            if (4 == iDevDomain) {
                oNEID = new TreeTableCellData(this.getShowDevIdInfo(oRes2.getDeviceID()));
                oRow.setColumnData(2, oNEID);
            }
            oRow.setColumnData(3, oDevType);
            oDeviceNode = new TreeTableNode(oRow);
            oOperationNode.add(oDeviceNode);
        }
        oRow = null;
        oDeviceName = null;
        oDeviceIP = null;
        oDeviceNode = null;
    }

    public void doCleanUp() {
        if (this.m_oOpResultTreeTable != null) {
            this.m_oOpResultTreeTable.removeAll();
            this.m_oOpResultTreeTable = null;
        }
        if (null != this.m_oRootNode) {
            this.clearTreeTable(this.m_oRootNode);
            this.m_oRootNode = null;
        }
        if (null != this.m_oOpResultScrollPane) {
            this.m_oOpResultScrollPane.removeAll();
            this.m_oOpResultScrollPane = null;
        }
        if (null != this.m_oTree) {
            this.m_oTree.removeAll();
            this.m_oTree = null;
        }
        if (null != this.m_oTaskObj) {
            this.m_oTaskObj = null;
        }
        if (null != this.m_oResource) {
            this.m_oResource = null;
        }
        if (null != this.m_oLinkRenderer) {
            this.m_oLinkRenderer.removeAll();
            this.m_oLinkRenderer = null;
        }
        if (null != this.m_oDefaultRenderer) {
            this.m_oDefaultRenderer.removeAll();
            this.m_oDefaultRenderer = null;
        }
        if (null != this.m_oCustomTableColumnModel) {
            this.m_oCustomTableColumnModel.setToNULL();
            this.m_oCustomTableColumnModel = null;
        }
    }

    public void removeScrollPane() {
        this.remove(this.m_oOpResultScrollPane);
        this.updateUI();
        this.repaint();
    }

    private void addScrollPane() {
        this.add(this.m_oOpResultScrollPane);
        this.updateUI();
        this.repaint();
    }

    private void updateOprStartTimeNEndTime(TreeTableNode oOprNode, Calendar oCalStartTime, Calendar oCalEndTime) {
        TreeTableRowData oRow = (TreeTableRowData)oOprNode.getUserObject();
        if (null == oRow) {
            return;
        }
        TreeTableCellData oStartTime = null;
        TreeTableCellData oEndTime = null;
        if (null != oCalStartTime) {
            oStartTime = oRow.getColumnData(4);
            if (null == oStartTime) {
                oStartTime = new TreeTableCellData(StringUtils.convertTimeToString(oCalStartTime));
            } else {
                oStartTime.setCellDataValue(StringUtils.convertTimeToString(oCalStartTime));
            }
        }
        if (null != oCalEndTime) {
            oEndTime = oRow.getColumnData(5);
            if (null == oEndTime) {
                oEndTime = new TreeTableCellData(StringUtils.convertTimeToString(oCalEndTime));
            } else {
                oEndTime.setCellDataValue(StringUtils.convertTimeToString(oCalEndTime));
            }
        }
        oRow.setColumnData(4, oStartTime);
        oRow.setColumnData(5, oEndTime);
    }

    protected int compareDate(Date oFirstValue, Date oSecondValue) {
        return oFirstValue.compareTo(oSecondValue);
    }

    public void removeColumn(int iColIndex) {
        TableColumn oCol = this.m_oCustomTableColumnModel.getColumn(iColIndex);
        this.m_oOpResultTreeTable.removeColumn(oCol);
        this.updateTableView();
    }

    private int toModel(int iColIndex) {
        if (iColIndex >= this.m_oOpResultTreeTable.getColumnCount()) {
            return -1;
        }
        return this.m_oCustomTableColumnModel.getColumn(iColIndex).getModelIndex();
    }

    private void initializeTaskObj() {
        int iSelectedRow = this.m_oTaskTreeTable.getSelectedRow();
        TreePath oTreePath = this.m_oTaskTreeTable.getTree().getPathForRow(iSelectedRow);
        TreeTableNode oNode = null;
        if (null != oTreePath && null != (oNode = (TreeTableNode)oTreePath.getLastPathComponent())) {
            this.m_oTaskObj = TaskTableUtil.getTaskForTableNode(oNode);
        }
    }

    private void removeTableColumn(int iSelectionType) {
        boolean TASK = false;
        boolean DEVICE = true;
        DeviceType oDevType = this.m_oTaskObj.getDeviceType();
        boolean bIsTelnetDevicePresent = this.isTelnetDevicePresent(oDevType);
        TableColumn column = null;
        boolean visible = false;
        switch (iSelectionType) {
            case 1: {
                visible = false;
                if (!bIsTelnetDevicePresent || 4 != this.m_iCurrentOprID && 16 != this.m_iCurrentOprID && 28 != this.m_iCurrentOprID && 29 != this.m_iCurrentOprID) {
                    column = this.m_oCustomTableColumnModel.getColumnByModelIndex(1);
                    visible = this.m_oCustomTableColumnModel.isColumnVisible(column);
                    if (visible) {
                        this.m_oCustomTableColumnModel.setColumnVisible(column, !visible);
                    }
                    if (2 == oDevType.getDeviceDomain()) {
                        column = this.m_oCustomTableColumnModel.getColumnByModelIndex(7);
                        visible = this.m_oCustomTableColumnModel.isColumnVisible(column);
                        if (8 == this.m_iCurrentOprID) {
                            visible = this.isShowLinkRender(this.m_iCurrentOprID);
                            if (!visible) {
                                this.m_oCustomTableColumnModel.setColumnVisible(column, false);
                            }
                        } else if (visible) {
                            this.m_oCustomTableColumnModel.setColumnVisible(column, !visible);
                        }
                    }
                }
                if (visible = this.m_oCustomTableColumnModel.isColumnVisible(column = this.m_oCustomTableColumnModel.getColumnByModelIndex(2))) {
                    this.m_oCustomTableColumnModel.setColumnVisible(column, !visible);
                }
                if (!(visible = this.m_oCustomTableColumnModel.isColumnVisible(column = this.m_oCustomTableColumnModel.getColumnByModelIndex(3)))) break;
                this.m_oCustomTableColumnModel.setColumnVisible(column, !visible);
                break;
            }
            case 0: {
                if (4 == oDevType.getDeviceDomain() || !(visible = this.m_oCustomTableColumnModel.isColumnVisible(column = this.m_oCustomTableColumnModel.getColumnByModelIndex(2)))) break;
                this.m_oCustomTableColumnModel.setColumnVisible(column, !visible);
                break;
            }
        }
    }

    private void displayHiddenColumns(int iSelectionType) {
        boolean TASK = false;
        boolean DEVICE = true;
        DeviceType oDevType = this.m_oTaskObj.getDeviceType();
        boolean bIsTelnetDevicePresent = this.isTelnetDevicePresent(oDevType);
        TableColumn column = null;
        boolean visible = false;
        switch (iSelectionType) {
            case 1: {
                visible = false;
                if (!bIsTelnetDevicePresent && (4 != this.m_iCurrentOprID || 16 != this.m_iCurrentOprID || 28 != this.m_iCurrentOprID || 29 != this.m_iCurrentOprID)) break;
                column = this.m_oCustomTableColumnModel.getColumnByModelIndex(1);
                visible = this.m_oCustomTableColumnModel.isColumnVisible(column);
                this.m_oCustomTableColumnModel.setColumnVisible(column, visible);
                this.m_oCustomTableColumnModel.getColumn(this.toModel(1)).setHeaderValue(this.m_oResourceMngr.getResString("COMMAND"));
                if (2 != oDevType.getDeviceDomain()) break;
                column = this.m_oCustomTableColumnModel.getColumnByModelIndex(7);
                visible = this.m_oCustomTableColumnModel.isColumnVisible(column);
                this.m_oCustomTableColumnModel.setColumnVisible(column, visible);
                if (-1 == this.toModel(7)) break;
                this.m_oCustomTableColumnModel.getColumn(this.toModel(7)).setHeaderValue(this.m_oResourceMngr.getResString("DETAILS_BUTTON"));
                break;
            }
            case 0: {
                visible = false;
                column = this.m_oCustomTableColumnModel.getColumnByModelIndex(1);
                visible = this.m_oCustomTableColumnModel.isColumnVisible(column);
                this.m_oCustomTableColumnModel.setColumnVisible(column, visible);
                this.m_oCustomTableColumnModel.getColumn(1).setHeaderValue(this.m_oResourceMngr.getResString("DEVICE_TABLE_HEADER_RESOURCE_IP"));
                column = this.m_oCustomTableColumnModel.getColumnByModelIndex(7);
                visible = this.m_oCustomTableColumnModel.isColumnVisible(column);
                this.m_oCustomTableColumnModel.setColumnVisible(column, visible);
                if (-1 != this.toModel(7)) {
                    this.m_oCustomTableColumnModel.getColumn(this.toModel(7)).setHeaderValue(this.m_oResourceMngr.getResString("DETAILS_BUTTON"));
                }
                column = this.m_oCustomTableColumnModel.getColumnByModelIndex(2);
                if (4 == oDevType.getDeviceDomain()) {
                    visible = this.m_oCustomTableColumnModel.isColumnVisible(column);
                    this.m_oCustomTableColumnModel.setColumnVisible(column, visible);
                }
                column = this.m_oCustomTableColumnModel.getColumnByModelIndex(3);
                visible = this.m_oCustomTableColumnModel.isColumnVisible(column);
                this.m_oCustomTableColumnModel.setColumnVisible(column, visible);
                break;
            }
        }
        column = this.m_oCustomTableColumnModel.getColumnByModelIndex(7);
        visible = this.m_oCustomTableColumnModel.isColumnVisible(column);
        if (null != column && visible) {
            column.setMaxWidth(800);
        }
    }

    private void setLinkRenderer() {
        if (this.isShowLinkRender(this.m_iCurrentOprID)) {
            int index = this.toView(7);
            if (index != -1) {
                this.m_oCustomTableColumnModel.getColumn(index).setCellRenderer(this.m_oLinkRenderer);
            }
        } else {
            int index = this.toView(7);
            if (index != -1) {
                this.m_oCustomTableColumnModel.getColumn(index).setCellRenderer(this.m_oDefaultRenderer);
            }
        }
    }

    public void removeAllComponents() {
        this.removeAll();
        this.updateUI();
        this.repaint();
    }
}

