/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.adapter.swimap.iview.commstyle.resource.DCResourceMng;
import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCSortableTableModel;
import com.huawei.dc.adapter.swimap.iview.templates.print.DCPrintSupportor;
import com.huawei.dc.adapter.swimap.iview.templates.print.DCTablePrintable;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCSaveFileChooser;
import com.huawei.dc.common.util.WindowStyleButton;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.view.common.TaskStatistics;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import com.swimap.iview.templates.print.tools.TablePrintable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class TaskStatisticsDlg
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private DCSortableTableModel m_oTaskstatisticsModel;
    private DefaultTableModel m_oTotalTaskstatisticsModel;
    private String[] m_oTaskStatisticsTableColumns = new String[]{ResourceManager.getInstance().getResString("TASK_NAME"), ResourceManager.getInstance().getResString("TOTAL_DEVICES"), ResourceManager.getInstance().getResString("RUNNING_DEVICES"), ResourceManager.getInstance().getResString("NOT_RUN_DEVICES"), ResourceManager.getInstance().getResString("SUCCESS_DEVICES"), ResourceManager.getInstance().getResString("FAILURE_DEVICES")};
    private DCExtendedTable m_statisticsTable;
    private JTable m_totalStatisticsTable;
    private Vector m_oVecTotal;
    JPanel oMainPanel = null;
    private WindowStyleButton m_saveButton = null;
    private WindowStyleButton m_previewButton = null;
    private WindowStyleButton m_printButton = null;

    public TaskStatisticsDlg(ArrayList listOfTasks) {
        this.setTitle(ResourceManager.getInstance().getResString("TASK_STATISTICS_DLG_TITLE"));
        this.jbInit();
        this.setTableData(listOfTasks);
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    private void setTableData(ArrayList listOfTasks) {
        int iTotalDevices = 0;
        int iTotalrunningDevices = 0;
        int iTotalnotrunningDevices = 0;
        int iTotalSuccessfulDevices = 0;
        int iTotalfailureDevices = 0;
        double iTotalrunningDevicesCal = 0.0;
        double iTotalrunningDevicesRes = 0.0;
        double iTotalnotrunningDevicesCal = 0.0;
        double iTotalnotrunningDevicesRes = 0.0;
        double iTotalSuccessfulDevicesCal = 0.0;
        double iTotalSuccessfulDevicesRes = 0.0;
        double iTotalfailureDevicesCal = 0.0;
        double iTotalfailureDevicesRes = 0.0;
        this.m_oVecTotal = new Vector();
        Vector<Object> vecStat = null;
        for (int i = 0; i < listOfTasks.size(); ++i) {
            TaskStatistics oTaskStatistics = new TaskStatistics((ITask)listOfTasks.get(i));
            int iTaskRunningDevices = oTaskStatistics.getRunningDevices();
            int iTaskTotalDevices = oTaskStatistics.getTotalDevices();
            int iTaskNotRunningDevice = oTaskStatistics.getNotRunningDevices();
            int iTaskSuccessfulDevices = oTaskStatistics.getSuccessfulDevices();
            int iTaskFailureDevices = oTaskStatistics.getFailureDevices();
            vecStat = new Vector<Object>();
            iTotalrunningDevicesCal = (double)iTaskRunningDevices / (double)iTaskTotalDevices * 100.0;
            iTotalrunningDevicesRes = (double)((int)(0.5 + iTotalrunningDevicesCal * 100.0)) / 100.0;
            iTotalnotrunningDevicesCal = (double)iTaskNotRunningDevice / (double)iTaskTotalDevices * 100.0;
            iTotalnotrunningDevicesRes = (double)((int)(0.5 + iTotalnotrunningDevicesCal * 100.0)) / 100.0;
            iTotalSuccessfulDevicesCal = (double)iTaskSuccessfulDevices / (double)iTaskTotalDevices * 100.0;
            iTotalSuccessfulDevicesRes = (double)((int)(0.5 + iTotalSuccessfulDevicesCal * 100.0)) / 100.0;
            iTotalfailureDevicesCal = (double)iTaskFailureDevices / (double)iTaskTotalDevices * 100.0;
            iTotalfailureDevicesRes = (double)((int)(0.5 + iTotalfailureDevicesCal * 100.0)) / 100.0;
            vecStat.addElement(oTaskStatistics.getTaskName());
            vecStat.addElement(iTaskTotalDevices);
            vecStat.addElement(Integer.valueOf(iTaskRunningDevices) + "(" + iTotalrunningDevicesRes + "%)");
            vecStat.addElement(Integer.valueOf(iTaskNotRunningDevice) + "(" + iTotalnotrunningDevicesRes + "%)");
            vecStat.addElement(Integer.valueOf(iTaskSuccessfulDevices) + "(" + iTotalSuccessfulDevicesRes + "%)");
            vecStat.addElement(Integer.valueOf(iTaskFailureDevices) + "(" + iTotalfailureDevicesRes + "%)");
            iTotalDevices += iTaskTotalDevices;
            iTotalrunningDevices += iTaskRunningDevices;
            iTotalnotrunningDevices += iTaskNotRunningDevice;
            iTotalSuccessfulDevices += iTaskSuccessfulDevices;
            iTotalfailureDevices += iTaskFailureDevices;
            this.m_oTaskstatisticsModel.addRow(vecStat);
            vecStat = null;
        }
        double downTableRunningDecicesCal = (double)iTotalrunningDevices / (double)iTotalDevices * 100.0;
        double downTableRunningDecicesRes = (double)((int)(0.5 + downTableRunningDecicesCal * 100.0)) / 100.0;
        double downTableNotRunningDecicesCal = (double)iTotalnotrunningDevices / (double)iTotalDevices * 100.0;
        double downTableNotRunningDecicesRes = (double)((int)(0.5 + downTableNotRunningDecicesCal * 100.0)) / 100.0;
        double downTableSucessfulDevicesCal = (double)iTotalSuccessfulDevices / (double)iTotalDevices * 100.0;
        double downTableSucessfulDevicesRes = (double)((int)(0.5 + downTableSucessfulDevicesCal * 100.0)) / 100.0;
        double downTableFailureDevicesCal = (double)iTotalfailureDevices / (double)iTotalDevices * 100.0;
        double downTableFailureDevicesRes = (double)((int)(0.5 + downTableFailureDevicesCal * 100.0)) / 100.0;
        this.m_oVecTotal.addElement(ResourceManager.getInstance().getResString("TASK_STATISTICS_TOTAL"));
        this.m_oVecTotal.addElement(iTotalDevices);
        this.m_oVecTotal.insertElementAt(Integer.valueOf(iTotalrunningDevices) + "(" + downTableRunningDecicesRes + "%)", 2);
        this.m_oVecTotal.insertElementAt(Integer.valueOf(iTotalnotrunningDevices) + "(" + downTableNotRunningDecicesRes + "%)", 3);
        this.m_oVecTotal.insertElementAt(Integer.valueOf(iTotalSuccessfulDevices) + "(" + downTableSucessfulDevicesRes + "%)", 4);
        this.m_oVecTotal.insertElementAt(Integer.valueOf(iTotalfailureDevices) + "(" + downTableFailureDevicesRes + "%)", 5);
        this.m_oTotalTaskstatisticsModel = new DefaultTableModel(this.m_oVecTotal, 0);
        this.m_totalStatisticsTable.setModel(this.m_oTotalTaskstatisticsModel);
    }

    private void jbInit() {
        this.oMainPanel = new JPanel();
        this.oMainPanel.setName("TaskMgmt_TaskStatisticsDlg_oMainPanel");
        this.oMainPanel.setLayout(null);
        JPanel oToolBarPanel = new JPanel();
        JPanel tablePanel = new JPanel();
        tablePanel.setName("TaskMgmt_TaskStatisticsDlg_tablePanel");
        tablePanel.setBounds(new Rectangle(12, 50, 695, 273));
        tablePanel.setLayout(null);
        oToolBarPanel.setBounds(new Rectangle(12, 12, 200, 30));
        oToolBarPanel.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        ImageIcon saveIcon = ResourceManager.getInstance().getImage("save.gif");
        ImageIcon previewIcon = ResourceManager.getInstance().getImage("preview.gif");
        ImageIcon printIcon = ResourceManager.getInstance().getImage("print.gif");
        this.m_saveButton = new WindowStyleButton();
        this.m_saveButton.setName("TaskMgmt_TaskStatisticsDlg_m_saveButton");
        this.m_previewButton = new WindowStyleButton();
        this.m_previewButton.setName("TaskMgmt_TaskStatisticsDlg_m_previewButton");
        this.m_printButton = new WindowStyleButton();
        this.m_printButton.setName("TaskMgmt_TaskStatisticsDlg_m_printButton");
        this.m_saveButton.setPreferredSize(new Dimension(25, 25));
        this.m_saveButton.setMaximumSize(new Dimension(25, 25));
        this.m_saveButton.setMinimumSize(new Dimension(25, 25));
        this.m_saveButton.setIcon(saveIcon);
        this.m_previewButton.setIcon(previewIcon);
        this.m_printButton.setIcon(printIcon);
        ButtonGroup viewButtonGrp = new ButtonGroup();
        viewButtonGrp.add(this.m_saveButton);
        viewButtonGrp.add(this.m_previewButton);
        viewButtonGrp.add(this.m_printButton);
        this.m_saveButton.setToolTipText(ResourceManager.getInstance().getResString("SAVE"));
        this.m_previewButton.setToolTipText(ResourceManager.getInstance().getResString("PRINT_PREVIEW"));
        this.m_printButton.setToolTipText(ResourceManager.getInstance().getResString("LEGEND_PRINT"));
        this.m_previewButton.setPreferredSize(new Dimension(25, 25));
        this.m_previewButton.setMaximumSize(new Dimension(25, 25));
        this.m_previewButton.setMinimumSize(new Dimension(25, 25));
        this.m_printButton.setPreferredSize(new Dimension(25, 25));
        this.m_printButton.setMaximumSize(new Dimension(25, 25));
        this.m_printButton.setMinimumSize(new Dimension(25, 25));
        this.m_saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskStatisticsDlg.this.saveButtonActionPerformed();
            }
        });
        this.m_previewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskStatisticsDlg.this.previewButtonActionPerformed();
            }
        });
        this.m_printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskStatisticsDlg.this.printRecords();
            }
        });
        this.m_saveButton.setBorder(null);
        this.m_previewButton.setBorder(null);
        this.m_printButton.setBorder(null);
        toolBar.add(this.m_saveButton);
        toolBar.add(this.m_previewButton);
        toolBar.add(this.m_printButton);
        this.m_oCancelBtn.setBounds(new Rectangle(626, 335, 80, 21));
        this.m_oCancelBtn.setName("TaskMgmt_TaskStatisticsDlg_m_oCancelBtn");
        this.m_oCancelBtn.setText(ResourceManager.getInstance().getResString("TASK_STATISTICS_CLOSE_BUTTON"));
        oToolBarPanel.add((Component)toolBar, "First");
        JScrollPane tableScrPan = new JScrollPane();
        JScrollPane totStatScrPan = new JScrollPane();
        tableScrPan.setBounds(new Rectangle(0, 0, 696, 250));
        totStatScrPan.setBounds(new Rectangle(0, 252, 696, 20));
        this.m_oTaskstatisticsModel = new DCSortableTableModel((Object[])this.m_oTaskStatisticsTableColumns, 0);
        this.m_statisticsTable = new DCExtendedTable((SortableTableModel)this.m_oTaskstatisticsModel);
        this.m_totalStatisticsTable = new JTable();
        this.m_totalStatisticsTable.setBounds(8, 260, 627, 20);
        this.m_statisticsTable.getTableHeader().setReorderingAllowed(false);
        this.m_statisticsTable.setRowHeight(21);
        this.m_statisticsTable.getTableHeader().setPreferredSize(new Dimension(this.m_statisticsTable.getSize().width, 21));
        this.m_totalStatisticsTable.getTableHeader().setReorderingAllowed(false);
        this.m_statisticsTable.getTableHeader().addMouseMotionListener(new TopTableHeaderListener());
        this.m_totalStatisticsTable.getTableHeader().addMouseMotionListener(new DownTableHeaderListener());
        this.m_statisticsTable.setSortableClickCount(1);
        for (int i = 0; i < this.m_oTaskStatisticsTableColumns.length; ++i) {
            this.m_statisticsTable.setColumnSortable(i, true);
        }
        TableColumnModel tcm = this.m_statisticsTable.getColumnModel();
        DataAllignmentInRight renderer = new DataAllignmentInRight();
        tcm.getColumn(0).setCellRenderer(new DefaultTableCellRenderer());
        tcm.getColumn(1).setCellRenderer(renderer);
        tcm.getColumn(2).setCellRenderer(renderer);
        tcm.getColumn(3).setCellRenderer(renderer);
        tcm.getColumn(4).setCellRenderer(renderer);
        tcm.getColumn(5).setCellRenderer(renderer);
        tablePanel.add(tableScrPan);
        tableScrPan.getViewport().add((Component)this.m_statisticsTable, null);
        this.oMainPanel.add((Component)oToolBarPanel, null);
        tablePanel.add(totStatScrPan);
        totStatScrPan.getViewport().add((Component)this.m_totalStatisticsTable, null);
        this.oMainPanel.add((Component)tablePanel, null);
        this.oMainPanel.add((Component)this.m_oCancelBtn, null);
        this.getContentPane().add(this.oMainPanel);
    }

    private void saveButtonActionPerformed() {
        this.m_saveButton.getModel().setPressed(true);
        this.m_saveButton.getModel().setRollover(true);
        this.m_previewButton.getModel().setPressed(false);
        this.m_printButton.getModel().setPressed(false);
        this.m_previewButton.setBorder(null);
        this.m_printButton.setBorder(null);
        this.m_saveButton.setBorder(null);
        this.m_previewButton.repaint();
        this.m_printButton.repaint();
        this.m_saveButton.repaint();
        String strPath = ConfigurationInfo.getInstance().getAbsoluteBaseDirectory() + File.separator + "report/";
        File fileDoc = new File(strPath);
        if (!fileDoc.exists()) {
            try {
                fileDoc.mkdir();
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
                return;
            }
        }
        DCSaveFileChooser oFileChooserDlg = new DCSaveFileChooser(strPath, false);
        oFileChooserDlg.setFileFilter(7);
        oFileChooserDlg.setAcceptAllFileFilterUsed(false);
        oFileChooserDlg.setEncodingEnabled(true);
        int iReturnVal = -1;
        iReturnVal = oFileChooserDlg.showSaveDialog(DCFrameWorkUtil.getMainFrame());
        if (iReturnVal == 0) {
            String strFileName = oFileChooserDlg.getFullFileName();
            if (strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".html") || strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".htm") || strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".txt") || strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".csv")) {
                this.saveRecords(strFileName, oFileChooserDlg.getUserEncoding());
            } else {
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("TASK_STATISTICS_TABLE_FILE_TYPE_NOT_SUPP"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
            }
        }
    }

    private void saveRecords(final String strFileName, final String strEncoding) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String strUserName;
                DCTablePrintable printable = null;
                String strHeader = ResourceManager.getInstance().getResString("TASK_STATISTICS_DLG_TITLE");
                Vector tableData = new Vector();
                String fileHeader = null;
                fileHeader = strUserName = DCFrameWorkUtil.getUserName();
                int iRowCount = TaskStatisticsDlg.this.m_statisticsTable.getRowCount();
                int iColumnCount = TaskStatisticsDlg.this.m_oTaskStatisticsTableColumns.length;
                tableData = TaskStatisticsDlg.this.tableDataVec(iRowCount, iColumnCount);
                try {
                    printable = new DCTablePrintable(strHeader, fileHeader, " ", TaskStatisticsDlg.this.m_oTaskStatisticsTableColumns, tableData, tableData.size(), true);
                }
                catch (Exception ex) {
                    DCDebugTracer.trace(ex);
                    return;
                }
                String strFileType = null;
                strFileType = strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".html") || strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".htm") || strFileName.endsWith(".HTML") || strFileName.endsWith(".HTM") ? "html" : (strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".csv") ? "csv" : "txt");
                boolean bSaveSuccess = false;
                try {
                    bSaveSuccess = DCPrintSupportor.saveToFileNoCheck((JFrame)DCFrameWorkUtil.getMainFrame(), (String)strFileName, (TablePrintable)printable, (String)strFileType, (String)strEncoding);
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                }
                if (bSaveSuccess) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_SUCCESS"), ResourceManager.getInstance().getResString("INFO"), 1);
                } else {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_FAILURE"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
                }
            }
        });
    }

    private void printRecords() {
        this.m_printButton.getModel().setPressed(true);
        this.m_printButton.getModel().setRollover(true);
        this.m_saveButton.getModel().setPressed(false);
        this.m_previewButton.getModel().setPressed(false);
        this.m_saveButton.setBorder(null);
        this.m_previewButton.setBorder(null);
        this.m_printButton.setBorder(null);
        this.m_saveButton.repaint();
        this.m_previewButton.repaint();
        this.m_printButton.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String strUserName;
                DCTablePrintable printable = null;
                String strHeader = ResourceManager.getInstance().getResString("TASK_STATISTICS_DLG_TITLE");
                Vector tableData = new Vector();
                String fileHeader = null;
                fileHeader = strUserName = DCFrameWorkUtil.getUserName();
                int iRowCount = TaskStatisticsDlg.this.m_statisticsTable.getRowCount();
                int iColumnCount = TaskStatisticsDlg.this.m_oTaskStatisticsTableColumns.length;
                int iPrintableRowCount = iRowCount + 1;
                try {
                    tableData = TaskStatisticsDlg.this.tableDataVec(iRowCount, iColumnCount);
                    printable = new DCTablePrintable(strHeader, fileHeader, " ", TaskStatisticsDlg.this.m_oTaskStatisticsTableColumns, tableData, iPrintableRowCount, false);
                }
                catch (Exception ex) {
                    DCDebugTracer.trace(ex);
                    return;
                }
                try {
                    DCPrintSupportor.print((JFrame)DCFrameWorkUtil.getMainFrame(), (TablePrintable)printable, (int)printable.getPageCount());
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                }
            }
        });
    }

    private void previewButtonActionPerformed() {
        this.m_previewButton.getModel().setPressed(true);
        this.m_previewButton.getModel().setRollover(true);
        this.m_saveButton.getModel().setPressed(false);
        this.m_saveButton.setBorder(null);
        this.m_saveButton.setBorder(null);
        this.m_saveButton.repaint();
        this.m_printButton.getModel().setPressed(false);
        this.m_printButton.setBorder(null);
        this.m_printButton.repaint();
        this.m_previewButton.setBorder(null);
        this.m_previewButton.repaint();
        this.getPreviewPanel();
    }

    protected void helpDisplay() {
        DCHelpManager.getInstance().enableF1HelpKey(DCFrameWorkUtil.getMainFrame(), "HELP_TOPIC_TASK_STATISTICS");
    }

    private void getPreviewPanel() {
        String strUserName;
        String strHeader = ResourceManager.getInstance().getResString("TASK_STATISTICS_DLG_TITLE");
        String fileHeader = null;
        fileHeader = strUserName = DCFrameWorkUtil.getUserName();
        DCTablePrintable printable = null;
        Vector tableData = new Vector();
        int iRowCount = this.m_statisticsTable.getRowCount();
        int iColumnCount = this.m_oTaskStatisticsTableColumns.length;
        int iPrintableRowCount = iRowCount + 1;
        tableData = this.tableDataVec(iRowCount, iColumnCount);
        try {
            printable = new DCTablePrintable(strHeader, fileHeader, " ", this.m_oTaskStatisticsTableColumns, tableData, iPrintableRowCount, false);
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        if (null != printable) {
            DCPrintSupportor.preview((JFrame)DCFrameWorkUtil.getMainFrame(), (TablePrintable)printable, (int)printable.getPageCount());
        }
    }

    private Vector tableDataVec(int iRowCount, int iColumnCount) {
        int i;
        Vector tableData = new Vector();
        Vector<String> lastTableData = new Vector<String>();
        for (i = 0; i < iRowCount; ++i) {
            Vector<String> rowData = new Vector<String>();
            for (int j = 0; j < iColumnCount; ++j) {
                if (null != this.m_statisticsTable.getValueAt(i, j) && !this.m_statisticsTable.getValueAt(i, j).equals("")) {
                    rowData.add(this.m_statisticsTable.getValueAt(i, j).toString());
                    continue;
                }
                rowData.add(" ");
            }
            tableData.add(rowData);
        }
        for (i = 0; i < iColumnCount; ++i) {
            lastTableData.add(this.m_oVecTotal.elementAt(i).toString());
        }
        tableData.add(lastTableData);
        return tableData;
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_TASK_STATISTICS";
    }

    class DataAllignmentInRight
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1689660545635097659L;

        DataAllignmentInRight() {
        }

        @Override
        protected void setValue(Object value) {
            super.setValue(value);
            this.setHorizontalAlignment(4);
        }
    }

    class DownTableHeaderListener
    implements MouseMotionListener {
        DownTableHeaderListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            for (int i = 0; i < TaskStatisticsDlg.this.m_statisticsTable.getColumnCount(); ++i) {
                int itotStatiticsTablelength = TaskStatisticsDlg.this.m_totalStatisticsTable.getColumnModel().getColumn(i).getWidth();
                if (e.getX() >= 685) continue;
                TaskStatisticsDlg.this.m_statisticsTable.getColumnModel().getColumn(i).setPreferredWidth(itotStatiticsTablelength);
            }
            TaskStatisticsDlg.this.m_statisticsTable.updateUI();
            TaskStatisticsDlg.this.m_totalStatisticsTable.updateUI();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    class TopTableHeaderListener
    implements MouseMotionListener {
        TopTableHeaderListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            for (int i = 0; i < TaskStatisticsDlg.this.m_statisticsTable.getColumnCount(); ++i) {
                int istatiticsTablelength = TaskStatisticsDlg.this.m_statisticsTable.getColumnModel().getColumn(i).getWidth();
                if (e.getX() >= 685) continue;
                TaskStatisticsDlg.this.m_totalStatisticsTable.getColumnModel().getColumn(i).setPreferredWidth(istatiticsTablelength);
            }
            TaskStatisticsDlg.this.m_statisticsTable.updateUI();
            TaskStatisticsDlg.this.m_totalStatisticsTable.updateUI();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int colNum = TaskStatisticsDlg.this.m_statisticsTable.getColumnModel().getColumnIndexAtX(e.getX());
            if (colNum > -1) {
                TaskStatisticsDlg.this.m_statisticsTable.getTableHeader().setToolTipText(TaskStatisticsDlg.this.m_statisticsTable.getColumnName(colNum));
            }
        }
    }
}

