/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import gnu.trove.THashSet;
import java.util.Iterator;

public class TaskStatistics {
    private String m_strTaskName = null;
    private int m_iTotalDevices = 0;
    private int m_iRunningDevices = 0;
    private int m_iNotRunningDevices = 0;
    private int m_iSuccessfulDevices = 0;
    private int m_iFailureDevices = 0;

    public TaskStatistics(ITask oTaskObject) {
        ITask oTask = oTaskObject;
        this.m_strTaskName = oTaskObject.getTaskName();
        DeviceType oDeviceType = oTask.getSelectedDeviceType();
        THashSet<Resource> oResourcesList = oDeviceType.getResources();
        this.updateResourceState(oResourcesList);
    }

    private void updateResourceState(THashSet<Resource> oResourcesList) {
        int iSize;
        this.m_iTotalDevices = iSize = oResourcesList.size();
        Iterator oResItor = oResourcesList.iterator();
        Resource oResouce = null;
        while (oResItor.hasNext()) {
            oResouce = (Resource)oResItor.next();
            ResourceProgressInfo oProgressInfo = oResouce.getProgressInfo();
            if (oProgressInfo.getState() == 0) {
                ++this.m_iNotRunningDevices;
                continue;
            }
            if (oProgressInfo.getState() == 1 || oProgressInfo.getState() == 4) {
                ++this.m_iRunningDevices;
                continue;
            }
            if (oProgressInfo.getResult() == 0) {
                ++this.m_iSuccessfulDevices;
                continue;
            }
            if (oProgressInfo.getResult() != 1) continue;
            ++this.m_iFailureDevices;
        }
    }

    public int getTotalDevices() {
        return this.m_iTotalDevices;
    }

    public int getRunningDevices() {
        return this.m_iRunningDevices;
    }

    public int getNotRunningDevices() {
        return this.m_iNotRunningDevices;
    }

    public int getSuccessfulDevices() {
        return this.m_iSuccessfulDevices;
    }

    public int getFailureDevices() {
        return this.m_iFailureDevices;
    }

    public String getTaskName() {
        return this.m_strTaskName;
    }
}

