/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.components.deviceselection.table.DCDefaultTableRenderer;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.table.renderer.TooltipHeader;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCHelpForErrCodeUtil;
import com.huawei.dc.common.util.ErrorInfo;
import com.huawei.dc.taskmgmt.view.createtask.ViewCommandResultDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class TaskOperationResultDialog
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private JTextArea m_oMsgTextArea;
    private JTable m_oResultTable = null;
    private DefaultTableModel m_oDetailsTableModel = null;
    private JScrollPane m_oScrollPane = null;
    private boolean m_bDetailsShown = true;
    private JButton m_oDetailsBtn = null;
    private JButton m_oCloseBtn = null;
    private JButton m_oYesBtn = null;
    private JButton m_oNoBtn = null;
    private int m_iTypeSign = 0;
    public static final int YES_AND_NO_BUTTON = 1;
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    private static int YES_OR_NO = 1;
    private static final int TABLE_COLUMN_SIZE = 2;
    private int iDlgType = 0;
    private boolean m_bDisplayDetails;
    private String[] m_strColumnNames = null;
    private int m_iRow = 0;
    public static final int INFORM = 0;
    public static final int ERROR = 1;
    public static final int CONFIRM = 2;
    private static final Dimension BTN_SIZE = new Dimension(90, 20);

    public TaskOperationResultDialog(String strDlgTitle, int iType, boolean bDisplayTable) {
        this.iDlgType = iType;
        this.m_bDisplayDetails = bDisplayTable;
        this.initializeDialog();
        this.jbinit();
        this.setTitle(strDlgTitle);
    }

    public TaskOperationResultDialog(String strDlgTitle, int iType, boolean bDisplayTable, String[] strColumns) {
        this.m_strColumnNames = (String[])strColumns.clone();
        this.iDlgType = iType;
        this.m_bDisplayDetails = bDisplayTable;
        this.initializeDialog();
        this.jbinit();
        this.setTitle(strDlgTitle);
    }

    public TaskOperationResultDialog(String strDlgTitle, int iType, boolean bDisplayTable, String[] strColumns, int iTypeSign) {
        this.m_strColumnNames = (String[])strColumns.clone();
        this.iDlgType = iType;
        this.m_bDisplayDetails = bDisplayTable;
        this.m_iTypeSign = iTypeSign;
        this.initializeDialog();
        this.jbinit();
        this.setTitle(strDlgTitle);
    }

    private void jbinit() {
        this.initMessagePanel();
        if (this.m_bDisplayDetails) {
            this.initializeTable(this.getTableHeader());
            this.initializeScrollPane();
        }
    }

    private void initMessagePanel() {
        JPanel oMsgPanel = new JPanel();
        oMsgPanel.setLayout(new BorderLayout(15, 5));
        ImageIcon oIcon = null;
        oIcon = this.iDlgType == 1 ? ResourceManager.getInstance().getImage("errorIcon.gif") : (this.iDlgType == 0 ? ResourceManager.getInstance().getImage("informationIcon.gif") : ResourceManager.getInstance().getImage("confirmImage.gif"));
        JPanel oIconPanel = new JPanel();
        oIconPanel.setLayout(new BorderLayout());
        JLabel oIconLabel = new JLabel(oIcon);
        oIconLabel.setOpaque(true);
        oIconLabel.setRequestFocusEnabled(false);
        oIconPanel.add((Component)oIconLabel, "North");
        this.m_oMsgTextArea = new JTextArea();
        this.m_oMsgTextArea.setName("TaskMgmt_TaskOperationResultDialog_m_oMsgTextArea");
        this.m_oMsgTextArea.setWrapStyleWord(true);
        this.m_oMsgTextArea.setLineWrap(true);
        this.m_oMsgTextArea.setEditable(false);
        this.m_oMsgTextArea.setRequestFocusEnabled(false);
        this.m_oMsgTextArea.setBorder(BorderFactory.createEmptyBorder());
        this.m_oMsgTextArea.setBackground(UIManager.getColor("Label.background"));
        oMsgPanel.add((Component)oIconPanel, "West");
        oMsgPanel.add((Component)this.m_oMsgTextArea, "Center");
        JPanel oBtnPanel = new JPanel();
        oBtnPanel.setLayout(new FlowLayout(1, 10, 5));
        if (this.m_bDisplayDetails) {
            this.initializeDetailBtn();
            oBtnPanel.add(this.m_oDetailsBtn);
        }
        if (this.m_iTypeSign == 1) {
            this.initializeYesBtn();
            this.initializeNoBtn();
            oBtnPanel.add(this.m_oYesBtn);
            oBtnPanel.add(this.m_oNoBtn);
        } else {
            this.initializeCloseBtn();
            oBtnPanel.add(this.m_oCloseBtn);
        }
        JPanel oPanel = new JPanel();
        oPanel.setLayout(new BorderLayout(5, 5));
        oPanel.add((Component)oMsgPanel, "Center");
        oPanel.add((Component)oBtnPanel, "South");
        this.getContentPane().add((Component)oPanel, "North");
    }

    private void initializeDialog() {
        this.setSize(500, 300);
        JPanel m_mainPanel = new JPanel();
        m_mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        m_mainPanel.setLayout(new BorderLayout(5, 5));
        this.setContentPane(m_mainPanel);
    }

    private void initializeScrollPane() {
        this.m_oScrollPane = new JScrollPane(this.m_oResultTable);
        this.m_oScrollPane.setName("TaskMgmt_TaskOperationResultDialog_m_oScrollPane");
        Border border1 = BorderFactory.createEtchedBorder();
        this.m_oScrollPane.setBorder(border1);
        this.m_oScrollPane.setVisible(true);
        this.getContentPane().add((Component)this.m_oScrollPane, "Center");
    }

    private void initializeTable(String[] strColumnNames) {
        this.m_oResultTable = new JTable(this.m_oDetailsTableModel);
        this.m_oResultTable.setName("TaskMgmt_TaskOperationResultDialog_m_oResultTable");
        this.m_oResultTable.getTableHeader().setReorderingAllowed(false);
        this.m_oResultTable.getTableHeader().setPreferredSize(new Dimension(this.m_oResultTable.getSize().width, 21));
        this.m_oResultTable.setRowHeight(21);
        TooltipHeader tableHeader = new TooltipHeader(this.m_oResultTable.getColumnModel(), strColumnNames);
        this.m_oResultTable.setTableHeader(tableHeader);
        this.m_oResultTable.addMouseMotionListener(this.generateMouseListenerAdapter());
        tableHeader.setReorderingAllowed(false);
        this.initializeTableCellRenderer();
    }

    private String[] getTableHeader() {
        Object[] arrColumnName = null;
        if (null == this.m_strColumnNames) {
            String[] strColumnNames = new String[]{ResourceManager.getInstance().getResString("TASK_RESULT_RESOURCE_NAME"), ResourceManager.getInstance().getResString("TASK_RESULT_FAILURE_REASON")};
            arrColumnName = strColumnNames;
        } else {
            arrColumnName = this.m_strColumnNames;
        }
        this.m_oDetailsTableModel = new DefaultTableModel(arrColumnName, 0){
            private static final long serialVersionUID = -3627816039673298816L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        return arrColumnName;
    }

    private void initializeCloseBtn() {
        this.m_oCloseBtn = new JButton(ResourceManager.getInstance().getResString("CLOSE_BUTTON"));
        this.m_oCloseBtn.setName("TaskMgmt_TaskOperationResultDialog_m_oCloseBtn");
        this.m_oCloseBtn.setEnabled(true);
        this.m_oCloseBtn.setPreferredSize(BTN_SIZE);
        this.registerCloseBtnListener();
    }

    private void initializeYesBtn() {
        this.m_oYesBtn = new JButton(ResourceManager.getInstance().getResString("YES"));
        this.m_oYesBtn.setName("TaskMgmt_TaskOperationResultDialog_m_oYesBtn");
        this.m_oYesBtn.setEnabled(true);
        this.m_oYesBtn.setPreferredSize(BTN_SIZE);
        this.registerYesBtnListener();
    }

    private void initializeNoBtn() {
        this.m_oNoBtn = new JButton(ResourceManager.getInstance().getResString("NO"));
        this.m_oNoBtn.setName("TaskMgmt_TaskOperationResultDialog_m_oNoBtn");
        this.m_oNoBtn.setEnabled(true);
        this.m_oNoBtn.setPreferredSize(BTN_SIZE);
        this.registerNoBtnListener();
    }

    private void initializeDetailBtn() {
        this.m_oDetailsBtn = new JButton(this.getDetailButtonText());
        this.m_oDetailsBtn.setName("TaskMgmt_TaskOperationResultDialog_m_oDetailsBtn");
        this.m_oDetailsBtn.setMnemonic('D');
        this.m_oDetailsBtn.setPreferredSize(BTN_SIZE);
        this.registerDetailBtnListener();
    }

    private String getDetailButtonText() {
        ResourceManager oResMgr = ResourceManager.getInstance();
        if (this.m_bDetailsShown) {
            return oResMgr.getResString("OPERATE_DETAIL") + "<<";
        }
        return oResMgr.getResString("OPERATE_DETAIL") + ">>";
    }

    private void initializeTableCellRenderer() {
        TableColumnModel oColumnModel = this.m_oResultTable.getColumnModel();
        int iColumnCount = oColumnModel.getColumnCount();
        DCDefaultTableRenderer oRenderer = new DCDefaultTableRenderer(true);
        for (int i = 0; i < iColumnCount; ++i) {
            oColumnModel.getColumn(i).setCellRenderer(oRenderer);
        }
    }

    private void registerCloseBtnListener() {
        this.m_oCloseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskOperationResultDialog.this.closeDialog();
                ToolTipManager.sharedInstance().setEnabled(true);
            }
        });
    }

    private void registerYesBtnListener() {
        this.m_oYesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                YES_OR_NO = 0;
                TaskOperationResultDialog.this.closeDialog();
                ToolTipManager.sharedInstance().setEnabled(true);
            }
        });
    }

    private void registerNoBtnListener() {
        this.m_oNoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                YES_OR_NO = 1;
                TaskOperationResultDialog.this.closeDialog();
                ToolTipManager.sharedInstance().setEnabled(true);
            }
        });
    }

    private void registerDetailBtnListener() {
        this.m_oDetailsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolTipManager.sharedInstance().setEnabled(true);
                TaskOperationResultDialog.this.detailBtn_actionPerformed();
            }
        });
    }

    private void detailBtn_actionPerformed() {
        if (!this.m_bDetailsShown) {
            this.m_bDetailsShown = true;
            this.setSize(500, 300);
            this.m_oScrollPane.setVisible(true);
            this.m_oDetailsBtn.setText(this.getDetailButtonText());
        } else {
            this.m_bDetailsShown = false;
            this.setSize(500, this.m_oScrollPane.getY() + 30);
            this.m_oScrollPane.setVisible(false);
            this.m_oDetailsBtn.setText(this.getDetailButtonText());
        }
        this.validate();
        this.repaint();
    }

    public void setMessage(String strMessage) {
        this.m_oMsgTextArea.setText(strMessage);
    }

    public void addRowInModel(String strDisplayName, String strOpResult) {
        if (this.m_bDisplayDetails) {
            Vector<String> oRowVector = new Vector<String>(2);
            oRowVector.add(strDisplayName);
            oRowVector.add(strOpResult);
            this.m_oDetailsTableModel.addRow(oRowVector);
        }
    }

    public void addRowInModel(Vector<Object> oRowData) {
        if (this.m_bDisplayDetails) {
            this.m_oDetailsTableModel.addRow(oRowData);
        }
    }

    public void addRowsInModel(Vector<Object> oRowsData) {
        if (this.m_bDisplayDetails) {
            for (int i = 0; i < oRowsData.size(); ++i) {
                Vector rowData = (Vector)oRowsData.get(i);
                this.m_oDetailsTableModel.addRow(rowData);
            }
        }
    }

    public void addRowInModel(int iInsertionPos, Vector<String> oRowData) {
        if (this.m_bDisplayDetails) {
            this.m_oDetailsTableModel.insertRow(iInsertionPos, oRowData);
            this.m_iRow = iInsertionPos;
        }
    }

    public void setTableRenderer() {
        int iColCount = this.m_oResultTable.getColumnCount();
        for (int i = 0; i < iColCount; ++i) {
            this.m_oResultTable.getColumnModel().getColumn(i).setCellRenderer(new MyCellRenderer());
        }
    }

    @Override
    protected String getCurrentContext() {
        return ResourceManager.getInstance().getResString("", "helpmapfile");
    }

    public int getRowCount() {
        return this.m_oDetailsTableModel.getRowCount();
    }

    public JTable getTable() {
        return this.m_oResultTable;
    }

    public void cutomizeForHAFailureResult() {
        this.m_oDetailsBtn.setVisible(false);
        this.setSize(500, 400);
        this.m_oMsgTextArea.setBounds(8, 10, 320, 20);
        this.m_oScrollPane.setBounds(8, 35, 480, 245);
        this.m_oCloseBtn.setBounds(398, 290, 90, 20);
        this.m_oMsgTextArea.setFont(this.m_oCloseBtn.getFont());
        this.m_oResultTable.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.m_oResultTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.m_oResultTable.getColumnModel().getColumn(2).setPreferredWidth(120);
    }

    public void cutomizeForUFCResult() {
        this.m_oDetailsBtn.setVisible(false);
        this.setSize(550, 400);
        this.m_oScrollPane.setBounds(8, 60, 530, 270);
        this.m_oCloseBtn.setBounds(448, 340, 90, 20);
        this.m_oMsgTextArea.setFont(this.m_oCloseBtn.getFont());
        this.m_oMsgTextArea.setBounds(65, 20, 470, 20);
    }

    private void setToolTipForTable(MouseEvent oEvent) {
        Point oPoint = oEvent.getPoint();
        int iHitColumnIndex = this.m_oResultTable.columnAtPoint(oPoint);
        int iHitRowIndex = this.m_oResultTable.rowAtPoint(oPoint);
        Object oToolTipValue = this.m_oResultTable.getValueAt(iHitRowIndex, iHitColumnIndex);
        this.m_oResultTable.setToolTipText(oToolTipValue.toString());
    }

    private MouseMotionAdapter generateMouseListenerAdapter() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent oEvent) {
                TaskOperationResultDialog.this.setToolTipForTable(oEvent);
            }
        };
    }

    public void showDetail() {
        this.m_bDetailsShown = true;
        this.setSize(500, 280);
        this.m_oScrollPane.setVisible(true);
        this.m_oDetailsBtn.setText(this.getDetailButtonText());
    }

    public void customizeTableForTelnetError() {
        int iColumnCount = this.m_oDetailsTableModel.getColumnCount();
        if (3 == iColumnCount) {
            this.m_oResultTable.removeColumn(this.m_oResultTable.getColumnModel().getColumn(iColumnCount - 1));
            this.m_oResultTable.getColumnModel().getColumn(1).setCellRenderer(new DetailTableRenderer());
            this.m_oResultTable.addMouseMotionListener(this.generateMouseMotionAdapter());
            this.m_oResultTable.addMouseListener(this.generateMouseAdapterForTable());
        } else if (2 == iColumnCount) {
            this.m_oResultTable.getColumnModel().getColumn(1).setCellRenderer(new DetailTableRenderer());
            this.m_oResultTable.addMouseMotionListener(this.generateMouseMotionAdapter());
            this.m_oResultTable.addMouseListener(this.generateMouseAdapterForTable());
        }
    }

    private MouseMotionAdapter generateMouseMotionAdapter() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent oMouseEvent) {
                Cursor cur;
                ErrorInfo oErrorInfo;
                Object oValue;
                Point oPoint = oMouseEvent.getPoint();
                int iColumnCount = TaskOperationResultDialog.this.m_oDetailsTableModel.getColumnCount();
                int iCol = TaskOperationResultDialog.this.m_oResultTable.columnAtPoint(oPoint);
                int iRow = TaskOperationResultDialog.this.m_oResultTable.rowAtPoint(oPoint);
                boolean bHandCursor = false;
                if (3 == iColumnCount && 1 == iCol && (oValue = TaskOperationResultDialog.this.m_oDetailsTableModel.getValueAt(iRow, 2)) instanceof ErrorInfo && DCHelpForErrCodeUtil.isShowHyperlink((oErrorInfo = (ErrorInfo)oValue).getErrorCode())) {
                    bHandCursor = true;
                }
                if (bHandCursor) {
                    cur = new Cursor(12);
                    DCFrameWorkUtil.setCursor(cur);
                } else {
                    cur = new Cursor(0);
                    DCFrameWorkUtil.setCursor(cur);
                }
            }
        };
    }

    public DefaultTableModel getDetailsTableModel() {
        return this.m_oDetailsTableModel;
    }

    private MouseAdapter generateMouseAdapterForTable() {
        return new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
            }

            @Override
            public void mouseClicked(MouseEvent oMouseEvent) {
                ErrorInfo oErrorInfo;
                Object oValue;
                Point oPoint = oMouseEvent.getPoint();
                int iColumnCount = TaskOperationResultDialog.this.m_oDetailsTableModel.getColumnCount();
                int iCol = TaskOperationResultDialog.this.m_oResultTable.columnAtPoint(oPoint);
                int iRow = TaskOperationResultDialog.this.m_oResultTable.rowAtPoint(oPoint);
                ErrorInfo oErrInfo = null;
                if (3 == iColumnCount && 1 == iCol) {
                    oValue = TaskOperationResultDialog.this.m_oDetailsTableModel.getValueAt(iRow, 2);
                    if (oValue instanceof ErrorInfo && 999293081 == (oErrorInfo = (ErrorInfo)oValue).getErrorCode()) {
                        oErrInfo = oErrorInfo;
                    }
                } else if (2 == iColumnCount && 1 == iCol && (oValue = TaskOperationResultDialog.this.m_oDetailsTableModel.getValueAt(iRow, 1)) instanceof ErrorInfo && 999293081 == (oErrorInfo = (ErrorInfo)oValue).getErrorCode()) {
                    oErrInfo = oErrorInfo;
                }
                if (null != oErrInfo) {
                    String strMessage = oErrInfo.toString();
                    ViewCommandResultDialog dialog = new ViewCommandResultDialog(strMessage);
                    dialog.setTitle(DCFrameWorkUtil.getLocalizedString("OPERATION_RESULT"));
                    dialog.getContentTextArea().setLineWrap(true);
                    dialog.setVisible(true);
                }
            }
        };
    }

    public void reashTable() {
        this.m_oResultTable.updateUI();
    }

    public int showResultDialog() {
        this.setVisible(true);
        return YES_OR_NO;
    }

    class DetailTableRenderer
    implements TableCellRenderer {
        DetailTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int iRow, int iCol) {
            ErrorInfo oErrorInfo;
            Object oValue;
            JLabel label = new JLabel();
            label.setOpaque(true);
            boolean bLink = false;
            int iColumnCount = TaskOperationResultDialog.this.m_oDetailsTableModel.getColumnCount();
            if (3 == iColumnCount && 1 == iCol) {
                ErrorInfo oErrorInfo2;
                oValue = TaskOperationResultDialog.this.m_oDetailsTableModel.getValueAt(iRow, 2);
                if (oValue instanceof ErrorInfo && 999293081 == (oErrorInfo2 = (ErrorInfo)oValue).getErrorCode()) {
                    bLink = true;
                }
            } else if (2 == iColumnCount && 1 == iCol && (oValue = TaskOperationResultDialog.this.m_oDetailsTableModel.getValueAt(iRow, 1)) instanceof ErrorInfo && 999293081 == (oErrorInfo = (ErrorInfo)oValue).getErrorCode()) {
                bLink = true;
            }
            if (isSelected) {
                label.setBackground(table.getSelectionBackground());
                label.setForeground(Color.white);
            } else {
                label.setBackground(table.getBackground());
                label.setForeground(table.getForeground());
            }
            if (null != value) {
                String strLabelText = value.toString();
                if (iColumnCount == 2 && bLink) {
                    strLabelText = ((ErrorInfo)value).getErrCodeDescription();
                }
                if (bLink) {
                    strLabelText = "<html><a href=\"x\">" + strLabelText + "</a>" + "</html>";
                }
                label.setText(strLabelText);
                label.setToolTipText(value.toString());
            }
            label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.gray));
            return label;
        }
    }

    class MyCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        MyCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jtable, Object obj, boolean flag, boolean flag1, int i, int j) {
            Component oComponent = super.getTableCellRendererComponent(jtable, obj, flag, flag1, i, j);
            if (i <= TaskOperationResultDialog.this.m_iRow) {
                this.setForeground(Color.RED);
            } else {
                this.setForeground(Color.BLACK);
            }
            return oComponent;
        }
    }
}

