/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCCheckDevicesInfoForTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnDCMultiDeviceErr;
import com.huawei.dc.common.asndatacenter.AsnDCMultiDeviceErrWithTaskRef;
import com.huawei.dc.common.asndatacenter.AsnDevSetInfo;
import com.huawei.dc.common.asndatacenter.AsnTaskRef;
import com.huawei.dc.common.asndatacenter.AsnTaskRefList;
import com.huawei.dc.common.asndatacenter.AsnToleranceSearchReq;
import com.huawei.dc.common.components.treetable.model.DCTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.TaskInfoUtil2;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperation;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskEventID;
import com.huawei.dc.taskmgmt.controller.TaskInfoNotifier;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.ITaskDataModel;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceOpResultInfo;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.Task;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.model.TaskModelUtil;
import com.huawei.dc.taskmgmt.model.TaskOpResultInfo;
import com.huawei.dc.taskmgmt.report.devlevel.controller.CheckReportProgressController;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportDataModel;
import com.huawei.dc.taskmgmt.view.TaskMgmtOperationSelecPanel;
import com.huawei.dc.taskmgmt.view.common.CreateTaskDialog;
import com.huawei.dc.taskmgmt.view.common.TaskOperationResultDialog;
import com.huawei.dc.taskmgmt.view.common.TaskTableButtonPanel;
import com.huawei.dc.taskmgmt.view.createtask.CreateTaskDeviceSelectionPanel;
import com.huawei.dc.taskmgmt.view.createtask.IDeviceVersionChangeListener;
import com.huawei.dc.taskmgmt.view.createtask.TaskConfirmationPanel;
import com.huawei.dc.taskmgmt.view.createtask.TaskDevSelecPanelWithUpgradeLevel;
import com.huawei.dc.taskmgmt.view.createtask.TaskDevSelecPanelWithUpgradeType;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTableUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Cursor;
import java.math.BigInteger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class TaskMenuItemHandlerHelper {
    protected static final int INEXIST_FAILED_BOARD = 0;
    protected static final int EXIST_LOAD_FAILED_BOARD = 1;
    protected static final int EXIST_LOAD_FAILED_MS_BOARD = 2;
    protected static final int EXIST_ACTIVATE_FAILED_BOARD = 3;
    private static final int CONTINUE_TYPE = 1;

    public static boolean isRetryConfRequiredForUFC(DCSortableTreeTable m_oTable) {
        DCDebugTracer.trace("[retry noDev]+getTaskIdResourceListMap start");
        int[] arrSelectedPaths = m_oTable.getSelectedRows();
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        boolean bIsNonT2000Device = true;
        boolean bIsUFCOperation = true;
        boolean m_bIsRetryConfirmationRequired = false;
        for (int i = 0; i < arrSelectedPaths.length; ++i) {
            Collator oEquals;
            TreePath oTreePath = m_oTable.getTree().getPathForRow(arrSelectedPaths[i]);
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            ITask oTask = TaskTableUtil.getTaskForTableNode(oNode);
            if (!(oNode.getUserObject() instanceof TreeTableRowData) || !((oRowData = (TreeTableRowData)oNode.getUserObject()).getUserObject() instanceof Resource)) continue;
            Resource oResource = (Resource)oRowData.getUserObject();
            String strCurrentOperation = oResource.getProgressInfo().getCurrentOperationId();
            if (oTask.isT2000Domain()) {
                bIsNonT2000Device = false;
            }
            if ((oEquals = Collator.getInstance()).equals("CheckFeasibility", strCurrentOperation)) continue;
            bIsUFCOperation = false;
        }
        if (bIsNonT2000Device && bIsUFCOperation) {
            m_bIsRetryConfirmationRequired = true;
        }
        return m_bIsRetryConfirmationRequired;
    }

    public static HashMap getTaskIdResourceListMap(boolean isGetBoardResource, DCSortableTreeTable m_oTable) {
        DCDebugTracer.trace("[retry noDev]+getTaskIdResourceListMap start");
        int[] arrSelectedPaths = m_oTable.getSelectedRows();
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        HashMap<Integer, THashSet> mapSelectedResources = new HashMap<Integer, THashSet>(8);
        THashSet listSelectedResources = null;
        Integer oTaskID = null;
        DCDebugTracer.trace("[retry noDev]+select Rows=" + arrSelectedPaths.length);
        for (int i = 0; i < arrSelectedPaths.length; ++i) {
            TreePath oTreePath = m_oTable.getTree().getPathForRow(arrSelectedPaths[i]);
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            ITask oTask = TaskTableUtil.getTaskForTableNode(oNode);
            oTaskID = oTask.getTaskId();
            DCDebugTracer.trace("[retry noDev]" + oTaskID);
            listSelectedResources = (THashSet)mapSelectedResources.get(oTaskID);
            if (null == listSelectedResources) {
                listSelectedResources = new THashSet(1);
                mapSelectedResources.put(oTaskID, listSelectedResources);
            }
            if (!(oNode.getUserObject() instanceof TreeTableRowData)) continue;
            DCDebugTracer.trace("[retry noDev]+oNode is TreeTableRowData");
            oRowData = (TreeTableRowData)oNode.getUserObject();
            if (!(oRowData.getUserObject() instanceof Resource)) continue;
            boolean isGetBoardInfo = isGetBoardResource;
            Resource oResource = (Resource)oRowData.getUserObject();
            String strCurrentOperation = oResource.getProgressInfo().getCurrentOperationId();
            isGetBoardInfo = TaskMenuItemHandlerHelper.isCanGetBoardInfo(oTask, strCurrentOperation, isGetBoardInfo);
            DCDebugTracer.trace("[retry noDev]+isGetBoardInfo afte tasktype check=" + isGetBoardInfo);
            if (isGetBoardInfo && oResource.getSlotId() >= 0) {
                isGetBoardInfo = false;
            }
            if (!isGetBoardInfo) {
                listSelectedResources.add((Object)oResource);
                continue;
            }
            DCDebugTracer.trace("[retry noDev]+isGetBoardInfo is true");
            int iChildCount = oNode.getChildCount();
            if (iChildCount <= 0) {
                listSelectedResources.add((Object)oResource);
                continue;
            }
            DCDebugTracer.trace("[retry noDev]+dev role tyep=" + oResource.getRoleType());
            if (3 == oResource.getRoleType()) {
                listSelectedResources.add((Object)oResource);
            }
            TaskMenuItemHandlerHelper.addChildResource(oNode, (THashSet<Resource>)listSelectedResources);
        }
        DCDebugTracer.trace("[retry noDev]+getTaskIdResourceListMap end");
        return mapSelectedResources;
    }

    public static List<Integer> getSelectDevList(DCSortableTreeTable m_oTable) {
        TreeTableNode oNode = null;
        int devID = -1;
        int[] arrSelectedRows = m_oTable.getSelectedRows();
        ArrayList<Integer> devIdLst = new ArrayList<Integer>();
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = m_oTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData)) continue;
            TreeTableRowData oRowData = (TreeTableRowData)oNode.getUserObject();
            Resource oResource = (Resource)oRowData.getUserObject();
            devID = oResource.getDeviceID();
            devIdLst.add(devID);
        }
        return devIdLst;
    }

    public static void fillFailedBoardReq(AsnToleranceSearchReq oAsnIsolationSearchReq, DCSortableTreeTable m_oTable) {
        oAsnIsolationSearchReq.iTaskId = BigInteger.ZERO;
        int[] arrSelectedRows = m_oTable.getSelectedRows();
        TreeTableNode oNode = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = m_oTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData)) continue;
            TreeTableRowData oRowData = (TreeTableRowData)oNode.getUserObject();
            Resource oResource = (Resource)oRowData.getUserObject();
            AsnDevSetInfo devInfo = new AsnDevSetInfo();
            devInfo.iDevId = new BigInteger(String.valueOf(oResource.getDeviceID()));
            oAsnIsolationSearchReq.oDevSetInfoLst.add((Object)devInfo);
        }
    }

    public static void deleteTaskFromTable(List oTaskIdList, int iFirstRowSelected, DCSortableTreeTable m_oTable) {
        int iSize = oTaskIdList.size();
        DCTreeTableModel oModel = m_oTable.getDataModel();
        TreeTableNode oRoot = oModel.getRoot();
        int iTaskId = -1;
        for (int i = 0; i < iSize; ++i) {
            iTaskId = (Integer)oTaskIdList.get(i);
            TreeTableNode oTaskNode = TaskMenuItemHandlerHelper.getTaskNode(iTaskId, oRoot);
            if (null == oTaskNode) continue;
            oRoot.remove(oTaskNode);
            DCDebugTracer.trace("delete task from table taskid=" + iTaskId);
            TaskDataModel.getInstance().removeTask(iTaskId);
        }
        m_oTable.clearSelection();
        DCFrameWorkUtil.updateUI((JComponent)((Object)m_oTable));
    }

    public static void viewCheckReportUI(int rptType, DCSortableTreeTable m_oTable) {
        int[] arrSelectedPaths = m_oTable.getSelectedRows();
        if (null == arrSelectedPaths || 0 == arrSelectedPaths.length) {
            return;
        }
        ITask oTask = null;
        THashSet resourceList = null;
        TreePath oTreePath = m_oTable.getTree().getPathForRow(arrSelectedPaths[0]);
        TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
        oTask = TaskTableUtil.getTaskForTableNode(oNode);
        if (null == oTask) {
            return;
        }
        if (TaskTableUtil.isATaskOnlySelection(m_oTable)) {
            DeviceType oDeviceType = oTask.getSelectedDeviceType();
            resourceList = oDeviceType.getResources();
        } else {
            int iRowCount = arrSelectedPaths.length;
            resourceList = new THashSet(iRowCount);
            for (int i = 0; i < iRowCount; ++i) {
                oTreePath = m_oTable.getTree().getPathForRow(arrSelectedPaths[i]);
                oNode = (TreeTableNode)oTreePath.getLastPathComponent();
                TreeTableRowData oRow = (TreeTableRowData)oNode.getUserObject();
                if (!(oRow.getUserObject() instanceof Resource)) continue;
                resourceList.add((Object)((Resource)oRow.getUserObject()));
            }
        }
        ArrayList<String> oDeviceTypes = new ArrayList<String>(resourceList.size());
        Iterator oResItor = resourceList.iterator();
        Resource oRes = null;
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            int iDevID = oRes.getDeviceID();
            String strDeviceTypes = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iDevID).getDeviceTypeInfo().getDevTypeName();
            if (oDeviceTypes.contains(strDeviceTypes)) continue;
            oDeviceTypes.add(strDeviceTypes);
        }
        try {
            CheckReportDataModel.getInstance().removeReport(rptType);
            int iNumOfReports = TaskSyncCommController.getInstance().getCheckReportDetails(oTask.getTaskId(), (THashSet<Resource>)resourceList, rptType);
            if (-1 > iNumOfReports) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("NO_CHECK_REPORTS_AVAILABLE"));
                return;
            }
            CheckReportProgressController oController = new CheckReportProgressController(oTask, rptType, resourceList.size());
            oController.initializeProgress(iNumOfReports);
            oController.setDeviceTypes(oDeviceTypes);
        }
        catch (DCException e) {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
            return;
        }
    }

    public static ITask getSelectOneTask(DCSortableTreeTable m_oTable) {
        int iRowCount;
        int[] arrSelectedPaths = m_oTable.getSelectedRows();
        if (null != arrSelectedPaths && 1 == (iRowCount = arrSelectedPaths.length)) {
            TreePath oTreePath = m_oTable.getTree().getPathForRow(arrSelectedPaths[0]);
            TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            return TaskMenuItemHandlerHelper.getTaskFromSelectedRow(oNode);
        }
        return null;
    }

    public static ITask[] getSelectTasks(DCSortableTreeTable m_oTable) {
        int[] arrSelectedPaths = m_oTable.getSelectedRows();
        if (null != arrSelectedPaths && arrSelectedPaths.length > 0) {
            int[] arrSelectedRows = m_oTable.getSelectedRows();
            if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
                return null;
            }
            int iRowCount = arrSelectedRows.length;
            ITask[] oTasks = new ITask[iRowCount];
            for (int i = 0; i < iRowCount; ++i) {
                TreePath oTreePath = m_oTable.getTree().getPathForRow(arrSelectedRows[i]);
                TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
                oTasks[i] = TaskTableUtil.getTaskForTableNode(oNode);
            }
            return oTasks;
        }
        return null;
    }

    public static ITask getSelectTask(DCSortableTreeTable m_oTable) {
        int[] arrSelectedPaths = m_oTable.getSelectedRows();
        if (null != arrSelectedPaths && arrSelectedPaths.length > 0) {
            int[] arrSelectedRows = m_oTable.getSelectedRows();
            if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
                return null;
            }
            TreePath oTreePath = m_oTable.getTree().getPathForRow(arrSelectedRows[0]);
            TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            return TaskTableUtil.getTaskForTableNode(oNode);
        }
        return null;
    }

    public static HashMap getTaskIdResourceListMapForNextOper(DCSortableTreeTable m_oTable) {
        DCDebugTracer.trace("[next operation]+getTaskIdResourceListMap start");
        int[] arrSelectedPaths = m_oTable.getSelectedRows();
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        HashMap<Integer, THashSet> mapSelectedResources = new HashMap<Integer, THashSet>(8);
        THashSet listSelectedResources = null;
        Integer oTaskID = null;
        Vector<Object> oCheckResultVec = new Vector<Object>();
        DCDebugTracer.trace("[next operation]+select Rows=" + arrSelectedPaths.length);
        block5: for (int i = 0; i < arrSelectedPaths.length; ++i) {
            TreePath oTreePath = m_oTable.getTree().getPathForRow(arrSelectedPaths[i]);
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            ITask oTask = TaskTableUtil.getTaskForTableNode(oNode);
            oTaskID = oTask.getTaskId();
            DCDebugTracer.trace("[next operation]" + oTaskID);
            listSelectedResources = (THashSet)mapSelectedResources.get(oTaskID);
            Vector<String> oCheckResult = new Vector<String>(2);
            if (null == listSelectedResources) {
                listSelectedResources = new THashSet(1);
                mapSelectedResources.put(oTaskID, listSelectedResources);
            }
            if (!(oNode.getUserObject() instanceof TreeTableRowData)) continue;
            DCDebugTracer.trace("[next operation]+oNode is TreeTableRowData");
            oRowData = (TreeTableRowData)oNode.getUserObject();
            if (!(oRowData.getUserObject() instanceof Resource)) continue;
            Resource oResource = (Resource)oRowData.getUserObject();
            int iHintType = TaskMenuItemHandlerHelper.checkForNextOperation(oNode);
            String resourceName = oResource.getDeviceName() + "[" + oTask.getTaskName() + "]";
            switch (iHintType) {
                case 1: {
                    oCheckResult.add(resourceName);
                    oCheckResult.add(ResourceManager.getInstance().getResString("EXIST_LOAD_FAILED_BOARDS_NEXT_OPERATION"));
                    oCheckResultVec.add(oCheckResult);
                    listSelectedResources.add((Object)oResource);
                    continue block5;
                }
                case 3: {
                    oCheckResult.add(resourceName);
                    oCheckResult.add(ResourceManager.getInstance().getResString("EXIST_ACTIVATE_FAILED_BOARDS_NEXT_OPERATION"));
                    oCheckResultVec.add(oCheckResult);
                    listSelectedResources.add((Object)oResource);
                    continue block5;
                }
                case 2: {
                    oCheckResult.add(resourceName);
                    oCheckResult.add(ResourceManager.getInstance().getResString("EXIST_LOAD_FAILED_MS_BOARDS_NEXT_OPERATION"));
                    oCheckResultVec.add(oCheckResult);
                    listSelectedResources.add((Object)oResource);
                    continue block5;
                }
                default: {
                    listSelectedResources.add((Object)oResource);
                }
            }
        }
        if (oCheckResultVec.size() > 0) {
            String strDlgTitle = ResourceManager.getInstance().getResString("CONFIRM_DIALOG_TITLE");
            String[] strColumnNames = new String[]{ResourceManager.getInstance().getResString("DEVICE_PROGRESS_TABLE_DEVICE_INFO"), ResourceManager.getInstance().getResString("DEVICE_PROGRESS_TABLE_OPERATION_RESULT")};
            TaskOperationResultDialog oDlg = new TaskOperationResultDialog(strDlgTitle, 2, true, strColumnNames, 1);
            oDlg.setMessage(ResourceManager.getInstance().getResString("CONFIRM_FOR_NEXT_OPERATION_FOR_T2000DEV"));
            if (TaskMenuItemHandlerHelper.getCurStepReslut(mapSelectedResources)) {
                oDlg.setMessage(ResourceManager.getInstance().getResString("CONFIRM_FOR_NEXT_OPERATION"));
            }
            oDlg.addRowsInModel(oCheckResultVec);
            int willContinue = oDlg.showResultDialog();
            if (0 != willContinue) {
                return null;
            }
        } else {
            int iConfirmOutput = DCOptionPane.showConfirmDialog(DCFrameWorkUtil.getMainFrame(), TaskMenuItemHandlerHelper.getConfirmMsg(mapSelectedResources), ResourceManager.getInstance().getResString("CONFIRM"), 0, 2);
            if (0 != iConfirmOutput) {
                return null;
            }
        }
        DCDebugTracer.trace("[next operation]+getTaskIdResourceListMap end");
        return mapSelectedResources;
    }

    public static String getConfirmMsg(HashMap listSelectedResources) {
        String confirmMsg = ResourceManager.getInstance().getResString("NE_NEXT_OPERATION_CONFIRM_MSG_FOR_T2000DEV");
        ArrayList<String> curOpeLst = new ArrayList<String>();
        String strCurrentOperation = null;
        Iterator oIterator = listSelectedResources.entrySet().iterator();
        Map.Entry oEntry = null;
        ITask task = null;
        while (oIterator.hasNext()) {
            oEntry = oIterator.next();
            Integer iTaskID = (Integer)oEntry.getKey();
            if (iTaskID == null) continue;
            task = TaskDataModel.getInstance().getTask(iTaskID);
            THashSet oResourceList = (THashSet)oEntry.getValue();
            for (Resource res : oResourceList) {
                strCurrentOperation = res.getProgressInfo().getCurrentOperationId();
                if (curOpeLst.contains(strCurrentOperation)) continue;
                curOpeLst.add(TaskCommUtil.getDisplayNameForOperation(task.getDeviceType(), strCurrentOperation));
            }
        }
        boolean bStepFail = TaskMenuItemHandlerHelper.getCurStepReslut(listSelectedResources);
        if (bStepFail) {
            confirmMsg = ResourceManager.getInstance().getResString("NE_NEXT_OPERATION_CONFIRM_MSG");
        }
        if (1 == curOpeLst.size() && TaskMenuItemHandlerHelper.isCX600LoadSoftWare(strCurrentOperation, task)) {
            confirmMsg = ResourceManager.getInstance().getResString("NE_NEXT_OPERATION_CONFIRM_LOAD_SOFTWARE_MSG");
        }
        return confirmMsg;
    }

    private static boolean getCurStepReslut(HashMap listSelectedResources) {
        boolean bStepFail = false;
        Iterator oIterator = listSelectedResources.entrySet().iterator();
        Map.Entry oEntry = null;
        while (oIterator.hasNext()) {
            oEntry = oIterator.next();
            Integer iTaskID = (Integer)oEntry.getKey();
            if (iTaskID == null) continue;
            THashSet oResourceList = (THashSet)oEntry.getValue();
            for (Resource res : oResourceList) {
                if (bStepFail || res.getProgressInfo().getErrorNo() == 989855882) continue;
                bStepFail = true;
            }
        }
        return bStepFail;
    }

    private static boolean isCX600LoadSoftWare(String step, ITask task) {
        boolean isCX600LoadSoftWare = true;
        if (null == task || 1252 != task.getDeviceType().getDeviceTypeID()) {
            isCX600LoadSoftWare = false;
        }
        if (!"LoadSoftware".equals(step)) {
            isCX600LoadSoftWare = false;
        }
        return isCX600LoadSoftWare;
    }

    public static void addChildResource(TreeTableNode oNode, THashSet<Resource> listSelectedRes) {
        int iChildCount = oNode.getChildCount();
        for (int j = 0; j < iChildCount; ++j) {
            Resource oRes;
            ResourceProgressInfo resProgressInfo;
            TreeTableRowData oTmpRowData;
            TreeTableNode tmpNode = (TreeTableNode)oNode.getChildAt(j);
            if (!(tmpNode.getUserObject() instanceof TreeTableRowData) || !((oTmpRowData = (TreeTableRowData)tmpNode.getUserObject()).getUserObject() instanceof Resource) || 1 != (resProgressInfo = (oRes = (Resource)oTmpRowData.getUserObject()).getProgressInfo()).getResult() && 0 != resProgressInfo.getState()) continue;
            listSelectedRes.add((Object)oRes);
        }
    }

    public static boolean isCanGetBoardInfo(ITask oTask, String sCurrentOperation, boolean bGetBoardInfo) {
        boolean isGetBoardInfo = bGetBoardInfo;
        boolean bMiniPkgUpgrade = 3 == oTask.getTaskTypeId();
        boolean bCurActivateSoft = "ActivateSoftware".equals(sCurrentOperation);
        Collator oEquals = Collator.getInstance();
        if (bMiniPkgUpgrade && !bCurActivateSoft && !oEquals.equals("LoadSoftware", sCurrentOperation) || !bMiniPkgUpgrade && !bCurActivateSoft) {
            isGetBoardInfo = false;
        }
        if (5 == oTask.getTaskTypeId() || 11 == oTask.getTaskTypeId() || 12 == oTask.getTaskTypeId()) {
            isGetBoardInfo = false;
        }
        return isGetBoardInfo;
    }

    public static void updateResourceListForCancel(DCSortableTreeTable m_oTable, boolean bFlag, List<TaskOpResultInfo> oExceptResultLst) {
        int[] arrSelectedPaths = m_oTable.getSelectedRows();
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        for (int i = 0; i < arrSelectedPaths.length; ++i) {
            TreePath oTreePath = m_oTable.getTree().getPathForRow(arrSelectedPaths[i]);
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            if (!(oNode.getUserObject() instanceof TreeTableRowData) || !((oRowData = (TreeTableRowData)oNode.getUserObject()).getUserObject() instanceof Resource)) continue;
            Resource oResource = (Resource)oRowData.getUserObject();
            TreeTableNode oTaskNode = (TreeTableNode)oNode.getParent();
            ITask oTask = TaskMenuItemHandlerHelper.getTaskFromSelectedRow(oTaskNode);
            int iTaskID = null == oTask ? -1 : oTask.getTaskId();
            boolean bExist = TaskMenuItemHandlerHelper.isResouceExistInLst(oExceptResultLst, iTaskID, oResource.getDeviceID());
            if (bExist) continue;
            oResource.setOperationCancelled(bFlag);
        }
    }

    public static boolean isResouceExistInLst(List<TaskOpResultInfo> oExceptResultLst, int iTaskID, int iDevID) {
        boolean bExist = false;
        if (null == oExceptResultLst || oExceptResultLst.isEmpty() || -1 == iTaskID) {
            return bExist;
        }
        block0: for (int i = 0; i < oExceptResultLst.size(); ++i) {
            TaskOpResultInfo oTaskResult = oExceptResultLst.get(i);
            int iTmpTaskID = oTaskResult.getTaskId();
            if (iTaskID != iTmpTaskID) continue;
            List<ResourceOpResultInfo> oResResultLst = oTaskResult.getOperationResultList();
            if (null == oResResultLst || oResResultLst.isEmpty()) break;
            for (int j = 0; j < oResResultLst.size(); ++j) {
                ResourceOpResultInfo oResResult = oResResultLst.get(j);
                if (null == oResResult.getResource() || oResResult.getResource().getDeviceID() != iDevID) continue;
                bExist = true;
                break block0;
            }
            break;
        }
        return bExist;
    }

    public static int checkForNextOperation(TreeTableNode oNode) {
        TreeTableRowData oRowData = (TreeTableRowData)oNode.getUserObject();
        Resource oResource = (Resource)oRowData.getUserObject();
        String strCurrentOperation = oResource.getProgressInfo().getCurrentOperationId();
        if (Collator.getInstance().equals("LoadSoftware", strCurrentOperation)) {
            return TaskMenuItemHandlerHelper.isExistFailedBoardsInNe(oNode, "LoadSoftware");
        }
        if (Collator.getInstance().equals("ActivateSoftware", strCurrentOperation)) {
            return TaskMenuItemHandlerHelper.isExistFailedBoardsInNe(oNode, "ActivateSoftware");
        }
        return 0;
    }

    public static int isExistFailedBoardsInNe(TreeTableNode oNode, String operName) {
        int boardCount = oNode.getChildCount();
        int iFailedBoardType = 0;
        if (boardCount > 0) {
            for (int i = 0; i < boardCount; ++i) {
                TreeTableRowData oTmpRowData;
                TreeTableNode tmpNode = (TreeTableNode)oNode.getChildAt(i);
                if (!(tmpNode.getUserObject() instanceof TreeTableRowData) || !((oTmpRowData = (TreeTableRowData)tmpNode.getUserObject()).getUserObject() instanceof Resource)) continue;
                Resource oRes = (Resource)oTmpRowData.getUserObject();
                ResourceProgressInfo resProgressInfo = oRes.getProgressInfo();
                String strOperName = resProgressInfo.getCurrentOperationId();
                int iResult = resProgressInfo.getResult();
                if (Collator.getInstance().equals("LoadSoftware", operName)) {
                    if (iResult != 1) continue;
                    String strSlotName = oTmpRowData.getColumnData(2).toString();
                    if (strSlotName.equals("Master SCC") || strSlotName.equals("Slave SCC") || strSlotName.equals("Master XC1") || strSlotName.equals("Slave XC1") || strSlotName.equals("Master XC2") || strSlotName.equals("Slave XC2") || strSlotName.equals("Master XC3") || strSlotName.equals("Slave XC3") || strSlotName.equals("Master XC4") || strSlotName.equals("Slave XC4")) {
                        return 2;
                    }
                    iFailedBoardType = 1;
                    continue;
                }
                if ((!Collator.getInstance().equals("ActivateSoftware", strOperName) && !Collator.getInstance().equals("ManualActivate", strOperName) || iResult != 1) && (!Collator.getInstance().equals("LoadSoftware", strOperName) || iResult != 0)) continue;
                return 3;
            }
        }
        return iFailedBoardType;
    }

    public static int showConfirmDialog(boolean bIsEnableRetry) {
        String strMessage = "";
        String strTitle = "";
        Object[] strButtonTitles = null;
        if (bIsEnableRetry) {
            strMessage = DCFrameWorkUtil.getLocalizedString("UFC_CONTINUE_TASK_CONFIRM_MSG");
            strTitle = DCFrameWorkUtil.getLocalizedString("CONFIRMATION_DIALOG_TITLE");
            strButtonTitles = new Object[]{DCFrameWorkUtil.getLocalizedString("CONTINUE_OPERATION"), DCFrameWorkUtil.getLocalizedString("RETRY"), DCFrameWorkUtil.getLocalizedString("CANCEL_BUTTON")};
        } else {
            strMessage = DCFrameWorkUtil.getLocalizedString("UFC_CONTINUE_TASK_CONFIRM_MSG_WITHOUT_RETRY");
            strTitle = DCFrameWorkUtil.getLocalizedString("CONFIRMATION_DIALOG_TITLE");
            strButtonTitles = new Object[]{DCFrameWorkUtil.getLocalizedString("CONTINUE_OPERATION"), DCFrameWorkUtil.getLocalizedString("CANCEL_BUTTON")};
        }
        int iOptionType = 1;
        int iMessageType = 3;
        return DCOptionPane.showOptionDialog(DCFrameWorkUtil.getMainFrame(), strMessage, strTitle, iOptionType, iMessageType, null, strButtonTitles, null);
    }

    public static void updateStatusOfStartedTasks(int[] arrSelectedTaskIDs, int[] arrFailedTaskIDs) {
        List oFailedTaskIDList = TaskMenuItemHandlerHelper.convertIntArrayToList(arrFailedTaskIDs);
        Integer oTaskID = null;
        for (int i = 0; i < arrSelectedTaskIDs.length; ++i) {
            oTaskID = arrSelectedTaskIDs[i];
            if (oFailedTaskIDList.contains(oTaskID)) continue;
            TaskModelUtil.updateTaskAndResourceStatus(arrSelectedTaskIDs[i], 1);
            ITask oTask = TaskDataModel.getInstance().getTask(arrSelectedTaskIDs[i]);
            oTask.setStartTime(Calendar.getInstance());
            THashSet<Resource> oResList = oTask.getDeviceType().getResources();
            Resource oRes2 = null;
            for (Resource oRes2 : oResList) {
                oRes2.setOperationCancelled(false);
            }
        }
    }

    public static void updateStatusOfMovedTasks(ITask[] arrSelectedTasks, int[] arrFailedTaskIDs) {
        List oFailedTaskIDList = TaskMenuItemHandlerHelper.convertIntArrayToList(arrFailedTaskIDs);
        Integer oTaskID = null;
        for (int i = 0; i < arrSelectedTasks.length; ++i) {
            oTaskID = arrSelectedTasks[i].getTaskId();
            if (oFailedTaskIDList.contains(oTaskID)) continue;
            TaskModelUtil.updateTaskStatus(arrSelectedTasks[i].getTaskId(), 3);
            if (i != arrSelectedTasks.length - 1) continue;
            TaskEvent oTaskEvent = new TaskEvent(arrSelectedTasks[i], TaskEventID.MOVE_TO_COMPLETED);
            TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
        }
    }

    public static TreeTableNode getTaskNode(int iTaskNodeID, TreeTableNode oRoot) {
        TreeTableNode oTreeTableNode = null;
        int iChildCount = oRoot.getChildCount();
        for (int i = 0; i < iChildCount; ++i) {
            TreeTableNode childAt = (TreeTableNode)oRoot.getChildAt(i);
            TreeTableRowData oRowData = (TreeTableRowData)childAt.getUserObject();
            ITask userObject = (ITask)oRowData.getUserObject();
            if (userObject.getTaskId() != iTaskNodeID) continue;
            oTreeTableNode = childAt;
        }
        return oTreeTableNode;
    }

    public static ArrayList getTaskSelectedTask(DCSortableTreeTable m_oTable) {
        ArrayList<ITask> oTaskList = new ArrayList<ITask>(8);
        int[] arrSelectedRows = m_oTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return oTaskList;
        }
        ITask oTask = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = m_oTable.getTree().getPathForRow(arrSelectedRows[i]);
            TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            oTask = TaskMenuItemHandlerHelper.getTaskFromSelectedRow(oNode);
            if (null == oTask || oTaskList.contains(oTask)) continue;
            oTaskList.add(oTask);
        }
        return oTaskList;
    }

    public static int[] getSelectTaskIds(DCSortableTreeTable m_oTable) {
        int[] arrSelectedPaths = m_oTable.getSelectedRows();
        int[] iArrTaskIds = new int[arrSelectedPaths.length];
        TreeTableNode oNode = null;
        for (int i = 0; i < arrSelectedPaths.length; ++i) {
            TreePath oTreePath = m_oTable.getTree().getPathForRow(arrSelectedPaths[i]);
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            ITask oTask = TaskTableUtil.getTaskForTableNode(oNode);
            if (null == oTask) continue;
            iArrTaskIds[i] = oTask.getTaskId();
        }
        return iArrTaskIds;
    }

    public static ITask getTaskFromSelectedRow(TreeTableNode oNodeInfo) {
        TreeTableRowData oTreeTableRowData;
        Object oTaskObj;
        ITask oTask = null;
        Object oUserObj = oNodeInfo.getUserObject();
        if (oUserObj instanceof TreeTableRowData && (oTaskObj = (oTreeTableRowData = (TreeTableRowData)oUserObj).getUserObject()) instanceof ITask) {
            oTask = (ITask)oTaskObj;
        }
        return oTask;
    }

    public static Resource getResFromSelectedRow(TreeTableNode oNodeInfo) {
        TreeTableRowData oTreeTableRowData;
        Object oResourceObj;
        Resource oResource = null;
        Object oUserObj = oNodeInfo.getUserObject();
        if (oUserObj instanceof TreeTableRowData && (oResourceObj = (oTreeTableRowData = (TreeTableRowData)oUserObj).getUserObject()) instanceof Resource) {
            oResource = (Resource)oResourceObj;
        }
        return oResource;
    }

    public static boolean isContanisDevParseInManualReboot(HashMap oSelectedResourcesMap) {
        boolean bContains = false;
        Iterator oIterator = oSelectedResourcesMap.keySet().iterator();
        THashSet oResLst = null;
        ResourceProgressInfo oResProgress = null;
        int iTaskID = -1;
        ITask oTask = null;
        while (oIterator.hasNext()) {
            iTaskID = (Integer)oIterator.next();
            oTask = TaskDataModel.getInstance().getTask(iTaskID);
            if (null == oTask || !TaskInfoUtil2.isTaskMatchActivationType(oTask, "ManualReboot") || null == (oResLst = (THashSet)oSelectedResourcesMap.get(iTaskID)) || oResLst.size() == 0) continue;
            for (Resource oResource : oResLst) {
                if (null == oResource || null == oResource.getProgressInfo() || (oResProgress = oResource.getProgressInfo()).getState() != 4 || !Collator.getInstance().equals(oResProgress.getCurrentOperationId(), "ActivateSoftware")) continue;
                return true;
            }
        }
        return bContains;
    }

    public static List convertIntArrayToList(int[] intArray) {
        ArrayList<Integer> oSelecTaskIdLst = new ArrayList<Integer>(0);
        Integer oTaskIds = null;
        for (int i = 0; i < intArray.length; ++i) {
            oTaskIds = intArray[i];
            oSelecTaskIdLst.add(oTaskIds);
        }
        return oSelecTaskIdLst;
    }

    public static int displayTaskOpResultMessage(List oTaskOpResultList, String strOpName, String strSuccessMsg) {
        return TaskMenuItemHandlerHelper.displayTaskOpResultMessage(oTaskOpResultList, strOpName, strSuccessMsg, false);
    }

    public static int displayTaskOpResultMessage(List oTaskOpResultList, String strOpName, final String strSuccessMsg, boolean isPause) {
        int iRowCount = 0;
        if (null == oTaskOpResultList || 0 == oTaskOpResultList.size()) {
            if (null != strSuccessMsg) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), strSuccessMsg, ResourceManager.getInstance().getResString("INFO"), 1);
                    }
                });
            }
            return iRowCount;
        }
        String strOperationResultTitle = ResourceManager.getInstance().getResStringFromPattern("TASK_OPERATION_RESULT_TITLE", "%s", strOpName);
        final TaskOperationResultDialog oDlg = new TaskOperationResultDialog(strOperationResultTitle, 1, true);
        oDlg.setMessage(ResourceManager.getInstance().getResString("TASK_OPERATION_RESULT_FAILURE_MSG"));
        List<ResourceOpResultInfo> oOpResultList = null;
        ITaskDataModel oTaskDataModel = TaskDataModel.getInstance();
        int iTaskCount = oTaskOpResultList.size();
        for (int i = 0; i < iTaskCount; ++i) {
            TaskOpResultInfo oTaskResult = (TaskOpResultInfo)oTaskOpResultList.get(i);
            ITask oTask = oTaskDataModel.getTask(oTaskResult.getTaskId());
            if (null == oTask) continue;
            String strTaskName = oTask.getTaskName();
            oOpResultList = oTaskResult.getOperationResultList();
            if (null == oOpResultList || 0 == oOpResultList.size()) {
                if (null == oTaskResult.getErrorCode()) continue;
                oDlg.addRowInModel(strTaskName, ErrorCodeReader.getInstance().getErrorDesc(oTaskResult.getErrorCode()));
                ++iRowCount;
                continue;
            }
            int iResourceCount = oOpResultList.size();
            ResourceOpResultInfo oOperationResult = null;
            Resource oTempRes = null;
            for (int j = 0; j < iResourceCount; ++j) {
                oOperationResult = oOpResultList.get(j);
                oTempRes = oOperationResult.getResource();
                Resource oResource = null;
                oResource = !isPause && 3 == oTask.getTaskTypeId() ? oTask.getTemporaryDevType().getResource(oTempRes.getDeviceID(), oTempRes.getFrameId(), oTempRes.getSlotId()) : oTask.getSelectedDeviceType().getResource(oTempRes.getDeviceID(), oTempRes.getFrameId(), oTempRes.getSlotId());
                if (null == oResource) continue;
                oDlg.addRowInModel(oResource.getDeviceName() + '[' + oTask.getTaskName() + ']', ErrorCodeReader.getInstance().getErrorDesc(oOperationResult.getErrorCode()));
                ++iRowCount;
            }
        }
        if (0 < oDlg.getRowCount()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    oDlg.setVisible(true);
                }
            });
        }
        return iRowCount;
    }

    public static void updateStatusForTasksAndResources(DCSortableTreeTable m_oTable, HashMap oTaskResourceMap, boolean bIsTaskLevelOp, int iState, int operationTypeId) {
        DCDebugTracer.trace("[suspend task] method updateStatusForTasksAndResources start");
        if (null == oTaskResourceMap) {
            return;
        }
        DCDebugTracer.trace("[suspend task] oTaskResourceMap : " + oTaskResourceMap);
        DCDebugTracer.trace("[suspend task] bIsTaskLevelOp : " + bIsTaskLevelOp);
        DCDebugTracer.trace("[suspend task] iState : " + iState);
        DCDebugTracer.trace("[suspend task] operationTypeId : " + operationTypeId);
        ITaskDataModel oTaskDataModel = TaskDataModel.getInstance();
        Iterator oTaskIdItr = oTaskResourceMap.entrySet().iterator();
        Integer oTaskId = null;
        Map.Entry oEntry = null;
        while (oTaskIdItr.hasNext()) {
            oEntry = oTaskIdItr.next();
            oTaskId = (Integer)oEntry.getKey();
            ITask oTask = oTaskDataModel.getTask(oTaskId);
            if (null == oTask || null != oTask.getTaskProgressInfo() && oTask.getTaskProgressInfo().getState() == 3) continue;
            TaskTableButtonPanel oTaskBtnPanel = DCFrameWorkUtil.getTaskTableButtonPanel();
            if (null != oTaskBtnPanel) {
                oTaskBtnPanel.enableContinueTaskBtn(false);
            }
            THashSet oResourceList = (THashSet)oEntry.getValue();
            int iResourceCount = oResourceList.size();
            if (bIsTaskLevelOp && iResourceCount > 0) {
                oTask.getTaskProgressInfo().setState(iState);
                if (1 == iState) {
                    if (operationTypeId != 1) {
                        oTask.getTaskProgressInfo().setProgress(0);
                        DCDebugTracer.trace("[suspend task] set task progress 0");
                    } else {
                        TaskMenuItemHandlerHelper.setTaskProgressForUFCContinue(oTask, (THashSet<Resource>)oResourceList);
                    }
                }
            }
            DCDebugTracer.trace("[suspend task] oResourceList size : " + oResourceList);
            for (Resource oResource : oResourceList) {
                TreeTableNode oParentNode;
                TreeTableRowData oParentRow;
                TreeTableNode oResourceNode;
                if (operationTypeId == 1) {
                    int iError = oResource.getProgressInfo().getErrorNo();
                    DCDebugTracer.trace("[suspend task] iError : " + iError);
                    if (iError == 989855882) {
                        oResource.getProgressInfo().setState(iState);
                        if (1 == iState) {
                            oResource.getProgressInfo().setProgress(0);
                            DCDebugTracer.trace("[suspend task] set device progress 0 oResource id = " + oResource.getDeviceID() + " DevIp = " + oResource.getDeviceIP());
                        }
                    }
                } else {
                    oResource.getProgressInfo().setState(iState);
                    if (1 == iState) {
                        oResource.getProgressInfo().setProgress(0);
                        DCDebugTracer.trace("[suspend task] set device progress 0 oResource id = " + oResource.getDeviceID() + " DevIp = " + oResource.getDeviceIP());
                    }
                }
                if (3 != oTask.getTaskTypeId() || -1 == oResource.getFrameId() || null == (oResourceNode = TaskTableUtil.getNodeForResourceInTask(m_oTable, oResource, oTask)) || null == oResourceNode.getParent() || null == (oParentRow = (TreeTableRowData)(oParentNode = (TreeTableNode)oResourceNode.getParent()).getUserObject()) || !(oParentRow.getUserObject() instanceof Resource)) continue;
                ((Resource)oParentRow.getUserObject()).getProgressInfo().setProgress(0);
            }
        }
        DCFrameWorkUtil.updateUI((JComponent)((Object)m_oTable));
    }

    public static void setTaskProgressForUFCContinue(ITask oTask, THashSet<Resource> oResourceList) {
        Resource resource = TaskCommUtil.getFirstDevice(oResourceList);
        if ("CheckFeasibility".equals(resource.getProgressInfo().getCurrentOperationId())) {
            int iSelectedOp = 0;
            for (int j = 0; j < oTask.getSupportedOperation().size(); ++j) {
                if (!oTask.getSupportedOperation().get(j).isSelected()) continue;
                ++iSelectedOp;
            }
            oTask.getTaskProgressInfo().setProgress(100 / iSelectedOp);
        }
    }

    public static HashMap getSuccessfulTaskResourceMap(HashMap oTaskResourceMap, List oTaskOpList) {
        if (null == oTaskOpList || 0 == oTaskOpList.size()) {
            return oTaskResourceMap;
        }
        HashMap oTaskResourceMapCopy = (HashMap)CloneUtil.getClone(oTaskResourceMap);
        int iTaskCount = oTaskResourceMap.size();
        TaskOpResultInfo oTaskResult = null;
        Integer oTaskId = null;
        for (int i = 0; i < iTaskCount; ++i) {
            BigInteger oTaskErrorCode;
            oTaskResult = (TaskOpResultInfo)oTaskOpList.get(i);
            oTaskId = oTaskResult.getTaskId();
            List<ResourceOpResultInfo> oOpResultList = oTaskResult.getOperationResultList();
            if (!(null != oOpResultList && 0 != oOpResultList.size() || null != (oTaskErrorCode = oTaskResult.getErrorCode()) && 0 != oTaskErrorCode.intValue())) {
                oTaskResourceMapCopy.remove(oTaskId);
                continue;
            }
            List oOriginalList = (List)oTaskResourceMapCopy.get(oTaskId);
            if (null == oOriginalList || null == oOpResultList) continue;
            int iResourceCount = oOpResultList.size();
            ResourceOpResultInfo oResourceInfo = null;
            Resource oTempRes = null;
            BigInteger oResourceErrorCode = null;
            for (int j = 0; j < iResourceCount; ++j) {
                oResourceInfo = oOpResultList.get(i);
                oTempRes = oResourceInfo.getResource();
                oResourceErrorCode = oResourceInfo.getErrorCode();
                if (null == oResourceErrorCode || 0 == oResourceErrorCode.intValue() || !oOriginalList.contains(oTempRes)) continue;
                oOriginalList.remove(oTempRes);
            }
        }
        return oTaskResourceMapCopy;
    }

    public static boolean checkDevicesInfoForTask(int[] arrSelectedTaskIDs) {
        AsnDCCheckDevicesInfoForTaskRsp oAsnDCCheckDevicesInfoForTaskRsp = TaskSyncCommController.getInstance().checkDevicesInfoForTask(arrSelectedTaskIDs);
        if (oAsnDCCheckDevicesInfoForTaskRsp == null) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SEND_FAIL"), ResourceManager.getInstance().getResString("SYSTEM_INFO_ERROR"), 0);
            return false;
        }
        DCDebugTracer.trace("AsnDCCheckDevicesInfoForTaskRsp :" + oAsnDCCheckDevicesInfoForTaskRsp.toString());
        int size = oAsnDCCheckDevicesInfoForTaskRsp.size();
        if (size > 0) {
            String[] strColumns = new String[]{ResourceManager.getInstance().getResString("TASK_RESULT_RESOURCE_NAME"), ResourceManager.getInstance().getResString("TASK_RESULT_FAILURE_REASON"), ResourceManager.getInstance().getResString("OPERATE_DETAIL")};
            String strOperationResultTitle = ResourceManager.getInstance().getResStringFromPattern("TASK_OPERATION_RESULT_TITLE", "%s", "");
            final TaskOperationResultDialog oDlg = new TaskOperationResultDialog(strOperationResultTitle, 1, true, strColumns);
            oDlg.setMessage(ResourceManager.getInstance().getResString("TASK_OPERATION_RESULT_FAILURE_MSG"));
            IDeviceInfoManager deviceInfoManager = DeviceInfoManagerImpl.getInstance();
            for (int i = 0; i < size; ++i) {
                AsnDCMultiDeviceErrWithTaskRef oAsnDCMultiDeviceErrWithTaskRef = (AsnDCMultiDeviceErrWithTaskRef)oAsnDCCheckDevicesInfoForTaskRsp.get(i);
                AsnDCMultiDeviceErr devErr = oAsnDCMultiDeviceErrWithTaskRef.oAsnDCMultiDeviceErr;
                String devName = deviceInfoManager.getDevice(devErr.iDeviceId.intValue()).getDevName();
                String strErrorCode = ResourceManager.getInstance().getResString("OTHER_TASK_INCLUDE_THEST_DEVICE");
                Vector<Object> oRowVector = new Vector<Object>();
                oRowVector.add(devName);
                oRowVector.add(strErrorCode);
                StringBuilder sb = new StringBuilder();
                AsnTaskRefList oAsnTaskRefList = oAsnDCMultiDeviceErrWithTaskRef.oAsnTaskRefList;
                AsnTaskRef oAsnTaskRef = null;
                for (int j = 0; j < oAsnTaskRefList.size(); ++j) {
                    oAsnTaskRef = (AsnTaskRef)oAsnTaskRefList.get(j);
                    ITask oTask = TaskDataModel.getInstance().getTask(oAsnTaskRef.iTaskId.intValue());
                    int taskTypeId = oTask.getTaskTypeId();
                    if (260 == taskTypeId || 269 == taskTypeId || 261 == taskTypeId || 268 == taskTypeId) {
                        sb.append(ResourceManager.getInstance().getResString("ISOLATION_TASK_TYPE_POSTFIX"));
                        sb.append("_");
                    }
                    sb.append(oTask.getTaskName());
                    sb.append(DCConstants.LINE_SEPARATOR);
                }
                oRowVector.add(sb.toString());
                oDlg.addRowInModel(oRowVector);
            }
            if (0 < oDlg.getRowCount()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        oDlg.showDetail();
                        oDlg.setVisible(true);
                    }
                });
            }
            return false;
        }
        return true;
    }

    public static boolean isActivationOpSelectedForTask(ITask oTask) {
        ArrayList oSupportedOperation = (ArrayList)oTask.getSupportedOperation();
        ActivationOperation oActivationOperation = null;
        boolean bActivationSelected = false;
        for (int index = 0; index < oSupportedOperation.size(); ++index) {
            if (!(oSupportedOperation.get(index) instanceof ActivationOperation)) continue;
            oActivationOperation = (ActivationOperation)oSupportedOperation.get(index);
            if (!oActivationOperation.isSelected()) break;
            bActivationSelected = true;
            break;
        }
        return bActivationSelected;
    }

    public static int[] getTaskIdsFromTaskResultList(List oTaskResultList) {
        if (null == oTaskResultList || 0 == oTaskResultList.size()) {
            return new int[0];
        }
        int[] arrTaskIds = new int[oTaskResultList.size()];
        int iTaskCount = oTaskResultList.size();
        for (int i = 0; i < iTaskCount; ++i) {
            arrTaskIds[i] = ((TaskOpResultInfo)oTaskResultList.get(i)).getTaskId();
        }
        return arrTaskIds;
    }

    public static void createTaskDialog(int taskTypeID) {
        Task oTaskObj = new Task();
        oTaskObj.setTaskTypeId(taskTypeID);
        TaskMenuItemHandlerHelper.createTaskDialog(oTaskObj, false);
    }

    public static void createTaskDialog(ITask oTaskObj, boolean isSelDev) {
        int taskTypeID = oTaskObj.getTaskTypeId();
        CreateTaskDialog oDialog = new CreateTaskDialog(oTaskObj);
        TaskInfoUtil2.setHelpKey(oDialog.getContentPane(), oTaskObj);
        DCFrameWorkUtil.setCreateTaskDialog(oDialog);
        try {
            CreateTaskDeviceSelectionPanel oDeviceSel = null;
            oDeviceSel = 2 == taskTypeID || 3 == taskTypeID || 4 == taskTypeID ? new CreateTaskDeviceSelectionPanel(oDialog, oTaskObj, isSelDev) : (5 == taskTypeID ? new TaskDevSelecPanelWithUpgradeLevel(oDialog, oTaskObj, isSelDev) : new TaskDevSelecPanelWithUpgradeType(oDialog, oTaskObj, isSelDev));
            if (!isSelDev) {
                int allDevTypeId = -1;
                int allDevTypeVersionId = -1;
                DeviceTypeInfo deviceType = new DeviceTypeInfo();
                deviceType.setDevTypeName(DCConstants.ALL_TYPE);
                deviceType.setDevTypeVersionName(DCConstants.ALL_TYPE_VERSION);
                deviceType.setDevTypeID(-1);
                deviceType.setDevTypeVersionId(-1);
                oDeviceSel.m_oDeviceSelectionPanel.getDeviceSelectionDropDownPanel().setSelectedDeviceType(deviceType);
            }
            CreateTaskDeviceSelectionPanel oDevVersionRes = oDeviceSel;
            TaskMgmtOperationSelecPanel oOperationSel = new TaskMgmtOperationSelecPanel(true);
            IDeviceVersionChangeListener oDevVersionChangeListener = oOperationSel;
            oDevVersionRes.addDeviceVersionChangelistener(oDevVersionChangeListener);
            TaskConfirmationPanel OConfirmationPanel = new TaskConfirmationPanel();
            oDialog.addPanel(oDeviceSel);
            oDialog.addPanel(oOperationSel);
            oDialog.addPanel(OConfirmationPanel);
            DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
            oDialog.setVisible(true);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
            oDialog.closeDialog();
            if (e.getErrorCode() == 0) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getMessage());
            }
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
        }
    }

    public static boolean isSelRes(Iterator<Map.Entry<Integer, THashSet<Resource>>> oTaskIDItor) {
        boolean bSelectedResourceNull = true;
        THashSet<Resource> oResourceList = null;
        Map.Entry<Integer, THashSet<Resource>> oEntry = null;
        while (oTaskIDItor.hasNext()) {
            oEntry = oTaskIDItor.next();
            Integer oTaskID = oEntry.getKey();
            if (null == oTaskID || null == (oResourceList = oEntry.getValue()) || oResourceList.isEmpty()) continue;
            bSelectedResourceNull = false;
            break;
        }
        return bSelectedResourceNull;
    }

    public static boolean isRetryActivate(List<Resource> oResourceLst) {
        boolean bRetryActive = false;
        for (int index = 0; index < oResourceLst.size(); ++index) {
            Resource oResource = oResourceLst.get(index);
            String strCurrOpr = oResource.getProgressInfo().getCurrentOperationId();
            Collator oEquals = Collator.getInstance();
            if (!oEquals.equals("ActivateSoftware", strCurrOpr)) continue;
            bRetryActive = true;
            break;
        }
        return bRetryActive;
    }
}

