/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnContinueTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnDCMultiDeviceErr;
import com.huawei.dc.common.asndatacenter.AsnDCMultiDeviceErrLst;
import com.huawei.dc.common.asndatacenter.AsnDelDevInTaskReq;
import com.huawei.dc.common.asndatacenter.AsnDelDevInTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnDevSetInfo;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.DeviceCommonManualOpr;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.SnmpConfComInfo;
import com.huawei.dc.taskmgmt.model.Task;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.report.devlevel.view.DevReportDlg;
import com.huawei.dc.taskmgmt.view.common.TaskMenuItemHandlerHelper;
import com.huawei.dc.taskmgmt.view.common.TaskOperationResultDialog;
import com.huawei.dc.taskmgmt.view.snmpconfigcom.SNMPConfComDialog;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTableUtil;
import com.swimap.iview.framework.modulemanagement.InternalLocalMsg;
import gnu.trove.THashSet;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;

public class TaskMenuItemHandlerExt {
    public static int getTaskID(DCSortableTreeTable m_oTable) {
        int[] arrSelectedRows = m_oTable.getSelectedRows();
        int taskID = -1;
        TreeTableNode oNode = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreeTableNode parentNode;
            Object parentUserObj;
            TreePath oTreePath = m_oTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData) || -1 != taskID || null == (parentUserObj = (parentNode = (TreeTableNode)oNode.getParent()).getUserObject()) || !(parentUserObj instanceof TreeTableRowData)) continue;
            TreeTableRowData pTreeTableRowData = (TreeTableRowData)parentUserObj;
            Task taskInfo = (Task)pTreeTableRowData.getUserObject();
            taskID = taskInfo.getTaskId();
            return taskID;
        }
        return taskID;
    }

    public static List<String> getFDNLst(List<Integer> devIdLst) {
        ArrayList<String> listFDN = new ArrayList<String>();
        for (int i = 0; i < devIdLst.size(); ++i) {
            int neID = devIdLst.get(i);
            DeviceTypeInfo oDeviceTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfoByDevId(neID);
            if (oDeviceTypeInfo.getDevDomain() == 4) {
                ArrayList<Integer> sRtnData = new ArrayList<Integer>();
                sRtnData.add(neID);
                InternalLocalMsg oRtnMsg = new InternalLocalMsg();
                oRtnMsg.ID = 4000006;
                oRtnMsg.data = sRtnData;
                Object obj = DCFrameWorkUtil.getDCModuleManager().sendEventGetFDN("teCfgModule", oRtnMsg);
                if (!(obj instanceof List)) continue;
                List lstFDN = (List)obj;
                for (int j = 0; j < lstFDN.size(); ++j) {
                    listFDN.add((String)lstFDN.get(j));
                }
                continue;
            }
            listFDN.add(DCCommonUtil.convertDevIDToFDN(neID));
        }
        return listFDN;
    }

    public static void generateCheckReports(DCSortableTreeTable m_oTable, ResourceManager m_oResmanager, String strClassName) {
        DCDebugTracer.trace(strClassName + " [dev report] generateCheckReports start");
        List<Integer> devLst = TaskMenuItemHandlerHelper.getSelectDevList(m_oTable);
        ITask task = TaskMenuItemHandlerHelper.getSelectTask(m_oTable);
        if (null == devLst || null == task) {
            DCDebugTracer.trace(strClassName + " [dev report]  null == devLst || null == task generateCheckReports end..");
            return;
        }
        try {
            DevReportDlg oDialog = new DevReportDlg(task, devLst, m_oResmanager.getResString("GENERATE_CHECK_REPORT_DIALOG_TITTLE"));
            oDialog.setVisible(true);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
        }
        DCDebugTracer.trace(strClassName + " [dev report] generateCheckReports end..");
    }

    public static void telnetTerminal(DCSortableTreeTable m_oTable) {
        TreePath oTreePath;
        TreeTableNode oNode;
        DCOptionPane.showWarningDialog(DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("TASK_TERMINAL_MESSAGE"));
        DeviceCommonManualOpr oDeviceCommonManualOpr = new DeviceCommonManualOpr(null);
        int[] arrSelectedRows = m_oTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return;
        }
        Resource oRes = null;
        int iRowCount = arrSelectedRows.length;
        for (int i = 0; i < iRowCount && null == (oRes = TaskMenuItemHandlerHelper.getResFromSelectedRow(oNode = (TreeTableNode)(oTreePath = m_oTable.getTree().getPathForRow(arrSelectedRows[i])).getLastPathComponent())); ++i) {
        }
        int[] iSelectedDevIds = new int[1];
        if (null != oRes) {
            iSelectedDevIds[0] = oRes.getDeviceID();
        }
        oDeviceCommonManualOpr.telnetTerminal(iSelectedDevIds);
    }

    public static void nextStepOperation(DCSortableTreeTable m_oTable, ResourceManager m_oResmanager) {
        int iErrorResultCount;
        int[] arrSelectedPaths = m_oTable.getSelectedRows();
        if (null == arrSelectedPaths || 0 == arrSelectedPaths.length) {
            return;
        }
        HashMap oSelectedResourcesMap = TaskMenuItemHandlerHelper.getTaskIdResourceListMapForNextOper(m_oTable);
        if (null == oSelectedResourcesMap) {
            return;
        }
        AsnContinueTaskRsp oAsnContinueTaskRsp = null;
        List<Object> oTaskOpResultList = new ArrayList(0);
        if (oSelectedResourcesMap != null && oSelectedResourcesMap.size() > 0) {
            try {
                oAsnContinueTaskRsp = TaskSyncCommController.getInstance().nextOperation(oSelectedResourcesMap, false, m_oTable);
                oTaskOpResultList = TaskCommUtil.getResultListForTaskOperation(oAsnContinueTaskRsp.oTaskRspList);
            }
            catch (DCException e) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
                return;
            }
        }
        if ((iErrorResultCount = TaskMenuItemHandlerHelper.displayTaskOpResultMessage(oTaskOpResultList, m_oResmanager.getResString("NEXT_OPERATION"), null)) == 0 && null != oAsnContinueTaskRsp && oAsnContinueTaskRsp.oErrorInfo.iErrorNo.intValue() != 0) {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), oAsnContinueTaskRsp.oErrorInfo.iErrorNo.intValue());
        }
    }

    public static void viewSNMPConfigurationCompareResult(DCSortableTreeTable m_oTable, String strClassName) {
        DCDebugTracer.trace(strClassName + " viewSNMPConfigurationCompareResult start");
        int[] arrSelectedPaths = m_oTable.getSelectedRows();
        if (null != arrSelectedPaths && arrSelectedPaths.length > 0) {
            int[] arrSelectedRows = m_oTable.getSelectedRows();
            if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
                return;
            }
            TreePath oTreePath = m_oTable.getTree().getPathForRow(arrSelectedRows[0]);
            TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            ITask oTask = TaskTableUtil.getTaskForTableNode(oNode);
            DeviceType devType = oTask.getDeviceType();
            THashSet<Resource> resLst = devType.getResources();
            ArrayList<BigInteger> devLst = new ArrayList<BigInteger>(0);
            for (Resource res : resLst) {
                devLst.add(BigInteger.valueOf(res.getDeviceID()));
            }
            SnmpConfComInfo[] snmpConfComInfos = null;
            try {
                List<SnmpConfComInfo> snmpConfComInfoLst = TaskSyncCommController.getInstance().getSnmpConfigCompareResult(devLst, oTask.getTaskId());
                snmpConfComInfos = snmpConfComInfoLst.toArray(new SnmpConfComInfo[0]);
                SNMPConfComDialog oDialog = new SNMPConfComDialog(snmpConfComInfos, oTask.getTaskId(), oTask.getTaskName());
                oDialog.setVisible(true);
            }
            catch (DCException e) {
                DCDebugTracer.trace(e);
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
                return;
            }
        }
        DCDebugTracer.trace(strClassName + " viewSNMPConfigurationCompareResult end..");
    }

    public static void deleteFailDevOperation(DCSortableTreeTable m_oTable) {
        DCDebugTracer.trace("[TaskMenuItemHandler] method deleteFailDevOperation start");
        int[] arrSelectedPaths = m_oTable.getSelectedRows();
        if (null == arrSelectedPaths || 0 == arrSelectedPaths.length) {
            return;
        }
        int iConfirmOutput = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("REMOVE_OPERATION_CONFIRMATION_MSG"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
        if (0 != iConfirmOutput) {
            return;
        }
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        AsnDelDevInTaskReq oAsnDelDevInTaskReq = new AsnDelDevInTaskReq();
        ITask oTask = null;
        for (int i = 0; i < arrSelectedPaths.length; ++i) {
            TreePath oTreePath = m_oTable.getTree().getPathForRow(arrSelectedPaths[i]);
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            if (oTask == null) {
                oTask = TaskTableUtil.getTaskForTableNode(oNode);
                oAsnDelDevInTaskReq.iTaskId = BigInteger.valueOf(oTask.getTaskId());
                DCDebugTracer.traceDetail("oAsnDelDevInTaskReq.iTaskId : " + oTask.getTaskId());
            }
            if (!(oNode.getUserObject() instanceof TreeTableRowData) || !((oRowData = (TreeTableRowData)oNode.getUserObject()).getUserObject() instanceof Resource)) continue;
            Resource oResource = (Resource)oRowData.getUserObject();
            AsnDevSetInfo oDevSetInfo = new AsnDevSetInfo();
            oDevSetInfo.iDevId = BigInteger.valueOf(oResource.getDeviceID());
            oAsnDelDevInTaskReq.oDevSetInfoLst.add((Object)oDevSetInfo);
            DCDebugTracer.traceDetail("oAsnDelDevInTaskReq.devid : " + oResource.getDeviceID());
        }
        try {
            AsnDelDevInTaskRsp oAsnDelDevInTaskRsp = new AsnDelDevInTaskRsp();
            TaskSyncCommController.getInstance().deleteFailDevOperation(oAsnDelDevInTaskReq, oAsnDelDevInTaskRsp);
            if (oAsnDelDevInTaskRsp.oErrorInfo != null && oAsnDelDevInTaskRsp.oErrorInfo.iErrorNo.intValue() != 0) {
                throw new DCException(oAsnDelDevInTaskRsp.oErrorInfo.iErrorNo.intValue(), null);
            }
            String strOperationResultTitle = ResourceManager.getInstance().getResString("TASK_REPORT_OPERATION_RESULT");
            String[] strColumnNames = new String[]{DCFrameWorkUtil.getLocalizedString("TASK_NAME"), DCFrameWorkUtil.getLocalizedString("OPERATION_RESULT")};
            oTask = TaskDataModel.getInstance().getTask(oAsnDelDevInTaskRsp.iTaskId.intValue());
            AsnDCMultiDeviceErrLst oMultiDeviceErrLst = oAsnDelDevInTaskRsp.oResultOpt;
            DCDebugTracer.trace(" oMultiDeviceErrLst size : " + oMultiDeviceErrLst.size());
            int failedDevCount = 0;
            Vector<Object> oRowDataVec = new Vector<Object>();
            for (Object obj : oMultiDeviceErrLst) {
                Vector<String> oRowContent = new Vector<String>();
                AsnDCMultiDeviceErr res = (AsnDCMultiDeviceErr)obj;
                DeviceInfo devInfo = DeviceInfoManagerImpl.getInstance().getDevice(res.iDeviceId.intValue());
                String resName = String.valueOf(res.iDeviceId.intValue());
                if (null != devInfo) {
                    resName = oTask.getTaskName() + "_" + devInfo.getDevName() + "(" + devInfo.getDevIPAddress() + ")";
                }
                if (res.oErrorInfo.iErrorNo.intValue() != 0) {
                    ++failedDevCount;
                } else {
                    Resource oTmpRes = new Resource();
                    oTmpRes.setDeviceID(res.iDeviceId.intValue());
                    TreeTableNode oDevNode = TaskTableUtil.getNodeForResourceInTask(m_oTable, oTmpRes, oTask);
                    if (null != oDevNode) {
                        oDevNode.removeFromParent();
                    }
                }
                oRowContent.add(resName);
                oRowContent.add(ErrorCodeReader.getInstance().getErrorDesc(res.oErrorInfo.iErrorNo));
                oRowDataVec.add(oRowContent);
            }
            DCFrameWorkUtil.updateUI((JComponent)((Object)m_oTable));
            TaskOperationResultDialog oDlg = null;
            if (failedDevCount == oMultiDeviceErrLst.size()) {
                oDlg = new TaskOperationResultDialog(strOperationResultTitle, 1, true, strColumnNames);
                oDlg.setMessage(ResourceManager.getInstance().getResString("DELETE_DEV_FROM_TASK_PART_FAILED"));
            } else if (failedDevCount == 0) {
                oDlg = new TaskOperationResultDialog(strOperationResultTitle, 0, true, strColumnNames);
                oDlg.setMessage(ResourceManager.getInstance().getResString("DELETE_DEV_FROM_TASK_SUCCESS"));
            } else {
                oDlg = new TaskOperationResultDialog(strOperationResultTitle, 1, true, strColumnNames);
                oDlg.setMessage(ResourceManager.getInstance().getResString("DELETE_DEV_FROM_TASK_PART_SUCCESS"));
            }
            oDlg.addRowsInModel(oRowDataVec);
            oDlg.setVisible(true);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
        }
        DCDebugTracer.trace("[TaskMenuItemHandler] method deleteFailDevOperation end..");
    }
}

