/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.DCQueryFaultCondition;
import com.huawei.dc.common.asndatacenter.AsnContinueTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnDCErrorCodeInfo;
import com.huawei.dc.common.asndatacenter.AsnDCGetActGroupBoardInfoReq;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.asndatacenter.AsnFreeIsolationDeviceReq;
import com.huawei.dc.common.asndatacenter.AsnToleranceSearchReq;
import com.huawei.dc.common.components.dialog.CommonProgressDlg;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCSaveFileChooser;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskEventID;
import com.huawei.dc.taskmgmt.controller.TaskInfoNotifier;
import com.huawei.dc.taskmgmt.controller.TaskResourceUtil;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.controller.UpgradeFeasibilityValidationManager;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.ITaskDataModel;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.Task;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.model.TaskOpResultInfo;
import com.huawei.dc.taskmgmt.model.TaskProgressInfo;
import com.huawei.dc.taskmgmt.report.tasklevel.view.TaskReportDlg;
import com.huawei.dc.taskmgmt.view.common.TaskMenuItemHandlerExt;
import com.huawei.dc.taskmgmt.view.common.TaskMenuItemHandlerHelper;
import com.huawei.dc.taskmgmt.view.common.TaskOperationResultDialog;
import com.huawei.dc.taskmgmt.view.common.TaskStatisticsDlg;
import com.huawei.dc.taskmgmt.view.copytask.CopyTaskDlg;
import com.huawei.dc.taskmgmt.view.modifytask.CopyModifyTaskDialog;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTablePanel;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTableUtil;
import com.huawei.dc.taskmgmt.view.viewtask.ViewTaskDialog;
import com.swimap.external.ifms.adapter.message.FaultQueryCondition;
import gnu.trove.THashSet;
import java.awt.Component;
import java.math.BigInteger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TaskMenuItemHandler {
    private DCSortableTreeTable m_oTable;
    private TaskTablePanel oTaskTablePan;
    private ResourceManager m_oResmanager = ResourceManager.getInstance();
    private int MODIFY_TASK = 2;
    private int IGNOER_TYPE = 3;
    private static final int TASK_LEVEL = 0;
    private static final int DEVICE_LEVEL = 1;
    private THashSet<Resource> m_oFailedResourceForUFC;

    public TaskMenuItemHandler(TaskTablePanel oTaskTablePan) {
        this.oTaskTablePan = oTaskTablePan;
        this.m_oTable = oTaskTablePan.getTaskTreeTable();
    }

    public void patchUpdate() {
        if (0 == DCFrameWorkUtil.getDeviceInfoManager().getAddedDeviceTypes().length) {
            ResourceManager oResManager = ResourceManager.getInstance();
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), oResManager.getResString(oResManager.getResString("DEVICES_NOT_ADDED")), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        TaskMenuItemHandlerHelper.createTaskDialog(2);
    }

    public void softwareUpgradeDowngrade() {
        TaskMenuItemHandlerHelper.createTaskDialog(0);
    }

    public void oltAgentUpgrade() {
        TaskMenuItemHandlerHelper.createTaskDialog(7);
    }

    public void mimicPackageUpgrade() {
        TaskMenuItemHandlerHelper.createTaskDialog(3);
    }

    public void packageUpgrade() {
        TaskMenuItemHandlerHelper.createTaskDialog(4);
    }

    public void packageUpgradedowngradetask() {
        TaskMenuItemHandlerHelper.createTaskDialog(4);
    }

    public void packageDiffusionUpgradeDowngrade() {
        TaskMenuItemHandlerHelper.createTaskDialog(5);
    }

    public void generateReport() {
        DCDebugTracer.trace(this.getClass().getName() + " [task report] generateReport start");
        ITask[] oTasks = TaskMenuItemHandlerHelper.getSelectTasks(this.m_oTable);
        if (null == oTasks) {
            return;
        }
        try {
            TaskReportDlg oDialog = new TaskReportDlg(oTasks, this.m_oResmanager.getResString("GENERATE_TASK_REPORT_DIALOG_TITTLE"));
            oDialog.setVisible(true);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
        }
        DCDebugTracer.trace(this.getClass().getName() + " [task report] generateReport end..");
    }

    public void generateExtendReport() {
        DCDebugTracer.trace("Method TaskMenuItemHandler#generateExtendReport start");
        int[] arrSelectedPaths = this.m_oTable.getSelectedRows();
        if (null != arrSelectedPaths) {
            int iRowCount = arrSelectedPaths.length;
            if (1 == iRowCount) {
                TreePath oTreePath = this.m_oTable.getTree().getPathForRow(arrSelectedPaths[0]);
                TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
                ITask oTask = TaskMenuItemHandlerHelper.getTaskFromSelectedRow(oNode);
                DCSaveFileChooser oFileChooserDlg = new DCSaveFileChooser();
                oFileChooserDlg.setFileFilter(8);
                oFileChooserDlg.setTitle(ResourceManager.getInstance().getResString("GENERATE_EXTEND_REPORT_INFO") + "-" + oTask.getTaskName());
                oFileChooserDlg.setAcceptAllFileFilterUsed(false);
                oFileChooserDlg.setEncodingEnabled(true);
                String fileName = FileUtil.getFileName(ResourceManager.getInstance().getResString("EXTEND_REPORT_INFO") + "-" + oTask.getTaskName());
                oFileChooserDlg.setDefaultFileName(fileName + "_" + StringUtils.getStrNowTime("yyyyMMddHHmmss"));
                int iReturnVal = -1;
                iReturnVal = oFileChooserDlg.showSaveDialog(DCFrameWorkUtil.getTaskTablePanel());
                if (iReturnVal != 0) {
                    return;
                }
                TaskResourceUtil.getExtendResultInfo(oTask.getTaskId(), oFileChooserDlg.getFullFileName());
            }
            DCDebugTracer.trace("Method TaskMenuItemHandler#generateExtendReport end");
        }
    }

    public void copyTask() {
        ITask oTask = TaskMenuItemHandlerHelper.getSelectOneTask(this.m_oTable);
        if (null != oTask) {
            CopyTaskDlg oDialog = new CopyTaskDlg(oTask);
            oDialog.setVisible(true);
        }
    }

    public void modifyTask() {
        ITask oTask = TaskMenuItemHandlerHelper.getSelectOneTask(this.m_oTable);
        if (null != oTask) {
            try {
                CopyModifyTaskDialog oDialog = new CopyModifyTaskDialog(oTask, this.m_oResmanager.getResString("MODIFY_TASK_DIALOG_TITTLE"), 43877, this.MODIFY_TASK);
                oDialog.setVisible(true);
            }
            catch (DCException e) {
                DCDebugTracer.trace(e);
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
            }
        }
    }

    public void viewTask() {
        ITask oTask = TaskMenuItemHandlerHelper.getSelectOneTask(this.m_oTable);
        if (null != oTask) {
            try {
                ViewTaskDialog oDialog = new ViewTaskDialog(oTask);
                oDialog.setVisible(true);
            }
            catch (DCException e) {
                DCDebugTracer.trace(e);
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
            }
        }
    }

    public void deleteFailDevOperation() {
        TaskMenuItemHandlerExt.deleteFailDevOperation(this.m_oTable);
    }

    public void taskStatistics() {
        TaskStatisticsDlg oTaskStatisticsDlg = new TaskStatisticsDlg(TaskMenuItemHandlerHelper.getTaskSelectedTask(this.m_oTable));
        oTaskStatisticsDlg.setSize(728, 401);
        oTaskStatisticsDlg.setLocationRelativeTo(null);
        oTaskStatisticsDlg.setResizable(false);
        oTaskStatisticsDlg.setVisible(true);
    }

    public void deleteTask() {
        if (0 == this.m_oTable.getRowCount()) {
            return;
        }
        int[] arrSelectedPaths = this.m_oTable.getSelectedRows();
        if (null == arrSelectedPaths || 0 == arrSelectedPaths.length) {
            return;
        }
        int iConfirmOutput = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("TASK_DELETE_CONFIRM_MSG"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
        if (0 != iConfirmOutput) {
            return;
        }
        try {
            TaskSyncCommController.getInstance().deleteTasks(TaskMenuItemHandlerHelper.getSelectTaskIds(this.m_oTable));
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
        }
    }

    public void startTask() {
        UpgradeFeasibilityValidationManager.getInstance();
        int[] arrSelectedRows = this.m_oTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return;
        }
        int[] arrSelectedTaskIDs = new int[arrSelectedRows.length];
        List oFailedTaskIDs = null;
        ITask oTask = null;
        boolean bDisplayActivationConfirmation = false;
        boolean isCheckForT2000 = false;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = this.m_oTable.getTree().getPathForRow(arrSelectedRows[i]);
            TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            oTask = TaskMenuItemHandlerHelper.getTaskFromSelectedRow(oNode);
            if (null == oTask) continue;
            if (TaskMenuItemHandlerHelper.isActivationOpSelectedForTask(oTask)) {
                bDisplayActivationConfirmation = true;
            }
            arrSelectedTaskIDs[i] = oTask.getTaskId();
            int devTypeID = oTask.getDeviceType().getDeviceTypeID();
            int devTypeVersionID = oTask.getDeviceType().getDeviceTypeVersionID();
            int iDeviceDomain = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(devTypeID, devTypeVersionID).getDevDomain();
            if (iDeviceDomain != 4) continue;
            isCheckForT2000 = true;
        }
        if (isCheckForT2000 && !TaskMenuItemHandlerHelper.checkDevicesInfoForTask(arrSelectedTaskIDs)) {
            return;
        }
        if (bDisplayActivationConfirmation) {
            String strTaskDescription = ResourceManager.getInstance().getResString("TASK_ACTIVATION_CONFIRMATION_MESSAGE");
            int iConfirmation = DCOptionPane.showExtConfirmDialog(DCFrameWorkUtil.getMainFrame(), strTaskDescription, ResourceManager.getInstance().getResString("WARNING"), 0, 2);
            if (0 != iConfirmation) {
                return;
            }
        }
        try {
            oFailedTaskIDs = TaskSyncCommController.getInstance().startTask(arrSelectedTaskIDs);
        }
        catch (DCException e) {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
            return;
        }
        TaskMenuItemHandlerHelper.displayTaskOpResultMessage(oFailedTaskIDs, this.m_oResmanager.getResString("START_TASK_CONTENT"), null);
        TaskMenuItemHandlerHelper.updateStatusOfStartedTasks(arrSelectedTaskIDs, TaskMenuItemHandlerHelper.getTaskIdsFromTaskResultList(oFailedTaskIDs));
        int allSelTaskCount = arrSelectedTaskIDs.length;
        int failedTaskCount = oFailedTaskIDs.size();
        int[] sccessTaskIDs = new int[allSelTaskCount - failedTaskCount];
        int j = 0;
        for (int i = 0; i < allSelTaskCount; ++i) {
            if (oFailedTaskIDs.contains(arrSelectedTaskIDs[i])) continue;
            sccessTaskIDs[j++] = arrSelectedTaskIDs[i];
        }
        if (sccessTaskIDs.length > 0) {
            TaskEvent oTaskEvent = new TaskEvent(sccessTaskIDs, TaskEventID.TASK_UPDATE_TASK_COUNT);
            TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
        }
        DCFrameWorkUtil.getTaskTableButtonPanel().checkButtonsStatus();
        DCFrameWorkUtil.updateUI((JComponent)((Object)this.m_oTable));
    }

    public void moveToCompleted() {
        ITask[] arrTasks = TaskMenuItemHandlerHelper.getSelectTasks(this.m_oTable);
        if (null == arrTasks) {
            return;
        }
        int iConfirmOutput = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("MOVE_TASK_TO_COMPLETED_CONFIRM_MSG"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
        if (0 != iConfirmOutput) {
            return;
        }
        List oTaskResultList = null;
        try {
            oTaskResultList = TaskSyncCommController.getInstance().moveTasksToCompleted(arrTasks);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
            return;
        }
        TaskMenuItemHandlerHelper.displayTaskOpResultMessage(oTaskResultList, this.m_oResmanager.getResString("MOVE_TO_COMLETED_CONTENT"), this.m_oResmanager.getResString("OPERATION_SUCCESSFUL"));
        TaskMenuItemHandlerHelper.updateStatusOfMovedTasks(arrTasks, TaskMenuItemHandlerHelper.getTaskIdsFromTaskResultList(oTaskResultList));
    }

    public void pauseTask() {
        DCDebugTracer.trace("[suspend task] method pauseTask start");
        int[] arrSelectedPaths = this.m_oTable.getSelectedRows();
        int iRowCount = arrSelectedPaths.length;
        HashMap<Integer, THashSet<Resource>> oTaskResourceMap = new HashMap<Integer, THashSet<Resource>>(iRowCount);
        List oTaskOpResultList = new ArrayList(iRowCount);
        if (0 < iRowCount) {
            int iConfirmOutput = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("TASK_PAUSE_CONFIRM_MSG"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
            if (0 != iConfirmOutput) {
                return;
            }
            Integer oTaskID = null;
            for (int i = 0; i < iRowCount; ++i) {
                TreePath oTreePath = this.m_oTable.getTree().getPathForRow(arrSelectedPaths[i]);
                TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
                ITask oTask = TaskMenuItemHandlerHelper.getTaskFromSelectedRow(oNode);
                if (null == oTask) continue;
                oTaskID = oTask.getTaskId();
                oTaskResourceMap.put(oTaskID, this.getResourcesWithStatus(oTask, 1, true));
            }
        }
        try {
            oTaskOpResultList = TaskSyncCommController.getInstance().pauseTasks(oTaskResourceMap, 0);
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        if (null != oTaskOpResultList && oTaskOpResultList.get(0) instanceof AsnDCErrorCodeInfo) {
            AsnDCErrorCodeInfo errorInfo = (AsnDCErrorCodeInfo)oTaskOpResultList.get(0);
            final String errorMsg = ErrorCodeReader.getInstance().getErrorDesc(errorInfo.iErrorNo);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), errorMsg, TaskMenuItemHandler.this.m_oResmanager.getResString("INFO"), 1);
                }
            });
        } else {
            HashMap oSuccessfulTaskResMap = TaskMenuItemHandlerHelper.getSuccessfulTaskResourceMap(oTaskResourceMap, oTaskOpResultList);
            Iterator oPausedTaskItr = oSuccessfulTaskResMap.keySet().iterator();
            Integer oTaskId = null;
            ITaskDataModel oTaskDataModel = TaskDataModel.getInstance();
            while (oPausedTaskItr.hasNext()) {
                oTaskId = (Integer)oPausedTaskItr.next();
                ITask oTask = oTaskDataModel.getTask(oTaskId);
                TaskProgressInfo oTaskProgress = oTask.getTaskProgressInfo();
                if (null == oTask.getStartTime() || 0 != oTaskProgress.getState()) continue;
                oTaskProgress.setState(4);
            }
        }
        DCDebugTracer.trace("[suspend task] method pauseTask end..");
    }

    private THashSet<Resource> getResourcesWithStatus(ITask oTask, int iStatus, boolean pauseTask) {
        THashSet<Resource> oResourceList = oTask.getSelectedDeviceType().getResources();
        THashSet oValidResources = new THashSet();
        if (null == oResourceList || 0 == oResourceList.size()) {
            return oResourceList;
        }
        int iDeviceDomain = oTask.getDeviceType().getDeviceDomain();
        Iterator oResItor = oResourceList.iterator();
        Resource oResource = null;
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            int currentState = oResource.getProgressInfo().getState();
            if (pauseTask) {
                DCDebugTracer.trace("[suspend task]  currentState : " + currentState + " iStatus : " + iStatus);
                DCDebugTracer.trace(" [suspend task] ResourceIP = " + oResource.getDeviceIP() + " DeviceName = " + oResource.getDeviceName() + " DeviceID = " + oResource.getDeviceID());
                oValidResources.add((Object)oResource);
                continue;
            }
            if (4 == iDeviceDomain || 1 == iDeviceDomain) {
                String strCurrOpr = oResource.getProgressInfo().getCurrentOperationId();
                Collator oEquals = Collator.getInstance();
                if (oEquals.equals("CheckFeasibility", strCurrOpr) && 2 == currentState) {
                    this.m_oFailedResourceForUFC.add((Object)oResource);
                }
            }
            if (iStatus != oResource.getProgressInfo().getState()) continue;
            DCDebugTracer.trace("[suspend task]  currentState : " + currentState + " iStatus : " + iStatus);
            DCDebugTracer.trace(" [suspend task] ResourceIP = " + oResource.getDeviceIP() + " DeviceName = " + oResource.getDeviceName() + " DeviceID = " + oResource.getDeviceID());
            oValidResources.add((Object)oResource);
        }
        DCDebugTracer.trace("[suspend task] method getResourcesWithStatus end.. Size : " + oValidResources.size());
        return oValidResources;
    }

    public void continueTask() {
        int[] arrSelectedPaths = this.m_oTable.getSelectedRows();
        int iRowCount = arrSelectedPaths.length;
        if (0 >= iRowCount) {
            DCDebugTracer.trace("[continue task] method continueTask rowCount <= 0");
            return;
        }
        HashMap<Integer, THashSet<Resource>> oTaskResourceMap = new HashMap<Integer, THashSet<Resource>>(iRowCount);
        HashMap<Integer, THashSet<Resource>> oUFCFailResourceMap = new HashMap<Integer, THashSet<Resource>>(0);
        HashMap<Integer, Object> oCompleteResourceMap = new HashMap<Integer, Object>(0);
        boolean bContinueNextOperation = false;
        boolean bIsAllresourceSuccess = true;
        Vector<Object> includeFailedBoardsNeVec = new Vector<Object>(0);
        Integer oTaskID = null;
        boolean bContainUFCResource = false;
        boolean bContainLoadFailedBoards = false;
        for (int i = 0; i < iRowCount; ++i) {
            this.m_oFailedResourceForUFC = new THashSet(0);
            TreePath oTreePath = this.m_oTable.getTree().getPathForRow(arrSelectedPaths[i]);
            TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            ITask oTask = TaskMenuItemHandlerHelper.getTaskFromSelectedRow(oNode);
            if (null == oTask) continue;
            oTaskID = oTask.getTaskId();
            oTaskResourceMap.put(oTaskID, this.getResourcesWithStatus(oTask, 4, false));
            if (null != this.m_oFailedResourceForUFC && 0 < this.m_oFailedResourceForUFC.size()) {
                oUFCFailResourceMap.put(oTaskID, this.m_oFailedResourceForUFC);
            }
            oCompleteResourceMap.put(oTaskID, oTask.getDeviceType().getResources());
            THashSet<Resource> oResourceList = oTask.getSelectedDeviceType().getResources();
            for (Resource oResource : oResourceList) {
                String strCurrOpr = oResource.getProgressInfo().getCurrentOperationId();
                if (!Collator.getInstance().equals("CheckFeasibility", strCurrOpr)) continue;
                bContainUFCResource = true;
                break;
            }
            if (bContainUFCResource) {
                THashSet oResourceTmp = new THashSet();
                for (Resource oResource : oResourceList) {
                    int resResult;
                    String strCurrOpr = oResource.getProgressInfo().getCurrentOperationId();
                    if ("CheckFeasibility".equals(strCurrOpr)) {
                        oResourceTmp.add((Object)oResource);
                        oCompleteResourceMap.put(oTaskID, oResourceTmp);
                    }
                    if ((resResult = oResource.getProgressInfo().getResult()) == 0) continue;
                    bIsAllresourceSuccess = false;
                }
            }
            if (oTask.getTaskTypeId() != 3) continue;
            int childCount = oNode.getChildCount();
            block5: for (int j = 0; j < childCount; ++j) {
                TreeTableNode oDevNode = (TreeTableNode)oNode.getChildAt(j);
                TreeTableRowData oDevRowData = (TreeTableRowData)oDevNode.getUserObject();
                if (oDevRowData.getNodeType() != 2) continue;
                Vector<String> resultVec = new Vector<String>();
                Resource oResource = (Resource)oDevRowData.getUserObject();
                if (!"ActivateSoftware".equals(oResource.getProgressInfo().getCurrentOperationId())) continue;
                Enumeration<TreeNode> oBoardNodes = oDevNode.depthFirstEnumeration();
                TreeTableNode oBoardNode = null;
                while (oBoardNodes.hasMoreElements()) {
                    oBoardNode = (TreeTableNode)oBoardNodes.nextElement();
                    TreeTableRowData oBoardRowData = (TreeTableRowData)oBoardNode.getUserObject();
                    Resource oBoardResource = (Resource)oBoardRowData.getUserObject();
                    if (!Collator.getInstance().equals("LoadSoftware", oBoardResource.getProgressInfo().getCurrentOperationId()) || !oBoardResource.isFailed()) continue;
                    resultVec.add(oResource.getDeviceName() + "[" + oTask.getTaskName() + "]");
                    resultVec.add(this.m_oResmanager.getResString("EXIST_LOAD_FAILED_BOARDS_WHEN_CONTINUE_TASK"));
                    includeFailedBoardsNeVec.add(resultVec);
                    continue block5;
                }
            }
        }
        if (0 == oUFCFailResourceMap.size() && !bContainUFCResource) {
            Set resultSet = oTaskResourceMap.entrySet();
            Iterator oIterator = resultSet.iterator();
            Map.Entry element = null;
            while (oIterator.hasNext()) {
                element = oIterator.next();
                THashSet oResourceList = (THashSet)element.getValue();
                if (element.getKey() == null || oResourceList == null) continue;
                int iResourceCount = oResourceList.size();
                if (0 != iResourceCount) {
                    bContinueNextOperation = false;
                    break;
                }
                bContinueNextOperation = true;
            }
            if (bContinueNextOperation) {
                oTaskResourceMap = oCompleteResourceMap;
            }
        } else if (0 < oUFCFailResourceMap.size() || bContainUFCResource) {
            int iConfirm = TaskMenuItemHandlerHelper.showConfirmDialog(!bIsAllresourceSuccess);
            if (0 == iConfirm) {
                oTaskResourceMap = oCompleteResourceMap;
                bContinueNextOperation = true;
            } else {
                if (1 == iConfirm) {
                    this.ufcRetry(oUFCFailResourceMap);
                    return;
                }
                return;
            }
        }
        if (!includeFailedBoardsNeVec.isEmpty()) {
            bContainLoadFailedBoards = true;
            String strDlgTitle = this.m_oResmanager.getResString("TASK_CONTINUE_CONFIRMATION_TITLE");
            String[] strColumnNames = new String[]{this.m_oResmanager.getResString("DEVICE_PROGRESS_TABLE_DEVICE_INFO"), this.m_oResmanager.getResString("DEVICE_PROGRESS_TABLE_OPERATION_RESULT")};
            TaskOperationResultDialog oDlg = new TaskOperationResultDialog(strDlgTitle, 2, true, strColumnNames, 1);
            oDlg.setMessage(this.m_oResmanager.getResString("TASK_CONTINUE_CONFIRM_MSG_CONTAIN_FAILED_BOARDS"));
            oDlg.addRowsInModel(includeFailedBoardsNeVec);
            int willContinue = oDlg.showResultDialog();
            if (0 != willContinue) {
                return;
            }
        }
        try {
            TaskSyncCommController.getInstance().continueTasks(oTaskResourceMap, bContinueNextOperation, bContainUFCResource, bContainLoadFailedBoards, this.m_oTable);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
            return;
        }
    }

    private void ufcRetry(HashMap<Integer, THashSet<Resource>> oUFCFailResourceMap) {
        int iErrorCode = 0;
        try {
            iErrorCode = TaskSyncCommController.getInstance().retryOperation(oUFCFailResourceMap, false);
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        if (0 != iErrorCode) {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode);
        }
    }

    public void pauseOperation() {
        int[] arrSelectedPaths = this.m_oTable.getSelectedRows();
        if (null == arrSelectedPaths || 0 == arrSelectedPaths.length) {
            return;
        }
        HashMap oSelectedResourcesMap = TaskMenuItemHandlerHelper.getTaskIdResourceListMap(false, this.m_oTable);
        if (oSelectedResourcesMap != null && oSelectedResourcesMap.size() > 0) {
            try {
                TaskSyncCommController.getInstance().pauseTasks(oSelectedResourcesMap, 1);
            }
            catch (DCException e) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
                return;
            }
        }
    }

    public void continueOperation() {
        int iErrorResultCount;
        int[] arrSelectedPaths = this.m_oTable.getSelectedRows();
        if (null == arrSelectedPaths || 0 == arrSelectedPaths.length) {
            return;
        }
        HashMap oSelectedResourcesMap = TaskMenuItemHandlerHelper.getTaskIdResourceListMap(false, this.m_oTable);
        AsnContinueTaskRsp oAsnContinueTaskRsp = null;
        List<Object> oTaskOpResultList = new ArrayList(0);
        if (oSelectedResourcesMap != null && oSelectedResourcesMap.size() > 0) {
            int iConfirmRlt;
            boolean bDevParseInManualReboot = TaskMenuItemHandlerHelper.isContanisDevParseInManualReboot(oSelectedResourcesMap);
            if (bDevParseInManualReboot && 0 != (iConfirmRlt = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("MSG_MANUAL_REBOOT_CONTINUE_TASK"), ResourceManager.getInstance().getResString("CONFIRM"), 0))) {
                return;
            }
            try {
                oAsnContinueTaskRsp = TaskSyncCommController.getInstance().continueTasks(oSelectedResourcesMap, false, false, false, this.m_oTable);
                oTaskOpResultList = TaskCommUtil.getResultListForTaskOperation(oAsnContinueTaskRsp.oTaskRspList);
            }
            catch (DCException e) {
                DCDebugTracer.trace(e);
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
                return;
            }
        }
        if ((iErrorResultCount = TaskMenuItemHandlerHelper.displayTaskOpResultMessage(oTaskOpResultList, this.m_oResmanager.getResString("CONTINUE_OPERATION"), null)) == 0 && null != oAsnContinueTaskRsp && oAsnContinueTaskRsp.oErrorInfo.iErrorNo.intValue() != 0) {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), oAsnContinueTaskRsp.oErrorInfo.iErrorNo.intValue());
        }
    }

    public void retryOperation() {
        int iConfirm;
        Iterator<Map.Entry<Integer, THashSet<Resource>>> oTaskIDItor;
        int iConfirm2;
        boolean bRetryActive;
        int[] arrSelectedPaths = this.m_oTable.getSelectedRows();
        if (null == arrSelectedPaths || 0 == arrSelectedPaths.length) {
            return;
        }
        boolean isFoundAllDevIsLoadFaildDiffTask = false;
        boolean isShowDiffMsg = false;
        int tmpTaskId = 0;
        String diffTaskName = "";
        ITask oTask = null;
        TreeTableRowData oRowData = null;
        ArrayList<Resource> oResourceLst = new ArrayList<Resource>();
        for (int k = 0; k < arrSelectedPaths.length; ++k) {
            TreePath oTreePath = this.m_oTable.getTree().getPathForRow(arrSelectedPaths[k]);
            if (null == oTreePath) continue;
            TreeTableNode oDiffNode = (TreeTableNode)oTreePath.getLastPathComponent();
            oTask = TaskTableUtil.getTaskForTableNode(oDiffNode);
            oRowData = (TreeTableRowData)oDiffNode.getUserObject();
            oResourceLst.add(k, (Resource)oRowData.getUserObject());
            if (tmpTaskId == oTask.getTaskId()) continue;
            if (oTask.getTaskTypeId() == 5 || oTask.getTaskTypeId() == 12) {
                isFoundAllDevIsLoadFaildDiffTask = TaskInfoUtil.checkIsAllDevInSameOperAndStaus(oTask, "LoadSoftware", 1);
            }
            if (isFoundAllDevIsLoadFaildDiffTask) {
                if (!TaskTableUtil.checkIsSelectAllDevInSameTask(this.m_oTable, oTask)) {
                    isShowDiffMsg = true;
                }
                if (isShowDiffMsg) {
                    diffTaskName = oTask.getTaskName();
                }
            }
            tmpTaskId = oTask.getTaskId();
        }
        if (isShowDiffMsg) {
            String sInfo = ResourceManager.getInstance().getResString("CONFIRM_DIFF_TASK_ALL_DEV_FAILED_IN_LOADSOFTWARE", new String[]{diffTaskName});
            int iConfirm3 = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), sInfo, ResourceManager.getInstance().getResString("CONFIRM"), 0);
            if (0 != iConfirm3) {
                return;
            }
        }
        if ((bRetryActive = TaskMenuItemHandlerHelper.isRetryActivate(oResourceLst)) && 0 != (iConfirm2 = DCOptionPane.showExtConfirmDialog(DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("RETRY_CONFIRM_DANGER_MSG"), ResourceManager.getInstance().getResString("WARNING"), 0, 2))) {
            return;
        }
        HashMap oMapSelectedResources = TaskMenuItemHandlerHelper.getTaskIdResourceListMap(true, this.m_oTable);
        if (null != oMapSelectedResources && TaskMenuItemHandlerHelper.isSelRes(oTaskIDItor = oMapSelectedResources.entrySet().iterator())) {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("MSG_RETRY_SELECTED_NULL_DEVICE"));
            return;
        }
        boolean bIsContinueNextOperation = false;
        if (TaskMenuItemHandlerHelper.isRetryConfRequiredForUFC(this.m_oTable) && 0 == (iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("UFC_RETRY_OPERATION_CONFIRM_MSG"), DCFrameWorkUtil.getLocalizedString("CONFIRM"), 0))) {
            bIsContinueNextOperation = true;
        }
        if (oMapSelectedResources != null && oMapSelectedResources.size() > 0) {
            int iErrorCode = 0;
            try {
                iErrorCode = TaskSyncCommController.getInstance().retryOperation(oMapSelectedResources, bIsContinueNextOperation);
            }
            catch (DCException e) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
                return;
            }
            if (0 != iErrorCode) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode);
            }
        }
    }

    public void retryDiffusionTask() {
        DCDebugTracer.trace("retryDiffusionTask start");
        int[] arrSelectedPaths = this.m_oTable.getSelectedRows();
        if (null == arrSelectedPaths || 0 == arrSelectedPaths.length) {
            return;
        }
        Map<Integer, THashSet<Resource>> oMapSelectedResources = TaskTableUtil.getTaskIdAndDevLstMap(this.m_oTable);
        if (oMapSelectedResources != null && oMapSelectedResources.size() > 0) {
            DCDebugTracer.trace("retryDiffusionTask start oMapSelectedResources.size() : " + oMapSelectedResources.toString());
            int iErrorCode = 0;
            try {
                iErrorCode = TaskSyncCommController.getInstance().retryDiffusionTaskOperation(oMapSelectedResources);
            }
            catch (DCException e) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
                return;
            }
            if (0 != iErrorCode) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode);
            }
        }
        DCDebugTracer.trace("retryDiffusionTask end..");
    }

    public void activateManually() {
        int[] arrSelectedPaths = this.m_oTable.getSelectedRows();
        if (null == arrSelectedPaths || 0 == arrSelectedPaths.length) {
            return;
        }
        HashMap oMapSelectedResources = TaskMenuItemHandlerHelper.getTaskIdResourceListMap(true, this.m_oTable);
        List<TaskOpResultInfo> oTaskOpResultList = new ArrayList<TaskOpResultInfo>(0);
        if (null != oMapSelectedResources && oMapSelectedResources.size() > 0) {
            try {
                oTaskOpResultList = TaskSyncCommController.getInstance().activeOperation(oMapSelectedResources);
                if (null == oTaskOpResultList) {
                    return;
                }
            }
            catch (DCException e) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
                DCDebugTracer.trace(e);
                return;
            }
        }
        TaskMenuItemHandlerHelper.updateResourceListForCancel(this.m_oTable, false, oTaskOpResultList);
        TaskMenuItemHandlerHelper.displayTaskOpResultMessage(oTaskOpResultList, this.m_oResmanager.getResString("REBOOT"), null);
    }

    public void cancelOperation() {
        int[] arrSelectedPaths = this.m_oTable.getSelectedRows();
        if (null == arrSelectedPaths || 0 == arrSelectedPaths.length) {
            return;
        }
        HashMap oMapSelectedResources = TaskMenuItemHandlerHelper.getTaskIdResourceListMap(true, this.m_oTable);
        AsnContinueTaskRsp oAsnContinueTaskRsp = null;
        List<TaskOpResultInfo> oTaskOpResultList = null;
        if (oMapSelectedResources != null && oMapSelectedResources.size() > 0) {
            try {
                int confirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("CONFIRM_CANCEL_MESSAGE"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
                if (confirm != 0) {
                    return;
                }
                oAsnContinueTaskRsp = TaskSyncCommController.getInstance().cancelOperation(oMapSelectedResources);
                oTaskOpResultList = TaskCommUtil.getResultListForTaskOperation(oAsnContinueTaskRsp.oTaskRspList);
                TaskMenuItemHandlerHelper.updateResourceListForCancel(this.m_oTable, true, oTaskOpResultList);
            }
            catch (DCException e) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
                return;
            }
            TaskMenuItemHandlerHelper.displayTaskOpResultMessage(oTaskOpResultList, this.m_oResmanager.getResString("CANCEL"), null);
        }
    }

    public void recheckOperation() {
        int[] arrSelectedPaths = this.m_oTable.getSelectedRows();
        if (null == arrSelectedPaths || 0 == arrSelectedPaths.length) {
            return;
        }
        HashMap oMapSelectedResources = TaskMenuItemHandlerHelper.getTaskIdResourceListMap(true, this.m_oTable);
        ArrayList oTaskOpResultList = new ArrayList(0);
        if (oMapSelectedResources != null && oMapSelectedResources.size() > 0) {
            int iErrorCode = 0;
            try {
                iErrorCode = TaskSyncCommController.getInstance().recheckOperation(oMapSelectedResources);
            }
            catch (DCException e) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
                return;
            }
            if (0 != iErrorCode) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode);
            }
        }
        TaskMenuItemHandlerHelper.displayTaskOpResultMessage(oTaskOpResultList, this.m_oResmanager.getResString("RECHECK_OPERATION"), null);
    }

    public void rollbackOperation() {
        ITask task2;
        int[] arrSelectedPaths = this.m_oTable.getSelectedRows();
        if (null == arrSelectedPaths || 0 == arrSelectedPaths.length) {
            return;
        }
        ITask[] oTasks = TaskMenuItemHandlerHelper.getSelectTasks(this.m_oTable);
        if (null == oTasks) {
            return;
        }
        boolean isAllPatchUpgradeTask = true;
        boolean isHighDangerOpr = false;
        for (ITask task2 : oTasks) {
            if (2 == task2.getTaskTypeId()) continue;
            isAllPatchUpgradeTask = false;
            break;
        }
        ITask[] arr$ = oTasks;
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || 2 != (task2 = arr$[i$]).getTaskTypeId() && (isHighDangerOpr = this.isHadDoActiveOpr(task2))); ++i$) {
        }
        String strDlgContent = ResourceManager.getInstance().getResString("ROLLBACK_CONFIRM_MSG");
        if (isHighDangerOpr) {
            boolean isDMSDev = false;
            List<Integer> iDevIDLst = TaskMenuItemHandlerHelper.getSelectDevList(this.m_oTable);
            for (int i = 0; i < iDevIDLst.size(); ++i) {
                int iDeviceId = iDevIDLst.get(i);
                DeviceTypeInfo oDeviceTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfoByDevId(iDeviceId);
                if (oDeviceTypeInfo.getDevDomain() != 2) continue;
                isDMSDev = true;
                break;
            }
            strDlgContent = isDMSDev ? ResourceManager.getInstance().getResString("ROLLBACK_CONFIRM_DANGER_MSG_FOR_DMS") : ResourceManager.getInstance().getResString("ROLLBACK_CONFIRM_DANGER_MSG");
        }
        if (isAllPatchUpgradeTask) {
            strDlgContent = ResourceManager.getInstance().getResString("ROLLBACK_PATCH_CONFIRM_MSG");
        }
        int iConfirm = 0;
        iConfirm = !isHighDangerOpr ? DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), strDlgContent, ResourceManager.getInstance().getResString("CONFIRM"), 0) : DCOptionPane.showExtConfirmDialog(DCFrameWorkUtil.getMainFrame(), strDlgContent, ResourceManager.getInstance().getResString("WARNING"), 0, 2);
        if (0 != iConfirm) {
            return;
        }
        HashMap mapSelectedResources = TaskMenuItemHandlerHelper.getTaskIdResourceListMap(false, this.m_oTable);
        AsnContinueTaskRsp oAsnContinueTaskRsp = null;
        List<Object> oTaskOpResultList = new ArrayList(0);
        if (mapSelectedResources != null && mapSelectedResources.size() > 0) {
            try {
                oAsnContinueTaskRsp = TaskSyncCommController.getInstance().rollbackOperation(mapSelectedResources);
                oTaskOpResultList = TaskCommUtil.getResultListForTaskOperation(oAsnContinueTaskRsp.oTaskRspList);
            }
            catch (DCException e) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
                return;
            }
        }
        TaskMenuItemHandlerHelper.displayTaskOpResultMessage(oTaskOpResultList, this.m_oResmanager.getResString("OPERATE_RESULT"), null);
    }

    private boolean isHadDoActiveOpr(ITask task) {
        List<Integer> iDevIDLst = TaskMenuItemHandlerHelper.getSelectDevList(this.m_oTable);
        Resource m_oResource = null;
        int strActivateStatus = 0;
        ResourceProgressInfo oResourceProgressInfo = null;
        for (int i = 0; i < iDevIDLst.size(); ++i) {
            m_oResource = task.getDeviceType().getResource(iDevIDLst.get(i));
            oResourceProgressInfo = m_oResource.getOprResultInfo("ActivateSoftware");
            if (null == oResourceProgressInfo) {
                return false;
            }
            strActivateStatus = oResourceProgressInfo.getErrorNo();
            if (989855882 == strActivateStatus || -1 == strActivateStatus) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshSWDLStatusOperation() {
        List<Integer> devIdLst = TaskMenuItemHandlerHelper.getSelectDevList(this.m_oTable);
        int[] arrSelectedRows = this.m_oTable.getSelectedRows();
        int taskID = -1;
        TreeTableNode oNode = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreeTableNode parentNode;
            Object parentUserObj;
            TreePath oTreePath = this.m_oTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData) || -1 != taskID || null == (parentUserObj = (parentNode = (TreeTableNode)oNode.getParent()).getUserObject()) || !(parentUserObj instanceof TreeTableRowData)) continue;
            TreeTableRowData pTreeTableRowData = (TreeTableRowData)parentUserObj;
            Task taskInfo = (Task)pTreeTableRowData.getUserObject();
            taskID = taskInfo.getTaskId();
        }
        Object object = this.oTaskTablePan.getSynObject();
        synchronized (object) {
            String[] columnNames = new String[]{ResourceManager.getInstance().getResString("DEVICE_NAME"), ResourceManager.getInstance().getResString("TBL_COLUMN_NAME_STATUS")};
            final CommonProgressDlg commonFileCheckResultDlg = new CommonProgressDlg(43981, devIdLst, columnNames);
            int iReqId = DCFrameWorkUtil.generateRequestId();
            commonFileCheckResultDlg.setProgressDlgId(iReqId);
            commonFileCheckResultDlg.setTitle(ResourceManager.getInstance().getResString("REFRESH_SWDL_DLG_PROGRESS_TITLE"));
            this.oTaskTablePan.setResultDlg(commonFileCheckResultDlg);
            try {
                TaskAsynCommController.getInstance().refreshSWDLStatus(iReqId, taskID, devIdLst);
            }
            catch (DCException e) {
                commonFileCheckResultDlg.dispose();
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    commonFileCheckResultDlg.setVisible(true);
                }
            });
        }
    }

    public void viewPreCheckReport() {
        TaskMenuItemHandlerHelper.viewCheckReportUI(0, this.m_oTable);
    }

    public void viewPostCheckReport() {
        TaskMenuItemHandlerHelper.viewCheckReportUI(1, this.m_oTable);
    }

    public void compareCheckReports() {
        TaskMenuItemHandlerHelper.viewCheckReportUI(2, this.m_oTable);
    }

    public void viewSNMPConfigurationCompareResult() {
        TaskMenuItemHandlerExt.viewSNMPConfigurationCompareResult(this.m_oTable, this.getClass().getName());
    }

    public void doCleanUp() {
        this.m_oTable = null;
        this.oTaskTablePan = null;
        this.m_oResmanager = null;
    }

    public void ignoreOperation() {
        int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("IGNOER_OPERATIONE_MSG"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
        if (0 != iConfirm) {
            return;
        }
        int[] arrSelectedPaths = this.m_oTable.getSelectedRows();
        if (null == arrSelectedPaths || 0 == arrSelectedPaths.length) {
            return;
        }
        HashMap mapSelectedResources = TaskMenuItemHandlerHelper.getTaskIdResourceListMap(true, this.m_oTable);
        List oTaskOpResultList = new ArrayList(0);
        if (mapSelectedResources != null && mapSelectedResources.size() > 0) {
            try {
                oTaskOpResultList = TaskSyncCommController.getInstance().ignoreOperation(mapSelectedResources);
            }
            catch (DCException e) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
                return;
            }
        }
        TaskMenuItemHandlerHelper.displayTaskOpResultMessage(oTaskOpResultList, this.m_oResmanager.getResString("IGNORE_OPERATION"), null);
        HashMap oSuccesfulTaskResMap = TaskMenuItemHandlerHelper.getSuccessfulTaskResourceMap(mapSelectedResources, oTaskOpResultList);
        TaskMenuItemHandlerHelper.updateStatusForTasksAndResources(this.m_oTable, oSuccesfulTaskResMap, true, 1, this.IGNOER_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryFailedBoardOperation() {
        AsnToleranceSearchReq oAsnIsolationSearchReq = new AsnToleranceSearchReq();
        TaskMenuItemHandlerHelper.fillFailedBoardReq(oAsnIsolationSearchReq, this.m_oTable);
        List<Integer> devIdLst = TaskMenuItemHandlerHelper.getSelectDevList(this.m_oTable);
        int iReqId = DCFrameWorkUtil.generateRequestId();
        oAsnIsolationSearchReq.oReqID = BigInteger.valueOf(iReqId);
        String[] columnNames = new String[]{ResourceManager.getInstance().getResString("DEVICE_INFO"), ResourceManager.getInstance().getResString("OPERATE_RESULT")};
        final CommonProgressDlg commonFileCheckResultDlg = new CommonProgressDlg(44047, devIdLst, columnNames);
        commonFileCheckResultDlg.setProgressDlgId(iReqId);
        commonFileCheckResultDlg.setTitle(ResourceManager.getInstance().getResString("QUERY_DLG_TITLE"));
        Object object = this.oTaskTablePan.getSynObject();
        synchronized (object) {
            try {
                TaskAsynCommController.getInstance().queryOperation(oAsnIsolationSearchReq);
                this.oTaskTablePan.setResultDlg(commonFileCheckResultDlg);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        commonFileCheckResultDlg.setVisible(true);
                    }
                });
            }
            catch (DCException e) {
                commonFileCheckResultDlg.dispose();
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
            }
        }
    }

    public void nextStepOperation() {
        TaskMenuItemHandlerExt.nextStepOperation(this.m_oTable, this.m_oResmanager);
    }

    public void telnetTerminal() {
        TaskMenuItemHandlerExt.telnetTerminal(this.m_oTable);
    }

    public void deleteTaskFromTable(List oTaskIdList, int iFirstRowSelected) {
        TaskMenuItemHandlerHelper.deleteTaskFromTable(oTaskIdList, iFirstRowSelected, this.m_oTable);
    }

    public void viewCurrentAlarm() {
        DCQueryFaultCondition oDCQueryFaultCondition = new DCQueryFaultCondition();
        List<Integer> devIdLst = TaskMenuItemHandlerHelper.getSelectDevList(this.m_oTable);
        List<String> listFDN = TaskMenuItemHandlerExt.getFDNLst(devIdLst);
        String[] strFDNList = new String[listFDN.size()];
        for (int i = 0; i < listFDN.size(); ++i) {
            strFDNList[i] = listFDN.get(i);
        }
        this.openCurAlarmBrowserWindow(oDCQueryFaultCondition, strFDNList);
    }

    public void openCurAlarmBrowserWindow(DCQueryFaultCondition oDCQueryFaultCondition, String[] strFDNList) {
        oDCQueryFaultCondition.setFDNLst(strFDNList);
        DCFrameWorkUtil.getFaultInterface().openAlarmEventBrowseWindow(ResourceManager.getInstance().getResString("VIEW_TCA_ALARM"), 1, (FaultQueryCondition)oDCQueryFaultCondition);
    }

    public void generateCheckReports() {
        TaskMenuItemHandlerExt.generateCheckReports(this.m_oTable, this.m_oResmanager, this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifySingleNEActiveGroup() {
        AsnDCGetActGroupBoardInfoReq oAsnDCGetActGroupBoardInfoReq = new AsnDCGetActGroupBoardInfoReq();
        int[] arrSelectedRows = this.m_oTable.getSelectedRows();
        TreeTableNode oNode = null;
        ArrayList<Integer> devIdLst = new ArrayList<Integer>();
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = this.m_oTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData)) continue;
            TreeTableRowData oRowData = (TreeTableRowData)oNode.getUserObject();
            Resource oResource = (Resource)oRowData.getUserObject();
            int devId = oResource.getDeviceID();
            devIdLst.add(devId);
            oAsnDCGetActGroupBoardInfoReq.iDeviceID = BigInteger.valueOf(devId);
        }
        oAsnDCGetActGroupBoardInfoReq.iRequestID = DCTimeDateUtil.getRandomReqId();
        AsnDCOpertionRsp oAsnDCOpertionRsp = new AsnDCOpertionRsp();
        Object object = this.oTaskTablePan.getSynObject();
        synchronized (object) {
            try {
                TaskAsynCommController.getInstance().getModifySingleNEActiveGroupOperation(oAsnDCGetActGroupBoardInfoReq, oAsnDCOpertionRsp);
                String[] columnNames = new String[]{ResourceManager.getInstance().getResString("DEVICE_NAME"), ResourceManager.getInstance().getResString("OPERATE_RESULT")};
                final CommonProgressDlg commonFileCheckResultDlg = new CommonProgressDlg(44090, devIdLst, columnNames);
                commonFileCheckResultDlg.setProgressDlgId(oAsnDCGetActGroupBoardInfoReq.iRequestID.intValue());
                commonFileCheckResultDlg.setTitle(ResourceManager.getInstance().getResString("QUERY_DLG_TITLE"));
                this.oTaskTablePan.setResultDlg(commonFileCheckResultDlg);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        commonFileCheckResultDlg.setVisible(true);
                    }
                });
            }
            catch (DCException e) {
                DCOptionPane.showMessageDialog(null, e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
            }
        }
    }

    public void freeIsolationDevice() {
        int taskID = TaskMenuItemHandlerExt.getTaskID(this.m_oTable);
        AsnFreeIsolationDeviceReq oAsnFreeIsolationDeviceReq = new AsnFreeIsolationDeviceReq();
        int iDevID = TaskMenuItemHandlerHelper.getSelectDevList(this.m_oTable).get(0);
        oAsnFreeIsolationDeviceReq.iDevID = BigInteger.valueOf(iDevID);
        oAsnFreeIsolationDeviceReq.iTaskID = BigInteger.valueOf(taskID);
        oAsnFreeIsolationDeviceReq.oReqID = DCTimeDateUtil.getRandomReqId();
        AsnDCOpertionRsp oAsnDCOpertionRsp = new AsnDCOpertionRsp();
        TaskAsynCommController.getInstance().setFreeIsolationDeviceOperation(oAsnFreeIsolationDeviceReq, oAsnDCOpertionRsp);
    }

    public void exportAlarmDevices() {
        TaskTableUtil.exportAlarmDevices(this.m_oTable);
    }
}

