/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ICheckOperation;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperation;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.CheckOperationConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.PostcheckOperation;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.PrecheckOperation;
import com.huawei.dc.devicemanagement.deviceoperation.loadpatch.LoadPatchOperation;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.LoadSoftwareOperation;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IOperationConfig;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.TaskModelUtil;
import com.huawei.dc.taskmgmt.model.TaskProgressInfo;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTableUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TaskManagementPopupMenuUtil {
    public static final int DEVICE_NODE_FOR_MIMIC_PACKAGE_TASK = 0;
    public static final int BOARD_NODE_FOR_MIMIC_PACKAGE_TASK = 1;
    public static final int DEVICE_NODE_FOR_PACKAGE_TASK = 2;
    public static final int BOARD_NODE_FOR_PACKAGE_TASK = 3;
    public static final int OTHER_NODE_FOR_OTHER_TASK = 4;

    public static boolean isActivateSelected(ITask oTask) {
        boolean bActivateSelected = false;
        List<ITaskDeviceOperation> oSuppOprList = oTask.getSupportedOperation();
        int iSize = oSuppOprList.size();
        for (int i = 0; i < iSize; ++i) {
            ITaskDeviceOperation oDevOp = oSuppOprList.get(i);
            if (!(oDevOp instanceof ActivationOperation) || !oDevOp.isSelected()) continue;
            bActivateSelected = true;
            break;
        }
        return bActivateSelected;
    }

    public static boolean isLoadPatchSelected(ITask oTask) {
        boolean bLoadSelected = false;
        List<ITaskDeviceOperation> oSuppOprList = oTask.getSupportedOperation();
        int iSize = oSuppOprList.size();
        for (int i = 0; i < iSize; ++i) {
            ITaskDeviceOperation oDevOp = oSuppOprList.get(i);
            if (!(oDevOp instanceof LoadPatchOperation) || !oDevOp.isSelected()) continue;
            bLoadSelected = true;
            break;
        }
        return bLoadSelected;
    }

    public static boolean isLoadSoftwareSelected(ITask oTask) {
        boolean bLoadSelected = false;
        List<ITaskDeviceOperation> oSuppOprList = oTask.getSupportedOperation();
        int iSize = oSuppOprList.size();
        for (int i = 0; i < iSize; ++i) {
            boolean bIsProgramFileSelected;
            ITaskDeviceOperation oDevOp = oSuppOprList.get(i);
            if (!(oDevOp instanceof LoadSoftwareOperation) || !oDevOp.isSelected()) continue;
            bLoadSelected = bIsProgramFileSelected = TaskInfoUtil.isFileSelectedForContentType(oTask, "PROGRAM");
            break;
        }
        return bLoadSelected;
    }

    public static boolean isFinishOperationForAllDev(TreeTableNode oNode, String tarOpr) {
        boolean isFinish = true;
        TreeTableNode oTaskNode = (TreeTableNode)oNode.getParent();
        int countNode = oTaskNode.getChildCount();
        for (int i = 0; i < countNode; ++i) {
            TreeTableNode oDevNode = (TreeTableNode)oTaskNode.getChildAt(i);
            TreeTableRowData oDevNodeInfo = (TreeTableRowData)oDevNode.getUserObject();
            Resource o_mResource = (Resource)oDevNodeInfo.getUserObject();
            ResourceProgressInfo resourceProgressInfo = o_mResource.getProgressInfo();
            int iDevOpState = resourceProgressInfo.getState();
            String operationId = resourceProgressInfo.getCurrentOperationId();
            if (iDevOpState != 1 && iDevOpState != 4 || !tarOpr.equals(operationId)) continue;
            isFinish = false;
            break;
        }
        return isFinish;
    }

    public static boolean isOtherDeviceBeginActivate(ITask oTask, THashSet<Resource> devList, int devID) {
        boolean bParseInGroup;
        int size = devList.size();
        if (size == 1) {
            return false;
        }
        Iterator oResItor = devList.iterator();
        Resource resObj = null;
        boolean bl = bParseInGroup = oTask.getTaskProgressInfo().getPausedActivateGrpID() > -1;
        while (oResItor.hasNext()) {
            resObj = (Resource)oResItor.next();
            if (devID == resObj.getDeviceID()) continue;
            String strCurrentOperation = resObj.getProgressInfo().getCurrentOperationId();
            int iResourceOpstate = resObj.getProgressInfo().getState();
            if ("Commit".equals(strCurrentOperation) || "PostCheck".equals(strCurrentOperation)) {
                return true;
            }
            if (!"ActivateSoftware".equals(strCurrentOperation) || 1 != iResourceOpstate && 2 != iResourceOpstate && 3 != iResourceOpstate && (4 != iResourceOpstate || !bParseInGroup)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSelectCurrentConfig(ITask iTask) {
        PrecheckOperation oPreCheckOp = (PrecheckOperation)TaskModelUtil.getOperationFromTask(iTask.getTaskId(), "PreCheck");
        if (null == oPreCheckOp) {
            return false;
        }
        CheckOperationConfigParam oCheckParam = (CheckOperationConfigParam)oPreCheckOp.getConfiguredPara();
        boolean isSelectPre = oCheckParam.isSelectTargetNode("CurrentConfig");
        PostcheckOperation oPostCheckOp = (PostcheckOperation)TaskModelUtil.getOperationFromTask(iTask.getTaskId(), "PostCheck");
        if (null == oPostCheckOp) {
            return false;
        }
        oCheckParam = (CheckOperationConfigParam)oPostCheckOp.getConfiguredPara();
        boolean isSelectPost = oCheckParam.isSelectTargetNode("CurrentConfig");
        return isSelectPre && isSelectPost;
    }

    public static boolean judgeTaskOperationStatus(THashSet<Resource> list) {
        Iterator oResItor = list.iterator();
        Resource resource = null;
        while (oResItor.hasNext()) {
            resource = (Resource)oResItor.next();
            String currentOperationName = resource.getProgressInfo().getCurrentOperationId();
            int iResourceOpstate = resource.getProgressInfo().getState();
            if ("PostCheck".equals(currentOperationName)) {
                return false;
            }
            if (!"Commit".equals(currentOperationName) || 1 != iResourceOpstate && 2 != iResourceOpstate && 3 != iResourceOpstate) continue;
            return false;
        }
        return true;
    }

    public static List<String> getOperationListForCancelConfigured(Resource oRes) {
        boolean bIsTelnetSupported = true;
        DeviceTypeInfo oDeviceTypeInfo = DeviceInfoManagerImpl.getInstance().getDevice(oRes.getDeviceID()).getDeviceTypeInfo();
        String strDevTypeVerName = oDeviceTypeInfo.getDevTypeVersionName();
        if (0 == (oRes.getUpgradeMode() & 0x1000) || -1 == oRes.getUpgradeMode()) {
            bIsTelnetSupported = false;
        }
        if (bIsTelnetSupported && oDeviceTypeInfo.getDevDomain() == 2 && !strDevTypeVerName.endsWith("_telnet")) {
            oDeviceTypeInfo = DCFrameWorkUtil.addPostFixTelnet(oDeviceTypeInfo);
        }
        int[] iDeviceIdLst = new int[]{oRes.getDeviceID()};
        IDeviceTypeConfigModel oDeviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceTypeInfo, iDeviceIdLst);
        oDeviceTypeInfo = DCFrameWorkUtil.removePostFixTelnet(oDeviceTypeInfo);
        IOperationConfig oOperationConfig = oDeviceTypeConfigModel.getOperationConfiguration();
        List oTaskOprList = oOperationConfig.getTaskOperation();
        ITaskDeviceOperation oTaskDeviceOperation = null;
        ArrayList<String> oOperationList = new ArrayList<String>(0);
        for (int i = 0; i < oTaskOprList.size(); ++i) {
            oTaskDeviceOperation = (ITaskDeviceOperation)oTaskOprList.get(i);
            if (!oTaskDeviceOperation.isCancelable()) continue;
            oOperationList.add(oTaskDeviceOperation.getOperationIdString());
        }
        return oOperationList;
    }

    public static boolean checkAllBoardsFailed(String strOperation, TreeTableNode oDevNode) {
        boolean isAllBoardsFailed = true;
        Enumeration<TreeNode> oBoardNodes = oDevNode.depthFirstEnumeration();
        TreeTableNode oBoardNode = null;
        while (oBoardNodes.hasMoreElements()) {
            oBoardNode = (TreeTableNode)oBoardNodes.nextElement();
            TreeTableRowData oBoardRowData = (TreeTableRowData)oBoardNode.getUserObject();
            Resource oBoardResource = (Resource)oBoardRowData.getUserObject();
            if (!strOperation.equals(oBoardResource.getProgressInfo().getCurrentOperationId()) || oBoardResource.getProgressInfo().getResult() == 1) continue;
            isAllBoardsFailed = false;
            break;
        }
        return isAllBoardsFailed;
    }

    public static boolean checkIsTaskRunning(TreeTableNode oNode) {
        ITask oTask = TaskTableUtil.getTaskForTableNode(oNode);
        if (null == oTask) {
            return false;
        }
        TaskProgressInfo taskProgressInfo = oTask.getTaskProgressInfo();
        int iTaskOpState = taskProgressInfo.getState();
        return 0 != iTaskOpState;
    }

    public static boolean checkManualBoard(TreeTableNode oNode) {
        boolean isExistManualBoard = false;
        Enumeration<TreeNode> oBoardNodes = oNode.depthFirstEnumeration();
        TreeTableNode oBoardNode = null;
        while (oBoardNodes.hasMoreElements()) {
            oBoardNode = (TreeTableNode)oBoardNodes.nextElement();
            TreeTableRowData oBoardRowData = (TreeTableRowData)oBoardNode.getUserObject();
            Resource oBoardResource = (Resource)oBoardRowData.getUserObject();
            if (!Collator.getInstance().equals("ManualActivate", oBoardResource.getProgressInfo().getCurrentOperationId()) || oBoardResource.getProgressInfo().getState() != 1) continue;
            isExistManualBoard = true;
            break;
        }
        return isExistManualBoard;
    }

    public static boolean checkRetryDiffTaskBaseOnRollback(ITask oTask) {
        boolean bIsEnable = true;
        if (TaskInfoUtil.isDevOperAndStausInTask(oTask, "Rollback", 1)) {
            bIsEnable = !TaskInfoUtil.checkIsAllDevInSameOperAndStaus(oTask, "Rollback", 1);
        }
        return bIsEnable;
    }

    public static boolean checkUFCisFinish(THashSet<Resource> oResList) {
        boolean isUFCFinish = false;
        Resource oRes2 = null;
        Collator oEquals = Collator.getInstance();
        if (null != oResList && 0 < oResList.size()) {
            for (Resource oRes2 : oResList) {
                int currState = oRes2.getProgressInfo().getState();
                oRes2.getProgressInfo().getResult();
                if (!oEquals.equals("CheckFeasibility", oRes2.getProgressInfo().getCurrentOperationId())) continue;
                if (currState == 1) {
                    return false;
                }
                if (currState != 4) continue;
                isUFCFinish = true;
            }
        }
        return isUFCFinish;
    }

    public static JSeparator getSeparator(JPopupMenu oMenu, int iSeperatorIndex) {
        if (null == oMenu || 0 > iSeperatorIndex) {
            return null;
        }
        int iCompCount = oMenu.getComponentCount();
        int iCurrentIndex = 0;
        Component oComponent = null;
        for (int i = 0; i < iCompCount; ++i) {
            oComponent = oMenu.getComponent(i);
            if (!(oComponent instanceof JSeparator) || iSeperatorIndex != ++iCurrentIndex) continue;
            return (JSeparator)oComponent;
        }
        return null;
    }

    public static void enableAllSeparators(JPopupMenu oMenu, boolean bFlag) {
        JSeparator oSeparator = null;
        int iIndex = 1;
        do {
            if (null == (oSeparator = TaskManagementPopupMenuUtil.getSeparator(oMenu, iIndex++))) continue;
            oSeparator.setEnabled(bFlag);
            oSeparator.setVisible(bFlag);
        } while (null != oSeparator);
    }

    public static boolean isSelecDiffTask(DCSortableTreeTable m_oTaskTreeTable) {
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        boolean isSelDiffTask = false;
        TreeTableNode oNode = null;
        ITask oTask = null;
        int iTaskID = -1;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath) continue;
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            oTask = TaskTableUtil.getTaskForTableNode(oNode);
            if (-1 == iTaskID) {
                iTaskID = oTask.getTaskId();
            }
            if (iTaskID == oTask.getTaskId()) continue;
            isSelDiffTask = true;
            break;
        }
        return isSelDiffTask;
    }

    public static boolean isEnbaleQueryMenuItem(DCSortableTreeTable m_oTaskTreeTable) {
        int iTaskId = -1;
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        boolean isEnable = true;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            ITask oTask;
            TreeTableNode oNode;
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData) || null == (oTask = TaskTableUtil.getTaskForTableNode(oNode))) continue;
            if (oTask.getTaskTypeId() == 4 || oTask.getTaskTypeId() == 13 || oTask.getTaskTypeId() == 5 && oTask.getUpgradeLevel() == 1) {
                if (iTaskId == -1) {
                    iTaskId = oTask.getTaskId();
                    continue;
                }
                if (iTaskId == oTask.getTaskId()) continue;
                isEnable = false;
                break;
            }
            isEnable = false;
            break;
        }
        return isEnable;
    }

    public static boolean isEnableTelnetMenuItem(DCSortableTreeTable m_oTaskTreeTable) {
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        boolean bIsCanTelnet = false;
        TreeTableNode oNode = null;
        ITask oTask = null;
        int iTaskID = -1;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreeTableRowData oRowData;
            Resource oResource;
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath) continue;
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            oTask = TaskTableUtil.getTaskForTableNode(oNode);
            TaskProgressInfo taskProgressInfo = oTask.getTaskProgressInfo();
            int iTaskOpState = taskProgressInfo.getState();
            if (-1 == iTaskID) {
                iTaskID = oTask.getTaskId();
            }
            if (iTaskID != oTask.getTaskId() || 3 == iTaskOpState || 0 == iTaskOpState) break;
            if (!(oNode.getUserObject() instanceof TreeTableRowData) || null == (oResource = (Resource)(oRowData = (TreeTableRowData)oNode.getUserObject()).getUserObject()).getProgressInfo()) continue;
            DeviceInfo oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(oResource.getDeviceID());
            String strResourceOperation = oResource.getProgressInfo().getCurrentOperationId();
            int iDevTypeId = oDevInfo.getDeviceTypeInfo().getDevTypeID();
            if (1252 != iDevTypeId && 1335 != iDevTypeId || !oResource.isPaused() || oTask.isThirdPartySupported() || !"ActivateSoftware".equals(strResourceOperation)) continue;
            bIsCanTelnet = true;
        }
        return bIsCanTelnet;
    }

    public static boolean isEnbaleDeleteMenuItem(DCSortableTreeTable m_oTaskTreeTable) {
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        boolean isEnable = true;
        TreeTableNode oNode = null;
        ITask oTask = null;
        int iTaskID = -1;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreeTableRowData oRowData;
            Resource oResource;
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath) continue;
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            oTask = TaskTableUtil.getTaskForTableNode(oNode);
            int iTaskTypeId = oTask.getTaskTypeId();
            TaskProgressInfo taskProgressInfo = oTask.getTaskProgressInfo();
            int iTaskOpState = taskProgressInfo.getState();
            if (-1 == iTaskID) {
                iTaskID = oTask.getTaskId();
            }
            if (iTaskID != oTask.getTaskId()) {
                isEnable = false;
                break;
            }
            if (3 == iTaskOpState || 0 == iTaskOpState) {
                isEnable = false;
                break;
            }
            if (!(oNode.getUserObject() instanceof TreeTableRowData) || null == (oResource = (Resource)(oRowData = (TreeTableRowData)oNode.getUserObject()).getUserObject()).getProgressInfo()) continue;
            String strResourceOperation = oResource.getProgressInfo().getCurrentOperationId();
            DCDebugTracer.trace("strResourceOperation : " + strResourceOperation);
            int iResourceOpState = oResource.getProgressInfo().getState();
            DCDebugTracer.trace("iResourceOpState : " + iResourceOpState);
            int iResourceOpResult = oResource.getProgressInfo().getResult();
            DCDebugTracer.trace("iResourceOpResult : " + iResourceOpResult);
            if (strResourceOperation.equals("Rollback") && iResourceOpState != 1 && iResourceOpResult == 1) continue;
            if (iResourceOpState == 2 && iResourceOpResult == 1 || (4 == iTaskTypeId || 13 == iTaskTypeId) && iResourceOpState == 4) {
                Enumeration<TreeNode> oBoardNodes = oNode.depthFirstEnumeration();
                TreeTableNode oBoardNode = null;
                boolean isExistManualActivateBoards = false;
                while (oBoardNodes.hasMoreElements()) {
                    oBoardNode = (TreeTableNode)oBoardNodes.nextElement();
                    TreeTableRowData oBoardRowData = (TreeTableRowData)oBoardNode.getUserObject();
                    Resource oBoardResource = (Resource)oBoardRowData.getUserObject();
                    if (!Collator.getInstance().equals("ManualActivate", oBoardResource.getProgressInfo().getCurrentOperationId()) || oBoardResource.getProgressInfo().getState() != 1) continue;
                    isExistManualActivateBoards = true;
                    break;
                }
                if (!isExistManualActivateBoards) continue;
                isEnable = false;
                break;
            }
            if ("Rollback".equals(strResourceOperation) && iResourceOpState == 3 && iResourceOpResult == 0) continue;
            isEnable = false;
            break;
        }
        return isEnable;
    }

    public static boolean isVisibleDeleteMenuItem(DCSortableTreeTable m_oTaskTreeTable) {
        boolean bIsShowDeleteMenu = true;
        TreeTableNode oNode = null;
        ITask oTask = null;
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath) continue;
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            oTask = TaskTableUtil.getTaskForTableNode(oNode);
            int iTaskTypeId = oTask.getTaskTypeId();
            boolean bl = bIsShowDeleteMenu = 3 == iTaskTypeId || 4 == iTaskTypeId || 13 == iTaskTypeId || 5 == iTaskTypeId || 12 == iTaskTypeId;
            if (!bIsShowDeleteMenu) break;
        }
        return bIsShowDeleteMenu;
    }

    public static boolean isEnbaleCancelMenu(DCSortableTreeTable m_oTaskTreeTable) {
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        TreePath oTreePath = null;
        Resource oRes = null;
        boolean bCancelEnable = true;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData) || !((oRowData = (TreeTableRowData)oNode.getUserObject()).getUserObject() instanceof Resource)) continue;
            oRes = (Resource)oRowData.getUserObject();
            List<String> oCancelSupportedOperation = TaskManagementPopupMenuUtil.getOperationListForCancelConfigured(oRes);
            int iResourceOpState = oRes.getProgressInfo().getState();
            String strCurrentOperation = oRes.getProgressInfo().getCurrentOperationId();
            if (iResourceOpState == 1) {
                if (oCancelSupportedOperation.contains(strCurrentOperation)) continue;
                bCancelEnable = false;
                continue;
            }
            bCancelEnable = false;
        }
        return bCancelEnable;
    }

    public static boolean isVisibleCancelMenu(DCSortableTreeTable m_oTaskTreeTable) {
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        TreePath oTreePath = null;
        Resource oRes = null;
        boolean bCancelVisible = true;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            List<String> oCancelSupportedOperation;
            oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData) || !((oRowData = (TreeTableRowData)oNode.getUserObject()).getUserObject() instanceof Resource) || null != (oCancelSupportedOperation = TaskManagementPopupMenuUtil.getOperationListForCancelConfigured(oRes = (Resource)oRowData.getUserObject())) && 0 != oCancelSupportedOperation.size()) continue;
            bCancelVisible = false;
            break;
        }
        return bCancelVisible;
    }

    public static boolean isHaveFailedRes(ITask oTask) {
        boolean isHaveFailedRes = false;
        DeviceType devType = oTask.getDeviceType();
        THashSet<Resource> resLst = devType.getResources();
        if (null == resLst) {
            return isHaveFailedRes;
        }
        for (Resource res : resLst) {
            if (!res.isFailed() || IsolationCommonOperation.isIsolationState(res.getProgressInfo())) continue;
            isHaveFailedRes = true;
            break;
        }
        return isHaveFailedRes;
    }

    public static boolean isEnableNERECheckMenuItemExceptT2000(DCSortableTreeTable m_oTaskTreeTable) {
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        boolean isMenuEnable = true;
        ITask oTask = null;
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        Resource oResource = null;
        int iTaskId = -1;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData)) continue;
            oTask = TaskTableUtil.getTaskForTableNode(oNode);
            if (iTaskId == -1) {
                iTaskId = oTask.getTaskId();
            }
            if (iTaskId != oTask.getTaskId()) {
                isMenuEnable = false;
                break;
            }
            boolean bEnablePrecheck = false;
            boolean bEnablePostcheck = false;
            ICheckOperation oPrecheckOp = (ICheckOperation)TaskModelUtil.getOperationFromTask(oTask.getTaskId(), "PreCheck");
            ICheckOperation oPostcheckOp = (ICheckOperation)TaskModelUtil.getOperationFromTask(oTask.getTaskId(), "PostCheck");
            if (null != oPrecheckOp && oPrecheckOp.isSelected()) {
                bEnablePrecheck = true;
            }
            if (null != oPostcheckOp && oPostcheckOp.isSelected()) {
                bEnablePostcheck = true;
            }
            if (!bEnablePrecheck && !bEnablePostcheck) {
                return false;
            }
            oRowData = (TreeTableRowData)oNode.getUserObject();
            oResource = (Resource)oRowData.getUserObject();
            if (null == oResource.getProgressInfo()) continue;
            int iResourceOpState = oResource.getProgressInfo().getState();
            int iResourceOpResult = oResource.getProgressInfo().getResult();
            String strCurrentOperation = oResource.getProgressInfo().getCurrentOperationId();
            if (Collator.getInstance().equals(strCurrentOperation, "PreCheck")) {
                if (iResourceOpState == 3 && iResourceOpResult == 0 && TaskManagementPopupMenuUtil.isOtherOprSelAferCheck(oNode, "PreCheck")) continue;
                isMenuEnable = false;
                break;
            }
            if (TaskTableUtil.isNextOprOfPreCheck(oNode, strCurrentOperation)) {
                if (4 == iResourceOpState) {
                    isMenuEnable = true;
                    continue;
                }
                if (Collator.getInstance().equals(strCurrentOperation, "PostCheck")) {
                    if (iResourceOpState == 3 && iResourceOpResult == 0) continue;
                    isMenuEnable = false;
                    break;
                }
                isMenuEnable = false;
                break;
            }
            if (Collator.getInstance().equals(strCurrentOperation, "PostCheck")) {
                if (iResourceOpState == 3 && iResourceOpResult == 0) continue;
                isMenuEnable = false;
                break;
            }
            isMenuEnable = false;
            break;
        }
        return isMenuEnable;
    }

    private static boolean isOtherOprSelAferCheck(TreeTableNode oSelectedNode, String strCurrentOperation) {
        ITask oTask = TaskTableUtil.getTaskForTableNode(oSelectedNode);
        List<ITaskDeviceOperation> oTaskOprLst = oTask.getSupportedOperation();
        boolean isFindCheck = false;
        boolean isOtherOprSelAferCheck = false;
        for (ITaskDeviceOperation oTaskOpr : oTaskOprLst) {
            String strOprId = oTaskOpr.getOperationIdString();
            if (oTaskOpr.isSelected() && strCurrentOperation.equals(strOprId)) {
                isFindCheck = true;
                continue;
            }
            if (!isFindCheck || !oTaskOpr.isSelected()) continue;
            isOtherOprSelAferCheck = true;
            break;
        }
        return isOtherOprSelAferCheck;
    }

    public static boolean isEnableModifySingleNEActiveGroupMenu(DCSortableTreeTable m_oTaskTreeTable) {
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (1 != arrSelectedRows.length) {
            return false;
        }
        TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[0]);
        if (null == oTreePath) {
            return false;
        }
        TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
        if (!(oNode.getUserObject() instanceof TreeTableRowData)) {
            return false;
        }
        boolean isEnableMenu = true;
        ITask oTask = TaskTableUtil.getTaskForTableNode(oNode);
        if (null != oTask && oTask.getTaskProgressInfo().getState() == 3) {
            return false;
        }
        if (null != oTask) {
            List<DeviceTypeInfo> devType = oTask.getDeviceTypeLst();
            for (int i = 0; i < devType.size(); ++i) {
                DeviceTypeInfo devTypeInfo = devType.get(i);
                if (4 == devTypeInfo.getDevDomain()) continue;
                isEnableMenu = false;
                break;
            }
            if (isEnableMenu && (oTask.getTaskTypeId() == 4 || oTask.getTaskTypeId() == 13)) {
                TreeTableRowData resRowData = (TreeTableRowData)oNode.getUserObject();
                if (null == resRowData) {
                    return false;
                }
                Resource res = (Resource)resRowData.getUserObject();
                if (null == res) {
                    return false;
                }
                int state = res.getProgressInfo().getState();
                return 1 != state;
            }
        }
        return false;
    }
}

