/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.common.util.DeviceOperationAdapter;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOtherOperation;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperation;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.LoadSimPackageInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.TaskProgressInfo;
import com.huawei.dc.taskmgmt.view.common.TaskManagementPopupMenuUtil;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTableUtil;
import gnu.trove.THashSet;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;

public class TaskManagementPopupMenuManagerHelper {
    public static boolean isEnableNERECheckMenuItemForT2000(DCSortableTreeTable m_oTaskTreeTable) {
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        boolean isMenuEnable = true;
        ITask oTask = null;
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        Resource oResource = null;
        int iTaskId = -1;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData)) continue;
            oTask = TaskTableUtil.getTaskForTableNode(oNode);
            if (iTaskId == -1) {
                iTaskId = oTask.getTaskId();
            }
            if (iTaskId != oTask.getTaskId() || oTask.getTaskProgressInfo().getState() == 3) {
                isMenuEnable = false;
                break;
            }
            oRowData = (TreeTableRowData)oNode.getUserObject();
            oResource = (Resource)oRowData.getUserObject();
            if (null == oResource.getProgressInfo()) continue;
            int iResourceOpState = oResource.getProgressInfo().getState();
            int iResourceOpResult = oResource.getProgressInfo().getResult();
            String strCurrentOperation = oResource.getProgressInfo().getCurrentOperationId();
            if (Collator.getInstance().equals(strCurrentOperation, "PostCheck")) {
                if (iResourceOpState == 3 && iResourceOpResult == 0) {
                    if (!TaskManagementPopupMenuUtil.checkManualBoard(oNode)) continue;
                    isMenuEnable = false;
                    break;
                }
                isMenuEnable = false;
                break;
            }
            if (TaskTableUtil.isNextOprOfPostCheck(oNode, strCurrentOperation)) {
                if (4 == iResourceOpState) {
                    isMenuEnable = true;
                    continue;
                }
                isMenuEnable = false;
                break;
            }
            isMenuEnable = false;
        }
        return isMenuEnable;
    }

    public static boolean isEnableNEContinueMenuForMimic(DCSortableTreeTable m_oTaskTreeTable) {
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        boolean isMenuEnable = true;
        ITask oTask = null;
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        Resource oResource = null;
        int iTaskId = -1;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData)) continue;
            oTask = TaskTableUtil.getTaskForTableNode(oNode);
            if (iTaskId == -1) {
                iTaskId = oTask.getTaskId();
            }
            if (iTaskId != oTask.getTaskId() || oTask.getTaskProgressInfo().getState() == 3) {
                isMenuEnable = false;
                break;
            }
            THashSet<Resource> resList = oTask.getDeviceType().getResources();
            String currentOperation = "";
            boolean isAllNEPauseDBeforeSameOper = true;
            for (Resource oRes : resList) {
                if ("".equals(currentOperation)) {
                    currentOperation = oRes.getProgressInfo().getCurrentOperationId();
                }
                if (oRes.getProgressInfo().getCurrentOperationId().equals(currentOperation) && oRes.getProgressInfo().getState() == 4) continue;
                isAllNEPauseDBeforeSameOper = false;
                break;
            }
            if (isAllNEPauseDBeforeSameOper) {
                isMenuEnable = false;
                break;
            }
            oRowData = (TreeTableRowData)oNode.getUserObject();
            oResource = (Resource)oRowData.getUserObject();
            if (null == oResource.getProgressInfo()) continue;
            int iResourceOpState = oResource.getProgressInfo().getState();
            String iCurrentOperation = oResource.getProgressInfo().getCurrentOperationId();
            if (4 == iResourceOpState && !Collator.getInstance().equals(iCurrentOperation, "ActivateSoftware")) {
                isMenuEnable = true;
                continue;
            }
            isMenuEnable = false;
            break;
        }
        return isMenuEnable;
    }

    public static boolean isEnableNERetryMenuForMimic(DCSortableTreeTable m_oTaskTreeTable) {
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        boolean isMenuEnable = true;
        ITask oTask = null;
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        Resource oResource = null;
        int iTaskId = -1;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData)) continue;
            oTask = TaskTableUtil.getTaskForTableNode(oNode);
            if (iTaskId == -1) {
                iTaskId = oTask.getTaskId();
            }
            if (iTaskId != oTask.getTaskId() || oTask.getTaskProgressInfo().getState() == 3) {
                isMenuEnable = false;
                break;
            }
            oRowData = (TreeTableRowData)oNode.getUserObject();
            oResource = (Resource)oRowData.getUserObject();
            if (null == oResource.getProgressInfo()) continue;
            int iResourceOpResult = oResource.getProgressInfo().getResult();
            int iResourceOpState = oResource.getProgressInfo().getState();
            String iCurrentOperation = oResource.getProgressInfo().getCurrentOperationId();
            if (Collator.getInstance().equals(iCurrentOperation, "Rollback")) {
                isMenuEnable = false;
                break;
            }
            if (iResourceOpState == 2 && 1 == iResourceOpResult) {
                if (!Collator.getInstance().equals(iCurrentOperation, "ActivateSoftware")) continue;
                isMenuEnable = false;
                break;
            }
            isMenuEnable = false;
            break;
        }
        return isMenuEnable;
    }

    public static boolean isEnableNENextMenuForT2000ExceptMimic(DCSortableTreeTable m_oTaskTreeTable) {
        boolean isMenuEnable = false;
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return isMenuEnable;
        }
        String[] SUPPORT_NEXT_OPERATIONS = new String[]{"Backup", "PreCheck", "PostCheck"};
        int iTaskId = 0;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            String strCurrentOperation;
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath) continue;
            TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            ITask oTask = TaskTableUtil.getTaskForTableNode(oNode);
            int iTaskTypeId = oTask.getTaskTypeId();
            if (0 == iTaskId) {
                iTaskId = oTask.getTaskId();
            } else if (iTaskId != oTask.getTaskId()) {
                isMenuEnable = false;
                break;
            }
            if (oTask.getTaskProgressInfo().getState() == 3) {
                isMenuEnable = false;
                return isMenuEnable;
            }
            if (4 != iTaskTypeId && 13 != iTaskTypeId && 11 != iTaskTypeId && 5 != iTaskTypeId) {
                return isMenuEnable;
            }
            if (!(oNode.getUserObject() instanceof TreeTableRowData)) continue;
            TreeTableRowData oRowData = (TreeTableRowData)oNode.getUserObject();
            Resource oResource = (Resource)oRowData.getUserObject();
            if (null == oResource.getProgressInfo() || StringUtils.isNullOrEmptyStr(strCurrentOperation = oResource.getProgressInfo().getCurrentOperationId())) break;
            boolean contains = false;
            for (String step : SUPPORT_NEXT_OPERATIONS) {
                if (!strCurrentOperation.equals(step)) continue;
                contains = true;
            }
            if (!contains) break;
            boolean isNotLastOperation = !TaskTableUtil.isLastOperation(oNode, strCurrentOperation);
            isMenuEnable = !oTask.isInProgress() && isNotLastOperation && (oResource.isFailed() || oResource.isPaused());
            if (!isMenuEnable) break;
        }
        return isMenuEnable;
    }

    public static boolean isEnableNENextMenuForMimic(DCSortableTreeTable m_oTaskTreeTable) {
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        boolean isMenuEnable = true;
        ITask oTask = null;
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        Resource oResource = null;
        int iTaskId = -1;
        String strLastOpertionID = "";
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData)) continue;
            oTask = TaskTableUtil.getTaskForTableNode(oNode);
            if (iTaskId == -1) {
                iTaskId = oTask.getTaskId();
            }
            if (iTaskId != oTask.getTaskId() || oTask.getTaskProgressInfo().getState() == 3) {
                isMenuEnable = false;
                break;
            }
            if ("".equals(strLastOpertionID)) {
                List<ITaskDeviceOperation> operList = oTask.getSupportedOperation();
                for (ITaskDeviceOperation oTaskOper : operList) {
                    if (!oTaskOper.isSelected()) continue;
                    strLastOpertionID = oTaskOper.getOperationIdString();
                }
            }
            if (null == (oResource = (Resource)(oRowData = (TreeTableRowData)oNode.getUserObject()).getUserObject()).getProgressInfo()) continue;
            int iResourceOpResult = oResource.getProgressInfo().getResult();
            int iResourceOpState = oResource.getProgressInfo().getState();
            String strCurrentOperation = oResource.getProgressInfo().getCurrentOperationId();
            if (Collator.getInstance().equals(strCurrentOperation, "Rollback") || Collator.getInstance().equals(strCurrentOperation, strLastOpertionID)) {
                isMenuEnable = false;
                break;
            }
            if (iResourceOpState == 2 && 1 == iResourceOpResult) {
                if (Collator.getInstance().equals("LoadSoftware", strCurrentOperation)) {
                    boolean isAllBoardsLoadFailed = TaskManagementPopupMenuUtil.checkAllBoardsFailed("LoadSoftware", oNode);
                    if (!isAllBoardsLoadFailed) continue;
                    isMenuEnable = false;
                    break;
                }
                if (!Collator.getInstance().equals("ActivateSoftware", strCurrentOperation)) continue;
                if (!TaskManagementPopupMenuUtil.checkManualBoard(oNode)) {
                    boolean isAllBoardActivateFailed = TaskManagementPopupMenuUtil.checkAllBoardsFailed("ActivateSoftware", oNode);
                    boolean isAllBoardManualActivateFailed = TaskManagementPopupMenuUtil.checkAllBoardsFailed("ManualActivate", oNode);
                    if (!isAllBoardActivateFailed || !isAllBoardManualActivateFailed) continue;
                    isMenuEnable = false;
                    break;
                }
                isMenuEnable = false;
                break;
            }
            if (Collator.getInstance().equals(strCurrentOperation, "ActivateSoftware") && 4 == iResourceOpState) {
                boolean isExistManualBoard = TaskManagementPopupMenuUtil.checkManualBoard(oNode);
                if (!isExistManualBoard) continue;
                isMenuEnable = false;
                break;
            }
            isMenuEnable = false;
            break;
        }
        return isMenuEnable;
    }

    public static boolean isEnableNENextMenuForIP(DCSortableTreeTable m_oTaskTreeTable) {
        boolean isMenuEnable = false;
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return isMenuEnable;
        }
        int iTaskId = 0;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            boolean isNotLastOperation;
            String strCurrentOperation;
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath) continue;
            TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            ITask oTask = TaskTableUtil.getTaskForTableNode(oNode);
            if (0 == iTaskId) {
                iTaskId = oTask.getTaskId();
            } else if (iTaskId != oTask.getTaskId()) {
                isMenuEnable = false;
                break;
            }
            if (!(oNode.getUserObject() instanceof TreeTableRowData)) continue;
            TreeTableRowData oRowData = (TreeTableRowData)oNode.getUserObject();
            Resource oResource = (Resource)oRowData.getUserObject();
            if (null == oResource.getProgressInfo() || StringUtils.isNullOrEmptyStr(strCurrentOperation = oResource.getProgressInfo().getCurrentOperationId())) break;
            DeviceInfo oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(oResource.getDeviceID());
            if (!oDevInfo.getDeviceTypeInfo().isDMSDomain()) {
                return isMenuEnable;
            }
            String[] controlSteps = DeviceOperationAdapter.getInstance().getControlSteps("NextStepOperation", oDevInfo.getDeviceTypeInfo().getDevTypeID());
            if (null == controlSteps) break;
            boolean contains = false;
            for (String step : controlSteps) {
                if (!strCurrentOperation.equals(step)) continue;
                contains = true;
            }
            if (!contains) break;
            boolean isTelnet = true;
            boolean isCluster = false;
            if (oDevInfo.getDeviceTypeInfo().getDevTypeID() == 1252 || oDevInfo.getDeviceTypeInfo().getDevTypeID() == 1335) {
                oDevInfo.setUpgradeMode(oResource.getUpgradeMode());
                isTelnet = DeviceInfoUtil.isSupportUpgradeMode(oDevInfo, 4096);
                isCluster = DeviceInfoUtil.isClusterNE(oDevInfo);
            }
            if (!(isMenuEnable = (isNotLastOperation = !TaskTableUtil.isLastOperation(oNode, strCurrentOperation)) && oResource.isFailed() && isTelnet && !isCluster)) break;
        }
        return isMenuEnable;
    }

    public static boolean isEnableRetryMenu(TreeTableNode oNode, boolean isBoardLevel) {
        if (!(oNode.getUserObject() instanceof TreeTableRowData)) {
            return false;
        }
        TreeTableRowData oRowData = (TreeTableRowData)oNode.getUserObject();
        Resource oResource = (Resource)oRowData.getUserObject();
        if (null == oResource.getProgressInfo()) {
            return false;
        }
        int iResourceOpState = oResource.getProgressInfo().getState();
        int iResourceOpResult = oResource.getProgressInfo().getResult();
        String strCurrentOperation = oResource.getProgressInfo().getCurrentOperationId();
        if (Collator.getInstance().equals("Rollback", strCurrentOperation)) {
            return false;
        }
        if (Collator.getInstance().equals("CheckFeasibility", strCurrentOperation) && iResourceOpResult == 0) {
            return false;
        }
        ITask oTask = TaskTableUtil.getTaskForTableNode(oNode);
        if (null == oTask) {
            return false;
        }
        DeviceType deviceTypeo = oTask.getDeviceType();
        if (4 == deviceTypeo.getDeviceDomain()) {
            TaskProgressInfo taskProgressInfo;
            int iTaskOpState;
            if (!(oTask.getTaskTypeId() != 5 && oTask.getTaskTypeId() != 11 || 3 != (iTaskOpState = (taskProgressInfo = oTask.getTaskProgressInfo()).getState()) && 0 != iTaskOpState)) {
                return false;
            }
            THashSet<Resource> resList = oTask.getDeviceType().getResources();
            if (resList.size() == 1 && iResourceOpState == 2 && iResourceOpResult != 0 && oTask.getTaskTypeId() == 3) {
                return !Collator.getInstance().equals("ActivateSoftware", strCurrentOperation);
            }
            if (isBoardLevel) {
                return false;
            }
            int iTaskOpResult = oTask.getTaskProgressInfo().getResult();
            int iTaskOpState2 = oTask.getTaskProgressInfo().getState();
            return (iTaskOpState2 == 4 && iTaskOpResult == 2 || iTaskOpState2 == 2 && iTaskOpResult == 1) && iResourceOpState == 2 && iResourceOpResult == 1;
        }
        return iResourceOpState == 2 && iResourceOpResult == 1;
    }

    public static boolean isRollbackMenuEnabled(DCSortableTreeTable m_oTaskTreeTable) {
        DCDebugTracer.trace("DC:: rollback isRollbackMenuEnabled start");
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        TreeTableNode oNode = null;
        boolean dmsRollback = true;
        boolean t2000Rollback = true;
        boolean accessRollback = true;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            TreeTableRowData oNodeInfo = (TreeTableRowData)oNode.getUserObject();
            Resource oResource = (Resource)oNodeInfo.getUserObject();
            int iDevID = oResource.getDeviceID();
            DeviceInfo oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(iDevID);
            DeviceTypeInfo oDevTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(oDevInfo.getDeviceTypeInfo().getDevTypeID(), oDevInfo.getDeviceTypeInfo().getDevTypeVersionId());
            ITask oTask = TaskTableUtil.getTaskForTableNode(oNode);
            ResourceProgressInfo oResProgressInfo = oResource.getProgressInfo();
            String operationId = oResProgressInfo.getCurrentOperationId();
            DCDebugTracer.trace("DC:: rollback operationId " + operationId);
            DCDebugTracer.trace("DC:: rollback state " + oResProgressInfo.getState());
            DCDebugTracer.trace("DC:: rollback result " + oResProgressInfo.getResult());
            if (null != oDevTypeInfo && oDevTypeInfo.isDMSDomain()) {
                DCDebugTracer.trace("DC:: rollback isRollbackMenuEnabled end..");
                dmsRollback = TaskManagementPopupMenuManagerHelper.isRollbackMenuEnabledForDMS(m_oTaskTreeTable, oDevTypeInfo, oResProgressInfo, oTask, oResource);
                if (dmsRollback) continue;
                break;
            }
            if (null != oDevTypeInfo && oDevTypeInfo.isT2000Domain()) {
                DCDebugTracer.trace("DC:: rollback isRollbackMenuEnabled end..");
                t2000Rollback = TaskManagementPopupMenuManagerHelper.isRollbackMenuEnabledForT2000(m_oTaskTreeTable, oTask, oResProgressInfo, oResource, oNode);
                if (t2000Rollback) continue;
                break;
            }
            DCDebugTracer.trace("DC:: rollback isRollbackMenuEnabled end..");
            accessRollback = false;
            break;
        }
        DCDebugTracer.trace("DC:: rollback isRollbackMenuEnabled end..");
        return dmsRollback && t2000Rollback && accessRollback;
    }

    private static boolean isRollbackMenuEnabledForDMS(DCSortableTreeTable m_oTaskTreeTable, DeviceTypeInfo oDevTypeInfo, ResourceProgressInfo oResProgressInfo, ITask oTask, Resource oResource) {
        DCDebugTracer.trace("DC:: rollback DevDomain " + oDevTypeInfo.getDevDomain());
        String operationId = oResProgressInfo.getCurrentOperationId();
        if (1304 == oDevTypeInfo.getDevTypeID()) {
            return false;
        }
        if (0 == oResProgressInfo.getState() || oResProgressInfo.getState() == 2 && oResProgressInfo.getResult() == 1 || 2 == oResProgressInfo.getResult() && 4 == oResProgressInfo.getState()) {
            return false;
        }
        if (2 == oTask.getTaskTypeId()) {
            if (!TaskManagementPopupMenuUtil.isLoadPatchSelected(oTask)) {
                return false;
            }
        } else {
            ResourceProgressInfo oLoadProgressInfo = oResource.getOprResultInfo("LoadSoftware");
            ResourceProgressInfo oActivateProgressInfo = oResource.getOprResultInfo("ActivateSoftware");
            if (!TaskManagementPopupMenuUtil.isLoadSoftwareSelected(oTask) || !TaskManagementPopupMenuUtil.isActivateSelected(oTask)) {
                return false;
            }
            if (null == oLoadProgressInfo || null == oActivateProgressInfo) {
                return false;
            }
            if (3 != oLoadProgressInfo.getState() || 0 != oLoadProgressInfo.getResult() || 3 != oActivateProgressInfo.getState() || 0 != oActivateProgressInfo.getResult()) {
                return false;
            }
            if (!TaskManagementPopupMenuManagerHelper.isRollbackSupportedForSelectedDevices(m_oTaskTreeTable)) {
                DCDebugTracer.trace("levelive for the justice of rollback menu item, we said it not availabilityfalse");
                return false;
            }
        }
        return !operationId.equals("Rollback");
    }

    private static boolean isRollbackMenuEnabledForT2000PauseTask(DCSortableTreeTable m_oTaskTreeTable, ITask oTask, ResourceProgressInfo oResProgressInfo, Resource oResource) {
        String operationId = oResProgressInfo.getCurrentOperationId();
        if (2 == oTask.getTaskTypeId()) {
            return false;
        }
        if (3 == oTask.getTaskTypeId()) {
            LoadSimPackageInfo oLoadSimPackageInfo = oTask.getLoadSimPackageInfo();
            if (oLoadSimPackageInfo != null && "".equals(oTask.getLoadAllPath(1, oLoadSimPackageInfo))) {
                return false;
            }
            if (operationId.equals("ActivateSoftware")) {
                if (oResProgressInfo.getState() == 1) {
                    return false;
                }
            } else {
                int actResult;
                if (operationId.equals("Rollback")) {
                    return false;
                }
                if (operationId.equals("LoadSoftware")) {
                    return false;
                }
                ResourceProgressInfo actProgressInfo = oResource.getOprResultInfo("ActivateSoftware");
                if (null != actProgressInfo && 0 == (actResult = actProgressInfo.getResult())) {
                    return true;
                }
            }
        } else {
            if (oTask.getTaskTypeId() == 13 || oTask.getTaskTypeId() == 4) {
                return TaskTableUtil.isRollbackEnableT2kPkgTask(m_oTaskTreeTable);
            }
            if (oTask.getTaskTypeId() == 11 || oTask.getTaskTypeId() == 5) {
                ResourceProgressInfo loadProgressInfo = null;
                ResourceProgressInfo dispenseProgressInfo = null;
                ResourceProgressInfo actProgressInfo = null;
                loadProgressInfo = oResource.getOprResultInfo("LoadSoftware");
                dispenseProgressInfo = oResource.getOprResultInfo("Dispense");
                actProgressInfo = oResource.getOprResultInfo("ActivateSoftware");
                if (null != loadProgressInfo && loadProgressInfo.getState() != 0) {
                    int result = loadProgressInfo.getResult();
                    if (0 == result || 1 == result) {
                        return true;
                    }
                    if (4 == loadProgressInfo.getState() && 2 == result) {
                        return false;
                    }
                } else if (null != dispenseProgressInfo && dispenseProgressInfo.getState() != 0) {
                    int result = dispenseProgressInfo.getResult();
                    if (0 == result || 1 == result) {
                        return true;
                    }
                } else if (null != actProgressInfo && actProgressInfo.getState() != 0) {
                    int result = actProgressInfo.getResult();
                    if (0 == result || 1 == result) {
                        return true;
                    }
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isRollbackMenuEnabledForT2000RunningAndInProgressTask(DCSortableTreeTable m_oTaskTreeTable, ITask oTask, ResourceProgressInfo oResProgressInfo, Resource oResource, TreeTableNode oNode) {
        String operationId = oResProgressInfo.getCurrentOperationId();
        if (2 == oTask.getTaskTypeId()) {
            return false;
        }
        if (3 == oTask.getTaskTypeId()) {
            LoadSimPackageInfo oLoadSimPackageInfo = oTask.getLoadSimPackageInfo();
            if (oLoadSimPackageInfo != null && "".equals(oTask.getLoadAllPath(1, oLoadSimPackageInfo))) {
                return false;
            }
            if (operationId.equals("ActivateSoftware")) {
                if (oResProgressInfo.getState() == 2 && oResProgressInfo.getResult() == 1) return true;
                return false;
            }
            if (operationId.equals("LoadSoftware")) {
                return oResProgressInfo.getState() != 1;
            }
            if (operationId.equals("Rollback")) {
                return false;
            }
            ResourceProgressInfo actProgressInfo = oResource.getOprResultInfo("ActivateSoftware");
            if (null == actProgressInfo) return false;
            int actResult = actProgressInfo.getResult();
            int actState = actProgressInfo.getState();
            if (0 == actState) {
                return false;
            }
            if (0 != actResult) return true;
            return true;
        }
        if (oTask.getTaskTypeId() == 13 || oTask.getTaskTypeId() == 4) {
            if (!operationId.equals("ActivateSoftware") && !operationId.equals("Dispense") && !operationId.equals("PostCheck") || oResProgressInfo.getState() != 1) return TaskTableUtil.isRollbackEnableT2kPkgTask(m_oTaskTreeTable);
            return false;
        }
        if (11 == oTask.getTaskTypeId() && oTask.getUpgradeLevel() == 2) {
            if (operationId.equals("ActivateSoftware")) {
                if (oResProgressInfo.getState() == 1) {
                    return false;
                }
                if (TaskManagementPopupMenuUtil.isFinishOperationForAllDev(oNode, "ActivateSoftware")) return true;
                return false;
            }
            if (operationId.equals("Dispense")) {
                if (oResProgressInfo.getState() != 1) return true;
                return false;
            }
            if (!operationId.equals("LoadSoftware")) return false;
            if (oResProgressInfo.getState() == 1) {
                return false;
            }
            if (TaskManagementPopupMenuUtil.isFinishOperationForAllDev(oNode, "LoadSoftware")) return true;
            return false;
        }
        if (!operationId.equals("LoadSoftware") && !operationId.equals("Dispense") && !operationId.equals("ActivateSoftware") && !operationId.equals("Recover") && !operationId.equals("Rollback")) return false;
        if (!(operationId.equals("ActivateSoftware") ? !TaskManagementPopupMenuUtil.isFinishOperationForAllDev(oNode, "ActivateSoftware") : (operationId.equals("LoadSoftware") ? !TaskManagementPopupMenuUtil.isFinishOperationForAllDev(oNode, "LoadSoftware") : (operationId.equals("Dispense") ? oResProgressInfo.getState() == 1 : operationId.equals("Rollback") && oResProgressInfo.getState() == 1)))) return true;
        return false;
    }

    private static boolean isRollbackMenuEnabledForT2000(DCSortableTreeTable m_oTaskTreeTable, ITask oTask, ResourceProgressInfo oResProgressInfo, Resource oResource, TreeTableNode oNode) {
        TaskProgressInfo oTaskProgress = oTask.getTaskProgressInfo();
        if (null != oTaskProgress && oTaskProgress.getState() == 3 || null != oTaskProgress && oTaskProgress.getState() == 0) {
            return false;
        }
        if (null != oTaskProgress && oTaskProgress.getState() == 4) {
            return TaskManagementPopupMenuManagerHelper.isRollbackMenuEnabledForT2000PauseTask(m_oTaskTreeTable, oTask, oResProgressInfo, oResource);
        }
        return TaskManagementPopupMenuManagerHelper.isRollbackMenuEnabledForT2000RunningAndInProgressTask(m_oTaskTreeTable, oTask, oResProgressInfo, oResource, oNode);
    }

    public static boolean isRollbackSupportedByState(DCSortableTreeTable m_oTaskTreeTable) {
        boolean bRollbackSupported = true;
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        TreeTableNode oNode = null;
        TreePath oTreePath = null;
        TreeTableRowData oRowData = null;
        Resource oResource = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData)) continue;
            oRowData = (TreeTableRowData)oNode.getUserObject();
            oResource = (Resource)oRowData.getUserObject();
            int iDevID = oResource.getDeviceID();
            THashSet<Resource> lstCurrTaskResource = TaskTableUtil.getSelectedResources(m_oTaskTreeTable);
            Resource currResource2 = null;
            for (Resource currResource2 : lstCurrTaskResource) {
                if (currResource2.getDeviceID() == iDevID) continue;
            }
            if (null == currResource2) {
                bRollbackSupported = false;
                return bRollbackSupported;
            }
            if (currResource2.getProgressInfo().getState() != 2) continue;
            bRollbackSupported = false;
            return bRollbackSupported;
        }
        return bRollbackSupported;
    }

    public static boolean isRollbackSupportedForSelectedDevices(DCSortableTreeTable m_oTaskTreeTable) {
        boolean bRollbackSupported = true;
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        TreeTableNode oNode = null;
        TreePath oTreePath = null;
        TreeTableRowData oRowData = null;
        Resource oResource = null;
        DeviceTypeInfo oDeviceTypeInfo = null;
        IDeviceTypeConfigModel deviceTypeConfigModel = null;
        IOtherOperation oOperationObj = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData)) continue;
            oRowData = (TreeTableRowData)oNode.getUserObject();
            oResource = (Resource)oRowData.getUserObject();
            int iDevID = oResource.getDeviceID();
            DeviceInfo devInfo = DeviceInfoManagerImpl.getInstance().getDevice(iDevID);
            if (null == devInfo) {
                DCDebugTracer.trace("isRollbackSupportedForSelectedDevices:devInfo = null,devId=" + iDevID);
                return false;
            }
            oDeviceTypeInfo = devInfo.getDeviceTypeInfo();
            if (null == oDeviceTypeInfo) {
                DCDebugTracer.trace("isRollbackSupportedForSelectedDevices:oDeviceTypeInfo = null");
                return false;
            }
            if (0 != (oResource.getUpgradeMode() & 0x1000) && oDeviceTypeInfo.getDevDomain() == 2) {
                oDeviceTypeInfo = DCFrameWorkUtil.addPostFixTelnet(oDeviceTypeInfo);
            }
            int[] iDeviceIdLst = new int[]{oResource.getDeviceID()};
            deviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceTypeInfo, iDeviceIdLst);
            oDeviceTypeInfo = DCFrameWorkUtil.removePostFixTelnet(oDeviceTypeInfo);
            if (null == deviceTypeConfigModel) {
                DCDebugTracer.trace("isRollbackSupportedForSelectedDevices:deviceTypeConfigModel = null");
                return false;
            }
            oOperationObj = (IOtherOperation)deviceTypeConfigModel.getOperationObj(5, 21);
            if (null == oOperationObj) {
                DCDebugTracer.trace("isRollbackSupportedForSelectedDevices:oOperationObj = null");
                return false;
            }
            if (oOperationObj.isSupported()) continue;
            bRollbackSupported = false;
            break;
        }
        return bRollbackSupported;
    }

    public static boolean controlModifyMenuForMimicPackageTask(ITask oTask) {
        if (null == oTask) {
            return false;
        }
        boolean isIncludeActiveOperation = false;
        List<ITaskDeviceOperation> oSuppOprList = oTask.getSupportedOperation();
        for (ITaskDeviceOperation oDevOp : oSuppOprList) {
            if (!(oDevOp instanceof ActivationOperation)) continue;
            if (!oDevOp.isSelected()) break;
            isIncludeActiveOperation = true;
            break;
        }
        if (!isIncludeActiveOperation) {
            return false;
        }
        THashSet<Resource> resourceList = oTask.getTemporaryDevType().getResources();
        for (Resource res : resourceList) {
            if (!(res.getSlotId() > 0 ? Collator.getInstance().equals(res.getProgressInfo().getCurrentOperationId(), "ActivateSoftware") || Collator.getInstance().equals(res.getProgressInfo().getCurrentOperationId(), "ManualActivate") : Collator.getInstance().equals(res.getProgressInfo().getCurrentOperationId(), "PostCheck"))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEnableContinueTaskMenuForUFC(DCSortableTreeTable m_oTaskTreeTable) {
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        TreeTableNode oNode = null;
        TreePath oTreePath = null;
        TreeTableRowData oRowData = null;
        ITask oTask = null;
        THashSet<Resource> oResList = null;
        Collator.getInstance();
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || null == (oNode = (TreeTableNode)oTreePath.getLastPathComponent()) || !(oNode.getUserObject() instanceof TreeTableRowData) || null == (oRowData = (TreeTableRowData)oNode.getUserObject()) || null == (oTask = (ITask)oRowData.getUserObject())) continue;
            oResList = oTask.getDeviceType().getResources();
        }
        return TaskManagementPopupMenuUtil.checkUFCisFinish(oResList);
    }

    public static boolean isEnableActivateManuallyMenuItemForBoard(DCSortableTreeTable m_oTaskTreeTable) {
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        boolean isMenuEnable = true;
        TreeTableNode oNode = null;
        ITask oTask = null;
        int iDeviceID = 0;
        int iTaskID = 0;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData)) continue;
            oTask = TaskTableUtil.getTaskForTableNode(oNode);
            if (3 != oTask.getTaskTypeId()) {
                isMenuEnable = false;
                break;
            }
            if (0 == iTaskID) {
                iTaskID = oTask.getTaskId();
            }
            if (oTask.getTaskProgressInfo().getState() == 3 || iTaskID != oTask.getTaskId()) {
                isMenuEnable = false;
                break;
            }
            TreeTableRowData oRowData = (TreeTableRowData)oNode.getUserObject();
            TreeTableNode oDevNode = (TreeTableNode)oNode.getParent();
            TreeTableRowData oDevRowData = (TreeTableRowData)oDevNode.getUserObject();
            Object oDevObj = oDevRowData.getUserObject();
            Resource oDevResource = (Resource)oDevObj;
            String sDevOperID = oDevResource.getProgressInfo().getCurrentOperationId();
            int iResourceState = oDevResource.getProgressInfo().getState();
            if (iDeviceID == 0) {
                iDeviceID = oDevResource.getDeviceID();
            }
            if (iDeviceID != oDevResource.getDeviceID()) {
                isMenuEnable = false;
                break;
            }
            if (("ActivateSoftware".equals(sDevOperID) || "PostCheck".equals(sDevOperID)) && iResourceState != 1) {
                Object obj = oRowData.getUserObject();
                if (!(obj instanceof Resource)) {
                    isMenuEnable = false;
                    break;
                }
                Resource oResource = (Resource)obj;
                ResourceProgressInfo oProgressInfo = oResource.getProgressInfo();
                String sBoardCurOperID = oProgressInfo.getCurrentOperationId();
                int iResult = oProgressInfo.getResult();
                if ("LoadSoftware".equals(sBoardCurOperID) && iResult == 0 || ("ActivateSoftware".equals(sBoardCurOperID) || "ManualActivate".equals(sBoardCurOperID)) && iResult == 1) continue;
                isMenuEnable = false;
                break;
            }
            isMenuEnable = false;
            break;
        }
        return isMenuEnable;
    }

    public static boolean isSelectedIsolationResource(DCSortableTreeTable m_oTaskTreeTable) {
        boolean isContainIsolationRes = false;
        if (0 == m_oTaskTreeTable.getRowCount()) {
            return isContainIsolationRes;
        }
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return isContainIsolationRes;
        }
        TreeTableNode oNode = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreeTableRowData oRowData;
            Resource oResource;
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData) || null == (oResource = (Resource)(oRowData = (TreeTableRowData)oNode.getUserObject()).getUserObject()).getProgressInfo() || !IsolationCommonOperation.isIsolationState(oResource.getProgressInfo()) && !IsolationCommonOperation.isIsolationStateForDownGrade(oResource.getProgressInfo())) continue;
            isContainIsolationRes = true;
            break;
        }
        return isContainIsolationRes;
    }

    public static boolean isEnableRetryMenuItem(DCSortableTreeTable m_oTaskTreeTable, boolean isBoardLevel) {
        if (0 == m_oTaskTreeTable.getRowCount()) {
            return false;
        }
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        boolean isEnableForRetryMenuItem = true;
        TreeTableNode oNode = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreeTableRowData oRowData;
            Resource oResource;
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath) continue;
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            if (!TaskManagementPopupMenuUtil.checkIsTaskRunning(oNode)) {
                isEnableForRetryMenuItem = false;
                break;
            }
            if (oNode.getUserObject() instanceof TreeTableRowData && null != (oResource = (Resource)(oRowData = (TreeTableRowData)oNode.getUserObject()).getUserObject()).getProgressInfo() && !(isEnableForRetryMenuItem = TaskManagementPopupMenuManagerHelper.isEnableRetryMenu(oNode, isBoardLevel))) break;
        }
        return isEnableForRetryMenuItem;
    }

    public static boolean isVisibleRollbackMenu(DCSortableTreeTable oTaskTreeTable) {
        boolean isRollbackVisible = true;
        int[] arrSelectedRows = oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return isRollbackVisible;
        }
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreeTableRowData oRowData;
            TreeTableNode oNode;
            TreePath oTreePath = oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData) || !((oRowData = (TreeTableRowData)oNode.getUserObject()).getUserObject() instanceof Resource)) continue;
            Resource resource = (Resource)oRowData.getUserObject();
            if (resource.getDeviceType().equals("S3300")) {
                isRollbackVisible = false;
                break;
            }
            if (2 != resource.getRoleType() || !DeviceInfoUtil.isDomainDevice(resource.getDeviceID(), 2)) continue;
            isRollbackVisible = false;
            break;
        }
        return isRollbackVisible;
    }

    public static boolean isEnableRollbackMenu(DCSortableTreeTable oTaskTreeTable) {
        boolean isRollbackEnable = false;
        int[] arrSelectedRows = oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return isRollbackEnable;
        }
        if (1 == arrSelectedRows.length) {
            isRollbackEnable = true;
        } else {
            ArrayList<Integer> oTaskTypeLst = new ArrayList<Integer>();
            ITask iTask = null;
            isRollbackEnable = true;
            for (int i = 0; i < arrSelectedRows.length; ++i) {
                TreePath oTreePath = oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
                if (null == oTreePath) continue;
                TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
                iTask = TaskTableUtil.getTaskForTableNode(oNode);
                if (!oTaskTypeLst.contains(iTask.getTaskId())) {
                    oTaskTypeLst.add(iTask.getTaskId());
                }
                if (oTaskTypeLst.size() <= 1) continue;
                isRollbackEnable = false;
                break;
            }
        }
        return isRollbackEnable;
    }

    public static boolean isEnableGenerateReport(DCSortableTreeTable m_oTaskTreeTable) {
        TreeTableNode oNode = null;
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (0 == m_oTaskTreeTable.getRowCount() || null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return false;
        }
        boolean bIsGenerateReportEnable = true;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            ITask iTask = TaskTableUtil.getTaskForTableNode(oNode);
            TaskProgressInfo taskProgressInfo = iTask.getTaskProgressInfo();
            int iTaskOpState = taskProgressInfo.getState();
            if (1 != iTaskOpState && 0 != iTaskOpState) continue;
            bIsGenerateReportEnable = false;
            break;
        }
        return bIsGenerateReportEnable;
    }
}

