/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.common.util.MenuUtil;
import com.huawei.dc.configuration.licence.LicenseMonitor;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.PrecheckOperation;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.TaskModelUtil;
import com.huawei.dc.taskmgmt.model.TaskProgressInfo;
import com.huawei.dc.taskmgmt.view.common.TaskManagementPopupMenuManagerHelper;
import com.huawei.dc.taskmgmt.view.common.TaskManagementPopupMenuUtil;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTableUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.tree.TreePath;

public class TaskManagementPopupMenuManagerExt {
    public void enableAllMenuItems(boolean bFlag, Map m_oTaskMenuItemMap) {
        for (String strMenuItemID : m_oTaskMenuItemMap.keySet()) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID(strMenuItemID, m_oTaskMenuItemMap), bFlag);
            MenuUtil.visibleMenuItem(this.getMenuItemForID(strMenuItemID, m_oTaskMenuItemMap), true);
        }
    }

    public JMenuItem getMenuItemForID(String strMenuItemID, Map m_oTaskMenuItemMap) {
        JMenuItem tempMenu = null;
        if (null != m_oTaskMenuItemMap.get(strMenuItemID)) {
            tempMenu = (JMenuItem)m_oTaskMenuItemMap.get(strMenuItemID);
        } else {
            DCDebugTracer.traceError("[menu] get Menu Item  : " + strMenuItemID + " failed, please check taskmgmtpopupmenufortask.xml or taskmgmtpopupmenufordevice.xml file. ");
            tempMenu = new JMenuItem();
        }
        return tempMenu;
    }

    public JSeparator getSeparatorForID(String strSeparatorID, Map separatorList) {
        return (JSeparator)separatorList.get(strSeparatorID);
    }

    public JPopupMenu enableOnlyCreateTaskItem(Map m_oTaskMenuItemMap, JPopupMenu m_oTaskPopupMenu, boolean m_hasTaskMgrPrivilege, Map separatorList) {
        this.enableAllMenuItems(false, m_oTaskMenuItemMap);
        this.enableTaskMenuItems(m_oTaskMenuItemMap);
        JSeparator oSeparator = TaskManagementPopupMenuUtil.getSeparator(m_oTaskPopupMenu, 5);
        if (null != oSeparator) {
            oSeparator.setVisible(false);
        }
        this.getMenuItemForID("CheckReportsForDevice", m_oTaskMenuItemMap).setVisible(false);
        if (!m_hasTaskMgrPrivilege) {
            this.enableAllMenuItems(false, m_oTaskMenuItemMap);
        }
        this.disVisibleSNMPConfig(m_oTaskMenuItemMap, separatorList);
        MenuUtil.orgSeparator(m_oTaskPopupMenu);
        return m_oTaskPopupMenu;
    }

    public void enableTaskMenuItems(Map m_oTaskMenuItemMap) {
        DeviceTypeInfo[] m_arrDeviceTypes = DCFrameWorkUtil.getDeviceInfoManager().getAddedDeviceTypes();
        int[] iDeviceIdLst = DCFrameWorkUtil.getDeviceInfoManager().getAddedDeviceIdLst();
        if (null == m_arrDeviceTypes || 0 == m_arrDeviceTypes.length) {
            this.getMenuItemForID("NewTask", m_oTaskMenuItemMap).setEnabled(false);
            this.getMenuItemForID("GenerateReport", m_oTaskMenuItemMap).setEnabled(false);
            this.getMenuItemForID("ViewSNMPConfigurationCompareResult", m_oTaskMenuItemMap).setEnabled(false);
        } else {
            this.getMenuItemForID("NewTask", m_oTaskMenuItemMap).setEnabled(true);
        }
        if (TaskModelUtil.isTaskTypeSupportedForDeviceTypes(10, m_arrDeviceTypes, iDeviceIdLst)) {
            this.visibleEnableMenuItem("UpgradeDowngrade", m_oTaskMenuItemMap, true);
        } else {
            this.getMenuItemForID("UpgradeDowngrade", m_oTaskMenuItemMap).setVisible(false);
        }
        if (TaskModelUtil.isTaskTypeSupportedForDeviceTypes(2, m_arrDeviceTypes, iDeviceIdLst)) {
            this.visibleEnableMenuItem("PatchUpdate", m_oTaskMenuItemMap, true);
        } else {
            this.getMenuItemForID("PatchUpdate", m_oTaskMenuItemMap).setVisible(false);
        }
        if (TaskModelUtil.isTaskTypeSupportedForDeviceTypes(3, m_arrDeviceTypes, iDeviceIdLst)) {
            this.visibleEnableMenuItem("MimcPackageUpgrade", m_oTaskMenuItemMap, true);
        } else {
            this.getMenuItemForID("MimcPackageUpgrade", m_oTaskMenuItemMap).setVisible(false);
        }
        if (TaskModelUtil.isTaskTypeSupportedForDeviceTypes(14, m_arrDeviceTypes, iDeviceIdLst)) {
            this.visibleEnableMenuItem("packageUpgradedowngradetask", m_oTaskMenuItemMap, true);
        } else {
            this.getMenuItemForID("packageUpgradedowngradetask", m_oTaskMenuItemMap).setVisible(false);
        }
        if (TaskModelUtil.isTaskTypeSupportedForDeviceTypes(11, m_arrDeviceTypes, iDeviceIdLst)) {
            if (LicenseMonitor.getInstance().isControlTran()) {
                if (LicenseMonitor.getInstance().isCurrStatusValid()) {
                    this.visibleEnableMenuItem("packageDiffusionUpgradeDowngrade", m_oTaskMenuItemMap, true);
                } else {
                    this.visibleEnableMenuItem("packageDiffusionUpgradeDowngrade", m_oTaskMenuItemMap, false);
                }
            } else {
                this.visibleEnableMenuItem("packageDiffusionUpgradeDowngrade", m_oTaskMenuItemMap, true);
            }
        } else {
            this.getMenuItemForID("packageDiffusionUpgradeDowngrade", m_oTaskMenuItemMap).setVisible(false);
        }
        if (TaskModelUtil.isTaskTypeSupportedForDeviceTypes(7, m_arrDeviceTypes, iDeviceIdLst) && !DCFrameWorkUtil.getIsSingleClient() && LicenseMonitor.getInstance().isCurrStatusValid()) {
            this.visibleEnableMenuItem("oltUpdate", m_oTaskMenuItemMap, true);
        } else {
            this.getMenuItemForID("oltUpdate", m_oTaskMenuItemMap).setVisible(false);
        }
    }

    public void setGenerateReportMenuStatus(DCSortableTreeTable m_oTaskTreeTable, Map m_oTaskMenuItemMap) {
        this.getMenuItemForID("GenerateReport", m_oTaskMenuItemMap).setEnabled(TaskManagementPopupMenuManagerHelper.isEnableGenerateReport(m_oTaskTreeTable));
    }

    public void setGenerateExtendedReportMenuStatus(DCSortableTreeTable m_oTaskTreeTable, Map m_oTaskMenuItemMap) {
        boolean bIsGenerateReportEnable = true;
        TreeTableNode oNode = null;
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (0 == m_oTaskTreeTable.getRowCount() || null == arrSelectedRows || 1 != arrSelectedRows.length) {
            bIsGenerateReportEnable = false;
        } else {
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[0]);
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            ITask iTask = TaskTableUtil.getTaskForTableNode(oNode);
            if (null == iTask || iTask.getTaskTypeId() != 4 && iTask.getTaskTypeId() != 13) {
                this.getMenuItemForID("GenerateExtendReport", m_oTaskMenuItemMap).setVisible(false);
                return;
            }
            this.getMenuItemForID("GenerateExtendReport", m_oTaskMenuItemMap).setVisible(true);
            TaskProgressInfo taskProgressInfo = iTask.getTaskProgressInfo();
            int iTaskOpState = taskProgressInfo.getState();
            if (1 == iTaskOpState || 0 == iTaskOpState) {
                bIsGenerateReportEnable = false;
                this.getMenuItemForID("GenerateExtendReport", m_oTaskMenuItemMap).setEnabled(bIsGenerateReportEnable);
                return;
            }
            ITaskDeviceOperation preCheckOpr = iTask.getTaskDeviceOperation(4);
            if (null == preCheckOpr || !preCheckOpr.isSelected()) {
                bIsGenerateReportEnable = false;
            } else {
                String oprStrBuf = ((PrecheckOperation)preCheckOpr).toString();
                if (-1 == oprStrBuf.indexOf(ResourceManager.getInstance().getResString("EXTENDCHECK"))) {
                    bIsGenerateReportEnable = false;
                }
            }
        }
        this.getMenuItemForID("GenerateExtendReport", m_oTaskMenuItemMap).setEnabled(bIsGenerateReportEnable);
    }

    public void setSNMPConfigComMenuStatus(DCSortableTreeTable m_oTaskTreeTable, Map m_oTaskMenuItemMap, Map separatorList) {
        TreeTableNode oNode = null;
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        ITask oTask = null;
        if (arrSelectedRows != null && arrSelectedRows.length == 1) {
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[0]);
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            oTask = TaskTableUtil.getTaskForTableNode(oNode);
            DeviceType devType = oTask.getDeviceType();
            DeviceInfo deviceInfo = null;
            THashSet<Resource> deviceInfos = devType.getResources();
            if (null != deviceInfos && deviceInfos.size() != 0) {
                int deviceId = ((Resource)deviceInfos.iterator().next()).getDeviceID();
                deviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(deviceId);
            }
            List<Integer> sSeriesDeviceTypeIDLst = DeviceInfoUtil.getDeviceTypeIDLst("DEVICE_TYPE_ID_SUPPORT_SNMP_COMPARE", "config");
            if (2 == devType.getDeviceDomain() && !DeviceInfoUtil.isClusterNE(deviceInfo) && sSeriesDeviceTypeIDLst.contains(devType.getDeviceTypeID())) {
                boolean bSelPrecheck = TaskModelUtil.isChckOpeSel(oTask, "PreCheck");
                THashSet<Resource> oResourceList = oTask.getDeviceType().getResources();
                boolean bCompletePrecheck = TaskModelUtil.isChckOpeComplete(oTask, "PreCheck", bSelPrecheck, oResourceList);
                boolean bSelPostcheck = TaskModelUtil.isChckOpeSel(oTask, "PostCheck");
                boolean bCompletePostcheck = TaskModelUtil.isChckOpeComplete(oTask, "PostCheck", bSelPostcheck, oResourceList);
                boolean isHaveCurrentConfig = TaskManagementPopupMenuUtil.isSelectCurrentConfig(oTask);
                if (isHaveCurrentConfig) {
                    MenuUtil.visibleMenuItem(this.getMenuItemForID("ViewSNMPConfigurationCompareResult", m_oTaskMenuItemMap), true);
                    MenuUtil.visibleMenuItem(this.getSeparatorForID("seperatorSnmp", separatorList), true);
                    if (bCompletePrecheck && bCompletePostcheck) {
                        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ViewSNMPConfigurationCompareResult", m_oTaskMenuItemMap), true);
                    } else {
                        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ViewSNMPConfigurationCompareResult", m_oTaskMenuItemMap), false);
                    }
                } else {
                    this.disVisibleSNMPConfig(m_oTaskMenuItemMap, separatorList);
                }
            } else {
                this.disVisibleSNMPConfig(m_oTaskMenuItemMap, separatorList);
            }
        } else {
            this.disVisibleSNMPConfig(m_oTaskMenuItemMap, separatorList);
        }
    }

    public void disVisibleSNMPConfig(Map m_oTaskMenuItemMap, Map separatorList) {
        MenuUtil.visibleMenuItem(this.getMenuItemForID("ViewSNMPConfigurationCompareResult", m_oTaskMenuItemMap), false);
        MenuUtil.visibleMenuItem(this.getSeparatorForID("seperatorSnmp", separatorList), false);
    }

    public ITask disableInapplicableMenuItemsForRes(DCSortableTreeTable m_oTaskTreeTable, Map m_oTaskMenuItemMap) {
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length || 0 == m_oTaskTreeTable.getRowCount()) {
            return null;
        }
        boolean bIsAnyOperationInProgress = false;
        boolean bIsAnyOperationRunning = false;
        boolean bIsAnyOperationSuccessful = false;
        boolean bIsAnyOperationFailed = false;
        boolean bIsAnyOperationCompleted = false;
        boolean bIsAnyOperationNotRun = false;
        boolean bIsAnyOperationSuspended = false;
        boolean bIsLastOperation = false;
        boolean bIsHaveRollbackingResource = false;
        boolean bIsOltTask = false;
        boolean bHasGetTaskInfo = false;
        ITask oTaskInfo = null;
        TreeTableNode oNode = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreeTableRowData oRowData;
            Resource oResource;
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData) || null == (oResource = (Resource)(oRowData = (TreeTableRowData)oNode.getUserObject()).getUserObject()).getProgressInfo()) continue;
            if (!bHasGetTaskInfo) {
                oTaskInfo = TaskTableUtil.getTaskForTableNode(oNode);
                bHasGetTaskInfo = true;
            }
            int iResourceOpState = oResource.getProgressInfo().getState();
            int iResourceOpResult = oResource.getProgressInfo().getResult();
            String strCurrentOperation = oResource.getProgressInfo().getCurrentOperationId();
            List<ResourceProgressInfo> oProgressInfoList = oResource.getOperationResultList();
            int count = 0;
            if (oProgressInfoList != null && (count = oProgressInfoList.size()) > 0 && ("Rollback".equals(strCurrentOperation) || strCurrentOperation.equals(oProgressInfoList.get(count - 1).getCurrentOperationId()))) {
                bIsLastOperation = true;
            }
            if ("Rollback".equals(strCurrentOperation)) {
                bIsHaveRollbackingResource = true;
            }
            if (0 == iResourceOpState) {
                bIsAnyOperationNotRun = true;
                continue;
            }
            if (1 == iResourceOpState) {
                bIsAnyOperationInProgress = true;
                continue;
            }
            if (2 == iResourceOpState) {
                bIsAnyOperationRunning = true;
                if (1 != iResourceOpResult) continue;
                bIsAnyOperationFailed = true;
                continue;
            }
            if (4 == iResourceOpState) {
                bIsAnyOperationSuspended = true;
                continue;
            }
            if (3 != iResourceOpState) continue;
            bIsAnyOperationCompleted = true;
            if (0 != iResourceOpResult) continue;
            bIsAnyOperationSuccessful = true;
        }
        this.getMenuItemForID("NextStepOperation", m_oTaskMenuItemMap).setEnabled(false);
        bIsOltTask = this.isOltTask(oTaskInfo);
        this.setContinueMenuStatus(bIsAnyOperationInProgress, bIsAnyOperationRunning, bIsAnyOperationSuccessful, bIsAnyOperationFailed, bIsAnyOperationCompleted, bIsAnyOperationNotRun, bIsOltTask, m_oTaskMenuItemMap);
        this.setRetryMenuStatus(bIsAnyOperationInProgress, bIsAnyOperationSuccessful, bIsAnyOperationFailed, bIsAnyOperationCompleted, bIsAnyOperationNotRun, bIsAnyOperationSuspended, m_oTaskMenuItemMap);
        this.setPauseMenuStatus(bIsAnyOperationRunning, bIsAnyOperationSuccessful, bIsAnyOperationFailed, bIsAnyOperationCompleted, bIsAnyOperationNotRun, bIsAnyOperationSuspended, bIsLastOperation, bIsHaveRollbackingResource, bIsOltTask, m_oTaskMenuItemMap);
        this.setRollbackOpeStatus(bIsAnyOperationInProgress, oTaskInfo, m_oTaskTreeTable, m_oTaskMenuItemMap);
        return oTaskInfo;
    }

    private void setPauseMenuStatus(boolean bIsAnyOperationRunning, boolean bIsAnyOperationSuccessful, boolean bIsAnyOperationFailed, boolean bIsAnyOperationCompleted, boolean bIsAnyOperationNotRun, boolean bIsAnyOperationSuspended, boolean bIsLastOperation, boolean bIsHaveRollbackingResource, boolean bIsOltTask, Map m_oTaskMenuItemMap) {
        if (bIsAnyOperationRunning || bIsAnyOperationFailed || bIsAnyOperationSuspended || bIsAnyOperationNotRun || bIsAnyOperationCompleted || bIsAnyOperationSuccessful || bIsLastOperation || bIsHaveRollbackingResource || bIsOltTask) {
            this.getMenuItemForID("PauseOperation", m_oTaskMenuItemMap).setEnabled(false);
        }
    }

    private void setRetryMenuStatus(boolean bIsAnyOperationInProgress, boolean bIsAnyOperationSuccessful, boolean bIsAnyOperationFailed, boolean bIsAnyOperationCompleted, boolean bIsAnyOperationNotRun, boolean bIsAnyOperationSuspended, Map m_oTaskMenuItemMap) {
        if (bIsAnyOperationInProgress || !bIsAnyOperationFailed || bIsAnyOperationSuspended || bIsAnyOperationNotRun || bIsAnyOperationCompleted || bIsAnyOperationSuccessful) {
            this.getMenuItemForID("RetryOperation", m_oTaskMenuItemMap).setEnabled(false);
        }
    }

    private void setContinueMenuStatus(boolean bIsAnyOperationInProgress, boolean bIsAnyOperationRunning, boolean bIsAnyOperationSuccessful, boolean bIsAnyOperationFailed, boolean bIsAnyOperationCompleted, boolean bIsAnyOperationNotRun, boolean bIsOltTask, Map m_oTaskMenuItemMap) {
        if (bIsAnyOperationInProgress || bIsAnyOperationRunning || bIsAnyOperationFailed || bIsAnyOperationNotRun || bIsAnyOperationCompleted || bIsAnyOperationSuccessful || bIsOltTask) {
            this.getMenuItemForID("ContinueOperation", m_oTaskMenuItemMap).setEnabled(false);
        }
    }

    private void setRollbackOpeStatus(boolean bIsAnyOperationInProgress, ITask oTaskInfo, DCSortableTreeTable m_oTaskTreeTable, Map m_oTaskMenuItemMap) {
        boolean bRollbackEnable = TaskManagementPopupMenuManagerHelper.isRollbackMenuEnabled(m_oTaskTreeTable);
        if (null == oTaskInfo) {
            DCDebugTracer.traceDetail("oTask is null in " + this.getClass().getName());
        } else if (4 == oTaskInfo.getDeviceType().getDeviceDomain()) {
            if (!bRollbackEnable) {
                this.getMenuItemForID("RollbackOperation", m_oTaskMenuItemMap).setEnabled(false);
            }
        } else if (!bRollbackEnable || bIsAnyOperationInProgress) {
            this.getMenuItemForID("RollbackOperation", m_oTaskMenuItemMap).setEnabled(false);
        }
        if (bRollbackEnable && !bIsAnyOperationInProgress) {
            if (DeviceInfoUtil.isStackDevicePresent(TaskTableUtil.getSelectedResources(m_oTaskTreeTable), 3)) {
                this.getMenuItemForID("RollbackOperation", m_oTaskMenuItemMap).setEnabled(false);
            } else {
                this.getMenuItemForID("RollbackOperation", m_oTaskMenuItemMap).setEnabled(true);
            }
        }
    }

    private boolean isOltTask(ITask oTaskInfo) {
        int taskTypeId;
        boolean bIsOltTask = false;
        if (null != oTaskInfo && 7 == (taskTypeId = oTaskInfo.getTaskTypeId())) {
            bIsOltTask = true;
        }
        return bIsOltTask;
    }

    public void enableActivateManuallyMenuItemForBoard(DCSortableTreeTable m_oTaskTreeTable, Map m_oTaskMenuItemMap) {
        boolean isVisible = true;
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        TreeTableNode oNode = null;
        ITask oTask = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData) || 3 == (oTask = TaskTableUtil.getTaskForTableNode(oNode)).getTaskTypeId()) continue;
            isVisible = false;
            break;
        }
        MenuUtil.visibleMenuItem(this.getMenuItemForID("AtivateManually", m_oTaskMenuItemMap), isVisible);
        if (isVisible) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("AtivateManually", m_oTaskMenuItemMap), TaskManagementPopupMenuManagerHelper.isEnableActivateManuallyMenuItemForBoard(m_oTaskTreeTable));
        }
    }

    public void setRetryDiffTaskMenuStatus(DCSortableTreeTable m_oTaskTreeTable, Map m_oTaskMenuItemMap) {
        DCDebugTracer.trace("TaskManagementPopupMenuManager#setRetryTaskMenuStatus start");
        boolean bIsReTryEnable = true;
        boolean bIsReTryVisible = true;
        TreeTableNode oNode = null;
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (0 == m_oTaskTreeTable.getRowCount() || null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return;
        }
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            ITask oTask = TaskTableUtil.getTaskForTableNode(oNode);
            boolean isolationTask = IsolationCommonOperation.isIsolationTask(oTask.getTaskTypeId());
            if (isolationTask) continue;
            boolean bl = bIsReTryVisible = 5 == oTask.getTaskTypeId() || 11 == oTask.getTaskTypeId() || 12 == oTask.getTaskTypeId();
            if (!bIsReTryVisible) break;
            boolean bl2 = bIsReTryEnable = bIsReTryVisible && !oTask.isInProgress() && !oTask.isComplete() && !oTask.isSucc() && TaskManagementPopupMenuUtil.isHaveFailedRes(oTask) && TaskManagementPopupMenuUtil.checkRetryDiffTaskBaseOnRollback(oTask);
            if (!bIsReTryEnable) break;
        }
        this.getMenuItemForID("RetryDiffusionTask", m_oTaskMenuItemMap).setVisible(bIsReTryVisible);
        this.getMenuItemForID("RetryDiffusionTask", m_oTaskMenuItemMap).setEnabled(bIsReTryEnable);
    }

    public void visibleEnableMenuItem(String menuItem, Map m_oTaskMenuItemMap, boolean status) {
        this.getMenuItemForID(menuItem, m_oTaskMenuItemMap).setVisible(status);
        this.getMenuItemForID(menuItem, m_oTaskMenuItemMap).setEnabled(status);
    }

    public boolean isT2000PatchTask(DCSortableTreeTable m_oTaskTreeTable) {
        boolean isT2000PatchTask = true;
        int[] arrSelectedRows = m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return isT2000PatchTask;
        }
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            Resource resource;
            TreeTableRowData oRowData;
            TreeTableNode oNode;
            TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData) || !((oRowData = (TreeTableRowData)oNode.getUserObject()).getUserObject() instanceof Resource) || DeviceInfoUtil.isDomainDevice((resource = (Resource)oRowData.getUserObject()).getDeviceID(), 4)) continue;
            isT2000PatchTask = false;
            break;
        }
        return isT2000PatchTask;
    }
}

