/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.PopupMenuManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.MenuUtil;
import com.huawei.dc.configuration.licence.LicenseMonitor;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ICheckOperation;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.Task;
import com.huawei.dc.taskmgmt.model.TaskModelUtil;
import com.huawei.dc.taskmgmt.view.common.TaskManagementPopupMenuManagerExt;
import com.huawei.dc.taskmgmt.view.common.TaskManagementPopupMenuManagerHelper;
import com.huawei.dc.taskmgmt.view.common.TaskManagementPopupMenuUtil;
import com.huawei.dc.taskmgmt.view.common.TaskMenuItemHandler;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTableUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.tree.TreePath;

public class TaskManagementPopupMenuManager
extends TaskManagementPopupMenuManagerExt {
    private Map m_oTaskMenuItemMap = null;
    private Map separatorList = null;
    private JPopupMenu m_oTaskPopupMenu = null;
    private JPopupMenu m_oResourcePopupMenu = null;
    private DCSortableTreeTable m_oTaskTreeTable = null;
    boolean m_hasTaskMgrPrivilege = true;
    private int m_taskKind = -1;

    public TaskManagementPopupMenuManager(DCSortableTreeTable oTaskTreeTable, TaskMenuItemHandler oTaskMenuItemHandler) {
        this.m_oTaskTreeTable = oTaskTreeTable;
        this.loadTaskPopupMenus(oTaskMenuItemHandler);
        this.checkUserPrivileges();
    }

    public void checkUserPrivileges() {
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            this.setMenuItemPrivilege();
        }
    }

    public void setMenuItemPrivilege() {
        this.m_hasTaskMgrPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43871);
    }

    private void loadTaskPopupMenus(TaskMenuItemHandler oTaskMenuItemHandler) {
        PopupMenuManager oPopupMenuManager = PopupMenuManager.getInstance();
        this.m_oTaskPopupMenu = oPopupMenuManager.load(oTaskMenuItemHandler, "taskmgmtpopupmenufortask");
        this.m_oTaskMenuItemMap = oPopupMenuManager.getMenuItemMap();
        this.separatorList = oPopupMenuManager.getSeparatorMap();
        this.m_oResourcePopupMenu = oPopupMenuManager.load(oTaskMenuItemHandler, "taskmgmtpopupmenufordevice");
        this.m_oTaskMenuItemMap.putAll(oPopupMenuManager.getMenuItemMap());
        this.separatorList.putAll(oPopupMenuManager.getSeparatorMap());
        oPopupMenuManager.resetFields();
    }

    public JMenuItem getMenuItemForID(String strMenuItemID) {
        JMenuItem tempMenu = null;
        if (null != this.m_oTaskMenuItemMap.get(strMenuItemID)) {
            tempMenu = (JMenuItem)this.m_oTaskMenuItemMap.get(strMenuItemID);
        } else {
            DCDebugTracer.traceError("[menu] get Menu Item  : " + strMenuItemID + " failed, please check taskmgmtpopupmenufortask.xml or taskmgmtpopupmenufordevice.xml file. ");
            tempMenu = new JMenuItem();
        }
        return tempMenu;
    }

    public JPopupMenu load() {
        int[] arrSelectedRows = this.m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length || 0 == this.m_oTaskTreeTable.getRowCount()) {
            if (!this.m_hasTaskMgrPrivilege) {
                this.enableAllMenuItems(false, this.m_oTaskMenuItemMap);
                MenuUtil.orgSeparator(this.m_oTaskPopupMenu);
                return this.m_oTaskPopupMenu;
            }
            return this.enableOnlyCreateTaskItem(this.m_oTaskMenuItemMap, this.m_oTaskPopupMenu, this.m_hasTaskMgrPrivilege, this.separatorList);
        }
        if (TaskTableUtil.isAResourceOnlySelection(this.m_oTaskTreeTable)) {
            return this.enableMenuForResource();
        }
        if (TaskTableUtil.isABoardResourceOnlySelection(this.m_oTaskTreeTable)) {
            return this.enableMenuForBoard();
        }
        if (TaskTableUtil.isATaskOnlySelection(this.m_oTaskTreeTable)) {
            return this.enableMenuForTask();
        }
        return this.enableOnlyCreateTaskItem(this.m_oTaskMenuItemMap, this.m_oTaskPopupMenu, this.m_hasTaskMgrPrivilege, this.separatorList);
    }

    private JPopupMenu enableMenuForTask() {
        if (!this.m_hasTaskMgrPrivilege) {
            this.enableAllMenuItems(false, this.m_oTaskMenuItemMap);
            MenuUtil.orgSeparator(this.m_oTaskPopupMenu);
            return this.m_oTaskPopupMenu;
        }
        this.enableApplicableMenuItemsForTask();
        this.disableContinueTaskMenuForUFC();
        if (this.m_oTaskTreeTable.getSelectedRowCount() > 1) {
            this.getMenuItemForID("PauseTask", this.m_oTaskMenuItemMap).setEnabled(false);
        }
        MenuUtil.orgSeparator(this.m_oTaskPopupMenu);
        return this.m_oTaskPopupMenu;
    }

    private JPopupMenu enableMenuForResource() {
        TaskManagementPopupMenuUtil.enableAllSeparators(this.m_oResourcePopupMenu, true);
        if (!this.m_hasTaskMgrPrivilege) {
            this.enableAllMenuItems(false, this.m_oTaskMenuItemMap);
            return this.m_oResourcePopupMenu;
        }
        this.displayDomainSpecificMenuItems(this.m_oResourcePopupMenu);
        if (TaskTableUtil.isADeviceNodeOnlySelection(this.m_oTaskTreeTable) == 2) {
            this.enableApplicableMenuItensForDevNodeOfPackageTask();
        } else if (TaskTableUtil.isADeviceNodeOnlySelection(this.m_oTaskTreeTable) == 0) {
            this.enableApplicableMenuItensForDevNodeOfMimicPackageTask();
        } else if (TaskTableUtil.isADeviceNodeOnlySelection(this.m_oTaskTreeTable) == 4) {
            this.enableApplicableMenuItemsForResource();
        }
        this.setStatusforRefreshMenuItem();
        this.setStatusforExportAlarmDevicesMenuItem();
        this.handleCancelOperationMenuDisplay();
        if (!this.m_hasTaskMgrPrivilege) {
            this.enableAllMenuItems(false, this.m_oTaskMenuItemMap);
        }
        MenuUtil.visibleMenuItem(this.getMenuItemForID("AtivateManually", this.m_oTaskMenuItemMap), false);
        this.disableModifySingleNEActiveGroupMenu();
        this.disableQueryMenuItem();
        this.visableRollbackMenu();
        this.disableRollbackMenu();
        this.disableDeleteMenuItem();
        this.disableNENextMenu();
        this.disableTelnetMenuItem();
        this.disableViewAlarmMenu();
        this.disableFreeIsolationDevice();
        MenuUtil.orgSeparator(this.m_oResourcePopupMenu);
        return this.m_oResourcePopupMenu;
    }

    private void visableRollbackMenu() {
        this.getMenuItemForID("RollbackOperation", this.m_oTaskMenuItemMap).setVisible(TaskManagementPopupMenuManagerHelper.isVisibleRollbackMenu(this.m_oTaskTreeTable));
        if (this.m_taskKind == 2 && this.isT2000PatchTask(this.m_oTaskTreeTable)) {
            this.getMenuItemForID("RollbackOperation", this.m_oTaskMenuItemMap).setVisible(false);
        }
    }

    private void disableRollbackMenu() {
        if (this.getMenuItemForID("RollbackOperation", this.m_oTaskMenuItemMap).isEnabled()) {
            this.getMenuItemForID("RollbackOperation", this.m_oTaskMenuItemMap).setEnabled(TaskManagementPopupMenuManagerHelper.isEnableRollbackMenu(this.m_oTaskTreeTable));
        }
    }

    private void disableFreeIsolationDevice() {
        boolean bVisibleFreeIsolationDev = false;
        int[] arrSelectedRows = this.m_oTaskTreeTable.getSelectedRows();
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            ITask oTask = this.getTaskInfoByTableNode(arrSelectedRows, i);
            if (null == oTask) {
                return;
            }
            if (!oTask.getTaskName().contains("AutoUpgradeSWPKG") || oTask.getTaskTypeId() != 4 || oTask.getDeviceType().getDeviceDomain() != 4) continue;
            bVisibleFreeIsolationDev = true;
        }
        MenuUtil.visibleMenuItem(this.getMenuItemForID("freeIsolationDevice", this.m_oTaskMenuItemMap), bVisibleFreeIsolationDev);
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("freeIsolationDevice", this.m_oTaskMenuItemMap), bVisibleFreeIsolationDev);
    }

    private void disableNENextMenu() {
        THashSet<Resource> resList = TaskTableUtil.getSelectedResources(this.m_oTaskTreeTable);
        Iterator oResItor = resList.iterator();
        Resource res = null;
        if (oResItor.hasNext()) {
            res = (Resource)oResItor.next();
        }
        if (null != res) {
            DeviceInfo devInfo = DeviceInfoManagerImpl.getInstance().getDevice(res.getDeviceID());
            int iDevDomain = devInfo.getDeviceTypeInfo().getDevDomain();
            if (2 == iDevDomain) {
                this.disableNENextMenuForIP();
            } else if (4 == iDevDomain) {
                if (TaskTableUtil.isADeviceNodeOnlySelection(this.m_oTaskTreeTable) != 0) {
                    this.disableNENextMenuForT2000ExceptMimic();
                }
            } else {
                this.getMenuItemForID("NextStepOperation", this.m_oTaskMenuItemMap).setVisible(false);
            }
        }
    }

    private void disableNENextMenuForT2000ExceptMimic() {
        this.getMenuItemForID("NextStepOperation", this.m_oTaskMenuItemMap).setEnabled(TaskManagementPopupMenuManagerHelper.isEnableNENextMenuForT2000ExceptMimic(this.m_oTaskTreeTable));
    }

    private JPopupMenu enableMenuForBoard() {
        for (String strMenuItemID : this.m_oTaskMenuItemMap.keySet()) {
            MenuUtil.visibleMenuItem(this.getMenuItemForID(strMenuItemID, this.m_oTaskMenuItemMap), false);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID(strMenuItemID, this.m_oTaskMenuItemMap), false);
        }
        TaskManagementPopupMenuUtil.enableAllSeparators(this.m_oResourcePopupMenu, false);
        if (!this.m_hasTaskMgrPrivilege) {
            return this.m_oResourcePopupMenu;
        }
        this.enableActivateManuallyMenuItemForBoard(this.m_oTaskTreeTable, this.m_oTaskMenuItemMap);
        MenuUtil.orgSeparator(this.m_oResourcePopupMenu);
        return this.m_oResourcePopupMenu;
    }

    private void disableDeleteMenuItem() {
        int[] arrSelectedRows = this.m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return;
        }
        if (TaskManagementPopupMenuUtil.isVisibleDeleteMenuItem(this.m_oTaskTreeTable)) {
            this.getMenuItemForID("DeleteFailDevOperation", this.m_oTaskMenuItemMap).setEnabled(TaskManagementPopupMenuUtil.isEnbaleDeleteMenuItem(this.m_oTaskTreeTable));
        } else {
            this.visibleEnableMenuItem("DeleteFailDevOperation", this.m_oTaskMenuItemMap, false);
        }
    }

    private void disableTelnetMenuItem() {
        int[] arrSelectedRows = this.m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length || arrSelectedRows.length > 1) {
            if (DCFrameWorkUtil.getIsSingleClient()) {
                if (2 == StandAloneDomainInfo.getInstance().getSelectedDomain()) {
                    MenuUtil.enableMenuItem((Component)this.getMenuItemForID("telnetTerminal", this.m_oTaskMenuItemMap), false);
                } else {
                    MenuUtil.visibleMenuItem(this.getMenuItemForID("telnetTerminal", this.m_oTaskMenuItemMap), false);
                }
            } else {
                this.visibleEnableMenuItem("telnetTerminal", this.m_oTaskMenuItemMap, false);
            }
            return;
        }
        if (TaskTableUtil.isAnyOtherResPresentExceptDomain(this.m_oTaskTreeTable, 2) || !DCFrameWorkUtil.getIsSingleClient()) {
            this.visibleEnableMenuItem("telnetTerminal", this.m_oTaskMenuItemMap, false);
            return;
        }
        this.getMenuItemForID("telnetTerminal", this.m_oTaskMenuItemMap).setEnabled(TaskManagementPopupMenuUtil.isEnableTelnetMenuItem(this.m_oTaskTreeTable));
    }

    private void handleCancelOperationMenuDisplay() {
        int[] arrSelectedRows = this.m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return;
        }
        if (TaskManagementPopupMenuUtil.isVisibleCancelMenu(this.m_oTaskTreeTable)) {
            this.getMenuItemForID("CancelOperation", this.m_oTaskMenuItemMap).setEnabled(TaskManagementPopupMenuUtil.isEnbaleCancelMenu(this.m_oTaskTreeTable));
        } else {
            this.getMenuItemForID("CancelOperation", this.m_oTaskMenuItemMap).setVisible(false);
        }
    }

    private void disableContinueTaskMenuForUFC() {
        if (TaskManagementPopupMenuManagerHelper.isEnableContinueTaskMenuForUFC(this.m_oTaskTreeTable)) {
            this.getMenuItemForID("ContinueTask", this.m_oTaskMenuItemMap).setEnabled(true);
        }
    }

    public JPopupMenu enableOnlyCreateTaskItem() {
        this.enableAllMenuItems(false, this.m_oTaskMenuItemMap);
        this.enableTaskMenuItems(this.m_oTaskMenuItemMap);
        JSeparator oSeparator = TaskManagementPopupMenuUtil.getSeparator(this.m_oTaskPopupMenu, 5);
        if (null != oSeparator) {
            oSeparator.setVisible(false);
        }
        this.getMenuItemForID("CheckReportsForDevice", this.m_oTaskMenuItemMap).setVisible(false);
        if (!this.m_hasTaskMgrPrivilege) {
            this.enableAllMenuItems(false, this.m_oTaskMenuItemMap);
        }
        this.disVisibleSNMPConfig(this.m_oTaskMenuItemMap, this.separatorList);
        MenuUtil.orgSeparator(this.m_oTaskPopupMenu);
        return this.m_oTaskPopupMenu;
    }

    private void enableApplicableMenuItemsForResource() {
        this.enableAllMenuItems(true, this.m_oTaskMenuItemMap);
        TaskManagementPopupMenuUtil.enableAllSeparators(this.m_oResourcePopupMenu, true);
        this.disableInapplicableMenuItemsForResource();
        this.disableInapplicableCheckReportItems();
        this.disableRecheckMenuItem();
        this.disableRetryMenuItem(false);
    }

    private void displayDomainSpecificMenuItems(JPopupMenu oPopupMenu) {
        boolean bAnyT200DevicePresent = false;
        boolean bAnyStackDevicePresent = false;
        int[] arrSelectedRows = this.m_oTaskTreeTable.getSelectedRows();
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            ITask oTask = this.getTaskInfoByTableNode(arrSelectedRows, i);
            if (null == oTask) {
                return;
            }
            if (4 == oTask.getSelectedDeviceType().getDeviceDomain() && 2 != oTask.getTaskTypeId()) {
                bAnyT200DevicePresent = true;
                break;
            }
            if (!oTask.isStackDevicePresent(3)) continue;
            bAnyStackDevicePresent = true;
            break;
        }
        if (this.m_oResourcePopupMenu == oPopupMenu) {
            if (bAnyT200DevicePresent) {
                this.getMenuItemForID("RollbackOperation", this.m_oTaskMenuItemMap).setVisible(true);
            } else if (bAnyStackDevicePresent) {
                this.getMenuItemForID("RollbackOperation", this.m_oTaskMenuItemMap).setVisible(false);
            } else if (TaskManagementPopupMenuManagerHelper.isRollbackSupportedForSelectedDevices(this.m_oTaskTreeTable) && TaskManagementPopupMenuManagerHelper.isRollbackSupportedByState(this.m_oTaskTreeTable)) {
                this.getMenuItemForID("RollbackOperation", this.m_oTaskMenuItemMap).setVisible(true);
            } else {
                this.getMenuItemForID("RollbackOperation", this.m_oTaskMenuItemMap).setVisible(false);
            }
        }
    }

    private ITask getTaskInfoByTableNode(int[] arrSelectedRows, int i) {
        TreePath oPath = this.m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
        if (null == oPath) {
            return null;
        }
        TreeTableNode oNode = (TreeTableNode)oPath.getLastPathComponent();
        if (null == oNode) {
            return null;
        }
        ITask oTask = TaskTableUtil.getTaskForTableNode(oNode);
        return oTask;
    }

    private void enableApplicableMenuItensForDevNodeOfPackageTask() {
        this.enableAllMenuItems(true, this.m_oTaskMenuItemMap);
        this.disableInapplicableMenuItemsForResource();
        this.disableInapplicableContinueItems();
        this.disableInapplicableCheckReportItems();
        this.disableRetryMenuItem(false);
        this.handleSelectedIsolationResource();
        this.controlNERECheckMenuForT2000Task();
    }

    private void enableApplicableMenuItensForDevNodeOfMimicPackageTask() {
        this.enableAllMenuItems(true, this.m_oTaskMenuItemMap);
        this.controlNEContinueMenuForMimic();
        this.controlNERetryMenuForMimic();
        this.controlNENextMenuForMimic();
        this.controlNERollbackMenuForMimic();
        this.controlNERECheckMenuForT2000Task();
        this.disableInapplicableCheckReportItems();
        this.handleSelectedIsolationResource();
        MenuUtil.visibleMenuItem(this.getMenuItemForID("PauseOperation", this.m_oTaskMenuItemMap), false);
    }

    private void controlNERECheckMenuForT2000Task() {
        this.getMenuItemForID("RecheckOperation", this.m_oTaskMenuItemMap).setEnabled(TaskManagementPopupMenuManagerHelper.isEnableNERECheckMenuItemForT2000(this.m_oTaskTreeTable));
    }

    private void controlNEContinueMenuForMimic() {
        this.getMenuItemForID("ContinueOperation", this.m_oTaskMenuItemMap).setEnabled(TaskManagementPopupMenuManagerHelper.isEnableNEContinueMenuForMimic(this.m_oTaskTreeTable));
    }

    private void controlNERetryMenuForMimic() {
        this.getMenuItemForID("RetryOperation", this.m_oTaskMenuItemMap).setEnabled(TaskManagementPopupMenuManagerHelper.isEnableNERetryMenuForMimic(this.m_oTaskTreeTable));
    }

    private void controlNERollbackMenuForMimic() {
        this.visibleEnableMenuItem("RollbackOperation", this.m_oTaskMenuItemMap, false);
    }

    private void disableNENextMenuForIP() {
        this.getMenuItemForID("NextStepOperation", this.m_oTaskMenuItemMap).setEnabled(TaskManagementPopupMenuManagerHelper.isEnableNENextMenuForIP(this.m_oTaskTreeTable));
    }

    private void controlNENextMenuForMimic() {
        this.getMenuItemForID("NextStepOperation", this.m_oTaskMenuItemMap).setEnabled(TaskManagementPopupMenuManagerHelper.isEnableNENextMenuForMimic(this.m_oTaskTreeTable));
    }

    private void disableInapplicableContinueItems() {
        int[] arrSelectedRows = this.m_oTaskTreeTable.getSelectedRows();
        if (0 == this.m_oTaskTreeTable.getRowCount() || null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return;
        }
        this.getMenuItemForID("ContinueOperation", this.m_oTaskMenuItemMap).setEnabled(false);
        this.getMenuItemForID("PauseOperation", this.m_oTaskMenuItemMap).setEnabled(false);
    }

    private void disableInapplicableCheckReportItems() {
        this.visibleMenuItem(false, "CheckReportsForDevice");
        this.displaySeparatorForCheckItems(false);
        this.enableMenuItem(false, "GenerateCheckReports");
        if (0 == this.m_oTaskTreeTable.getRowCount() || !TaskTableUtil.isASingleTaskSelection(this.m_oTaskTreeTable)) {
            return;
        }
        int[] arrSelectedRows = this.m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows) {
            return;
        }
        TreePath oTreePath = this.m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[0]);
        if (null == oTreePath) {
            return;
        }
        TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
        if (null == oNode) {
            return;
        }
        ITask oTask = TaskTableUtil.getTaskForTableNode(oNode);
        boolean bEnablePrecheck = false;
        boolean bEnablePostcheck = false;
        ICheckOperation oPrecheckOp = (ICheckOperation)TaskModelUtil.getOperationFromTask(oTask.getTaskId(), "PreCheck");
        ICheckOperation oPostcheckOp = (ICheckOperation)TaskModelUtil.getOperationFromTask(oTask.getTaskId(), "PostCheck");
        if (null != oPrecheckOp && oPrecheckOp.isSelected()) {
            bEnablePrecheck = true;
        }
        if (null != oPostcheckOp && oPostcheckOp.isSelected()) {
            bEnablePostcheck = true;
        }
        if (bEnablePrecheck || bEnablePostcheck) {
            THashSet<Resource> oResourceList = null;
            if (TaskTableUtil.isATaskOnlySelection(this.m_oTaskTreeTable)) {
                oResourceList = oTask.getDeviceType().getResources();
            } else if (TaskTableUtil.isAResourceOnlySelection(this.m_oTaskTreeTable)) {
                oResourceList = TaskTableUtil.getSelectedResources(this.m_oTaskTreeTable);
            } else if (TaskTableUtil.isABoardResourceOnlySelection(this.m_oTaskTreeTable)) {
                oResourceList = TaskTableUtil.getSelectedBoardResources(this.m_oTaskTreeTable, new Vector(0));
            } else {
                return;
            }
            if (bEnablePrecheck) {
                bEnablePrecheck = TaskModelUtil.isOperationCompletedForResourceList(oTask, "PreCheck", oResourceList);
            }
            if (bEnablePostcheck) {
                bEnablePostcheck = TaskModelUtil.isOperationCompletedForResourceList(oTask, "PostCheck", oResourceList);
            }
        }
        if (!bEnablePrecheck && !bEnablePostcheck) {
            if (oTask.isBMSDomain()) {
                this.visibleMenuItem(true, "GenerateCheckReports");
            } else {
                this.visibleMenuItem(false, "GenerateCheckReports");
            }
            return;
        }
        if (bEnablePrecheck || bEnablePostcheck) {
            this.getMenuItemForID("RecheckOperation", this.m_oTaskMenuItemMap).setVisible(true);
        }
        this.visibleMenuItem(true, "CheckReportsForDevice");
        this.displaySeparatorForCheckItems(true);
        if (oTask.isDMSDomain()) {
            this.visibleMenuItem(false, "GenerateCheckReports");
            if (1 == arrSelectedRows.length) {
                if (TaskTableUtil.isATaskOnlySelection(this.m_oTaskTreeTable) && TaskTableUtil.isTaskContainsTelnetDevice(this.m_oTaskTreeTable)) {
                    this.enableMenuItem(false, "CheckReportsForDevice");
                } else {
                    this.enableMenuItem(this.m_hasTaskMgrPrivilege, "CheckReportsForDevice");
                    if (bEnablePrecheck) {
                        this.visibleMenuItem(true, "ViewPreCheckReportForDevice");
                    } else {
                        this.visibleMenuItem(false, "ViewPreCheckReportForDevice");
                    }
                    if (bEnablePostcheck) {
                        this.visibleMenuItem(true, "ViewPostCheckReportForDevice");
                    } else {
                        this.visibleMenuItem(false, "ViewPostCheckReportForDevice");
                    }
                    if (bEnablePrecheck && bEnablePostcheck) {
                        this.visibleMenuItem(true, "CompareCheckReportsForDevice");
                    } else {
                        this.visibleMenuItem(false, "CompareCheckReportsForDevice");
                    }
                }
                this.enableMenuItem(this.m_hasTaskMgrPrivilege, "CheckReportsForDevice");
            } else {
                this.enableMenuItem(false, "CheckReportsForDevice");
            }
        } else {
            this.visibleMenuItem(false, "CheckReportsForDevice");
            this.displaySeparatorForCheckItems(false);
            this.visibleMenuItem(false, "GenerateCheckReports");
            if (oTask.isBMSDomain()) {
                this.visibleMenuItem(true, "GenerateCheckReports");
                this.enableMenuItem((bEnablePrecheck || bEnablePostcheck) && !oTask.isInProgress(), "GenerateCheckReports");
            }
        }
    }

    private void displaySeparatorForCheckItems(boolean bFlag) {
        MenuUtil.visibleMenuItem(this.getSeparatorForID("seperatorViewCheck", this.separatorList), bFlag);
    }

    private void disableInapplicableMenuItemsForResource() {
        ITask oTaskInfo = this.disableInapplicableMenuItemsForRes(this.m_oTaskTreeTable, this.m_oTaskMenuItemMap);
        if (null != oTaskInfo) {
            this.m_taskKind = oTaskInfo.getTaskTypeId();
        }
    }

    private void enableApplicableMenuItemsForTask() {
        this.enableAllMenuItems(true, this.m_oTaskMenuItemMap);
        TaskManagementPopupMenuUtil.enableAllSeparators(this.m_oTaskPopupMenu, true);
        this.enableTaskMenuItems(this.m_oTaskMenuItemMap);
        this.disableInapplicableMenuItemsForTask();
        this.setRetryDiffTaskMenuStatus(this.m_oTaskTreeTable, this.m_oTaskMenuItemMap);
        this.setGenerateReportMenuStatus(this.m_oTaskTreeTable, this.m_oTaskMenuItemMap);
        this.setGenerateExtendedReportMenuStatus(this.m_oTaskTreeTable, this.m_oTaskMenuItemMap);
        this.setSNMPConfigComMenuStatus(this.m_oTaskTreeTable, this.m_oTaskMenuItemMap, this.separatorList);
    }

    private void disableInapplicableMenuItemsForTask() {
        if (0 == this.m_oTaskTreeTable.getRowCount() || !this.m_hasTaskMgrPrivilege) {
            return;
        }
        int[] arrSelectedRows = this.m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return;
        }
        int iTasktype = -1;
        boolean bIsAnyTaskInProgress = false;
        boolean bIsAnyTaskCompleted = false;
        boolean bIsAnyTaskSuspended = false;
        boolean bIsAnyTaskNotRun = false;
        boolean bIsAnyTaskRunning = false;
        boolean bIsAnyTaskFailed = false;
        int iNumberOfTasksSelected = 0;
        boolean bIsOLTTask = true;
        boolean bIsPkgDIffTask = true;
        boolean bIsAutoTask = false;
        HashMap taskMap = new HashMap(0);
        TreeTableNode oNode = null;
        Vector<Integer> oTaskTypes = new Vector<Integer>(0);
        Vector<Calendar> startTimeVec = new Vector<Calendar>(0);
        ITask oTask = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = this.m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            TreeTableRowData oRowData = (TreeTableRowData)oNode.getUserObject();
            oTask = (ITask)oRowData.getUserObject();
            if (!(oNode.getUserObject() instanceof TreeTableRowData) || null == oTask.getTaskProgressInfo()) continue;
            bIsAutoTask = oTask.getTaskTypeId() == 6;
            bIsOLTTask = oTask.getTaskTypeId() == 7;
            bIsPkgDIffTask = oTask.getTaskTypeId() == 5;
            iTasktype = oTask.getTaskTypeId();
            int iCurrentTaskState = oTask.getTaskProgressInfo().getState();
            int iCurrentTaskResult = oTask.getTaskProgressInfo().getResult();
            ++iNumberOfTasksSelected;
            if (null != oTask.getStartTime()) {
                startTimeVec.add(oTask.getStartTime());
            }
            if (arrSelectedRows.length > 1) {
                oTaskTypes.add(iTasktype);
                Integer oTaskID = oTask.getTaskId();
                if (!taskMap.containsKey(oTaskID)) {
                    taskMap.put(oTaskID, null);
                }
            }
            if (0 == iCurrentTaskState) {
                bIsAnyTaskNotRun = true;
                continue;
            }
            if (1 == iCurrentTaskState) {
                bIsAnyTaskInProgress = true;
                continue;
            }
            if (2 == iCurrentTaskState) {
                bIsAnyTaskRunning = true;
                if (1 != iCurrentTaskResult) continue;
                bIsAnyTaskFailed = true;
                continue;
            }
            if (4 == iCurrentTaskState) {
                bIsAnyTaskSuspended = true;
                continue;
            }
            if (3 != iCurrentTaskState) continue;
            bIsAnyTaskCompleted = true;
        }
        this.changeStartCopyModifyContinueMenuStatusForAutoTask(bIsAutoTask);
        this.changeCopyModifyMenuStatusForLicense(bIsOLTTask, bIsPkgDIffTask);
        this.changeModifyViewCopyMenuStatusForMutiTask(iNumberOfTasksSelected);
        this.changeStartCopyModifyContinueCompleteRreportMenuStatusForCompleteTask(bIsAnyTaskCompleted);
        this.changeMenuStatusForAnyTaskNotRun(bIsAnyTaskNotRun);
        this.changeMenuStatusForAnyTaskSuspend(iTasktype, bIsAnyTaskSuspended, iNumberOfTasksSelected, oTask);
        this.changeMenuStatusForAnyTaskInProgress(bIsAnyTaskInProgress);
        if (bIsAnyTaskRunning || bIsAnyTaskFailed) {
            this.enableMenuItem(false, "StartTask", "Modify", "PauseTask", "ContinueTask");
        }
        if (!oTaskTypes.isEmpty() && -1 == iTasktype) {
            this.enableMenuItem(false, "ViewTask", "Modify", "PauseTask", "ContinueTask");
            return;
        }
        boolean bIsNotAnyResourceInRunning = TaskTableUtil.isAnyResourceInProgressInTask(this.m_oTaskTreeTable);
        if (!bIsNotAnyResourceInRunning) {
            this.enableMenuItem(false, "DeleteTask", "ContinueTask", "MoveToCompleted");
        }
    }

    private void changeMenuStatusForAnyTaskInProgress(boolean bIsAnyTaskInProgress) {
        if (bIsAnyTaskInProgress) {
            this.enableMenuItem(false, "StartTask", "DeleteTask", "Modify", "ContinueTask", "MoveToCompleted");
        }
    }

    private void changeMenuStatusForAnyTaskSuspend(int iTasktype, boolean bIsAnyTaskSuspended, int iNumberOfTasksSelected, ITask oTask) {
        if (bIsAnyTaskSuspended) {
            boolean diffTask;
            this.enableMenuItem(false, "Modify", "PauseTask", "MoveToCompleted", "StartTask");
            boolean bl = diffTask = 5 == iTasktype || 12 == iTasktype;
            if (LicenseMonitor.getInstance().isControlTran()) {
                boolean bl2 = diffTask = diffTask && LicenseMonitor.getInstance().isCurrStatusValid();
            }
            if (1 == iNumberOfTasksSelected && (diffTask || 11 == iTasktype || 3 == iTasktype || 13 == iTasktype || 4 == iTasktype || 14 == iTasktype)) {
                if (3 == iTasktype) {
                    this.getMenuItemForID("Modify", this.m_oTaskMenuItemMap).setEnabled(TaskManagementPopupMenuManagerHelper.controlModifyMenuForMimicPackageTask(oTask));
                } else {
                    this.getMenuItemForID("Modify", this.m_oTaskMenuItemMap).setEnabled(true);
                }
            }
            this.getMenuItemForID("GenerateReport", this.m_oTaskMenuItemMap).setEnabled(true);
        }
    }

    private void changeMenuStatusForAnyTaskNotRun(boolean bIsAnyTaskNotRun) {
        if (bIsAnyTaskNotRun) {
            this.enableMenuItem(false, "MoveToCompleted", "PauseTask", "ContinueTask");
        }
    }

    private void changeModifyViewCopyMenuStatusForMutiTask(int iNumberOfTasksSelected) {
        if (iNumberOfTasksSelected > 1) {
            this.enableMenuItem(false, "Modify", "ViewTask", "Copy");
        }
    }

    private void changeStartCopyModifyContinueCompleteRreportMenuStatusForCompleteTask(boolean bIsAnyTaskCompleted) {
        if (bIsAnyTaskCompleted) {
            this.enableMenuItem(false, "Modify", "StartTask", "MoveToCompleted", "PauseTask", "ContinueTask", "GenerateReport");
        }
    }

    private void changeStartCopyModifyContinueMenuStatusForAutoTask(boolean bIsAutoTask) {
        if (bIsAutoTask) {
            this.enableMenuItem(false, "StartTask", "Modify", "Copy", "ContinueTask");
        }
    }

    private void changeCopyModifyMenuStatusForLicense(boolean bIsOLTTask, boolean bIsPkgDIffTask) {
        if (bIsOLTTask) {
            if (LicenseMonitor.getInstance().isCurrStatusValid()) {
                this.enableMenuItem(true, "Modify", "Copy");
            } else {
                this.enableMenuItem(false, "Modify", "Copy");
            }
        }
        if (bIsPkgDIffTask) {
            if (LicenseMonitor.getInstance().isControlTran()) {
                if (LicenseMonitor.getInstance().isCurrStatusValid()) {
                    this.enableMenuItem(true, "Modify", "Copy");
                } else {
                    this.enableMenuItem(false, "Modify", "Copy");
                }
            } else {
                this.enableMenuItem(true, "Modify", "Copy");
            }
        }
    }

    private void disableRecheckMenuItem() {
        this.getMenuItemForID("RecheckOperation", this.m_oTaskMenuItemMap).setVisible(true);
        this.getMenuItemForID("RecheckOperation", this.m_oTaskMenuItemMap).setEnabled(TaskManagementPopupMenuUtil.isEnableNERECheckMenuItemExceptT2000(this.m_oTaskTreeTable));
    }

    private void disableRetryMenuItem(boolean isBoardLevel) {
        this.getMenuItemForID("RetryOperation", this.m_oTaskMenuItemMap).setEnabled(TaskManagementPopupMenuManagerHelper.isEnableRetryMenuItem(this.m_oTaskTreeTable, isBoardLevel));
    }

    private void handleSelectedIsolationResource() {
        if (TaskManagementPopupMenuManagerHelper.isSelectedIsolationResource(this.m_oTaskTreeTable)) {
            this.enableMenuItem(false, "PauseOperation", "ContinueOperation", "RetryOperation", "RollbackOperation");
            if (this.m_taskKind == 13) {
                this.getMenuItemForID("RollbackOperation", this.m_oTaskMenuItemMap).setEnabled(true);
            }
        }
    }

    private void disableQueryMenuItem() {
        if (TaskTableUtil.isAnyOtherResPresentExceptDomain(this.m_oTaskTreeTable, 4)) {
            this.visibleEnableMenuItem("QueryOperation", this.m_oTaskMenuItemMap, false);
            return;
        }
        this.getMenuItemForID("QueryOperation", this.m_oTaskMenuItemMap).setEnabled(TaskManagementPopupMenuUtil.isEnbaleQueryMenuItem(this.m_oTaskTreeTable));
    }

    private void setStatusforExportAlarmDevicesMenuItem() {
        if (DCFrameWorkUtil.getIsSingleClient() && 4 == StandAloneDomainInfo.getInstance().getSelectedDomain()) {
            this.visibleEnableMenuItem("ExportAlarmDevices", this.m_oTaskMenuItemMap, true);
        } else {
            this.visibleEnableMenuItem("ExportAlarmDevices", this.m_oTaskMenuItemMap, false);
        }
    }

    private void setStatusforRefreshMenuItem() {
        int[] arrSelectedRows = this.m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length || 0 == this.m_oTaskTreeTable.getRowCount()) {
            return;
        }
        boolean isSelResInSingleTask = TaskTableUtil.isOnlySelResInSingleTask(this.m_oTaskTreeTable);
        if (!isSelResInSingleTask) {
            this.getMenuItemForID("RefreshSWDLStatusOperation", this.m_oTaskMenuItemMap).setEnabled(false);
            return;
        }
        TreeTableNode oNode = null;
        Task taskInfo = null;
        boolean bAllDeviceFailed = true;
        TreeTableRowData oDeviceNode = null;
        ResourceProgressInfo oResourceProgressInfo = null;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = this.m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || !((oNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject() instanceof TreeTableRowData)) continue;
            oDeviceNode = (TreeTableRowData)oNode.getUserObject();
            if (oDeviceNode.getUserObject() instanceof Resource) {
                oResourceProgressInfo = ((Resource)oDeviceNode.getUserObject()).getProgressInfo();
                if (bAllDeviceFailed && (null == oResourceProgressInfo || oResourceProgressInfo.getState() != 2 && oResourceProgressInfo.getState() != 4 || oResourceProgressInfo.getResult() != 1)) {
                    bAllDeviceFailed = false;
                }
            }
            TreeTableNode parentNode = (TreeTableNode)oNode.getParent();
            Object parentUserObj = parentNode.getUserObject();
            if (null != taskInfo || null == parentUserObj || !(parentUserObj instanceof TreeTableRowData)) continue;
            TreeTableRowData pTreeTableRowData = (TreeTableRowData)parentUserObj;
            taskInfo = (Task)pTreeTableRowData.getUserObject();
        }
        if (null == taskInfo) {
            return;
        }
        if (!taskInfo.isT2000Domain()) {
            this.visibleEnableMenuItem("RefreshSWDLStatusOperation", this.m_oTaskMenuItemMap, false);
            return;
        }
        int taskTypeID = taskInfo.getTaskTypeId();
        int taskState = taskInfo.getTaskProgressInfo().getState();
        int taskResult = taskInfo.getTaskProgressInfo().getResult();
        if (4 == StandAloneDomainInfo.getInstance().getSelectedDomain()) {
            if (taskTypeID == 4 || taskTypeID == 13 || taskTypeID == 5 || taskTypeID == 12 || taskTypeID == 2) {
                if (taskState == 0 || (taskState == 3 || taskState == 2) && taskResult == 1) {
                    this.getMenuItemForID("RefreshSWDLStatusOperation", this.m_oTaskMenuItemMap).setEnabled(true);
                } else if (taskState == 2 && bAllDeviceFailed) {
                    this.getMenuItemForID("RefreshSWDLStatusOperation", this.m_oTaskMenuItemMap).setEnabled(true);
                }
            } else if (this.getMenuItemForID("RefreshSWDLStatusOperation", this.m_oTaskMenuItemMap) != null) {
                this.getMenuItemForID("RefreshSWDLStatusOperation", this.m_oTaskMenuItemMap).setEnabled(false);
            }
        } else {
            this.getMenuItemForID("RefreshSWDLStatusOperation", this.m_oTaskMenuItemMap).setEnabled(false);
        }
    }

    public void doCleanUp() {
        if (null != this.m_oTaskMenuItemMap) {
            this.m_oTaskMenuItemMap.clear();
            this.m_oTaskMenuItemMap = null;
        }
        if (null != this.m_oTaskPopupMenu) {
            this.m_oTaskPopupMenu.removeAll();
            this.m_oTaskPopupMenu = null;
        }
        if (null != this.m_oResourcePopupMenu) {
            this.m_oResourcePopupMenu.removeAll();
            this.m_oResourcePopupMenu = null;
        }
        this.m_oTaskTreeTable = null;
    }

    private void disableViewAlarmMenu() {
        if (DCFrameWorkUtil.getIsSingleClient() || DCFrameWorkUtil.isPluginMode()) {
            MenuUtil.visibleMenuItem(this.getSeparatorForID("seperatorViewAlarm", this.separatorList), false);
            MenuUtil.visibleMenuItem(this.getMenuItemForID("ViewAlarmInfo", this.m_oTaskMenuItemMap), false);
            return;
        }
        MenuUtil.visibleMenuItem(this.getMenuItemForID("ViewAlarmInfo", this.m_oTaskMenuItemMap), true);
        int[] arrSelectedRows = this.m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ViewAlarmInfo", this.m_oTaskMenuItemMap), false);
            return;
        }
        if (TaskManagementPopupMenuUtil.isSelecDiffTask(this.m_oTaskTreeTable)) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ViewAlarmInfo", this.m_oTaskMenuItemMap), false);
        } else {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ViewAlarmInfo", this.m_oTaskMenuItemMap), true);
        }
    }

    private void enableMenuItem(boolean enable, String ... menuIds) {
        if (null == menuIds) {
            return;
        }
        for (String menu : menuIds) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID(menu, this.m_oTaskMenuItemMap), enable);
        }
    }

    private void visibleMenuItem(boolean enable, String ... menuIds) {
        if (null == menuIds) {
            return;
        }
        for (String menu : menuIds) {
            MenuUtil.visibleMenuItem(this.getMenuItemForID(menu, this.m_oTaskMenuItemMap), enable);
        }
    }

    private void disableModifySingleNEActiveGroupMenu() {
        int[] arrSelectedRows = this.m_oTaskTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return;
        }
        if (TaskTableUtil.isAnyOtherResPresentExceptDomain(this.m_oTaskTreeTable, 4)) {
            this.visibleEnableMenuItem("ModifySingleNEActiveGroup", this.m_oTaskMenuItemMap, false);
            return;
        }
        this.getMenuItemForID("ModifySingleNEActiveGroup", this.m_oTaskMenuItemMap).setVisible(true);
        this.getMenuItemForID("ModifySingleNEActiveGroup", this.m_oTaskMenuItemMap).setEnabled(TaskManagementPopupMenuUtil.isEnableModifySingleNEActiveGroupMenu(this.m_oTaskTreeTable));
    }
}

