/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfoLst;
import com.huawei.dc.common.dcmodule.DataCenterModuleManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.deviceoperation.deviceconfigchange.DeviceConfigEventReceiver;
import com.huawei.dc.deviceoperation.deviceconfigchange.IDeviceConfigChangeListener;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.taskmgmt.ITaskManagement;
import com.huawei.dc.taskmgmt.controller.ITaskAsynCommController;
import com.huawei.dc.taskmgmt.controller.ITaskSyncCommController;
import com.huawei.dc.taskmgmt.controller.LogInfoNotifier;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskEventID;
import com.huawei.dc.taskmgmt.controller.TaskInfoNotifier;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.view.common.TaskDeviceOperationDetailsPanel;
import com.huawei.dc.taskmgmt.view.common.TaskTableButtonPanel;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTablePanel;
import com.huawei.dc.taskmgmt.view.tasktree.TaskTreePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class TaskManagementPanel
extends JPanel
implements IDeviceConfigChangeListener,
ITaskManagement {
    private static final long serialVersionUID = 1L;
    private JSplitPane m_oVerticalSplitPane;
    private JSplitPane m_oHorizontalSplitPane;
    private TaskTreePanel m_oTaskTreePanel;
    private TaskTablePanel m_oTaskTablePanel;
    private TaskDeviceOperationDetailsPanel m_oOperationResultPane;
    private ITaskSyncCommController m_oTaskSyncController;
    private ITaskAsynCommController m_oTaskAsyncComCtrler;
    private TaskTableButtonPanel m_oTaskTableButtonPanel;
    private DataCenterModuleManager m_oDCModuleMgr;

    public TaskManagementPanel(DataCenterModuleManager dcModuleMgr) {
        this(dcModuleMgr, false);
    }

    public TaskManagementPanel(DataCenterModuleManager dcModuleMgr, boolean isAllowClosed) {
        super(isAllowClosed);
        this.m_oDCModuleMgr = dcModuleMgr;
        this.jbinit();
    }

    private void jbinit() {
        this.createSubPanels();
        this.addVerticalSplitPane();
        this.addHorizontalSplitPane();
        this.addPanelsToSplitPanes();
        this.addListenerForDeviceDeletion();
        this.setName("Componenets_DataCenterMainPanel_m_oTaskManagementPanel");
        DCHelpManager.getInstance().enableF1HelpKey(this, "HELP_TOPIC_TASK_MGMT");
    }

    private void addListenerForDeviceDeletion() {
        DeviceConfigEventReceiver.getInstance().resigterForConfigChangeEvent(this);
    }

    private void createSubPanels() {
        this.m_oTaskSyncController = this.getTaskController();
        this.m_oTaskAsyncComCtrler = this.getTaskAsyncCtrler();
        TaskDataModel.getInstance().clearTaskModel();
        this.m_oTaskSyncController.updateTaskTypes();
        this.m_oTaskTablePanel = new TaskTablePanel(this.m_oDCModuleMgr);
        this.m_oTaskTablePanel.setName("TaskMgmt_TaskManagementPanel_m_oTaskTablePanel");
        this.m_oTaskTablePanel.setMinimumSize(new Dimension(350, 100));
        this.m_oTaskTablePanel.setPreferredSize(new Dimension(540, 350));
        DCFrameWorkUtil.setTaskTablePanel(this.m_oTaskTablePanel);
        this.m_oTaskTreePanel = new TaskTreePanel(TaskDataModel.getInstance(), this.m_oTaskTablePanel);
        this.m_oTaskTreePanel.setName("TaskMgmt_TaskManagementPanel_m_oTaskTreePanel");
        this.m_oTaskTreePanel.setMinimumSize(new Dimension(200, 200));
        this.m_oTaskTreePanel.setPreferredSize(new Dimension(230, 200));
        this.m_oTaskTreePanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.m_oOperationResultPane = new TaskDeviceOperationDetailsPanel();
        this.m_oOperationResultPane.setName("TaskMgmt_TaskManagementPanel_m_oOperationResultPane");
        this.m_oOperationResultPane.setMinimumSize(new Dimension(200, 100));
        this.m_oOperationResultPane.setPreferredSize(new Dimension(230, 200));
        this.m_oTaskTablePanel.addDCEventListener(this.m_oOperationResultPane);
        this.m_oTaskTreePanel.addDCEventListener(this.m_oTaskTablePanel);
        TaskInfoNotifier.getInstance().addTaskNotificationListener(this.m_oTaskTreePanel);
        TaskInfoNotifier.getInstance().addTaskNotificationListener(this.m_oTaskTablePanel);
        this.m_oTaskTablePanel.openGettingTaskLstProgressDlg();
        ((TaskAsynCommController)this.m_oTaskAsyncComCtrler).setTaskTreeTableInstance(this.m_oTaskTablePanel.getTaskTreeTable());
        this.m_oTaskTableButtonPanel = new TaskTableButtonPanel(this.m_oTaskTablePanel);
        ObjectStore.getInstance().putObjectInstance("TaskTableButtonPanel", this.m_oTaskTableButtonPanel);
        this.m_oTaskTablePanel.addDCEventListener(this.m_oTaskTableButtonPanel);
    }

    protected ITaskAsynCommController getTaskAsyncCtrler() {
        return TaskAsynCommController.getInstance();
    }

    protected ITaskSyncCommController getTaskController() {
        return TaskSyncCommController.getInstance();
    }

    private void addVerticalSplitPane() {
        this.m_oVerticalSplitPane = new JSplitPane(0);
        this.m_oVerticalSplitPane.setName("TaskMgmt_TaskManagementPanel_m_oVerticalSplitPane");
        this.m_oVerticalSplitPane.setMinimumSize(new Dimension(285, 77));
        this.m_oVerticalSplitPane.setPreferredSize(new Dimension(285, 534));
        this.m_oVerticalSplitPane.setAutoscrolls(false);
        this.m_oVerticalSplitPane.setToolTipText("");
        this.m_oVerticalSplitPane.setContinuousLayout(true);
        this.m_oVerticalSplitPane.setOneTouchExpandable(false);
        this.m_oVerticalSplitPane.setDividerSize(6);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskManagementPanel.this.m_oVerticalSplitPane.setDividerLocation(520);
            }
        });
        this.m_oVerticalSplitPane.setResizeWeight(0.5);
        this.setLayout(new GridLayout());
    }

    private void addHorizontalSplitPane() {
        this.m_oHorizontalSplitPane = new JSplitPane(1);
        this.m_oHorizontalSplitPane.setName("TaskMgmt_TaskManagementPanel_m_oHorizontalSplitPane");
        this.m_oHorizontalSplitPane.setMinimumSize(new Dimension(285, 77));
        this.m_oHorizontalSplitPane.setPreferredSize(new Dimension(285, 534));
        this.m_oHorizontalSplitPane.setAutoscrolls(false);
        this.m_oHorizontalSplitPane.setContinuousLayout(true);
        this.m_oHorizontalSplitPane.setOneTouchExpandable(false);
        this.m_oHorizontalSplitPane.setDividerLocation(200);
        this.m_oHorizontalSplitPane.setDividerSize(6);
        this.setLayout(new GridLayout());
    }

    private void addPanelsToSplitPanes() {
        Box m_oBoxLayout = Box.createVerticalBox();
        m_oBoxLayout.add(this.m_oTaskTablePanel);
        m_oBoxLayout.add(this.m_oTaskTableButtonPanel);
        JPanel oTopPanel = new JPanel(new GridLayout());
        oTopPanel.add(m_oBoxLayout);
        this.m_oVerticalSplitPane.add((Component)oTopPanel, "top");
        this.m_oVerticalSplitPane.add((Component)this.m_oOperationResultPane, "bottom");
        this.m_oHorizontalSplitPane.add((Component)this.m_oTaskTreePanel, "left");
        this.m_oHorizontalSplitPane.add((Component)this.m_oVerticalSplitPane, "right");
        this.add((Component)this.m_oHorizontalSplitPane, null);
    }

    private void handleDeviceDeleteNotification(final AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        Thread oThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (null == oDeviceInfoList || 0 == oDeviceInfoList.size()) {
                    return;
                }
                int noOfDevices = oDeviceInfoList.size();
                AsnDCDeviceSubmapNtfnInfo asnDeviceInfo = null;
                ArrayList<Resource> oResList = new ArrayList<Resource>(4);
                Resource oResource = null;
                for (int i = 0; i < noOfDevices; ++i) {
                    asnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
                    oResource = new Resource();
                    oResource.setDeviceID(asnDeviceInfo.oDeviceInfo.iDevId.intValue());
                    oResList.add(oResource);
                }
                TaskEvent taskEvent = new TaskEvent(oResList, TaskEventID.RESOURCE_DELETION);
                TaskDataModel.getInstance().notifyTaskEvent(taskEvent);
                TaskEvent oTaskEvent = new TaskEvent(Boolean.TRUE, TaskEventID.TASK_LIST_REFRESH);
                TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
            }
        });
        oThread.start();
    }

    @Override
    public void disposePanel() {
        DeviceConfigEventReceiver.getInstance().unResigterForConfigChangeEvent(this);
        this.removeAll();
        if (null != this.m_oTaskTreePanel) {
            this.m_oTaskTreePanel.disposePanel();
            this.m_oTaskTreePanel = null;
        }
        if (null != this.m_oTaskTablePanel) {
            this.m_oTaskTablePanel.disposePanel();
            this.m_oTaskTablePanel = null;
        }
        if (null != this.m_oTaskTableButtonPanel) {
            this.m_oTaskTableButtonPanel.disposePanel();
            this.m_oTaskTableButtonPanel = null;
        }
        if (null != this.m_oOperationResultPane) {
            this.m_oOperationResultPane.disposePanel();
            this.m_oOperationResultPane = null;
            LogInfoNotifier.getInstance().clearAllListeners();
        }
        if (null != this.m_oVerticalSplitPane) {
            this.m_oVerticalSplitPane.removeAll();
            this.m_oVerticalSplitPane = null;
        }
        if (null != this.m_oHorizontalSplitPane) {
            this.m_oHorizontalSplitPane.removeAll();
            this.m_oHorizontalSplitPane = null;
        }
        this.m_oTaskSyncController = null;
        this.m_oTaskAsyncComCtrler = null;
    }

    @Override
    public void refreshTaskManagement() {
        this.m_oTaskSyncController = TaskSyncCommController.getInstance();
        this.m_oTaskAsyncComCtrler = TaskAsynCommController.getInstance();
        TaskDataModel.getInstance().clearTaskModel();
        this.m_oTaskSyncController.updateTaskTypes();
        this.m_oTaskTreePanel.refreshData();
        this.m_oTaskTablePanel.refreshData();
        this.m_oTaskAsyncComCtrler.getTaskList();
        this.m_oTaskTablePanel.openGettingTaskLstProgressDlg();
    }

    public void setHelpKeyValue(String strHelpKeyValue) {
        DCHelpManager.getInstance().enableF1HelpKey(this, strHelpKeyValue);
    }

    @Override
    public void handleDeviceConfigNotification(int iEventType, AsnDCDeviceSubmapNtfnInfoLst deviceInfoList) {
        switch (iEventType) {
            case 1: 
            case 7: {
                this.handleDeviceDeleteNotification(deviceInfoList);
                break;
            }
        }
    }

    @Override
    public String getTitle() {
        return ResourceManager.getInstance().getResString("TASK_MANAGEMENT_TAB_TITLE");
    }
}

