/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.NumberTextField;
import com.huawei.dc.taskmgmt.controller.ITaskNotificationListener;
import com.huawei.dc.taskmgmt.controller.LogInfoNotifier;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskEventID;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.isolation.model.IsolationTaskInfoObj;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.model.TaskDeviceLogInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class TaskDeviceOperationLogPanel
extends JPanel
implements ITaskNotificationListener,
DCTreeEventListener {
    private static final long serialVersionUID = 6014216003374227589L;
    private JEditorPane m_oLogInformation = null;
    private JScrollPane m_oScrollPane = null;
    private JButton m_oNextButton = null;
    private JButton m_oPreButton = null;
    private JButton m_oGoToButton = null;
    private NumberTextField m_oGoToFiled = null;
    private JLabel m_oTotalPage = null;
    private JPanel m_oButtonPanel = null;
    private static final String HTML_START_TAG = "<html><head></head><body>";
    private static final String HTML_CLOSE_TAG = "</body></html>";
    private int m_iTaskID = -1;
    private int m_iDevID = -1;
    private int m_iStackID = -1;
    boolean m_isIsolation = false;
    private Resource m_oCurrentResource = null;

    public TaskDeviceOperationLogPanel() {
        this(false);
    }

    public TaskDeviceOperationLogPanel(boolean isIsolation) {
        this.m_isIsolation = isIsolation;
        LogInfoNotifier.getInstance().addListenerToProcessResponse(this);
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BorderLayout());
        this.m_oLogInformation = new JEditorPane();
        this.m_oLogInformation.setContentType("text/html");
        this.m_oLogInformation.setEditable(false);
        this.m_oLogInformation.setName("Text_Area_taskmgmt.view.common");
        this.m_oScrollPane = new JScrollPane(this.m_oLogInformation);
        this.createButtonPanel();
        this.add((Component)this.m_oScrollPane, "Center");
        this.add((Component)this.m_oButtonPanel, "South");
    }

    private void createButtonPanel() {
        this.m_oButtonPanel = new JPanel();
        this.m_oButtonPanel.setLayout(new FlowLayout(2));
        this.m_oButtonPanel.setName("TaskDeviceOperationLogPanel_ButtonPanel");
        this.m_oPreButton = new JButton(ResourceManager.getInstance().getResString("NE_Operation_Log_Pre_Button"));
        this.m_oPreButton.setMinimumSize(new Dimension(60, 23));
        this.m_oPreButton.setName("TaskDeviceOperationLogPanel_PreButton");
        this.m_oPreButton.setEnabled(false);
        this.m_oNextButton = new JButton(ResourceManager.getInstance().getResString("NE_Operation_Log_Next_Button"));
        this.m_oNextButton.setMinimumSize(new Dimension(60, 23));
        this.m_oNextButton.setName("TaskDeviceOperationLogPanel_NextButton");
        this.m_oNextButton.setEnabled(false);
        this.m_oGoToButton = new JButton(ResourceManager.getInstance().getResString("NE_Operation_Log_Go_Button"));
        this.m_oGoToButton.setMinimumSize(new Dimension(60, 23));
        this.m_oGoToButton.setName("TaskDeviceOperationLogPanel_GoToButton");
        this.m_oGoToButton.setEnabled(false);
        this.m_oGoToFiled = new NumberTextField();
        this.m_oGoToFiled.setMinimumSize(new Dimension(60, 23));
        this.m_oGoToFiled.setPreferredSize(new Dimension(40, 23));
        this.m_oGoToFiled.setName("TaskDeviceOperationLogPanel_GoToFiled");
        this.m_oGoToFiled.setEnabled(false);
        this.m_oTotalPage = new JLabel();
        this.m_oTotalPage.setMinimumSize(new Dimension(60, 23));
        this.m_oTotalPage.setName("TaskDeviceOperationLogPanel_TotalPage");
        this.m_oButtonPanel.add(this.m_oPreButton);
        this.m_oButtonPanel.add(this.m_oNextButton);
        this.m_oButtonPanel.add(this.m_oGoToFiled);
        this.m_oButtonPanel.add(this.m_oGoToButton);
        this.m_oButtonPanel.add(this.m_oTotalPage);
        this.initCompnentAction();
    }

    private void initCompnentAction() {
        this.initPreButtonAction();
        this.initNextButtonAction();
        this.initGoToButtonAction();
    }

    private void initPreButtonAction() {
        this.m_oPreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (null == TaskDeviceOperationLogPanel.this.m_oCurrentResource || !TaskDeviceOperationLogPanel.this.m_oPreButton.isEnabled()) {
                    return;
                }
                TaskDeviceOperationLogPanel.this.m_oCurrentResource.getLogInfoObject().removeCurrentPage();
                TaskDeviceOperationLogPanel.this.addLogInformation(TaskDeviceOperationLogPanel.this.m_oCurrentResource);
            }
        });
    }

    private void initNextButtonAction() {
        this.m_oNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (null == TaskDeviceOperationLogPanel.this.m_oCurrentResource || !TaskDeviceOperationLogPanel.this.m_oNextButton.isEnabled()) {
                    return;
                }
                TaskDeviceOperationLogPanel.this.m_oCurrentResource.getLogInfoObject().addCurrentPage();
                TaskDeviceOperationLogPanel.this.addLogInformation(TaskDeviceOperationLogPanel.this.m_oCurrentResource);
            }
        });
    }

    private void initGoToButtonAction() {
        this.m_oGoToButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (null == TaskDeviceOperationLogPanel.this.m_oCurrentResource || !TaskDeviceOperationLogPanel.this.m_oGoToButton.isEnabled()) {
                    return;
                }
                String goToPage = TaskDeviceOperationLogPanel.this.m_oGoToFiled.getText();
                int goToPageNum = Integer.parseInt(goToPage);
                if (0 == goToPageNum || goToPageNum > TaskDeviceOperationLogPanel.this.m_oCurrentResource.getLogInfoObject().getTotalPage()) {
                    DCOptionPane.showErrorDialog(null, ResourceManager.getInstance().getResString("NE_Operation_Log_ErrorPage"));
                    return;
                }
                TaskDeviceOperationLogPanel.this.m_oCurrentResource.getLogInfoObject().setCurrentPage(goToPageNum);
                TaskDeviceOperationLogPanel.this.addLogInformation(TaskDeviceOperationLogPanel.this.m_oCurrentResource);
            }
        });
    }

    public void addLogInformation(Resource oRes) {
        StringBuffer str = new StringBuffer("");
        TaskDeviceLogInfo oTaskDeviceLogInfo = null;
        if (null != oRes) {
            oTaskDeviceLogInfo = oRes.getLogInfoObject();
            str.append(oTaskDeviceLogInfo.getLogInfo());
            this.m_oTotalPage.setText(oTaskDeviceLogInfo.getPageContent());
            this.setButtonEnable(oTaskDeviceLogInfo.getCurrentPage(), oTaskDeviceLogInfo.getTotalPage());
            this.m_oButtonPanel.setVisible(true);
            if (oTaskDeviceLogInfo.getCurrentPage() == oTaskDeviceLogInfo.getCurrentPage()) {
                if (str.toString().equals("")) {
                    this.m_oButtonPanel.setVisible(false);
                }
                this.setLogInfo(str.toString());
            }
        } else {
            this.m_oButtonPanel.setVisible(false);
            this.setLogInfo(str.toString());
        }
    }

    public void doCleanUp() {
        LogInfoNotifier.getInstance().removeNotificationListener(this);
        if (null != this.m_oLogInformation) {
            this.m_oLogInformation.removeAll();
            this.m_oLogInformation = null;
        }
        if (null != this.m_oScrollPane) {
            this.m_oScrollPane = null;
        }
    }

    public void clearLogInforamtion() {
        this.setLogInfo("");
        this.m_oButtonPanel.setVisible(false);
    }

    @Override
    public void onTaskNotification(TaskEvent oEvent) {
        boolean isUpdateLogInfo = true;
        ITask oTask = TaskDataModel.getInstance().getTask(this.m_iTaskID);
        if (this.m_isIsolation) {
            if (null == oTask || !IsolationCommonOperation.isIsolationTask(oTask.getTaskTypeId())) {
                isUpdateLogInfo = false;
            }
        } else if (null != oTask && IsolationCommonOperation.isIsolationTask(oTask.getTaskTypeId())) {
            isUpdateLogInfo = false;
        }
        if (isUpdateLogInfo && oEvent.getSource() instanceof Resource) {
            Resource oRes = (Resource)oEvent.getSource();
            if (this.m_iTaskID == oEvent.getTaskID() && this.m_iDevID == oRes.getDeviceID() && this.m_iStackID == oRes.getStackId()) {
                if (oRes.getLogInfoObject().getCurrentPage() == oRes.getLogInfoObject().getLastPage()) {
                    this.setLogInfo(oRes.getLogInfoObject().getLogInfo());
                }
                this.m_oTotalPage.setText(oRes.getLogInfoObject().getPageContent());
                this.setButtonEnable(oRes.getLogInfoObject().getCurrentPage(), oRes.getLogInfoObject().getTotalPage());
                if (!this.m_oButtonPanel.isVisible()) {
                    this.m_oButtonPanel.setVisible(true);
                }
            }
        }
    }

    private void updateLogUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != TaskDeviceOperationLogPanel.this.m_oScrollPane) {
                    TaskDeviceOperationLogPanel.this.m_oScrollPane.getVerticalScrollBar().setValue(TaskDeviceOperationLogPanel.this.m_oScrollPane.getVerticalScrollBar().getMaximum());
                }
                TaskDeviceOperationLogPanel.this.repaint();
            }
        });
    }

    @Override
    public void onTreeInit(DCEventObject eventObject) {
    }

    @Override
    public void onTreeNodeSelection(DCEventObject eventObject) {
        if (eventObject instanceof TaskEvent) {
            TaskEvent oTaskEvent = (TaskEvent)eventObject;
            if (TaskEventID.DC_UPDATE_ISOLATION_OPERATION_PROGRESS == oTaskEvent.getTaskEventType()) {
                return;
            }
            this.clearLogInforamtion();
            Resource oRes = null;
            if (oTaskEvent.getSource() instanceof Resource) {
                oRes = (Resource)oTaskEvent.getSource();
            } else if (oTaskEvent.getSource() instanceof IsolationTaskInfoObj) {
                IsolationTaskInfoObj taskInfoObj = (IsolationTaskInfoObj)oTaskEvent.getSource();
                if (3 == taskInfoObj.getNodeType()) {
                    return;
                }
                oRes = taskInfoObj.getResource();
            } else {
                oRes = null;
            }
            if (null != oRes) {
                oRes.getLogInfoObject().setToGetOldData(false);
                oRes.getLogInfoObject().clearLogInfo();
                this.m_iTaskID = oTaskEvent.getTaskID();
                this.m_iDevID = oRes.getDeviceID();
                this.m_iStackID = oRes.getStackId();
                this.m_oCurrentResource = oRes;
                ITask oTask = TaskDataModel.getInstance().getTask(this.m_iTaskID);
                if (oTask.isT2000Domain() && oRes.isBoard()) {
                    DCDebugTracer.trace("DC::TaskOprDetailsController::onTreeNodeSelection::m_iTaskID = " + this.m_iTaskID + ";deviceID = " + oRes.getDeviceID() + ";deviceName = " + oRes.getDeviceName());
                    return;
                }
                TaskAsynCommController.getInstance().getDeviceOperationLogs(oTaskEvent.getTaskID(), oRes.getDeviceID(), oRes.getStackId());
            }
        }
    }

    private void setButtonEnable(int currentPage, int totalPage) {
        if (currentPage > 1) {
            this.m_oPreButton.setEnabled(true);
        } else {
            this.m_oPreButton.setEnabled(false);
        }
        if (currentPage == totalPage) {
            this.m_oNextButton.setEnabled(false);
        } else {
            this.m_oNextButton.setEnabled(true);
        }
        if (totalPage > 1) {
            this.m_oGoToFiled.setEnabled(true);
            this.m_oGoToButton.setEnabled(true);
        } else {
            this.m_oGoToFiled.setEnabled(false);
            this.m_oGoToButton.setEnabled(false);
        }
        if (null != this.m_oCurrentResource) {
            int iTotalPageNum = this.m_oCurrentResource.getLogInfoObject().getTotalPage();
            if (this.m_oGoToFiled.getText().equals("") || this.m_oGoToFiled.getIntValue() > iTotalPageNum) {
                String strTotalPageNum = "";
                try {
                    strTotalPageNum = String.valueOf(iTotalPageNum);
                    this.m_oGoToFiled.setText(strTotalPageNum);
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
    }

    public void disposePanel() {
        this.m_oLogInformation = null;
        this.m_oScrollPane = null;
        this.m_oCurrentResource = null;
    }

    public void setToNULL() {
        this.disposePanel();
    }

    private void setLogInfo(String strLog) {
        DCDebugTracer.trace("TaskDeviceOperationLogPanel#setLogInfo Start:");
        String strHTMLTags = HTML_START_TAG + strLog + HTML_CLOSE_TAG;
        try {
            if (null != this.m_oLogInformation) {
                this.m_oLogInformation.setText(strHTMLTags);
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            DCDebugTracer.trace("recreate m_oLogInformation and print : " + strHTMLTags);
            if (null != this.m_oLogInformation) {
                this.m_oScrollPane.remove(this.m_oLogInformation);
                this.m_oLogInformation.removeAll();
            }
            this.m_oLogInformation = null;
            this.m_oLogInformation = new JEditorPane();
            this.m_oLogInformation.setContentType("text/html");
            this.m_oLogInformation.setEditable(false);
            this.m_oLogInformation.setName("Text_Area_taskmgmt.view.common");
            this.m_oScrollPane.add(this.m_oLogInformation);
            this.m_oLogInformation.setText(strHTMLTags);
        }
        this.updateLogUI();
        DCDebugTracer.trace("TaskDeviceOperationLogPanel#setLogInfo End:");
    }
}

