/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.OperationIdStore;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskEventID;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.ITaskSubOperation;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.view.common.HyperLinkLabel;
import com.huawei.dc.taskmgmt.view.common.TaskSubOperationMainPanel;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class TaskDeviceOperationListPanel
extends JPanel {
    private static final long serialVersionUID = 4171852283742828004L;
    private Vector<List> m_oOperationSelected = new Vector();
    private boolean m_bIsDeviceSelected = false;
    private GridLayout m_oGridLayout = null;
    private TaskSubOperationMainPanel m_oOprDetailsPanelInstance = null;
    private int m_iDevID = -1;
    private THashSet<Resource> m_oResList = null;
    private HashMap<Integer, HyperLinkLabel> m_oHyperLinkLabelMap = new HashMap();
    private int m_iCurrentRunningOprID = -1;
    private ITask m_oTask = null;
    private int m_bOprSelectedForDetails = -1;
    private static final ImageIcon ERROR_ICON = ResourceManager.getInstance().getImage("error2.gif");
    private static final ImageIcon DONE_ICON = ResourceManager.getInstance().getImage("done.gif");
    private static final ImageIcon ONDO_ICON = ResourceManager.getInstance().getImage("ondo.gif");
    private static final ImageIcon PAUSE_ICON = ResourceManager.getInstance().getImage("pause.gif");
    private static final ImageIcon READY_ICON = ResourceManager.getInstance().getImage("ready.gif");

    public TaskDeviceOperationListPanel() {
        this.initPanel();
    }

    private void initPanel() {
        this.m_oGridLayout = new GridLayout();
        this.setLayout(this.m_oGridLayout);
    }

    public void onTreeNodeSelection(ITask oTaskObj, DCEventObject oEventObject) {
        DCDebugTracer.trace("[upgrade step] method TaskDeviceOperationListPanel#onTreeNodeSelection start");
        this.onTreeNodeSelection(oTaskObj, oEventObject, null);
        DCDebugTracer.trace("[upgrade step] method TaskDeviceOperationListPanel#onTreeNodeSelection end..");
    }

    public void onTreeNodeSelection(ITask oTaskObj, DCEventObject oEventObject, Resource res) {
        this.m_iCurrentRunningOprID = -1;
        this.m_oTask = oTaskObj;
        if (oEventObject instanceof TaskEvent && TaskEventID.DEVICE_SUB_OPR_NOTIFICATION != ((TaskEvent)oEventObject).getTaskEventType()) {
            this.m_bIsDeviceSelected = true;
            if (oTaskObj.getTaskId() == ((TaskEvent)oEventObject).getTaskID()) {
                this.onResourceNotification(oEventObject);
                this.m_oTask = TaskDataModel.getInstance().getTask(((TaskEvent)oEventObject).getTaskID());
                return;
            }
            this.m_bIsDeviceSelected = false;
        }
        this.updateOprSelectedList();
        this.reInitPanel();
        this.updateTablepanel(res);
    }

    private void updateOprSelectedList() {
        List<ITaskDeviceOperation> oOprList = this.m_oTask.getSupportedOperation();
        int iLen = oOprList.size();
        this.m_oOperationSelected.clear();
        this.m_oResList = this.m_oTask.getDeviceType().getResources();
        List oTemp = null;
        ITaskDeviceOperation oObj = null;
        for (int i = 0; i < iLen; ++i) {
            oObj = oOprList.get(i);
            oTemp = oObj.getOperationIDnName();
            if (!oObj.isSelected() || null == oTemp || 0 == ((String)oTemp.get(0)).length()) continue;
            this.m_oOperationSelected.add(oTemp);
        }
    }

    private void updateTablepanel(Resource res) {
        if (this.m_bIsDeviceSelected) {
            if (-1 == this.m_iCurrentRunningOprID) {
                this.updateTable((Integer)((ArrayList)this.m_oOperationSelected.get(0)).get(1), res);
            } else {
                HyperLinkLabel oHyperLinkLabel = this.getHyperLinkLabel(this.m_iCurrentRunningOprID);
                oHyperLinkLabel.setText("<html><B>" + oHyperLinkLabel.getText() + "</B></html>");
                this.updateTable(this.m_iCurrentRunningOprID, res);
            }
        } else if (-1 == this.m_bOprSelectedForDetails) {
            this.updateTable((Integer)((ArrayList)this.m_oOperationSelected.get(0)).get(1), res);
        } else {
            this.updateTable(this.m_bOprSelectedForDetails, res);
        }
    }

    public void reInitializeSelectedOpr() {
        this.m_bOprSelectedForDetails = -1;
    }

    private void reInitializeLayoutSetting() {
        this.removeAll();
        this.m_oGridLayout.setRows(1);
        this.m_oGridLayout.setColumns(0);
        this.invalidate();
        this.m_oGridLayout = new GridLayout(this.m_oGridLayout.getRows() + this.m_oOperationSelected.size() - 1, 1);
        this.setLayout(this.m_oGridLayout);
        this.validate();
        this.repaint();
    }

    private synchronized void reInitPanel() {
        int OPR_ID = 1;
        int OPR_NAME = 0;
        this.reInitializeLayoutSetting();
        HyperLinkLabel oHyperLinkLabel = null;
        ArrayList oTemp = null;
        int iOprID = -1;
        int iOprStatus = -1;
        int iSize = this.m_oOperationSelected.size();
        boolean bSetCurOperIDForTaskLevel = false;
        int iCurInprogressOperID = -1;
        int iCurParseOperID = -1;
        for (int i = 0; i < iSize; ++i) {
            oTemp = (ArrayList)this.m_oOperationSelected.get(i);
            iOprID = (Integer)oTemp.get(1);
            oHyperLinkLabel = this.getHyperLinkLabel(iOprID);
            oHyperLinkLabel.setText((String)oTemp.get(OPR_NAME));
            oHyperLinkLabel.setName(oHyperLinkLabel.getText() + "_Label_taskmgmt.view.common");
            if (this.m_bIsDeviceSelected) {
                iOprStatus = this.getOprStatusForSelectedResource((Integer)oTemp.get(OPR_ID));
            } else if (0 != this.m_oTask.getTaskProgressInfo().getState() && 1 == (iOprStatus = this.getOprStatusForSelectedTask((Integer)oTemp.get(OPR_ID)))) {
                String str = oHyperLinkLabel.getText();
                oHyperLinkLabel.setText("<html><B>" + str + "</B></html>");
                if (!bSetCurOperIDForTaskLevel) {
                    bSetCurOperIDForTaskLevel = true;
                    this.m_iCurrentRunningOprID = iOprID;
                }
            }
            oHyperLinkLabel.setOperationStatus(iOprStatus);
            oHyperLinkLabel.setOperationID(iOprID);
            int result = -1;
            if (this.m_bIsDeviceSelected) {
                result = this.getOprResultForSelectedDev(iOprID);
                oHyperLinkLabel.setIcon(this.getIconBasedOnStatus(iOprStatus, result));
            } else {
                result = this.getOprResultForSelectedTask(iOprID);
                oHyperLinkLabel.setIcon(this.getIconBasedOnStatus(iOprStatus, result));
            }
            if (1 == iOprStatus && this.m_bIsDeviceSelected) {
                iCurInprogressOperID = iOprID;
            } else if (4 == iOprStatus && this.m_bIsDeviceSelected) {
                iCurParseOperID = iOprID;
            }
            this.add(oHyperLinkLabel);
            this.m_oHyperLinkLabelMap.remove(iOprID);
            this.m_oHyperLinkLabelMap.put(iOprID, oHyperLinkLabel);
        }
        if (-1 != iCurInprogressOperID) {
            this.m_iCurrentRunningOprID = iCurInprogressOperID;
        } else if (-1 != iCurParseOperID) {
            this.m_iCurrentRunningOprID = iCurParseOperID;
        }
        oHyperLinkLabel = null;
    }

    private HyperLinkLabel getHyperLinkLabel(int iOprID) {
        HyperLinkLabel oHyperLinkLabel = null;
        oHyperLinkLabel = this.m_oHyperLinkLabelMap.get(iOprID);
        if (null == oHyperLinkLabel) {
            oHyperLinkLabel = new HyperLinkLabel();
            oHyperLinkLabel.addActionListener(new CustomActionListener(iOprID));
        }
        return oHyperLinkLabel;
    }

    private ImageIcon getIconBasedOnStatus(int iOperationStatus, int result) {
        ImageIcon oIcon = null;
        switch (iOperationStatus) {
            case 2: 
            case 3: {
                if (1 == result) {
                    oIcon = ERROR_ICON;
                    break;
                }
                oIcon = DONE_ICON;
                break;
            }
            case 1: {
                oIcon = ONDO_ICON;
                break;
            }
            case 4: {
                oIcon = PAUSE_ICON;
                break;
            }
            case 0: {
                oIcon = READY_ICON;
                break;
            }
            default: {
                oIcon = READY_ICON;
            }
        }
        return oIcon;
    }

    public void setOperationDetailsPanelInstance(TaskSubOperationMainPanel oOprDetailsPanel) {
        this.m_oOprDetailsPanelInstance = oOprDetailsPanel;
    }

    public void setNodeSelected(boolean isDeviceNodeSelected) {
        this.m_bIsDeviceSelected = isDeviceNodeSelected;
    }

    public void setDeviceID(int iDevID) {
        this.m_iDevID = iDevID;
    }

    private int getOprStatusForSelectedResource(int iOprID) {
        DCDebugTracer.traceDetail("[Device Step] method getOprStatusForSelectedResource start");
        Resource oRes = this.getReource();
        DCDebugTracer.traceDetail("[Device Step] oRes ID" + oRes.getDeviceID() + " oRes Name " + oRes.getDeviceName());
        ITaskSubOperation oTaskOprDetails = null;
        int iOprStatus = -1;
        oTaskOprDetails = oRes.getSubOprInfo(iOprID);
        if (null != oTaskOprDetails) {
            iOprStatus = oTaskOprDetails.getOprStatus();
        }
        DCDebugTracer.traceDetail("[Device Step] method getOprStatusForSelectedResource end.. iOprStatus : " + iOprStatus);
        return iOprStatus;
    }

    private int getOprStatusForSelectedTask(int iOprID) {
        THashSet<Resource> oResList = this.m_oTask.getDeviceType().getResources();
        int iOprStatus = 0;
        String strOprID = OperationIdStore.getInstance().getOperationStrId(iOprID);
        ResourceProgressInfo oResourceProgressInfo = null;
        Iterator oResItor = oResList.iterator();
        Resource oRes = null;
        TIntArrayList oDevStateLst = new TIntArrayList();
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            oResourceProgressInfo = oRes.getProgressInfo();
            if (null != oResourceProgressInfo && strOprID.equals(oResourceProgressInfo.getCurrentOperationId())) {
                iOprStatus = oResourceProgressInfo.getState();
            } else {
                oResourceProgressInfo = oRes.getOprResultInfo(strOprID);
                if (null != oResourceProgressInfo) {
                    iOprStatus = oResourceProgressInfo.getState();
                }
            }
            oDevStateLst.add(iOprStatus);
            if (1 == iOprStatus) {
                if (null == oResourceProgressInfo || oResourceProgressInfo.getResult() >= 0) continue;
                oDevStateLst.add(iOprStatus);
                break;
            }
            oDevStateLst.add(iOprStatus);
        }
        if (oDevStateLst.contains(1)) {
            return 1;
        }
        if (oDevStateLst.contains(4)) {
            return 4;
        }
        return iOprStatus;
    }

    private int getOprResultForSelectedTask(int iOprID) {
        DCDebugTracer.traceDetail("[Device Step] iOprID : " + iOprID);
        THashSet<Resource> oResList = this.m_oTask.getDeviceType().getResources();
        int iOprResult = -1;
        String strOprID = OperationIdStore.getInstance().getOperationStrId(iOprID);
        ResourceProgressInfo oResourceProgressInfo = null;
        Iterator oResItor = oResList.iterator();
        Resource oRes = null;
        TIntArrayList oDevStateLst = new TIntArrayList();
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            oResourceProgressInfo = oRes.getOprResultInfo(strOprID);
            if (null == oResourceProgressInfo) continue;
            iOprResult = oResourceProgressInfo.getResult();
            oDevStateLst.add(iOprResult);
            if (2 != oResourceProgressInfo.getResult()) continue;
        }
        if (oDevStateLst.contains(2)) {
            return 2;
        }
        if (oDevStateLst.contains(1)) {
            return 1;
        }
        DCDebugTracer.traceDetail("[Device Step] iOprResult : " + iOprResult);
        return iOprResult;
    }

    private int getOprResultForSelectedDev(int iOprID) {
        DCDebugTracer.trace("[Device Step] iOprID : " + iOprID);
        int iOprResult = -1;
        Resource oRes = this.getReource();
        if (null != oRes) {
            DCDebugTracer.trace("getOprResultForSelectedDev:" + oRes);
            String strOprID = OperationIdStore.getInstance().getOperationStrId(iOprID);
            ResourceProgressInfo oResourceProgressInfo = null;
            oResourceProgressInfo = oRes.getOprResultInfo(strOprID);
            DCDebugTracer.trace("[Device Step] strOprID : " + strOprID);
            if (null != oResourceProgressInfo) {
                iOprResult = oResourceProgressInfo.getResult();
            } else {
                oResourceProgressInfo = oRes.getResultForOperation(strOprID);
                if (null != oResourceProgressInfo) {
                    iOprResult = oResourceProgressInfo.getResult();
                } else {
                    DCDebugTracer.trace("[Device Step] get ag by getResultForOperation() is null.");
                }
                DCDebugTracer.trace("[Device Step] getOperationStrId() get null,get ag by getResultForOperation()");
            }
            DCDebugTracer.trace("[Device Step] getOprResultInfo iOprResult : " + iOprResult);
            oResourceProgressInfo = oRes.getResultForOperation(strOprID);
            if (null != oResourceProgressInfo) {
                DCDebugTracer.trace("[Device Step] getResultForOperation iOprResult : " + oResourceProgressInfo.getResult());
            }
        }
        DCDebugTracer.traceDetail("[Device Step] iOprResult : " + iOprResult);
        return iOprResult;
    }

    private Resource getReource() {
        Iterator oResItor = this.m_oResList.iterator();
        Resource oRes = null;
        while (oResItor.hasNext() && this.m_iDevID != (oRes = (Resource)oResItor.next()).getDeviceID()) {
        }
        return oRes;
    }

    private void updateTable(int iCurrentOprID, Resource res) {
        boolean OPR_ID = true;
        switch (iCurrentOprID) {
            case -1: {
                this.m_oOprDetailsPanelInstance.updateOprDetailsTable((Integer)((ArrayList)this.m_oOperationSelected.get(0)).get(1));
                break;
            }
            default: {
                this.m_oOprDetailsPanelInstance.updateOprDetailsTable(iCurrentOprID, res);
            }
        }
    }

    private void highLightCurrentOpr() {
        HyperLinkLabel oHyperLinkLabel = null;
        if (-1 != this.m_iCurrentRunningOprID) {
            oHyperLinkLabel = this.m_oHyperLinkLabelMap.get(this.m_iCurrentRunningOprID);
            String str = oHyperLinkLabel.getText();
            oHyperLinkLabel.setText("<html><B>" + str + "</B></html>");
        }
    }

    public void onResourceNotification(DCEventObject oEventObject) {
        Resource oRes = (Resource)oEventObject.getSource();
        ResourceProgressInfo oResourceProgress = oRes.getProgressInfo();
        DCDebugTracer.trace("task device oplist panal on resource notify state " + oResourceProgress.getState() + " result " + oResourceProgress.getResult());
        this.m_iCurrentRunningOprID = OperationIdStore.getInstance().getOperationId(oResourceProgress.getCurrentOperationId());
        HyperLinkLabel oHyperLinkLabel = this.m_oHyperLinkLabelMap.get(this.m_iCurrentRunningOprID);
        int iState = this.getState(oResourceProgress);
        oHyperLinkLabel.setIcon(this.getIconBasedOnStatus(iState, oResourceProgress.getResult()));
        if (1 == iState || 4 == iState) {
            this.highLightCurrentOpr();
        } else {
            String str = oHyperLinkLabel.getText();
            oHyperLinkLabel.setText(str);
        }
        this.updateTable(this.m_iCurrentRunningOprID, null);
    }

    private int getState(ResourceProgressInfo oResProg) {
        int iOprStatus = -1;
        switch (oResProg.getState()) {
            case 0: {
                iOprStatus = 0;
                break;
            }
            case 3: {
                iOprStatus = 3;
                break;
            }
            case 1: 
            case 4: {
                iOprStatus = 1;
                break;
            }
        }
        return iOprStatus;
    }

    public void doCleanUp() {
        if (null != this.m_oOperationSelected) {
            this.m_oOperationSelected.removeAllElements();
            this.m_oOperationSelected = null;
        }
        if (null != this.m_oGridLayout) {
            this.m_oGridLayout = null;
        }
        if (null != this.m_oOprDetailsPanelInstance) {
            this.m_oOprDetailsPanelInstance.doCleanUp();
        }
        if (null != this.m_oResList) {
            this.m_oResList.clear();
            this.m_oResList = null;
        }
        if (null != this.m_oHyperLinkLabelMap) {
            this.m_oHyperLinkLabelMap.clear();
            this.m_oHyperLinkLabelMap = null;
        }
        if (null != this.m_oTask) {
            this.m_oTask = null;
        }
    }

    public void removeAllComponents() {
        try {
            Thread.sleep(128L);
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
        if (null != this.m_oHyperLinkLabelMap) {
            this.m_oHyperLinkLabelMap.clear();
        }
        this.removeAll();
        DCFrameWorkUtil.updateUI(this);
    }

    class CustomActionListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = 7010879645338361138L;
        int iCurrentOprID = -1;

        public CustomActionListener(int iOprID) {
            this.iCurrentOprID = iOprID;
        }

        @Override
        public void actionPerformed(ActionEvent oEvent) {
            TaskDeviceOperationListPanel.this.updateTable(this.iCurrentOprID, null);
            TaskDeviceOperationListPanel.this.m_bOprSelectedForDetails = this.iCurrentOprID;
        }
    }
}

