/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.deviceview.common.DeviceTreeTableDataSelectionEventObject;
import com.huawei.dc.taskmgmt.controller.LogInfoNotifier;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskEventID;
import com.huawei.dc.taskmgmt.controller.TaskOprDetailsController;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.view.common.TaskDeviceOperationListPanel;
import com.huawei.dc.taskmgmt.view.common.TaskDeviceOperationLogPanel;
import com.huawei.dc.taskmgmt.view.common.TaskSubOperationMainPanel;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTablePanel;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTableUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class TaskDeviceOperationDetailsPanel
extends JPanel
implements DCTreeEventListener {
    private static final long serialVersionUID = 4539749818725611810L;
    private TaskTablePanel m_oTaskTablePanel = DCFrameWorkUtil.getTaskTablePanel();
    private DCSortableTreeTable m_oTaskTreeTable = this.m_oTaskTablePanel.getTaskTreeTable();
    private TaskSubOperationMainPanel m_oOperationMainPanel = null;
    private TaskDeviceOperationLogPanel m_oOperationLogPanel = null;
    private TaskDeviceOperationListPanel m_oOperationListPanel = null;
    private JSplitPane m_oHorizontalSplitPane = null;
    private JSplitPane m_oVerticalSplitPane = null;
    private ITask m_oTaskObj = null;
    private TaskOprDetailsController m_oOprDetailsController = null;
    private boolean m_bFirstTime = false;

    public TaskDeviceOperationDetailsPanel() {
        this.initPanels();
    }

    private void initPanels() {
        this.m_oOperationListPanel = new TaskDeviceOperationListPanel();
        this.m_oOperationMainPanel = new TaskSubOperationMainPanel(this.m_oTaskTreeTable);
        this.m_oOperationLogPanel = new TaskDeviceOperationLogPanel();
        this.m_oOprDetailsController = new TaskOprDetailsController();
        LogInfoNotifier.getInstance().addListenerToSendRequest(this.m_oOprDetailsController);
        this.m_oOperationListPanel.setOperationDetailsPanelInstance(this.m_oOperationMainPanel);
        this.m_oOprDetailsController.setLogPanelInstance(this.m_oOperationLogPanel);
        this.m_oOprDetailsController.setOprListPanelInstance(this.m_oOperationListPanel);
        this.addHorizontalSplitPane();
        this.addVerticalSplitPane();
        this.addPanelsToSplitPanes();
        DCFrameWorkUtil.setTaskDeviceOperationLogPanel(this.m_oOperationLogPanel);
    }

    private void addHorizontalSplitPane() {
        this.m_oHorizontalSplitPane = new JSplitPane(1);
        this.m_oHorizontalSplitPane.setName("TaskMgmt_TaskDeviceOperationDetailsPanel_m_oHorizontalSplitPane");
        this.m_oHorizontalSplitPane.setMinimumSize(new Dimension(295, 200));
        this.m_oHorizontalSplitPane.setPreferredSize(new Dimension(295, 534));
        this.m_oHorizontalSplitPane.setAutoscrolls(false);
        this.m_oHorizontalSplitPane.setContinuousLayout(true);
        this.m_oHorizontalSplitPane.setOneTouchExpandable(false);
        this.m_oHorizontalSplitPane.setDividerLocation(145);
        this.m_oHorizontalSplitPane.setDividerSize(5);
        this.setLayout(new GridLayout());
    }

    private void addVerticalSplitPane() {
        this.m_oVerticalSplitPane = new JSplitPane(0);
        this.m_oVerticalSplitPane.setName("TaskMgmt_TaskDeviceOperationDetailsPanel_m_oVerticalSplitPane");
        this.m_oVerticalSplitPane.setMinimumSize(new Dimension(295, 77));
        this.m_oVerticalSplitPane.setPreferredSize(new Dimension(295, 534));
        this.m_oVerticalSplitPane.setAutoscrolls(false);
        this.m_oVerticalSplitPane.setToolTipText("");
        this.m_oVerticalSplitPane.setContinuousLayout(true);
        this.m_oVerticalSplitPane.setOneTouchExpandable(true);
        if (DCFrameWorkUtil.getIsSingleClient()) {
            this.m_oVerticalSplitPane.setDividerLocation(310);
        } else {
            this.m_oVerticalSplitPane.setDividerLocation(300);
        }
        this.m_oVerticalSplitPane.setDividerSize(7);
        this.setLayout(new GridLayout());
    }

    private void addPanelsToSplitPanes() {
        JScrollPane oScrollPane = new JScrollPane(this.m_oOperationListPanel);
        oScrollPane.setMinimumSize(new Dimension(140, 77));
        this.m_oHorizontalSplitPane.add((Component)oScrollPane, "left");
        this.m_oHorizontalSplitPane.add((Component)this.m_oOperationMainPanel, "right");
        this.m_oOperationLogPanel.setMinimumSize(new Dimension(295, 25));
        this.m_oOperationLogPanel.setPreferredSize(new Dimension(295, 25));
        this.m_oVerticalSplitPane.add((Component)this.m_oHorizontalSplitPane, "top");
        this.m_oVerticalSplitPane.add((Component)this.m_oOperationLogPanel, "bottom");
        this.add((Component)this.m_oVerticalSplitPane, null);
    }

    @Override
    public void onTreeInit(DCEventObject oEventObject) {
    }

    @Override
    public void onTreeNodeSelection(DCEventObject oEventObject) {
        TreePath oTreePath;
        int[] iRows = this.m_oTaskTreeTable.getSelectedRows();
        if (null == iRows) {
            this.clearAllPanels();
            return;
        }
        if (0 == iRows.length || 1 < iRows.length) {
            this.clearAllPanels();
            return;
        }
        if (1 == iRows.length && null == (oTreePath = this.m_oTaskTreeTable.getTree().getPathForRow(iRows[0]))) {
            this.clearAllPanels();
            return;
        }
        if (oEventObject instanceof TaskEvent && TaskEventID.DEVICE_SUB_OPR_NOTIFICATION != ((TaskEvent)oEventObject).getTaskEventType()) {
            this.onResourceProgressNtfn(oEventObject);
            return;
        }
        this.m_oTaskObj = this.m_oOprDetailsController.getTaskObject();
        if (null != this.m_oTaskObj) {
            if (TaskTableUtil.isAResourceOnlySelection(this.m_oTaskTreeTable)) {
                this.m_oOperationListPanel.setNodeSelected(true);
                if (oEventObject instanceof DeviceTreeTableDataSelectionEventObject) {
                    if (3 == ((DeviceTreeTableDataSelectionEventObject)oEventObject).getEventType()) {
                        int iTaskId = this.m_oOprDetailsController.getTaskID();
                        int iDevId = this.m_oOprDetailsController.getDeviceID();
                        Resource oRes = null;
                        Object oSource = oEventObject.getSource();
                        if (oSource instanceof HashMap) {
                            HashMap oUpdateResInfoMap = (HashMap)oSource;
                            if (oUpdateResInfoMap.containsKey(iTaskId)) {
                                List oResLst = (List)oUpdateResInfoMap.get(iTaskId);
                                for (Resource oTmpRes : oResLst) {
                                    if (iDevId != oTmpRes.getDeviceID()) continue;
                                    oRes = oTmpRes;
                                }
                            }
                        } else if (oSource instanceof Resource) {
                            if (iTaskId == ((DeviceTreeTableDataSelectionEventObject)oEventObject).getTaskID() && iDevId == ((Resource)oSource).getDeviceID()) {
                                oRes = (Resource)oSource;
                            }
                        } else {
                            return;
                        }
                        if (null != oRes) {
                            ResourceProgressInfo oProgressInfo = oRes.getProgressInfo();
                            if (-1 == oProgressInfo.getProgress() || 0 == oProgressInfo.getProgress() || 100 == oProgressInfo.getProgress() || 1 == oProgressInfo.getResult()) {
                                DCDebugTracer.traceDetail("DC::TaskDeviceOperationDetailsPanel::onTreeNodeSelection::m_iTaskID = " + iTaskId + ";deviceID = " + iDevId);
                                this.m_oOprDetailsController.sendReqForDevOprDetails(true);
                            }
                        } else {
                            return;
                        }
                    }
                    this.m_oOperationListPanel.setDeviceID(this.m_oOprDetailsController.getDeviceID());
                    int iSelRowCount = this.m_oTaskTreeTable.getSelectedRowCount();
                    if (iSelRowCount > 0) {
                        this.m_oOperationListPanel.onTreeNodeSelection(this.m_oTaskObj, null);
                    }
                }
            } else if (TaskTableUtil.isATaskOnlySelection(this.m_oTaskTreeTable)) {
                this.m_oOperationListPanel.setNodeSelected(false);
                DeviceTreeTableDataSelectionEventObject oEvtObject = (DeviceTreeTableDataSelectionEventObject)oEventObject;
                if (oEvtObject.getIsOpTabRefresh() && (!this.m_bFirstTime || TaskEventID.TASK_TREE_SELECTION_NOTIFICATION.ordinal() == oEvtObject.getEventType())) {
                    this.m_oOprDetailsController.sendReqForTaskDevsOprDetails();
                    this.m_bFirstTime = true;
                }
                this.m_oOprDetailsController.setDeviceID(-1);
                this.m_oOperationListPanel.setDeviceID(-1);
                this.m_oOperationLogPanel.addLogInformation(null);
                Resource tmpRes = null;
                if (oEventObject.getSource() instanceof Resource) {
                    tmpRes = (Resource)oEventObject.getSource();
                }
                this.m_oOperationListPanel.onTreeNodeSelection(this.m_oTaskObj, null, tmpRes);
            } else if (TaskTableUtil.isABoardResourceOnlySelection(this.m_oTaskTreeTable)) {
                this.m_oOperationListPanel.setDeviceID(this.m_oOprDetailsController.getDeviceID());
                this.m_oOperationLogPanel.addLogInformation(this.m_oOprDetailsController.getSelectedRes());
                this.m_oOperationListPanel.onTreeNodeSelection(this.m_oTaskObj, null);
            } else {
                this.m_oOperationListPanel.removeAllComponents();
                this.m_oOperationLogPanel.clearLogInforamtion();
                this.m_oOperationMainPanel.removeAllComponents();
            }
        }
    }

    private void onResourceProgressNtfn(DCEventObject oEventObject) {
        this.m_oOperationListPanel.onTreeNodeSelection(this.m_oTaskObj, oEventObject);
    }

    public void disposePanel() {
        this.m_oOperationMainPanel.doCleanUp();
        this.m_oOperationMainPanel = null;
        this.m_oOperationListPanel.doCleanUp();
        this.m_oOperationListPanel = null;
        this.m_oOperationLogPanel.doCleanUp();
        this.m_oOperationLogPanel = null;
        this.m_oTaskTreeTable = null;
        this.m_oTaskObj = null;
        this.m_oHorizontalSplitPane = null;
        this.m_oVerticalSplitPane = null;
        this.m_oOprDetailsController.doCleanUp();
        this.m_oOprDetailsController = null;
    }

    private void clearAllPanels() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != TaskDeviceOperationDetailsPanel.this.m_oOperationListPanel) {
                    TaskDeviceOperationDetailsPanel.this.m_oOperationListPanel.removeAllComponents();
                    TaskDeviceOperationDetailsPanel.this.m_oOperationListPanel.repaint();
                }
                if (null != TaskDeviceOperationDetailsPanel.this.m_oOperationLogPanel) {
                    TaskDeviceOperationDetailsPanel.this.m_oOperationLogPanel.clearLogInforamtion();
                    TaskDeviceOperationDetailsPanel.this.m_oOperationLogPanel.repaint();
                }
                if (null != TaskDeviceOperationDetailsPanel.this.m_oOperationMainPanel) {
                    TaskDeviceOperationDetailsPanel.this.m_oOperationMainPanel.removeScrollPane();
                    TaskDeviceOperationDetailsPanel.this.m_oOperationMainPanel.repaint();
                }
            }
        });
    }
}

