/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.sam.view.SAMFileInfoImportDlg;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.TaskMgmtOperationSelecPanel;
import gnu.trove.THashSet;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class TargetVersionButton
extends JButton {
    private static final long serialVersionUID = -4327642209127087016L;
    private ITask m_oTask;
    private List<DeviceTypeInfo> m_oDevTypeLst = null;

    public void cleanUp() {
        this.m_oTask = null;
        if (null != this.m_oDevTypeLst) {
            this.m_oDevTypeLst.clear();
            this.m_oDevTypeLst = null;
        }
    }

    public TargetVersionButton(List<DeviceTypeInfo> oDevTypeLst) {
        this.m_oDevTypeLst = oDevTypeLst;
        this.setText("...");
        this.setPreferredSize(new Dimension(20, 20));
        this.setMinimumSize(new Dimension(20, 20));
        this.addActionListener();
    }

    public TargetVersionButton(ITask oTask) {
        this.m_oTask = oTask;
        this.setText("...");
        this.setPreferredSize(new Dimension(20, 20));
        this.setMinimumSize(new Dimension(20, 20));
        this.addActionListener();
    }

    public void addActionListener() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent oEvent) {
                if (TaskCommUtil.checkOtherSAMFileInfoTablePanelHasShow()) {
                    return;
                }
                TargetVersionButton.this.handleTargetVersionButtonActionPerformed();
            }
        });
    }

    private void handleTargetVersionButtonActionPerformed() {
        final SAMFileInfoImportDlg oSAMFileInfoImportDlg = this.getSAMFileInfoImportDlg();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                oSAMFileInfoImportDlg.setVisible(true);
                TaskCommUtil.setSamFileImportShow(0);
                oSAMFileInfoImportDlg.updateTaskTargetVersion();
            }
        });
    }

    private SAMFileInfoImportDlg getSAMFileInfoImportDlg() {
        Container basePanel = this.getParent().getParent();
        SAMFileInfoImportDlg oSAMFileInfoImportDlg = null;
        if (basePanel instanceof TaskMgmtOperationSelecPanel) {
            int iContentTypeCode = -1;
            if (this.m_oTask.getTaskTypeId() == 3) {
                iContentTypeCode = 2;
            }
            DCModalDialog parentDlg = ((TaskMgmtOperationSelecPanel)basePanel).getParentDlg();
            DeviceType deviceType = this.m_oTask.getDeviceType();
            if (deviceType.getDeviceDomain() == 1) {
                iContentTypeCode = 25;
            }
            boolean isSupport = deviceType.isUpgradeModeSupportedByAllDevices(4096);
            oSAMFileInfoImportDlg = new SAMFileInfoImportDlg(parentDlg, iContentTypeCode, isSupport){
                private static final long serialVersionUID = -173719095707739126L;

                @Override
                public void setApplyButtonEnable(boolean bFlag) {
                    this.m_oApplyBtn.setEnabled(bFlag);
                }
            };
        } else {
            oSAMFileInfoImportDlg = new SAMFileInfoImportDlg(){
                private static final long serialVersionUID = -173719095707739126L;

                @Override
                public void setApplyButtonEnable(boolean bFlag) {
                    this.m_oApplyBtn.setEnabled(bFlag);
                }
            };
        }
        String strTitle = DCFrameWorkUtil.getLocalizedString("IMPORT_FILE_TITLE");
        oSAMFileInfoImportDlg.setTitle(strTitle);
        this.removeListeners(oSAMFileInfoImportDlg);
        List<DeviceTypeInfo> oDevTypeInfoList = this.getSelectedDeviceTypes();
        this.updateSAMTreePanel(oSAMFileInfoImportDlg, oDevTypeInfoList);
        return oSAMFileInfoImportDlg;
    }

    private void updateSAMTreePanel(SAMFileInfoImportDlg oSAMFileInfoImportDlg, List<DeviceTypeInfo> oDevTypeInfoList) {
        oSAMFileInfoImportDlg.getSAMFileImportPanel().setDeviceTypeList(oDevTypeInfoList);
        for (int i = 0; i < oDevTypeInfoList.size(); ++i) {
            DeviceTypeInfo oDevTypeInfo = oDevTypeInfoList.get(i);
            oSAMFileInfoImportDlg.getSAMFileTreePanel().setNodeState(oDevTypeInfo, true);
        }
        int iOperationID = 26;
        if (2 == this.m_oTask.getTaskTypeId()) {
            iOperationID = 9;
        }
        oSAMFileInfoImportDlg.getSAMFileImportPanel().setOperationIDForContentType(iOperationID);
        oSAMFileInfoImportDlg.getSAMFileImportPanel().updateContentTypeComboBox();
        oSAMFileInfoImportDlg.getApplyButton().setEnabled(false);
    }

    private List<DeviceTypeInfo> getSelectedDeviceTypes() {
        if (null != this.m_oDevTypeLst) {
            return this.m_oDevTypeLst;
        }
        ArrayList<DeviceTypeInfo> oDevTypeInfoList = new ArrayList<DeviceTypeInfo>(0);
        DeviceTypeInfo oDevTypeInfo = null;
        THashSet<Resource> oResList = this.m_oTask.getDeviceType().getResources();
        Iterator oResItor = oResList.iterator();
        Resource oRes = null;
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            oDevTypeInfo = DeviceInfoManagerImpl.getInstance().getDevice(oRes.getDeviceID()).getDeviceTypeInfo();
            if (oDevTypeInfoList.contains(oDevTypeInfo)) continue;
            oDevTypeInfoList.add(oDevTypeInfo);
        }
        return oDevTypeInfoList;
    }

    private void removeListeners(SAMFileInfoImportDlg oSAMFileInfoImportDlg) {
        oSAMFileInfoImportDlg.getSAMFileTreePanel().getTree().removeMouseListener(oSAMFileInfoImportDlg.getSAMFileTreePanel().getMouseListener());
        KeyListener[] oLis = oSAMFileInfoImportDlg.getSAMFileTreePanel().getTree().getKeyListeners();
        for (int i = 0; i < oLis.length; ++i) {
            oSAMFileInfoImportDlg.getSAMFileTreePanel().getTree().removeKeyListener(oLis[i]);
        }
    }
}

