/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDevTypeIdInfo;
import com.huawei.dc.common.asndatacenter.AsnDevTypeIdInfoList;
import com.huawei.dc.common.asndatacenter.AsnSAMFileUpdateInfo;
import com.huawei.dc.common.asndatacenter.AsnSAMFileUpdateInfoLst;
import com.huawei.dc.common.asndatacenter.AsnSAMGetVersionRsp;
import com.huawei.dc.common.asndatacenter.AsnSAMVersion;
import com.huawei.dc.common.asndatacenter.AsnSAMVersionLst;
import com.huawei.dc.common.components.DCDateChooser;
import com.huawei.dc.common.components.deviceselection.dropdown.DeviceDropDownChangeEvent;
import com.huawei.dc.common.components.deviceselection.dropdown.DeviceDropDownChangeListener;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCCleanupUtil;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCInmDateChooserFormat;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.sam.SAMUtil;
import com.huawei.dc.sam.controller.ISAMManager;
import com.huawei.dc.sam.controller.SAMManager;
import com.huawei.dc.sam.event.ISAMChangeEventListener;
import com.huawei.dc.sam.event.SAMChangeEventReceiver;
import com.huawei.dc.sam.model.SAMFileInfo;
import com.huawei.dc.taskmgmt.controller.IThirdPartyFTPNotificationListener;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.controller.ThirdPartyFTPNotifier;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.huawei.dc.taskmgmt.view.common.TargetVersionButton;
import com.swimap.imap12.util.dateChooser.InmDateDocument;
import com.swimap.iview.util.format.TimeFormatService;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SelectTimeAndVersionPanel
extends JPanel
implements DeviceDropDownChangeListener,
ISAMChangeEventListener,
IThirdPartyFTPNotificationListener {
    private static final long serialVersionUID = 1L;
    public JCheckBox m_oAutoCheckBox;
    public JLabel m_oTimeLabel;
    public JLabel m_oActivateLevelLabel;
    public JTextField m_oActivateLevelTxtField = null;
    public DCDateChooser m_oStartTimeTxt = null;
    private String m_strDefaultTImeString = "    -  -     :  :  ";
    public JLabel m_oVersionLabel;
    public ComboBoxWithToolTip m_oVersionDropDown;
    public JButton m_oTargetVersionButton;
    private List m_oTargetVersionList;
    private DefaultComboBoxModel m_oModel;
    private ResourceManager oResMgr = ResourceManager.getInstance();
    private ITask m_oTask;
    private boolean m_bisVersionChanged;
    private DeviceTypeInfo m_oDevTypeInfo;
    private static int Oper_Type = -1;
    private static int COPY_TASK = 1;
    private long firstOpenClientTime = -1L;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstOpenClientTime ^ this.firstOpenClientTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelectTimeAndVersionPanel other = (SelectTimeAndVersionPanel)obj;
        return this.firstOpenClientTime == other.firstOpenClientTime;
    }

    public SelectTimeAndVersionPanel(ITask oTask, int OperationType) {
        DCDebugTracer.trace("SelectTimeAndVersionPanel create SelectTimeAndVersionPanel start ");
        this.firstOpenClientTime = System.nanoTime();
        Oper_Type = OperationType;
        this.setLayout(null);
        this.m_oTask = oTask;
        this.m_oDevTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(this.m_oTask.getDeviceType().getDeviceTypeID(), this.m_oTask.getDeviceType().getDeviceTypeVersionID());
        this.createComponents();
        this.addComponents();
        this.registerListeners();
        SAMChangeEventReceiver.getInstance().resigterForConfigChangeEvent(this);
        this.handleThirdPartyFTPChangeNotification(this.m_oTask.isThirdPartySupported());
        ThirdPartyFTPNotifier.getInstance().addNotificationListener(this);
        DCDebugTracer.trace("SelectTimeAndVersionPanel create SelectTimeAndVersionPanel end.. ");
    }

    protected void registerListeners() {
        this.m_oAutoCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectTimeAndVersionPanel.this.m_oStartTimeTxt.setEnabled(SelectTimeAndVersionPanel.this.m_oAutoCheckBox.isSelected());
                if (!SelectTimeAndVersionPanel.this.m_oAutoCheckBox.isSelected()) {
                    SelectTimeAndVersionPanel.this.m_oTask.setStartTime(null);
                    SelectTimeAndVersionPanel.this.m_oStartTimeTxt.setCalendar(null);
                    SelectTimeAndVersionPanel.this.m_oStartTimeTxt.updateUI();
                } else {
                    Calendar oCurrentTime = TaskSyncCommController.getInstance().getCurrentServerTime(true);
                    SelectTimeAndVersionPanel.this.m_oStartTimeTxt.setCalendar(oCurrentTime);
                    SelectTimeAndVersionPanel.this.m_oTask.setStartTime(oCurrentTime);
                    SelectTimeAndVersionPanel.this.m_oStartTimeTxt.updateUI();
                }
            }
        });
    }

    private void createComponents() {
        this.initComponents();
        this.alignComponents();
    }

    public List getTargetVersionInfoLst(int iDevTypeId, int iDevTypeVersionId) throws DCException {
        int allDevTypeId = -1;
        int allDevTypeVersionId = -1;
        this.m_oTargetVersionList = new ArrayList(0);
        if (iDevTypeId == allDevTypeId && iDevTypeVersionId == allDevTypeVersionId) {
            List<DeviceTypeInfo> oDevTypeInfoLst = this.m_oTask.getDeviceTypeLst();
            for (DeviceTypeInfo deviceType : oDevTypeInfoLst) {
                if (null == deviceType || deviceType.getDevTypeID() == allDevTypeId || deviceType.getDevTypeVersionId() == allDevTypeVersionId) continue;
                this.getTargetVerFrmSAM(deviceType.getDevTypeID(), deviceType.getDevTypeVersionId());
            }
            this.filtrateSameTargetVersion(this.m_oTargetVersionList);
        } else {
            this.getTargetVerFrmSAM(iDevTypeId, iDevTypeVersionId);
        }
        return this.m_oTargetVersionList;
    }

    private void filtrateSameTargetVersion(List m_oTargetVersionList) {
        String strDevVersion = "";
        String m_strDevVersion = "";
        int count = m_oTargetVersionList.size();
        if (count > 1) {
            Vector<String> targetVersionList = new Vector<String>();
            m_strDevVersion = (String)m_oTargetVersionList.get(0);
            targetVersionList.add(m_strDevVersion);
            for (int i = 1; i < count; ++i) {
                strDevVersion = (String)m_oTargetVersionList.get(i);
                if (strDevVersion.startsWith(m_strDevVersion)) continue;
                targetVersionList.add(strDevVersion);
                m_strDevVersion = strDevVersion;
            }
            m_oTargetVersionList = targetVersionList;
        }
    }

    private void getTargetVerFrmSAM(int iDevTypeId, int iDevTypeVersionId) throws DCException {
        if (this.m_oTask.getDeviceTypeLst().size() > 1) {
            return;
        }
        ISAMManager oSAManager = SAMManager.getInstance();
        int iErrorCode = -1;
        SAMFileInfo oSAMFileInfo = new SAMFileInfo();
        IDeviceInfoManager oDeviceInfoMgr = DCFrameWorkUtil.getDeviceInfoManager();
        DeviceTypeInfo oDeviceTypeInfo = oDeviceInfoMgr.getDeviceTypeInfo(iDevTypeId, iDevTypeVersionId);
        oSAMFileInfo.setDeviceTypeInfo(oDeviceTypeInfo);
        AsnSAMGetVersionRsp oAsnSAMGetVersionRsp = oSAManager.getAsnSAMGetVersionReq(oSAMFileInfo, this.m_oTask.getTaskTypeId());
        iErrorCode = oAsnSAMGetVersionRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            return;
        }
        AsnSAMVersionLst oSAMVersionLst = oAsnSAMGetVersionRsp.oAsnSAMVersionLst;
        String strDevVersion = "";
        String strPatchVersion = "";
        String strTargetVer = "";
        AsnSAMVersion oSAMVersion = null;
        for (int index = 0; index < oSAMVersionLst.size(); ++index) {
            oSAMVersion = (AsnSAMVersion)oSAMVersionLst.get(index);
            strDevVersion = new String(oSAMVersion.stringSWVersion);
            strPatchVersion = new String(oSAMVersion.stringPatchVersion);
            if (oDeviceTypeInfo.isT2000Domain()) {
                strTargetVer = strDevVersion;
                if (2 == this.m_oTask.getTaskTypeId() && !strPatchVersion.isEmpty()) {
                    strTargetVer = strTargetVer + "_" + strPatchVersion;
                }
                strTargetVer = strTargetVer + "(" + oDeviceTypeInfo.getDevTypeName() + ")";
            } else if (oDeviceTypeInfo.isDMSDomain()) {
                strTargetVer = strDevVersion;
                if (2 == this.m_oTask.getTaskTypeId() && !strPatchVersion.isEmpty()) {
                    strTargetVer = strTargetVer + "_" + strPatchVersion;
                }
            } else {
                strTargetVer = strDevVersion;
            }
            if (this.m_oTargetVersionList.contains(strTargetVer)) continue;
            this.m_oTargetVersionList.add(strTargetVer);
        }
    }

    private void alignComponents() {
        this.m_oAutoCheckBox.setBounds(0, 0, 18, 21);
        this.m_oTimeLabel.setBounds(26, 0, 80, 20);
        this.m_oVersionLabel.setBounds(330, 0, 155, 20);
        this.m_oVersionDropDown.setBounds(428, 0, 142, 20);
        this.m_oTargetVersionButton.setBounds(570, 0, 20, 20);
        this.m_oStartTimeTxt.setBounds(98, 0, 230, 22);
    }

    public ComboBoxWithToolTip getTargetVersionComboBox() {
        return this.m_oVersionDropDown;
    }

    public ValidationResult validateInput() {
        ValidationResult oValidationResult = null;
        oValidationResult = this.validateTaskTime();
        return oValidationResult;
    }

    private ValidationResult validateTaskTime() {
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        if (this.m_oAutoCheckBox.isSelected()) {
            if (this.m_oStartTimeTxt.getTextField().getText().equals(this.m_strDefaultTImeString)) {
                oValidationResult.setErrorCode(-1);
                oValidationResult.setErrorMessage(this.oResMgr.getResString("START_TIME_NULL_MSG"));
            } else {
                oValidationResult = this.validateWithCurrentTime();
            }
        } else {
            this.m_oTask.setStartTime(null);
            String strTargetVersion = (String)this.m_oVersionDropDown.getSelectedItem();
            this.m_oTask.setTargetVersion(strTargetVersion);
        }
        return oValidationResult;
    }

    private ValidationResult validateWithCurrentTime() {
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        Calendar oCurrentTime = TaskSyncCommController.getInstance().getCurrentServerTime(true);
        Calendar oStartimeCal = Calendar.getInstance();
        oStartimeCal = this.m_oStartTimeTxt.getCalendar(true);
        if (oStartimeCal.equals(oCurrentTime) || oStartimeCal.before(oCurrentTime)) {
            String sCurrentTime = TimeFormatService.getString((Calendar)oCurrentTime);
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(this.oResMgr.getResString("START_TIME_GREATER_CURRENT_TIME", new String[]{sCurrentTime}));
            oValidationResult.setWarningMessage(true);
        } else {
            this.m_oTask.setStartTime(oStartimeCal);
            String strTargetVersion = (String)this.m_oVersionDropDown.getSelectedItem();
            this.m_oTask.setTargetVersion(strTargetVersion);
        }
        return oValidationResult;
    }

    private void initComponents() {
        this.m_oAutoCheckBox = new JCheckBox(this.oResMgr.getResString("START_TIME_CHECKBOX_TITLE"));
        this.m_oAutoCheckBox.setName("TaskMgmt_SelectTimeAndVersionPanel_m_oAutoCheckBox");
        this.m_oTimeLabel = new JLabel(this.oResMgr.getResString("START_TIME_LABEL"));
        this.initStartTimeText();
        this.m_strDefaultTImeString = this.m_oStartTimeTxt.getTextField().getText();
        this.setTimeComponents();
        this.m_oVersionLabel = new JLabel(this.oResMgr.getResString("TARGET_VERSION_LABEL"));
        this.m_oModel = new DefaultComboBoxModel();
        this.m_oVersionDropDown = new ComboBoxWithToolTip((ComboBoxModel)this.m_oModel);
        this.m_oVersionDropDown.setName("TaskMgmt_SelectTimeAndVersionPanel_m_oVersionDropDown");
        this.getTargetVersionButton();
        this.setActivateLevelToPanel();
    }

    private void setActivateLevelToPanel() {
        this.m_oActivateLevelLabel = new JLabel();
        this.m_oActivateLevelLabel.setText(this.oResMgr.getResString("PACKAGE_DIFFUSION_ACTIVATION_LEVEL_LABEL"));
        this.m_oActivateLevelTxtField = new JTextField();
        this.m_oActivateLevelTxtField.setName("TaskMgmt_SelectTimeAndVersionPanel_m_oActivateLevelTxtField");
        this.m_oActivateLevelTxtField.setEditable(false);
        if (this.m_oTask.getUpgradeLevel() == 1) {
            this.m_oActivateLevelTxtField.setText(this.oResMgr.getResString("PACKAGE_DIFFUSION_ACTIVATION_LEVEL_DEVICE"));
        } else {
            this.m_oActivateLevelTxtField.setText(this.oResMgr.getResString("PACKAGE_DIFFUSION_ACTIVATION_LEVEL_BOARD"));
        }
    }

    private void setTimeComponents() {
        if (null == this.m_oTask.getStartTime()) {
            this.m_oAutoCheckBox.setSelected(false);
            this.m_oStartTimeTxt.setEnabled(false);
        } else if (Oper_Type == COPY_TASK) {
            this.m_oAutoCheckBox.setSelected(false);
            this.m_oStartTimeTxt.setEnabled(false);
        } else {
            this.m_oAutoCheckBox.setSelected(true);
            this.m_oStartTimeTxt.setEnabled(true);
            this.m_oStartTimeTxt.setCalendar(this.m_oTask.getStartTime());
        }
    }

    private void initStartTimeText() {
        DCInmDateChooserFormat oDateFormat = new DCInmDateChooserFormat();
        InmDateDocument.defaultType = oDateFormat.getDateFormat();
        this.m_oStartTimeTxt = new DCDateChooser();
        this.m_oStartTimeTxt.setName("TaskMgmt_SelectTimeAndVersionPanel_m_oStartTimeTxt");
        this.m_oStartTimeTxt.setEnabled(this.m_oAutoCheckBox.isSelected());
        this.m_oStartTimeTxt.setCalendar(null);
    }

    private void addComponents() {
        this.add(this.m_oAutoCheckBox);
        this.add(this.m_oTimeLabel);
        this.add((Component)((Object)this.m_oStartTimeTxt));
        this.add(this.m_oVersionLabel);
        this.add(this.m_oVersionDropDown);
        this.add(this.m_oTargetVersionButton);
        if (this.m_oTask.getTaskTypeId() == 5 || this.m_oTask.getTaskTypeId() == 12) {
            this.add(this.m_oActivateLevelLabel);
            this.add(this.m_oActivateLevelTxtField);
        }
    }

    public void setStartTime(Calendar oStartTime) {
        if (null != this.m_oStartTimeTxt.getCalendar(true)) {
            this.m_oStartTimeTxt.setCalendar(oStartTime);
        }
    }

    public void populateVersionModel(int iDeviceTypeId, int iDeviceTypeVersionId) throws DCException {
        if (null == this.m_oModel) {
            return;
        }
        this.m_oModel.removeAllElements();
        this.m_oModel.addElement("");
        List oVersionList = this.getTargetVersionInfoLst(iDeviceTypeId, iDeviceTypeVersionId);
        if (null == oVersionList) {
            return;
        }
        for (int index = 0; index < oVersionList.size(); ++index) {
            Object oItem = oVersionList.get(index);
            if (!(oItem instanceof String)) continue;
            this.m_oModel.addElement(oItem);
        }
    }

    public void setVersion(String strVersion) {
        if (-1 != this.m_oModel.getIndexOf(strVersion = strVersion + "(" + this.m_oDevTypeInfo.getDevTypeName() + ")")) {
            this.m_oModel.setSelectedItem(strVersion);
        } else {
            this.m_oModel.setSelectedItem("");
        }
    }

    public boolean isDeviceVersionChanged() {
        DCDebugTracer.trace("method isDeviceVersionChanged m_bisVersionChanged : " + this.m_bisVersionChanged);
        return this.m_bisVersionChanged;
    }

    private void populateTargetVersion(String strDeviceVersion) throws DCException {
        if (null == this.m_oModel) {
            return;
        }
        this.m_oTargetVersionList = this.getTargetVersionInfoLst(this.m_oDevTypeInfo.getDevTypeID(), this.m_oDevTypeInfo.getDevTypeVersionId());
        if (null == this.m_oTargetVersionList) {
            return;
        }
        String strSelectedTargetVersion = this.m_oTask.getTargetVersion();
        this.m_bisVersionChanged = true;
        this.m_oModel.removeAllElements();
        this.m_oModel.addElement("");
        int iItemCount = this.m_oTargetVersionList.size();
        for (int index = 0; index < iItemCount; ++index) {
            String strVersion = this.m_oTargetVersionList.get(index).toString();
            if (strVersion == null || strVersion.equals("")) continue;
            this.m_oModel.addElement(strVersion);
        }
        if (null != strSelectedTargetVersion) {
            this.setVersion(strSelectedTargetVersion);
        }
        this.m_bisVersionChanged = false;
    }

    public void dispose() {
        DCDebugTracer.trace("SelectTimeAndVersionPanel method dispose start ");
        SAMChangeEventReceiver.getInstance().unResigterForConfigChangeEvent(this);
        if (null != this.m_oVersionDropDown) {
            this.m_oVersionDropDown.removeAllItems();
            this.m_oVersionDropDown = null;
        }
        if (null != this.m_oTargetVersionButton) {
            this.m_oTargetVersionButton = null;
        }
        if (this.m_oTargetVersionList != null) {
            this.m_oTargetVersionList.clear();
            this.m_oTargetVersionList = null;
        }
        if (this.m_oModel != null) {
            this.m_oModel = null;
        }
        if (this.oResMgr != null) {
            this.oResMgr = null;
        }
        if (this.m_oTask != null) {
            this.m_oTask = null;
        }
        if (null != ThirdPartyFTPNotifier.getInstance()) {
            ThirdPartyFTPNotifier.getInstance().removeNotificationListener(this);
        }
        DCCleanupUtil.cleanUpPanel(this);
        DCDebugTracer.trace("SelectTimeAndVersionPanel method dispose end..");
    }

    @Override
    public void onDropDownSelecton(DeviceDropDownChangeEvent oEvent) {
        if (null == oEvent) {
            return;
        }
        int iSelectionType = oEvent.getSelectionType();
        if (1 == iSelectionType) {
            this.m_oDevTypeInfo = (DeviceTypeInfo)oEvent.getSource();
            try {
                this.populateVersionModel(this.m_oDevTypeInfo.getDevTypeID(), this.m_oDevTypeInfo.getDevTypeVersionId());
                String sDevVersion = oEvent.getDeviceVersion();
                if (null != sDevVersion) {
                    this.populateTargetVersion(sDevVersion);
                }
            }
            catch (DCException e) {
                DCDebugTracer.trace(e);
            }
        } else if (2 == iSelectionType) {
            String strDeviceVersion = (String)oEvent.getSource();
            try {
                this.populateTargetVersion(strDeviceVersion);
            }
            catch (DCException e) {
                DCDebugTracer.trace(e);
            }
        }
    }

    @Override
    public void setCurrentEvent(DeviceDropDownChangeEvent oEvent) {
        if (oEvent.getSource() instanceof DeviceTypeInfo) {
            this.m_oDevTypeInfo = (DeviceTypeInfo)oEvent.getSource();
            String sDeviceVersion = oEvent.getDeviceVersion();
            if (null != sDeviceVersion) {
                try {
                    this.populateTargetVersion(sDeviceVersion);
                }
                catch (DCException e) {
                    DCDebugTracer.trace(e);
                }
            }
        } else if (oEvent.getSource() instanceof String) {
            String strDeviceVersion = (String)oEvent.getSource();
            try {
                this.populateTargetVersion(strDeviceVersion);
            }
            catch (DCException e) {
                DCDebugTracer.trace(e);
            }
        }
    }

    private JButton getTargetVersionButton() {
        if (this.m_oTargetVersionButton != null) {
            return this.m_oTargetVersionButton;
        }
        this.m_oTargetVersionButton = new TargetVersionButton(this.m_oTask);
        this.m_oTargetVersionButton.setName("TaskMgmt_TaskMgmtOperationSelecPanel_m_oTargetVersionButton");
        return this.m_oTargetVersionButton;
    }

    @Override
    public void handleDeleteSAMFileNotification(AsnSAMFileUpdateInfoLst asnSAMFileInfoLst) {
        this.handleSamChange(asnSAMFileInfoLst, 1);
    }

    @Override
    public void handleImportSAMFileNotification(AsnSAMFileUpdateInfoLst asnSAMFileInfoLst) {
        this.handleSamChange(asnSAMFileInfoLst, 0);
    }

    private void handleSamChange(AsnSAMFileUpdateInfoLst asnSAMFileInfoLst, int iEventType) {
        if (null == asnSAMFileInfoLst) {
            DCDebugTracer.trace("asnSAMFileInfoLst is null event type=" + iEventType);
            return;
        }
        Iterator iterator = asnSAMFileInfoLst.iterator();
        AsnSAMFileUpdateInfo oAsnSAMFileUpdateInfo = null;
        AsnDevTypeIdInfoList oAsnDevTypeList = null;
        Iterator itrDevType = null;
        AsnDevTypeIdInfo oAsnDevTypeIdInfo2 = null;
        DeviceTypeInfo oDevTypeInfo = null;
        String strVersionToSelect = "";
        block0: while (iterator.hasNext()) {
            oAsnSAMFileUpdateInfo = (AsnSAMFileUpdateInfo)iterator.next();
            String strVersion = DCCommonUtil.convertByteArrayToStr(oAsnSAMFileUpdateInfo.oFileInfo.strVersion);
            String strPatchVer = "";
            if (null != oAsnSAMFileUpdateInfo.oFileInfo.strPatchVersion) {
                strPatchVer = new String(oAsnSAMFileUpdateInfo.oFileInfo.strPatchVersion);
            }
            if (0 == strVersion.length()) continue;
            oAsnDevTypeList = oAsnSAMFileUpdateInfo.oDevTypeIdInfoList;
            for (AsnDevTypeIdInfo oAsnDevTypeIdInfo2 : oAsnDevTypeList) {
                oDevTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(oAsnDevTypeIdInfo2.iDevTypeId.intValue(), oAsnDevTypeIdInfo2.iDevTypeVerId.intValue());
                if (!this.m_oDevTypeInfo.equals(oDevTypeInfo)) continue;
                if (oDevTypeInfo.isBMSDomain()) {
                    strVersionToSelect = strVersion;
                } else {
                    strVersionToSelect = strVersion;
                    if (2 == this.m_oTask.getTaskTypeId()) {
                        int iFileType = oAsnSAMFileUpdateInfo.oFileInfo.iFileType.intValue();
                        ContentType oContentType = SAMUtil.getFileTypeObj(oDevTypeInfo, iFileType);
                        if (null != oContentType && !"PATCH".equals(oContentType.getId())) continue;
                        if (!strPatchVer.isEmpty()) {
                            strVersionToSelect = strVersionToSelect + "_" + strPatchVer;
                        }
                    }
                    if (oDevTypeInfo.isT2000Domain()) {
                        strVersionToSelect = strVersionToSelect + "(" + oDevTypeInfo.getDevTypeName() + ")";
                        this.addTargetVersionInModel(strVersionToSelect, iEventType);
                        continue;
                    }
                }
                this.addTargetVersionInModel(strVersionToSelect, iEventType);
                continue block0;
            }
        }
    }

    private void addTargetVersionInModel(String strVersionToSelect, int iEventType) {
        boolean bItemExist = false;
        int iSize = this.m_oModel.getSize();
        String strTargetVersion = null;
        int index = -1;
        for (int i = 0; i < iSize; ++i) {
            strTargetVersion = (String)this.m_oModel.getElementAt(i);
            if (!Collator.getInstance().equals(strTargetVersion, strVersionToSelect)) continue;
            index = i;
            bItemExist = true;
            break;
        }
        switch (iEventType) {
            case 0: {
                if (bItemExist) break;
                this.m_oModel.addElement(strVersionToSelect);
                break;
            }
            case 1: {
                if (index == -1) break;
                this.m_oModel.removeElementAt(index);
                break;
            }
            case 2: {
                if (index != -1) {
                    this.m_oModel.removeElementAt(index);
                }
                this.m_oModel.addElement(strVersionToSelect);
            }
        }
    }

    @Override
    public void handleUpdateSAMFileNotification(AsnSAMFileUpdateInfoLst asnSAMFileInfoLst) {
        this.handleSamChange(asnSAMFileInfoLst, 2);
    }

    @Override
    public void handleThirdPartyFTPChangeNotification(boolean bSelected) {
        if (bSelected) {
            if (null != this.m_oVersionDropDown) {
                if (1 <= this.m_oVersionDropDown.getItemCount()) {
                    this.m_bisVersionChanged = true;
                    this.m_oVersionDropDown.setSelectedIndex(0);
                    this.m_bisVersionChanged = false;
                }
                this.m_oVersionDropDown.setEnabled(false);
            }
            if (null != this.m_oTargetVersionButton) {
                this.m_oTargetVersionButton.setEnabled(false);
            }
        } else {
            if (null != this.m_oVersionDropDown) {
                this.m_oVersionDropDown.setEnabled(true);
            }
            if (null != this.m_oTargetVersionButton) {
                this.m_oTargetVersionButton.setEnabled(true);
            }
        }
    }
}

