/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.loadsimulationpackage.view.LoadSimPackageTabbedPane;
import com.huawei.dc.devicemanagement.deviceoperation.loadsimulationpackage.view.SimPackageBrowseDlg;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.SelectPackgesInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class SelectPackagesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable m_oTable = null;
    private DefaultTableModel m_oTableModel = null;
    private JScrollPane m_oScrollPane = null;
    private transient SimPackageBrowseDlg browaseDlg = null;
    private ITask m_oTask;
    private static final int DEVICE_PKGPATH_COL = 1;
    private int pathType = 0;
    private int operType = -1;
    private static final int DEVTYPE_COL = 0;
    private static final int PACKAGEPATH_COL = 1;
    private static final int MODY_TASK = 1;
    private boolean isEidtor = true;
    private List<SelectPackgesInfo> selectPackagesInfoList = null;
    private List<SelectPackgesInfo> modifyPackagesInfoList = null;
    private List<String> addDevTypeList = new ArrayList<String>();
    private List<String> delDevTypeList = new ArrayList<String>();
    private String tableTooltipText = "";
    private LoadSimPackageTabbedPane loadPackageTabbedPan;
    private String packagePathLast = "";

    public SelectPackagesPanel(ITask oTask, LoadSimPackageTabbedPane loadPackageTabbedPan, int pathType) {
        this.m_oTask = oTask;
        this.pathType = pathType;
        this.loadPackageTabbedPan = loadPackageTabbedPan;
        this.selectPackagesInfoList = loadPackageTabbedPan.getSelectPackagesInfoList();
        this.modifyPackagesInfoList = new ArrayList<SelectPackgesInfo>();
        this.jbInit();
        this.fillTabelData(pathType);
    }

    public SelectPackagesPanel(ITask oTask, int pathType, int operType) {
        this.operType = operType;
        this.m_oTask = oTask;
        this.pathType = pathType;
        this.jbInit();
        this.initPackagesInfoList();
        this.modifyPackagesInfoList = new ArrayList<SelectPackgesInfo>();
        this.fillTabelData(pathType);
    }

    private void jbInit() {
        this.createTable();
        this.setLayout(null);
        this.m_oScrollPane = new JScrollPane();
        if (1 == this.pathType) {
            this.m_oScrollPane.setBounds(12, 15, 834, 260);
        } else if (this.operType == 1 && this.pathType == 2) {
            this.m_oScrollPane.setBounds(0, 0, 865, 340);
        } else {
            this.m_oScrollPane.setBounds(12, 15, 668, 435);
        }
        this.m_oScrollPane.getViewport().add(this.m_oTable);
        this.add(this.m_oScrollPane);
    }

    public JScrollPane getPanel() {
        return this.m_oScrollPane;
    }

    private void fillTabelData(int pathType) {
        for (SelectPackgesInfo packagesInfo : this.selectPackagesInfoList) {
            Vector<String> rowData = new Vector<String>();
            rowData.add(packagesInfo.getDevTypeName());
            if (1 == pathType) {
                rowData.add(packagesInfo.getRollBackPath());
            } else {
                rowData.add(packagesInfo.getFilePath());
            }
            this.m_oTableModel.addRow(rowData);
        }
    }

    public void addRowDataByDevTyep(String devType) {
        Vector<String> rowData = new Vector<String>();
        rowData.add(devType);
        this.m_oTableModel.addRow(rowData);
        this.m_oTable.updateUI();
    }

    public void deleteRowDataByDevTyep(String devType) {
        int rowCount = this.m_oTableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String devTypeName = this.m_oTableModel.getValueAt(i, 0).toString();
            if (!devTypeName.equals(devType)) continue;
            final int index = i;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SelectPackagesPanel.this.m_oTableModel.removeRow(index);
                    SelectPackagesPanel.this.m_oTable.updateUI();
                    SelectPackagesPanel.this.m_oTable.repaint();
                }
            });
        }
    }

    private void createTable() {
        int initRowCount = 0;
        Object[] tableColName = new String[]{ResourceManager.getInstance().getResString("DEVICE_TYPE"), ResourceManager.getInstance().getResString("POLICYINFOPAN_TABLE_BACKUP_PATH")};
        this.m_oTableModel = new DefaultTableModel(tableColName, initRowCount);
        this.m_oTable = new JTable(this.m_oTableModel){

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                if (column == 1) {
                    return new pkgSelectButtonRenderer("...");
                }
                return super.getCellRenderer(row, column);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                if (column == 1) {
                    return SelectPackagesPanel.this.isEidtor;
                }
                return false;
            }

            @Override
            public TableCellEditor getCellEditor(int row, int column) {
                if (column == 1) {
                    return new pkgSelectButtonEditor("...");
                }
                return super.getCellEditor(row, column);
            }

            @Override
            public String getToolTipText(MouseEvent e) {
                return SelectPackagesPanel.this.tableTooltipText;
            }
        };
        this.m_oTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (null != SelectPackagesPanel.this.m_oTable.getCellEditor()) {
                    SelectPackagesPanel.this.m_oTable.getCellEditor().stopCellEditing();
                }
                SelectPackagesPanel.this.tableTooltipText = null;
                int colum = SelectPackagesPanel.this.m_oTable.columnAtPoint(e.getPoint());
                int row = SelectPackagesPanel.this.m_oTable.rowAtPoint(e.getPoint());
                if (row < 0) {
                    SelectPackagesPanel.this.tableTooltipText = "";
                    return;
                }
                if (colum == 0) {
                    SelectPackagesPanel.this.tableTooltipText = SelectPackagesPanel.this.m_oTable.getValueAt(row, colum).toString();
                } else if (colum == 1) {
                    String path = SelectPackagesPanel.this.m_oTable.getValueAt(row, colum).toString();
                    SelectPackagesPanel.this.tableTooltipText = path;
                }
            }
        });
        this.m_oTable.setName("selectPackagePanel_packageTable");
        this.m_oTable.setRowHeight(22);
        this.m_oTable.getTableHeader().setReorderingAllowed(false);
        this.m_oTable.getColumnModel().getColumn(0).setPreferredWidth(180);
        this.m_oTable.getColumnModel().getColumn(0).setMaxWidth(180);
        this.m_oTable.getColumnModel().getColumn(0).setMinWidth(180);
    }

    public JTable getTable() {
        return this.m_oTable;
    }

    public DefaultTableModel getTableModel() {
        return this.m_oTableModel;
    }

    public void setEditor(boolean isEditor) {
        this.isEidtor = isEditor;
    }

    public boolean getEditor() {
        return this.isEidtor;
    }

    private void initPackagesInfoList() {
        this.selectPackagesInfoList = new ArrayList<SelectPackgesInfo>();
        List devTypeList = this.m_oTask.getDeviceTypes();
        LoadFileInfoListParam m_oLoadParam = this.m_oTask.getLoadFileInfoListParam();
        if (null == m_oLoadParam || m_oLoadParam.getLoadFileInfoList().size() == 0) {
            for (String devTypeName : devTypeList) {
                SelectPackgesInfo packageInfo = new SelectPackgesInfo();
                packageInfo.setDevTypeName(devTypeName);
                this.selectPackagesInfoList.add(packageInfo);
            }
            return;
        }
        if (devTypeList.size() == 1) {
            SelectPackgesInfo packageInfo = new SelectPackgesInfo();
            packageInfo.setDevTypeName((String)devTypeList.get(0));
            LoadFileInfo fileInfo = m_oLoadParam.getLoadFileInfoList().get(0);
            packageInfo.setFilePath(fileInfo.getFileName());
            this.selectPackagesInfoList.add(packageInfo);
            return;
        }
        List<LoadFileInfo> fileInfoList = m_oLoadParam.getLoadFileInfoList();
        IDeviceInfoManager oDeviceInfoMgr = DCFrameWorkUtil.getDeviceInfoManager();
        block1: for (String devTypeName : devTypeList) {
            for (LoadFileInfo fileInfo : fileInfoList) {
                Resource res = oDeviceInfoMgr.getResourceForID(fileInfo.getDeviceId());
                if (!devTypeName.equals(res.getDeviceType())) continue;
                SelectPackgesInfo packageInfo = new SelectPackgesInfo();
                packageInfo.setDevTypeName(devTypeName);
                packageInfo.setFilePath(fileInfo.getAbsoluteFilePath());
                this.selectPackagesInfoList.add(packageInfo);
                continue block1;
            }
        }
    }

    public List<SelectPackgesInfo> fillSimPackageInfoList(int pathType) {
        this.modifyPackagesInfoList.clear();
        int rowCount = this.m_oTableModel.getRowCount();
        block0: for (int i = 0; i < rowCount; ++i) {
            String devType = this.m_oTableModel.getValueAt(i, 0).toString();
            String path = "";
            if (this.m_oTableModel.getValueAt(i, 1) != null) {
                path = this.m_oTableModel.getValueAt(i, 1).toString();
            }
            String fileName = this.getFileName(path);
            for (SelectPackgesInfo packageInfo : this.selectPackagesInfoList) {
                if (!devType.equals(packageInfo.getDevTypeName())) continue;
                if (!(pathType != 0 && pathType != 2 || path.equals(packageInfo.getFilePath()))) {
                    packageInfo.setFilePath(path);
                    packageInfo.setFileName(fileName);
                    this.modifyPackagesInfoList.add(packageInfo);
                    continue block0;
                }
                if (pathType != 1 || path.equals(packageInfo.getRollBackPath())) continue block0;
                packageInfo.setRollBackPath(path);
                this.modifyPackagesInfoList.add(packageInfo);
                continue block0;
            }
        }
        return this.modifyPackagesInfoList;
    }

    public List<SelectPackgesInfo> getPackInfoList() {
        return this.selectPackagesInfoList;
    }

    public List<String> getAddDevtypeList() {
        return this.addDevTypeList;
    }

    public List<String> getdelDevtypeList() {
        return this.delDevTypeList;
    }

    public boolean isAddDevtype(List<String> devTypeList) {
        boolean isAdd = false;
        for (String devTypeName : devTypeList) {
            boolean isExist = false;
            for (SelectPackgesInfo packageInfo : this.selectPackagesInfoList) {
                if (!packageInfo.getDevTypeName().equals(devTypeName)) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            SelectPackgesInfo packageInfo = new SelectPackgesInfo();
            packageInfo.setDevTypeName(devTypeName);
            this.selectPackagesInfoList.add(packageInfo);
            this.addDevTypeList.add(devTypeName);
            this.addRowDataByDevTyep(devTypeName);
            isAdd = true;
        }
        return isAdd;
    }

    public boolean isDelDevtype(List<String> devTypeList) {
        boolean isDel = false;
        for (SelectPackgesInfo packageInfo : this.selectPackagesInfoList) {
            boolean isExist = false;
            for (String devTypeName : devTypeList) {
                if (!packageInfo.getDevTypeName().equals(devTypeName)) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            this.selectPackagesInfoList.remove(packageInfo);
            this.delDevTypeList.add(packageInfo.getDevTypeName());
            this.deleteRowDataByDevTyep(packageInfo.getDevTypeName());
            isDel = true;
        }
        return isDel;
    }

    public String getFilePath(String devType) {
        for (SelectPackgesInfo packageInfo : this.selectPackagesInfoList) {
            if (!devType.equals(packageInfo.getDevTypeName())) continue;
            return packageInfo.getFilePath();
        }
        return "";
    }

    public void updateLoadPackageConfiguration(ITask iTask) {
        List devTypeList = iTask.getDeviceTypes();
        this.isAddDevtype(devTypeList);
        this.isDelDevtype(devTypeList);
    }

    private String getFileName(String filePath) {
        if (filePath.equals("")) {
            return "";
        }
        File f = new File(filePath);
        return f.getName();
    }

    public boolean validateFilePath() {
        int rowCount = this.m_oTableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (this.m_oTableModel.getValueAt(i, 1) != null && !this.m_oTableModel.getValueAt(i, 1).equals("")) continue;
            return false;
        }
        if (this.pathType == 1) {
            this.fillSimPackageInfoList(this.pathType);
        }
        return true;
    }

    public String pkgPath() {
        ArrayList<String> pathList = new ArrayList<String>();
        List<SelectPackgesInfo> pkgInfoList = this.getPackInfoList();
        for (SelectPackgesInfo pkgInfo : pkgInfoList) {
            pathList.add(pkgInfo.getFilePath());
        }
        if (pathList.size() == 1) {
            return (String)pathList.get(0);
        }
        String fristPath = (String)pathList.get(0);
        String pathSeparatorChar = File.separator;
        pathSeparatorChar = -1 != fristPath.indexOf("/") ? "/" : "\\";
        return this.loadPackageTabbedPan.getPath(pathList, pathSeparatorChar, fristPath);
    }

    protected String getCurrentContext() {
        String strHelpFileName = null;
        strHelpFileName = ResourceManager.getInstance().getResString("", "helpmapfile");
        return strHelpFileName;
    }

    public void setFilePath(String filePath, String deviceType) {
        int rowCount = this.m_oTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String devType = this.m_oTable.getValueAt(i, 0).toString();
            if (!devType.equals(deviceType)) continue;
            this.m_oTable.setValueAt(filePath, i, 1);
        }
    }

    class pkgSelectButtonEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JPanel panel = new JPanel();
        JTextField textField = new JTextField();
        JButton button = new JButton();

        public pkgSelectButtonEditor(String buttonText) {
            this.button.setText(buttonText);
            this.button.setSize(15, 20);
            this.button.setName("browseFileButton");
            this.textField.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.textField.setEditable(false);
            this.textField.setName("browseFileText");
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.textField, "Center");
            this.panel.add((Component)this.button, "East");
            ActionListener[] als = this.button.getActionListeners();
            for (int i = 0; i < als.length; ++i) {
                this.button.removeActionListener(als[i]);
            }
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    pkgSelectButtonEditor.this.actionPerformedByEditor(pkgSelectButtonEditor.this.textField.getText());
                }
            });
        }

        private void actionPerformedByEditor(String packagePath) {
            try {
                if (!packagePath.equals("")) {
                    SelectPackagesPanel.this.packagePathLast = packagePath;
                }
                SelectPackagesPanel.this.browaseDlg = new SimPackageBrowseDlg(SelectPackagesPanel.this.m_oTask, SelectPackagesPanel.this.packagePathLast);
                if (((SelectPackagesPanel)SelectPackagesPanel.this).browaseDlg.isClickOk) {
                    this.textField.setText(SelectPackagesPanel.this.browaseDlg.getPath());
                    SelectPackagesPanel.this.packagePathLast = SelectPackagesPanel.this.browaseDlg.getPath();
                    int row = SelectPackagesPanel.this.m_oTable.getSelectedRow();
                    SelectPackagesPanel.this.m_oTableModel.setValueAt(this.textField.getText(), row, 1);
                    this.textField.repaint();
                    if (null != SelectPackagesPanel.this.m_oTable.getCellEditor()) {
                        SelectPackagesPanel.this.m_oTable.getCellEditor().stopCellEditing();
                    }
                }
            }
            catch (DCException e) {
                if (null == DCFrameWorkUtil.getTaskMgmtOperationSelecPanel()) {
                    DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode());
                } else {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getTaskMgmtOperationSelecPanel(), e.getErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
                }
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value != null) {
                this.textField.setText(value.toString());
            }
            this.textField.repaint();
            return this.panel;
        }

        @Override
        public Object getCellEditorValue() {
            return this.textField.getText();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.textField.repaint();
            return super.stopCellEditing();
        }

        public Component getTableCellEditorComponent() {
            return this.textField;
        }
    }

    class pkgSelectButtonRenderer
    implements TableCellRenderer {
        JPanel panel = new JPanel();
        JTextField textField = new JTextField();
        JButton button = new JButton();

        public pkgSelectButtonRenderer(String buttonText) {
            this.button.setText(buttonText);
            this.button.setName("SelectPackagesDlg_jbInit_browseBtn");
            this.button.setSize(15, 20);
            this.textField.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.textField.setEditable(false);
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.textField, "Center");
            this.panel.add((Component)this.button, "East");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean isCellEditable = table.isCellEditable(row, column);
            this.button.setEnabled(isCellEditable);
            if (isSelected) {
                this.textField.setForeground(table.getSelectionForeground());
                this.textField.setBackground(table.getSelectionBackground());
            } else {
                this.textField.setEnabled(isCellEditable);
                this.textField.setForeground(table.getForeground());
                this.textField.setBackground(table.getBackground());
            }
            if (value != null) {
                this.textField.setText(value.toString());
            }
            this.textField.repaint();
            return this.panel;
        }
    }
}

