/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.asndatacenter.AsnDCSimulationPackageList;
import com.huawei.dc.common.asndatacenter.AsnDCSimulationPackageLoadSortRsp;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.loadpatch.LoadPatchOperation;
import com.huawei.dc.devicemanagement.deviceoperation.loadsimulationpackage.view.LoadSimPackageTabbedPane;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.LoadSoftwareOperation;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.sam.controller.TargetVersionPathGetter;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.SelectPackgesInfo;
import com.huawei.dc.taskmgmt.view.TaskMgmtOperationSelecPanel;
import com.huawei.dc.taskmgmt.view.common.SelectPackagesPanel;
import gnu.trove.THashSet;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;

public class SelectPackagesDlg
extends DCModalDialog {
    private SelectPackagesPanel selectPackagePanel = null;
    private LoadSimPackageTabbedPane loadPackageTabbedPan = null;
    private List<SelectPackgesInfo> modifyPackagesInfoList = null;
    private LoadSoftwareOperation loadSimuPackageOp;
    LoadFileInfoListParam m_oLoadParam;
    private LoadPatchOperation loadPathcOp;
    private ITask iTask;
    public boolean isClickOk = false;
    public int pathType = -1;

    public SelectPackagesDlg(ITask oTask, LoadSimPackageTabbedPane loadPackageTabbedPan) {
        this.pathType = 0;
        this.iTask = oTask;
        this.loadPackageTabbedPan = loadPackageTabbedPan;
        this.selectPackagePanel = new SelectPackagesPanel(oTask, loadPackageTabbedPan, 0);
        this.jbInit();
        this.setVisible(true);
    }

    public SelectPackagesDlg(ITask oTask, LoadSoftwareOperation loadSimuPackageOp, LoadFileInfoListParam m_oLoadParam, int pathType) {
        this.pathType = pathType;
        this.loadSimuPackageOp = loadSimuPackageOp;
        this.m_oLoadParam = m_oLoadParam;
        this.iTask = oTask;
        this.selectPackagePanel = new SelectPackagesPanel(oTask, pathType, 0);
        this.jbInit();
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
    }

    public SelectPackagesDlg(ITask oTask, LoadPatchOperation loadSimuPackageOp, LoadFileInfoListParam m_oLoadParam, int pathType) {
        this.pathType = pathType;
        this.loadPathcOp = loadSimuPackageOp;
        this.m_oLoadParam = m_oLoadParam;
        this.iTask = oTask;
        this.selectPackagePanel = new SelectPackagesPanel(oTask, pathType, 0);
        this.jbInit();
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
    }

    private void jbInit() {
        if (this.iTask.getTaskTypeId() == 2) {
            this.setTitle(ResourceManager.getInstance().getResString("LOAD_PATCH_DIALOG_TITLE"));
        } else {
            this.setTitle(ResourceManager.getInstance().getResString("LOAD_PACKAGE_DIALOG_TITLE"));
        }
        this.setLayout(null);
        this.initializeOKButton();
        this.initializeCancelButton();
        this.setSize(700, 520);
        this.getContentPane().add(this.m_oOKBtn);
        this.getContentPane().add(this.m_oCancelBtn);
        this.getContentPane().add(this.selectPackagePanel.getPanel());
        this.setResizable(false);
    }

    public SelectPackagesPanel getPackagePanel() {
        return this.selectPackagePanel;
    }

    private void initializeOKButton() {
        this.m_oOKBtn.setName("DeviceOperation_SimPackageSelectionDialog_m_oOKBtn");
        this.m_oOKBtn.setText(ResourceManager.getInstance().getResString("OK_BUTTON"));
        this.m_oOKBtn.setBounds(515, 455, 80, 21);
        this.m_oOKBtn.setToolTipText(ResourceManager.getInstance().getResString("OK_BUTTON"));
        this.getRootPane().setDefaultButton(this.m_oOKBtn);
    }

    private void initializeCancelButton() {
        this.m_oCancelBtn.setName("DeviceOperation_SimPackageSelectionDialog_m_oCancelBtn");
        this.m_oCancelBtn.setText(ResourceManager.getInstance().getResString("CANCEL_BUTTON"));
        this.m_oCancelBtn.setBounds(599, 455, 80, 21);
        this.m_oCancelBtn.setToolTipText(ResourceManager.getInstance().getResString("CANCEL_BUTTON"));
    }

    @Override
    protected void oKButton_ActionPerformed() {
        boolean isSelectPackage = this.selectPackagePanel.validateFilePath();
        if (!isSelectPackage) {
            String strErrorMsg = "";
            strErrorMsg = ResourceManager.getInstance().getResString("NO_File_SELECTED");
            DCOptionPane.showMessageDialog((Component)((Object)this), strErrorMsg, ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        this.modifyPackagesInfoList = this.selectPackagePanel.fillSimPackageInfoList(this.pathType);
        this.dispose();
        boolean isSuccess = true;
        if (this.pathType == 2) {
            this.handleForPkgUpgrade();
        } else {
            isSuccess = this.handleForSimPkgUpgrade();
        }
        if (!isSuccess) {
            return;
        }
        this.isClickOk = true;
    }

    private void handleForPkgUpgrade() {
        THashSet<Resource> resList = this.iTask.getDeviceType().getResources();
        List devTypeList = this.iTask.getDeviceTypes();
        List<SelectPackgesInfo> pkgInfoList = this.getPackagePanel().getPackInfoList();
        this.m_oLoadParam.clearAllFilesFromList();
        if (1 == devTypeList.size()) {
            LoadFileInfo[] fileList = new LoadFileInfo[]{new LoadFileInfo()};
            fileList[0].setSequenceNo(1);
            fileList[0].setFileName(pkgInfoList.get(0).getFilePath());
            fileList[0].setContentType(new ContentType(25, ResourceManager.getInstance().getResString("PACKAGE_FILE")));
            this.m_oLoadParam.addServerFiles(fileList);
        } else {
            Iterator oResItor = resList.iterator();
            Resource res = null;
            int i = 0;
            block0: while (oResItor.hasNext()) {
                res = (Resource)oResItor.next();
                LoadFileInfo fileInfo = new LoadFileInfo();
                fileInfo.setDeviceId(res.getDeviceID());
                fileInfo.setSequenceNo(i + 1);
                ++i;
                for (SelectPackgesInfo pkgInfo : pkgInfoList) {
                    if (!res.getDeviceType().equals(pkgInfo.getDevTypeName())) continue;
                    fileInfo.setFileName(pkgInfo.getFilePath());
                    this.m_oLoadParam.getLoadFileInfoList().add(fileInfo);
                    fileInfo.setContentType(new ContentType(25, ResourceManager.getInstance().getResString("PACKAGE_FILE")));
                    continue block0;
                }
            }
        }
        String path = pkgInfoList.get(0).getFilePath();
        if (path.equals("")) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("NO_LOAD_FILE_SELECTED"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        if (this.iTask.getTaskTypeId() == 2) {
            this.loadPathcOp.getParentTask().setLoadFileInfoListParam(this.m_oLoadParam);
            return;
        }
        this.loadSimuPackageOp.getOperationData().setLoadFileInfoListParam(this.m_oLoadParam);
        String strTargetVer = this.iTask.getTargetVersion();
        if (strTargetVer.length() > 0) {
            LoadFileInfoListParam m_oLoadParamtmp = this.m_oLoadParam;
            List<LoadFileInfo> strFilePathLst = this.m_oLoadParam.getLoadFileInfoList();
            String strTargetFilePath = TargetVersionPathGetter.getTargetVersionDir(this.iTask.getDeviceType(), strTargetVer, this.iTask);
            for (int index = 0; index < strFilePathLst.size(); ++index) {
                String strFilePath = ((Object)strFilePathLst.get(index)).toString();
                if ((strFilePath = strFilePath.substring(0, strFilePath.indexOf(","))).equalsIgnoreCase(strTargetFilePath)) continue;
                TaskMgmtOperationSelecPanel oTaskMgmtOperationSelecPanel = DCFrameWorkUtil.getTaskMgmtOperationSelecPanel();
                if (null == oTaskMgmtOperationSelecPanel) break;
                oTaskMgmtOperationSelecPanel.updateTargetVsnBlank();
                this.loadSimuPackageOp.getOperationData().setLoadFileInfoListParam(m_oLoadParamtmp);
                break;
            }
        }
    }

    private boolean handleForSimPkgUpgrade() {
        AsnDCSimulationPackageList packageList = this.loadPackageTabbedPan.getPackageInfoList(this.loadPackageTabbedPan.getSelectPackagesInfoList());
        AsnDCSimulationPackageLoadSortRsp packageLoadSortRsp = this.loadPackageTabbedPan.getPackageLoadSort(packageList);
        if (packageLoadSortRsp == null) {
            return false;
        }
        this.loadPackageTabbedPan.showPackageTbalePan.populateResourceInTable(packageLoadSortRsp.oSimulationPackageInfoDeviceLst);
        return true;
    }

    @Override
    protected String getCurrentContext() {
        String strHelpFileName = null;
        DCDebugTracer.trace("help id is empty in " + SelectPackagesDlg.class.getName());
        strHelpFileName = ResourceManager.getInstance().getResString("", "helpmapfile");
        return strHelpFileName;
    }

    public List<SelectPackgesInfo> getModifyPackagesInfoList() {
        return this.modifyPackagesInfoList;
    }
}

