/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCSortableTableModel;
import com.huawei.dc.common.asndatacenter.AsnDCLoadBoardInfo;
import com.huawei.dc.common.asndatacenter.AsnDCLoadBoardList;
import com.huawei.dc.common.asndatacenter.AsnDCLoadTaskDeviceInfo;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCHelpManager;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public class QueryFailedBoardInfoDlg
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private QueryInfoSortableTableModel m_oQueryInfoTableModel;
    private DCExtendedTable m_QueryInfoTable;
    private ResourceManager m_oRes = ResourceManager.getInstance();
    private JScrollPane oScrollPan = null;
    private final List<AsnDCLoadTaskDeviceInfo> oQueryInfoList;
    private static final int DEVICE_NAME_INDEX = 0;
    private static final int BOARD_ID_INDEX = 1;
    private static final int BOARD_TYPE_INDEX = 2;
    private String[] m_arrHeader = new String[]{this.m_oRes.getResString("DEVICE_NAME"), this.m_oRes.getResString("BOARD_ID"), this.m_oRes.getResString("BOARD_TYPE"), this.m_oRes.getResString("FAILURE_REASON")};

    public QueryFailedBoardInfoDlg(List<AsnDCLoadTaskDeviceInfo> queryInfoList) {
        this.oQueryInfoList = queryInfoList;
        this.jbInit();
        if (this.oQueryInfoList != null && this.oQueryInfoList.size() != 0) {
            this.populateTable(this.oQueryInfoList);
        }
    }

    private void populateTable(List<AsnDCLoadTaskDeviceInfo> oQueryInfoList) {
        for (AsnDCLoadTaskDeviceInfo oDeviceInfo : oQueryInfoList) {
            AsnDCLoadBoardList oBoardList = oDeviceInfo.oBoardList;
            int iBoardListSize = oBoardList.size();
            for (int i = 0; i < iBoardListSize; ++i) {
                AsnDCLoadBoardInfo oBoardInfo = (AsnDCLoadBoardInfo)oBoardList.get(i);
                Vector<Object> oRowVector = new Vector<Object>(0);
                if (0 == i) {
                    oRowVector.add(new String(oDeviceInfo.strDeviceName));
                } else {
                    oRowVector.add("");
                }
                if (0 == oBoardInfo.iFrameId.intValue()) {
                    oRowVector.add(oBoardInfo.iSlotId.intValue());
                } else {
                    oRowVector.add(oBoardInfo.iFrameId.intValue() + "-" + oBoardInfo.iSlotId.intValue());
                }
                oRowVector.add(new String(oBoardInfo.strBoardName));
                oRowVector.add(new String(oBoardInfo.strFaliureReason));
                this.m_oQueryInfoTableModel.addRow(oRowVector);
            }
        }
        this.m_QueryInfoTable.setRowSelectionInterval(0, 0);
        this.oScrollPan.getVerticalScrollBar().setValue(0);
    }

    private void jbInit() {
        JPanel oQueryMainPanel = new JPanel();
        oQueryMainPanel.setLayout(null);
        JPanel tablePanel = new JPanel();
        tablePanel.setBounds(new Rectangle(12, 50, 545, 273));
        tablePanel.setLayout(null);
        this.m_oQueryInfoTableModel = new QueryInfoSortableTableModel(this.m_arrHeader, 0);
        this.m_QueryInfoTable = new DCExtendedTable((SortableTableModel)this.m_oQueryInfoTableModel);
        this.m_QueryInfoTable.setName("QueryFailedBoardInfoDlg_QueryInfoTable");
        this.m_QueryInfoTable.getTableHeader().setReorderingAllowed(false);
        this.m_QueryInfoTable.setRowHeight(21);
        this.m_QueryInfoTable.getTableHeader().setPreferredSize(new Dimension(this.m_QueryInfoTable.getSize().width, 21));
        this.m_QueryInfoTable.setSortableClickCount(1);
        this.m_QueryInfoTable.setColumnSortable(0, true);
        this.m_QueryInfoTable.setColumnSortable(1, true);
        this.m_QueryInfoTable.setColumnSortable(2, true);
        TableColumnModel oColModel = this.m_QueryInfoTable.getColumnModel();
        DataAllignmentInCenter oAlignrenderer = new DataAllignmentInCenter();
        oColModel.getColumn(0).setCellRenderer(oAlignrenderer);
        oColModel.getColumn(1).setCellRenderer(oAlignrenderer);
        oColModel.getColumn(2).setCellRenderer(oAlignrenderer);
        oColModel.getColumn(3).setCellRenderer(oAlignrenderer);
        this.m_oOKBtn.setName("QueryFailedBoardInfoDlg_OKBtn");
        this.m_oCancelBtn.setName("QueryFailedBoardInfoDlg_CancelBtn");
        this.m_oCancelBtn.setBounds(new Rectangle(476, 335, 80, 21));
        this.m_oCancelBtn.setText(ResourceManager.getInstance().getResString("CLOSE_REPORT"));
        this.oScrollPan = new JScrollPane();
        this.oScrollPan.setBounds(new Rectangle(0, 0, 546, 270));
        this.oScrollPan.getViewport().add((Component)this.m_QueryInfoTable, null);
        tablePanel.add(this.oScrollPan);
        oQueryMainPanel.add((Component)tablePanel, null);
        oQueryMainPanel.add((Component)this.m_oCancelBtn, null);
        this.getContentPane().add(oQueryMainPanel);
        this.m_QueryInfoTable.getTableHeader().addMouseMotionListener(new TopTableHeaderListener());
        this.setTitle(this.m_oRes.getResString("QUERY_DLG_TITLE"));
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.setResizable(false);
        this.setSize(578, 401);
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), "HELP_TOPIC_QUERY_FAILED_BOARD");
        this.m_oCancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryFailedBoardInfoDlg.this.dispose();
            }
        });
    }

    @Override
    public void doCleanUp() {
        this.dispose();
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_QUERY_FAILED_BOARD";
    }

    class DataAllignmentInCenter
    extends DefaultTableCellRenderer {
        DataAllignmentInCenter() {
        }

        @Override
        protected void setValue(Object value) {
            super.setValue(value);
            this.setHorizontalAlignment(0);
        }
    }

    class QueryInfoSortableTableModel
    extends DCSortableTableModel {
        public QueryInfoSortableTableModel(String[] columnNames, int rowCount) {
            super((Object[])columnNames, rowCount);
        }

        public void sortByColumn(int column, boolean isDesc) {
            if (-1 == column) {
                return;
            }
            QueryInfoSortComparator oComparator = new QueryInfoSortComparator(column, isDesc);
            if (null == QueryFailedBoardInfoDlg.this.oQueryInfoList || QueryFailedBoardInfoDlg.this.oQueryInfoList.isEmpty()) {
                return;
            }
            if (0 == column) {
                Collections.sort(QueryFailedBoardInfoDlg.this.oQueryInfoList, oComparator);
            } else {
                for (AsnDCLoadTaskDeviceInfo oDevInfo : QueryFailedBoardInfoDlg.this.oQueryInfoList) {
                    Collections.sort(oDevInfo.oBoardList, oComparator);
                }
            }
            int rowNum = this.getRowCount();
            for (int i = rowNum - 1; i >= 0; --i) {
                this.removeModelRow(i);
            }
            QueryFailedBoardInfoDlg.this.populateTable(QueryFailedBoardInfoDlg.this.oQueryInfoList);
        }
    }

    class QueryInfoSortComparator
    implements Comparator {
        private boolean isDesc = true;
        private int sortedColumn = -1;

        public QueryInfoSortComparator(int sortedColumn, boolean isDesc) {
            this.sortedColumn = sortedColumn;
            this.isDesc = !isDesc;
        }

        public int compare(Object o1, Object o2) {
            int result = 0;
            if (0 == this.sortedColumn) {
                AsnDCLoadTaskDeviceInfo oDevInfo1 = (AsnDCLoadTaskDeviceInfo)o1;
                AsnDCLoadTaskDeviceInfo oDevInfo2 = (AsnDCLoadTaskDeviceInfo)o2;
                String devName1 = new String(oDevInfo1.strDeviceName);
                String devName2 = new String(oDevInfo2.strDeviceName);
                result = this.isDesc ? devName1.compareTo(devName2) : -devName1.compareTo(devName2);
            } else {
                AsnDCLoadBoardInfo oBoardInfo1 = (AsnDCLoadBoardInfo)o1;
                AsnDCLoadBoardInfo oBoardInfo2 = (AsnDCLoadBoardInfo)o2;
                if (1 == this.sortedColumn) {
                    int iFrameId1 = oBoardInfo1.iFrameId.intValue();
                    int iFrameId2 = oBoardInfo2.iFrameId.intValue();
                    int boardId1 = oBoardInfo1.iSlotId.intValue();
                    int boardId2 = oBoardInfo2.iSlotId.intValue();
                    result = this.isDesc ? iFrameId1 - iFrameId2 : iFrameId2 - iFrameId1;
                    if (result == 0) {
                        result = this.isDesc ? boardId1 - boardId2 : boardId2 - boardId1;
                    }
                } else if (2 == this.sortedColumn) {
                    String boardName1 = new String(oBoardInfo1.strBoardName);
                    String boardName2 = new String(oBoardInfo2.strBoardName);
                    result = this.isDesc ? boardName1.compareTo(boardName2) : -boardName1.compareTo(boardName2);
                }
            }
            return result;
        }
    }

    class TopTableHeaderListener
    extends MouseMotionAdapter {
        TopTableHeaderListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int colNum = QueryFailedBoardInfoDlg.this.m_QueryInfoTable.getColumnModel().getColumnIndexAtX(e.getX());
            if (colNum > -1) {
                QueryFailedBoardInfoDlg.this.m_QueryInfoTable.getTableHeader().setToolTipText(QueryFailedBoardInfoDlg.this.m_QueryInfoTable.getColumnName(colNum));
            }
        }
    }
}

