/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.asndatacenter.AsnDCSIBoardInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnSIBoardInfo;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.treetable.model.DCTreeTableModel;
import com.huawei.dc.common.components.treetable.model.SortCriteria;
import com.huawei.dc.common.components.treetable.model.TreeTableCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableComparator;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableNodeCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.components.treetable.view.DCTreeTableCellRenderer;
import com.huawei.dc.common.controller.AbstractDeviceInfoManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.framework.utility.print.tools.TablePrintable;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCSaveFileChooser;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.security.LoginInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class QueryBoardResetInfoDlg
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private JPanel m_oBoardResetInfoPanel;
    private DCTreeTableModel m_oResetInfoTableModel;
    private DCSortableTreeTable m_oResetInfoTable;
    private JToolBar m_toolBar;
    private ImageIcon m_oExpandIcon;
    private ImageIcon m_oCollapseIcon;
    private JButton expandButton;
    private JButton collapseButton;
    private JPanel m_tablePanel;
    private TreeTableNode m_oRootNode;
    private JScrollPane m_oTableScrollPan;
    private JLabel m_oDescriptionLabel;
    private JLabel m_oProgressLabel;
    private JProgressBar m_oProgressBar;
    private JPanel m_oButtonsPanel;
    private JButton m_oSaveToFileBtn;
    private int m_iTotalNENum = 0;
    private String m_strTaskName = "";
    private int m_iComlpetedNeNum = 0;
    private static final int DEVICE_NAME_COLUMN = 0;
    private static final int BOARD_ID_COLUMN = 1;
    private static final int BOARD_TYPE_COLUMN = 2;
    private static final int QUERY_RESULT_COLUMN = 3;
    private SortCriteria m_oLastSortCriteria;
    private List<Resource> unSupportQueryDevList;
    private String[] m_arrHeader = new String[]{ResourceManager.getInstance().getResString("QUERY_BOARD_RESET_DLG_DEVNAME_COLUNM"), ResourceManager.getInstance().getResString("QUERY_BOARD_RESET_DLG_BOARDID_COLUNM"), ResourceManager.getInstance().getResString("QUERY_BOARD_RESET_DLG_BOARDTYPE_COLUNM"), ResourceManager.getInstance().getResString("QUERY_BOARD_RESET_DLG_RESULT_COLUNM")};
    private String strProgressContent = ResourceManager.getInstance().getResString("QUERY_BOARD_RESET_PROGRESS_CONTENT");

    public QueryBoardResetInfoDlg(int neNum, String strTaskName, List<Resource> unSupportQueryDevList) {
        this.m_strTaskName = strTaskName;
        this.unSupportQueryDevList = unSupportQueryDevList;
        this.m_iTotalNENum = neNum;
        this.setDefaultCloseOperation(0);
        this.jbInit();
        this.hitUnSupportDeviceMsg();
    }

    private void jbInit() {
        this.setSize(700, 550);
        this.setResizable(true);
        this.setLayout(new GridBagLayout());
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.setTitle(ResourceManager.getInstance().getResString("QUERY_BOARD_RESET_DLG_TITLE"));
        this.initMainPanl();
    }

    private void initMainPanl() {
        this.m_oBoardResetInfoPanel = new JPanel();
        this.m_oBoardResetInfoPanel.setName("QueryBoardResetInfoDlg_m_oBoardResetInfoPanel");
        this.m_oBoardResetInfoPanel.setLayout(new GridBagLayout());
        this.m_oDescriptionLabel = new JLabel(ResourceManager.getInstance().getResString("QUERY_BOARD_RESET_DLG_DESCRIPTION_LABEL"));
        this.initProgressPanel();
        this.initTablePanel();
        this.initButtonPanel();
        this.getContentPane().add((Component)this.m_oProgressLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(10, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.m_oProgressBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 10, 10, 10), 0, 0));
        this.getContentPane().add((Component)this.m_oDescriptionLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.m_tablePanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 15.0, 10, 1, new Insets(5, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.m_oCancelBtn, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 13, 0, new Insets(10, 0, 10, 10), 0, 0));
        this.getContentPane().add((Component)this.m_oSaveToFileBtn, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.getContentPane().add((Component)this.m_oBoardResetInfoPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
    }

    private void initTablePanel() {
        this.createTableModel();
        this.createTreeTable();
        this.m_toolBar = new JToolBar();
        this.m_toolBar.setName("QueryBoardResetInfo_m_toolBar");
        this.m_toolBar.setFloatable(false);
        this.m_toolBar.setRollover(true);
        this.m_toolBar.setMaximumSize(new Dimension(50, 40));
        this.m_toolBar.setMinimumSize(new Dimension(50, 40));
        this.m_oExpandIcon = ResourceManager.getInstance().getImage("expand_tasks.gif");
        this.expandButton = new JButton("", this.m_oExpandIcon);
        this.expandButton.setName("TaskMgmt_GroupTablePanel_expandButton");
        this.expandButton.setBackground(this.getBackground());
        this.expandButton.setEnabled(false);
        this.expandButton.setToolTipText(ResourceManager.getInstance().getResString("EXPAND"));
        this.expandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryBoardResetInfoDlg.this.expandTree(QueryBoardResetInfoDlg.this.m_oResetInfoTable.getTree(), QueryBoardResetInfoDlg.this.m_oRootNode);
            }
        });
        this.m_oCollapseIcon = ResourceManager.getInstance().getImage("collapse_tasks.gif");
        this.collapseButton = new JButton("", this.m_oCollapseIcon);
        this.collapseButton.setName("TaskMgmt_GroupTablePanel_collapseButton");
        this.collapseButton.setBackground(this.getBackground());
        this.collapseButton.setEnabled(false);
        this.collapseButton.setToolTipText(ResourceManager.getInstance().getResString("COLLAPSE"));
        this.collapseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryBoardResetInfoDlg.this.collapseTree(QueryBoardResetInfoDlg.this.m_oResetInfoTable.getTree(), QueryBoardResetInfoDlg.this.m_oRootNode);
            }
        });
        this.m_toolBar.add(this.expandButton);
        this.m_toolBar.add(this.collapseButton);
        this.m_oTableScrollPan = new JScrollPane();
        this.m_oTableScrollPan.getViewport().add((Component)((Object)this.m_oResetInfoTable), null);
        Border oBorder = BorderFactory.createEtchedBorder(Color.gray, Color.white);
        this.m_oTableScrollPan.setPreferredSize(new Dimension(600, 400));
        this.m_oTableScrollPan.setMinimumSize(new Dimension(600, 400));
        this.m_oTableScrollPan.setMaximumSize(new Dimension(600, 400));
        this.m_tablePanel = new JPanel();
        this.m_tablePanel.setLayout(new BorderLayout());
        this.m_tablePanel.add((Component)this.m_toolBar, "North");
        this.m_tablePanel.add((Component)this.m_oTableScrollPan, "Center");
        this.m_tablePanel.setBorder(oBorder);
    }

    private void createTableModel() {
        Class[] arrColumnTypes = new Class[]{TreeTableModel.class, String.class, String.class, String.class, String.class};
        boolean[] arrSortableColumns = new boolean[]{true, false, false, false};
        boolean[] arrEditableColumns = new boolean[]{true, false, false, false};
        this.m_oResetInfoTableModel = new DCTreeTableModel(this.m_arrHeader, arrColumnTypes, arrSortableColumns, arrEditableColumns);
        this.m_oRootNode = this.m_oResetInfoTableModel.getRoot();
    }

    private void createTreeTable() {
        this.m_oResetInfoTable = new DCSortableTreeTable(this.m_oResetInfoTableModel);
        this.m_oResetInfoTable.setName("QueryBoardResetInfoDlg_m_oResetInfoTable");
        this.m_oResetInfoTable.setOpaque(true);
        this.m_oResetInfoTable.getTableHeader().setReorderingAllowed(false);
        this.m_oResetInfoTable.getTableHeader().setPreferredSize(new Dimension(this.m_oResetInfoTable.getSize().width, 20));
        this.m_oResetInfoTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.m_oResetInfoTable.getColumnModel().getColumn(0).setMaxWidth(250);
        this.m_oResetInfoTable.setRowHeight(20);
        this.m_oResetInfoTable.setShowHorizontalLines(true);
        DefaultListSelectionModel devSelection = new DefaultListSelectionModel();
        devSelection.setSelectionMode(2);
        this.m_oResetInfoTable.setSelectionModel(devSelection);
        this.m_oResetInfoTable.getTree().setToggleClickCount(2);
        this.initializeTableCellRenderer();
        this.m_oResetInfoTable.setSelectionMode(2);
        this.m_oResetInfoTable.getTableHeader().addMouseListener(this.generateMouseAdapterForTableHeader());
    }

    private MouseAdapter generateMouseAdapterForTableHeader() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                QueryBoardResetInfoDlg.this.tableHeader_MousePressed(e);
            }
        };
    }

    private void tableHeader_MousePressed(MouseEvent oMouseEvent) {
        if (this.m_oResetInfoTableModel.getRowCount() <= 0) {
            return;
        }
        int iCurrentColumn = this.m_oResetInfoTable.getTableHeader().columnAtPoint(oMouseEvent.getPoint());
        if (!this.m_oResetInfoTableModel.isColumnSortable(iCurrentColumn)) {
            return;
        }
        boolean bSortType = this.m_oResetInfoTable.getCurrentSortState(iCurrentColumn) == 1;
        this.sortColumn(iCurrentColumn, bSortType);
        this.m_oResetInfoTable.setCurrentSortColumn(iCurrentColumn);
        this.refreshTable();
    }

    public void sortColumn(int iCurrentColumn, boolean bSortType) {
        this.m_oRootNode.sortNode(new TreeTableComparator(bSortType, iCurrentColumn, true), true);
        if (null == this.m_oLastSortCriteria) {
            this.m_oLastSortCriteria = new SortCriteria();
        }
        this.m_oLastSortCriteria.setSortColumn(iCurrentColumn);
        this.m_oLastSortCriteria.setIsAscendingSort(bSortType);
    }

    public void refreshTable() {
        if (0 == this.m_oResetInfoTable.getRowCount()) {
            this.m_oResetInfoTable.clearCurrentSort();
        }
        this.updateTableView();
    }

    private void updateTableView() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                QueryBoardResetInfoDlg.this.m_oResetInfoTable.getTableHeader().updateUI();
                QueryBoardResetInfoDlg.this.m_oResetInfoTable.updateUI();
                QueryBoardResetInfoDlg.this.m_oResetInfoTable.getTree().updateUI();
            }
        });
    }

    private void initializeTableCellRenderer() {
        this.m_oResetInfoTable.getTree().setCellRenderer(new QueryTableCellRenderer());
        DCTreeTableCellRenderer oSlotCellRenderer = new DCTreeTableCellRenderer(this.m_oResetInfoTable, 2);
        oSlotCellRenderer.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Color.gray));
        this.m_oResetInfoTable.getColumnModel().getColumn(1).setCellRenderer(oSlotCellRenderer);
        DCTreeTableCellRenderer oDefaultCellRenderer = new DCTreeTableCellRenderer(this.m_oResetInfoTable, 2);
        this.m_oResetInfoTable.getColumnModel().getColumn(2).setCellRenderer(oDefaultCellRenderer);
        this.m_oResetInfoTable.getColumnModel().getColumn(3).setCellRenderer(oDefaultCellRenderer);
    }

    private void initProgressPanel() {
        this.m_oProgressLabel = new JLabel(ResourceManager.getInstance().getResString("QUERY_BOARD_RESET_PROGRESS_LABEL"));
        this.m_oProgressLabel.setName("QueryBoardResetInfoDlg_m_oProgressPanel");
        this.m_oProgressBar = new JProgressBar();
        this.m_oProgressBar.setName("QueryBoardResetInfoDlg_m_oProgressBar");
        this.m_oProgressBar.setIndeterminate(false);
        this.m_oProgressBar.setStringPainted(true);
        this.m_oProgressBar.setString(MessageFormat.format(this.strProgressContent, "" + this.m_iComlpetedNeNum, "" + this.m_iTotalNENum));
        if (this.m_iComlpetedNeNum == this.m_iTotalNENum) {
            this.m_oProgressBar.setValue(100);
            this.m_oProgressLabel.setText(ResourceManager.getInstance().getResString("QUERY_BOARD_RESET_PROGRESS_LABEL_COMPLETE"));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryBoardResetInfoDlg.this.m_oProgressBar.repaint();
                }
            });
        }
    }

    private void initButtonPanel() {
        this.m_oButtonsPanel = new JPanel();
        this.m_oButtonsPanel.setName("QueryBoardResetInfoDlg_m_oButtonsPanel");
        this.m_oButtonsPanel.setLayout(null);
        this.m_oSaveToFileBtn = new JButton(ResourceManager.getInstance().getResString("QUERY_BOARD_RESET_DLG_SAVE_BTN"));
        this.m_oSaveToFileBtn.setName("QueryBoardResetInfoDlg_m_oSaveToFileBtn");
        this.m_oSaveToFileBtn.setPreferredSize(new Dimension(120, 20));
        this.m_oSaveToFileBtn.setMinimumSize(new Dimension(120, 20));
        this.m_oSaveToFileBtn.setMaximumSize(new Dimension(120, 20));
        this.m_oSaveToFileBtn.setEnabled(false);
        this.m_oSaveToFileBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryBoardResetInfoDlg.this.saveButtonActionPerformed();
            }
        });
        this.m_oCancelBtn.setText(ResourceManager.getInstance().getResString("QUERY_BOARD_RESET_DLG_CLOSE_BTN"));
        this.m_oCancelBtn.setName("QueryBoardResetInfoDlg_m_oCancelBtn");
        this.m_oCancelBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oCancelBtn.setMinimumSize(new Dimension(80, 20));
        this.m_oCancelBtn.setMaximumSize(new Dimension(80, 20));
        this.m_oCancelBtn.setEnabled(false);
    }

    public void saveButtonActionPerformed() {
        if (null == this.m_oResetInfoTable) {
            return;
        }
        int iTotalRows = this.m_oResetInfoTable.getRowCount();
        if (iTotalRows <= 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("DEVICE_INFORMATION_EMPTY"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
            return;
        }
        DCSaveFileChooser oFileChooserDlg = null;
        oFileChooserDlg = new DCSaveFileChooser();
        oFileChooserDlg.setFileFilter(2);
        oFileChooserDlg.setAcceptAllFileFilterUsed(false);
        oFileChooserDlg.setEncodingEnabled(true);
        String strTaskName = FileUtil.getFileName(this.m_strTaskName);
        oFileChooserDlg.setSelectedFile(new File(strTaskName + "_" + "resetinfor"));
        int iReturnVal = -1;
        iReturnVal = oFileChooserDlg.showSaveDialog((Component)((Object)this));
        if (iReturnVal == 0) {
            String strFileName = oFileChooserDlg.getFullFileName();
            if (strFileName.toLowerCase().endsWith(".csv")) {
                this.saveDeviceInformation(strFileName);
            } else {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_FILE_TYPE_NOT_SUPP"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
            }
        }
    }

    private void saveDeviceInformation(final String strFileName) {
        if (null == this.m_oResetInfoTable) {
            return;
        }
        final Vector resetInfoVec = new Vector();
        for (int i = 0; i < this.m_oRootNode.getChildCount(); ++i) {
            TreeTableNode devNode = (TreeTableNode)this.m_oRootNode.getChildAt(i);
            TreeTableRowData oRowData = (TreeTableRowData)devNode.getUserObject();
            Vector<String> rowDataVec = new Vector<String>();
            rowDataVec.add(oRowData.getColumnData(0).toString());
            rowDataVec.add("");
            rowDataVec.add("");
            if (null != oRowData.getColumnData(3)) {
                rowDataVec.add(oRowData.getColumnData(3).toString());
            }
            resetInfoVec.add(rowDataVec);
            int boardNodeCount = devNode.getChildCount();
            for (int j = 0; j < boardNodeCount; ++j) {
                TreeTableNode boardNode = (TreeTableNode)devNode.getChildAt(j);
                TreeTableRowData oboardRowData = (TreeTableRowData)boardNode.getUserObject();
                Vector<String> bdRowDataVec = new Vector<String>();
                bdRowDataVec.add("");
                bdRowDataVec.add(oboardRowData.getColumnData(1).toString());
                bdRowDataVec.add(oboardRowData.getColumnData(2).toString());
                bdRowDataVec.add("");
                resetInfoVec.add(bdRowDataVec);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TablePrintable printable = null;
                String strHeader = ResourceManager.getInstance().getResString("QUERY_BOARD_RESET_DLG_TITLE");
                LoginInfo loginInfo = DCFrameWorkUtil.getSecurityManager().getLoginInfo();
                String strUserName = loginInfo.getUserName();
                String strFileType = "csv";
                try {
                    printable = new TablePrintable(strHeader, strUserName, " ", QueryBoardResetInfoDlg.this.m_arrHeader, resetInfoVec, resetInfoVec.size() + 1, true, QueryBoardResetInfoDlg.this.m_iTotalNENum);
                }
                catch (Exception ex) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_VECTOR_FAILED"), ResourceManager.getInstance().getResString("INFO"), 1);
                    return;
                }
                PrintSupportor.setIsCheckFileNameAndType(false);
                boolean bSaveSuccess = PrintSupportor.saveToFile((Window)DCFrameWorkUtil.getMainFrame(), strFileName, printable, strFileType);
                if (!bSaveSuccess) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_FAILURE"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
                }
            }
        });
    }

    public synchronized void insertBoardResetInfo(AsnDCSIBoardInfoRsp oAsnDCSIBoardInfoRsp) {
        this.addDeviceToTableModel(oAsnDCSIBoardInfoRsp);
        this.updateTableView();
        this.setProgress();
        if (oAsnDCSIBoardInfoRsp.bIsFinal) {
            DCDebugTracer.trace("DC::QueryBoardResetInfoDlg::oAsnDCSIBoardInfoRsp.bIsFinal::" + oAsnDCSIBoardInfoRsp.bIsFinal);
            DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(0));
            this.m_oCancelBtn.setEnabled(true);
            this.m_oSaveToFileBtn.setEnabled(true);
            this.collapseButton.setEnabled(true);
            this.expandButton.setEnabled(true);
        }
    }

    private void hitUnSupportDeviceMsg() {
        if (this.unSupportQueryDevList.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Resource res : this.unSupportQueryDevList) {
            sb.append("\n");
            sb.append(res.getDeviceName());
        }
        String msg = ResourceManager.getInstance().getResString("QUERY_BOARD_RESET_DLG_UNSUPPORTNE", new String[]{sb.toString()});
        DCOptionPane.showMessageDialog((Component)((Object)this), msg);
    }

    private void addDeviceToTableModel(AsnDCSIBoardInfoRsp oAsnDCSIBoardInfoRsp) {
        DeviceInfo deviceInfo;
        int iDeviceId = oAsnDCSIBoardInfoRsp.iDeviceID.intValue();
        int iErrorNum = oAsnDCSIBoardInfoRsp.oErrorNo.iErrorNo.intValue();
        String strErrMsg = "";
        if (0 != iErrorNum) {
            strErrMsg = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorNum));
        }
        if (null == (deviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(iDeviceId))) {
            DCDebugTracer.trace("DC::QueryBoardResetResetInfoDlg::addDeviceToTableModel::oAsnDCSIBoardInfoRsp.iDeviceID.intValue()::" + oAsnDCSIBoardInfoRsp.iDeviceID.intValue());
            return;
        }
        TreeTableCellData[] oTreeTableCellData = new TreeTableCellData[4];
        oTreeTableCellData[0] = this.getTableNodeData(deviceInfo.getDevName());
        oTreeTableCellData[3] = this.getCellData(strErrMsg);
        TreeTableRowData oRowData = new TreeTableRowData(oTreeTableCellData);
        TreeTableNode oNode = new TreeTableNode(oRowData);
        if (0 == oAsnDCSIBoardInfoRsp.oAsnSIBoardInfoLst.size() || !"".equals(strErrMsg)) {
            strErrMsg = ResourceManager.getInstance().getResString("QUERY_BOARD_RESET_DLG_NOBOARD");
            oTreeTableCellData[3] = this.getCellData(strErrMsg);
        } else {
            ((TreeTableNodeCellData)oTreeTableCellData[0]).setAttachedTreeNode(oNode);
            this.addBoardToTableModel(oNode, (List<Object>)oAsnDCSIBoardInfoRsp.oAsnSIBoardInfoLst);
        }
        this.m_oRootNode.add(oNode);
    }

    private void addBoardToTableModel(TreeTableNode oParentNode, List<Object> boardList) {
        for (Object oBoardInfo : boardList) {
            AsnSIBoardInfo oAsnSIBoardInfo = (AsnSIBoardInfo)oBoardInfo;
            TreeTableCellData[] oTreeTableCellData = new TreeTableCellData[4];
            AbstractDeviceInfoManager impl = (AbstractDeviceInfoManager)DeviceInfoManagerImpl.getInstance();
            String slotName = impl.getBoardNameForT2000(oAsnSIBoardInfo.iSlotId.intValue());
            oTreeTableCellData[1] = this.getCellData(slotName);
            oTreeTableCellData[2] = this.getCellData(new String(oAsnSIBoardInfo.strSlotLabel));
            TreeTableRowData oRowData = new TreeTableRowData(oTreeTableCellData);
            TreeTableNode oNode = new TreeTableNode(oRowData);
            oParentNode.add(oNode);
        }
    }

    private TreeTableCellData getCellData(Object colValue) {
        return new TreeTableCellData(colValue);
    }

    private TreeTableNodeCellData getTableNodeData(Object oNodeInfo) {
        TreeTableNodeCellData oDeviceNodeData = new TreeTableNodeCellData();
        oDeviceNodeData.setNodeLeafIcon("");
        oDeviceNodeData.setCellDataValue(oNodeInfo);
        return oDeviceNodeData;
    }

    public void setProgress() {
        ++this.m_iComlpetedNeNum;
        if (this.m_iComlpetedNeNum == this.m_iTotalNENum) {
            this.m_oProgressLabel.setText(ResourceManager.getInstance().getResString("QUERY_BOARD_RESET_PROGRESS_LABEL_COMPLETE"));
        }
        int iProgress = this.m_iComlpetedNeNum * 100 / this.m_iTotalNENum;
        this.m_oProgressBar.setValue(iProgress);
        this.m_oProgressBar.setString(MessageFormat.format(this.strProgressContent, "" + this.m_iComlpetedNeNum, "" + this.m_iTotalNENum));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                QueryBoardResetInfoDlg.this.m_oProgressBar.repaint();
            }
        });
    }

    public void expandTree(JTree tree, DefaultMutableTreeNode start) {
        Enumeration<TreeNode> children = start.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode dtm = (DefaultMutableTreeNode)children.nextElement();
            if (dtm.isLeaf()) continue;
            TreePath tp = new TreePath(dtm.getPath());
            tree.expandPath(tp);
            this.expandTree(tree, dtm);
        }
    }

    public void collapseTree(JTree tree, DefaultMutableTreeNode start) {
        Enumeration<TreeNode> children = start.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode dtm = (DefaultMutableTreeNode)children.nextElement();
            if (dtm.isLeaf()) continue;
            TreePath tp = new TreePath(dtm.getPath());
            tree.collapsePath(tp);
            this.collapseTree(tree, dtm);
        }
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }

    @Override
    protected void closeDialog() {
        if (this.m_oProgressBar.getValue() != 100) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("QUERY_BOARD_RESET_PROGRESS_LABEL"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
            return;
        }
        super.closeDialog();
    }

    @Override
    public void doCleanUp() {
        this.m_arrHeader = null;
        this.m_oBoardResetInfoPanel = null;
        this.m_oButtonsPanel = null;
        this.m_oDescriptionLabel = null;
        this.m_oLastSortCriteria = null;
        this.m_oProgressBar = null;
        this.m_oResetInfoTable = null;
        this.m_oProgressLabel = null;
        this.m_oTableScrollPan = null;
        this.m_oProgressLabel = null;
        this.m_oSaveToFileBtn = null;
        this.unSupportQueryDevList = null;
        this.m_oRootNode = null;
        this.m_strTaskName = null;
        super.doCleanUp();
    }

    class QueryTableCellRenderer
    implements TreeCellRenderer {
        private static final long serialVersionUID = 1L;

        QueryTableCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel oLabel = new JLabel();
            oLabel.setOpaque(true);
            oLabel.setIconTextGap(8);
            oLabel.setBorder(QueryBoardResetInfoDlg.this.m_oResetInfoTable.getBorder());
            if (QueryBoardResetInfoDlg.this.m_oResetInfoTable.isRowSelected(row)) {
                oLabel.setBackground(QueryBoardResetInfoDlg.this.m_oResetInfoTable.getSelectionBackground());
                oLabel.setForeground(Color.white);
            } else {
                oLabel.setBackground(QueryBoardResetInfoDlg.this.m_oResetInfoTable.getBackground());
                oLabel.setForeground(QueryBoardResetInfoDlg.this.m_oResetInfoTable.getForeground());
            }
            oLabel.setText(value.toString());
            oLabel.setToolTipText(value.toString());
            oLabel.setBorder(null);
            return oLabel;
        }
    }
}

