/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.adapter.swimap.iview.commstyle.resource.DCResourceMng;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import javax.swing.JLabel;

public class HyperLinkLabel
extends JLabel {
    private static final long serialVersionUID = -7584294036367832456L;
    protected final Color LINK_COLOR = Color.blue;
    protected LinkedList<ActionListener> m_oActionListenerList = new LinkedList();
    protected boolean m_bUnderline;
    private int m_iOperationID = -1;
    private int m_iOperationStatus = -1;
    private transient MouseListener m_oMouseListener = null;

    public HyperLinkLabel() {
        this("");
        this.m_oMouseListener = new CustomMouseAdapter();
    }

    public HyperLinkLabel(String strText) {
        super(strText);
        DCFrameWorkUtil.setCursor(this, Cursor.getPredefinedCursor(12));
        this.setForeground(this.LINK_COLOR);
        this.m_oMouseListener = new CustomMouseAdapter();
        this.addMouseListener(this.m_oMouseListener);
    }

    public void addActionListener(ActionListener oListener) {
        if (!this.m_oActionListenerList.contains(oListener)) {
            this.m_oActionListenerList.add(oListener);
        }
    }

    public void removeActionListener(ActionListener oListener) {
        this.m_oActionListenerList.remove(oListener);
    }

    protected void fireActionEvent() {
        ActionEvent oEvent = new ActionEvent(this, 1001, this.getText());
        for (ActionListener oListener : this.m_oActionListenerList) {
            oListener.actionPerformed(oEvent);
        }
    }

    @Override
    public void paint(Graphics oGraphics) {
        super.paint(oGraphics);
        if (this.m_bUnderline) {
            Rectangle2D oTextBounds = this.getFontMetrics(this.getFont()).getStringBounds(this.getText().trim(), oGraphics);
            int y = this.getHeight() / 2 + (int)(oTextBounds.getHeight() / 2.0);
            int w = (int)oTextBounds.getWidth();
            if (this.getText().startsWith("<html>".toLowerCase(DCResourceMng.getInstance().getLocale()))) {
                w -= 126;
            }
            int x = this.getIcon() == null ? 0 : this.getIcon().getIconWidth() + this.getIconTextGap();
            oGraphics.setColor(this.getForeground());
            oGraphics.drawLine(x, y, x + w, y);
        }
    }

    public void setOperationID(int iOprID) {
        this.m_iOperationID = iOprID;
    }

    public int getOperationID() {
        return this.m_iOperationID;
    }

    public int getOperationStatus() {
        return this.m_iOperationStatus;
    }

    public void setOperationStatus(int operationStatus) {
        this.m_iOperationStatus = operationStatus;
    }

    public class CustomMouseAdapter
    extends MouseAdapter {
        @Override
        public void mouseEntered(MouseEvent oMouseEvent) {
            HyperLinkLabel.this.m_bUnderline = true;
            HyperLinkLabel.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent oMouseEvent) {
            HyperLinkLabel.this.m_bUnderline = false;
            HyperLinkLabel.this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent oMouseEvent) {
            HyperLinkLabel.this.fireActionEvent();
        }
    }
}

